% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/assume.R
\name{lock_unique}
\alias{lock_unique}
\title{Assert that columns are unique}
\usage{
lock_unique(.data, ..., .strict = FALSE)
}
\arguments{
\item{.data}{A data frame.}

\item{...}{Column names (unquoted) to check for uniqueness.}

\item{.strict}{If \code{TRUE}, error on failure. If \code{FALSE} (default), warn.}
}
\value{
Invisibly returns \code{.data} (for piping).
}
\description{
Checks that the combination of specified columns has unique values.
This is a point-in-time assertion that either passes silently or fails.
}
\examples{
df <- data.frame(id = 1:3, x = c("a", "b", "c"))
lock_unique(df, id)

# Fails with warning
df2 <- data.frame(id = c(1, 1, 2), x = c("a", "b", "c"))
lock_unique(df2, id)

}
