% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/edit.R
\name{editFeatures}
\alias{editFeatures}
\alias{editFeatures.sf}
\alias{editFeatures.Spatial}
\title{Interactively Edit Map Features}
\usage{
editFeatures(x, ...)

\method{editFeatures}{sf}(
  x,
  map = NULL,
  mergeOrder = c("add", "edit", "delete"),
  record = FALSE,
  viewer = shiny::paneViewer(),
  crs = 4326,
  label = NULL,
  title = "Edit Map",
  editor = "leafpm",
  editorOptions = list(),
  ...
)

\method{editFeatures}{Spatial}(x, ...)
}
\arguments{
\item{x}{features to edit}

\item{...}{other arguments}

\item{map}{a background \code{leaflet} or \code{mapview} map
to be used for editing. If \code{NULL} a blank
mapview canvas will be provided.}

\item{mergeOrder}{\code{vector} or \code{character} arguments to specify the order
of merge operations.  By default, merges will proceed in the order
of add, edit, delete.}

\item{record}{\code{logical} to record all edits for future playback.}

\item{viewer}{\code{function} for the viewer.  See Shiny \code{\link[shiny]{viewer}}.
NOTE: when using \code{browserViewer(browser = getOption("browser"))} to
open the app in the default browser, the browser window will automatically
close when closing the app (by pressing "done" or "cancel") in most browsers.
Firefox is an exception. See Details for instructions on how to enable this
behaviour in Firefox.}

\item{crs}{see \code{\link[sf]{st_crs}}.}

\item{label}{\code{character} vector or \code{formula} for the
content that will appear in label/tooltip.}

\item{title}{\code{string} to customize the title of the UI window.  The default
is "Edit Map".}

\item{editor}{\code{character} currently, only "leafpm" is supported.}

\item{editorOptions}{\code{list} of options suitable for passing to
\code{leafpm::addPmToolbar}.}
}
\description{
Interactively Edit Map Features
}
\details{
When setting \code{viewer = browserViewer(browser = getOption("browser"))} and
the systems default browser is Firefox, the browser window will likely not
automatically close when the app is closed (by pressing "done" or "cancel").
To enable automatic closing of tabs/windows in Firefox try the following:
\itemize{
\item{input "about:config " to your firefox address bar and hit enter}
\item{make sure your "dom.allow_scripts_to_close_windows" is true}
}
}
\examples{
\dontrun{
library(mapedit)
library(mapview)

lf <- mapview()

# draw some polygons that we will select later
drawing <- lf \%>\%
  editMap()

# little easier now with sf
mapview(drawing$finished)

# especially easy with selectFeatures
selectFeatures(drawing$finished)
}
}
