% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/search_bandwidths.R
\name{search_bandwidths}
\alias{search_bandwidths}
\title{Bandwidth Selection via Multi-round Grid Search based on AICc}
\usage{
search_bandwidths(
  formula,
  data,
  coords,
  fixed_vars = NULL,
  kernels = c("gauss", "gauss"),
  Model = "GWR",
  control = list(),
  hs_range = NULL,
  ht_range = NULL,
  n_seq = 10,
  ncore = 1,
  n_rounds = 0,
  refine = TRUE,
  verbose = FALSE,
  show_progress = FALSE,
  tol = NULL,
  parallel_method = "auto"
)
}
\arguments{
\item{formula}{A formula object specifying the model (e.g., \code{y ~ x1 + x2}).}

\item{data}{A data frame containing the variables in the model.}

\item{coords}{A matrix or data frame of coordinates (2 columns for spatial, 1 for temporal, or more for GDT).}

\item{fixed_vars}{A character vector indicating the names of variables with spatially stationary (fixed) coefficients.
Default is \code{NULL} (all coefficients are varying).}

\item{kernels}{A character vector specifying the kernel types for spatial and temporal components
(e.g., \code{c("gauss", "gauss")}).}

\item{Model}{A character string specifying the model type. Options include "GWR", "MGWR", "OLS", "SAR", etc.
Default is "GWR".}

\item{control}{A named list of extra control arguments passed to the \code{MGWRSAR} function
(e.g., \code{adaptive}, \code{NN}, \code{Z}).}

\item{hs_range}{A numeric vector of length 2 defining the lower and upper bounds for the spatial bandwidth search.}

\item{ht_range}{A numeric vector of length 2 defining the lower and upper bounds for the temporal bandwidth search.
Set to \code{NULL} for spatial-only models.}

\item{n_seq}{An integer specifying the number of bandwidth candidates to test per dimension in each round.}

\item{ncore}{An integer specifying the number of CPU cores to use for parallel processing.
Default is \code{parallel::detectCores() - 1}.}

\item{n_rounds}{An integer specifying the number of grid search rounds (zooming steps). Default is 3.}

\item{refine}{Logical. If \code{TRUE}, a final optimization step using golden section search is performed
around the best candidate found. Default is \code{FALSE}.}

\item{verbose}{Logical. If \code{TRUE}, prints progress messages to the console.}

\item{show_progress}{Logical. If \code{TRUE}, displays a progress bar during computation.}

\item{tol}{A numeric vector of length 2 (or 1) specifying the
tolerance for spatial and temporal bandwidths. If \code{NULL}, it
is calculated automatically based on the range.}

\item{parallel_method}{Parallelization method ("auto", "fork", "socket"); "auto" selects the best available backend depending on
the OS, other values run sequentially.}
}
\value{
A list containing:
\item{mode}{The mode of optimization ("spatial_only" or "spatio-temporal").}
\item{results}{A list of data frames containing the results (bandwidths and AICc) for each round.}
\item{best}{A data frame row corresponding to the best parameter combination found.}
\item{refined}{The result of the refinement step (if \code{refine = TRUE}).}
\item{best_model}{The final \code{mgwrsar} model object fitted with the optimal bandwidths.}
\item{ctime}{The total computation time.}
}
\description{
This function selects the optimal bandwidths (spatial and/or temporal) for GWR or MGWR models
by minimizing the Corrected Akaike Information Criterion (AICc). It uses a multi-round
grid search approach (coarse-to-fine) to efficiently narrow down the optimal parameter space
before optionally applying a golden section search for final refinement.
}
\details{
The function performs a grid search over \code{n_rounds}. In the first round, it tests \code{n_seq}
candidates linearly or geometrically spaced within the provided ranges. In subsequent rounds,
the search range is narrowed around the best candidate from the previous round.
}
\seealso{
\code{\link{MGWRSAR}}
}
