% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mulSEM-package.R
\docType{package}
\name{mulSEM-package}
\alias{mulSEM-package}
\alias{mulSEM}
\title{mulSEM: Some Multivariate Analyses using Structural Equation Modeling}
\description{
A set of functions for some multivariate analyses utilizing a structural equation modeling (SEM) approach through the 'OpenMx' package. These analyses include canonical correlation analysis (CANCORR), redundancy analysis (RDA), and multivariate principal component regression (MPCR). It implements procedures discussed in Gu and Cheung (2023) \doi{10.1111/bmsp.12301}, Gu, Yung, and Cheung (2019) \doi{10.1080/00273171.2018.1512847}, and Gu et al. (2023) \doi{10.1080/00273171.2022.2141675}.

A set of functions for some multivariate analyses utilizing a
structural equation modeling (SEM) approach through the 'OpenMx' package.
These analyses include canonical correlation analysis (CANCORR),
redundancy analysis (RDA), and multivariate principal component
regression (MPCR). It implements procedures discussed in
Gu and Cheung (2023) \url{doi:10.1111/bmsp.12301}, Gu, Yung, and Cheung
(2019) \url{doi:10.1080/00273171.2018.1512847}, and Gu et al. (2023)
\url{doi:10.1080/00273171.2022.2141675}.
}
\examples{
\donttest{
## Canonical Correlation Analysis
cancorr(X_vars=c("Weight", "Waist", "Pulse"),
        Y_vars=c("Chins", "Situps", "Jumps"),
        data=sas_ex1)

## Redundancy Analysis
rda(X_vars=c("x1", "x2", "x3", "x4"),
    Y_vars=c("y1", "y2", "y3"),
    data=sas_ex2)

## Multivariate Principal Component Regression
mpcr(X_vars=c("AU", "CC", "CL", "CO", "DF", "FB", "GR", "MW"),
     Y_vars=c("IDE", "IEE", "IOCB", "IPR", "ITS"),
     pca="COR", pc_select=1,
     data=Nimon21)
}

}
\references{
Gu, F., & Cheung, M. W.-L. (2023). A model-based approach to
multivariate principal component regression: Selection of principal
components and standard error estimates for unstandardized regression
coefficients. \emph{British Journal of Mathematical and Statistical
Psychology}, \strong{76(3)}, 605-622. \doi{10.1111/bmsp.12301}

Gu, F., Yung, Y.-F., & Cheung, M. W.-L. (2019). Four covariance
structure models for canonical correlation analysis: A COSAN modeling
approach. \emph{Multivariate Behavioral Research}, \strong{54(2)},
192-223. \doi{10.1080/00273171.2018.1512847}

Gu, F., Yung, Y.-F., Cheung, M. W.-L., Joo, B.-K., & Nimon,
K. (2023). Statistical inference in redundancy analysis: A direct
covariance structure modeling approach. \emph{Multivariate Behavioral
Research}, \strong{58(5)}, 877-893. \doi{10.1080/00273171.2022.2141675}
}
\seealso{
Useful links:
\itemize{
  \item \url{https://github.com/mikewlcheung/mulsem}
  \item Report bugs at \url{https://github.com/mikewlcheung/mulsem/issues}
}

}
\author{
\strong{Maintainer}: Mike Cheung \email{mikewlcheung@nus.edu.sg} (\href{https://orcid.org/0000-0003-0113-0758}{ORCID})

Other contributors:
\itemize{
  \item Fei Gu \email{fgu@vt.edu} (\href{https://orcid.org/0000-0002-1753-8398}{ORCID}) [contributor]
  \item Yiu-Fai Yung \email{Yiu-Fai.Yung@sas.com} [contributor]
}


Mike W.-L. Cheung \href{mailto:mikewlcheung@nus.edu.sg}{mikewlcheung@nus.edu.sg}, Fei Gu \href{mailto:fgu@vt.edu}{fgu@vt.edu},
Yiu-Fai Yung \href{mailto:Yiu-Fai.Yung@sas.com}{Yiu-Fai.Yung@sas.com}
}
\keyword{internal}
