% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data.R
\docType{data}
\name{sas_ex1}
\alias{sas_ex1}
\title{Sample data for canonical correlation analysis from the SAS manual}
\format{
A data frame with 20 rows and 6 variables:
\describe{
\item{Weight}{Weight measurement}
\item{Waist}{Waist measurement}
\item{Pulse}{Pulse measurement}
\item{Chins}{Number of chin-ups}
\item{Situps}{Number of sit-ups}
\item{Jumps}{Number of jumps}
}
}
\source{
\url{https://documentation.sas.com/doc/en/statcdc/14.2/statug/statug_cancorr_example01.htm}
}
\usage{
sas_ex1
}
\description{
This dataset includes six variables of fitness club data from the SAS manual.
}
\examples{
data(sas_ex1)

\donttest{
## Canonical Correlation Analysis
cancorr(X_vars=c("Weight", "Waist", "Pulse"),
        Y_vars=c("Chins", "Situps", "Jumps"),
        data=sas_ex1)
}
}
\keyword{datasets}
