% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/strings.R
\name{nstring}
\alias{nstring}
\title{neat representation of string}
\usage{
nstring(
  text,
  case = NULL,
  remove_specials = FALSE,
  keep_chars = "",
  ascii_only = FALSE,
  string = NULL,
  whitelist_specials = NULL,
  en_only = NULL
)
}
\arguments{
\item{text}{a string / character}

\item{case}{a string, It specifies how the string should be formatted.
Current options are 'lower', 'upper', 'title', 'start' and 'initcap'.}

\item{remove_specials}{a Boolean. If TRUE, special characters are removed
from the string.}

\item{keep_chars}{a vector of characters that are kept even if
remove_specials is TRUE.}

\item{ascii_only}{a Boolean. If TRUE, only ASCII characters are kept.}

\item{string}{Deprecated. Use 'text' instead.}

\item{whitelist_specials}{Deprecated. Use 'keep_chars' instead.}

\item{en_only}{Deprecated. Use 'ascii_only' instead.}
}
\value{
White space cleaned and optionally formatted by case conversion
and removal of special characters of the input string.
}
\description{
neat representation of string
}
\examples{
nstring("   All MOdels are wrong.   some ARE useful!!! ",
  case = "title",
  remove_specials = TRUE
)
nstring("all Models are Wrong some are Useful",
  case = "start",
  remove_specials = TRUE
)
nstring("variable_123!!", remove_specials = TRUE, keep_chars = c("_"))
}
