% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mockPerson.R
\name{mockPerson}
\alias{mockPerson}
\title{Generates a mock person table and integrates it into an existing CDM object.}
\usage{
mockPerson(
  cdm = mockCdmReference(),
  nPerson = 10,
  birthRange = as.Date(c("1950-01-01", "2000-12-31")),
  proportionFemale = 0.5,
  seed = NULL
)
}
\arguments{
\item{cdm}{A \code{cdm_reference} object that serves as the base structure for adding the person table.
This parameter should be an existing or newly created CDM object that does not yet
contain a 'person' table.}

\item{nPerson}{An integer specifying the number of mock persons to create in the person table.
This defines the scale of the simulation and allows for the creation of datasets
with varying sizes.}

\item{birthRange}{A date range within which the birthdays of the mock persons will be randomly generated.
This should be provided as a vector of two dates (\code{as.Date} format), specifying
the start and end of the range.}

\item{proportionFemale}{A numeric value between 0 and 1 indicating the proportion of the persons
who are female. For example, a value of 0.5 means approximately 50\% of
the generated persons will be female. This helps simulate realistic demographic distributions.}

\item{seed}{An optional integer used to set the seed for random number generation, ensuring
reproducibility of the generated data. If provided, this seed allows the function
to produce consistent results each time it is run with the same inputs. If 'NULL',
the seed is not set, which can lead to different outputs on each run.}
}
\value{
A modified \code{cdm} object with the new 'person' table added. This table includes simulated
person data for each generated individual, with unique identifiers and demographic attributes.
}
\description{
This function creates a mock person table with specified characteristics for each individual,
including a randomly assigned date of birth within a given range and gender based on specified
proportions. It populates the CDM object's person table with these entries, ensuring each record
is uniquely identified.
}
\examples{
\donttest{
library(omock)
library(dplyr)
cdm <- mockPerson(cdm = mockCdmReference(), nPerson = 10)

# View the generated person data
cdm$person |>
glimpse()
}

}
