% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/osmapi_changeset_discussion.R
\name{osm_subscribe_changeset_discussion}
\alias{osm_subscribe_changeset_discussion}
\alias{osm_unsubscribe_changeset_discussion}
\title{Subscribe or unsubscribe to a changeset discussion}
\usage{
osm_subscribe_changeset_discussion(changeset_id)

osm_unsubscribe_changeset_discussion(changeset_id)
}
\arguments{
\item{changeset_id}{The id of the changeset represented by a numeric or a character value.}
}
\value{
Returns the changeset information.
}
\description{
Subscribe or unsubscribe to a changeset discussion
}
\section{Functions}{
\itemize{
\item \code{osm_subscribe_changeset_discussion()}: Subscribe to the discussion of a changeset to receive notifications
for new comments.

\item \code{osm_unsubscribe_changeset_discussion()}: Unsubscribe from the discussion of a changeset to stop receiving
notifications.

}}
\examples{
\dontrun{
# set_osmapi_connection(server = "openstreetmap.org")
osm_subscribe_changeset_discussion(137595351)
osm_unsubscribe_changeset_discussion("137595351")
}
}
\seealso{
Other changeset discussion's functions: 
\code{\link{osm_comment_changeset_discussion}()},
\code{\link{osm_hide_comment_changeset_discussion}()},
\code{\link{osm_search_comment_changeset_discussion}()}
}
\concept{changeset discussion's functions}
