% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/osrm_contract.R
\name{osrm_contract}
\alias{osrm_contract}
\title{Contract OSRM Graph for Contraction Hierarchies (CH)}
\usage{
osrm_contract(
  input_osrm,
  threads = 8L,
  verbosity = c("INFO", "NONE", "ERROR", "WARNING", "DEBUG"),
  segment_speed_file = NULL,
  turn_penalty_file = NULL,
  edge_weight_updates_over_factor = 0,
  parse_conditionals_from_now = 0,
  time_zone_file = NULL,
  quiet = FALSE,
  verbose = FALSE,
  spinner = TRUE,
  echo_cmd = FALSE
)
}
\arguments{
\item{input_osrm}{A string. Path to a \code{.osrm.timestamp} file, the base path to the \code{.osrm} files (without extension),
or a directory containing exactly one \code{.osrm.timestamp} file.}

\item{threads}{An integer. Number of threads to use; default \code{8}.}

\item{verbosity}{A string. Log verbosity level passed to \code{-l/--verbosity}
(one of \verb{"NONE","ERROR","WARNING","INFO","DEBUG"}); default \code{"INFO"}.}

\item{segment_speed_file}{A string or \code{NULL}. Path to nodeA,nodeB,speed CSV; default \code{NULL}.}

\item{turn_penalty_file}{A string or \code{NULL}. Path to from_,to_,via_nodes,penalties CSV; default \code{NULL}.}

\item{edge_weight_updates_over_factor}{A numeric. Threshold for logging large weight updates; default \code{0}.}

\item{parse_conditionals_from_now}{A numeric. UTC timestamp for conditional restrictions; default \code{0}.}

\item{time_zone_file}{A string or \code{NULL}. GeoJSON file for time zone boundaries; default \code{NULL}.}

\item{quiet}{A logical. Master switch that suppresses package messages and
process output when \code{TRUE}; default \code{FALSE}.}

\item{verbose}{A logical. When \code{TRUE} and \code{quiet = FALSE}, streams stdout and
stderr from the underlying \code{processx::run} calls.}

\item{spinner}{A logical. When \code{TRUE} and \code{quiet = FALSE}, shows a spinner
instead of live logs; default \code{TRUE}.}

\item{echo_cmd}{A logical. When \code{TRUE} and \code{quiet = FALSE}, prints each
command before running; default \code{FALSE}.}
}
\value{
An object of class \code{osrm_job} with the following elements:
\describe{
\item{osrm_job_artifact}{The path to the contracted \code{.osrm.hsgr} file.}
\item{osrm_working_dir}{The directory containing all OSRM files.}
\item{logs}{The \code{processx::run} result object.}
}
}
\description{
Run the \code{osrm-contract} tool to contract an OSRM graph for the CH pipeline.
After running, a companion \verb{<base>.osrm.hsgr} file must exist to confirm success.
}
\examples{
\donttest{
if (identical(Sys.getenv("OSRM_EXAMPLES"), "true")) {
  install_dir <- osrm_install(
    version = "latest",
    path_action = "session",
    quiet = TRUE
  )

  # Prepare a small graph then contract it for the CH pipeline
  pbf_path <- system.file("extdata/cur.osm.pbf", package = "osrm.backend")
  osrm_dir <- file.path(tempdir(), paste0("osrm-", Sys.getpid()))
  dir.create(osrm_dir, recursive = TRUE)
  tmp_pbf <- file.path(osrm_dir, "cur.osm.pbf")
  file.copy(from = pbf_path, to = tmp_pbf, overwrite = TRUE)
  profile <- osrm_find_profile("car.lua")

  extract_job <- osrm_extract(
    input_osm = tmp_pbf,
    profile = profile,
    overwrite = TRUE,
    threads = 1L
  )

  ch_graph <- osrm_contract(extract_job, threads = 1L, verbose = TRUE)
  ch_graph$osrm_job_artifact

  osrm_uninstall(
    dest_dir = install_dir,
    clear_path = TRUE,
    force = TRUE,
    quiet = TRUE
  )
  unlink(osrm_dir, recursive = TRUE)
}
}

}
