% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gcomp_bayes.R
\name{calc_gcomp_bayes}
\alias{calc_gcomp_bayes}
\title{Bayesian G-computation using Stan}
\usage{
calc_gcomp_bayes(strategy, analysis_params, ...)
}
\arguments{
\item{strategy}{A list specifying the model strategy, including:
\itemize{
\item \code{formula}: A linear regression \code{formula} object.
\item \code{family}: A \code{family} object specifying the distribution and link function
(e.g., \code{binomial}).
\item \code{iter}: Number of iterations for the MCMC sampling.
\item \code{warmup}: Number of warmup iterations for the MCMC sampling.
\item \code{chains}: Number of MCMC chains.
}}

\item{analysis_params}{List of analysis parameters. Must contain \code{ipd} and \code{ald}.}

\item{...}{Additional arguments passed to \code{\link[rstanarm:stan_glm]{rstanarm::stan_glm()}}.}
}
\value{
A list containing:
\itemize{
\item \code{means}: A list containing:
\itemize{
\item \code{A}: Posterior means for comparator treatment group "A".
\item \code{C}: Posterior means for reference treatment group "C".
}
\item \code{model}: A list containing the \code{fit} object (from \code{stan_glm}), \code{rho}, \code{N},
and \code{stan_args}.
}
}
\description{
Calculate draws of binary responses from posterior predictive distribution
from the Bayesian G-computation method using Hamiltonian Monte Carlo.
}
\examples{
strategy <- list(
  formula = y ~ trt:X1,
  family = binomial(),
  rho = NA,
  N = 1000L,
  marginal_distns = NA,
  marginal_params = NA,
  trt_var = "trt",
  iter = 2000,
  warmup = 500,
  chains = 4)

ipd <- data.frame(
   trt = sample(c("A", "C"), size = 100, replace = TRUE),
   X1 = rnorm(100, 1, 1),
   y = sample(c(1,0), size = 100, prob = c(0.7, 0.3), replace = TRUE))

ald <- data.frame(
  trt = c(NA, NA, "B", "C", "B", "C"),
  variable = c("X1", "X1", "y", "y", NA, NA),
  statistic = c("mean", "sd", "sum", "sum", "N", "N"),
  value = c(0.5, 0.1, 10, 12, 20, 25))

calc_gcomp_bayes(
  strategy,
  analysis_params = list(
    ipd = ipd, ald = ald, 
    ref_trt = "C",
    ipd_comp = "A"))

}
