% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pccc-package.R
\docType{package}
\name{pccc-package}
\alias{pccc}
\alias{pccc-package}
\title{pccc: Pediatric Complex Chronic Conditions}
\description{
An implementation of the pediatric complex chronic conditions (CCC)
classification system.  Implemented for the International Classification of
Disease (ICD) 9th and 10th revisions.
}
\section{Reference Material}{

The original paper, Feudtner C, et al. (2014), was publish with open access.
For ease, a copy of the paper is included in this package.  See the examples
below for instructions on opening this pdf from within R or outside of R.
You can view the publication online at
\doi{10.1186/1471-2431-14-199}.

Feudtner et. al. provided a SAS macro and STATA program to implement the CCC.
These files are also provided for reference.  See the Examples for
instructions on opening these files.

Lastly, the appendix tables in the file
\code{system.file("pccc_references", "Categories_of_CCCv2_and_Corresponding_ICD.docx", package = "pccc")}
have also been included with this package.
}

\examples{
\dontrun{
# To open the Feudtner et.al. pdf from within R use the following
if (!is.null(getOption("pdfviewer"))) {
  system(paste0(getOption("pdfviewer"), " ",
                file.path(system.file("pccc_references", package = "pccc")), "/",
                "Feudtner_etal_2014.pdf"))
}

# If the pdf cannot be opened, you should be able to open it manually by
# navagating to
file.path(system.file("pccc_references", package = "pccc"))

# To view the original SAS program
file.show(system.file("pccc_references", "ccc_version2_sas.sas", package = "pccc"))

# To view the original STATA program
file.show(system.file("pccc_references", "ccc.do", package = "pccc"))
}

}
\references{
Feudtner C, et al. Pediatric complex chronic conditions classification system
version 2: updated for ICD-10 and complex medical technology dependence and
transplantation, BMC Pediatrics, 2014, 14:199, DOI: 10.1186/1471-2431-14-199
}
\seealso{
Useful links:
\itemize{
  \item \url{https://github.com/CUD2V/pccc}
  \item Report bugs at \url{https://github.com/CUD2V/pccc/issues}
}

}
\author{
\strong{Maintainer}: Seth Russell \email{seth.russell@cuanschutz.edu} (\href{https://orcid.org/0000-0002-2436-1367}{ORCID})

Authors:
\itemize{
  \item Peter DeWitt \email{dewittpe@gmail.com} (\href{https://orcid.org/0000-0002-6391-0795}{ORCID})
  \item James Feinstein \email{james.feinstein@cuanschutz.edu} (\href{https://orcid.org/0000-0003-3074-8805}{ORCID})
}

Other contributors:
\itemize{
  \item Tell Bennett \email{tell.bennett@cuanschutz.edu} (\href{https://orcid.org/0000-0003-1483-4236}{ORCID}) [contributor]
}

}
\keyword{internal}
