% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/allele_cluster.R
\name{igClust}
\alias{igClust}
\title{Allele similarity clustering}
\usage{
igClust(
  germline_distance,
  method = c("hierarchical", "leiden"),
  family_threshold = 75,
  allele_cluster_threshold = 95,
  cluster_method = "complete",
  resolution = NULL,
  target_clusters = NULL,
  optimize_silhouette = TRUE,
  ncores = 1,
  quiet = FALSE
)
}
\arguments{
\item{germline_distance}{A germline set distance matrix created by \code{\link{igDistance}}.}

\item{method}{Clustering method. One of "hierarchical" (default) or "leiden".}

\item{family_threshold}{The similarity threshold for family level (hierarchical only). Default is 75.}

\item{allele_cluster_threshold}{The similarity threshold for allele cluster level (hierarchical only). Default is 95.}

\item{cluster_method}{The hierarchical clustering linkage method. Default is "complete".}

\item{resolution}{Resolution parameter for Leiden clustering. If NULL, will be optimized.}

\item{target_clusters}{Target number of clusters for Leiden optimization. Default is NULL.}

\item{optimize_silhouette}{Logical. Optimize resolution using silhouette score (Leiden only). Default is TRUE.}

\item{ncores}{Number of cores for parallel processing (Leiden only). Default is 1.}

\item{quiet}{Logical. Suppress messages. Default is FALSE.}
}
\value{
A named list that includes:
\itemize{
\item \code{alleleClusterTable}: data.frame of allele clusters
\item \code{threshold}: list of threshold parameters
\item \code{hclustAlleleCluster}: hierarchical clustering object (hierarchical method)
\item \code{communityObject}: community detection result (Leiden method)
\item \code{graphObject}: igraph object (Leiden method)
\item \code{silhouetteScore}: silhouette score (Leiden method)
\item \code{resolutionParameter}: resolution used (Leiden method)
}
}
\description{
Cluster the distance matrix to create allele clusters. Supports both
hierarchical clustering (default) and Leiden community detection.
}
\seealso{
\code{\link{igDistance}}, \code{\link{inferAlleleClusters}}
}
