% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pixr-package.R
\docType{package}
\name{pixr-package}
\alias{pixr-package}
\alias{pixr}
\title{pixr: Access Brazilian Central Bank PIX Open Data API}
\description{
The pixr package provides a tidyverse-style interface to the Brazilian
Central Bank (BCB) PIX Open Data API. It allows you to retrieve statistics
on PIX keys, transactions by municipality, transaction breakdowns, and
fraud statistics.
}
\section{Main Functions}{

\itemize{
\item \code{\link[=get_pix_keys]{get_pix_keys()}}: Retrieve PIX keys stock by participant
\item \code{\link[=get_pix_transactions_by_municipality]{get_pix_transactions_by_municipality()}}: Get PIX transactions by municipality
\item \code{\link[=get_pix_transaction_stats]{get_pix_transaction_stats()}}: Get detailed PIX transaction statistics
\item \code{\link[=get_pix_fraud_stats]{get_pix_fraud_stats()}}: Get fraud statistics (MED)
}
}

\section{API Endpoints}{


The package provides access to 4 endpoints, each with different parameters:\tabular{lll}{
   Endpoint \tab Parameter \tab Format \cr
   ChavesPix \tab Data \tab YYYY-MM-DD \cr
   TransacoesPixPorMunicipio \tab DataBase \tab YYYYMM \cr
   EstatisticasTransacoesPix \tab Database \tab YYYYMM \cr
   EstatisticasFraudesPix \tab Database \tab YYYYMM \cr
}
}

\section{API Information}{


The PIX Open Data API is provided by the Brazilian Central Bank (Banco Central
do Brasil - BCB) through the Olinda platform. The API follows the OData protocol
and provides data in JSON, XML, CSV, or HTML formats.

Base URL: \verb{https://olinda.bcb.gov.br/olinda/servico/Pix_DadosAbertos/versao/v1/odata/}
}

\section{Package Options}{


The following options can be set to customize package behavior:

\describe{
\item{pixr.timeout}{Request timeout in seconds. Default is 120 seconds.
The BCB API can be slow for large queries, so a generous timeout is
recommended. Example: \code{options(pixr.timeout = 180)} for 3 minutes.}
}
}

\section{Timeout Configuration}{


The default timeout for API requests is 120 seconds. This can be changed
using:

\if{html}{\out{<div class="sourceCode">}}\preformatted{# Using the helper function
pix_timeout(180)  # Set timeout to 3 minutes

# Or via options
options(pixr.timeout = 180)

# Check current timeout
pix_timeout()
}\if{html}{\out{</div>}}
}

\seealso{
Useful links:
\itemize{
  \item \url{https://github.com/StrategicProjects/pixr}
  \item Report bugs at \url{https://github.com/StrategicProjects/pixr/issues}
}

}
\author{
\strong{Maintainer}: Andre Leite \email{leite@castlab.org}

Authors:
\itemize{
  \item Marcos Wasilew \email{marcos.wasilew@gmail.com}
  \item Hugo Vasconcelos \email{hugo.vasconcelos@ufpe.br}
  \item Diogo Bezerra \email{diogo.bezerra@ufpe.br}
}

}
\keyword{internal}
