% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/intrinsic_growth_rate.R
\name{.intrinsic_growth_rate}
\alias{.intrinsic_growth_rate}
\title{Calculate Intrinsic Growth Rate}
\usage{
.intrinsic_growth_rate(mx, Lx, age_mid)
}
\arguments{
\item{mx}{Age specific fertility rates,
for a single sex (typically daughters).
An ordinary numeric vector or an \link[rvec:rvec]{rvec()}.}

\item{Lx}{Life table mortality measure,
for a single sex (typically females).
An ordinary numeric vector or an \link[rvec:rvec]{rvec()}.}

\item{age_mid}{The midpoint of each age group.
Numeric vector.}
}
\value{
A numeric vector of length 1.
}
\description{
Calculate the intrinsic growth rate implied
by fertility and mortality schedules. The
intrinsic growth rate is the rate at which
all age groups in a population would eventually
grow if the population was subject to the fertility
and mortality schedules indefinitely. The fertility
and mortality schedules apply to a single sex,
typically females.
}
\details{
The fertility scehdule \code{mx} and mortality schedule
\code{Lx} refer only to the reproductive ages. The
mortality schedule \code{Lx} is the number of years that
a newborn baby would be expected to spend in each
age group under prevailing mortality rates. It is
the life table quantity \code{nLx} where the radix
\code{l0} has been set to 1.
}
\examples{
mx <- c(0.072, 0.148, 0.156, 0.140, 0.108, 0.054, 0.013)
Lx <- c(3.49, 3.37, 3.23, 3.07, 2.91, 2.74, 2.56)
age_mid <- c(17.5, 22.5, 27.5, 32.5, 37.5, 42.5, 47.5)
.intrinsic_growth_rate(mx = mx, Lx = Lx, age_mid = age_mid)
}
