% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/result_helpers.R
\name{extract_trt_effects}
\alias{extract_trt_effects}
\title{Extract Treatment Effect Estimates}
\usage{
extract_trt_effects(results, visit = NULL)
}
\arguments{
\item{results}{A tibble from \code{\link[=tidy_pool_obj]{tidy_pool_obj()}}.}

\item{visit}{Optional character vector of visits to filter. If NULL (default),
returns results for all visits.}
}
\value{
A tibble containing only treatment effect rows.
}
\description{
Convenience function to extract only treatment comparison estimates from
tidy results, filtering out least squares means.
}
\examples{
\donttest{
library(rbmi)

# Assuming you have a tidy result
# tidy_result <- tidy_pool_obj(pool_obj)
# trt_effects <- extract_trt_effects(tidy_result)
# trt_week24 <- extract_trt_effects(tidy_result, visit = "Week 24")
}

}
\seealso{
\itemize{
\item \code{\link[=tidy_pool_obj]{tidy_pool_obj()}} to create tidy results
\item \code{\link[=extract_lsm]{extract_lsm()}} to extract least squares means
}
}
