% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/x13.R
\name{refresh}
\alias{refresh}
\alias{regarima_refresh}
\alias{x13_refresh}
\title{Refresh a specification with constraints}
\usage{
regarima_refresh(
  spec,
  refspec = NULL,
  policy = c("FreeParameters", "Complete", "Outliers_StochasticComponent", "Outliers",
    "FixedParameters", "FixedAutoRegressiveParameters", "Fixed", "Current"),
  period = 0,
  start = NULL,
  end = NULL
)

x13_refresh(
  spec,
  refspec = NULL,
  policy = c("FreeParameters", "Complete", "Outliers_StochasticComponent", "Outliers",
    "FixedParameters", "FixedAutoRegressiveParameters", "Fixed", "Current"),
  period = 0,
  start = NULL,
  end = NULL
)
}
\arguments{
\item{spec}{the current specification to be refreshed (\code{"result_spec"}).}

\item{refspec}{the reference specification used to define the domain
considered for re-estimation (\code{"domain_spec"}).
By default this is the \code{"RG5c"} or \code{"RSA5"} specification.}

\item{policy}{the refresh policy to apply (see details).}

\item{period, start, end}{additional parameters used to specify the span on
which additive outliers (AO) are introduced when \code{policy = "Current"} or to
specify the span on which outliers will be re-detected when
\code{policy = "Outliers"} or \code{policy = "Outliers_StochasticComponent"}, is this
case \code{end} is unused.
If \code{start} is not specified, outliers will be re-identified on the whole
series.
Span definition: \code{period}: numeric, number of observations in a year
(12, 4...).
\code{start} and \code{end}: defined as arrays of two elements: year and
first period (for example, \code{period = 12} and \code{c(1980, 1)} stands for January
1980)
The dates corresponding \code{start} and \code{end} are included in the span
definition.}
}
\value{
a new specification, an object of class \code{"JD3_X13_SPEC"} or
\code{"JD3_REGARIMA_SPEC"}.
}
\description{
Functions \code{x13_refresh} and \code{regarima_refresh} allow to create a new
specification by updating a specification used for a previous estimation.
Some selected parameters will be kept fixed (previous estimation results)
while others will be freed for re-estimation in a domain of constraints.
See details and examples.
}
\details{
The selection of constraints to be kept fixed or re-estimated is called a
revision policy. User-defined parameters are always copied to the new
refreshed specifications. In X-13 only the reg-arima part can be refreshed.
X-11 decomposition will be completely re-run, keeping all the user-defined
parameters from the original specification.

Available refresh policies are:
\enumerate{
\item \strong{Current}: applying the current pre-adjustment reg-arima model
and handling the new raw data points, or any sub-span of the series as
Additive Outliers (defined as new intervention variables);
\item \strong{Fixed}: applying the current pre-adjustment reg-arima model
and replacing forecasts by new raw data points;
\item \strong{FixedParameters}: pre-adjustment reg-arima model is partially
modified: regression coefficients will be re-estimated but regression
variables, Arima orders and coefficients are unchanged;
\item \strong{FixedAutoRegressiveParameters}: same as FixedParameters but
Arima Moving Average coefficients (MA) are also re-estimated, Auto-regressive
(AR) coefficients are kept fixed;
\item \strong{FreeParameters}: all regression and Arima model coefficients
are re-estimated, regression variables and Arima orders are kept fixed;
\item \strong{Outliers}: regression variables and Arima orders are kept
fixed, but outliers will be re-detected on the defined span, thus all
regression and Arima model coefficients are re-estimated;
\item \strong{Outliers_StochasticComponent}: same as "Outliers" but Arima
model orders (p,d,q)(P,D,Q) can also be re-identified;
\item \strong{Complete}: All the parameters are re-identified and
re-estimated, unless constrained in the domain spec.
}
}
\examples{
\dontshow{if (current_java_version >= minimal_java_version) withAutoprint(\{ # examplesIf}
\donttest{
y <- rjd3toolkit::ABS$X0.2.08.10.M

# raw series for first estimation
y_raw <- window(y, end = c(2016, 12))

# raw series for second (refreshed) estimation
y_new <- window(y, end = c(2017, 6))

# specification for first estimation
spec_x13_1 <- x13_spec("rsa5c")

# first estimation
sa_x13 <- x13(y_raw, spec_x13_1)

# refreshing the specification
current_result_spec <- sa_x13$result_spec
current_domain_spec <- sa_x13$estimation_spec

# policy = "Fixed"
spec_x13_ref <- x13_refresh(current_result_spec, # point spec to be refreshed
    current_domain_spec, # domain spec (set of constraints)
    policy = "Fixed"
)
# 2nd estimation with refreshed specification
sa_x13_ref <- x13(y_new, spec_x13_ref)

# policy = "Outliers"
spec_x13_ref <- x13_refresh(current_result_spec,
    current_domain_spec,
    policy = "Outliers",
    period = 12,
    start = c(2017, 1)
) # outliers will be re-detected from January 2017 included
# 2nd estimation with refreshed specification
sa_x13_ref <- x13(y_new, spec_x13_ref)

# policy = "Current"
spec_x13_ref <- x13_refresh(current_result_spec,
    current_domain_spec,
    policy = "Current",
    period = 12,
    start = c(2017, 1),
    end = end(y_new)
)

# Points from January 2017 (included) until the end of the series will be
# treated as Additive Outliers, the previous reg-Arima model being otherwise
# kept fixed 2nd estimation with refreshed specification
sa_x13_ref <- x13(y_new, spec_x13_ref)

# Same procedure using regarima_refresh
# specification for first estimation
spec_1 <- regarima_spec("rg3")

# First estimation
reg_a_model <- regarima(y_raw, spec_1)
reg_a_model$estimation_spec

# Refreshing the specification
current_result_spec <- reg_a_model$result_spec
current_domain_spec <- reg_a_model$estimation_spec

# Policy = "Fixed"
spec_1_ref <- regarima_refresh(
    current_result_spec, # point spec to be refreshed
    current_domain_spec, # domain spec (set of constraints)
    policy = "Fixed"
)
# 2nd estimation with refreshed specification
reg_a_model_ref <- regarima(y_new, spec_1_ref)
}
\dontshow{\}) # examplesIf}
}
\references{
More information on revision policies in JDemetra+ online documentation:
\url{https://jdemetra-new-documentation.netlify.app/a-rev-policies}
}
