% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data_classes.R
\name{create_tidy_omic}
\alias{create_tidy_omic}
\title{Create Tidy Omic}
\usage{
create_tidy_omic(
  df,
  feature_pk,
  feature_vars = NULL,
  sample_pk,
  sample_vars = NULL,
  omic_type_tag = "general",
  verbose = TRUE
)
}
\arguments{
\item{df}{a data.frame (or tibble) containing some combination of feature,
sample and observation-level variables}

\item{feature_pk}{A unique identifier for features}

\item{feature_vars}{a character vector of additional feature-level
variables (or NULL if there are no additional variables)}

\item{sample_pk}{A unique identifier for samples}

\item{sample_vars}{a character vector of additional sample-level variables
(or NULL if there are no additional variables)}

\item{omic_type_tag}{an optional subtype of omic data: metabolomics,
lipidomics, proteomics, genomics, general}

\item{verbose}{extra reporting messages}
}
\value{
An S3 \code{tidy_omic}/\code{tomic} object built on a \code{list}:
 \describe{
   \item{data}{A tibble with one row per measurement (i.e., features x
     samples)}
   \item{design}{A list which organized the dataset's meta-data:
     \describe{
       \item{feature_pk}{variable specifying a unique feature}
       \item{sample_pk}{variable specifying a unique sample}
       \item{features}{tibble of feature attributes}
       \item{samples}{tibble of sample attributes}
       \item{measurements}{tibble of measurement attributes}
     }
   }
 }
}
\description{
A tidy omics object contains a formatted dataset and a summary of the
  experimental design.
}
\examples{

library(dplyr)

measurement_df <- tidyr::expand_grid(
  feature_id = 1:10,
  sample_id = LETTERS[1:5]
) \%>\%
  dplyr::mutate(value = rnorm(n()))

feature_df <- tibble(
  feature_id = 1:10,
  feature_group = rep(c("a", "b"), each = 5)
)
sample_df <- tibble(
  sample_id = LETTERS[1:5],
  sample_group = c("a", "a", "b", "b", "b")
)

triple_omic <- create_triple_omic(
  measurement_df, feature_df, sample_df,
  "feature_id", "sample_id"
)
raw_tidy_omic <- triple_to_tidy(triple_omic)$data

create_tidy_omic(raw_tidy_omic,
  feature_pk = "feature_id",
  feature_vars = "feature_group", sample_pk = "sample_id",
  sample_vars = "sample_group"
)
}
