% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data_classes.R
\name{reform_tidy_omic}
\alias{reform_tidy_omic}
\title{Reform Tidy Omic}
\usage{
reform_tidy_omic(tidy_data, tomic_design)
}
\arguments{
\item{tidy_data}{A tibble containing measurements along with sample metadata. This
table can be obtained as the "data" attribute from a romic "tidy_omic" object.}

\item{tomic_design}{a list with named attributes describing feature,
sample, and measurement variables.}
}
\description{
This function recreates a `tidy_omic` object from the "data" and "design"
attributes of this object.
}
\details{
This is handy for passing data and metadata through approaches like parsnip
which expect data to be formatted as a data.frame
}
\examples{
tidy_data <- romic::brauer_2008_tidy$data
reform_tidy_omic(tidy_data, romic::brauer_2008_tidy$design)

}
