% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_spatial_list.R
\name{CreateSpatialList}
\alias{CreateSpatialList}
\title{Get Spatial Files from a \code{SpatSimObj}}
\usage{
CreateSpatialList(sim_object, single_df = FALSE, multihit_action = "random")
}
\arguments{
\item{sim_object}{A \code{SpatSimObj}}

\item{single_df}{boolean as to whether to collapse the output list of data frames to a single data frame or not. default is \code{FALSE}}

\item{multihit_action}{string of value 'random', 'drop', or 'keep' for cells that are positive for multiple cell assignments}
}
\value{
A list of data frames, one for each simulated cell type, with cleaned columns
}
\description{
This function extracts the 'Spatial Files' slot from a Spatial Simulation Object
and removes probability columns while converting 'Positive' and 'Negative' in
cell assignment columns to 1 and 0, respectively.
}
\details{
The output of this function creates a list of the spatial files formatted in a way
that would allow direct import into a mIF object from the package 'spatialTIME'
}
