% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/make_paired_t_test_table.R
\name{make_paired_t_test_table}
\alias{make_paired_t_test_table}
\title{Create a one-row summary table of a paired t-test}
\usage{
make_paired_t_test_table(
  data,
  var1,
  var2,
  var_name = NULL,
  alternative = "two.sided",
  conf.level = 0.95
)
}
\arguments{
\item{data}{A data frame containing the two numeric variables.}

\item{var1}{Character string. Name of the first variable (observation 1) in \code{data}.}

\item{var2}{Character string. Name of the second variable (observation 2) in \code{data}.}

\item{var_name}{Optional character string. Custom name for the variable to display in the table. Default is \verb{var1 vs var2}.}

\item{alternative}{Character string specifying the alternative hypothesis. One of \code{"two.sided"}, \code{"less"}, or \code{"greater"}. Default is \code{"two.sided"}.}

\item{conf.level}{Confidence level for the interval. Default is 0.95.}
}
\value{
A one-row data frame with columns:
\itemize{
\item \code{Variable} - variable name
\item \code{Mean_obs1} - mean of observation 1
\item \code{Mean_obs2} - mean of observation 2
\item \code{Mean_diff} - mean difference (obs1 - obs2)
\item \code{t_value} - t statistic
\item \code{df} - degrees of freedom
\item \code{p_value} - p-value
\item \code{CI_lower} - lower bound of confidence interval
\item \code{CI_upper} - upper bound of confidence interval
}
}
\description{
This function performs a paired t-test between two numeric variables in a data frame
and returns a one-row summary table including means, mean difference, t-value, degrees of freedom,
p-value, and confidence interval.
}
\examples{
# example data
df <- data.frame(
  before = c(10, 12, 14, 15, 11),
  after  = c(11, 13, 13, 16, 12)
)

# Run the paired t-test summary
make_paired_t_test_table(df, var1 = "before", var2 = "after")
}
