% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/kernelEstimator.R
\name{fit_strategy_final}
\alias{fit_strategy_final}
\title{Fit locfit with Multiple Fallback Strategies}
\usage{
fit_strategy_final(
  data,
  valid_data,
  nn_high,
  nn_safe,
  maxit,
  maxk,
  verbose = TRUE,
  ...
)
}
\arguments{
\item{data}{Data frame with columns V1, V2, and w (weights).}

\item{valid_data}{Subset of data used for validation (typically signal-rich region).}

\item{nn_high}{First (higher resolution) nn value to try.}

\item{nn_safe}{Second (safer, more conservative) nn value.}

\item{maxit}{Maximum iterations for locfit.}

\item{maxk}{Maximum number of fitting points for locfit.}

\item{verbose}{Logical; print progress messages.}

\item{...}{Additional arguments passed to lp() in locfit.}
}
\value{
A fitted locfit object, or NULL if all strategies fail.
}
\description{
Internal helper function that attempts to fit a locfit model using multiple
strategies with different kernels, degrees, and smoothing parameters.
}
\keyword{internal}
