% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/slope_fun.R
\name{slope_fun}
\alias{slope_fun}
\title{Compute the linear slope of a numeric sequence}
\usage{
slope_fun(x)
}
\arguments{
\item{x}{Numeric vector.}
}
\value{
A numeric scalar giving the slope of the fitted linear trend.
}
\description{
Computes the slope of a simple linear regression of a numeric vector
against its index (\code{seq_along(x)}). Non-finite (\code{NA}, \code{NaN}, \code{Inf}) values
are removed prior to computation. If fewer than two finite values remain,
the function returns \code{0}.
}
\details{
The slope is estimated from the model
\eqn{x_i = \beta_0 + \beta_1 i + \varepsilon_i},
where \eqn{i = 1, \dots, n}. The function returns the estimated slope
\eqn{\beta_1}.

This summary is useful for characterizing monotonic trends in ordered
risk values along a path.
}
\examples{
slope_fun(c(1, 2, 3, 4))
slope_fun(c(4, 3, 2, 1))
slope_fun(c(NA, 1, 2, Inf, 3))

}
