% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_density.R
\name{plot_density}
\alias{plot_density}
\title{Plot density of a variable, optionally by another variable}
\usage{
plot_density(formula, data = NULL, show_means = TRUE, ...)
}
\arguments{
\item{formula}{Either the single variable name \code{y} or a formula like \code{y ~ x}.}

\item{data}{An optional data frame containing the variables in the formula.}

\item{show_means}{Logical. If TRUE (default), shows points at means.}

\item{...}{Additional arguments passed to plotting functions.}
}
\value{
Invisibly returns a list with the following element:
  \describe{
    \item{densities}{A named list of density objects (class \code{"density"}), 
      one for each group. Each density object contains \code{x} (evaluation points), 
      \code{y} (density estimates), \code{bw} (bandwidth), and other components 
      as returned by \code{\link[stats]{density}}. If no grouping variable is 
      provided, the list contains a single element named \code{"all"}.}
  }
  The function is primarily called for its side effect of creating a plot.
}
\description{
Plots the distribution of a variable by group, simply: \code{plot_density(y ~ x)}
}
\details{
Plot parameters like
\code{col}, \code{lwd}, \code{lty}, and \code{pch} can be specified as:
\itemize{
  \item A single value: applied to all groups
  \item A vector: applied to groups in order of unique \code{group} values
}
}
\examples{
# Basic usage with formula syntax (no grouping)
y <- rnorm(100)
plot_density(y)

# With grouping variable
group <- rep(c("A", "B", "C"), c(30, 40, 30))
plot_density(y ~ group)

# With custom colors (scalar - same for all)
plot_density(y ~ group, col = "blue")

# With custom colors (vector - different for each group)
plot_density(y ~ group, col = c("red", "green", "blue"))

# Multiple parameters
plot_density(y ~ group, col = c("red", "green", "blue"), lwd = c(1, 2, 3))

# With line type
plot_density(y ~ group, col = c("red", "green", "blue"), lty = c(1, 2, 3), lwd = 2)

# Using data frame
df <- data.frame(value = rnorm(100), group = rep(c("A", "B"), 50))
plot_density(value ~ group, data = df)
plot_density(value ~ group, data = df, col = c("red", "blue"))

}
