#' @export
as.sign_name <- function(x, ...) {
  UseMethod("as.sign_name")
}

#' @export
as.sign_name.default <- function(x, ...) {
  stop("Cannot coerce to cuneiform names")
}

#' @export
as.sign_name.character <- function(x, mapping = NULL, ...) {
  if(is.null(mapping)){
    path    <- system.file("extdata", "etcsl_mapping.txt", package = "sumer")
    mapping <- read.csv2(path, sep=";", na.strings="")
  }
  result <- rep("", length(x))

  for(i in 1: length(x)){
    if(x[i]==""){next}
    this_info  <- info(x[i], mapping=mapping)
    separators <- attr(this_info, "separators")
    names      <- this_info$name

    sign_name_text <- paste0(c("",names), separators, collapse="")
    sign_name_text <- str_replace_all(sign_name_text, "-", ".")

    result[i] <- sign_name_text
  }

  class(result) <- c("sign_name", "character")

  return(result)
}

#' @exportS3Method print sign_name
print.sign_name <- function(x, ...){
  cat(x, sep="\n")
}
