% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils-textnets.R
\name{doc_centrality}
\alias{doc_centrality}
\title{Find a specified document centrality metric}
\usage{
doc_centrality(mat, method, alpha = 1L, two_mode = TRUE)
}
\arguments{
\item{mat}{Document-term matrix with terms as columns or a
document-similarity matrix with documents as rows and columns.}

\item{method}{Character vector indicating centrality method, including
"degree", "eigen", "span", and "between".}

\item{alpha}{Number (default = 1) indicating the tuning parameter for
weighted metrics.}

\item{two_mode}{Logical (default = TRUE), indicating whether the input matrix
is two mode (i.e. a document-term matrix) or one-mode
(i.e. document-similarity matrix)}
}
\value{
A dataframe with two columns
}
\description{
Given a document-term matrix or a document-similarity matrix,
this function returns specified text network-based centrality measures.
Currently, this includes degree, eigenvector, betweenness, and
spanning.
}
\details{
If a document-term matrix is provided, the function obtains the one-mode
document-level projection to get the document-similarity matrix using
\code{tcrossprod()}. If a one-mode document-similarity matrix is provided, then
this step is skipped. This way document similiarities may be obtained
using other methods, such as Word-Mover's Distance (see \code{doc_similarity}).
The diagonal is ignored in all calculations.

Document centrality methods include:
\itemize{
\item degree: Opsahl's weighted degree centrality with tuning parameter "alpha"
\item between: vertex betweenness centrality using Brandes' method
\item eigen: eigenvector centrality using Freeman's method
\item span: Modified Burt's constraint following Stoltz and Taylor's method,
uses a tuning parameter "alpha" and the output is scaled.
}
}
\examples{

# load example text
data(jfk_speech)

# minimal preprocessing
jfk_speech$sentence <- tolower(jfk_speech$sentence)
jfk_speech$sentence <- gsub("[[:punct:]]+", " ", jfk_speech$sentence)

# create DTM
dtm <- dtm_builder(jfk_speech, sentence, sentence_id)

ddeg <- doc_centrality(dtm, method = "degree")
deig <- doc_centrality(dtm, method = "eigen")
dbet <- doc_centrality(dtm, method = "between")
dspa <- doc_centrality(dtm, method = "span")

# with a document-similarity matrix (dsm)

dsm <- doc_similarity(dtm, method = "cosine")
ddeg <- doc_centrality(dsm, method = "degree", two_mode = FALSE)

}
\references{
Brandes, Ulrik
(2000) 'A faster algorithm for betweenness centrality'
\emph{Journal of Mathematical Sociology}. 25(2):163-177
\doi{10.1080/0022250X.2001.9990249}.\cr
Opsahl, Tore, et al.
(2010) 'Node centrality in weighted networks: Generalizing degree
and shortest paths.' \emph{Social Networks}. 32(3)245:251
\doi{10.1016/j.socnet.2010.03.006}\cr
Stoltz, Dustin; Taylor, Marshall
(2019) 'Textual Spanning: Finding Discursive Holes in Text Networks'
\emph{Socius}. \doi{10.1177/2378023119827674}\cr
}
\author{
Dustin Stoltz
}
