% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rename_alleles.R
\name{rename_alleles}
\alias{rename_alleles}
\title{Rename alleles in a dataframe based on reference alleles}
\usage{
rename_alleles(df_alleles, ref_alleles, replacements = FALSE)
}
\arguments{
\item{df_alleles}{Dataframe with at least the following columns:
'allele' 'sequence'.}

\item{ref_alleles}{Dataframe with at least the same columns as 'df_alleles',
or path multifasta FASTA with allele names in fasta headers.}

\item{replacements}{T/F, if TRUE, a dataframe with the replacements
correspondence is returned.
Optionally, a path to a multifasta with fasta headers being allele names.}
}
\value{
Dataframe as 'df_alleles' with renamed alleles as in 'ref_alleles'.
}
\description{
Rename alleles in a dataframe based on reference alleles
}
\examples{
data("genotypes")
ref_al <-
    system.file("extdata/reference_alleles.fasta", package = "tidyGenR")
rename_alleles(df_alleles = genotypes, ref_alleles = ref_al)
}
