% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/variant_seq2len.R
\name{var_seq2len}
\alias{var_seq2len}
\title{Convert sequence-based variants to length-based}
\usage{
var_seq2len(variants)
}
\arguments{
\item{variants}{Dataframe with tidy variants.}
}
\value{
Dataframe with length-based variants and the variables:
'locus' 'sample' 'variant' 'reads'.
}
\description{
Convert sequence-based variants to length-based
}
\details{
Recodes dataframe with sequence-based variants, such as the output
from 'variant_call' to
length-based variants. The sequence length 'nt', instead of the nucleotide
sequence, is used for determining variants.
Each variant is named after its number of nucleotides.
Number of reads from previous variants with equal lengths are aggreated.
Legacy for microsatellite data.
}
\examples{
data("variants")
var_seq2len(variants)
}
