% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/aaa_generics.R, R/class-seg_cpt.R,
%   R/pkg-GA.R, R/pkg-changepoint.R, R/pkg-changepointGA.R, R/pkg-segmented.R,
%   R/pkg-strucchange.R, R/pkg-wbs.R
\name{model_args}
\alias{model_args}
\alias{model_args.default}
\alias{model_args.seg_cpt}
\alias{model_args.ga}
\alias{model_args.cpt}
\alias{model_args.cptga}
\alias{model_args.lm}
\alias{model_args.breakpointsfull}
\alias{model_args.wbs}
\title{Retrieve the arguments that a model-fitting function used}
\usage{
model_args(object, ...)

\method{model_args}{default}(object, ...)

\method{model_args}{seg_cpt}(object, ...)

\method{model_args}{ga}(object, ...)

\method{model_args}{cpt}(object, ...)

\method{model_args}{cptga}(object, ...)

\method{model_args}{lm}(object, ...)

\method{model_args}{breakpointsfull}(object, ...)

\method{model_args}{wbs}(object, ...)
}
\arguments{
\item{object}{A \code{segmenter} object.}

\item{...}{currently ignored}
}
\value{
A named \code{list} of arguments, or \code{NULL}
}
\description{
Retrieve the arguments that a model-fitting function used
}
\details{
Every model is fit by a model-fitting function, and these functions sometimes
take arguments.
\code{\link[=model_args]{model_args()}} recovers the arguments that were passed to
the model fitting function when it was called.
These are especially
important when using a genetic algorithm.
}
\examples{
# Segment a time series using Coen's algorithm
x <- segment(CET, method = "ga-coen", maxiter = 3)

# Recover the arguments passed to the model-fitting function
x |>
  as.segmenter() |>
  model_args()
  
}
\seealso{
Other model-fitting: 
\code{\link{fit_arima}()},
\code{\link{fit_lmshift}()},
\code{\link{fit_meanshift}()},
\code{\link{fit_meanvar}()},
\code{\link{fit_nhpp}()},
\code{\link{model_name}()},
\code{\link{new_fun_cpt}()},
\code{\link{whomademe}()}

Other segmenter-functions: 
\code{\link{as.segmenter}()},
\code{\link{fitness}()},
\code{\link{seg_params}()}
}
\concept{model-fitting}
\concept{segmenter-functions}
