% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pull_write.R
\name{batch_export_laslogs}
\alias{batch_export_laslogs}
\title{Index, filter, pull, and export LAS logs in one call}
\usage{
batch_export_laslogs(
  dir,
  out_dir,
  county = NULL,
  curves_any = NULL,
  curves_all = NULL,
  curves = NULL,
  output = c("wide", "long"),
  prefix = NULL,
  csv = TRUE,
  parquet = TRUE,
  write_index = TRUE,
  index_prefix = NULL
)
}
\arguments{
\item{dir}{Folder containing .las files}

\item{out_dir}{Output directory (absolute path, or relative to dir)}

\item{county}{Optional county filter (character vector)}

\item{curves_any}{Optional: keep wells with at least one of these curves}

\item{curves_all}{Optional: keep wells with all of these curves}

\item{curves}{Optional: curves to actually export (defaults to curves_all, else curves_any, else NULL=all)}

\item{output}{"wide" or "long"}

\item{prefix}{Optional file prefix. If NULL, an informative prefix is built.}

\item{csv}{Write CSV?}

\item{parquet}{Write Parquet?}

\item{write_index}{If TRUE, also export wells_index/curves_index/files_index tables}

\item{index_prefix}{Optional prefix for index files (defaults to \code{prefix__index})}
}
\value{
Invisibly returns a list with index, apis, data, output paths, and manifest
}
\description{
Index, filter, pull, and export LAS logs in one call
}
\examples{
td <- tempdir()
f <- file.path(td, "a.las")

las_text <- c(
  " ~Version Information",
  " VERS. 2.0:",
  " WRAP. NO:",
  " ~Well Information",
  " STRT.M 1000:",
  " STOP.M 1001:",
  " STEP.M 1:",
  " NULL. -999.25:",
  " API . 1111111111:",
  " CNTY. TEST:",
  " ~Curve Information",
  " DEPT.M:",
  " GR.API:",
  " ~ASCII Log Data",
  " 1000 80",
  " 1001 82"
)

writeLines(las_text, f)

res <- batch_export_laslogs(
  dir = td,
  out_dir = file.path(td, "exports"),
  county = "TEST",
  curves_any = "GR",
  output = "wide",
  csv = TRUE,
  parquet = FALSE,
  write_index = TRUE
)
names(res)
}
