% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/matrix_ops.R
\name{matrix_ops}
\alias{matrix_ops}
\alias{\%row~\%}
\alias{\%col~\%}
\title{Row- or Column-wise Re-ordering of Matrices}
\usage{
x \%row~\% mat

x \%col~\% mat
}
\arguments{
\item{x}{a matrix}

\item{mat}{a numeric matrix with the same dimensions as \code{x},
giving the new ordering ranks for every element of matrix \code{x}. \cr \cr}
}
\value{
A re-ordered matrix.
}
\description{
Infix operators for custom row- and column-wise re-ordering of matrices. \cr
\cr
The \code{x \%row~\% mat} operator re-orders the elements of every row,
each row ordered independently from the other rows, of matrix \code{x},
according to the ordering ranks given in matrix \code{mat}. \cr
\cr
The \code{x \%col~\% mat} operator re-orders the elements of every column,
each column ordered independently from the other columns, of matrix \code{x},
according to the ordering ranks given in matrix \code{mat}. \cr
\cr
Note that these operators strip all attributes,
except dimensions. \cr
\cr
}
\examples{
# numeric matrix ====

x <- matrix(sample(1:25), nrow = 5)
print(x)
x \%row~\% x # sort elements of every row independently
x \%row~\% -x # reverse-sort elements of every row independently
x \%col~\% x # sort elements of every column independently
x \%col~\% -x # reverse-sort elements of every column independently

x <- matrix(sample(1:25), nrow = 5)
print(x)
mat <- sample(seq_along(x)) |> matrix(ncol = ncol(x))
x \%row~\% mat # randomly shuffle every row independently
x \%col~\% mat # randomly shuffle every column independently

# character matrix ====

x <- matrix(sample(letters, 25), nrow = 5)
print(x)
mat <- stringi::stri_rank(as.vector(x)) |> matrix(ncol = ncol(x))
x \%row~\% mat # sort elements of every row independently
x \%row~\% -mat # reverse-sort elements of every row independently
x \%col~\% mat # sort elements of every column independently
x \%col~\% -mat # reverse-sort elements of every column independently

x <- matrix(sample(letters, 25), nrow = 5)
print(x)
mat <- sample(seq_along(x)) |> matrix(ncol = ncol(x))
x \%row~\% mat # randomly shuffle every row independently
x \%col~\% mat # randomise shuffle every column independently
}
\seealso{
\link{tinycodet_dry}
}
