% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/as-tsibble.R
\name{is_duplicated}
\alias{is_duplicated}
\alias{are_duplicated}
\alias{duplicates}
\title{Test duplicated observations determined by key and index variables}
\usage{
is_duplicated(data, key = NULL, index)

are_duplicated(data, key = NULL, index, from_last = FALSE)

duplicates(data, key = NULL, index)
}
\arguments{
\item{data}{A data frame for creating a tsibble.}

\item{key}{<\code{\link[dplyr:dplyr_tidy_select]{tidy-select}}> Variable(s) that uniquely
determine time indices. \code{NULL} for an empty key, unquoted column names (e.g.
\code{x}) for a single variable, and \code{c()} for multiple variables (e.g. \code{c(x, y)}).
This argument also supports \link[tidyselect:language]{tidy-select expressions},
e.g. \code{\link[dplyr:reexports]{dplyr::starts_with()}}, \code{\link[dplyr:reexports]{dplyr::all_of()}}.}

\item{index}{<\code{\link[dplyr:dplyr_tidy_select]{tidy-select}}> A variable that contains
time indices. This is commonly an unquoted column name (e.g. \code{t}), but it can
also be a \link[tidyselect:language]{tidy-select expression}.}

\item{from_last}{\code{TRUE} does the duplication check from the last of identical
elements.}
}
\description{
\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#stable}{\figure{lifecycle-stable.svg}{options: alt='[Stable]'}}}{\strong{[Stable]}}
\itemize{
\item \code{is_duplicated()}: a logical scalar if the data exist duplicated observations.
\item \code{are_duplicated()}: a logical vector, the same length as the row number of \code{data}.
\item \code{duplicates()}: identical key-index data entries.
}
}
\examples{
harvest <- tibble(
  year = c(2010, 2011, 2013, 2011, 2012, 2014, 2014),
  fruit = c(rep(c("kiwi", "cherry"), each = 3), "cherry"),
  kilo = sample(1:10, size = 7)
)
is_duplicated(harvest, key = fruit, index = year)
are_duplicated(harvest, key = fruit, index = year)
are_duplicated(harvest, key = fruit, index = year, from_last = TRUE)
duplicates(harvest, key = fruit, index = year)
}
