% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tspredbench.R
\docType{data}
\name{ipeadata.m}
\alias{ipeadata.m}
\title{Ipea Monthly Macroeconomic Dataset}
\format{
A data frame with up to 1019 rows and 23 columns. Each column corresponds to a different univariate monthly time series.
}
\source{
\href{http://www.ipeadata.gov.br}{Ipea - Ipeadata Portal}, section "Most Requested Series", filtered by frequency "Monthly".
}
\usage{
data(ipeadata.m)
}
\description{
Monthly economic time series from Ipea (Institute for Applied Economic Research, Brazil).
Data Type: Macroeconomic indicators. Category: Public data. Observations: 156 to 1019 per series, 23 series.
This dataset contains the most requested time series provided by Ipea, including exchange rates, inflation indices, unemployment rates, interest rates, minimum wage, and GDP.
The series span from 1930 to September 2017. Missing values were removed using \code{na.omit}.
The last 12 observations are for testing set.
}
\details{
Contains monthly macroeconomic indicators; the last 12 observations are intended as a test set.
}
\examples{
# Load Ipea monthly dataset and plot the first series
data(ipeadata.m)
# ipeadata.m <- loadfulldata(ipeadata.m)
series <- ipeadata.m[[1]]
ts.plot(series, ylab = "Value", xlab = "Month", main = "Ipea monthly example")
}
\references{
Ipea (2017). \emph{Ipeadata – Macroeconomic and Regional Data}. Technical Report. \url{http://www.ipeadata.gov.br}
}
\keyword{benchmark}
\keyword{brazil}
\keyword{datasets}
\keyword{economics}
