% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ts_fil_ses.R
\name{ts_fil_ses}
\alias{ts_fil_ses}
\title{Simple Exponential Smoothing}
\usage{
ts_fil_ses(gamma = FALSE)
}
\arguments{
\item{gamma}{If TRUE, enables the gamma seasonality component.}
}
\value{
A \code{ts_fil_ses} object.
}
\description{
Exponential smoothing focused on the level component, with
optional extensions to trend/seasonality via Holt–Winters variants.
}
\examples{
# time series with noise
library(daltoolbox)
data(tsd)
tsd$y[9] <- 2*tsd$y[9]

# filter
filter <- ts_fil_ses()
filter <- fit(filter, tsd$y)
y <- transform(filter, tsd$y)

# plot
plot_ts_pred(y=tsd$y, yadj=y)
}
\references{
\itemize{
\item R. G. Brown (1959). Statistical Forecasting for Inventory Control.
}
}
