% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tt.R
\name{tt}
\alias{tt}
\title{Create a Typst table}
\usage{
tt(
  data,
  cols = tidyselect::everything(),
  col_names = NULL,
  col_widths = "auto",
  align = NULL,
  preamble = NULL,
  escape = TRUE,
  rownames = TRUE
)
}
\arguments{
\item{data}{A data.frame or tibble to convert to a table.}

\item{cols}{<\code{\link[tidyselect:language]{tidy-select}}> Columns to include in the
displayed table. Hidden columns remain available for data-driven formatting.
Defaults to all columns.}

\item{col_names}{Optional character vector of display names for columns.
Must match the number of selected columns. If NULL, uses column names from data.}

\item{col_widths}{Column width specification: "auto" (default) creates equal-width
columns that fill the container. Use \code{tt_widths()} for custom proportions.}

\item{align}{Column alignment: single value applied to all columns, or vector
of alignments. Valid values: "left"/"l", "center"/"c", "right"/"r".}

\item{preamble}{Optional character string of raw Typst code to insert before the
table. Useful for \verb{#set} rules, \verb{#let} bindings, or other Typst directives that
should apply to the table (e.g., \code{'#set text(font: "Arial")'}).}

\item{escape}{Logical. If TRUE (default), escapes Typst special characters.}

\item{rownames}{Logical. TRUE (default) includes row names as the first column
with an empty header, FALSE excludes them.}
}
\value{
A \code{typst_table} object that can be further styled and rendered.
}
\description{
Creates a \code{typst_table} object from a data.frame or tibble that can be
rendered to Typst markup. Use pipe-friendly styling functions like
\code{tt_style()}, \code{tt_column()}, \code{tt_row()}, and \code{tt_cell()} to customize
the table appearance.
}
\examples{
# Basic table (includes row names by default)
tt(mtcars[1:5, 1:3])

# Select specific columns (excludes row names)
tt(mtcars, cols = c(mpg, cyl, hp), rownames = FALSE)

# Custom column names
tt(mtcars[1:5, 1:3], col_names = c("Miles/Gallon", "Cylinders", "Horsepower"), rownames = FALSE)

# Right-align numeric columns
tt(mtcars[1:5, 1:3], align = "right")

}
