% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tt_lines.R
\name{tt_vline}
\alias{tt_vline}
\title{Add vertical line to table}
\usage{
tt_vline(table, x, start = NULL, end = NULL, stroke = TRUE)
}
\arguments{
\item{table}{A \code{typst_table} object.}

\item{x}{Position of the line (0 = before first column, 1 = after first column, etc.).}

\item{start}{Starting row for partial line (0-indexed, inclusive, 0 = header).}

\item{end}{Ending row for partial line (0-indexed, inclusive).}

\item{stroke}{Line style: \code{TRUE} for default, color name, or full stroke spec.}
}
\value{
The modified \code{typst_table} object.
}
\description{
Adds a vertical line at a specific position in the table.
}
\examples{
# Add line after first column
tt(mtcars[1:5, 1:3], rownames = FALSE) |>
  tt_vline(1)

# Add partial vertical line (data rows only)
tt(mtcars[1:5, 1:3], rownames = FALSE) |>
  tt_vline(1, start = 1)

}
