% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ggplot_decorator.R
\name{ggplot_decorator}
\alias{ggplot_decorator}
\title{\code{ggplot} decorator}
\usage{
ggplot_decorator(
  output_name,
  label_text = "decorator",
  render_ui = c(),
  plot_options = list(title = "", footnote = "", y_breaks = "", y_limits_max = "",
    y_limits_min = "", x_breaks = "", x_labels_discrete = "", x_labels_cont = "",
    y_labels_discrete = "", y_labels_cont = "", font_size_geom_text = "",
    font_size_plot_title = "", font_size_axis_title = "", font_size_axis_text = "")
)
}
\arguments{
\item{output_name}{a name for the output plot object.}

\item{label_text}{customized label text for the decorator}

\item{render_ui}{vector of \code{ggplot_options} from the following list:
"title" - Title of the plot,
"footnote" - Footnote of the plot,
"y_breaks" - Value of breaks(numeric) for y-axis. Note: y_limits_max and y_limits_min
should also be provided,
"y_limits_max" - Value of y-axis maximum limit(numeric). Note: y_limits_max and y_breaks
should also be provided,
"y_limits_min" - Value of y-axis minimum limit(numeric). Note: y_breaks and y_limits_min
should also be provided,
"x_breaks"- Value of breaks for continuous x-axis(numeric). Note: should be comma separated,
"x_labels_discrete" - Values of labels for discrete x-axis. Note: should be comma separated,
"x_labels_cont" - Values of labels for continuous x-axis. Note: should be comma separated,
"y_labels_discrete" - Values of labels for discrete y-axis. Note: should be comma separated,
"y_labels_cont" - Values of labels for continuous y-axis. Note: should be comma separated,
"font_size_geom_text" - Font size of geom_text. Note: numeric value should be provided,
"font_size_plot_title"- Font size of plot title text. Note: numeric value should be provided,
"font_size_axis_title"- Font size of axis title text. Note: numeric value should be provided,
"font_size_axis_text"- Font size of axis labels text. Note: numeric value should be provided}

\item{plot_options}{named list with the list of values for the \code{ggplot} options.
The app developer can specify the required list of options while calling the decorator.}
}
\value{
\code{teal::teal_transform_module} Returns a modified plot object with the transformation applied.
}
\description{
\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#experimental}{\figure{lifecycle-experimental.svg}{options: alt='[Experimental]'}}}{\strong{[Experimental]}}
Decorator function to update various settings for \code{ggplot} plot objects
}
\details{
The module creates a UI with text controls for specifying the list
of \code{ggplot} options given in the \code{plot_options} parameter value.
The entered \code{ggplot} options are applied to \code{ggplot} plot object.
}
\examples{
app <- teal::init(
  data = teal.data::teal_data(IRIS = iris, code = "IRIS <- iris"),
  modules = teal::modules(
    teal.modules.general::tm_g_scatterplot(
      x = teal.transform::data_extract_spec(
        dataname = "IRIS",
        select = teal.transform::select_spec(choices = teal.transform::variable_choices(iris))
      ),
      y = teal.transform::data_extract_spec(
        dataname = "IRIS",
        select = teal.transform::select_spec(choices = teal.transform::variable_choices(iris))
      ),
      decorators = list(
        plot = ggplot_decorator(
          output_name = "plot", render_ui = c("title", "footnote", "font_size_axis_title")
        )
      )
    )
  )
)
if (interactive()) {
  shinyApp(app$ui, app$server)
}

}
