% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/precision_methods.R
\name{print.precision_study}
\alias{print.precision_study}
\title{Print method for precision_study objects}
\usage{
\method{print}{precision_study}(x, digits = 3, ...)
}
\arguments{
\item{x}{An object of class \code{precision_study}.}

\item{digits}{Number of significant digits to display (default: 3).}

\item{...}{Additional arguments (currently ignored).}
}
\value{
Invisibly returns the input object \code{x}.
}
\description{
Displays a concise summary of precision study results, including
variance components and key precision estimates.
}
\examples{
# Create example data
set.seed(42)
data <- data.frame(
  day = rep(1:5, each = 4),
  value = rnorm(20, mean = 100, sd = 5)
)
data$value <- data$value + rep(rnorm(5, 0, 3), each = 4)

prec <- precision_study(data, value = "value", day = "day")
print(prec)

}
\seealso{
\code{\link[=summary.precision_study]{summary.precision_study()}} for detailed output
}
