% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/transformation.R
\name{vascr_normalise}
\alias{vascr_normalise}
\title{Normalize ECIS data to a single time point}
\usage{
vascr_normalise(data.df, normtime, divide = FALSE)
}
\arguments{
\item{data.df}{Standard vascr data frame}

\item{normtime}{Time to normalize the data to}

\item{divide}{If set to true, data will be normalized via a division. If set to false (default) data will be normalized by subtraction. Default is subtraction}
}
\value{
A standard ECIS dataset with each value normalized to the selected point.
}
\description{
This function normalises each unique experiment/well combination to it's value at the specified time. Contains options to do this either by division or subtraction. Can be run twice on the same dataset if both operations are desired.
}
\examples{

data = vascr_normalise(growth.df, normtime = 100)
head(data)

}
