# Can subset correctly

    Code
      vascr_subset(growth.df)
    Output
      # A tibble: 139,230 x 12
          Time Unit  Well  Value Sample    Frequency Experiment cells line  Instrument
         <dbl> <chr> <chr> <dbl> <chr>         <dbl> <fct>      <chr> <chr> <chr>     
       1     5 Alpha A01    2.69 35,000_c~         0 1 : Exper~ 35000 HCME~ ECIS      
       2     5 Alpha A02    2.89 35,000_c~         0 1 : Exper~ 35000 HCME~ ECIS      
       3     5 Alpha A03    2.71 35,000_c~         0 1 : Exper~ 35000 HCME~ ECIS      
       4     5 Alpha B01    2.52 30,000_c~         0 1 : Exper~ 30000 HCME~ ECIS      
       5     5 Alpha B02    2.69 30,000_c~         0 1 : Exper~ 30000 HCME~ ECIS      
       6     5 Alpha B03    2.34 30,000_c~         0 1 : Exper~ 30000 HCME~ ECIS      
       7     5 Alpha C01    2.15 25,000_c~         0 1 : Exper~ 25000 HCME~ ECIS      
       8     5 Alpha C02    2.35 25,000_c~         0 1 : Exper~ 25000 HCME~ ECIS      
       9     5 Alpha C03    2.4  25,000_c~         0 1 : Exper~ 25000 HCME~ ECIS      
      10     5 Alpha D01    1.85 20,000_c~         0 1 : Exper~ 20000 HCME~ ECIS      
      # i 139,220 more rows
      # i 2 more variables: SampleID <int>, Excluded <chr>

---

    Code
      vascr_subset(growth.df, time = 40)
    Output
      # A tibble: 3,570 x 12
          Time Unit  Well  Value Sample    Frequency Experiment cells line  Instrument
         <dbl> <chr> <chr> <dbl> <chr>         <dbl> <fct>      <chr> <chr> <chr>     
       1    40 Alpha A01    5.17 35,000_c~         0 1 : Exper~ 35000 HCME~ ECIS      
       2    40 Alpha A02    4.89 35,000_c~         0 1 : Exper~ 35000 HCME~ ECIS      
       3    40 Alpha A03    5.12 35,000_c~         0 1 : Exper~ 35000 HCME~ ECIS      
       4    40 Alpha B01    5.22 30,000_c~         0 1 : Exper~ 30000 HCME~ ECIS      
       5    40 Alpha B02    5.36 30,000_c~         0 1 : Exper~ 30000 HCME~ ECIS      
       6    40 Alpha B03    5.6  30,000_c~         0 1 : Exper~ 30000 HCME~ ECIS      
       7    40 Alpha C01    5.19 25,000_c~         0 1 : Exper~ 25000 HCME~ ECIS      
       8    40 Alpha C02    5.32 25,000_c~         0 1 : Exper~ 25000 HCME~ ECIS      
       9    40 Alpha C03    4.95 25,000_c~         0 1 : Exper~ 25000 HCME~ ECIS      
      10    40 Alpha D01    4.51 20,000_c~         0 1 : Exper~ 20000 HCME~ ECIS      
      # i 3,560 more rows
      # i 2 more variables: SampleID <int>, Excluded <chr>

---

    Code
      vascr_subset(growth.df, time = c(40, 60))
    Output
      # A tibble: 17,850 x 12
          Time Unit  Well  Value Sample    Frequency Experiment cells line  Instrument
         <dbl> <chr> <chr> <dbl> <chr>         <dbl> <fct>      <chr> <chr> <chr>     
       1    40 Alpha A01    5.17 35,000_c~         0 1 : Exper~ 35000 HCME~ ECIS      
       2    40 Alpha A02    4.89 35,000_c~         0 1 : Exper~ 35000 HCME~ ECIS      
       3    40 Alpha A03    5.12 35,000_c~         0 1 : Exper~ 35000 HCME~ ECIS      
       4    40 Alpha B01    5.22 30,000_c~         0 1 : Exper~ 30000 HCME~ ECIS      
       5    40 Alpha B02    5.36 30,000_c~         0 1 : Exper~ 30000 HCME~ ECIS      
       6    40 Alpha B03    5.6  30,000_c~         0 1 : Exper~ 30000 HCME~ ECIS      
       7    40 Alpha C01    5.19 25,000_c~         0 1 : Exper~ 25000 HCME~ ECIS      
       8    40 Alpha C02    5.32 25,000_c~         0 1 : Exper~ 25000 HCME~ ECIS      
       9    40 Alpha C03    4.95 25,000_c~         0 1 : Exper~ 25000 HCME~ ECIS      
      10    40 Alpha D01    4.51 20,000_c~         0 1 : Exper~ 20000 HCME~ ECIS      
      # i 17,840 more rows
      # i 2 more variables: SampleID <int>, Excluded <chr>

---

    Code
      vascr_subset(growth.df, time = NULL)
    Output
      # A tibble: 139,230 x 12
          Time Unit  Well  Value Sample    Frequency Experiment cells line  Instrument
         <dbl> <chr> <chr> <dbl> <chr>         <dbl> <fct>      <chr> <chr> <chr>     
       1     5 Alpha A01    2.69 35,000_c~         0 1 : Exper~ 35000 HCME~ ECIS      
       2     5 Alpha A02    2.89 35,000_c~         0 1 : Exper~ 35000 HCME~ ECIS      
       3     5 Alpha A03    2.71 35,000_c~         0 1 : Exper~ 35000 HCME~ ECIS      
       4     5 Alpha B01    2.52 30,000_c~         0 1 : Exper~ 30000 HCME~ ECIS      
       5     5 Alpha B02    2.69 30,000_c~         0 1 : Exper~ 30000 HCME~ ECIS      
       6     5 Alpha B03    2.34 30,000_c~         0 1 : Exper~ 30000 HCME~ ECIS      
       7     5 Alpha C01    2.15 25,000_c~         0 1 : Exper~ 25000 HCME~ ECIS      
       8     5 Alpha C02    2.35 25,000_c~         0 1 : Exper~ 25000 HCME~ ECIS      
       9     5 Alpha C03    2.4  25,000_c~         0 1 : Exper~ 25000 HCME~ ECIS      
      10     5 Alpha D01    1.85 20,000_c~         0 1 : Exper~ 20000 HCME~ ECIS      
      # i 139,220 more rows
      # i 2 more variables: SampleID <int>, Excluded <chr>

---

    Code
      vascr_subset(growth.df, unit = "Rb")
    Output
      # A tibble: 2,574 x 12
          Time Unit  Well  Value Sample    Frequency Experiment cells line  Instrument
         <dbl> <fct> <chr> <dbl> <chr>         <dbl> <fct>      <chr> <chr> <chr>     
       1     5 Rb    A01       0 35,000_c~         0 1 : Exper~ 35000 HCME~ ECIS      
       2     5 Rb    A02       0 35,000_c~         0 1 : Exper~ 35000 HCME~ ECIS      
       3     5 Rb    A03       0 35,000_c~         0 1 : Exper~ 35000 HCME~ ECIS      
       4     5 Rb    B01       0 30,000_c~         0 1 : Exper~ 30000 HCME~ ECIS      
       5     5 Rb    B02       0 30,000_c~         0 1 : Exper~ 30000 HCME~ ECIS      
       6     5 Rb    B03       0 30,000_c~         0 1 : Exper~ 30000 HCME~ ECIS      
       7     5 Rb    C01       0 25,000_c~         0 1 : Exper~ 25000 HCME~ ECIS      
       8     5 Rb    C02       0 25,000_c~         0 1 : Exper~ 25000 HCME~ ECIS      
       9     5 Rb    C03       0 25,000_c~         0 1 : Exper~ 25000 HCME~ ECIS      
      10     5 Rb    D01       0 20,000_c~         0 1 : Exper~ 20000 HCME~ ECIS      
      # i 2,564 more rows
      # i 2 more variables: SampleID <int>, Excluded <chr>

---

    Code
      vascr_subset(growth.df, unit = "R")
    Output
      # A tibble: 25,272 x 12
          Time Unit  Well  Value Sample    Frequency Experiment cells line  Instrument
         <dbl> <fct> <chr> <dbl> <chr>         <dbl> <fct>      <chr> <chr> <chr>     
       1     5 R     A01    413. 35,000_c~      1000 1 : Exper~ 35000 HCME~ ECIS      
       2    10 R     A01    470. 35,000_c~      1000 1 : Exper~ 35000 HCME~ ECIS      
       3    15 R     A01    556. 35,000_c~      1000 1 : Exper~ 35000 HCME~ ECIS      
       4    20 R     A01    630. 35,000_c~      1000 1 : Exper~ 35000 HCME~ ECIS      
       5    25 R     A01    677. 35,000_c~      1000 1 : Exper~ 35000 HCME~ ECIS      
       6    30 R     A01    695. 35,000_c~      1000 1 : Exper~ 35000 HCME~ ECIS      
       7    35 R     A01    729. 35,000_c~      1000 1 : Exper~ 35000 HCME~ ECIS      
       8    40 R     A01    768. 35,000_c~      1000 1 : Exper~ 35000 HCME~ ECIS      
       9    45 R     A01    801. 35,000_c~      1000 1 : Exper~ 35000 HCME~ ECIS      
      10    50 R     A01    815. 35,000_c~      1000 1 : Exper~ 35000 HCME~ ECIS      
      # i 25,262 more rows
      # i 2 more variables: SampleID <int>, Excluded <chr>

---

    Code
      vascr_subset(growth.df, well = "A1")
    Output
      # A tibble: 1,950 x 12
          Time Unit  Well  Value Sample    Frequency Experiment cells line  Instrument
         <dbl> <chr> <chr> <dbl> <chr>         <dbl> <fct>      <chr> <chr> <chr>     
       1     5 Alpha A01    2.69 35,000_c~         0 1 : Exper~ 35000 HCME~ ECIS      
       2     5 Cm    A01   37.9  35,000_c~         0 1 : Exper~ 35000 HCME~ ECIS      
       3     5 Drift A01   -0.94 35,000_c~         0 1 : Exper~ 35000 HCME~ ECIS      
       4     5 Rb    A01    0    35,000_c~         0 1 : Exper~ 35000 HCME~ ECIS      
       5     5 RMSE  A01    0.01 35,000_c~         0 1 : Exper~ 35000 HCME~ ECIS      
       6    10 Alpha A01    3.34 35,000_c~         0 1 : Exper~ 35000 HCME~ ECIS      
       7    10 Cm    A01   18.8  35,000_c~         0 1 : Exper~ 35000 HCME~ ECIS      
       8    10 Drift A01   -1.82 35,000_c~         0 1 : Exper~ 35000 HCME~ ECIS      
       9    10 Rb    A01    0    35,000_c~         0 1 : Exper~ 35000 HCME~ ECIS      
      10    10 RMSE  A01    0.02 35,000_c~         0 1 : Exper~ 35000 HCME~ ECIS      
      # i 1,940 more rows
      # i 2 more variables: SampleID <int>, Excluded <chr>

---

    Code
      vascr_subset(growth.df, well = "B12")
    Message
      ! [B12] corrected to [B02]. Please check the argeuments for your functions are correctly typed.
    Output
      # A tibble: 1,950 x 12
          Time Unit  Well  Value Sample    Frequency Experiment cells line  Instrument
         <dbl> <chr> <chr> <dbl> <chr>         <dbl> <fct>      <chr> <chr> <chr>     
       1     5 Alpha B02    2.69 30,000_c~         0 1 : Exper~ 30000 HCME~ ECIS      
       2     5 Cm    B02   37.7  30,000_c~         0 1 : Exper~ 30000 HCME~ ECIS      
       3     5 Drift B02   -1.1  30,000_c~         0 1 : Exper~ 30000 HCME~ ECIS      
       4     5 Rb    B02    0    30,000_c~         0 1 : Exper~ 30000 HCME~ ECIS      
       5     5 RMSE  B02    0.01 30,000_c~         0 1 : Exper~ 30000 HCME~ ECIS      
       6    10 Alpha B02    3.4  30,000_c~         0 1 : Exper~ 30000 HCME~ ECIS      
       7    10 Cm    B02   18.1  30,000_c~         0 1 : Exper~ 30000 HCME~ ECIS      
       8    10 Drift B02   -2.16 30,000_c~         0 1 : Exper~ 30000 HCME~ ECIS      
       9    10 Rb    B02    0    30,000_c~         0 1 : Exper~ 30000 HCME~ ECIS      
      10    10 RMSE  B02    0.02 30,000_c~         0 1 : Exper~ 30000 HCME~ ECIS      
      # i 1,940 more rows
      # i 2 more variables: SampleID <int>, Excluded <chr>

---

    Code
      vascr_subset(growth.df, well = "B20")
    Message
      ! Well NA is not a valid well name, please check your input data
      ! [NA] corrected to [A01]. Please check the argeuments for your functions are correctly typed.
    Output
      # A tibble: 1,950 x 12
          Time Unit  Well  Value Sample    Frequency Experiment cells line  Instrument
         <dbl> <chr> <chr> <dbl> <chr>         <dbl> <fct>      <chr> <chr> <chr>     
       1     5 Alpha A01    2.69 35,000_c~         0 1 : Exper~ 35000 HCME~ ECIS      
       2     5 Cm    A01   37.9  35,000_c~         0 1 : Exper~ 35000 HCME~ ECIS      
       3     5 Drift A01   -0.94 35,000_c~         0 1 : Exper~ 35000 HCME~ ECIS      
       4     5 Rb    A01    0    35,000_c~         0 1 : Exper~ 35000 HCME~ ECIS      
       5     5 RMSE  A01    0.01 35,000_c~         0 1 : Exper~ 35000 HCME~ ECIS      
       6    10 Alpha A01    3.34 35,000_c~         0 1 : Exper~ 35000 HCME~ ECIS      
       7    10 Cm    A01   18.8  35,000_c~         0 1 : Exper~ 35000 HCME~ ECIS      
       8    10 Drift A01   -1.82 35,000_c~         0 1 : Exper~ 35000 HCME~ ECIS      
       9    10 Rb    A01    0    35,000_c~         0 1 : Exper~ 35000 HCME~ ECIS      
      10    10 RMSE  A01    0.02 35,000_c~         0 1 : Exper~ 35000 HCME~ ECIS      
      # i 1,940 more rows
      # i 2 more variables: SampleID <int>, Excluded <chr>

---

    Code
      vascr_subset(growth.df, well = c("B2", "B03"))
    Output
      # A tibble: 3,900 x 12
          Time Unit  Well  Value Sample    Frequency Experiment cells line  Instrument
         <dbl> <chr> <chr> <dbl> <chr>         <dbl> <fct>      <chr> <chr> <chr>     
       1     5 Alpha B02    2.69 30,000_c~         0 1 : Exper~ 30000 HCME~ ECIS      
       2     5 Alpha B03    2.34 30,000_c~         0 1 : Exper~ 30000 HCME~ ECIS      
       3     5 Cm    B02   37.7  30,000_c~         0 1 : Exper~ 30000 HCME~ ECIS      
       4     5 Cm    B03   49.0  30,000_c~         0 1 : Exper~ 30000 HCME~ ECIS      
       5     5 Drift B02   -1.1  30,000_c~         0 1 : Exper~ 30000 HCME~ ECIS      
       6     5 Drift B03   -0.58 30,000_c~         0 1 : Exper~ 30000 HCME~ ECIS      
       7     5 Rb    B02    0    30,000_c~         0 1 : Exper~ 30000 HCME~ ECIS      
       8     5 Rb    B03    0    30,000_c~         0 1 : Exper~ 30000 HCME~ ECIS      
       9     5 RMSE  B02    0.01 30,000_c~         0 1 : Exper~ 30000 HCME~ ECIS      
      10     5 RMSE  B03    0.01 30,000_c~         0 1 : Exper~ 30000 HCME~ ECIS      
      # i 3,890 more rows
      # i 2 more variables: SampleID <int>, Excluded <chr>

---

    Code
      vascr_subset(growth.df, well = c("-A01", "-B3"))
    Output
      # A tibble: 135,330 x 12
          Time Unit  Well  Value Sample    Frequency Experiment cells line  Instrument
         <dbl> <chr> <chr> <dbl> <chr>         <dbl> <fct>      <chr> <chr> <chr>     
       1     5 Alpha A02    2.89 35,000_c~         0 1 : Exper~ 35000 HCME~ ECIS      
       2     5 Alpha A03    2.71 35,000_c~         0 1 : Exper~ 35000 HCME~ ECIS      
       3     5 Alpha B01    2.52 30,000_c~         0 1 : Exper~ 30000 HCME~ ECIS      
       4     5 Alpha B02    2.69 30,000_c~         0 1 : Exper~ 30000 HCME~ ECIS      
       5     5 Alpha C01    2.15 25,000_c~         0 1 : Exper~ 25000 HCME~ ECIS      
       6     5 Alpha C02    2.35 25,000_c~         0 1 : Exper~ 25000 HCME~ ECIS      
       7     5 Alpha C03    2.4  25,000_c~         0 1 : Exper~ 25000 HCME~ ECIS      
       8     5 Alpha D01    1.85 20,000_c~         0 1 : Exper~ 20000 HCME~ ECIS      
       9     5 Alpha D02    2.02 20,000_c~         0 1 : Exper~ 20000 HCME~ ECIS      
      10     5 Alpha D03    2.05 20,000_c~         0 1 : Exper~ 20000 HCME~ ECIS      
      # i 135,320 more rows
      # i 2 more variables: SampleID <int>, Excluded <chr>

---

    Code
      vascr_subset(growth.df, frequency = 4000)
    Output
      # A tibble: 14,040 x 12
          Time Unit  Well  Value Sample    Frequency Experiment cells line  Instrument
         <dbl> <chr> <chr> <dbl> <chr>         <dbl> <fct>      <chr> <chr> <chr>     
       1     5 C     A01   104.  35,000_c~      4000 1 : Exper~ 35000 HCME~ ECIS      
       2    10 C     A01    98.8 35,000_c~      4000 1 : Exper~ 35000 HCME~ ECIS      
       3    15 C     A01    92.3 35,000_c~      4000 1 : Exper~ 35000 HCME~ ECIS      
       4    20 C     A01    88.4 35,000_c~      4000 1 : Exper~ 35000 HCME~ ECIS      
       5    25 C     A01    86.9 35,000_c~      4000 1 : Exper~ 35000 HCME~ ECIS      
       6    30 C     A01    86.8 35,000_c~      4000 1 : Exper~ 35000 HCME~ ECIS      
       7    35 C     A01    86.7 35,000_c~      4000 1 : Exper~ 35000 HCME~ ECIS      
       8    40 C     A01    87.9 35,000_c~      4000 1 : Exper~ 35000 HCME~ ECIS      
       9    45 C     A01    90.0 35,000_c~      4000 1 : Exper~ 35000 HCME~ ECIS      
      10    50 C     A01    92.3 35,000_c~      4000 1 : Exper~ 35000 HCME~ ECIS      
      # i 14,030 more rows
      # i 2 more variables: SampleID <int>, Excluded <chr>

---

    Code
      vascr_subset(growth.df %>% mutate(Frequency = as.character(Frequency)),
      frequency = "4000")
    Output
      # A tibble: 14,040 x 12
          Time Unit  Well  Value Sample    Frequency Experiment cells line  Instrument
         <dbl> <chr> <chr> <dbl> <chr>         <dbl> <fct>      <chr> <chr> <chr>     
       1     5 C     A01   104.  35,000_c~      4000 1 : Exper~ 35000 HCME~ ECIS      
       2    10 C     A01    98.8 35,000_c~      4000 1 : Exper~ 35000 HCME~ ECIS      
       3    15 C     A01    92.3 35,000_c~      4000 1 : Exper~ 35000 HCME~ ECIS      
       4    20 C     A01    88.4 35,000_c~      4000 1 : Exper~ 35000 HCME~ ECIS      
       5    25 C     A01    86.9 35,000_c~      4000 1 : Exper~ 35000 HCME~ ECIS      
       6    30 C     A01    86.8 35,000_c~      4000 1 : Exper~ 35000 HCME~ ECIS      
       7    35 C     A01    86.7 35,000_c~      4000 1 : Exper~ 35000 HCME~ ECIS      
       8    40 C     A01    87.9 35,000_c~      4000 1 : Exper~ 35000 HCME~ ECIS      
       9    45 C     A01    90.0 35,000_c~      4000 1 : Exper~ 35000 HCME~ ECIS      
      10    50 C     A01    92.3 35,000_c~      4000 1 : Exper~ 35000 HCME~ ECIS      
      # i 14,030 more rows
      # i 2 more variables: SampleID <int>, Excluded <chr>

---

    Code
      vascr_subset(growth.df, experiment = 1)
    Output
      # A tibble: 46,215 x 12
          Time Unit  Well  Value Sample    Frequency Experiment cells line  Instrument
         <dbl> <chr> <chr> <dbl> <chr>         <dbl> <fct>      <chr> <chr> <chr>     
       1     5 Alpha A01    2.69 35,000_c~         0 1 : Exper~ 35000 HCME~ ECIS      
       2     5 Alpha A02    2.89 35,000_c~         0 1 : Exper~ 35000 HCME~ ECIS      
       3     5 Alpha A03    2.71 35,000_c~         0 1 : Exper~ 35000 HCME~ ECIS      
       4     5 Alpha B01    2.52 30,000_c~         0 1 : Exper~ 30000 HCME~ ECIS      
       5     5 Alpha B02    2.69 30,000_c~         0 1 : Exper~ 30000 HCME~ ECIS      
       6     5 Alpha B03    2.34 30,000_c~         0 1 : Exper~ 30000 HCME~ ECIS      
       7     5 Alpha C01    2.15 25,000_c~         0 1 : Exper~ 25000 HCME~ ECIS      
       8     5 Alpha C02    2.35 25,000_c~         0 1 : Exper~ 25000 HCME~ ECIS      
       9     5 Alpha C03    2.4  25,000_c~         0 1 : Exper~ 25000 HCME~ ECIS      
      10     5 Alpha D01    1.85 20,000_c~         0 1 : Exper~ 20000 HCME~ ECIS      
      # i 46,205 more rows
      # i 2 more variables: SampleID <int>, Excluded <chr>

---

    Code
      vascr_subset(growth.df, experiment = 1)
    Output
      # A tibble: 46,215 x 12
          Time Unit  Well  Value Sample    Frequency Experiment cells line  Instrument
         <dbl> <chr> <chr> <dbl> <chr>         <dbl> <fct>      <chr> <chr> <chr>     
       1     5 Alpha A01    2.69 35,000_c~         0 1 : Exper~ 35000 HCME~ ECIS      
       2     5 Alpha A02    2.89 35,000_c~         0 1 : Exper~ 35000 HCME~ ECIS      
       3     5 Alpha A03    2.71 35,000_c~         0 1 : Exper~ 35000 HCME~ ECIS      
       4     5 Alpha B01    2.52 30,000_c~         0 1 : Exper~ 30000 HCME~ ECIS      
       5     5 Alpha B02    2.69 30,000_c~         0 1 : Exper~ 30000 HCME~ ECIS      
       6     5 Alpha B03    2.34 30,000_c~         0 1 : Exper~ 30000 HCME~ ECIS      
       7     5 Alpha C01    2.15 25,000_c~         0 1 : Exper~ 25000 HCME~ ECIS      
       8     5 Alpha C02    2.35 25,000_c~         0 1 : Exper~ 25000 HCME~ ECIS      
       9     5 Alpha C03    2.4  25,000_c~         0 1 : Exper~ 25000 HCME~ ECIS      
      10     5 Alpha D01    1.85 20,000_c~         0 1 : Exper~ 20000 HCME~ ECIS      
      # i 46,205 more rows
      # i 2 more variables: SampleID <int>, Excluded <chr>

---

    Code
      vascr_subset(growth.df, instrument = "ECIS")
    Output
      # A tibble: 139,230 x 12
          Time Unit  Well  Value Sample    Frequency Experiment cells line  Instrument
         <dbl> <chr> <chr> <dbl> <chr>         <dbl> <fct>      <chr> <chr> <chr>     
       1     5 Alpha A01    2.69 35,000_c~         0 1 : Exper~ 35000 HCME~ ECIS      
       2     5 Alpha A02    2.89 35,000_c~         0 1 : Exper~ 35000 HCME~ ECIS      
       3     5 Alpha A03    2.71 35,000_c~         0 1 : Exper~ 35000 HCME~ ECIS      
       4     5 Alpha B01    2.52 30,000_c~         0 1 : Exper~ 30000 HCME~ ECIS      
       5     5 Alpha B02    2.69 30,000_c~         0 1 : Exper~ 30000 HCME~ ECIS      
       6     5 Alpha B03    2.34 30,000_c~         0 1 : Exper~ 30000 HCME~ ECIS      
       7     5 Alpha C01    2.15 25,000_c~         0 1 : Exper~ 25000 HCME~ ECIS      
       8     5 Alpha C02    2.35 25,000_c~         0 1 : Exper~ 25000 HCME~ ECIS      
       9     5 Alpha C03    2.4  25,000_c~         0 1 : Exper~ 25000 HCME~ ECIS      
      10     5 Alpha D01    1.85 20,000_c~         0 1 : Exper~ 20000 HCME~ ECIS      
      # i 139,220 more rows
      # i 2 more variables: SampleID <int>, Excluded <chr>

---

    Code
      vascr_subset(growth.df, unit = "Rb", sampleid = c(1:3))
    Output
      # A tibble: 1,053 x 12
          Time Unit  Well  Value Sample    Frequency Experiment cells line  Instrument
         <dbl> <fct> <chr> <dbl> <fct>         <dbl> <fct>      <chr> <chr> <chr>     
       1     5 Rb    A01       0 35,000_c~         0 1 : Exper~ 35000 HCME~ ECIS      
       2     5 Rb    A02       0 35,000_c~         0 1 : Exper~ 35000 HCME~ ECIS      
       3     5 Rb    A03       0 35,000_c~         0 1 : Exper~ 35000 HCME~ ECIS      
       4     5 Rb    B01       0 30,000_c~         0 1 : Exper~ 30000 HCME~ ECIS      
       5     5 Rb    B02       0 30,000_c~         0 1 : Exper~ 30000 HCME~ ECIS      
       6     5 Rb    B03       0 30,000_c~         0 1 : Exper~ 30000 HCME~ ECIS      
       7     5 Rb    C01       0 25,000_c~         0 1 : Exper~ 25000 HCME~ ECIS      
       8     5 Rb    C02       0 25,000_c~         0 1 : Exper~ 25000 HCME~ ECIS      
       9     5 Rb    C03       0 25,000_c~         0 1 : Exper~ 25000 HCME~ ECIS      
      10    10 Rb    A01       0 35,000_c~         0 1 : Exper~ 35000 HCME~ ECIS      
      # i 1,043 more rows
      # i 2 more variables: SampleID <int>, Excluded <chr>

---

    Code
      vascr_subset(growth.df, unit = "Rb", sampleid = c(8))
    Output
      # A tibble: 117 x 12
          Time Unit  Well  Value Sample    Frequency Experiment cells line  Instrument
         <dbl> <fct> <chr> <dbl> <fct>         <dbl> <fct>      <chr> <chr> <chr>     
       1     5 Rb    H07       0 0_cells ~         0 3 : Exper~ 0     HCME~ ECIS      
       2     5 Rb    H08       0 0_cells ~         0 3 : Exper~ 0     HCME~ ECIS      
       3     5 Rb    H09       0 0_cells ~         0 3 : Exper~ 0     HCME~ ECIS      
       4    10 Rb    H07       0 0_cells ~         0 3 : Exper~ 0     HCME~ ECIS      
       5    10 Rb    H08       0 0_cells ~         0 3 : Exper~ 0     HCME~ ECIS      
       6    10 Rb    H09       0 0_cells ~         0 3 : Exper~ 0     HCME~ ECIS      
       7    15 Rb    H07       0 0_cells ~         0 3 : Exper~ 0     HCME~ ECIS      
       8    15 Rb    H08       0 0_cells ~         0 3 : Exper~ 0     HCME~ ECIS      
       9    15 Rb    H09       0 0_cells ~         0 3 : Exper~ 0     HCME~ ECIS      
      10    20 Rb    H07       0 0_cells ~         0 3 : Exper~ 0     HCME~ ECIS      
      # i 107 more rows
      # i 2 more variables: SampleID <int>, Excluded <chr>

---

    Code
      vascr_subset(growth.df, subsample = 100)
    Output
      # A tibble: 3,570 x 12
          Time Unit  Well  Value Sample    Frequency Experiment cells line  Instrument
         <dbl> <chr> <chr> <dbl> <chr>         <dbl> <fct>      <chr> <chr> <chr>     
       1     5 Alpha A01    2.69 35,000_c~         0 1 : Exper~ 35000 HCME~ ECIS      
       2     5 Alpha A02    2.89 35,000_c~         0 1 : Exper~ 35000 HCME~ ECIS      
       3     5 Alpha A03    2.71 35,000_c~         0 1 : Exper~ 35000 HCME~ ECIS      
       4     5 Alpha B01    2.52 30,000_c~         0 1 : Exper~ 30000 HCME~ ECIS      
       5     5 Alpha B02    2.69 30,000_c~         0 1 : Exper~ 30000 HCME~ ECIS      
       6     5 Alpha B03    2.34 30,000_c~         0 1 : Exper~ 30000 HCME~ ECIS      
       7     5 Alpha C01    2.15 25,000_c~         0 1 : Exper~ 25000 HCME~ ECIS      
       8     5 Alpha C02    2.35 25,000_c~         0 1 : Exper~ 25000 HCME~ ECIS      
       9     5 Alpha C03    2.4  25,000_c~         0 1 : Exper~ 25000 HCME~ ECIS      
      10     5 Alpha D01    1.85 20,000_c~         0 1 : Exper~ 20000 HCME~ ECIS      
      # i 3,560 more rows
      # i 2 more variables: SampleID <int>, Excluded <chr>

---

    Code
      vascr_subset(growth.df, unit = "Rb", sampleid = 10)
    Message
      ! No data returned from dataset subset. Check your frequencies, times and units are present in the dataset
    Output
      # A tibble: 0 x 12
      # i 12 variables: Time <dbl>, Unit <fct>, Well <chr>, Value <dbl>,
      #   Sample <fct>, Frequency <dbl>, Experiment <fct>, cells <chr>, line <chr>,
      #   Instrument <chr>, SampleID <int>, Excluded <chr>

---

    Code
      vascr_exclude(growth.df, c("A01", "E01"))
    Output
      # A tibble: 142,270 x 12
          Time Unit  Well  Value Sample    Frequency Experiment cells line  Instrument
         <dbl> <chr> <chr> <dbl> <chr>         <dbl> <fct>      <chr> <chr> <chr>     
       1     0 Alpha A02      NA 35,000_c~         0 1 : Exper~ 35000 HCME~ ECIS      
       2     0 Alpha A03      NA 35,000_c~         0 1 : Exper~ 35000 HCME~ ECIS      
       3     0 Alpha B01      NA 30,000_c~         0 1 : Exper~ 30000 HCME~ ECIS      
       4     0 Alpha B02      NA 30,000_c~         0 1 : Exper~ 30000 HCME~ ECIS      
       5     0 Alpha B03      NA 30,000_c~         0 1 : Exper~ 30000 HCME~ ECIS      
       6     0 Alpha C01      NA 25,000_c~         0 1 : Exper~ 25000 HCME~ ECIS      
       7     0 Alpha C02      NA 25,000_c~         0 1 : Exper~ 25000 HCME~ ECIS      
       8     0 Alpha C03      NA 25,000_c~         0 1 : Exper~ 25000 HCME~ ECIS      
       9     0 Alpha D01      NA 20,000_c~         0 1 : Exper~ 20000 HCME~ ECIS      
      10     0 Alpha D02      NA 20,000_c~         0 1 : Exper~ 20000 HCME~ ECIS      
      # i 142,260 more rows
      # i 2 more variables: SampleID <int>, Excluded <chr>

---

    Code
      vascr_exclude(growth.df, c("A01", "E01"), 1)
    Output
      # A tibble: 142,270 x 12
          Time Unit  Well  Value Sample    Frequency Experiment cells line  Instrument
         <dbl> <chr> <chr> <dbl> <chr>         <dbl> <fct>      <chr> <chr> <chr>     
       1     0 Alpha A02      NA 35,000_c~         0 1 : Exper~ 35000 HCME~ ECIS      
       2     0 Alpha A03      NA 35,000_c~         0 1 : Exper~ 35000 HCME~ ECIS      
       3     0 Alpha B01      NA 30,000_c~         0 1 : Exper~ 30000 HCME~ ECIS      
       4     0 Alpha B02      NA 30,000_c~         0 1 : Exper~ 30000 HCME~ ECIS      
       5     0 Alpha B03      NA 30,000_c~         0 1 : Exper~ 30000 HCME~ ECIS      
       6     0 Alpha C01      NA 25,000_c~         0 1 : Exper~ 25000 HCME~ ECIS      
       7     0 Alpha C02      NA 25,000_c~         0 1 : Exper~ 25000 HCME~ ECIS      
       8     0 Alpha C03      NA 25,000_c~         0 1 : Exper~ 25000 HCME~ ECIS      
       9     0 Alpha D01      NA 20,000_c~         0 1 : Exper~ 20000 HCME~ ECIS      
      10     0 Alpha D02      NA 20,000_c~         0 1 : Exper~ 20000 HCME~ ECIS      
      # i 142,260 more rows
      # i 2 more variables: SampleID <int>, Excluded <chr>

---

    Code
      vascr_edit_sample(growth.df, change_list = list(c("0_cells", "Cell Free")))
    Output
           Time  Unit Well     Value Frequency       Experiment cells     line
      1       0 Alpha  A01        NA         0 1 : Experiment 1 35000 HCMEC D3
      2       0 Alpha  A02        NA         0 1 : Experiment 1 35000 HCMEC D3
      3       0 Alpha  A03        NA         0 1 : Experiment 1 35000 HCMEC D3
      4       0 Alpha  B01        NA         0 1 : Experiment 1 30000 HCMEC D3
      5       0 Alpha  B02        NA         0 1 : Experiment 1 30000 HCMEC D3
      6       0 Alpha  B03        NA         0 1 : Experiment 1 30000 HCMEC D3
      7       0 Alpha  C01        NA         0 1 : Experiment 1 25000 HCMEC D3
      8       0 Alpha  C02        NA         0 1 : Experiment 1 25000 HCMEC D3
      9       0 Alpha  C03        NA         0 1 : Experiment 1 25000 HCMEC D3
      10      0 Alpha  D01        NA         0 1 : Experiment 1 20000 HCMEC D3
      11      0 Alpha  D02        NA         0 1 : Experiment 1 20000 HCMEC D3
      12      0 Alpha  D03        NA         0 1 : Experiment 1 20000 HCMEC D3
      13      0 Alpha  E01        NA         0 1 : Experiment 1 15000 HCMEC D3
      14      0 Alpha  E02        NA         0 1 : Experiment 1 15000 HCMEC D3
      15      0 Alpha  E03        NA         0 1 : Experiment 1 15000 HCMEC D3
      16      0 Alpha  F01        NA         0 1 : Experiment 1 10000 HCMEC D3
      17      0 Alpha  F02        NA         0 1 : Experiment 1 10000 HCMEC D3
      18      0 Alpha  F03        NA         0 1 : Experiment 1 10000 HCMEC D3
      19      0 Alpha  G01        NA         0 1 : Experiment 1  5000 HCMEC D3
      20      0 Alpha  G02        NA         0 1 : Experiment 1  5000 HCMEC D3
      21      0 Alpha  G03        NA         0 1 : Experiment 1  5000 HCMEC D3
      22      0    Cm  A01        NA         0 1 : Experiment 1 35000 HCMEC D3
      23      0    Cm  A02        NA         0 1 : Experiment 1 35000 HCMEC D3
      24      0    Cm  A03        NA         0 1 : Experiment 1 35000 HCMEC D3
      25      0    Cm  B01        NA         0 1 : Experiment 1 30000 HCMEC D3
      26      0    Cm  B02        NA         0 1 : Experiment 1 30000 HCMEC D3
      27      0    Cm  B03        NA         0 1 : Experiment 1 30000 HCMEC D3
      28      0    Cm  C01        NA         0 1 : Experiment 1 25000 HCMEC D3
      29      0    Cm  C02        NA         0 1 : Experiment 1 25000 HCMEC D3
      30      0    Cm  C03        NA         0 1 : Experiment 1 25000 HCMEC D3
      31      0    Cm  D01        NA         0 1 : Experiment 1 20000 HCMEC D3
      32      0    Cm  D02        NA         0 1 : Experiment 1 20000 HCMEC D3
      33      0    Cm  D03        NA         0 1 : Experiment 1 20000 HCMEC D3
      34      0    Cm  E01        NA         0 1 : Experiment 1 15000 HCMEC D3
      35      0    Cm  E02        NA         0 1 : Experiment 1 15000 HCMEC D3
      36      0    Cm  E03        NA         0 1 : Experiment 1 15000 HCMEC D3
      37      0    Cm  F01        NA         0 1 : Experiment 1 10000 HCMEC D3
      38      0    Cm  F02        NA         0 1 : Experiment 1 10000 HCMEC D3
      39      0    Cm  F03        NA         0 1 : Experiment 1 10000 HCMEC D3
      40      0    Cm  G01        NA         0 1 : Experiment 1  5000 HCMEC D3
      41      0    Cm  G02        NA         0 1 : Experiment 1  5000 HCMEC D3
      42      0    Cm  G03        NA         0 1 : Experiment 1  5000 HCMEC D3
      43      0 Drift  A01        NA         0 1 : Experiment 1 35000 HCMEC D3
      44      0 Drift  A02        NA         0 1 : Experiment 1 35000 HCMEC D3
      45      0 Drift  A03        NA         0 1 : Experiment 1 35000 HCMEC D3
      46      0 Drift  B01        NA         0 1 : Experiment 1 30000 HCMEC D3
      47      0 Drift  B02        NA         0 1 : Experiment 1 30000 HCMEC D3
      48      0 Drift  B03        NA         0 1 : Experiment 1 30000 HCMEC D3
      49      0 Drift  C01        NA         0 1 : Experiment 1 25000 HCMEC D3
      50      0 Drift  C02        NA         0 1 : Experiment 1 25000 HCMEC D3
      51      0 Drift  C03        NA         0 1 : Experiment 1 25000 HCMEC D3
      52      0 Drift  D01        NA         0 1 : Experiment 1 20000 HCMEC D3
      53      0 Drift  D02        NA         0 1 : Experiment 1 20000 HCMEC D3
      54      0 Drift  D03        NA         0 1 : Experiment 1 20000 HCMEC D3
      55      0 Drift  E01        NA         0 1 : Experiment 1 15000 HCMEC D3
      56      0 Drift  E02        NA         0 1 : Experiment 1 15000 HCMEC D3
      57      0 Drift  E03        NA         0 1 : Experiment 1 15000 HCMEC D3
      58      0 Drift  F01        NA         0 1 : Experiment 1 10000 HCMEC D3
      59      0 Drift  F02        NA         0 1 : Experiment 1 10000 HCMEC D3
      60      0 Drift  F03        NA         0 1 : Experiment 1 10000 HCMEC D3
      61      0 Drift  G01        NA         0 1 : Experiment 1  5000 HCMEC D3
      62      0 Drift  G02        NA         0 1 : Experiment 1  5000 HCMEC D3
      63      0 Drift  G03        NA         0 1 : Experiment 1  5000 HCMEC D3
      64      0    Rb  A01        NA         0 1 : Experiment 1 35000 HCMEC D3
      65      0    Rb  A02        NA         0 1 : Experiment 1 35000 HCMEC D3
      66      0    Rb  A03        NA         0 1 : Experiment 1 35000 HCMEC D3
      67      0    Rb  B01        NA         0 1 : Experiment 1 30000 HCMEC D3
      68      0    Rb  B02        NA         0 1 : Experiment 1 30000 HCMEC D3
      69      0    Rb  B03        NA         0 1 : Experiment 1 30000 HCMEC D3
      70      0    Rb  C01        NA         0 1 : Experiment 1 25000 HCMEC D3
      71      0    Rb  C02        NA         0 1 : Experiment 1 25000 HCMEC D3
      72      0    Rb  C03        NA         0 1 : Experiment 1 25000 HCMEC D3
      73      0    Rb  D01        NA         0 1 : Experiment 1 20000 HCMEC D3
      74      0    Rb  D02        NA         0 1 : Experiment 1 20000 HCMEC D3
      75      0    Rb  D03        NA         0 1 : Experiment 1 20000 HCMEC D3
      76      0    Rb  E01        NA         0 1 : Experiment 1 15000 HCMEC D3
      77      0    Rb  E02        NA         0 1 : Experiment 1 15000 HCMEC D3
      78      0    Rb  E03        NA         0 1 : Experiment 1 15000 HCMEC D3
      79      0    Rb  F01        NA         0 1 : Experiment 1 10000 HCMEC D3
      80      0    Rb  F02        NA         0 1 : Experiment 1 10000 HCMEC D3
      81      0    Rb  F03        NA         0 1 : Experiment 1 10000 HCMEC D3
      82      0    Rb  G01        NA         0 1 : Experiment 1  5000 HCMEC D3
      83      0    Rb  G02        NA         0 1 : Experiment 1  5000 HCMEC D3
      84      0    Rb  G03        NA         0 1 : Experiment 1  5000 HCMEC D3
      85      0  RMSE  A01        NA         0 1 : Experiment 1 35000 HCMEC D3
      86      0  RMSE  A02        NA         0 1 : Experiment 1 35000 HCMEC D3
      87      0  RMSE  A03        NA         0 1 : Experiment 1 35000 HCMEC D3
      88      0  RMSE  B01        NA         0 1 : Experiment 1 30000 HCMEC D3
      89      0  RMSE  B02        NA         0 1 : Experiment 1 30000 HCMEC D3
      90      0  RMSE  B03        NA         0 1 : Experiment 1 30000 HCMEC D3
      91      0  RMSE  C01        NA         0 1 : Experiment 1 25000 HCMEC D3
      92      0  RMSE  C02        NA         0 1 : Experiment 1 25000 HCMEC D3
      93      0  RMSE  C03        NA         0 1 : Experiment 1 25000 HCMEC D3
      94      0  RMSE  D01        NA         0 1 : Experiment 1 20000 HCMEC D3
      95      0  RMSE  D02        NA         0 1 : Experiment 1 20000 HCMEC D3
      96      0  RMSE  D03        NA         0 1 : Experiment 1 20000 HCMEC D3
      97      0  RMSE  E01        NA         0 1 : Experiment 1 15000 HCMEC D3
      98      0  RMSE  E02        NA         0 1 : Experiment 1 15000 HCMEC D3
      99      0  RMSE  E03        NA         0 1 : Experiment 1 15000 HCMEC D3
      100     0  RMSE  F01        NA         0 1 : Experiment 1 10000 HCMEC D3
      101     0  RMSE  F02        NA         0 1 : Experiment 1 10000 HCMEC D3
      102     0  RMSE  F03        NA         0 1 : Experiment 1 10000 HCMEC D3
      103     0  RMSE  G01        NA         0 1 : Experiment 1  5000 HCMEC D3
      104     0  RMSE  G02        NA         0 1 : Experiment 1  5000 HCMEC D3
      105     0  RMSE  G03        NA         0 1 : Experiment 1  5000 HCMEC D3
      106     5 Alpha  A01   2.69000         0 1 : Experiment 1 35000 HCMEC D3
      107     5 Alpha  A02   2.89000         0 1 : Experiment 1 35000 HCMEC D3
      108     5 Alpha  A03   2.71000         0 1 : Experiment 1 35000 HCMEC D3
      109     5 Alpha  B01   2.52000         0 1 : Experiment 1 30000 HCMEC D3
      110     5 Alpha  B02   2.69000         0 1 : Experiment 1 30000 HCMEC D3
      111     5 Alpha  B03   2.34000         0 1 : Experiment 1 30000 HCMEC D3
      112     5 Alpha  C01   2.15000         0 1 : Experiment 1 25000 HCMEC D3
      113     5 Alpha  C02   2.35000         0 1 : Experiment 1 25000 HCMEC D3
      114     5 Alpha  C03   2.40000         0 1 : Experiment 1 25000 HCMEC D3
      115     5 Alpha  D01   1.85000         0 1 : Experiment 1 20000 HCMEC D3
      116     5 Alpha  D02   2.02000         0 1 : Experiment 1 20000 HCMEC D3
      117     5 Alpha  D03   2.05000         0 1 : Experiment 1 20000 HCMEC D3
      118     5 Alpha  E01   1.54000         0 1 : Experiment 1 15000 HCMEC D3
      119     5 Alpha  E02   1.67000         0 1 : Experiment 1 15000 HCMEC D3
      120     5 Alpha  E03   1.90000         0 1 : Experiment 1 15000 HCMEC D3
      121     5 Alpha  F01   1.34000         0 1 : Experiment 1 10000 HCMEC D3
      122     5 Alpha  F02   0.00000         0 1 : Experiment 1 10000 HCMEC D3
      123     5 Alpha  F03   1.49000         0 1 : Experiment 1 10000 HCMEC D3
      124     5 Alpha  G01   0.86000         0 1 : Experiment 1  5000 HCMEC D3
      125     5 Alpha  G02   0.81000         0 1 : Experiment 1  5000 HCMEC D3
      126     5 Alpha  G03   0.83000         0 1 : Experiment 1  5000 HCMEC D3
      127     5    Cm  A01  37.92000         0 1 : Experiment 1 35000 HCMEC D3
      128     5    Cm  A02  24.99000         0 1 : Experiment 1 35000 HCMEC D3
      129     5    Cm  A03  32.07000         0 1 : Experiment 1 35000 HCMEC D3
      130     5    Cm  B01  35.10000         0 1 : Experiment 1 30000 HCMEC D3
      131     5    Cm  B02  37.68000         0 1 : Experiment 1 30000 HCMEC D3
      132     5    Cm  B03  48.99000         0 1 : Experiment 1 30000 HCMEC D3
      133     5    Cm  C01  53.35000         0 1 : Experiment 1 25000 HCMEC D3
      134     5    Cm  C02  52.07000         0 1 : Experiment 1 25000 HCMEC D3
      135     5    Cm  C03  53.22000         0 1 : Experiment 1 25000 HCMEC D3
      136     5    Cm  D01  85.61000         0 1 : Experiment 1 20000 HCMEC D3
      137     5    Cm  D02  86.11000         0 1 : Experiment 1 20000 HCMEC D3
      138     5    Cm  D03  75.01000         0 1 : Experiment 1 20000 HCMEC D3
      139     5    Cm  E01 105.36000         0 1 : Experiment 1 15000 HCMEC D3
      140     5    Cm  E02 128.54000         0 1 : Experiment 1 15000 HCMEC D3
      141     5    Cm  E03 111.94000         0 1 : Experiment 1 15000 HCMEC D3
      142     5    Cm  F01 166.67000         0 1 : Experiment 1 10000 HCMEC D3
      143     5    Cm  F02 288.68000         0 1 : Experiment 1 10000 HCMEC D3
      144     5    Cm  F03 135.38000         0 1 : Experiment 1 10000 HCMEC D3
      145     5    Cm  G01 483.51000         0 1 : Experiment 1  5000 HCMEC D3
      146     5    Cm  G02 575.87000         0 1 : Experiment 1  5000 HCMEC D3
      147     5    Cm  G03 370.22000         0 1 : Experiment 1  5000 HCMEC D3
      148     5 Drift  A01  -0.94000         0 1 : Experiment 1 35000 HCMEC D3
      149     5 Drift  A02  -1.22000         0 1 : Experiment 1 35000 HCMEC D3
      150     5 Drift  A03  -0.65000         0 1 : Experiment 1 35000 HCMEC D3
      151     5 Drift  B01  -1.21000         0 1 : Experiment 1 30000 HCMEC D3
      152     5 Drift  B02  -1.10000         0 1 : Experiment 1 30000 HCMEC D3
      153     5 Drift  B03  -0.58000         0 1 : Experiment 1 30000 HCMEC D3
      154     5 Drift  C01  -1.26000         0 1 : Experiment 1 25000 HCMEC D3
      155     5 Drift  C02  -1.29000         0 1 : Experiment 1 25000 HCMEC D3
      156     5 Drift  C03  -0.77000         0 1 : Experiment 1 25000 HCMEC D3
      157     5 Drift  D01  -1.11000         0 1 : Experiment 1 20000 HCMEC D3
      158     5 Drift  D02  -1.14000         0 1 : Experiment 1 20000 HCMEC D3
      159     5 Drift  D03  -0.21000         0 1 : Experiment 1 20000 HCMEC D3
      160     5 Drift  E01   0.08000         0 1 : Experiment 1 15000 HCMEC D3
      161     5 Drift  E02   0.09000         0 1 : Experiment 1 15000 HCMEC D3
      162     5 Drift  E03   0.11000         0 1 : Experiment 1 15000 HCMEC D3
      163     5 Drift  F01  -0.01000         0 1 : Experiment 1 10000 HCMEC D3
      164     5 Drift  F02   0.06000         0 1 : Experiment 1 10000 HCMEC D3
      165     5 Drift  F03   0.35000         0 1 : Experiment 1 10000 HCMEC D3
      166     5 Drift  G01  -0.11000         0 1 : Experiment 1  5000 HCMEC D3
      167     5 Drift  G02  -0.01000         0 1 : Experiment 1  5000 HCMEC D3
      168     5 Drift  G03   0.36000         0 1 : Experiment 1  5000 HCMEC D3
      169     5    Rb  A01   0.00000         0 1 : Experiment 1 35000 HCMEC D3
      170     5    Rb  A02   0.00000         0 1 : Experiment 1 35000 HCMEC D3
      171     5    Rb  A03   0.00000         0 1 : Experiment 1 35000 HCMEC D3
      172     5    Rb  B01   0.00000         0 1 : Experiment 1 30000 HCMEC D3
      173     5    Rb  B02   0.00000         0 1 : Experiment 1 30000 HCMEC D3
      174     5    Rb  B03   0.00000         0 1 : Experiment 1 30000 HCMEC D3
      175     5    Rb  C01   0.00000         0 1 : Experiment 1 25000 HCMEC D3
      176     5    Rb  C02   0.00000         0 1 : Experiment 1 25000 HCMEC D3
      177     5    Rb  C03   0.00000         0 1 : Experiment 1 25000 HCMEC D3
      178     5    Rb  D01   0.00000         0 1 : Experiment 1 20000 HCMEC D3
      179     5    Rb  D02   0.00000         0 1 : Experiment 1 20000 HCMEC D3
      180     5    Rb  D03   0.00000         0 1 : Experiment 1 20000 HCMEC D3
      181     5    Rb  E01   0.00000         0 1 : Experiment 1 15000 HCMEC D3
      182     5    Rb  E02   0.00000         0 1 : Experiment 1 15000 HCMEC D3
      183     5    Rb  E03   0.00000         0 1 : Experiment 1 15000 HCMEC D3
      184     5    Rb  F01   0.00000         0 1 : Experiment 1 10000 HCMEC D3
      185     5    Rb  F02   0.00000         0 1 : Experiment 1 10000 HCMEC D3
      186     5    Rb  F03   0.00000         0 1 : Experiment 1 10000 HCMEC D3
      187     5    Rb  G01   0.00000         0 1 : Experiment 1  5000 HCMEC D3
      188     5    Rb  G02   0.01000         0 1 : Experiment 1  5000 HCMEC D3
      189     5    Rb  G03   0.00000         0 1 : Experiment 1  5000 HCMEC D3
      190     5  RMSE  A01   0.01000         0 1 : Experiment 1 35000 HCMEC D3
      191     5  RMSE  A02   0.02000         0 1 : Experiment 1 35000 HCMEC D3
      192     5  RMSE  A03   0.02000         0 1 : Experiment 1 35000 HCMEC D3
      193     5  RMSE  B01   0.02000         0 1 : Experiment 1 30000 HCMEC D3
      194     5  RMSE  B02   0.01000         0 1 : Experiment 1 30000 HCMEC D3
      195     5  RMSE  B03   0.01000         0 1 : Experiment 1 30000 HCMEC D3
      196     5  RMSE  C01   0.01000         0 1 : Experiment 1 25000 HCMEC D3
      197     5  RMSE  C02   0.01000         0 1 : Experiment 1 25000 HCMEC D3
      198     5  RMSE  C03   0.01000         0 1 : Experiment 1 25000 HCMEC D3
      199     5  RMSE  D01   0.01000         0 1 : Experiment 1 20000 HCMEC D3
      200     5  RMSE  D02   0.01000         0 1 : Experiment 1 20000 HCMEC D3
      201     5  RMSE  D03   0.01000         0 1 : Experiment 1 20000 HCMEC D3
      202     5  RMSE  E01   0.01000         0 1 : Experiment 1 15000 HCMEC D3
      203     5  RMSE  E02   0.01000         0 1 : Experiment 1 15000 HCMEC D3
      204     5  RMSE  E03   0.01000         0 1 : Experiment 1 15000 HCMEC D3
      205     5  RMSE  F01   0.01000         0 1 : Experiment 1 10000 HCMEC D3
      206     5  RMSE  F02   0.02000         0 1 : Experiment 1 10000 HCMEC D3
      207     5  RMSE  F03   0.01000         0 1 : Experiment 1 10000 HCMEC D3
      208     5  RMSE  G01   0.00000         0 1 : Experiment 1  5000 HCMEC D3
      209     5  RMSE  G02   0.00000         0 1 : Experiment 1  5000 HCMEC D3
      210     5  RMSE  G03   0.00000         0 1 : Experiment 1  5000 HCMEC D3
      211    10 Alpha  A01   3.34000         0 1 : Experiment 1 35000 HCMEC D3
      212    10 Alpha  A02   3.77000         0 1 : Experiment 1 35000 HCMEC D3
      213    10 Alpha  A03   3.25000         0 1 : Experiment 1 35000 HCMEC D3
      214    10 Alpha  B01   3.15000         0 1 : Experiment 1 30000 HCMEC D3
      215    10 Alpha  B02   3.40000         0 1 : Experiment 1 30000 HCMEC D3
      216    10 Alpha  B03   2.89000         0 1 : Experiment 1 30000 HCMEC D3
      217    10 Alpha  C01   2.71000         0 1 : Experiment 1 25000 HCMEC D3
      218    10 Alpha  C02   2.88000         0 1 : Experiment 1 25000 HCMEC D3
      219    10 Alpha  C03   2.83000         0 1 : Experiment 1 25000 HCMEC D3
      220    10 Alpha  D01   2.27000         0 1 : Experiment 1 20000 HCMEC D3
      221    10 Alpha  D02   2.52000         0 1 : Experiment 1 20000 HCMEC D3
      222    10 Alpha  D03   2.56000         0 1 : Experiment 1 20000 HCMEC D3
      223    10 Alpha  E01   1.89000         0 1 : Experiment 1 15000 HCMEC D3
      224    10 Alpha  E02   2.01000         0 1 : Experiment 1 15000 HCMEC D3
      225    10 Alpha  E03   2.26000         0 1 : Experiment 1 15000 HCMEC D3
      226    10 Alpha  F01   1.66000         0 1 : Experiment 1 10000 HCMEC D3
      227    10 Alpha  F02   1.58000         0 1 : Experiment 1 10000 HCMEC D3
      228    10 Alpha  F03   1.81000         0 1 : Experiment 1 10000 HCMEC D3
      229    10 Alpha  G01   0.12000         0 1 : Experiment 1  5000 HCMEC D3
      230    10 Alpha  G02   0.99000         0 1 : Experiment 1  5000 HCMEC D3
      231    10 Alpha  G03   1.07000         0 1 : Experiment 1  5000 HCMEC D3
      232    10    Cm  A01  18.81000         0 1 : Experiment 1 35000 HCMEC D3
      233    10    Cm  A02  10.18000         0 1 : Experiment 1 35000 HCMEC D3
      234    10    Cm  A03  17.32000         0 1 : Experiment 1 35000 HCMEC D3
      235    10    Cm  B01  17.67000         0 1 : Experiment 1 30000 HCMEC D3
      236    10    Cm  B02  18.12000         0 1 : Experiment 1 30000 HCMEC D3
      237    10    Cm  B03  27.73000         0 1 : Experiment 1 30000 HCMEC D3
      238    10    Cm  C01  29.00000         0 1 : Experiment 1 25000 HCMEC D3
      239    10    Cm  C02  28.21000         0 1 : Experiment 1 25000 HCMEC D3
      240    10    Cm  C03  32.41000         0 1 : Experiment 1 25000 HCMEC D3
      241    10    Cm  D01  50.82000         0 1 : Experiment 1 20000 HCMEC D3
      242    10    Cm  D02  49.00000         0 1 : Experiment 1 20000 HCMEC D3
      243    10    Cm  D03  44.11000         0 1 : Experiment 1 20000 HCMEC D3
      244    10    Cm  E01  66.01000         0 1 : Experiment 1 15000 HCMEC D3
      245    10    Cm  E02  80.91000         0 1 : Experiment 1 15000 HCMEC D3
      246    10    Cm  E03  72.87000         0 1 : Experiment 1 15000 HCMEC D3
      247    10    Cm  F01  99.81000         0 1 : Experiment 1 10000 HCMEC D3
      248    10    Cm  F02 137.38000         0 1 : Experiment 1 10000 HCMEC D3
      249    10    Cm  F03  88.22000         0 1 : Experiment 1 10000 HCMEC D3
      250    10    Cm  G01 420.13000         0 1 : Experiment 1  5000 HCMEC D3
      251    10    Cm  G02 350.01000         0 1 : Experiment 1  5000 HCMEC D3
      252    10    Cm  G03 233.36000         0 1 : Experiment 1  5000 HCMEC D3
      253    10 Drift  A01  -1.82000         0 1 : Experiment 1 35000 HCMEC D3
      254    10 Drift  A02  -2.30000         0 1 : Experiment 1 35000 HCMEC D3
      255    10 Drift  A03  -1.59000         0 1 : Experiment 1 35000 HCMEC D3
      256    10 Drift  B01  -2.10000         0 1 : Experiment 1 30000 HCMEC D3
      257    10 Drift  B02  -2.16000         0 1 : Experiment 1 30000 HCMEC D3
      258    10 Drift  B03  -1.48000         0 1 : Experiment 1 30000 HCMEC D3
      259    10 Drift  C01  -2.12000         0 1 : Experiment 1 25000 HCMEC D3
      260    10 Drift  C02  -2.18000         0 1 : Experiment 1 25000 HCMEC D3
      261    10 Drift  C03  -1.62000         0 1 : Experiment 1 25000 HCMEC D3
      262    10 Drift  D01  -1.80000         0 1 : Experiment 1 20000 HCMEC D3
      263    10 Drift  D02  -1.99000         0 1 : Experiment 1 20000 HCMEC D3
      264    10 Drift  D03  -1.03000         0 1 : Experiment 1 20000 HCMEC D3
      265    10 Drift  E01  -0.50000         0 1 : Experiment 1 15000 HCMEC D3
      266    10 Drift  E02  -0.57000         0 1 : Experiment 1 15000 HCMEC D3
      267    10 Drift  E03  -0.53000         0 1 : Experiment 1 15000 HCMEC D3
      268    10 Drift  F01  -0.47000         0 1 : Experiment 1 10000 HCMEC D3
      269    10 Drift  F02  -0.43000         0 1 : Experiment 1 10000 HCMEC D3
      270    10 Drift  F03  -0.18000         0 1 : Experiment 1 10000 HCMEC D3
      271    10 Drift  G01  -0.33000         0 1 : Experiment 1  5000 HCMEC D3
      272    10 Drift  G02  -0.30000         0 1 : Experiment 1  5000 HCMEC D3
      273    10 Drift  G03   0.07000         0 1 : Experiment 1  5000 HCMEC D3
      274    10    Rb  A01   0.00000         0 1 : Experiment 1 35000 HCMEC D3
      275    10    Rb  A02   0.00000         0 1 : Experiment 1 35000 HCMEC D3
      276    10    Rb  A03   0.00000         0 1 : Experiment 1 35000 HCMEC D3
      277    10    Rb  B01   0.00000         0 1 : Experiment 1 30000 HCMEC D3
      278    10    Rb  B02   0.00000         0 1 : Experiment 1 30000 HCMEC D3
      279    10    Rb  B03   0.00000         0 1 : Experiment 1 30000 HCMEC D3
      280    10    Rb  C01   0.00000         0 1 : Experiment 1 25000 HCMEC D3
      281    10    Rb  C02   0.00000         0 1 : Experiment 1 25000 HCMEC D3
      282    10    Rb  C03   0.00000         0 1 : Experiment 1 25000 HCMEC D3
      283    10    Rb  D01   0.00000         0 1 : Experiment 1 20000 HCMEC D3
      284    10    Rb  D02   0.00000         0 1 : Experiment 1 20000 HCMEC D3
      285    10    Rb  D03   0.00000         0 1 : Experiment 1 20000 HCMEC D3
      286    10    Rb  E01   0.00000         0 1 : Experiment 1 15000 HCMEC D3
      287    10    Rb  E02   0.00000         0 1 : Experiment 1 15000 HCMEC D3
      288    10    Rb  E03   0.00000         0 1 : Experiment 1 15000 HCMEC D3
      289    10    Rb  F01   0.00000         0 1 : Experiment 1 10000 HCMEC D3
      290    10    Rb  F02   0.00000         0 1 : Experiment 1 10000 HCMEC D3
      291    10    Rb  F03   0.00000         0 1 : Experiment 1 10000 HCMEC D3
      292    10    Rb  G01   0.13000         0 1 : Experiment 1  5000 HCMEC D3
      293    10    Rb  G02   0.00000         0 1 : Experiment 1  5000 HCMEC D3
      294    10    Rb  G03   0.00000         0 1 : Experiment 1  5000 HCMEC D3
      295    10  RMSE  A01   0.02000         0 1 : Experiment 1 35000 HCMEC D3
      296    10  RMSE  A02   0.03000         0 1 : Experiment 1 35000 HCMEC D3
      297    10  RMSE  A03   0.02000         0 1 : Experiment 1 35000 HCMEC D3
      298    10  RMSE  B01   0.03000         0 1 : Experiment 1 30000 HCMEC D3
      299    10  RMSE  B02   0.02000         0 1 : Experiment 1 30000 HCMEC D3
      300    10  RMSE  B03   0.02000         0 1 : Experiment 1 30000 HCMEC D3
      301    10  RMSE  C01   0.02000         0 1 : Experiment 1 25000 HCMEC D3
      302    10  RMSE  C02   0.02000         0 1 : Experiment 1 25000 HCMEC D3
      303    10  RMSE  C03   0.02000         0 1 : Experiment 1 25000 HCMEC D3
      304    10  RMSE  D01   0.02000         0 1 : Experiment 1 20000 HCMEC D3
      305    10  RMSE  D02   0.01000         0 1 : Experiment 1 20000 HCMEC D3
      306    10  RMSE  D03   0.02000         0 1 : Experiment 1 20000 HCMEC D3
      307    10  RMSE  E01   0.01000         0 1 : Experiment 1 15000 HCMEC D3
      308    10  RMSE  E02   0.01000         0 1 : Experiment 1 15000 HCMEC D3
      309    10  RMSE  E03   0.01000         0 1 : Experiment 1 15000 HCMEC D3
      310    10  RMSE  F01   0.01000         0 1 : Experiment 1 10000 HCMEC D3
      311    10  RMSE  F02   0.01000         0 1 : Experiment 1 10000 HCMEC D3
      312    10  RMSE  F03   0.01000         0 1 : Experiment 1 10000 HCMEC D3
      313    10  RMSE  G01   0.00000         0 1 : Experiment 1  5000 HCMEC D3
      314    10  RMSE  G02   0.00000         0 1 : Experiment 1  5000 HCMEC D3
      315    10  RMSE  G03   0.00000         0 1 : Experiment 1  5000 HCMEC D3
      316    15 Alpha  A01   4.17000         0 1 : Experiment 1 35000 HCMEC D3
      317    15 Alpha  A02   4.65000         0 1 : Experiment 1 35000 HCMEC D3
      318    15 Alpha  A03   4.05000         0 1 : Experiment 1 35000 HCMEC D3
      319    15 Alpha  B01   3.95000         0 1 : Experiment 1 30000 HCMEC D3
      320    15 Alpha  B02   4.12000         0 1 : Experiment 1 30000 HCMEC D3
      321    15 Alpha  B03   3.56000         0 1 : Experiment 1 30000 HCMEC D3
      322    15 Alpha  C01   3.33000         0 1 : Experiment 1 25000 HCMEC D3
      323    15 Alpha  C02   3.53000         0 1 : Experiment 1 25000 HCMEC D3
      324    15 Alpha  C03   3.33000         0 1 : Experiment 1 25000 HCMEC D3
      325    15 Alpha  D01   2.79000         0 1 : Experiment 1 20000 HCMEC D3
      326    15 Alpha  D02   3.00000         0 1 : Experiment 1 20000 HCMEC D3
      327    15 Alpha  D03   3.04000         0 1 : Experiment 1 20000 HCMEC D3
      328    15 Alpha  E01   2.40000         0 1 : Experiment 1 15000 HCMEC D3
      329    15 Alpha  E02   2.49000         0 1 : Experiment 1 15000 HCMEC D3
      330    15 Alpha  E03   2.68000         0 1 : Experiment 1 15000 HCMEC D3
      331    15 Alpha  F01   2.13000         0 1 : Experiment 1 10000 HCMEC D3
      332    15 Alpha  F02   1.90000         0 1 : Experiment 1 10000 HCMEC D3
      333    15 Alpha  F03   2.20000         0 1 : Experiment 1 10000 HCMEC D3
      334    15 Alpha  G01   0.00000         0 1 : Experiment 1  5000 HCMEC D3
      335    15 Alpha  G02   0.00000         0 1 : Experiment 1  5000 HCMEC D3
      336    15 Alpha  G03   1.31000         0 1 : Experiment 1  5000 HCMEC D3
      337    15    Cm  A01   8.72000         0 1 : Experiment 1 35000 HCMEC D3
      338    15    Cm  A02   4.23000         0 1 : Experiment 1 35000 HCMEC D3
      339    15    Cm  A03   8.21000         0 1 : Experiment 1 35000 HCMEC D3
      340    15    Cm  B01   8.69000         0 1 : Experiment 1 30000 HCMEC D3
      341    15    Cm  B02   8.76000         0 1 : Experiment 1 30000 HCMEC D3
      342    15    Cm  B03  15.63000         0 1 : Experiment 1 30000 HCMEC D3
      343    15    Cm  C01  16.50000         0 1 : Experiment 1 25000 HCMEC D3
      344    15    Cm  C02  15.67000         0 1 : Experiment 1 25000 HCMEC D3
      345    15    Cm  C03  20.39000         0 1 : Experiment 1 25000 HCMEC D3
      346    15    Cm  D01  30.31000         0 1 : Experiment 1 20000 HCMEC D3
      347    15    Cm  D02  28.81000         0 1 : Experiment 1 20000 HCMEC D3
      348    15    Cm  D03  27.52000         0 1 : Experiment 1 20000 HCMEC D3
      349    15    Cm  E01  42.55000         0 1 : Experiment 1 15000 HCMEC D3
      350    15    Cm  E02  50.91000         0 1 : Experiment 1 15000 HCMEC D3
      351    15    Cm  E03  45.32000         0 1 : Experiment 1 15000 HCMEC D3
      352    15    Cm  F01  59.93000         0 1 : Experiment 1 10000 HCMEC D3
      353    15    Cm  F02  89.04000         0 1 : Experiment 1 10000 HCMEC D3
      354    15    Cm  F03  54.78000         0 1 : Experiment 1 10000 HCMEC D3
      355    15    Cm  G01 278.45000         0 1 : Experiment 1  5000 HCMEC D3
      356    15    Cm  G02 316.14000         0 1 : Experiment 1  5000 HCMEC D3
      357    15    Cm  G03 153.02000         0 1 : Experiment 1  5000 HCMEC D3
      358    15 Drift  A01  -2.72000         0 1 : Experiment 1 35000 HCMEC D3
      359    15 Drift  A02  -3.20000         0 1 : Experiment 1 35000 HCMEC D3
      360    15 Drift  A03  -2.59000         0 1 : Experiment 1 35000 HCMEC D3
      361    15 Drift  B01  -3.04000         0 1 : Experiment 1 30000 HCMEC D3
      362    15 Drift  B02  -3.06000         0 1 : Experiment 1 30000 HCMEC D3
      363    15 Drift  B03  -2.37000         0 1 : Experiment 1 30000 HCMEC D3
      364    15 Drift  C01  -2.97000         0 1 : Experiment 1 25000 HCMEC D3
      365    15 Drift  C02  -3.08000         0 1 : Experiment 1 25000 HCMEC D3
      366    15 Drift  C03  -2.45000         0 1 : Experiment 1 25000 HCMEC D3
      367    15 Drift  D01  -2.62000         0 1 : Experiment 1 20000 HCMEC D3
      368    15 Drift  D02  -2.87000         0 1 : Experiment 1 20000 HCMEC D3
      369    15 Drift  D03  -1.84000         0 1 : Experiment 1 20000 HCMEC D3
      370    15 Drift  E01  -1.25000         0 1 : Experiment 1 15000 HCMEC D3
      371    15 Drift  E02  -1.27000         0 1 : Experiment 1 15000 HCMEC D3
      372    15 Drift  E03  -1.29000         0 1 : Experiment 1 15000 HCMEC D3
      373    15 Drift  F01  -1.08000         0 1 : Experiment 1 10000 HCMEC D3
      374    15 Drift  F02  -0.97000         0 1 : Experiment 1 10000 HCMEC D3
      375    15 Drift  F03  -0.72000         0 1 : Experiment 1 10000 HCMEC D3
      376    15 Drift  G01  -0.64000         0 1 : Experiment 1  5000 HCMEC D3
      377    15 Drift  G02  -0.61000         0 1 : Experiment 1  5000 HCMEC D3
      378    15 Drift  G03  -0.26000         0 1 : Experiment 1  5000 HCMEC D3
      379    15    Rb  A01   0.00000         0 1 : Experiment 1 35000 HCMEC D3
      380    15    Rb  A02   0.00000         0 1 : Experiment 1 35000 HCMEC D3
      381    15    Rb  A03   0.00000         0 1 : Experiment 1 35000 HCMEC D3
      382    15    Rb  B01   0.00000         0 1 : Experiment 1 30000 HCMEC D3
      383    15    Rb  B02   0.00000         0 1 : Experiment 1 30000 HCMEC D3
      384    15    Rb  B03   0.00000         0 1 : Experiment 1 30000 HCMEC D3
      385    15    Rb  C01   0.00000         0 1 : Experiment 1 25000 HCMEC D3
      386    15    Rb  C02   0.00000         0 1 : Experiment 1 25000 HCMEC D3
      387    15    Rb  C03   0.00000         0 1 : Experiment 1 25000 HCMEC D3
      388    15    Rb  D01   0.00000         0 1 : Experiment 1 20000 HCMEC D3
      389    15    Rb  D02   0.00000         0 1 : Experiment 1 20000 HCMEC D3
      390    15    Rb  D03   0.00000         0 1 : Experiment 1 20000 HCMEC D3
      391    15    Rb  E01   0.00000         0 1 : Experiment 1 15000 HCMEC D3
      392    15    Rb  E02   0.00000         0 1 : Experiment 1 15000 HCMEC D3
      393    15    Rb  E03   0.00000         0 1 : Experiment 1 15000 HCMEC D3
      394    15    Rb  F01   0.00000         0 1 : Experiment 1 10000 HCMEC D3
      395    15    Rb  F02   0.00000         0 1 : Experiment 1 10000 HCMEC D3
      396    15    Rb  F03   0.00000         0 1 : Experiment 1 10000 HCMEC D3
      397    15    Rb  G01   0.00000         0 1 : Experiment 1  5000 HCMEC D3
      398    15    Rb  G02   0.00000         0 1 : Experiment 1  5000 HCMEC D3
      399    15    Rb  G03   0.00000         0 1 : Experiment 1  5000 HCMEC D3
      400    15  RMSE  A01   0.02000         0 1 : Experiment 1 35000 HCMEC D3
      401    15  RMSE  A02   0.02000         0 1 : Experiment 1 35000 HCMEC D3
      402    15  RMSE  A03   0.03000         0 1 : Experiment 1 35000 HCMEC D3
      403    15  RMSE  B01   0.03000         0 1 : Experiment 1 30000 HCMEC D3
      404    15  RMSE  B02   0.03000         0 1 : Experiment 1 30000 HCMEC D3
      405    15  RMSE  B03   0.03000         0 1 : Experiment 1 30000 HCMEC D3
      406    15  RMSE  C01   0.03000         0 1 : Experiment 1 25000 HCMEC D3
      407    15  RMSE  C02   0.03000         0 1 : Experiment 1 25000 HCMEC D3
      408    15  RMSE  C03   0.02000         0 1 : Experiment 1 25000 HCMEC D3
      409    15  RMSE  D01   0.03000         0 1 : Experiment 1 20000 HCMEC D3
      410    15  RMSE  D02   0.02000         0 1 : Experiment 1 20000 HCMEC D3
      411    15  RMSE  D03   0.02000         0 1 : Experiment 1 20000 HCMEC D3
      412    15  RMSE  E01   0.02000         0 1 : Experiment 1 15000 HCMEC D3
      413    15  RMSE  E02   0.02000         0 1 : Experiment 1 15000 HCMEC D3
      414    15  RMSE  E03   0.02000         0 1 : Experiment 1 15000 HCMEC D3
      415    15  RMSE  F01   0.02000         0 1 : Experiment 1 10000 HCMEC D3
      416    15  RMSE  F02   0.01000         0 1 : Experiment 1 10000 HCMEC D3
      417    15  RMSE  F03   0.02000         0 1 : Experiment 1 10000 HCMEC D3
      418    15  RMSE  G01   0.02000         0 1 : Experiment 1  5000 HCMEC D3
      419    15  RMSE  G02   0.02000         0 1 : Experiment 1  5000 HCMEC D3
      420    15  RMSE  G03   0.01000         0 1 : Experiment 1  5000 HCMEC D3
      421    20 Alpha  A01   4.85000         0 1 : Experiment 1 35000 HCMEC D3
      422    20 Alpha  A02   5.30000         0 1 : Experiment 1 35000 HCMEC D3
      423    20 Alpha  A03   4.65000         0 1 : Experiment 1 35000 HCMEC D3
      424    20 Alpha  B01   4.68000         0 1 : Experiment 1 30000 HCMEC D3
      425    20 Alpha  B02   4.77000         0 1 : Experiment 1 30000 HCMEC D3
      426    20 Alpha  B03   4.08000         0 1 : Experiment 1 30000 HCMEC D3
      427    20 Alpha  C01   3.96000         0 1 : Experiment 1 25000 HCMEC D3
      428    20 Alpha  C02   4.00000         0 1 : Experiment 1 25000 HCMEC D3
      429    20 Alpha  C03   3.81000         0 1 : Experiment 1 25000 HCMEC D3
      430    20 Alpha  D01   3.29000         0 1 : Experiment 1 20000 HCMEC D3
      431    20 Alpha  D02   3.45000         0 1 : Experiment 1 20000 HCMEC D3
      432    20 Alpha  D03   3.38000         0 1 : Experiment 1 20000 HCMEC D3
      433    20 Alpha  E01   2.76000         0 1 : Experiment 1 15000 HCMEC D3
      434    20 Alpha  E02   2.82000         0 1 : Experiment 1 15000 HCMEC D3
      435    20 Alpha  E03   2.99000         0 1 : Experiment 1 15000 HCMEC D3
      436    20 Alpha  F01   2.47000         0 1 : Experiment 1 10000 HCMEC D3
      437    20 Alpha  F02   2.23000         0 1 : Experiment 1 10000 HCMEC D3
      438    20 Alpha  F03   2.52000         0 1 : Experiment 1 10000 HCMEC D3
      439    20 Alpha  G01   1.48000         0 1 : Experiment 1  5000 HCMEC D3
      440    20 Alpha  G02   1.38000         0 1 : Experiment 1  5000 HCMEC D3
      441    20 Alpha  G03   1.42000         0 1 : Experiment 1  5000 HCMEC D3
      442    20    Cm  A01   4.49000         0 1 : Experiment 1 35000 HCMEC D3
      443    20    Cm  A02   2.04000         0 1 : Experiment 1 35000 HCMEC D3
      444    20    Cm  A03   4.65000         0 1 : Experiment 1 35000 HCMEC D3
      445    20    Cm  B01   4.48000         0 1 : Experiment 1 30000 HCMEC D3
      446    20    Cm  B02   4.45000         0 1 : Experiment 1 30000 HCMEC D3
      447    20    Cm  B03   9.21000         0 1 : Experiment 1 30000 HCMEC D3
      448    20    Cm  C01  10.13000         0 1 : Experiment 1 25000 HCMEC D3
      449    20    Cm  C02   9.67000         0 1 : Experiment 1 25000 HCMEC D3
      450    20    Cm  C03  12.95000         0 1 : Experiment 1 25000 HCMEC D3
      451    20    Cm  D01  20.30000         0 1 : Experiment 1 20000 HCMEC D3
      452    20    Cm  D02  18.87000         0 1 : Experiment 1 20000 HCMEC D3
      453    20    Cm  D03  18.58000         0 1 : Experiment 1 20000 HCMEC D3
      454    20    Cm  E01  29.63000         0 1 : Experiment 1 15000 HCMEC D3
      455    20    Cm  E02  34.32000         0 1 : Experiment 1 15000 HCMEC D3
      456    20    Cm  E03  32.26000         0 1 : Experiment 1 15000 HCMEC D3
      457    20    Cm  F01  41.72000         0 1 : Experiment 1 10000 HCMEC D3
      458    20    Cm  F02  63.88000         0 1 : Experiment 1 10000 HCMEC D3
      459    20    Cm  F03  40.67000         0 1 : Experiment 1 10000 HCMEC D3
      460    20    Cm  G01 156.28000         0 1 : Experiment 1  5000 HCMEC D3
      461    20    Cm  G02 177.70000         0 1 : Experiment 1  5000 HCMEC D3
      462    20    Cm  G03 111.97000         0 1 : Experiment 1  5000 HCMEC D3
      463    20 Drift  A01  -3.39000         0 1 : Experiment 1 35000 HCMEC D3
      464    20 Drift  A02  -3.78000         0 1 : Experiment 1 35000 HCMEC D3
      465    20 Drift  A03  -3.19000         0 1 : Experiment 1 35000 HCMEC D3
      466    20 Drift  B01  -3.72000         0 1 : Experiment 1 30000 HCMEC D3
      467    20 Drift  B02  -3.74000         0 1 : Experiment 1 30000 HCMEC D3
      468    20 Drift  B03  -3.10000         0 1 : Experiment 1 30000 HCMEC D3
      469    20 Drift  C01  -3.72000         0 1 : Experiment 1 25000 HCMEC D3
      470    20 Drift  C02  -3.80000         0 1 : Experiment 1 25000 HCMEC D3
      471    20 Drift  C03  -3.15000         0 1 : Experiment 1 25000 HCMEC D3
      472    20 Drift  D01  -3.32000         0 1 : Experiment 1 20000 HCMEC D3
      473    20 Drift  D02  -3.52000         0 1 : Experiment 1 20000 HCMEC D3
      474    20 Drift  D03  -2.50000         0 1 : Experiment 1 20000 HCMEC D3
      475    20 Drift  E01  -1.81000         0 1 : Experiment 1 15000 HCMEC D3
      476    20 Drift  E02  -1.92000         0 1 : Experiment 1 15000 HCMEC D3
      477    20 Drift  E03  -1.88000         0 1 : Experiment 1 15000 HCMEC D3
      478    20 Drift  F01  -1.64000         0 1 : Experiment 1 10000 HCMEC D3
      479    20 Drift  F02  -1.52000         0 1 : Experiment 1 10000 HCMEC D3
      480    20 Drift  F03  -1.20000         0 1 : Experiment 1 10000 HCMEC D3
      481    20 Drift  G01  -0.96000         0 1 : Experiment 1  5000 HCMEC D3
      482    20 Drift  G02  -0.95000         0 1 : Experiment 1  5000 HCMEC D3
      483    20 Drift  G03  -0.56000         0 1 : Experiment 1  5000 HCMEC D3
      484    20    Rb  A01   0.00000         0 1 : Experiment 1 35000 HCMEC D3
      485    20    Rb  A02   0.01000         0 1 : Experiment 1 35000 HCMEC D3
      486    20    Rb  A03   0.00000         0 1 : Experiment 1 35000 HCMEC D3
      487    20    Rb  B01   0.00000         0 1 : Experiment 1 30000 HCMEC D3
      488    20    Rb  B02   0.00000         0 1 : Experiment 1 30000 HCMEC D3
      489    20    Rb  B03   0.00000         0 1 : Experiment 1 30000 HCMEC D3
      490    20    Rb  C01   0.00000         0 1 : Experiment 1 25000 HCMEC D3
      491    20    Rb  C02   0.00000         0 1 : Experiment 1 25000 HCMEC D3
      492    20    Rb  C03   0.00000         0 1 : Experiment 1 25000 HCMEC D3
      493    20    Rb  D01   0.00000         0 1 : Experiment 1 20000 HCMEC D3
      494    20    Rb  D02   0.00000         0 1 : Experiment 1 20000 HCMEC D3
      495    20    Rb  D03   0.00000         0 1 : Experiment 1 20000 HCMEC D3
      496    20    Rb  E01   0.00000         0 1 : Experiment 1 15000 HCMEC D3
      497    20    Rb  E02   0.00000         0 1 : Experiment 1 15000 HCMEC D3
      498    20    Rb  E03   0.00000         0 1 : Experiment 1 15000 HCMEC D3
      499    20    Rb  F01   0.00000         0 1 : Experiment 1 10000 HCMEC D3
      500    20    Rb  F02   0.00000         0 1 : Experiment 1 10000 HCMEC D3
      501    20    Rb  F03   0.00000         0 1 : Experiment 1 10000 HCMEC D3
      502    20    Rb  G01   0.00000         0 1 : Experiment 1  5000 HCMEC D3
      503    20    Rb  G02   0.00000         0 1 : Experiment 1  5000 HCMEC D3
      504    20    Rb  G03   0.00000         0 1 : Experiment 1  5000 HCMEC D3
      505    20  RMSE  A01   0.02000         0 1 : Experiment 1 35000 HCMEC D3
      506    20  RMSE  A02   0.01000         0 1 : Experiment 1 35000 HCMEC D3
      507    20  RMSE  A03   0.02000         0 1 : Experiment 1 35000 HCMEC D3
      508    20  RMSE  B01   0.03000         0 1 : Experiment 1 30000 HCMEC D3
      509    20  RMSE  B02   0.03000         0 1 : Experiment 1 30000 HCMEC D3
      510    20  RMSE  B03   0.03000         0 1 : Experiment 1 30000 HCMEC D3
      511    20  RMSE  C01   0.04000         0 1 : Experiment 1 25000 HCMEC D3
      512    20  RMSE  C02   0.03000         0 1 : Experiment 1 25000 HCMEC D3
      513    20  RMSE  C03   0.03000         0 1 : Experiment 1 25000 HCMEC D3
      514    20  RMSE  D01   0.03000         0 1 : Experiment 1 20000 HCMEC D3
      515    20  RMSE  D02   0.03000         0 1 : Experiment 1 20000 HCMEC D3
      516    20  RMSE  D03   0.03000         0 1 : Experiment 1 20000 HCMEC D3
      517    20  RMSE  E01   0.03000         0 1 : Experiment 1 15000 HCMEC D3
      518    20  RMSE  E02   0.02000         0 1 : Experiment 1 15000 HCMEC D3
      519    20  RMSE  E03   0.02000         0 1 : Experiment 1 15000 HCMEC D3
      520    20  RMSE  F01   0.02000         0 1 : Experiment 1 10000 HCMEC D3
      521    20  RMSE  F02   0.02000         0 1 : Experiment 1 10000 HCMEC D3
      522    20  RMSE  F03   0.02000         0 1 : Experiment 1 10000 HCMEC D3
      523    20  RMSE  G01   0.01000         0 1 : Experiment 1  5000 HCMEC D3
      524    20  RMSE  G02   0.01000         0 1 : Experiment 1  5000 HCMEC D3
      525    20  RMSE  G03   0.01000         0 1 : Experiment 1  5000 HCMEC D3
      526    25 Alpha  A01   5.31000         0 1 : Experiment 1 35000 HCMEC D3
      527    25 Alpha  A02   5.32000         0 1 : Experiment 1 35000 HCMEC D3
      528    25 Alpha  A03   5.17000         0 1 : Experiment 1 35000 HCMEC D3
      529    25 Alpha  B01   5.10000         0 1 : Experiment 1 30000 HCMEC D3
      530    25 Alpha  B02   5.21000         0 1 : Experiment 1 30000 HCMEC D3
      531    25 Alpha  B03   4.59000         0 1 : Experiment 1 30000 HCMEC D3
      532    25 Alpha  C01   4.38000         0 1 : Experiment 1 25000 HCMEC D3
      533    25 Alpha  C02   4.46000         0 1 : Experiment 1 25000 HCMEC D3
      534    25 Alpha  C03   4.18000         0 1 : Experiment 1 25000 HCMEC D3
      535    25 Alpha  D01   3.69000         0 1 : Experiment 1 20000 HCMEC D3
      536    25 Alpha  D02   3.82000         0 1 : Experiment 1 20000 HCMEC D3
      537    25 Alpha  D03   3.74000         0 1 : Experiment 1 20000 HCMEC D3
      538    25 Alpha  E01   3.15000         0 1 : Experiment 1 15000 HCMEC D3
      539    25 Alpha  E02   3.22000         0 1 : Experiment 1 15000 HCMEC D3
      540    25 Alpha  E03   3.26000         0 1 : Experiment 1 15000 HCMEC D3
      541    25 Alpha  F01   2.73000         0 1 : Experiment 1 10000 HCMEC D3
      542    25 Alpha  F02   2.59000         0 1 : Experiment 1 10000 HCMEC D3
      543    25 Alpha  F03   2.72000         0 1 : Experiment 1 10000 HCMEC D3
      544    25 Alpha  G01   1.65000         0 1 : Experiment 1  5000 HCMEC D3
      545    25 Alpha  G02   1.50000         0 1 : Experiment 1  5000 HCMEC D3
      546    25 Alpha  G03   0.00000         0 1 : Experiment 1  5000 HCMEC D3
      547    25    Cm  A01   2.79000         0 1 : Experiment 1 35000 HCMEC D3
      548    25    Cm  A02   1.97000         0 1 : Experiment 1 35000 HCMEC D3
      549    25    Cm  A03   2.92000         0 1 : Experiment 1 35000 HCMEC D3
      550    25    Cm  B01   2.77000         0 1 : Experiment 1 30000 HCMEC D3
      551    25    Cm  B02   2.88000         0 1 : Experiment 1 30000 HCMEC D3
      552    25    Cm  B03   5.59000         0 1 : Experiment 1 30000 HCMEC D3
      553    25    Cm  C01   6.99000         0 1 : Experiment 1 25000 HCMEC D3
      554    25    Cm  C02   6.89000         0 1 : Experiment 1 25000 HCMEC D3
      555    25    Cm  C03   9.25000         0 1 : Experiment 1 25000 HCMEC D3
      556    25    Cm  D01  15.00000         0 1 : Experiment 1 20000 HCMEC D3
      557    25    Cm  D02  13.70000         0 1 : Experiment 1 20000 HCMEC D3
      558    25    Cm  D03  12.91000         0 1 : Experiment 1 20000 HCMEC D3
      559    25    Cm  E01  21.54000         0 1 : Experiment 1 15000 HCMEC D3
      560    25    Cm  E02  23.82000         0 1 : Experiment 1 15000 HCMEC D3
      561    25    Cm  E03  23.69000         0 1 : Experiment 1 15000 HCMEC D3
      562    25    Cm  F01  31.94000         0 1 : Experiment 1 10000 HCMEC D3
      563    25    Cm  F02  48.43000         0 1 : Experiment 1 10000 HCMEC D3
      564    25    Cm  F03  30.00000         0 1 : Experiment 1 10000 HCMEC D3
      565    25    Cm  G01 125.58000         0 1 : Experiment 1  5000 HCMEC D3
      566    25    Cm  G02 147.98000         0 1 : Experiment 1  5000 HCMEC D3
      567    25    Cm  G03 121.21000         0 1 : Experiment 1  5000 HCMEC D3
      568    25 Drift  A01  -3.86000         0 1 : Experiment 1 35000 HCMEC D3
      569    25 Drift  A02  -4.15000         0 1 : Experiment 1 35000 HCMEC D3
      570    25 Drift  A03  -3.59000         0 1 : Experiment 1 35000 HCMEC D3
      571    25 Drift  B01  -4.19000         0 1 : Experiment 1 30000 HCMEC D3
      572    25 Drift  B02  -4.28000         0 1 : Experiment 1 30000 HCMEC D3
      573    25 Drift  B03  -3.67000         0 1 : Experiment 1 30000 HCMEC D3
      574    25 Drift  C01  -4.27000         0 1 : Experiment 1 25000 HCMEC D3
      575    25 Drift  C02  -4.37000         0 1 : Experiment 1 25000 HCMEC D3
      576    25 Drift  C03  -3.71000         0 1 : Experiment 1 25000 HCMEC D3
      577    25 Drift  D01  -3.94000         0 1 : Experiment 1 20000 HCMEC D3
      578    25 Drift  D02  -3.95000         0 1 : Experiment 1 20000 HCMEC D3
      579    25 Drift  D03  -3.08000         0 1 : Experiment 1 20000 HCMEC D3
      580    25 Drift  E01  -2.35000         0 1 : Experiment 1 15000 HCMEC D3
      581    25 Drift  E02  -2.49000         0 1 : Experiment 1 15000 HCMEC D3
      582    25 Drift  E03  -2.36000         0 1 : Experiment 1 15000 HCMEC D3
      583    25 Drift  F01  -2.15000         0 1 : Experiment 1 10000 HCMEC D3
      584    25 Drift  F02  -2.00000         0 1 : Experiment 1 10000 HCMEC D3
      585    25 Drift  F03  -1.69000         0 1 : Experiment 1 10000 HCMEC D3
      586    25 Drift  G01  -1.26000         0 1 : Experiment 1  5000 HCMEC D3
      587    25 Drift  G02  -1.25000         0 1 : Experiment 1  5000 HCMEC D3
      588    25 Drift  G03  -0.88000         0 1 : Experiment 1  5000 HCMEC D3
      589    25    Rb  A01   0.00000         0 1 : Experiment 1 35000 HCMEC D3
      590    25    Rb  A02   0.42000         0 1 : Experiment 1 35000 HCMEC D3
      591    25    Rb  A03   0.00000         0 1 : Experiment 1 35000 HCMEC D3
      592    25    Rb  B01   0.00000         0 1 : Experiment 1 30000 HCMEC D3
      593    25    Rb  B02   0.00000         0 1 : Experiment 1 30000 HCMEC D3
      594    25    Rb  B03   0.00000         0 1 : Experiment 1 30000 HCMEC D3
      595    25    Rb  C01   0.00000         0 1 : Experiment 1 25000 HCMEC D3
      596    25    Rb  C02   0.00000         0 1 : Experiment 1 25000 HCMEC D3
      597    25    Rb  C03   0.00000         0 1 : Experiment 1 25000 HCMEC D3
      598    25    Rb  D01   0.00000         0 1 : Experiment 1 20000 HCMEC D3
      599    25    Rb  D02   0.00000         0 1 : Experiment 1 20000 HCMEC D3
      600    25    Rb  D03   0.00000         0 1 : Experiment 1 20000 HCMEC D3
      601    25    Rb  E01   0.00000         0 1 : Experiment 1 15000 HCMEC D3
      602    25    Rb  E02   0.00000         0 1 : Experiment 1 15000 HCMEC D3
      603    25    Rb  E03   0.00000         0 1 : Experiment 1 15000 HCMEC D3
      604    25    Rb  F01   0.00000         0 1 : Experiment 1 10000 HCMEC D3
      605    25    Rb  F02   0.00000         0 1 : Experiment 1 10000 HCMEC D3
      606    25    Rb  F03   0.00000         0 1 : Experiment 1 10000 HCMEC D3
      607    25    Rb  G01   0.00000         0 1 : Experiment 1  5000 HCMEC D3
      608    25    Rb  G02   0.00000         0 1 : Experiment 1  5000 HCMEC D3
      609    25    Rb  G03   0.00000         0 1 : Experiment 1  5000 HCMEC D3
      610    25  RMSE  A01   0.01000         0 1 : Experiment 1 35000 HCMEC D3
      611    25  RMSE  A02   0.01000         0 1 : Experiment 1 35000 HCMEC D3
      612    25  RMSE  A03   0.02000         0 1 : Experiment 1 35000 HCMEC D3
      613    25  RMSE  B01   0.02000         0 1 : Experiment 1 30000 HCMEC D3
      614    25  RMSE  B02   0.02000         0 1 : Experiment 1 30000 HCMEC D3
      615    25  RMSE  B03   0.03000         0 1 : Experiment 1 30000 HCMEC D3
      616    25  RMSE  C01   0.03000         0 1 : Experiment 1 25000 HCMEC D3
      617    25  RMSE  C02   0.03000         0 1 : Experiment 1 25000 HCMEC D3
      618    25  RMSE  C03   0.03000         0 1 : Experiment 1 25000 HCMEC D3
      619    25  RMSE  D01   0.03000         0 1 : Experiment 1 20000 HCMEC D3
      620    25  RMSE  D02   0.03000         0 1 : Experiment 1 20000 HCMEC D3
      621    25  RMSE  D03   0.03000         0 1 : Experiment 1 20000 HCMEC D3
      622    25  RMSE  E01   0.03000         0 1 : Experiment 1 15000 HCMEC D3
      623    25  RMSE  E02   0.03000         0 1 : Experiment 1 15000 HCMEC D3
      624    25  RMSE  E03   0.03000         0 1 : Experiment 1 15000 HCMEC D3
      625    25  RMSE  F01   0.02000         0 1 : Experiment 1 10000 HCMEC D3
      626    25  RMSE  F02   0.02000         0 1 : Experiment 1 10000 HCMEC D3
      627    25  RMSE  F03   0.03000         0 1 : Experiment 1 10000 HCMEC D3
      628    25  RMSE  G01   0.01000         0 1 : Experiment 1  5000 HCMEC D3
      629    25  RMSE  G02   0.01000         0 1 : Experiment 1  5000 HCMEC D3
      630    25  RMSE  G03   0.05000         0 1 : Experiment 1  5000 HCMEC D3
      631    30 Alpha  A01   5.31000         0 1 : Experiment 1 35000 HCMEC D3
      632    30 Alpha  A02   5.27000         0 1 : Experiment 1 35000 HCMEC D3
      633    30 Alpha  A03   5.33000         0 1 : Experiment 1 35000 HCMEC D3
      634    30 Alpha  B01   5.47000         0 1 : Experiment 1 30000 HCMEC D3
      635    30 Alpha  B02   5.49000         0 1 : Experiment 1 30000 HCMEC D3
      636    30 Alpha  B03   4.95000         0 1 : Experiment 1 30000 HCMEC D3
      637    30 Alpha  C01   4.63000         0 1 : Experiment 1 25000 HCMEC D3
      638    30 Alpha  C02   4.83000         0 1 : Experiment 1 25000 HCMEC D3
      639    30 Alpha  C03   4.56000         0 1 : Experiment 1 25000 HCMEC D3
      640    30 Alpha  D01   4.01000         0 1 : Experiment 1 20000 HCMEC D3
      641    30 Alpha  D02   4.18000         0 1 : Experiment 1 20000 HCMEC D3
      642    30 Alpha  D03   4.01000         0 1 : Experiment 1 20000 HCMEC D3
      643    30 Alpha  E01   3.48000         0 1 : Experiment 1 15000 HCMEC D3
      644    30 Alpha  E02   3.51000         0 1 : Experiment 1 15000 HCMEC D3
      645    30 Alpha  E03   3.54000         0 1 : Experiment 1 15000 HCMEC D3
      646    30 Alpha  F01   3.03000         0 1 : Experiment 1 10000 HCMEC D3
      647    30 Alpha  F02   2.81000         0 1 : Experiment 1 10000 HCMEC D3
      648    30 Alpha  F03   2.94000         0 1 : Experiment 1 10000 HCMEC D3
      649    30 Alpha  G01   1.80000         0 1 : Experiment 1  5000 HCMEC D3
      650    30 Alpha  G02   1.55000         0 1 : Experiment 1  5000 HCMEC D3
      651    30 Alpha  G03   1.74000         0 1 : Experiment 1  5000 HCMEC D3
      652    30    Cm  A01   2.63000         0 1 : Experiment 1 35000 HCMEC D3
      653    30    Cm  A02   1.76000         0 1 : Experiment 1 35000 HCMEC D3
      654    30    Cm  A03   2.13000         0 1 : Experiment 1 35000 HCMEC D3
      655    30    Cm  B01   2.02000         0 1 : Experiment 1 30000 HCMEC D3
      656    30    Cm  B02   2.14000         0 1 : Experiment 1 30000 HCMEC D3
      657    30    Cm  B03   4.13000         0 1 : Experiment 1 30000 HCMEC D3
      658    30    Cm  C01   5.59000         0 1 : Experiment 1 25000 HCMEC D3
      659    30    Cm  C02   4.61000         0 1 : Experiment 1 25000 HCMEC D3
      660    30    Cm  C03   6.46000         0 1 : Experiment 1 25000 HCMEC D3
      661    30    Cm  D01  12.05000         0 1 : Experiment 1 20000 HCMEC D3
      662    30    Cm  D02  10.86000         0 1 : Experiment 1 20000 HCMEC D3
      663    30    Cm  D03  10.01000         0 1 : Experiment 1 20000 HCMEC D3
      664    30    Cm  E01  17.12000         0 1 : Experiment 1 15000 HCMEC D3
      665    30    Cm  E02  18.26000         0 1 : Experiment 1 15000 HCMEC D3
      666    30    Cm  E03  18.31000         0 1 : Experiment 1 15000 HCMEC D3
      667    30    Cm  F01  24.85000         0 1 : Experiment 1 10000 HCMEC D3
      668    30    Cm  F02  39.77000         0 1 : Experiment 1 10000 HCMEC D3
      669    30    Cm  F03  25.26000         0 1 : Experiment 1 10000 HCMEC D3
      670    30    Cm  G01 101.76000         0 1 : Experiment 1  5000 HCMEC D3
      671    30    Cm  G02 121.73000         0 1 : Experiment 1  5000 HCMEC D3
      672    30    Cm  G03  81.58000         0 1 : Experiment 1  5000 HCMEC D3
      673    30 Drift  A01  -4.15000         0 1 : Experiment 1 35000 HCMEC D3
      674    30 Drift  A02  -4.46000         0 1 : Experiment 1 35000 HCMEC D3
      675    30 Drift  A03  -3.84000         0 1 : Experiment 1 35000 HCMEC D3
      676    30 Drift  B01  -4.57000         0 1 : Experiment 1 30000 HCMEC D3
      677    30 Drift  B02  -4.66000         0 1 : Experiment 1 30000 HCMEC D3
      678    30 Drift  B03  -4.11000         0 1 : Experiment 1 30000 HCMEC D3
      679    30 Drift  C01  -4.66000         0 1 : Experiment 1 25000 HCMEC D3
      680    30 Drift  C02  -4.82000         0 1 : Experiment 1 25000 HCMEC D3
      681    30 Drift  C03  -4.16000         0 1 : Experiment 1 25000 HCMEC D3
      682    30 Drift  D01  -4.38000         0 1 : Experiment 1 20000 HCMEC D3
      683    30 Drift  D02  -4.42000         0 1 : Experiment 1 20000 HCMEC D3
      684    30 Drift  D03  -3.52000         0 1 : Experiment 1 20000 HCMEC D3
      685    30 Drift  E01  -2.82000         0 1 : Experiment 1 15000 HCMEC D3
      686    30 Drift  E02  -2.95000         0 1 : Experiment 1 15000 HCMEC D3
      687    30 Drift  E03  -2.82000         0 1 : Experiment 1 15000 HCMEC D3
      688    30 Drift  F01  -2.60000         0 1 : Experiment 1 10000 HCMEC D3
      689    30 Drift  F02  -2.47000         0 1 : Experiment 1 10000 HCMEC D3
      690    30 Drift  F03  -2.06000         0 1 : Experiment 1 10000 HCMEC D3
      691    30 Drift  G01  -1.55000         0 1 : Experiment 1  5000 HCMEC D3
      692    30 Drift  G02  -1.50000         0 1 : Experiment 1  5000 HCMEC D3
      693    30 Drift  G03  -1.14000         0 1 : Experiment 1  5000 HCMEC D3
      694    30    Rb  A01   0.20000         0 1 : Experiment 1 35000 HCMEC D3
      695    30    Rb  A02   0.84000         0 1 : Experiment 1 35000 HCMEC D3
      696    30    Rb  A03   0.21000         0 1 : Experiment 1 35000 HCMEC D3
      697    30    Rb  B01   0.01000         0 1 : Experiment 1 30000 HCMEC D3
      698    30    Rb  B02   0.09000         0 1 : Experiment 1 30000 HCMEC D3
      699    30    Rb  B03   0.00000         0 1 : Experiment 1 30000 HCMEC D3
      700    30    Rb  C01   0.00000         0 1 : Experiment 1 25000 HCMEC D3
      701    30    Rb  C02   0.00000         0 1 : Experiment 1 25000 HCMEC D3
      702    30    Rb  C03   0.00000         0 1 : Experiment 1 25000 HCMEC D3
      703    30    Rb  D01   0.00000         0 1 : Experiment 1 20000 HCMEC D3
      704    30    Rb  D02   0.00000         0 1 : Experiment 1 20000 HCMEC D3
      705    30    Rb  D03   0.00000         0 1 : Experiment 1 20000 HCMEC D3
      706    30    Rb  E01   0.00000         0 1 : Experiment 1 15000 HCMEC D3
      707    30    Rb  E02   0.00000         0 1 : Experiment 1 15000 HCMEC D3
      708    30    Rb  E03   0.00000         0 1 : Experiment 1 15000 HCMEC D3
      709    30    Rb  F01   0.00000         0 1 : Experiment 1 10000 HCMEC D3
      710    30    Rb  F02   0.00000         0 1 : Experiment 1 10000 HCMEC D3
      711    30    Rb  F03   0.00000         0 1 : Experiment 1 10000 HCMEC D3
      712    30    Rb  G01   0.00000         0 1 : Experiment 1  5000 HCMEC D3
      713    30    Rb  G02   0.00000         0 1 : Experiment 1  5000 HCMEC D3
      714    30    Rb  G03   0.00000         0 1 : Experiment 1  5000 HCMEC D3
      715    30  RMSE  A01   0.01000         0 1 : Experiment 1 35000 HCMEC D3
      716    30  RMSE  A02   0.01000         0 1 : Experiment 1 35000 HCMEC D3
      717    30  RMSE  A03   0.01000         0 1 : Experiment 1 35000 HCMEC D3
      718    30  RMSE  B01   0.01000         0 1 : Experiment 1 30000 HCMEC D3
      719    30  RMSE  B02   0.01000         0 1 : Experiment 1 30000 HCMEC D3
      720    30  RMSE  B03   0.02000         0 1 : Experiment 1 30000 HCMEC D3
      721    30  RMSE  C01   0.03000         0 1 : Experiment 1 25000 HCMEC D3
      722    30  RMSE  C02   0.03000         0 1 : Experiment 1 25000 HCMEC D3
      723    30  RMSE  C03   0.03000         0 1 : Experiment 1 25000 HCMEC D3
      724    30  RMSE  D01   0.04000         0 1 : Experiment 1 20000 HCMEC D3
      725    30  RMSE  D02   0.03000         0 1 : Experiment 1 20000 HCMEC D3
      726    30  RMSE  D03   0.03000         0 1 : Experiment 1 20000 HCMEC D3
      727    30  RMSE  E01   0.03000         0 1 : Experiment 1 15000 HCMEC D3
      728    30  RMSE  E02   0.03000         0 1 : Experiment 1 15000 HCMEC D3
      729    30  RMSE  E03   0.03000         0 1 : Experiment 1 15000 HCMEC D3
      730    30  RMSE  F01   0.03000         0 1 : Experiment 1 10000 HCMEC D3
      731    30  RMSE  F02   0.02000         0 1 : Experiment 1 10000 HCMEC D3
      732    30  RMSE  F03   0.03000         0 1 : Experiment 1 10000 HCMEC D3
      733    30  RMSE  G01   0.01000         0 1 : Experiment 1  5000 HCMEC D3
      734    30  RMSE  G02   0.01000         0 1 : Experiment 1  5000 HCMEC D3
      735    30  RMSE  G03   0.01000         0 1 : Experiment 1  5000 HCMEC D3
      736    35 Alpha  A01   5.30000         0 1 : Experiment 1 35000 HCMEC D3
      737    35 Alpha  A02   5.16000         0 1 : Experiment 1 35000 HCMEC D3
      738    35 Alpha  A03   5.24000         0 1 : Experiment 1 35000 HCMEC D3
      739    35 Alpha  B01   5.35000         0 1 : Experiment 1 30000 HCMEC D3
      740    35 Alpha  B02   5.44000         0 1 : Experiment 1 30000 HCMEC D3
      741    35 Alpha  B03   5.18000         0 1 : Experiment 1 30000 HCMEC D3
      742    35 Alpha  C01   4.86000         0 1 : Experiment 1 25000 HCMEC D3
      743    35 Alpha  C02   5.05000         0 1 : Experiment 1 25000 HCMEC D3
      744    35 Alpha  C03   4.71000         0 1 : Experiment 1 25000 HCMEC D3
      745    35 Alpha  D01   4.22000         0 1 : Experiment 1 20000 HCMEC D3
      746    35 Alpha  D02   4.53000         0 1 : Experiment 1 20000 HCMEC D3
      747    35 Alpha  D03   4.28000         0 1 : Experiment 1 20000 HCMEC D3
      748    35 Alpha  E01   3.75000         0 1 : Experiment 1 15000 HCMEC D3
      749    35 Alpha  E02   3.75000         0 1 : Experiment 1 15000 HCMEC D3
      750    35 Alpha  E03   3.89000         0 1 : Experiment 1 15000 HCMEC D3
      751    35 Alpha  F01   3.38000         0 1 : Experiment 1 10000 HCMEC D3
      752    35 Alpha  F02   3.02000         0 1 : Experiment 1 10000 HCMEC D3
      753    35 Alpha  F03   3.15000         0 1 : Experiment 1 10000 HCMEC D3
      754    35 Alpha  G01   1.98000         0 1 : Experiment 1  5000 HCMEC D3
      755    35 Alpha  G02   1.73000         0 1 : Experiment 1  5000 HCMEC D3
      756    35 Alpha  G03   1.86000         0 1 : Experiment 1  5000 HCMEC D3
      757    35    Cm  A01   2.27000         0 1 : Experiment 1 35000 HCMEC D3
      758    35    Cm  A02   1.54000         0 1 : Experiment 1 35000 HCMEC D3
      759    35    Cm  A03   1.91000         0 1 : Experiment 1 35000 HCMEC D3
      760    35    Cm  B01   1.98000         0 1 : Experiment 1 30000 HCMEC D3
      761    35    Cm  B02   2.01000         0 1 : Experiment 1 30000 HCMEC D3
      762    35    Cm  B03   3.18000         0 1 : Experiment 1 30000 HCMEC D3
      763    35    Cm  C01   4.47000         0 1 : Experiment 1 25000 HCMEC D3
      764    35    Cm  C02   3.50000         0 1 : Experiment 1 25000 HCMEC D3
      765    35    Cm  C03   5.38000         0 1 : Experiment 1 25000 HCMEC D3
      766    35    Cm  D01   9.87000         0 1 : Experiment 1 20000 HCMEC D3
      767    35    Cm  D02   8.24000         0 1 : Experiment 1 20000 HCMEC D3
      768    35    Cm  D03   8.45000         0 1 : Experiment 1 20000 HCMEC D3
      769    35    Cm  E01  14.34000         0 1 : Experiment 1 15000 HCMEC D3
      770    35    Cm  E02  15.16000         0 1 : Experiment 1 15000 HCMEC D3
      771    35    Cm  E03  13.81000         0 1 : Experiment 1 15000 HCMEC D3
      772    35    Cm  F01  19.32000         0 1 : Experiment 1 10000 HCMEC D3
      773    35    Cm  F02  31.25000         0 1 : Experiment 1 10000 HCMEC D3
      774    35    Cm  F03  21.94000         0 1 : Experiment 1 10000 HCMEC D3
      775    35    Cm  G01  82.19000         0 1 : Experiment 1  5000 HCMEC D3
      776    35    Cm  G02  94.75000         0 1 : Experiment 1  5000 HCMEC D3
      777    35    Cm  G03  70.09000         0 1 : Experiment 1  5000 HCMEC D3
      778    35 Drift  A01  -4.45000         0 1 : Experiment 1 35000 HCMEC D3
      779    35 Drift  A02  -4.69000         0 1 : Experiment 1 35000 HCMEC D3
      780    35 Drift  A03  -4.11000         0 1 : Experiment 1 35000 HCMEC D3
      781    35 Drift  B01  -4.80000         0 1 : Experiment 1 30000 HCMEC D3
      782    35 Drift  B02  -4.91000         0 1 : Experiment 1 30000 HCMEC D3
      783    35 Drift  B03  -4.40000         0 1 : Experiment 1 30000 HCMEC D3
      784    35 Drift  C01  -4.96000         0 1 : Experiment 1 25000 HCMEC D3
      785    35 Drift  C02  -5.10000         0 1 : Experiment 1 25000 HCMEC D3
      786    35 Drift  C03  -4.46000         0 1 : Experiment 1 25000 HCMEC D3
      787    35 Drift  D01  -4.69000         0 1 : Experiment 1 20000 HCMEC D3
      788    35 Drift  D02  -4.78000         0 1 : Experiment 1 20000 HCMEC D3
      789    35 Drift  D03  -3.90000         0 1 : Experiment 1 20000 HCMEC D3
      790    35 Drift  E01  -3.19000         0 1 : Experiment 1 15000 HCMEC D3
      791    35 Drift  E02  -3.33000         0 1 : Experiment 1 15000 HCMEC D3
      792    35 Drift  E03  -3.19000         0 1 : Experiment 1 15000 HCMEC D3
      793    35 Drift  F01  -3.02000         0 1 : Experiment 1 10000 HCMEC D3
      794    35 Drift  F02  -2.83000         0 1 : Experiment 1 10000 HCMEC D3
      795    35 Drift  F03  -2.36000         0 1 : Experiment 1 10000 HCMEC D3
      796    35 Drift  G01  -1.82000         0 1 : Experiment 1  5000 HCMEC D3
      797    35 Drift  G02  -1.72000         0 1 : Experiment 1  5000 HCMEC D3
      798    35 Drift  G03  -1.39000         0 1 : Experiment 1  5000 HCMEC D3
      799    35    Rb  A01   0.56000         0 1 : Experiment 1 35000 HCMEC D3
      800    35    Rb  A02   1.20000         0 1 : Experiment 1 35000 HCMEC D3
      801    35    Rb  A03   0.56000         0 1 : Experiment 1 35000 HCMEC D3
      802    35    Rb  B01   0.46000         0 1 : Experiment 1 30000 HCMEC D3
      803    35    Rb  B02   0.37000         0 1 : Experiment 1 30000 HCMEC D3
      804    35    Rb  B03   0.00000         0 1 : Experiment 1 30000 HCMEC D3
      805    35    Rb  C01   0.00000         0 1 : Experiment 1 25000 HCMEC D3
      806    35    Rb  C02   0.00000         0 1 : Experiment 1 25000 HCMEC D3
      807    35    Rb  C03   0.00000         0 1 : Experiment 1 25000 HCMEC D3
      808    35    Rb  D01   0.00000         0 1 : Experiment 1 20000 HCMEC D3
      809    35    Rb  D02   0.00000         0 1 : Experiment 1 20000 HCMEC D3
      810    35    Rb  D03   0.00000         0 1 : Experiment 1 20000 HCMEC D3
      811    35    Rb  E01   0.00000         0 1 : Experiment 1 15000 HCMEC D3
      812    35    Rb  E02   0.00000         0 1 : Experiment 1 15000 HCMEC D3
      813    35    Rb  E03   0.00000         0 1 : Experiment 1 15000 HCMEC D3
      814    35    Rb  F01   0.00000         0 1 : Experiment 1 10000 HCMEC D3
      815    35    Rb  F02   0.00000         0 1 : Experiment 1 10000 HCMEC D3
      816    35    Rb  F03   0.00000         0 1 : Experiment 1 10000 HCMEC D3
      817    35    Rb  G01   0.00000         0 1 : Experiment 1  5000 HCMEC D3
      818    35    Rb  G02   0.00000         0 1 : Experiment 1  5000 HCMEC D3
      819    35    Rb  G03   0.00000         0 1 : Experiment 1  5000 HCMEC D3
      820    35  RMSE  A01   0.01000         0 1 : Experiment 1 35000 HCMEC D3
      821    35  RMSE  A02   0.01000         0 1 : Experiment 1 35000 HCMEC D3
      822    35  RMSE  A03   0.01000         0 1 : Experiment 1 35000 HCMEC D3
      823    35  RMSE  B01   0.01000         0 1 : Experiment 1 30000 HCMEC D3
      824    35  RMSE  B02   0.01000         0 1 : Experiment 1 30000 HCMEC D3
      825    35  RMSE  B03   0.02000         0 1 : Experiment 1 30000 HCMEC D3
      826    35  RMSE  C01   0.03000         0 1 : Experiment 1 25000 HCMEC D3
      827    35  RMSE  C02   0.02000         0 1 : Experiment 1 25000 HCMEC D3
      828    35  RMSE  C03   0.03000         0 1 : Experiment 1 25000 HCMEC D3
      829    35  RMSE  D01   0.03000         0 1 : Experiment 1 20000 HCMEC D3
      830    35  RMSE  D02   0.03000         0 1 : Experiment 1 20000 HCMEC D3
      831    35  RMSE  D03   0.03000         0 1 : Experiment 1 20000 HCMEC D3
      832    35  RMSE  E01   0.03000         0 1 : Experiment 1 15000 HCMEC D3
      833    35  RMSE  E02   0.03000         0 1 : Experiment 1 15000 HCMEC D3
      834    35  RMSE  E03   0.03000         0 1 : Experiment 1 15000 HCMEC D3
      835    35  RMSE  F01   0.03000         0 1 : Experiment 1 10000 HCMEC D3
      836    35  RMSE  F02   0.03000         0 1 : Experiment 1 10000 HCMEC D3
      837    35  RMSE  F03   0.03000         0 1 : Experiment 1 10000 HCMEC D3
      838    35  RMSE  G01   0.01000         0 1 : Experiment 1  5000 HCMEC D3
      839    35  RMSE  G02   0.01000         0 1 : Experiment 1  5000 HCMEC D3
      840    35  RMSE  G03   0.01000         0 1 : Experiment 1  5000 HCMEC D3
      841    40 Alpha  A01   5.17000         0 1 : Experiment 1 35000 HCMEC D3
      842    40 Alpha  A02   4.89000         0 1 : Experiment 1 35000 HCMEC D3
      843    40 Alpha  A03   5.12000         0 1 : Experiment 1 35000 HCMEC D3
      844    40 Alpha  B01   5.22000         0 1 : Experiment 1 30000 HCMEC D3
      845    40 Alpha  B02   5.36000         0 1 : Experiment 1 30000 HCMEC D3
      846    40 Alpha  B03   5.60000         0 1 : Experiment 1 30000 HCMEC D3
      847    40 Alpha  C01   5.19000         0 1 : Experiment 1 25000 HCMEC D3
      848    40 Alpha  C02   5.32000         0 1 : Experiment 1 25000 HCMEC D3
      849    40 Alpha  C03   4.95000         0 1 : Experiment 1 25000 HCMEC D3
      850    40 Alpha  D01   4.51000         0 1 : Experiment 1 20000 HCMEC D3
      851    40 Alpha  D02   4.78000         0 1 : Experiment 1 20000 HCMEC D3
      852    40 Alpha  D03   4.60000         0 1 : Experiment 1 20000 HCMEC D3
      853    40 Alpha  E01   4.05000         0 1 : Experiment 1 15000 HCMEC D3
      854    40 Alpha  E02   4.01000         0 1 : Experiment 1 15000 HCMEC D3
      855    40 Alpha  E03   4.11000         0 1 : Experiment 1 15000 HCMEC D3
      856    40 Alpha  F01   3.55000         0 1 : Experiment 1 10000 HCMEC D3
      857    40 Alpha  F02   3.27000         0 1 : Experiment 1 10000 HCMEC D3
      858    40 Alpha  F03   3.56000         0 1 : Experiment 1 10000 HCMEC D3
      859    40 Alpha  G01   2.08000         0 1 : Experiment 1  5000 HCMEC D3
      860    40 Alpha  G02   1.86000         0 1 : Experiment 1  5000 HCMEC D3
      861    40 Alpha  G03   1.97000         0 1 : Experiment 1  5000 HCMEC D3
      862    40    Cm  A01   1.72000         0 1 : Experiment 1 35000 HCMEC D3
      863    40    Cm  A02   1.23000         0 1 : Experiment 1 35000 HCMEC D3
      864    40    Cm  A03   1.67000         0 1 : Experiment 1 35000 HCMEC D3
      865    40    Cm  B01   1.65000         0 1 : Experiment 1 30000 HCMEC D3
      866    40    Cm  B02   1.73000         0 1 : Experiment 1 30000 HCMEC D3
      867    40    Cm  B03   2.07000         0 1 : Experiment 1 30000 HCMEC D3
      868    40    Cm  C01   3.33000         0 1 : Experiment 1 25000 HCMEC D3
      869    40    Cm  C02   2.59000         0 1 : Experiment 1 25000 HCMEC D3
      870    40    Cm  C03   4.03000         0 1 : Experiment 1 25000 HCMEC D3
      871    40    Cm  D01   7.74000         0 1 : Experiment 1 20000 HCMEC D3
      872    40    Cm  D02   6.41000         0 1 : Experiment 1 20000 HCMEC D3
      873    40    Cm  D03   5.95000         0 1 : Experiment 1 20000 HCMEC D3
      874    40    Cm  E01  11.02000         0 1 : Experiment 1 15000 HCMEC D3
      875    40    Cm  E02  12.72000         0 1 : Experiment 1 15000 HCMEC D3
      876    40    Cm  E03  10.54000         0 1 : Experiment 1 15000 HCMEC D3
      877    40    Cm  F01  15.81000         0 1 : Experiment 1 10000 HCMEC D3
      878    40    Cm  F02  24.03000         0 1 : Experiment 1 10000 HCMEC D3
      879    40    Cm  F03  17.42000         0 1 : Experiment 1 10000 HCMEC D3
      880    40    Cm  G01  70.36000         0 1 : Experiment 1  5000 HCMEC D3
      881    40    Cm  G02  74.17000         0 1 : Experiment 1  5000 HCMEC D3
      882    40    Cm  G03  58.66000         0 1 : Experiment 1  5000 HCMEC D3
      883    40 Drift  A01  -4.65000         0 1 : Experiment 1 35000 HCMEC D3
      884    40 Drift  A02  -4.85000         0 1 : Experiment 1 35000 HCMEC D3
      885    40 Drift  A03  -4.31000         0 1 : Experiment 1 35000 HCMEC D3
      886    40 Drift  B01  -4.98000         0 1 : Experiment 1 30000 HCMEC D3
      887    40 Drift  B02  -5.14000         0 1 : Experiment 1 30000 HCMEC D3
      888    40 Drift  B03  -4.72000         0 1 : Experiment 1 30000 HCMEC D3
      889    40 Drift  C01  -5.22000         0 1 : Experiment 1 25000 HCMEC D3
      890    40 Drift  C02  -5.35000         0 1 : Experiment 1 25000 HCMEC D3
      891    40 Drift  C03  -4.75000         0 1 : Experiment 1 25000 HCMEC D3
      892    40 Drift  D01  -5.05000         0 1 : Experiment 1 20000 HCMEC D3
      893    40 Drift  D02  -5.13000         0 1 : Experiment 1 20000 HCMEC D3
      894    40 Drift  D03  -4.23000         0 1 : Experiment 1 20000 HCMEC D3
      895    40 Drift  E01  -3.52000         0 1 : Experiment 1 15000 HCMEC D3
      896    40 Drift  E02  -3.69000         0 1 : Experiment 1 15000 HCMEC D3
      897    40 Drift  E03  -3.49000         0 1 : Experiment 1 15000 HCMEC D3
      898    40 Drift  F01  -3.34000         0 1 : Experiment 1 10000 HCMEC D3
      899    40 Drift  F02  -3.09000         0 1 : Experiment 1 10000 HCMEC D3
      900    40 Drift  F03  -2.77000         0 1 : Experiment 1 10000 HCMEC D3
      901    40 Drift  G01  -2.06000         0 1 : Experiment 1  5000 HCMEC D3
      902    40 Drift  G02  -1.94000         0 1 : Experiment 1  5000 HCMEC D3
      903    40 Drift  G03  -1.62000         0 1 : Experiment 1  5000 HCMEC D3
      904    40    Rb  A01   1.09000         0 1 : Experiment 1 35000 HCMEC D3
      905    40    Rb  A02   1.86000         0 1 : Experiment 1 35000 HCMEC D3
      906    40    Rb  A03   0.98000         0 1 : Experiment 1 35000 HCMEC D3
      907    40    Rb  B01   1.00000         0 1 : Experiment 1 30000 HCMEC D3
      908    40    Rb  B02   0.84000         0 1 : Experiment 1 30000 HCMEC D3
      909    40    Rb  B03   0.03000         0 1 : Experiment 1 30000 HCMEC D3
      910    40    Rb  C01   0.00000         0 1 : Experiment 1 25000 HCMEC D3
      911    40    Rb  C02   0.00000         0 1 : Experiment 1 25000 HCMEC D3
      912    40    Rb  C03   0.00000         0 1 : Experiment 1 25000 HCMEC D3
      913    40    Rb  D01   0.00000         0 1 : Experiment 1 20000 HCMEC D3
      914    40    Rb  D02   0.00000         0 1 : Experiment 1 20000 HCMEC D3
      915    40    Rb  D03   0.00000         0 1 : Experiment 1 20000 HCMEC D3
      916    40    Rb  E01   0.00000         0 1 : Experiment 1 15000 HCMEC D3
      917    40    Rb  E02   0.00000         0 1 : Experiment 1 15000 HCMEC D3
      918    40    Rb  E03   0.00000         0 1 : Experiment 1 15000 HCMEC D3
      919    40    Rb  F01   0.00000         0 1 : Experiment 1 10000 HCMEC D3
      920    40    Rb  F02   0.00000         0 1 : Experiment 1 10000 HCMEC D3
      921    40    Rb  F03   0.00000         0 1 : Experiment 1 10000 HCMEC D3
      922    40    Rb  G01   0.00000         0 1 : Experiment 1  5000 HCMEC D3
      923    40    Rb  G02   0.00000         0 1 : Experiment 1  5000 HCMEC D3
      924    40    Rb  G03   0.00000         0 1 : Experiment 1  5000 HCMEC D3
      925    40  RMSE  A01   0.01000         0 1 : Experiment 1 35000 HCMEC D3
      926    40  RMSE  A02   0.01000         0 1 : Experiment 1 35000 HCMEC D3
      927    40  RMSE  A03   0.01000         0 1 : Experiment 1 35000 HCMEC D3
      928    40  RMSE  B01   0.01000         0 1 : Experiment 1 30000 HCMEC D3
      929    40  RMSE  B02   0.01000         0 1 : Experiment 1 30000 HCMEC D3
      930    40  RMSE  B03   0.01000         0 1 : Experiment 1 30000 HCMEC D3
      931    40  RMSE  C01   0.02000         0 1 : Experiment 1 25000 HCMEC D3
      932    40  RMSE  C02   0.02000         0 1 : Experiment 1 25000 HCMEC D3
      933    40  RMSE  C03   0.02000         0 1 : Experiment 1 25000 HCMEC D3
      934    40  RMSE  D01   0.03000         0 1 : Experiment 1 20000 HCMEC D3
      935    40  RMSE  D02   0.03000         0 1 : Experiment 1 20000 HCMEC D3
      936    40  RMSE  D03   0.03000         0 1 : Experiment 1 20000 HCMEC D3
      937    40  RMSE  E01   0.04000         0 1 : Experiment 1 15000 HCMEC D3
      938    40  RMSE  E02   0.03000         0 1 : Experiment 1 15000 HCMEC D3
      939    40  RMSE  E03   0.03000         0 1 : Experiment 1 15000 HCMEC D3
      940    40  RMSE  F01   0.03000         0 1 : Experiment 1 10000 HCMEC D3
      941    40  RMSE  F02   0.03000         0 1 : Experiment 1 10000 HCMEC D3
      942    40  RMSE  F03   0.04000         0 1 : Experiment 1 10000 HCMEC D3
      943    40  RMSE  G01   0.01000         0 1 : Experiment 1  5000 HCMEC D3
      944    40  RMSE  G02   0.01000         0 1 : Experiment 1  5000 HCMEC D3
      945    40  RMSE  G03   0.02000         0 1 : Experiment 1  5000 HCMEC D3
      946    45 Alpha  A01   4.92000         0 1 : Experiment 1 35000 HCMEC D3
      947    45 Alpha  A02   4.63000         0 1 : Experiment 1 35000 HCMEC D3
      948    45 Alpha  A03   4.88000         0 1 : Experiment 1 35000 HCMEC D3
      949    45 Alpha  B01   5.06000         0 1 : Experiment 1 30000 HCMEC D3
      950    45 Alpha  B02   5.20000         0 1 : Experiment 1 30000 HCMEC D3
      951    45 Alpha  B03   5.48000         0 1 : Experiment 1 30000 HCMEC D3
      952    45 Alpha  C01   5.65000         0 1 : Experiment 1 25000 HCMEC D3
      953    45 Alpha  C02   5.63000         0 1 : Experiment 1 25000 HCMEC D3
      954    45 Alpha  C03   5.36000         0 1 : Experiment 1 25000 HCMEC D3
      955    45 Alpha  D01   4.80000         0 1 : Experiment 1 20000 HCMEC D3
      956    45 Alpha  D02   5.03000         0 1 : Experiment 1 20000 HCMEC D3
      957    45 Alpha  D03   4.90000         0 1 : Experiment 1 20000 HCMEC D3
      958    45 Alpha  E01   4.29000         0 1 : Experiment 1 15000 HCMEC D3
      959    45 Alpha  E02   4.31000         0 1 : Experiment 1 15000 HCMEC D3
      960    45 Alpha  E03   4.26000         0 1 : Experiment 1 15000 HCMEC D3
      961    45 Alpha  F01   3.84000         0 1 : Experiment 1 10000 HCMEC D3
      962    45 Alpha  F02   3.49000         0 1 : Experiment 1 10000 HCMEC D3
      963    45 Alpha  F03   3.76000         0 1 : Experiment 1 10000 HCMEC D3
      964    45 Alpha  G01   2.17000         0 1 : Experiment 1  5000 HCMEC D3
      965    45 Alpha  G02   2.01000         0 1 : Experiment 1  5000 HCMEC D3
      966    45 Alpha  G03   2.17000         0 1 : Experiment 1  5000 HCMEC D3
      967    45    Cm  A01   1.35000         0 1 : Experiment 1 35000 HCMEC D3
      968    45    Cm  A02   1.10000         0 1 : Experiment 1 35000 HCMEC D3
      969    45    Cm  A03   1.31000         0 1 : Experiment 1 35000 HCMEC D3
      970    45    Cm  B01   1.38000         0 1 : Experiment 1 30000 HCMEC D3
      971    45    Cm  B02   1.38000         0 1 : Experiment 1 30000 HCMEC D3
      972    45    Cm  B03   1.78000         0 1 : Experiment 1 30000 HCMEC D3
      973    45    Cm  C01   2.00000         0 1 : Experiment 1 25000 HCMEC D3
      974    45    Cm  C02   1.79000         0 1 : Experiment 1 25000 HCMEC D3
      975    45    Cm  C03   2.69000         0 1 : Experiment 1 25000 HCMEC D3
      976    45    Cm  D01   5.61000         0 1 : Experiment 1 20000 HCMEC D3
      977    45    Cm  D02   5.09000         0 1 : Experiment 1 20000 HCMEC D3
      978    45    Cm  D03   4.61000         0 1 : Experiment 1 20000 HCMEC D3
      979    45    Cm  E01   8.89000         0 1 : Experiment 1 15000 HCMEC D3
      980    45    Cm  E02   9.13000         0 1 : Experiment 1 15000 HCMEC D3
      981    45    Cm  E03   8.91000         0 1 : Experiment 1 15000 HCMEC D3
      982    45    Cm  F01  12.88000         0 1 : Experiment 1 10000 HCMEC D3
      983    45    Cm  F02  19.72000         0 1 : Experiment 1 10000 HCMEC D3
      984    45    Cm  F03  13.88000         0 1 : Experiment 1 10000 HCMEC D3
      985    45    Cm  G01  58.18000         0 1 : Experiment 1  5000 HCMEC D3
      986    45    Cm  G02  62.49000         0 1 : Experiment 1  5000 HCMEC D3
      987    45    Cm  G03  44.63000         0 1 : Experiment 1  5000 HCMEC D3
      988    45 Drift  A01  -4.80000         0 1 : Experiment 1 35000 HCMEC D3
      989    45 Drift  A02  -4.98000         0 1 : Experiment 1 35000 HCMEC D3
      990    45 Drift  A03  -4.47000         0 1 : Experiment 1 35000 HCMEC D3
      991    45 Drift  B01  -5.16000         0 1 : Experiment 1 30000 HCMEC D3
      992    45 Drift  B02  -5.32000         0 1 : Experiment 1 30000 HCMEC D3
      993    45 Drift  B03  -4.88000         0 1 : Experiment 1 30000 HCMEC D3
      994    45 Drift  C01  -5.49000         0 1 : Experiment 1 25000 HCMEC D3
      995    45 Drift  C02  -5.55000         0 1 : Experiment 1 25000 HCMEC D3
      996    45 Drift  C03  -5.01000         0 1 : Experiment 1 25000 HCMEC D3
      997    45 Drift  D01  -5.33000         0 1 : Experiment 1 20000 HCMEC D3
      998    45 Drift  D02  -5.36000         0 1 : Experiment 1 20000 HCMEC D3
      999    45 Drift  D03  -4.50000         0 1 : Experiment 1 20000 HCMEC D3
      1000   45 Drift  E01  -3.88000         0 1 : Experiment 1 15000 HCMEC D3
      1001   45 Drift  E02  -3.99000         0 1 : Experiment 1 15000 HCMEC D3
      1002   45 Drift  E03  -3.76000         0 1 : Experiment 1 15000 HCMEC D3
      1003   45 Drift  F01  -3.64000         0 1 : Experiment 1 10000 HCMEC D3
      1004   45 Drift  F02  -3.46000         0 1 : Experiment 1 10000 HCMEC D3
      1005   45 Drift  F03  -3.13000         0 1 : Experiment 1 10000 HCMEC D3
      1006   45 Drift  G01  -2.26000         0 1 : Experiment 1  5000 HCMEC D3
      1007   45 Drift  G02  -2.18000         0 1 : Experiment 1  5000 HCMEC D3
      1008   45 Drift  G03  -1.89000         0 1 : Experiment 1  5000 HCMEC D3
      1009   45    Rb  A01   1.70000         0 1 : Experiment 1 35000 HCMEC D3
      1010   45    Rb  A02   2.37000         0 1 : Experiment 1 35000 HCMEC D3
      1011   45    Rb  A03   1.61000         0 1 : Experiment 1 35000 HCMEC D3
      1012   45    Rb  B01   1.49000         0 1 : Experiment 1 30000 HCMEC D3
      1013   45    Rb  B02   1.45000         0 1 : Experiment 1 30000 HCMEC D3
      1014   45    Rb  B03   0.56000         0 1 : Experiment 1 30000 HCMEC D3
      1015   45    Rb  C01   0.00000         0 1 : Experiment 1 25000 HCMEC D3
      1016   45    Rb  C02   0.19000         0 1 : Experiment 1 25000 HCMEC D3
      1017   45    Rb  C03   0.00000         0 1 : Experiment 1 25000 HCMEC D3
      1018   45    Rb  D01   0.00000         0 1 : Experiment 1 20000 HCMEC D3
      1019   45    Rb  D02   0.00000         0 1 : Experiment 1 20000 HCMEC D3
      1020   45    Rb  D03   0.00000         0 1 : Experiment 1 20000 HCMEC D3
      1021   45    Rb  E01   0.00000         0 1 : Experiment 1 15000 HCMEC D3
      1022   45    Rb  E02   0.00000         0 1 : Experiment 1 15000 HCMEC D3
      1023   45    Rb  E03   0.00000         0 1 : Experiment 1 15000 HCMEC D3
      1024   45    Rb  F01   0.00000         0 1 : Experiment 1 10000 HCMEC D3
      1025   45    Rb  F02   0.00000         0 1 : Experiment 1 10000 HCMEC D3
      1026   45    Rb  F03   0.00000         0 1 : Experiment 1 10000 HCMEC D3
      1027   45    Rb  G01   0.00000         0 1 : Experiment 1  5000 HCMEC D3
      1028   45    Rb  G02   0.00000         0 1 : Experiment 1  5000 HCMEC D3
      1029   45    Rb  G03   0.00000         0 1 : Experiment 1  5000 HCMEC D3
      1030   45  RMSE  A01   0.01000         0 1 : Experiment 1 35000 HCMEC D3
      1031   45  RMSE  A02   0.01000         0 1 : Experiment 1 35000 HCMEC D3
      1032   45  RMSE  A03   0.01000         0 1 : Experiment 1 35000 HCMEC D3
      1033   45  RMSE  B01   0.01000         0 1 : Experiment 1 30000 HCMEC D3
      1034   45  RMSE  B02   0.01000         0 1 : Experiment 1 30000 HCMEC D3
      1035   45  RMSE  B03   0.01000         0 1 : Experiment 1 30000 HCMEC D3
      1036   45  RMSE  C01   0.02000         0 1 : Experiment 1 25000 HCMEC D3
      1037   45  RMSE  C02   0.01000         0 1 : Experiment 1 25000 HCMEC D3
      1038   45  RMSE  C03   0.02000         0 1 : Experiment 1 25000 HCMEC D3
      1039   45  RMSE  D01   0.03000         0 1 : Experiment 1 20000 HCMEC D3
      1040   45  RMSE  D02   0.02000         0 1 : Experiment 1 20000 HCMEC D3
      1041   45  RMSE  D03   0.02000         0 1 : Experiment 1 20000 HCMEC D3
      1042   45  RMSE  E01   0.04000         0 1 : Experiment 1 15000 HCMEC D3
      1043   45  RMSE  E02   0.03000         0 1 : Experiment 1 15000 HCMEC D3
      1044   45  RMSE  E03   0.03000         0 1 : Experiment 1 15000 HCMEC D3
      1045   45  RMSE  F01   0.03000         0 1 : Experiment 1 10000 HCMEC D3
      1046   45  RMSE  F02   0.03000         0 1 : Experiment 1 10000 HCMEC D3
      1047   45  RMSE  F03   0.04000         0 1 : Experiment 1 10000 HCMEC D3
      1048   45  RMSE  G01   0.02000         0 1 : Experiment 1  5000 HCMEC D3
      1049   45  RMSE  G02   0.02000         0 1 : Experiment 1  5000 HCMEC D3
      1050   45  RMSE  G03   0.02000         0 1 : Experiment 1  5000 HCMEC D3
      1051   50 Alpha  A01   4.65000         0 1 : Experiment 1 35000 HCMEC D3
      1052   50 Alpha  A02   4.41000         0 1 : Experiment 1 35000 HCMEC D3
      1053   50 Alpha  A03   4.65000         0 1 : Experiment 1 35000 HCMEC D3
      1054   50 Alpha  B01   4.83000         0 1 : Experiment 1 30000 HCMEC D3
      1055   50 Alpha  B02   4.95000         0 1 : Experiment 1 30000 HCMEC D3
      1056   50 Alpha  B03   5.34000         0 1 : Experiment 1 30000 HCMEC D3
      1057   50 Alpha  C01   5.61000         0 1 : Experiment 1 25000 HCMEC D3
      1058   50 Alpha  C02   5.55000         0 1 : Experiment 1 25000 HCMEC D3
      1059   50 Alpha  C03   5.55000         0 1 : Experiment 1 25000 HCMEC D3
      1060   50 Alpha  D01   5.05000         0 1 : Experiment 1 20000 HCMEC D3
      1061   50 Alpha  D02   5.33000         0 1 : Experiment 1 20000 HCMEC D3
      1062   50 Alpha  D03   5.19000         0 1 : Experiment 1 20000 HCMEC D3
      1063   50 Alpha  E01   4.59000         0 1 : Experiment 1 15000 HCMEC D3
      1064   50 Alpha  E02   4.52000         0 1 : Experiment 1 15000 HCMEC D3
      1065   50 Alpha  E03   4.58000         0 1 : Experiment 1 15000 HCMEC D3
      1066   50 Alpha  F01   4.06000         0 1 : Experiment 1 10000 HCMEC D3
      1067   50 Alpha  F02   3.76000         0 1 : Experiment 1 10000 HCMEC D3
      1068   50 Alpha  F03   4.04000         0 1 : Experiment 1 10000 HCMEC D3
      1069   50 Alpha  G01   2.34000         0 1 : Experiment 1  5000 HCMEC D3
      1070   50 Alpha  G02   2.20000         0 1 : Experiment 1  5000 HCMEC D3
      1071   50 Alpha  G03   2.29000         0 1 : Experiment 1  5000 HCMEC D3
      1072   50    Cm  A01   1.18000         0 1 : Experiment 1 35000 HCMEC D3
      1073   50    Cm  A02   1.08000         0 1 : Experiment 1 35000 HCMEC D3
      1074   50    Cm  A03   1.17000         0 1 : Experiment 1 35000 HCMEC D3
      1075   50    Cm  B01   1.15000         0 1 : Experiment 1 30000 HCMEC D3
      1076   50    Cm  B02   1.20000         0 1 : Experiment 1 30000 HCMEC D3
      1077   50    Cm  B03   1.54000         0 1 : Experiment 1 30000 HCMEC D3
      1078   50    Cm  C01   1.84000         0 1 : Experiment 1 25000 HCMEC D3
      1079   50    Cm  C02   1.66000         0 1 : Experiment 1 25000 HCMEC D3
      1080   50    Cm  C03   1.98000         0 1 : Experiment 1 25000 HCMEC D3
      1081   50    Cm  D01   4.10000         0 1 : Experiment 1 20000 HCMEC D3
      1082   50    Cm  D02   3.24000         0 1 : Experiment 1 20000 HCMEC D3
      1083   50    Cm  D03   3.24000         0 1 : Experiment 1 20000 HCMEC D3
      1084   50    Cm  E01   6.68000         0 1 : Experiment 1 15000 HCMEC D3
      1085   50    Cm  E02   7.08000         0 1 : Experiment 1 15000 HCMEC D3
      1086   50    Cm  E03   6.77000         0 1 : Experiment 1 15000 HCMEC D3
      1087   50    Cm  F01  10.46000         0 1 : Experiment 1 10000 HCMEC D3
      1088   50    Cm  F02  16.51000         0 1 : Experiment 1 10000 HCMEC D3
      1089   50    Cm  F03  10.58000         0 1 : Experiment 1 10000 HCMEC D3
      1090   50    Cm  G01  48.45000         0 1 : Experiment 1  5000 HCMEC D3
      1091   50    Cm  G02  50.64000         0 1 : Experiment 1  5000 HCMEC D3
      1092   50    Cm  G03  38.45000         0 1 : Experiment 1  5000 HCMEC D3
      1093   50 Drift  A01  -4.90000         0 1 : Experiment 1 35000 HCMEC D3
      1094   50 Drift  A02  -5.08000         0 1 : Experiment 1 35000 HCMEC D3
      1095   50 Drift  A03  -4.61000         0 1 : Experiment 1 35000 HCMEC D3
      1096   50 Drift  B01  -5.31000         0 1 : Experiment 1 30000 HCMEC D3
      1097   50 Drift  B02  -5.45000         0 1 : Experiment 1 30000 HCMEC D3
      1098   50 Drift  B03  -5.05000         0 1 : Experiment 1 30000 HCMEC D3
      1099   50 Drift  C01  -5.66000         0 1 : Experiment 1 25000 HCMEC D3
      1100   50 Drift  C02  -5.75000         0 1 : Experiment 1 25000 HCMEC D3
      1101   50 Drift  C03  -5.22000         0 1 : Experiment 1 25000 HCMEC D3
      1102   50 Drift  D01  -5.52000         0 1 : Experiment 1 20000 HCMEC D3
      1103   50 Drift  D02  -5.62000         0 1 : Experiment 1 20000 HCMEC D3
      1104   50 Drift  D03  -4.77000         0 1 : Experiment 1 20000 HCMEC D3
      1105   50 Drift  E01  -4.14000         0 1 : Experiment 1 15000 HCMEC D3
      1106   50 Drift  E02  -4.26000         0 1 : Experiment 1 15000 HCMEC D3
      1107   50 Drift  E03  -4.04000         0 1 : Experiment 1 15000 HCMEC D3
      1108   50 Drift  F01  -3.95000         0 1 : Experiment 1 10000 HCMEC D3
      1109   50 Drift  F02  -3.86000         0 1 : Experiment 1 10000 HCMEC D3
      1110   50 Drift  F03  -3.38000         0 1 : Experiment 1 10000 HCMEC D3
      1111   50 Drift  G01  -2.53000         0 1 : Experiment 1  5000 HCMEC D3
      1112   50 Drift  G02  -2.43000         0 1 : Experiment 1  5000 HCMEC D3
      1113   50 Drift  G03  -2.11000         0 1 : Experiment 1  5000 HCMEC D3
      1114   50    Rb  A01   2.16000         0 1 : Experiment 1 35000 HCMEC D3
      1115   50    Rb  A02   2.65000         0 1 : Experiment 1 35000 HCMEC D3
      1116   50    Rb  A03   2.06000         0 1 : Experiment 1 35000 HCMEC D3
      1117   50    Rb  B01   2.13000         0 1 : Experiment 1 30000 HCMEC D3
      1118   50    Rb  B02   1.99000         0 1 : Experiment 1 30000 HCMEC D3
      1119   50    Rb  B03   0.99000         0 1 : Experiment 1 30000 HCMEC D3
      1120   50    Rb  C01   0.54000         0 1 : Experiment 1 25000 HCMEC D3
      1121   50    Rb  C02   0.68000         0 1 : Experiment 1 25000 HCMEC D3
      1122   50    Rb  C03   0.17000         0 1 : Experiment 1 25000 HCMEC D3
      1123   50    Rb  D01   0.00000         0 1 : Experiment 1 20000 HCMEC D3
      1124   50    Rb  D02   0.00000         0 1 : Experiment 1 20000 HCMEC D3
      1125   50    Rb  D03   0.00000         0 1 : Experiment 1 20000 HCMEC D3
      1126   50    Rb  E01   0.00000         0 1 : Experiment 1 15000 HCMEC D3
      1127   50    Rb  E02   0.00000         0 1 : Experiment 1 15000 HCMEC D3
      1128   50    Rb  E03   0.00000         0 1 : Experiment 1 15000 HCMEC D3
      1129   50    Rb  F01   0.00000         0 1 : Experiment 1 10000 HCMEC D3
      1130   50    Rb  F02   0.00000         0 1 : Experiment 1 10000 HCMEC D3
      1131   50    Rb  F03   0.00000         0 1 : Experiment 1 10000 HCMEC D3
      1132   50    Rb  G01   0.00000         0 1 : Experiment 1  5000 HCMEC D3
      1133   50    Rb  G02   0.00000         0 1 : Experiment 1  5000 HCMEC D3
      1134   50    Rb  G03   0.00000         0 1 : Experiment 1  5000 HCMEC D3
      1135   50  RMSE  A01   0.01000         0 1 : Experiment 1 35000 HCMEC D3
      1136   50  RMSE  A02   0.01000         0 1 : Experiment 1 35000 HCMEC D3
      1137   50  RMSE  A03   0.01000         0 1 : Experiment 1 35000 HCMEC D3
      1138   50  RMSE  B01   0.01000         0 1 : Experiment 1 30000 HCMEC D3
      1139   50  RMSE  B02   0.01000         0 1 : Experiment 1 30000 HCMEC D3
      1140   50  RMSE  B03   0.01000         0 1 : Experiment 1 30000 HCMEC D3
      1141   50  RMSE  C01   0.02000         0 1 : Experiment 1 25000 HCMEC D3
      1142   50  RMSE  C02   0.02000         0 1 : Experiment 1 25000 HCMEC D3
      1143   50  RMSE  C03   0.01000         0 1 : Experiment 1 25000 HCMEC D3
      1144   50  RMSE  D01   0.03000         0 1 : Experiment 1 20000 HCMEC D3
      1145   50  RMSE  D02   0.02000         0 1 : Experiment 1 20000 HCMEC D3
      1146   50  RMSE  D03   0.02000         0 1 : Experiment 1 20000 HCMEC D3
      1147   50  RMSE  E01   0.03000         0 1 : Experiment 1 15000 HCMEC D3
      1148   50  RMSE  E02   0.03000         0 1 : Experiment 1 15000 HCMEC D3
      1149   50  RMSE  E03   0.03000         0 1 : Experiment 1 15000 HCMEC D3
      1150   50  RMSE  F01   0.04000         0 1 : Experiment 1 10000 HCMEC D3
      1151   50  RMSE  F02   0.04000         0 1 : Experiment 1 10000 HCMEC D3
      1152   50  RMSE  F03   0.04000         0 1 : Experiment 1 10000 HCMEC D3
      1153   50  RMSE  G01   0.02000         0 1 : Experiment 1  5000 HCMEC D3
      1154   50  RMSE  G02   0.02000         0 1 : Experiment 1  5000 HCMEC D3
      1155   50  RMSE  G03   0.02000         0 1 : Experiment 1  5000 HCMEC D3
      1156   55 Alpha  A01   4.34000         0 1 : Experiment 1 35000 HCMEC D3
      1157   55 Alpha  A02   4.26000         0 1 : Experiment 1 35000 HCMEC D3
      1158   55 Alpha  A03   4.39000         0 1 : Experiment 1 35000 HCMEC D3
      1159   55 Alpha  B01   4.53000         0 1 : Experiment 1 30000 HCMEC D3
      1160   55 Alpha  B02   4.62000         0 1 : Experiment 1 30000 HCMEC D3
      1161   55 Alpha  B03   5.05000         0 1 : Experiment 1 30000 HCMEC D3
      1162   55 Alpha  C01   5.38000         0 1 : Experiment 1 25000 HCMEC D3
      1163   55 Alpha  C02   5.18000         0 1 : Experiment 1 25000 HCMEC D3
      1164   55 Alpha  C03   5.41000         0 1 : Experiment 1 25000 HCMEC D3
      1165   55 Alpha  D01   5.52000         0 1 : Experiment 1 20000 HCMEC D3
      1166   55 Alpha  D02   5.67000         0 1 : Experiment 1 20000 HCMEC D3
      1167   55 Alpha  D03   5.49000         0 1 : Experiment 1 20000 HCMEC D3
      1168   55 Alpha  E01   4.84000         0 1 : Experiment 1 15000 HCMEC D3
      1169   55 Alpha  E02   4.71000         0 1 : Experiment 1 15000 HCMEC D3
      1170   55 Alpha  E03   4.85000         0 1 : Experiment 1 15000 HCMEC D3
      1171   55 Alpha  F01   4.27000         0 1 : Experiment 1 10000 HCMEC D3
      1172   55 Alpha  F02   3.94000         0 1 : Experiment 1 10000 HCMEC D3
      1173   55 Alpha  F03   4.21000         0 1 : Experiment 1 10000 HCMEC D3
      1174   55 Alpha  G01   2.57000         0 1 : Experiment 1  5000 HCMEC D3
      1175   55 Alpha  G02   2.40000         0 1 : Experiment 1  5000 HCMEC D3
      1176   55 Alpha  G03   2.54000         0 1 : Experiment 1  5000 HCMEC D3
      1177   55    Cm  A01   1.12000         0 1 : Experiment 1 35000 HCMEC D3
      1178   55    Cm  A02   1.07000         0 1 : Experiment 1 35000 HCMEC D3
      1179   55    Cm  A03   1.08000         0 1 : Experiment 1 35000 HCMEC D3
      1180   55    Cm  B01   1.06000         0 1 : Experiment 1 30000 HCMEC D3
      1181   55    Cm  B02   1.06000         0 1 : Experiment 1 30000 HCMEC D3
      1182   55    Cm  B03   1.27000         0 1 : Experiment 1 30000 HCMEC D3
      1183   55    Cm  C01   1.56000         0 1 : Experiment 1 25000 HCMEC D3
      1184   55    Cm  C02   1.37000         0 1 : Experiment 1 25000 HCMEC D3
      1185   55    Cm  C03   1.78000         0 1 : Experiment 1 25000 HCMEC D3
      1186   55    Cm  D01   2.35000         0 1 : Experiment 1 20000 HCMEC D3
      1187   55    Cm  D02   2.17000         0 1 : Experiment 1 20000 HCMEC D3
      1188   55    Cm  D03   2.16000         0 1 : Experiment 1 20000 HCMEC D3
      1189   55    Cm  E01   4.88000         0 1 : Experiment 1 15000 HCMEC D3
      1190   55    Cm  E02   5.67000         0 1 : Experiment 1 15000 HCMEC D3
      1191   55    Cm  E03   5.52000         0 1 : Experiment 1 15000 HCMEC D3
      1192   55    Cm  F01   7.91000         0 1 : Experiment 1 10000 HCMEC D3
      1193   55    Cm  F02  12.39000         0 1 : Experiment 1 10000 HCMEC D3
      1194   55    Cm  F03   9.01000         0 1 : Experiment 1 10000 HCMEC D3
      1195   55    Cm  G01  38.63000         0 1 : Experiment 1  5000 HCMEC D3
      1196   55    Cm  G02  43.79000         0 1 : Experiment 1  5000 HCMEC D3
      1197   55    Cm  G03  31.57000         0 1 : Experiment 1  5000 HCMEC D3
      1198   55 Drift  A01  -5.00000         0 1 : Experiment 1 35000 HCMEC D3
      1199   55 Drift  A02  -5.20000         0 1 : Experiment 1 35000 HCMEC D3
      1200   55 Drift  A03  -4.72000         0 1 : Experiment 1 35000 HCMEC D3
      1201   55 Drift  B01  -5.36000         0 1 : Experiment 1 30000 HCMEC D3
      1202   55 Drift  B02  -5.60000         0 1 : Experiment 1 30000 HCMEC D3
      1203   55 Drift  B03  -5.19000         0 1 : Experiment 1 30000 HCMEC D3
      1204   55 Drift  C01  -5.84000         0 1 : Experiment 1 25000 HCMEC D3
      1205   55 Drift  C02  -5.91000         0 1 : Experiment 1 25000 HCMEC D3
      1206   55 Drift  C03  -5.42000         0 1 : Experiment 1 25000 HCMEC D3
      1207   55 Drift  D01  -5.73000         0 1 : Experiment 1 20000 HCMEC D3
      1208   55 Drift  D02  -5.85000         0 1 : Experiment 1 20000 HCMEC D3
      1209   55 Drift  D03  -4.99000         0 1 : Experiment 1 20000 HCMEC D3
      1210   55 Drift  E01  -4.37000         0 1 : Experiment 1 15000 HCMEC D3
      1211   55 Drift  E02  -4.47000         0 1 : Experiment 1 15000 HCMEC D3
      1212   55 Drift  E03  -4.33000         0 1 : Experiment 1 15000 HCMEC D3
      1213   55 Drift  F01  -4.14000         0 1 : Experiment 1 10000 HCMEC D3
      1214   55 Drift  F02  -4.06000         0 1 : Experiment 1 10000 HCMEC D3
      1215   55 Drift  F03  -3.63000         0 1 : Experiment 1 10000 HCMEC D3
      1216   55 Drift  G01  -2.74000         0 1 : Experiment 1  5000 HCMEC D3
      1217   55 Drift  G02  -2.67000         0 1 : Experiment 1  5000 HCMEC D3
      1218   55 Drift  G03  -2.38000         0 1 : Experiment 1  5000 HCMEC D3
      1219   55    Rb  A01   2.49000         0 1 : Experiment 1 35000 HCMEC D3
      1220   55    Rb  A02   2.75000         0 1 : Experiment 1 35000 HCMEC D3
      1221   55    Rb  A03   2.41000         0 1 : Experiment 1 35000 HCMEC D3
      1222   55    Rb  B01   2.57000         0 1 : Experiment 1 30000 HCMEC D3
      1223   55    Rb  B02   2.61000         0 1 : Experiment 1 30000 HCMEC D3
      1224   55    Rb  B03   1.72000         0 1 : Experiment 1 30000 HCMEC D3
      1225   55    Rb  C01   1.20000         0 1 : Experiment 1 25000 HCMEC D3
      1226   55    Rb  C02   1.45000         0 1 : Experiment 1 25000 HCMEC D3
      1227   55    Rb  C03   0.70000         0 1 : Experiment 1 25000 HCMEC D3
      1228   55    Rb  D01   0.00000         0 1 : Experiment 1 20000 HCMEC D3
      1229   55    Rb  D02   0.12000         0 1 : Experiment 1 20000 HCMEC D3
      1230   55    Rb  D03   0.00000         0 1 : Experiment 1 20000 HCMEC D3
      1231   55    Rb  E01   0.00000         0 1 : Experiment 1 15000 HCMEC D3
      1232   55    Rb  E02   0.00000         0 1 : Experiment 1 15000 HCMEC D3
      1233   55    Rb  E03   0.00000         0 1 : Experiment 1 15000 HCMEC D3
      1234   55    Rb  F01   0.00000         0 1 : Experiment 1 10000 HCMEC D3
      1235   55    Rb  F02   0.00000         0 1 : Experiment 1 10000 HCMEC D3
      1236   55    Rb  F03   0.00000         0 1 : Experiment 1 10000 HCMEC D3
      1237   55    Rb  G01   0.00000         0 1 : Experiment 1  5000 HCMEC D3
      1238   55    Rb  G02   0.00000         0 1 : Experiment 1  5000 HCMEC D3
      1239   55    Rb  G03   0.00000         0 1 : Experiment 1  5000 HCMEC D3
      1240   55  RMSE  A01   0.01000         0 1 : Experiment 1 35000 HCMEC D3
      1241   55  RMSE  A02   0.01000         0 1 : Experiment 1 35000 HCMEC D3
      1242   55  RMSE  A03   0.01000         0 1 : Experiment 1 35000 HCMEC D3
      1243   55  RMSE  B01   0.01000         0 1 : Experiment 1 30000 HCMEC D3
      1244   55  RMSE  B02   0.01000         0 1 : Experiment 1 30000 HCMEC D3
      1245   55  RMSE  B03   0.01000         0 1 : Experiment 1 30000 HCMEC D3
      1246   55  RMSE  C01   0.02000         0 1 : Experiment 1 25000 HCMEC D3
      1247   55  RMSE  C02   0.01000         0 1 : Experiment 1 25000 HCMEC D3
      1248   55  RMSE  C03   0.01000         0 1 : Experiment 1 25000 HCMEC D3
      1249   55  RMSE  D01   0.02000         0 1 : Experiment 1 20000 HCMEC D3
      1250   55  RMSE  D02   0.01000         0 1 : Experiment 1 20000 HCMEC D3
      1251   55  RMSE  D03   0.01000         0 1 : Experiment 1 20000 HCMEC D3
      1252   55  RMSE  E01   0.03000         0 1 : Experiment 1 15000 HCMEC D3
      1253   55  RMSE  E02   0.03000         0 1 : Experiment 1 15000 HCMEC D3
      1254   55  RMSE  E03   0.03000         0 1 : Experiment 1 15000 HCMEC D3
      1255   55  RMSE  F01   0.04000         0 1 : Experiment 1 10000 HCMEC D3
      1256   55  RMSE  F02   0.04000         0 1 : Experiment 1 10000 HCMEC D3
      1257   55  RMSE  F03   0.04000         0 1 : Experiment 1 10000 HCMEC D3
      1258   55  RMSE  G01   0.02000         0 1 : Experiment 1  5000 HCMEC D3
      1259   55  RMSE  G02   0.02000         0 1 : Experiment 1  5000 HCMEC D3
      1260   55  RMSE  G03   0.03000         0 1 : Experiment 1  5000 HCMEC D3
      1261   60 Alpha  A01   4.18000         0 1 : Experiment 1 35000 HCMEC D3
      1262   60 Alpha  A02   4.15000         0 1 : Experiment 1 35000 HCMEC D3
      1263   60 Alpha  A03   4.19000         0 1 : Experiment 1 35000 HCMEC D3
      1264   60 Alpha  B01   4.37000         0 1 : Experiment 1 30000 HCMEC D3
      1265   60 Alpha  B02   4.49000         0 1 : Experiment 1 30000 HCMEC D3
      1266   60 Alpha  B03   4.78000         0 1 : Experiment 1 30000 HCMEC D3
      1267   60 Alpha  C01   5.06000         0 1 : Experiment 1 25000 HCMEC D3
      1268   60 Alpha  C02   4.99000         0 1 : Experiment 1 25000 HCMEC D3
      1269   60 Alpha  C03   5.10000         0 1 : Experiment 1 25000 HCMEC D3
      1270   60 Alpha  D01   5.63000         0 1 : Experiment 1 20000 HCMEC D3
      1271   60 Alpha  D02   5.55000         0 1 : Experiment 1 20000 HCMEC D3
      1272   60 Alpha  D03   5.46000         0 1 : Experiment 1 20000 HCMEC D3
      1273   60 Alpha  E01   5.19000         0 1 : Experiment 1 15000 HCMEC D3
      1274   60 Alpha  E02   4.95000         0 1 : Experiment 1 15000 HCMEC D3
      1275   60 Alpha  E03   5.07000         0 1 : Experiment 1 15000 HCMEC D3
      1276   60 Alpha  F01   4.55000         0 1 : Experiment 1 10000 HCMEC D3
      1277   60 Alpha  F02   4.16000         0 1 : Experiment 1 10000 HCMEC D3
      1278   60 Alpha  F03   4.51000         0 1 : Experiment 1 10000 HCMEC D3
      1279   60 Alpha  G01   2.80000         0 1 : Experiment 1  5000 HCMEC D3
      1280   60 Alpha  G02   2.70000         0 1 : Experiment 1  5000 HCMEC D3
      1281   60 Alpha  G03   2.76000         0 1 : Experiment 1  5000 HCMEC D3
      1282   60    Cm  A01   1.11000         0 1 : Experiment 1 35000 HCMEC D3
      1283   60    Cm  A02   1.09000         0 1 : Experiment 1 35000 HCMEC D3
      1284   60    Cm  A03   1.08000         0 1 : Experiment 1 35000 HCMEC D3
      1285   60    Cm  B01   1.07000         0 1 : Experiment 1 30000 HCMEC D3
      1286   60    Cm  B02   1.05000         0 1 : Experiment 1 30000 HCMEC D3
      1287   60    Cm  B03   1.14000         0 1 : Experiment 1 30000 HCMEC D3
      1288   60    Cm  C01   1.28000         0 1 : Experiment 1 25000 HCMEC D3
      1289   60    Cm  C02   1.20000         0 1 : Experiment 1 25000 HCMEC D3
      1290   60    Cm  C03   1.44000         0 1 : Experiment 1 25000 HCMEC D3
      1291   60    Cm  D01   1.78000         0 1 : Experiment 1 20000 HCMEC D3
      1292   60    Cm  D02   1.81000         0 1 : Experiment 1 20000 HCMEC D3
      1293   60    Cm  D03   1.83000         0 1 : Experiment 1 20000 HCMEC D3
      1294   60    Cm  E01   3.37000         0 1 : Experiment 1 15000 HCMEC D3
      1295   60    Cm  E02   4.00000         0 1 : Experiment 1 15000 HCMEC D3
      1296   60    Cm  E03   4.34000         0 1 : Experiment 1 15000 HCMEC D3
      1297   60    Cm  F01   6.24000         0 1 : Experiment 1 10000 HCMEC D3
      1298   60    Cm  F02   9.92000         0 1 : Experiment 1 10000 HCMEC D3
      1299   60    Cm  F03   6.96000         0 1 : Experiment 1 10000 HCMEC D3
      1300   60    Cm  G01  32.24000         0 1 : Experiment 1  5000 HCMEC D3
      1301   60    Cm  G02  36.54000         0 1 : Experiment 1  5000 HCMEC D3
      1302   60    Cm  G03  28.65000         0 1 : Experiment 1  5000 HCMEC D3
      1303   60 Drift  A01  -5.06000         0 1 : Experiment 1 35000 HCMEC D3
      1304   60 Drift  A02  -5.28000         0 1 : Experiment 1 35000 HCMEC D3
      1305   60 Drift  A03  -4.79000         0 1 : Experiment 1 35000 HCMEC D3
      1306   60 Drift  B01  -5.45000         0 1 : Experiment 1 30000 HCMEC D3
      1307   60 Drift  B02  -5.70000         0 1 : Experiment 1 30000 HCMEC D3
      1308   60 Drift  B03  -5.28000         0 1 : Experiment 1 30000 HCMEC D3
      1309   60 Drift  C01  -5.87000         0 1 : Experiment 1 25000 HCMEC D3
      1310   60 Drift  C02  -6.01000         0 1 : Experiment 1 25000 HCMEC D3
      1311   60 Drift  C03  -5.51000         0 1 : Experiment 1 25000 HCMEC D3
      1312   60 Drift  D01  -5.77000         0 1 : Experiment 1 20000 HCMEC D3
      1313   60 Drift  D02  -6.07000         0 1 : Experiment 1 20000 HCMEC D3
      1314   60 Drift  D03  -5.15000         0 1 : Experiment 1 20000 HCMEC D3
      1315   60 Drift  E01  -4.55000         0 1 : Experiment 1 15000 HCMEC D3
      1316   60 Drift  E02  -4.65000         0 1 : Experiment 1 15000 HCMEC D3
      1317   60 Drift  E03  -4.49000         0 1 : Experiment 1 15000 HCMEC D3
      1318   60 Drift  F01  -4.36000         0 1 : Experiment 1 10000 HCMEC D3
      1319   60 Drift  F02  -4.19000         0 1 : Experiment 1 10000 HCMEC D3
      1320   60 Drift  F03  -3.86000         0 1 : Experiment 1 10000 HCMEC D3
      1321   60 Drift  G01  -2.99000         0 1 : Experiment 1  5000 HCMEC D3
      1322   60 Drift  G02  -2.96000         0 1 : Experiment 1  5000 HCMEC D3
      1323   60 Drift  G03  -2.62000         0 1 : Experiment 1  5000 HCMEC D3
      1324   60    Rb  A01   2.61000         0 1 : Experiment 1 35000 HCMEC D3
      1325   60    Rb  A02   2.82000         0 1 : Experiment 1 35000 HCMEC D3
      1326   60    Rb  A03   2.55000         0 1 : Experiment 1 35000 HCMEC D3
      1327   60    Rb  B01   2.75000         0 1 : Experiment 1 30000 HCMEC D3
      1328   60    Rb  B02   2.78000         0 1 : Experiment 1 30000 HCMEC D3
      1329   60    Rb  B03   2.20000         0 1 : Experiment 1 30000 HCMEC D3
      1330   60    Rb  C01   1.91000         0 1 : Experiment 1 25000 HCMEC D3
      1331   60    Rb  C02   1.99000         0 1 : Experiment 1 25000 HCMEC D3
      1332   60    Rb  C03   1.38000         0 1 : Experiment 1 25000 HCMEC D3
      1333   60    Rb  D01   0.41000         0 1 : Experiment 1 20000 HCMEC D3
      1334   60    Rb  D02   0.69000         0 1 : Experiment 1 20000 HCMEC D3
      1335   60    Rb  D03   0.44000         0 1 : Experiment 1 20000 HCMEC D3
      1336   60    Rb  E01   0.00000         0 1 : Experiment 1 15000 HCMEC D3
      1337   60    Rb  E02   0.00000         0 1 : Experiment 1 15000 HCMEC D3
      1338   60    Rb  E03   0.00000         0 1 : Experiment 1 15000 HCMEC D3
      1339   60    Rb  F01   0.00000         0 1 : Experiment 1 10000 HCMEC D3
      1340   60    Rb  F02   0.00000         0 1 : Experiment 1 10000 HCMEC D3
      1341   60    Rb  F03   0.00000         0 1 : Experiment 1 10000 HCMEC D3
      1342   60    Rb  G01   0.00000         0 1 : Experiment 1  5000 HCMEC D3
      1343   60    Rb  G02   0.00000         0 1 : Experiment 1  5000 HCMEC D3
      1344   60    Rb  G03   0.00000         0 1 : Experiment 1  5000 HCMEC D3
      1345   60  RMSE  A01   0.01000         0 1 : Experiment 1 35000 HCMEC D3
      1346   60  RMSE  A02   0.01000         0 1 : Experiment 1 35000 HCMEC D3
      1347   60  RMSE  A03   0.01000         0 1 : Experiment 1 35000 HCMEC D3
      1348   60  RMSE  B01   0.01000         0 1 : Experiment 1 30000 HCMEC D3
      1349   60  RMSE  B02   0.01000         0 1 : Experiment 1 30000 HCMEC D3
      1350   60  RMSE  B03   0.01000         0 1 : Experiment 1 30000 HCMEC D3
      1351   60  RMSE  C01   0.01000         0 1 : Experiment 1 25000 HCMEC D3
      1352   60  RMSE  C02   0.01000         0 1 : Experiment 1 25000 HCMEC D3
      1353   60  RMSE  C03   0.01000         0 1 : Experiment 1 25000 HCMEC D3
      1354   60  RMSE  D01   0.02000         0 1 : Experiment 1 20000 HCMEC D3
      1355   60  RMSE  D02   0.02000         0 1 : Experiment 1 20000 HCMEC D3
      1356   60  RMSE  D03   0.01000         0 1 : Experiment 1 20000 HCMEC D3
      1357   60  RMSE  E01   0.03000         0 1 : Experiment 1 15000 HCMEC D3
      1358   60  RMSE  E02   0.03000         0 1 : Experiment 1 15000 HCMEC D3
      1359   60  RMSE  E03   0.03000         0 1 : Experiment 1 15000 HCMEC D3
      1360   60  RMSE  F01   0.04000         0 1 : Experiment 1 10000 HCMEC D3
      1361   60  RMSE  F02   0.05000         0 1 : Experiment 1 10000 HCMEC D3
      1362   60  RMSE  F03   0.04000         0 1 : Experiment 1 10000 HCMEC D3
      1363   60  RMSE  G01   0.03000         0 1 : Experiment 1  5000 HCMEC D3
      1364   60  RMSE  G02   0.02000         0 1 : Experiment 1  5000 HCMEC D3
      1365   60  RMSE  G03   0.03000         0 1 : Experiment 1  5000 HCMEC D3
      1366   65 Alpha  A01   4.01000         0 1 : Experiment 1 35000 HCMEC D3
      1367   65 Alpha  A02   4.05000         0 1 : Experiment 1 35000 HCMEC D3
      1368   65 Alpha  A03   4.02000         0 1 : Experiment 1 35000 HCMEC D3
      1369   65 Alpha  B01   4.28000         0 1 : Experiment 1 30000 HCMEC D3
      1370   65 Alpha  B02   4.36000         0 1 : Experiment 1 30000 HCMEC D3
      1371   65 Alpha  B03   4.53000         0 1 : Experiment 1 30000 HCMEC D3
      1372   65 Alpha  C01   4.73000         0 1 : Experiment 1 25000 HCMEC D3
      1373   65 Alpha  C02   4.69000         0 1 : Experiment 1 25000 HCMEC D3
      1374   65 Alpha  C03   4.80000         0 1 : Experiment 1 25000 HCMEC D3
      1375   65 Alpha  D01   5.42000         0 1 : Experiment 1 20000 HCMEC D3
      1376   65 Alpha  D02   5.32000         0 1 : Experiment 1 20000 HCMEC D3
      1377   65 Alpha  D03   5.30000         0 1 : Experiment 1 20000 HCMEC D3
      1378   65 Alpha  E01   5.62000         0 1 : Experiment 1 15000 HCMEC D3
      1379   65 Alpha  E02   5.40000         0 1 : Experiment 1 15000 HCMEC D3
      1380   65 Alpha  E03   5.37000         0 1 : Experiment 1 15000 HCMEC D3
      1381   65 Alpha  F01   4.75000         0 1 : Experiment 1 10000 HCMEC D3
      1382   65 Alpha  F02   4.46000         0 1 : Experiment 1 10000 HCMEC D3
      1383   65 Alpha  F03   4.79000         0 1 : Experiment 1 10000 HCMEC D3
      1384   65 Alpha  G01   3.04000         0 1 : Experiment 1  5000 HCMEC D3
      1385   65 Alpha  G02   2.85000         0 1 : Experiment 1  5000 HCMEC D3
      1386   65 Alpha  G03   2.99000         0 1 : Experiment 1  5000 HCMEC D3
      1387   65    Cm  A01   1.12000         0 1 : Experiment 1 35000 HCMEC D3
      1388   65    Cm  A02   1.09000         0 1 : Experiment 1 35000 HCMEC D3
      1389   65    Cm  A03   1.08000         0 1 : Experiment 1 35000 HCMEC D3
      1390   65    Cm  B01   1.07000         0 1 : Experiment 1 30000 HCMEC D3
      1391   65    Cm  B02   1.05000         0 1 : Experiment 1 30000 HCMEC D3
      1392   65    Cm  B03   1.08000         0 1 : Experiment 1 30000 HCMEC D3
      1393   65    Cm  C01   1.12000         0 1 : Experiment 1 25000 HCMEC D3
      1394   65    Cm  C02   1.09000         0 1 : Experiment 1 25000 HCMEC D3
      1395   65    Cm  C03   1.20000         0 1 : Experiment 1 25000 HCMEC D3
      1396   65    Cm  D01   1.53000         0 1 : Experiment 1 20000 HCMEC D3
      1397   65    Cm  D02   1.44000         0 1 : Experiment 1 20000 HCMEC D3
      1398   65    Cm  D03   1.58000         0 1 : Experiment 1 20000 HCMEC D3
      1399   65    Cm  E01   1.94000         0 1 : Experiment 1 15000 HCMEC D3
      1400   65    Cm  E02   2.42000         0 1 : Experiment 1 15000 HCMEC D3
      1401   65    Cm  E03   2.87000         0 1 : Experiment 1 15000 HCMEC D3
      1402   65    Cm  F01   4.67000         0 1 : Experiment 1 10000 HCMEC D3
      1403   65    Cm  F02   7.33000         0 1 : Experiment 1 10000 HCMEC D3
      1404   65    Cm  F03   5.28000         0 1 : Experiment 1 10000 HCMEC D3
      1405   65    Cm  G01  27.08000         0 1 : Experiment 1  5000 HCMEC D3
      1406   65    Cm  G02  32.99000         0 1 : Experiment 1  5000 HCMEC D3
      1407   65    Cm  G03  22.71000         0 1 : Experiment 1  5000 HCMEC D3
      1408   65 Drift  A01  -5.11000         0 1 : Experiment 1 35000 HCMEC D3
      1409   65 Drift  A02  -5.33000         0 1 : Experiment 1 35000 HCMEC D3
      1410   65 Drift  A03  -4.87000         0 1 : Experiment 1 35000 HCMEC D3
      1411   65 Drift  B01  -5.52000         0 1 : Experiment 1 30000 HCMEC D3
      1412   65 Drift  B02  -5.77000         0 1 : Experiment 1 30000 HCMEC D3
      1413   65 Drift  B03  -5.35000         0 1 : Experiment 1 30000 HCMEC D3
      1414   65 Drift  C01  -5.93000         0 1 : Experiment 1 25000 HCMEC D3
      1415   65 Drift  C02  -6.07000         0 1 : Experiment 1 25000 HCMEC D3
      1416   65 Drift  C03  -5.60000         0 1 : Experiment 1 25000 HCMEC D3
      1417   65 Drift  D01  -5.83000         0 1 : Experiment 1 20000 HCMEC D3
      1418   65 Drift  D02  -6.16000         0 1 : Experiment 1 20000 HCMEC D3
      1419   65 Drift  D03  -5.26000         0 1 : Experiment 1 20000 HCMEC D3
      1420   65 Drift  E01  -4.68000         0 1 : Experiment 1 15000 HCMEC D3
      1421   65 Drift  E02  -4.86000         0 1 : Experiment 1 15000 HCMEC D3
      1422   65 Drift  E03  -4.67000         0 1 : Experiment 1 15000 HCMEC D3
      1423   65 Drift  F01  -4.54000         0 1 : Experiment 1 10000 HCMEC D3
      1424   65 Drift  F02  -4.40000         0 1 : Experiment 1 10000 HCMEC D3
      1425   65 Drift  F03  -4.15000         0 1 : Experiment 1 10000 HCMEC D3
      1426   65 Drift  G01  -3.24000         0 1 : Experiment 1  5000 HCMEC D3
      1427   65 Drift  G02  -3.16000         0 1 : Experiment 1  5000 HCMEC D3
      1428   65 Drift  G03  -2.83000         0 1 : Experiment 1  5000 HCMEC D3
      1429   65    Rb  A01   2.68000         0 1 : Experiment 1 35000 HCMEC D3
      1430   65    Rb  A02   2.80000         0 1 : Experiment 1 35000 HCMEC D3
      1431   65    Rb  A03   2.60000         0 1 : Experiment 1 35000 HCMEC D3
      1432   65    Rb  B01   2.83000         0 1 : Experiment 1 30000 HCMEC D3
      1433   65    Rb  B02   2.87000         0 1 : Experiment 1 30000 HCMEC D3
      1434   65    Rb  B03   2.52000         0 1 : Experiment 1 30000 HCMEC D3
      1435   65    Rb  C01   2.44000         0 1 : Experiment 1 25000 HCMEC D3
      1436   65    Rb  C02   2.47000         0 1 : Experiment 1 25000 HCMEC D3
      1437   65    Rb  C03   1.99000         0 1 : Experiment 1 25000 HCMEC D3
      1438   65    Rb  D01   1.09000         0 1 : Experiment 1 20000 HCMEC D3
      1439   65    Rb  D02   1.32000         0 1 : Experiment 1 20000 HCMEC D3
      1440   65    Rb  D03   1.08000         0 1 : Experiment 1 20000 HCMEC D3
      1441   65    Rb  E01   0.00000         0 1 : Experiment 1 15000 HCMEC D3
      1442   65    Rb  E02   0.00000         0 1 : Experiment 1 15000 HCMEC D3
      1443   65    Rb  E03   0.00000         0 1 : Experiment 1 15000 HCMEC D3
      1444   65    Rb  F01   0.00000         0 1 : Experiment 1 10000 HCMEC D3
      1445   65    Rb  F02   0.00000         0 1 : Experiment 1 10000 HCMEC D3
      1446   65    Rb  F03   0.00000         0 1 : Experiment 1 10000 HCMEC D3
      1447   65    Rb  G01   0.00000         0 1 : Experiment 1  5000 HCMEC D3
      1448   65    Rb  G02   0.00000         0 1 : Experiment 1  5000 HCMEC D3
      1449   65    Rb  G03   0.00000         0 1 : Experiment 1  5000 HCMEC D3
      1450   65  RMSE  A01   0.01000         0 1 : Experiment 1 35000 HCMEC D3
      1451   65  RMSE  A02   0.01000         0 1 : Experiment 1 35000 HCMEC D3
      1452   65  RMSE  A03   0.01000         0 1 : Experiment 1 35000 HCMEC D3
      1453   65  RMSE  B01   0.01000         0 1 : Experiment 1 30000 HCMEC D3
      1454   65  RMSE  B02   0.01000         0 1 : Experiment 1 30000 HCMEC D3
      1455   65  RMSE  B03   0.01000         0 1 : Experiment 1 30000 HCMEC D3
      1456   65  RMSE  C01   0.01000         0 1 : Experiment 1 25000 HCMEC D3
      1457   65  RMSE  C02   0.01000         0 1 : Experiment 1 25000 HCMEC D3
      1458   65  RMSE  C03   0.01000         0 1 : Experiment 1 25000 HCMEC D3
      1459   65  RMSE  D01   0.02000         0 1 : Experiment 1 20000 HCMEC D3
      1460   65  RMSE  D02   0.01000         0 1 : Experiment 1 20000 HCMEC D3
      1461   65  RMSE  D03   0.01000         0 1 : Experiment 1 20000 HCMEC D3
      1462   65  RMSE  E01   0.02000         0 1 : Experiment 1 15000 HCMEC D3
      1463   65  RMSE  E02   0.02000         0 1 : Experiment 1 15000 HCMEC D3
      1464   65  RMSE  E03   0.02000         0 1 : Experiment 1 15000 HCMEC D3
      1465   65  RMSE  F01   0.04000         0 1 : Experiment 1 10000 HCMEC D3
      1466   65  RMSE  F02   0.05000         0 1 : Experiment 1 10000 HCMEC D3
      1467   65  RMSE  F03   0.04000         0 1 : Experiment 1 10000 HCMEC D3
      1468   65  RMSE  G01   0.03000         0 1 : Experiment 1  5000 HCMEC D3
      1469   65  RMSE  G02   0.03000         0 1 : Experiment 1  5000 HCMEC D3
      1470   65  RMSE  G03   0.03000         0 1 : Experiment 1  5000 HCMEC D3
      1471   70 Alpha  A01   3.90000         0 1 : Experiment 1 35000 HCMEC D3
      1472   70 Alpha  A02   3.96000         0 1 : Experiment 1 35000 HCMEC D3
      1473   70 Alpha  A03   3.92000         0 1 : Experiment 1 35000 HCMEC D3
      1474   70 Alpha  B01   4.18000         0 1 : Experiment 1 30000 HCMEC D3
      1475   70 Alpha  B02   4.23000         0 1 : Experiment 1 30000 HCMEC D3
      1476   70 Alpha  B03   4.34000         0 1 : Experiment 1 30000 HCMEC D3
      1477   70 Alpha  C01   4.51000         0 1 : Experiment 1 25000 HCMEC D3
      1478   70 Alpha  C02   4.53000         0 1 : Experiment 1 25000 HCMEC D3
      1479   70 Alpha  C03   4.58000         0 1 : Experiment 1 25000 HCMEC D3
      1480   70 Alpha  D01   5.21000         0 1 : Experiment 1 20000 HCMEC D3
      1481   70 Alpha  D02   4.99000         0 1 : Experiment 1 20000 HCMEC D3
      1482   70 Alpha  D03   5.05000         0 1 : Experiment 1 20000 HCMEC D3
      1483   70 Alpha  E01   5.48000         0 1 : Experiment 1 15000 HCMEC D3
      1484   70 Alpha  E02   5.61000         0 1 : Experiment 1 15000 HCMEC D3
      1485   70 Alpha  E03   5.73000         0 1 : Experiment 1 15000 HCMEC D3
      1486   70 Alpha  F01   5.11000         0 1 : Experiment 1 10000 HCMEC D3
      1487   70 Alpha  F02   4.61000         0 1 : Experiment 1 10000 HCMEC D3
      1488   70 Alpha  F03   5.05000         0 1 : Experiment 1 10000 HCMEC D3
      1489   70 Alpha  G01   3.16000         0 1 : Experiment 1  5000 HCMEC D3
      1490   70 Alpha  G02   2.99000         0 1 : Experiment 1  5000 HCMEC D3
      1491   70 Alpha  G03   3.18000         0 1 : Experiment 1  5000 HCMEC D3
      1492   70    Cm  A01   1.13000         0 1 : Experiment 1 35000 HCMEC D3
      1493   70    Cm  A02   1.10000         0 1 : Experiment 1 35000 HCMEC D3
      1494   70    Cm  A03   1.09000         0 1 : Experiment 1 35000 HCMEC D3
      1495   70    Cm  B01   1.07000         0 1 : Experiment 1 30000 HCMEC D3
      1496   70    Cm  B02   1.06000         0 1 : Experiment 1 30000 HCMEC D3
      1497   70    Cm  B03   1.06000         0 1 : Experiment 1 30000 HCMEC D3
      1498   70    Cm  C01   1.05000         0 1 : Experiment 1 25000 HCMEC D3
      1499   70    Cm  C02   1.04000         0 1 : Experiment 1 25000 HCMEC D3
      1500   70    Cm  C03   1.11000         0 1 : Experiment 1 25000 HCMEC D3
      1501   70    Cm  D01   1.33000         0 1 : Experiment 1 20000 HCMEC D3
      1502   70    Cm  D02   1.20000         0 1 : Experiment 1 20000 HCMEC D3
      1503   70    Cm  D03   1.31000         0 1 : Experiment 1 20000 HCMEC D3
      1504   70    Cm  E01   1.82000         0 1 : Experiment 1 15000 HCMEC D3
      1505   70    Cm  E02   1.78000         0 1 : Experiment 1 15000 HCMEC D3
      1506   70    Cm  E03   1.77000         0 1 : Experiment 1 15000 HCMEC D3
      1507   70    Cm  F01   3.26000         0 1 : Experiment 1 10000 HCMEC D3
      1508   70    Cm  F02   5.95000         0 1 : Experiment 1 10000 HCMEC D3
      1509   70    Cm  F03   3.56000         0 1 : Experiment 1 10000 HCMEC D3
      1510   70    Cm  G01  22.35000         0 1 : Experiment 1  5000 HCMEC D3
      1511   70    Cm  G02  24.38000         0 1 : Experiment 1  5000 HCMEC D3
      1512   70    Cm  G03  19.38000         0 1 : Experiment 1  5000 HCMEC D3
      1513   70 Drift  A01  -5.17000         0 1 : Experiment 1 35000 HCMEC D3
      1514   70 Drift  A02  -5.41000         0 1 : Experiment 1 35000 HCMEC D3
      1515   70 Drift  A03  -4.94000         0 1 : Experiment 1 35000 HCMEC D3
      1516   70 Drift  B01  -5.61000         0 1 : Experiment 1 30000 HCMEC D3
      1517   70 Drift  B02  -5.86000         0 1 : Experiment 1 30000 HCMEC D3
      1518   70 Drift  B03  -5.40000         0 1 : Experiment 1 30000 HCMEC D3
      1519   70 Drift  C01  -5.98000         0 1 : Experiment 1 25000 HCMEC D3
      1520   70 Drift  C02  -6.17000         0 1 : Experiment 1 25000 HCMEC D3
      1521   70 Drift  C03  -5.66000         0 1 : Experiment 1 25000 HCMEC D3
      1522   70 Drift  D01  -5.85000         0 1 : Experiment 1 20000 HCMEC D3
      1523   70 Drift  D02  -6.25000         0 1 : Experiment 1 20000 HCMEC D3
      1524   70 Drift  D03  -5.32000         0 1 : Experiment 1 20000 HCMEC D3
      1525   70 Drift  E01  -4.75000         0 1 : Experiment 1 15000 HCMEC D3
      1526   70 Drift  E02  -4.98000         0 1 : Experiment 1 15000 HCMEC D3
      1527   70 Drift  E03  -4.85000         0 1 : Experiment 1 15000 HCMEC D3
      1528   70 Drift  F01  -4.66000         0 1 : Experiment 1 10000 HCMEC D3
      1529   70 Drift  F02  -4.52000         0 1 : Experiment 1 10000 HCMEC D3
      1530   70 Drift  F03  -4.29000         0 1 : Experiment 1 10000 HCMEC D3
      1531   70 Drift  G01  -3.43000         0 1 : Experiment 1  5000 HCMEC D3
      1532   70 Drift  G02  -3.39000         0 1 : Experiment 1  5000 HCMEC D3
      1533   70 Drift  G03  -3.03000         0 1 : Experiment 1  5000 HCMEC D3
      1534   70    Rb  A01   2.66000         0 1 : Experiment 1 35000 HCMEC D3
      1535   70    Rb  A02   2.75000         0 1 : Experiment 1 35000 HCMEC D3
      1536   70    Rb  A03   2.66000         0 1 : Experiment 1 35000 HCMEC D3
      1537   70    Rb  B01   2.91000         0 1 : Experiment 1 30000 HCMEC D3
      1538   70    Rb  B02   2.91000         0 1 : Experiment 1 30000 HCMEC D3
      1539   70    Rb  B03   2.70000         0 1 : Experiment 1 30000 HCMEC D3
      1540   70    Rb  C01   2.82000         0 1 : Experiment 1 25000 HCMEC D3
      1541   70    Rb  C02   2.67000         0 1 : Experiment 1 25000 HCMEC D3
      1542   70    Rb  C03   2.32000         0 1 : Experiment 1 25000 HCMEC D3
      1543   70    Rb  D01   1.57000         0 1 : Experiment 1 20000 HCMEC D3
      1544   70    Rb  D02   1.99000         0 1 : Experiment 1 20000 HCMEC D3
      1545   70    Rb  D03   1.68000         0 1 : Experiment 1 20000 HCMEC D3
      1546   70    Rb  E01   0.64000         0 1 : Experiment 1 15000 HCMEC D3
      1547   70    Rb  E02   0.30000         0 1 : Experiment 1 15000 HCMEC D3
      1548   70    Rb  E03   0.00000         0 1 : Experiment 1 15000 HCMEC D3
      1549   70    Rb  F01   0.00000         0 1 : Experiment 1 10000 HCMEC D3
      1550   70    Rb  F02   0.00000         0 1 : Experiment 1 10000 HCMEC D3
      1551   70    Rb  F03   0.00000         0 1 : Experiment 1 10000 HCMEC D3
      1552   70    Rb  G01   0.00000         0 1 : Experiment 1  5000 HCMEC D3
      1553   70    Rb  G02   0.00000         0 1 : Experiment 1  5000 HCMEC D3
      1554   70    Rb  G03   0.00000         0 1 : Experiment 1  5000 HCMEC D3
      1555   70  RMSE  A01   0.01000         0 1 : Experiment 1 35000 HCMEC D3
      1556   70  RMSE  A02   0.01000         0 1 : Experiment 1 35000 HCMEC D3
      1557   70  RMSE  A03   0.01000         0 1 : Experiment 1 35000 HCMEC D3
      1558   70  RMSE  B01   0.01000         0 1 : Experiment 1 30000 HCMEC D3
      1559   70  RMSE  B02   0.01000         0 1 : Experiment 1 30000 HCMEC D3
      1560   70  RMSE  B03   0.01000         0 1 : Experiment 1 30000 HCMEC D3
      1561   70  RMSE  C01   0.01000         0 1 : Experiment 1 25000 HCMEC D3
      1562   70  RMSE  C02   0.01000         0 1 : Experiment 1 25000 HCMEC D3
      1563   70  RMSE  C03   0.01000         0 1 : Experiment 1 25000 HCMEC D3
      1564   70  RMSE  D01   0.01000         0 1 : Experiment 1 20000 HCMEC D3
      1565   70  RMSE  D02   0.01000         0 1 : Experiment 1 20000 HCMEC D3
      1566   70  RMSE  D03   0.01000         0 1 : Experiment 1 20000 HCMEC D3
      1567   70  RMSE  E01   0.02000         0 1 : Experiment 1 15000 HCMEC D3
      1568   70  RMSE  E02   0.02000         0 1 : Experiment 1 15000 HCMEC D3
      1569   70  RMSE  E03   0.01000         0 1 : Experiment 1 15000 HCMEC D3
      1570   70  RMSE  F01   0.03000         0 1 : Experiment 1 10000 HCMEC D3
      1571   70  RMSE  F02   0.05000         0 1 : Experiment 1 10000 HCMEC D3
      1572   70  RMSE  F03   0.04000         0 1 : Experiment 1 10000 HCMEC D3
      1573   70  RMSE  G01   0.03000         0 1 : Experiment 1  5000 HCMEC D3
      1574   70  RMSE  G02   0.03000         0 1 : Experiment 1  5000 HCMEC D3
      1575   70  RMSE  G03   0.04000         0 1 : Experiment 1  5000 HCMEC D3
      1576   75 Alpha  A01   3.84000         0 1 : Experiment 1 35000 HCMEC D3
      1577   75 Alpha  A02   3.93000         0 1 : Experiment 1 35000 HCMEC D3
      1578   75 Alpha  A03   3.84000         0 1 : Experiment 1 35000 HCMEC D3
      1579   75 Alpha  B01   4.11000         0 1 : Experiment 1 30000 HCMEC D3
      1580   75 Alpha  B02   4.20000         0 1 : Experiment 1 30000 HCMEC D3
      1581   75 Alpha  B03   4.16000         0 1 : Experiment 1 30000 HCMEC D3
      1582   75 Alpha  C01   4.37000         0 1 : Experiment 1 25000 HCMEC D3
      1583   75 Alpha  C02   4.40000         0 1 : Experiment 1 25000 HCMEC D3
      1584   75 Alpha  C03   4.36000         0 1 : Experiment 1 25000 HCMEC D3
      1585   75 Alpha  D01   4.93000         0 1 : Experiment 1 20000 HCMEC D3
      1586   75 Alpha  D02   4.74000         0 1 : Experiment 1 20000 HCMEC D3
      1587   75 Alpha  D03   4.82000         0 1 : Experiment 1 20000 HCMEC D3
      1588   75 Alpha  E01   5.30000         0 1 : Experiment 1 15000 HCMEC D3
      1589   75 Alpha  E02   5.44000         0 1 : Experiment 1 15000 HCMEC D3
      1590   75 Alpha  E03   5.56000         0 1 : Experiment 1 15000 HCMEC D3
      1591   75 Alpha  F01   5.37000         0 1 : Experiment 1 10000 HCMEC D3
      1592   75 Alpha  F02   4.95000         0 1 : Experiment 1 10000 HCMEC D3
      1593   75 Alpha  F03   5.40000         0 1 : Experiment 1 10000 HCMEC D3
      1594   75 Alpha  G01   3.36000         0 1 : Experiment 1  5000 HCMEC D3
      1595   75 Alpha  G02   3.11000         0 1 : Experiment 1  5000 HCMEC D3
      1596   75 Alpha  G03   3.41000         0 1 : Experiment 1  5000 HCMEC D3
      1597   75    Cm  A01   1.14000         0 1 : Experiment 1 35000 HCMEC D3
      1598   75    Cm  A02   1.11000         0 1 : Experiment 1 35000 HCMEC D3
      1599   75    Cm  A03   1.09000         0 1 : Experiment 1 35000 HCMEC D3
      1600   75    Cm  B01   1.08000         0 1 : Experiment 1 30000 HCMEC D3
      1601   75    Cm  B02   1.07000         0 1 : Experiment 1 30000 HCMEC D3
      1602   75    Cm  B03   1.05000         0 1 : Experiment 1 30000 HCMEC D3
      1603   75    Cm  C01   1.06000         0 1 : Experiment 1 25000 HCMEC D3
      1604   75    Cm  C02   1.04000         0 1 : Experiment 1 25000 HCMEC D3
      1605   75    Cm  C03   1.04000         0 1 : Experiment 1 25000 HCMEC D3
      1606   75    Cm  D01   1.19000         0 1 : Experiment 1 20000 HCMEC D3
      1607   75    Cm  D02   1.08000         0 1 : Experiment 1 20000 HCMEC D3
      1608   75    Cm  D03   1.20000         0 1 : Experiment 1 20000 HCMEC D3
      1609   75    Cm  E01   1.46000         0 1 : Experiment 1 15000 HCMEC D3
      1610   75    Cm  E02   1.65000         0 1 : Experiment 1 15000 HCMEC D3
      1611   75    Cm  E03   1.72000         0 1 : Experiment 1 15000 HCMEC D3
      1612   75    Cm  F01   2.25000         0 1 : Experiment 1 10000 HCMEC D3
      1613   75    Cm  F02   4.19000         0 1 : Experiment 1 10000 HCMEC D3
      1614   75    Cm  F03   2.50000         0 1 : Experiment 1 10000 HCMEC D3
      1615   75    Cm  G01  19.88000         0 1 : Experiment 1  5000 HCMEC D3
      1616   75    Cm  G02  21.68000         0 1 : Experiment 1  5000 HCMEC D3
      1617   75    Cm  G03  16.21000         0 1 : Experiment 1  5000 HCMEC D3
      1618   75 Drift  A01  -5.24000         0 1 : Experiment 1 35000 HCMEC D3
      1619   75 Drift  A02  -5.49000         0 1 : Experiment 1 35000 HCMEC D3
      1620   75 Drift  A03  -5.00000         0 1 : Experiment 1 35000 HCMEC D3
      1621   75 Drift  B01  -5.69000         0 1 : Experiment 1 30000 HCMEC D3
      1622   75 Drift  B02  -5.94000         0 1 : Experiment 1 30000 HCMEC D3
      1623   75 Drift  B03  -5.47000         0 1 : Experiment 1 30000 HCMEC D3
      1624   75 Drift  C01  -6.03000         0 1 : Experiment 1 25000 HCMEC D3
      1625   75 Drift  C02  -6.24000         0 1 : Experiment 1 25000 HCMEC D3
      1626   75 Drift  C03  -5.72000         0 1 : Experiment 1 25000 HCMEC D3
      1627   75 Drift  D01  -5.89000         0 1 : Experiment 1 20000 HCMEC D3
      1628   75 Drift  D02  -6.25000         0 1 : Experiment 1 20000 HCMEC D3
      1629   75 Drift  D03  -5.36000         0 1 : Experiment 1 20000 HCMEC D3
      1630   75 Drift  E01  -4.84000         0 1 : Experiment 1 15000 HCMEC D3
      1631   75 Drift  E02  -5.11000         0 1 : Experiment 1 15000 HCMEC D3
      1632   75 Drift  E03  -4.95000         0 1 : Experiment 1 15000 HCMEC D3
      1633   75 Drift  F01  -4.76000         0 1 : Experiment 1 10000 HCMEC D3
      1634   75 Drift  F02  -4.68000         0 1 : Experiment 1 10000 HCMEC D3
      1635   75 Drift  F03  -4.42000         0 1 : Experiment 1 10000 HCMEC D3
      1636   75 Drift  G01  -3.59000         0 1 : Experiment 1  5000 HCMEC D3
      1637   75 Drift  G02  -3.55000         0 1 : Experiment 1  5000 HCMEC D3
      1638   75 Drift  G03  -3.22000         0 1 : Experiment 1  5000 HCMEC D3
      1639   75    Rb  A01   2.61000         0 1 : Experiment 1 35000 HCMEC D3
      1640   75    Rb  A02   2.66000         0 1 : Experiment 1 35000 HCMEC D3
      1641   75    Rb  A03   2.58000         0 1 : Experiment 1 35000 HCMEC D3
      1642   75    Rb  B01   2.83000         0 1 : Experiment 1 30000 HCMEC D3
      1643   75    Rb  B02   2.86000         0 1 : Experiment 1 30000 HCMEC D3
      1644   75    Rb  B03   2.82000         0 1 : Experiment 1 30000 HCMEC D3
      1645   75    Rb  C01   2.82000         0 1 : Experiment 1 25000 HCMEC D3
      1646   75    Rb  C02   2.80000         0 1 : Experiment 1 25000 HCMEC D3
      1647   75    Rb  C03   2.69000         0 1 : Experiment 1 25000 HCMEC D3
      1648   75    Rb  D01   2.04000         0 1 : Experiment 1 20000 HCMEC D3
      1649   75    Rb  D02   2.48000         0 1 : Experiment 1 20000 HCMEC D3
      1650   75    Rb  D03   2.05000         0 1 : Experiment 1 20000 HCMEC D3
      1651   75    Rb  E01   1.30000         0 1 : Experiment 1 15000 HCMEC D3
      1652   75    Rb  E02   0.92000         0 1 : Experiment 1 15000 HCMEC D3
      1653   75    Rb  E03   0.57000         0 1 : Experiment 1 15000 HCMEC D3
      1654   75    Rb  F01   0.00000         0 1 : Experiment 1 10000 HCMEC D3
      1655   75    Rb  F02   0.00000         0 1 : Experiment 1 10000 HCMEC D3
      1656   75    Rb  F03   0.00000         0 1 : Experiment 1 10000 HCMEC D3
      1657   75    Rb  G01   0.00000         0 1 : Experiment 1  5000 HCMEC D3
      1658   75    Rb  G02   0.00000         0 1 : Experiment 1  5000 HCMEC D3
      1659   75    Rb  G03   0.00000         0 1 : Experiment 1  5000 HCMEC D3
      1660   75  RMSE  A01   0.01000         0 1 : Experiment 1 35000 HCMEC D3
      1661   75  RMSE  A02   0.01000         0 1 : Experiment 1 35000 HCMEC D3
      1662   75  RMSE  A03   0.01000         0 1 : Experiment 1 35000 HCMEC D3
      1663   75  RMSE  B01   0.01000         0 1 : Experiment 1 30000 HCMEC D3
      1664   75  RMSE  B02   0.01000         0 1 : Experiment 1 30000 HCMEC D3
      1665   75  RMSE  B03   0.01000         0 1 : Experiment 1 30000 HCMEC D3
      1666   75  RMSE  C01   0.01000         0 1 : Experiment 1 25000 HCMEC D3
      1667   75  RMSE  C02   0.01000         0 1 : Experiment 1 25000 HCMEC D3
      1668   75  RMSE  C03   0.01000         0 1 : Experiment 1 25000 HCMEC D3
      1669   75  RMSE  D01   0.01000         0 1 : Experiment 1 20000 HCMEC D3
      1670   75  RMSE  D02   0.01000         0 1 : Experiment 1 20000 HCMEC D3
      1671   75  RMSE  D03   0.01000         0 1 : Experiment 1 20000 HCMEC D3
      1672   75  RMSE  E01   0.01000         0 1 : Experiment 1 15000 HCMEC D3
      1673   75  RMSE  E02   0.02000         0 1 : Experiment 1 15000 HCMEC D3
      1674   75  RMSE  E03   0.02000         0 1 : Experiment 1 15000 HCMEC D3
      1675   75  RMSE  F01   0.02000         0 1 : Experiment 1 10000 HCMEC D3
      1676   75  RMSE  F02   0.04000         0 1 : Experiment 1 10000 HCMEC D3
      1677   75  RMSE  F03   0.03000         0 1 : Experiment 1 10000 HCMEC D3
      1678   75  RMSE  G01   0.04000         0 1 : Experiment 1  5000 HCMEC D3
      1679   75  RMSE  G02   0.04000         0 1 : Experiment 1  5000 HCMEC D3
      1680   75  RMSE  G03   0.04000         0 1 : Experiment 1  5000 HCMEC D3
      1681   80 Alpha  A01   3.82000         0 1 : Experiment 1 35000 HCMEC D3
      1682   80 Alpha  A02   3.87000         0 1 : Experiment 1 35000 HCMEC D3
      1683   80 Alpha  A03   3.79000         0 1 : Experiment 1 35000 HCMEC D3
      1684   80 Alpha  B01   4.05000         0 1 : Experiment 1 30000 HCMEC D3
      1685   80 Alpha  B02   4.15000         0 1 : Experiment 1 30000 HCMEC D3
      1686   80 Alpha  B03   4.16000         0 1 : Experiment 1 30000 HCMEC D3
      1687   80 Alpha  C01   4.27000         0 1 : Experiment 1 25000 HCMEC D3
      1688   80 Alpha  C02   4.27000         0 1 : Experiment 1 25000 HCMEC D3
      1689   80 Alpha  C03   4.24000         0 1 : Experiment 1 25000 HCMEC D3
      1690   80 Alpha  D01   4.64000         0 1 : Experiment 1 20000 HCMEC D3
      1691   80 Alpha  D02   4.58000         0 1 : Experiment 1 20000 HCMEC D3
      1692   80 Alpha  D03   4.57000         0 1 : Experiment 1 20000 HCMEC D3
      1693   80 Alpha  E01   5.04000         0 1 : Experiment 1 15000 HCMEC D3
      1694   80 Alpha  E02   5.25000         0 1 : Experiment 1 15000 HCMEC D3
      1695   80 Alpha  E03   5.40000         0 1 : Experiment 1 15000 HCMEC D3
      1696   80 Alpha  F01   5.75000         0 1 : Experiment 1 10000 HCMEC D3
      1697   80 Alpha  F02   5.24000         0 1 : Experiment 1 10000 HCMEC D3
      1698   80 Alpha  F03   5.59000         0 1 : Experiment 1 10000 HCMEC D3
      1699   80 Alpha  G01   3.49000         0 1 : Experiment 1  5000 HCMEC D3
      1700   80 Alpha  G02   3.32000         0 1 : Experiment 1  5000 HCMEC D3
      1701   80 Alpha  G03   3.66000         0 1 : Experiment 1  5000 HCMEC D3
      1702   80    Cm  A01   1.16000         0 1 : Experiment 1 35000 HCMEC D3
      1703   80    Cm  A02   1.11000         0 1 : Experiment 1 35000 HCMEC D3
      1704   80    Cm  A03   1.11000         0 1 : Experiment 1 35000 HCMEC D3
      1705   80    Cm  B01   1.09000         0 1 : Experiment 1 30000 HCMEC D3
      1706   80    Cm  B02   1.07000         0 1 : Experiment 1 30000 HCMEC D3
      1707   80    Cm  B03   1.06000         0 1 : Experiment 1 30000 HCMEC D3
      1708   80    Cm  C01   1.06000         0 1 : Experiment 1 25000 HCMEC D3
      1709   80    Cm  C02   1.05000         0 1 : Experiment 1 25000 HCMEC D3
      1710   80    Cm  C03   1.05000         0 1 : Experiment 1 25000 HCMEC D3
      1711   80    Cm  D01   1.08000         0 1 : Experiment 1 20000 HCMEC D3
      1712   80    Cm  D02   1.05000         0 1 : Experiment 1 20000 HCMEC D3
      1713   80    Cm  D03   1.10000         0 1 : Experiment 1 20000 HCMEC D3
      1714   80    Cm  E01   1.18000         0 1 : Experiment 1 15000 HCMEC D3
      1715   80    Cm  E02   1.43000         0 1 : Experiment 1 15000 HCMEC D3
      1716   80    Cm  E03   1.55000         0 1 : Experiment 1 15000 HCMEC D3
      1717   80    Cm  F01   1.42000         0 1 : Experiment 1 10000 HCMEC D3
      1718   80    Cm  F02   2.92000         0 1 : Experiment 1 10000 HCMEC D3
      1719   80    Cm  F03   1.92000         0 1 : Experiment 1 10000 HCMEC D3
      1720   80    Cm  G01  16.77000         0 1 : Experiment 1  5000 HCMEC D3
      1721   80    Cm  G02  17.65000         0 1 : Experiment 1  5000 HCMEC D3
      1722   80    Cm  G03  12.99000         0 1 : Experiment 1  5000 HCMEC D3
      1723   80 Drift  A01  -5.28000         0 1 : Experiment 1 35000 HCMEC D3
      1724   80 Drift  A02  -5.55000         0 1 : Experiment 1 35000 HCMEC D3
      1725   80 Drift  A03  -5.05000         0 1 : Experiment 1 35000 HCMEC D3
      1726   80 Drift  B01  -5.75000         0 1 : Experiment 1 30000 HCMEC D3
      1727   80 Drift  B02  -6.00000         0 1 : Experiment 1 30000 HCMEC D3
      1728   80 Drift  B03  -5.53000         0 1 : Experiment 1 30000 HCMEC D3
      1729   80 Drift  C01  -6.07000         0 1 : Experiment 1 25000 HCMEC D3
      1730   80 Drift  C02  -6.27000         0 1 : Experiment 1 25000 HCMEC D3
      1731   80 Drift  C03  -5.75000         0 1 : Experiment 1 25000 HCMEC D3
      1732   80 Drift  D01  -5.92000         0 1 : Experiment 1 20000 HCMEC D3
      1733   80 Drift  D02  -6.18000         0 1 : Experiment 1 20000 HCMEC D3
      1734   80 Drift  D03  -5.40000         0 1 : Experiment 1 20000 HCMEC D3
      1735   80 Drift  E01  -4.90000         0 1 : Experiment 1 15000 HCMEC D3
      1736   80 Drift  E02  -5.15000         0 1 : Experiment 1 15000 HCMEC D3
      1737   80 Drift  E03  -5.00000         0 1 : Experiment 1 15000 HCMEC D3
      1738   80 Drift  F01  -4.84000         0 1 : Experiment 1 10000 HCMEC D3
      1739   80 Drift  F02  -4.85000         0 1 : Experiment 1 10000 HCMEC D3
      1740   80 Drift  F03  -4.52000         0 1 : Experiment 1 10000 HCMEC D3
      1741   80 Drift  G01  -3.72000         0 1 : Experiment 1  5000 HCMEC D3
      1742   80 Drift  G02  -3.72000         0 1 : Experiment 1  5000 HCMEC D3
      1743   80 Drift  G03  -3.38000         0 1 : Experiment 1  5000 HCMEC D3
      1744   80    Rb  A01   2.44000         0 1 : Experiment 1 35000 HCMEC D3
      1745   80    Rb  A02   2.61000         0 1 : Experiment 1 35000 HCMEC D3
      1746   80    Rb  A03   2.49000         0 1 : Experiment 1 35000 HCMEC D3
      1747   80    Rb  B01   2.78000         0 1 : Experiment 1 30000 HCMEC D3
      1748   80    Rb  B02   2.83000         0 1 : Experiment 1 30000 HCMEC D3
      1749   80    Rb  B03   2.79000         0 1 : Experiment 1 30000 HCMEC D3
      1750   80    Rb  C01   2.85000         0 1 : Experiment 1 25000 HCMEC D3
      1751   80    Rb  C02   2.78000         0 1 : Experiment 1 25000 HCMEC D3
      1752   80    Rb  C03   2.71000         0 1 : Experiment 1 25000 HCMEC D3
      1753   80    Rb  D01   2.48000         0 1 : Experiment 1 20000 HCMEC D3
      1754   80    Rb  D02   2.71000         0 1 : Experiment 1 20000 HCMEC D3
      1755   80    Rb  D03   2.44000         0 1 : Experiment 1 20000 HCMEC D3
      1756   80    Rb  E01   1.96000         0 1 : Experiment 1 15000 HCMEC D3
      1757   80    Rb  E02   1.36000         0 1 : Experiment 1 15000 HCMEC D3
      1758   80    Rb  E03   1.06000         0 1 : Experiment 1 15000 HCMEC D3
      1759   80    Rb  F01   0.01000         0 1 : Experiment 1 10000 HCMEC D3
      1760   80    Rb  F02   0.00000         0 1 : Experiment 1 10000 HCMEC D3
      1761   80    Rb  F03   0.00000         0 1 : Experiment 1 10000 HCMEC D3
      1762   80    Rb  G01   0.00000         0 1 : Experiment 1  5000 HCMEC D3
      1763   80    Rb  G02   0.00000         0 1 : Experiment 1  5000 HCMEC D3
      1764   80    Rb  G03   0.00000         0 1 : Experiment 1  5000 HCMEC D3
      1765   80  RMSE  A01   0.01000         0 1 : Experiment 1 35000 HCMEC D3
      1766   80  RMSE  A02   0.01000         0 1 : Experiment 1 35000 HCMEC D3
      1767   80  RMSE  A03   0.01000         0 1 : Experiment 1 35000 HCMEC D3
      1768   80  RMSE  B01   0.01000         0 1 : Experiment 1 30000 HCMEC D3
      1769   80  RMSE  B02   0.01000         0 1 : Experiment 1 30000 HCMEC D3
      1770   80  RMSE  B03   0.01000         0 1 : Experiment 1 30000 HCMEC D3
      1771   80  RMSE  C01   0.01000         0 1 : Experiment 1 25000 HCMEC D3
      1772   80  RMSE  C02   0.01000         0 1 : Experiment 1 25000 HCMEC D3
      1773   80  RMSE  C03   0.01000         0 1 : Experiment 1 25000 HCMEC D3
      1774   80  RMSE  D01   0.01000         0 1 : Experiment 1 20000 HCMEC D3
      1775   80  RMSE  D02   0.01000         0 1 : Experiment 1 20000 HCMEC D3
      1776   80  RMSE  D03   0.01000         0 1 : Experiment 1 20000 HCMEC D3
      1777   80  RMSE  E01   0.01000         0 1 : Experiment 1 15000 HCMEC D3
      1778   80  RMSE  E02   0.01000         0 1 : Experiment 1 15000 HCMEC D3
      1779   80  RMSE  E03   0.02000         0 1 : Experiment 1 15000 HCMEC D3
      1780   80  RMSE  F01   0.01000         0 1 : Experiment 1 10000 HCMEC D3
      1781   80  RMSE  F02   0.03000         0 1 : Experiment 1 10000 HCMEC D3
      1782   80  RMSE  F03   0.02000         0 1 : Experiment 1 10000 HCMEC D3
      1783   80  RMSE  G01   0.04000         0 1 : Experiment 1  5000 HCMEC D3
      1784   80  RMSE  G02   0.04000         0 1 : Experiment 1  5000 HCMEC D3
      1785   80  RMSE  G03   0.04000         0 1 : Experiment 1  5000 HCMEC D3
      1786   85 Alpha  A01   3.74000         0 1 : Experiment 1 35000 HCMEC D3
      1787   85 Alpha  A02   3.81000         0 1 : Experiment 1 35000 HCMEC D3
      1788   85 Alpha  A03   3.75000         0 1 : Experiment 1 35000 HCMEC D3
      1789   85 Alpha  B01   4.05000         0 1 : Experiment 1 30000 HCMEC D3
      1790   85 Alpha  B02   4.15000         0 1 : Experiment 1 30000 HCMEC D3
      1791   85 Alpha  B03   4.11000         0 1 : Experiment 1 30000 HCMEC D3
      1792   85 Alpha  C01   4.23000         0 1 : Experiment 1 25000 HCMEC D3
      1793   85 Alpha  C02   4.20000         0 1 : Experiment 1 25000 HCMEC D3
      1794   85 Alpha  C03   4.17000         0 1 : Experiment 1 25000 HCMEC D3
      1795   85 Alpha  D01   4.52000         0 1 : Experiment 1 20000 HCMEC D3
      1796   85 Alpha  D02   4.48000         0 1 : Experiment 1 20000 HCMEC D3
      1797   85 Alpha  D03   4.38000         0 1 : Experiment 1 20000 HCMEC D3
      1798   85 Alpha  E01   4.83000         0 1 : Experiment 1 15000 HCMEC D3
      1799   85 Alpha  E02   5.01000         0 1 : Experiment 1 15000 HCMEC D3
      1800   85 Alpha  E03   5.26000         0 1 : Experiment 1 15000 HCMEC D3
      1801   85 Alpha  F01   5.54000         0 1 : Experiment 1 10000 HCMEC D3
      1802   85 Alpha  F02   5.48000         0 1 : Experiment 1 10000 HCMEC D3
      1803   85 Alpha  F03   5.83000         0 1 : Experiment 1 10000 HCMEC D3
      1804   85 Alpha  G01   3.67000         0 1 : Experiment 1  5000 HCMEC D3
      1805   85 Alpha  G02   3.51000         0 1 : Experiment 1  5000 HCMEC D3
      1806   85 Alpha  G03   3.77000         0 1 : Experiment 1  5000 HCMEC D3
      1807   85    Cm  A01   1.16000         0 1 : Experiment 1 35000 HCMEC D3
      1808   85    Cm  A02   1.12000         0 1 : Experiment 1 35000 HCMEC D3
      1809   85    Cm  A03   1.12000         0 1 : Experiment 1 35000 HCMEC D3
      1810   85    Cm  B01   1.10000         0 1 : Experiment 1 30000 HCMEC D3
      1811   85    Cm  B02   1.07000         0 1 : Experiment 1 30000 HCMEC D3
      1812   85    Cm  B03   1.07000         0 1 : Experiment 1 30000 HCMEC D3
      1813   85    Cm  C01   1.07000         0 1 : Experiment 1 25000 HCMEC D3
      1814   85    Cm  C02   1.04000         0 1 : Experiment 1 25000 HCMEC D3
      1815   85    Cm  C03   1.06000         0 1 : Experiment 1 25000 HCMEC D3
      1816   85    Cm  D01   1.08000         0 1 : Experiment 1 20000 HCMEC D3
      1817   85    Cm  D02   1.08000         0 1 : Experiment 1 20000 HCMEC D3
      1818   85    Cm  D03   1.07000         0 1 : Experiment 1 20000 HCMEC D3
      1819   85    Cm  E01   1.10000         0 1 : Experiment 1 15000 HCMEC D3
      1820   85    Cm  E02   1.19000         0 1 : Experiment 1 15000 HCMEC D3
      1821   85    Cm  E03   1.35000         0 1 : Experiment 1 15000 HCMEC D3
      1822   85    Cm  F01   1.53000         0 1 : Experiment 1 10000 HCMEC D3
      1823   85    Cm  F02   2.10000         0 1 : Experiment 1 10000 HCMEC D3
      1824   85    Cm  F03   1.42000         0 1 : Experiment 1 10000 HCMEC D3
      1825   85    Cm  G01  14.16000         0 1 : Experiment 1  5000 HCMEC D3
      1826   85    Cm  G02  14.62000         0 1 : Experiment 1  5000 HCMEC D3
      1827   85    Cm  G03  11.33000         0 1 : Experiment 1  5000 HCMEC D3
      1828   85 Drift  A01  -5.32000         0 1 : Experiment 1 35000 HCMEC D3
      1829   85 Drift  A02  -5.60000         0 1 : Experiment 1 35000 HCMEC D3
      1830   85 Drift  A03  -5.10000         0 1 : Experiment 1 35000 HCMEC D3
      1831   85 Drift  B01  -5.81000         0 1 : Experiment 1 30000 HCMEC D3
      1832   85 Drift  B02  -6.07000         0 1 : Experiment 1 30000 HCMEC D3
      1833   85 Drift  B03  -5.59000         0 1 : Experiment 1 30000 HCMEC D3
      1834   85 Drift  C01  -6.12000         0 1 : Experiment 1 25000 HCMEC D3
      1835   85 Drift  C02  -6.35000         0 1 : Experiment 1 25000 HCMEC D3
      1836   85 Drift  C03  -5.82000         0 1 : Experiment 1 25000 HCMEC D3
      1837   85 Drift  D01  -5.94000         0 1 : Experiment 1 20000 HCMEC D3
      1838   85 Drift  D02  -6.31000         0 1 : Experiment 1 20000 HCMEC D3
      1839   85 Drift  D03  -5.43000         0 1 : Experiment 1 20000 HCMEC D3
      1840   85 Drift  E01  -4.90000         0 1 : Experiment 1 15000 HCMEC D3
      1841   85 Drift  E02  -5.21000         0 1 : Experiment 1 15000 HCMEC D3
      1842   85 Drift  E03  -5.02000         0 1 : Experiment 1 15000 HCMEC D3
      1843   85 Drift  F01  -4.95000         0 1 : Experiment 1 10000 HCMEC D3
      1844   85 Drift  F02  -4.88000         0 1 : Experiment 1 10000 HCMEC D3
      1845   85 Drift  F03  -4.58000         0 1 : Experiment 1 10000 HCMEC D3
      1846   85 Drift  G01  -3.82000         0 1 : Experiment 1  5000 HCMEC D3
      1847   85 Drift  G02  -3.86000         0 1 : Experiment 1  5000 HCMEC D3
      1848   85 Drift  G03  -3.51000         0 1 : Experiment 1  5000 HCMEC D3
      1849   85    Rb  A01   2.38000         0 1 : Experiment 1 35000 HCMEC D3
      1850   85    Rb  A02   2.49000         0 1 : Experiment 1 35000 HCMEC D3
      1851   85    Rb  A03   2.38000         0 1 : Experiment 1 35000 HCMEC D3
      1852   85    Rb  B01   2.68000         0 1 : Experiment 1 30000 HCMEC D3
      1853   85    Rb  B02   2.73000         0 1 : Experiment 1 30000 HCMEC D3
      1854   85    Rb  B03   2.69000         0 1 : Experiment 1 30000 HCMEC D3
      1855   85    Rb  C01   2.80000         0 1 : Experiment 1 25000 HCMEC D3
      1856   85    Rb  C02   2.75000         0 1 : Experiment 1 25000 HCMEC D3
      1857   85    Rb  C03   2.63000         0 1 : Experiment 1 25000 HCMEC D3
      1858   85    Rb  D01   2.54000         0 1 : Experiment 1 20000 HCMEC D3
      1859   85    Rb  D02   2.64000         0 1 : Experiment 1 20000 HCMEC D3
      1860   85    Rb  D03   2.61000         0 1 : Experiment 1 20000 HCMEC D3
      1861   85    Rb  E01   2.32000         0 1 : Experiment 1 15000 HCMEC D3
      1862   85    Rb  E02   1.90000         0 1 : Experiment 1 15000 HCMEC D3
      1863   85    Rb  E03   1.51000         0 1 : Experiment 1 15000 HCMEC D3
      1864   85    Rb  F01   0.73000         0 1 : Experiment 1 10000 HCMEC D3
      1865   85    Rb  F02   0.00000         0 1 : Experiment 1 10000 HCMEC D3
      1866   85    Rb  F03   0.04000         0 1 : Experiment 1 10000 HCMEC D3
      1867   85    Rb  G01   0.00000         0 1 : Experiment 1  5000 HCMEC D3
      1868   85    Rb  G02   0.00000         0 1 : Experiment 1  5000 HCMEC D3
      1869   85    Rb  G03   0.00000         0 1 : Experiment 1  5000 HCMEC D3
      1870   85  RMSE  A01   0.01000         0 1 : Experiment 1 35000 HCMEC D3
      1871   85  RMSE  A02   0.01000         0 1 : Experiment 1 35000 HCMEC D3
      1872   85  RMSE  A03   0.01000         0 1 : Experiment 1 35000 HCMEC D3
      1873   85  RMSE  B01   0.01000         0 1 : Experiment 1 30000 HCMEC D3
      1874   85  RMSE  B02   0.01000         0 1 : Experiment 1 30000 HCMEC D3
      1875   85  RMSE  B03   0.01000         0 1 : Experiment 1 30000 HCMEC D3
      1876   85  RMSE  C01   0.01000         0 1 : Experiment 1 25000 HCMEC D3
      1877   85  RMSE  C02   0.01000         0 1 : Experiment 1 25000 HCMEC D3
      1878   85  RMSE  C03   0.01000         0 1 : Experiment 1 25000 HCMEC D3
      1879   85  RMSE  D01   0.01000         0 1 : Experiment 1 20000 HCMEC D3
      1880   85  RMSE  D02   0.01000         0 1 : Experiment 1 20000 HCMEC D3
      1881   85  RMSE  D03   0.01000         0 1 : Experiment 1 20000 HCMEC D3
      1882   85  RMSE  E01   0.01000         0 1 : Experiment 1 15000 HCMEC D3
      1883   85  RMSE  E02   0.01000         0 1 : Experiment 1 15000 HCMEC D3
      1884   85  RMSE  E03   0.02000         0 1 : Experiment 1 15000 HCMEC D3
      1885   85  RMSE  F01   0.02000         0 1 : Experiment 1 10000 HCMEC D3
      1886   85  RMSE  F02   0.02000         0 1 : Experiment 1 10000 HCMEC D3
      1887   85  RMSE  F03   0.02000         0 1 : Experiment 1 10000 HCMEC D3
      1888   85  RMSE  G01   0.05000         0 1 : Experiment 1  5000 HCMEC D3
      1889   85  RMSE  G02   0.04000         0 1 : Experiment 1  5000 HCMEC D3
      1890   85  RMSE  G03   0.04000         0 1 : Experiment 1  5000 HCMEC D3
      1891   90 Alpha  A01   3.71000         0 1 : Experiment 1 35000 HCMEC D3
      1892   90 Alpha  A02   3.76000         0 1 : Experiment 1 35000 HCMEC D3
      1893   90 Alpha  A03   3.68000         0 1 : Experiment 1 35000 HCMEC D3
      1894   90 Alpha  B01   4.02000         0 1 : Experiment 1 30000 HCMEC D3
      1895   90 Alpha  B02   4.09000         0 1 : Experiment 1 30000 HCMEC D3
      1896   90 Alpha  B03   4.04000         0 1 : Experiment 1 30000 HCMEC D3
      1897   90 Alpha  C01   4.19000         0 1 : Experiment 1 25000 HCMEC D3
      1898   90 Alpha  C02   4.16000         0 1 : Experiment 1 25000 HCMEC D3
      1899   90 Alpha  C03   4.13000         0 1 : Experiment 1 25000 HCMEC D3
      1900   90 Alpha  D01   4.38000         0 1 : Experiment 1 20000 HCMEC D3
      1901   90 Alpha  D02   4.35000         0 1 : Experiment 1 20000 HCMEC D3
      1902   90 Alpha  D03   4.28000         0 1 : Experiment 1 20000 HCMEC D3
      1903   90 Alpha  E01   4.68000         0 1 : Experiment 1 15000 HCMEC D3
      1904   90 Alpha  E02   4.79000         0 1 : Experiment 1 15000 HCMEC D3
      1905   90 Alpha  E03   5.02000         0 1 : Experiment 1 15000 HCMEC D3
      1906   90 Alpha  F01   5.32000         0 1 : Experiment 1 10000 HCMEC D3
      1907   90 Alpha  F02   5.80000         0 1 : Experiment 1 10000 HCMEC D3
      1908   90 Alpha  F03   5.56000         0 1 : Experiment 1 10000 HCMEC D3
      1909   90 Alpha  G01   3.80000         0 1 : Experiment 1  5000 HCMEC D3
      1910   90 Alpha  G02   3.80000         0 1 : Experiment 1  5000 HCMEC D3
      1911   90 Alpha  G03   3.95000         0 1 : Experiment 1  5000 HCMEC D3
      1912   90    Cm  A01   1.18000         0 1 : Experiment 1 35000 HCMEC D3
      1913   90    Cm  A02   1.13000         0 1 : Experiment 1 35000 HCMEC D3
      1914   90    Cm  A03   1.13000         0 1 : Experiment 1 35000 HCMEC D3
      1915   90    Cm  B01   1.09000         0 1 : Experiment 1 30000 HCMEC D3
      1916   90    Cm  B02   1.08000         0 1 : Experiment 1 30000 HCMEC D3
      1917   90    Cm  B03   1.07000         0 1 : Experiment 1 30000 HCMEC D3
      1918   90    Cm  C01   1.08000         0 1 : Experiment 1 25000 HCMEC D3
      1919   90    Cm  C02   1.05000         0 1 : Experiment 1 25000 HCMEC D3
      1920   90    Cm  C03   1.07000         0 1 : Experiment 1 25000 HCMEC D3
      1921   90    Cm  D01   1.07000         0 1 : Experiment 1 20000 HCMEC D3
      1922   90    Cm  D02   1.06000         0 1 : Experiment 1 20000 HCMEC D3
      1923   90    Cm  D03   1.07000         0 1 : Experiment 1 20000 HCMEC D3
      1924   90    Cm  E01   1.06000         0 1 : Experiment 1 15000 HCMEC D3
      1925   90    Cm  E02   1.12000         0 1 : Experiment 1 15000 HCMEC D3
      1926   90    Cm  E03   1.23000         0 1 : Experiment 1 15000 HCMEC D3
      1927   90    Cm  F01   1.44000         0 1 : Experiment 1 10000 HCMEC D3
      1928   90    Cm  F02   1.36000         0 1 : Experiment 1 10000 HCMEC D3
      1929   90    Cm  F03   1.56000         0 1 : Experiment 1 10000 HCMEC D3
      1930   90    Cm  G01  11.62000         0 1 : Experiment 1  5000 HCMEC D3
      1931   90    Cm  G02  12.31000         0 1 : Experiment 1  5000 HCMEC D3
      1932   90    Cm  G03   8.81000         0 1 : Experiment 1  5000 HCMEC D3
      1933   90 Drift  A01  -5.35000         0 1 : Experiment 1 35000 HCMEC D3
      1934   90 Drift  A02  -5.64000         0 1 : Experiment 1 35000 HCMEC D3
      1935   90 Drift  A03  -5.12000         0 1 : Experiment 1 35000 HCMEC D3
      1936   90 Drift  B01  -5.86000         0 1 : Experiment 1 30000 HCMEC D3
      1937   90 Drift  B02  -6.12000         0 1 : Experiment 1 30000 HCMEC D3
      1938   90 Drift  B03  -5.64000         0 1 : Experiment 1 30000 HCMEC D3
      1939   90 Drift  C01  -6.16000         0 1 : Experiment 1 25000 HCMEC D3
      1940   90 Drift  C02  -6.40000         0 1 : Experiment 1 25000 HCMEC D3
      1941   90 Drift  C03  -5.88000         0 1 : Experiment 1 25000 HCMEC D3
      1942   90 Drift  D01  -5.96000         0 1 : Experiment 1 20000 HCMEC D3
      1943   90 Drift  D02  -6.28000         0 1 : Experiment 1 20000 HCMEC D3
      1944   90 Drift  D03  -5.47000         0 1 : Experiment 1 20000 HCMEC D3
      1945   90 Drift  E01  -4.93000         0 1 : Experiment 1 15000 HCMEC D3
      1946   90 Drift  E02  -5.24000         0 1 : Experiment 1 15000 HCMEC D3
      1947   90 Drift  E03  -5.08000         0 1 : Experiment 1 15000 HCMEC D3
      1948   90 Drift  F01  -4.99000         0 1 : Experiment 1 10000 HCMEC D3
      1949   90 Drift  F02  -4.92000         0 1 : Experiment 1 10000 HCMEC D3
      1950   90 Drift  F03  -4.66000         0 1 : Experiment 1 10000 HCMEC D3
      1951   90 Drift  G01  -3.95000         0 1 : Experiment 1  5000 HCMEC D3
      1952   90 Drift  G02  -4.04000         0 1 : Experiment 1  5000 HCMEC D3
      1953   90 Drift  G03  -3.62000         0 1 : Experiment 1  5000 HCMEC D3
      1954   90    Rb  A01   2.29000         0 1 : Experiment 1 35000 HCMEC D3
      1955   90    Rb  A02   2.35000         0 1 : Experiment 1 35000 HCMEC D3
      1956   90    Rb  A03   2.27000         0 1 : Experiment 1 35000 HCMEC D3
      1957   90    Rb  B01   2.61000         0 1 : Experiment 1 30000 HCMEC D3
      1958   90    Rb  B02   2.64000         0 1 : Experiment 1 30000 HCMEC D3
      1959   90    Rb  B03   2.65000         0 1 : Experiment 1 30000 HCMEC D3
      1960   90    Rb  C01   2.72000         0 1 : Experiment 1 25000 HCMEC D3
      1961   90    Rb  C02   2.75000         0 1 : Experiment 1 25000 HCMEC D3
      1962   90    Rb  C03   2.55000         0 1 : Experiment 1 25000 HCMEC D3
      1963   90    Rb  D01   2.63000         0 1 : Experiment 1 20000 HCMEC D3
      1964   90    Rb  D02   2.71000         0 1 : Experiment 1 20000 HCMEC D3
      1965   90    Rb  D03   2.68000         0 1 : Experiment 1 20000 HCMEC D3
      1966   90    Rb  E01   2.54000         0 1 : Experiment 1 15000 HCMEC D3
      1967   90    Rb  E02   2.18000         0 1 : Experiment 1 15000 HCMEC D3
      1968   90    Rb  E03   1.88000         0 1 : Experiment 1 15000 HCMEC D3
      1969   90    Rb  F01   1.22000         0 1 : Experiment 1 10000 HCMEC D3
      1970   90    Rb  F02   0.02000         0 1 : Experiment 1 10000 HCMEC D3
      1971   90    Rb  F03   0.70000         0 1 : Experiment 1 10000 HCMEC D3
      1972   90    Rb  G01   0.00000         0 1 : Experiment 1  5000 HCMEC D3
      1973   90    Rb  G02   0.00000         0 1 : Experiment 1  5000 HCMEC D3
      1974   90    Rb  G03   0.00000         0 1 : Experiment 1  5000 HCMEC D3
      1975   90  RMSE  A01   0.01000         0 1 : Experiment 1 35000 HCMEC D3
      1976   90  RMSE  A02   0.01000         0 1 : Experiment 1 35000 HCMEC D3
      1977   90  RMSE  A03   0.01000         0 1 : Experiment 1 35000 HCMEC D3
      1978   90  RMSE  B01   0.01000         0 1 : Experiment 1 30000 HCMEC D3
      1979   90  RMSE  B02   0.01000         0 1 : Experiment 1 30000 HCMEC D3
      1980   90  RMSE  B03   0.01000         0 1 : Experiment 1 30000 HCMEC D3
      1981   90  RMSE  C01   0.01000         0 1 : Experiment 1 25000 HCMEC D3
      1982   90  RMSE  C02   0.01000         0 1 : Experiment 1 25000 HCMEC D3
      1983   90  RMSE  C03   0.01000         0 1 : Experiment 1 25000 HCMEC D3
      1984   90  RMSE  D01   0.01000         0 1 : Experiment 1 20000 HCMEC D3
      1985   90  RMSE  D02   0.01000         0 1 : Experiment 1 20000 HCMEC D3
      1986   90  RMSE  D03   0.01000         0 1 : Experiment 1 20000 HCMEC D3
      1987   90  RMSE  E01   0.01000         0 1 : Experiment 1 15000 HCMEC D3
      1988   90  RMSE  E02   0.01000         0 1 : Experiment 1 15000 HCMEC D3
      1989   90  RMSE  E03   0.01000         0 1 : Experiment 1 15000 HCMEC D3
      1990   90  RMSE  F01   0.02000         0 1 : Experiment 1 10000 HCMEC D3
      1991   90  RMSE  F02   0.02000         0 1 : Experiment 1 10000 HCMEC D3
      1992   90  RMSE  F03   0.02000         0 1 : Experiment 1 10000 HCMEC D3
      1993   90  RMSE  G01   0.05000         0 1 : Experiment 1  5000 HCMEC D3
      1994   90  RMSE  G02   0.05000         0 1 : Experiment 1  5000 HCMEC D3
      1995   90  RMSE  G03   0.05000         0 1 : Experiment 1  5000 HCMEC D3
      1996   95 Alpha  A01   3.67000         0 1 : Experiment 1 35000 HCMEC D3
      1997   95 Alpha  A02   3.68000         0 1 : Experiment 1 35000 HCMEC D3
      1998   95 Alpha  A03   3.65000         0 1 : Experiment 1 35000 HCMEC D3
      1999   95 Alpha  B01   3.95000         0 1 : Experiment 1 30000 HCMEC D3
      2000   95 Alpha  B02   4.01000         0 1 : Experiment 1 30000 HCMEC D3
      2001   95 Alpha  B03   3.94000         0 1 : Experiment 1 30000 HCMEC D3
      2002   95 Alpha  C01   4.11000         0 1 : Experiment 1 25000 HCMEC D3
      2003   95 Alpha  C02   4.10000         0 1 : Experiment 1 25000 HCMEC D3
      2004   95 Alpha  C03   4.07000         0 1 : Experiment 1 25000 HCMEC D3
      2005   95 Alpha  D01   4.23000         0 1 : Experiment 1 20000 HCMEC D3
      2006   95 Alpha  D02   4.28000         0 1 : Experiment 1 20000 HCMEC D3
      2007   95 Alpha  D03   4.21000         0 1 : Experiment 1 20000 HCMEC D3
      2008   95 Alpha  E01   4.47000         0 1 : Experiment 1 15000 HCMEC D3
      2009   95 Alpha  E02   4.68000         0 1 : Experiment 1 15000 HCMEC D3
      2010   95 Alpha  E03   4.76000         0 1 : Experiment 1 15000 HCMEC D3
      2011   95 Alpha  F01   5.08000         0 1 : Experiment 1 10000 HCMEC D3
      2012   95 Alpha  F02   5.69000         0 1 : Experiment 1 10000 HCMEC D3
      2013   95 Alpha  F03   5.39000         0 1 : Experiment 1 10000 HCMEC D3
      2014   95 Alpha  G01   3.99000         0 1 : Experiment 1  5000 HCMEC D3
      2015   95 Alpha  G02   4.01000         0 1 : Experiment 1  5000 HCMEC D3
      2016   95 Alpha  G03   4.00000         0 1 : Experiment 1  5000 HCMEC D3
      2017   95    Cm  A01   1.19000         0 1 : Experiment 1 35000 HCMEC D3
      2018   95    Cm  A02   1.12000         0 1 : Experiment 1 35000 HCMEC D3
      2019   95    Cm  A03   1.14000         0 1 : Experiment 1 35000 HCMEC D3
      2020   95    Cm  B01   1.10000         0 1 : Experiment 1 30000 HCMEC D3
      2021   95    Cm  B02   1.07000         0 1 : Experiment 1 30000 HCMEC D3
      2022   95    Cm  B03   1.08000         0 1 : Experiment 1 30000 HCMEC D3
      2023   95    Cm  C01   1.08000         0 1 : Experiment 1 25000 HCMEC D3
      2024   95    Cm  C02   1.05000         0 1 : Experiment 1 25000 HCMEC D3
      2025   95    Cm  C03   1.06000         0 1 : Experiment 1 25000 HCMEC D3
      2026   95    Cm  D01   1.08000         0 1 : Experiment 1 20000 HCMEC D3
      2027   95    Cm  D02   1.07000         0 1 : Experiment 1 20000 HCMEC D3
      2028   95    Cm  D03   1.06000         0 1 : Experiment 1 20000 HCMEC D3
      2029   95    Cm  E01   1.07000         0 1 : Experiment 1 15000 HCMEC D3
      2030   95    Cm  E02   1.07000         0 1 : Experiment 1 15000 HCMEC D3
      2031   95    Cm  E03   1.13000         0 1 : Experiment 1 15000 HCMEC D3
      2032   95    Cm  F01   1.29000         0 1 : Experiment 1 10000 HCMEC D3
      2033   95    Cm  F02   1.46000         0 1 : Experiment 1 10000 HCMEC D3
      2034   95    Cm  F03   1.46000         0 1 : Experiment 1 10000 HCMEC D3
      2035   95    Cm  G01   9.95000         0 1 : Experiment 1  5000 HCMEC D3
      2036   95    Cm  G02   9.54000         0 1 : Experiment 1  5000 HCMEC D3
      2037   95    Cm  G03   7.62000         0 1 : Experiment 1  5000 HCMEC D3
      2038   95 Drift  A01  -5.36000         0 1 : Experiment 1 35000 HCMEC D3
      2039   95 Drift  A02  -5.67000         0 1 : Experiment 1 35000 HCMEC D3
      2040   95 Drift  A03  -5.14000         0 1 : Experiment 1 35000 HCMEC D3
      2041   95 Drift  B01  -5.89000         0 1 : Experiment 1 30000 HCMEC D3
      2042   95 Drift  B02  -6.15000         0 1 : Experiment 1 30000 HCMEC D3
      2043   95 Drift  B03  -5.66000         0 1 : Experiment 1 30000 HCMEC D3
      2044   95 Drift  C01  -6.19000         0 1 : Experiment 1 25000 HCMEC D3
      2045   95 Drift  C02  -6.44000         0 1 : Experiment 1 25000 HCMEC D3
      2046   95 Drift  C03  -5.90000         0 1 : Experiment 1 25000 HCMEC D3
      2047   95 Drift  D01  -5.96000         0 1 : Experiment 1 20000 HCMEC D3
      2048   95 Drift  D02  -6.30000         0 1 : Experiment 1 20000 HCMEC D3
      2049   95 Drift  D03  -5.48000         0 1 : Experiment 1 20000 HCMEC D3
      2050   95 Drift  E01  -4.91000         0 1 : Experiment 1 15000 HCMEC D3
      2051   95 Drift  E02  -5.28000         0 1 : Experiment 1 15000 HCMEC D3
      2052   95 Drift  E03  -5.11000         0 1 : Experiment 1 15000 HCMEC D3
      2053   95 Drift  F01  -4.97000         0 1 : Experiment 1 10000 HCMEC D3
      2054   95 Drift  F02  -4.98000         0 1 : Experiment 1 10000 HCMEC D3
      2055   95 Drift  F03  -4.70000         0 1 : Experiment 1 10000 HCMEC D3
      2056   95 Drift  G01  -4.01000         0 1 : Experiment 1  5000 HCMEC D3
      2057   95 Drift  G02  -4.16000         0 1 : Experiment 1  5000 HCMEC D3
      2058   95 Drift  G03  -3.63000         0 1 : Experiment 1  5000 HCMEC D3
      2059   95    Rb  A01   2.17000         0 1 : Experiment 1 35000 HCMEC D3
      2060   95    Rb  A02   2.26000         0 1 : Experiment 1 35000 HCMEC D3
      2061   95    Rb  A03   2.17000         0 1 : Experiment 1 35000 HCMEC D3
      2062   95    Rb  B01   2.49000         0 1 : Experiment 1 30000 HCMEC D3
      2063   95    Rb  B02   2.55000         0 1 : Experiment 1 30000 HCMEC D3
      2064   95    Rb  B03   2.52000         0 1 : Experiment 1 30000 HCMEC D3
      2065   95    Rb  C01   2.60000         0 1 : Experiment 1 25000 HCMEC D3
      2066   95    Rb  C02   2.66000         0 1 : Experiment 1 25000 HCMEC D3
      2067   95    Rb  C03   2.64000         0 1 : Experiment 1 25000 HCMEC D3
      2068   95    Rb  D01   2.65000         0 1 : Experiment 1 20000 HCMEC D3
      2069   95    Rb  D02   2.76000         0 1 : Experiment 1 20000 HCMEC D3
      2070   95    Rb  D03   2.65000         0 1 : Experiment 1 20000 HCMEC D3
      2071   95    Rb  E01   2.62000         0 1 : Experiment 1 15000 HCMEC D3
      2072   95    Rb  E02   2.40000         0 1 : Experiment 1 15000 HCMEC D3
      2073   95    Rb  E03   2.26000         0 1 : Experiment 1 15000 HCMEC D3
      2074   95    Rb  F01   1.66000         0 1 : Experiment 1 10000 HCMEC D3
      2075   95    Rb  F02   0.50000         0 1 : Experiment 1 10000 HCMEC D3
      2076   95    Rb  F03   1.16000         0 1 : Experiment 1 10000 HCMEC D3
      2077   95    Rb  G01   0.00000         0 1 : Experiment 1  5000 HCMEC D3
      2078   95    Rb  G02   0.00000         0 1 : Experiment 1  5000 HCMEC D3
      2079   95    Rb  G03   0.00000         0 1 : Experiment 1  5000 HCMEC D3
      2080   95  RMSE  A01   0.01000         0 1 : Experiment 1 35000 HCMEC D3
      2081   95  RMSE  A02   0.01000         0 1 : Experiment 1 35000 HCMEC D3
      2082   95  RMSE  A03   0.01000         0 1 : Experiment 1 35000 HCMEC D3
      2083   95  RMSE  B01   0.01000         0 1 : Experiment 1 30000 HCMEC D3
      2084   95  RMSE  B02   0.01000         0 1 : Experiment 1 30000 HCMEC D3
      2085   95  RMSE  B03   0.01000         0 1 : Experiment 1 30000 HCMEC D3
      2086   95  RMSE  C01   0.01000         0 1 : Experiment 1 25000 HCMEC D3
      2087   95  RMSE  C02   0.01000         0 1 : Experiment 1 25000 HCMEC D3
      2088   95  RMSE  C03   0.01000         0 1 : Experiment 1 25000 HCMEC D3
      2089   95  RMSE  D01   0.01000         0 1 : Experiment 1 20000 HCMEC D3
      2090   95  RMSE  D02   0.01000         0 1 : Experiment 1 20000 HCMEC D3
      2091   95  RMSE  D03   0.01000         0 1 : Experiment 1 20000 HCMEC D3
      2092   95  RMSE  E01   0.01000         0 1 : Experiment 1 15000 HCMEC D3
      2093   95  RMSE  E02   0.01000         0 1 : Experiment 1 15000 HCMEC D3
      2094   95  RMSE  E03   0.01000         0 1 : Experiment 1 15000 HCMEC D3
      2095   95  RMSE  F01   0.01000         0 1 : Experiment 1 10000 HCMEC D3
      2096   95  RMSE  F02   0.02000         0 1 : Experiment 1 10000 HCMEC D3
      2097   95  RMSE  F03   0.02000         0 1 : Experiment 1 10000 HCMEC D3
      2098   95  RMSE  G01   0.05000         0 1 : Experiment 1  5000 HCMEC D3
      2099   95  RMSE  G02   0.05000         0 1 : Experiment 1  5000 HCMEC D3
      2100   95  RMSE  G03   0.05000         0 1 : Experiment 1  5000 HCMEC D3
      2101  100 Alpha  A01   3.64000         0 1 : Experiment 1 35000 HCMEC D3
      2102  100 Alpha  A02   3.62000         0 1 : Experiment 1 35000 HCMEC D3
      2103  100 Alpha  A03   3.58000         0 1 : Experiment 1 35000 HCMEC D3
      2104  100 Alpha  B01   3.89000         0 1 : Experiment 1 30000 HCMEC D3
      2105  100 Alpha  B02   3.98000         0 1 : Experiment 1 30000 HCMEC D3
      2106  100 Alpha  B03   3.90000         0 1 : Experiment 1 30000 HCMEC D3
      2107  100 Alpha  C01   4.07000         0 1 : Experiment 1 25000 HCMEC D3
      2108  100 Alpha  C02   4.07000         0 1 : Experiment 1 25000 HCMEC D3
      2109  100 Alpha  C03   4.06000         0 1 : Experiment 1 25000 HCMEC D3
      2110  100 Alpha  D01   4.22000         0 1 : Experiment 1 20000 HCMEC D3
      2111  100 Alpha  D02   4.26000         0 1 : Experiment 1 20000 HCMEC D3
      2112  100 Alpha  D03   4.18000         0 1 : Experiment 1 20000 HCMEC D3
      2113  100 Alpha  E01   4.37000         0 1 : Experiment 1 15000 HCMEC D3
      2114  100 Alpha  E02   4.56000         0 1 : Experiment 1 15000 HCMEC D3
      2115  100 Alpha  E03   4.62000         0 1 : Experiment 1 15000 HCMEC D3
      2116  100 Alpha  F01   4.81000         0 1 : Experiment 1 10000 HCMEC D3
      2117  100 Alpha  F02   5.51000         0 1 : Experiment 1 10000 HCMEC D3
      2118  100 Alpha  F03   5.20000         0 1 : Experiment 1 10000 HCMEC D3
      2119  100 Alpha  G01   4.09000         0 1 : Experiment 1  5000 HCMEC D3
      2120  100 Alpha  G02   4.16000         0 1 : Experiment 1  5000 HCMEC D3
      2121  100 Alpha  G03   4.19000         0 1 : Experiment 1  5000 HCMEC D3
      2122  100    Cm  A01   1.20000         0 1 : Experiment 1 35000 HCMEC D3
      2123  100    Cm  A02   1.13000         0 1 : Experiment 1 35000 HCMEC D3
      2124  100    Cm  A03   1.15000         0 1 : Experiment 1 35000 HCMEC D3
      2125  100    Cm  B01   1.11000         0 1 : Experiment 1 30000 HCMEC D3
      2126  100    Cm  B02   1.08000         0 1 : Experiment 1 30000 HCMEC D3
      2127  100    Cm  B03   1.09000         0 1 : Experiment 1 30000 HCMEC D3
      2128  100    Cm  C01   1.08000         0 1 : Experiment 1 25000 HCMEC D3
      2129  100    Cm  C02   1.05000         0 1 : Experiment 1 25000 HCMEC D3
      2130  100    Cm  C03   1.08000         0 1 : Experiment 1 25000 HCMEC D3
      2131  100    Cm  D01   1.08000         0 1 : Experiment 1 20000 HCMEC D3
      2132  100    Cm  D02   1.08000         0 1 : Experiment 1 20000 HCMEC D3
      2133  100    Cm  D03   1.08000         0 1 : Experiment 1 20000 HCMEC D3
      2134  100    Cm  E01   1.07000         0 1 : Experiment 1 15000 HCMEC D3
      2135  100    Cm  E02   1.05000         0 1 : Experiment 1 15000 HCMEC D3
      2136  100    Cm  E03   1.10000         0 1 : Experiment 1 15000 HCMEC D3
      2137  100    Cm  F01   1.14000         0 1 : Experiment 1 10000 HCMEC D3
      2138  100    Cm  F02   1.43000         0 1 : Experiment 1 10000 HCMEC D3
      2139  100    Cm  F03   1.34000         0 1 : Experiment 1 10000 HCMEC D3
      2140  100    Cm  G01   8.64000         0 1 : Experiment 1  5000 HCMEC D3
      2141  100    Cm  G02   8.13000         0 1 : Experiment 1  5000 HCMEC D3
      2142  100    Cm  G03   5.95000         0 1 : Experiment 1  5000 HCMEC D3
      2143  100 Drift  A01  -5.37000         0 1 : Experiment 1 35000 HCMEC D3
      2144  100 Drift  A02  -5.67000         0 1 : Experiment 1 35000 HCMEC D3
      2145  100 Drift  A03  -5.14000         0 1 : Experiment 1 35000 HCMEC D3
      2146  100 Drift  B01  -5.90000         0 1 : Experiment 1 30000 HCMEC D3
      2147  100 Drift  B02  -6.18000         0 1 : Experiment 1 30000 HCMEC D3
      2148  100 Drift  B03  -5.67000         0 1 : Experiment 1 30000 HCMEC D3
      2149  100 Drift  C01  -6.21000         0 1 : Experiment 1 25000 HCMEC D3
      2150  100 Drift  C02  -6.47000         0 1 : Experiment 1 25000 HCMEC D3
      2151  100 Drift  C03  -5.91000         0 1 : Experiment 1 25000 HCMEC D3
      2152  100 Drift  D01  -5.97000         0 1 : Experiment 1 20000 HCMEC D3
      2153  100 Drift  D02  -6.31000         0 1 : Experiment 1 20000 HCMEC D3
      2154  100 Drift  D03  -5.51000         0 1 : Experiment 1 20000 HCMEC D3
      2155  100 Drift  E01  -4.92000         0 1 : Experiment 1 15000 HCMEC D3
      2156  100 Drift  E02  -5.31000         0 1 : Experiment 1 15000 HCMEC D3
      2157  100 Drift  E03  -5.11000         0 1 : Experiment 1 15000 HCMEC D3
      2158  100 Drift  F01  -4.96000         0 1 : Experiment 1 10000 HCMEC D3
      2159  100 Drift  F02  -5.01000         0 1 : Experiment 1 10000 HCMEC D3
      2160  100 Drift  F03  -4.72000         0 1 : Experiment 1 10000 HCMEC D3
      2161  100 Drift  G01  -4.03000         0 1 : Experiment 1  5000 HCMEC D3
      2162  100 Drift  G02  -4.20000         0 1 : Experiment 1  5000 HCMEC D3
      2163  100 Drift  G03  -3.69000         0 1 : Experiment 1  5000 HCMEC D3
      2164  100    Rb  A01   2.05000         0 1 : Experiment 1 35000 HCMEC D3
      2165  100    Rb  A02   2.15000         0 1 : Experiment 1 35000 HCMEC D3
      2166  100    Rb  A03   2.08000         0 1 : Experiment 1 35000 HCMEC D3
      2167  100    Rb  B01   2.37000         0 1 : Experiment 1 30000 HCMEC D3
      2168  100    Rb  B02   2.42000         0 1 : Experiment 1 30000 HCMEC D3
      2169  100    Rb  B03   2.40000         0 1 : Experiment 1 30000 HCMEC D3
      2170  100    Rb  C01   2.56000         0 1 : Experiment 1 25000 HCMEC D3
      2171  100    Rb  C02   2.52000         0 1 : Experiment 1 25000 HCMEC D3
      2172  100    Rb  C03   2.47000         0 1 : Experiment 1 25000 HCMEC D3
      2173  100    Rb  D01   2.60000         0 1 : Experiment 1 20000 HCMEC D3
      2174  100    Rb  D02   2.65000         0 1 : Experiment 1 20000 HCMEC D3
      2175  100    Rb  D03   2.55000         0 1 : Experiment 1 20000 HCMEC D3
      2176  100    Rb  E01   2.65000         0 1 : Experiment 1 15000 HCMEC D3
      2177  100    Rb  E02   2.52000         0 1 : Experiment 1 15000 HCMEC D3
      2178  100    Rb  E03   2.38000         0 1 : Experiment 1 15000 HCMEC D3
      2179  100    Rb  F01   2.18000         0 1 : Experiment 1 10000 HCMEC D3
      2180  100    Rb  F02   0.95000         0 1 : Experiment 1 10000 HCMEC D3
      2181  100    Rb  F03   1.56000         0 1 : Experiment 1 10000 HCMEC D3
      2182  100    Rb  G01   0.00000         0 1 : Experiment 1  5000 HCMEC D3
      2183  100    Rb  G02   0.00000         0 1 : Experiment 1  5000 HCMEC D3
      2184  100    Rb  G03   0.00000         0 1 : Experiment 1  5000 HCMEC D3
      2185  100  RMSE  A01   0.01000         0 1 : Experiment 1 35000 HCMEC D3
      2186  100  RMSE  A02   0.01000         0 1 : Experiment 1 35000 HCMEC D3
      2187  100  RMSE  A03   0.01000         0 1 : Experiment 1 35000 HCMEC D3
      2188  100  RMSE  B01   0.01000         0 1 : Experiment 1 30000 HCMEC D3
      2189  100  RMSE  B02   0.01000         0 1 : Experiment 1 30000 HCMEC D3
      2190  100  RMSE  B03   0.01000         0 1 : Experiment 1 30000 HCMEC D3
      2191  100  RMSE  C01   0.01000         0 1 : Experiment 1 25000 HCMEC D3
      2192  100  RMSE  C02   0.01000         0 1 : Experiment 1 25000 HCMEC D3
      2193  100  RMSE  C03   0.01000         0 1 : Experiment 1 25000 HCMEC D3
      2194  100  RMSE  D01   0.01000         0 1 : Experiment 1 20000 HCMEC D3
      2195  100  RMSE  D02   0.01000         0 1 : Experiment 1 20000 HCMEC D3
      2196  100  RMSE  D03   0.01000         0 1 : Experiment 1 20000 HCMEC D3
      2197  100  RMSE  E01   0.01000         0 1 : Experiment 1 15000 HCMEC D3
      2198  100  RMSE  E02   0.01000         0 1 : Experiment 1 15000 HCMEC D3
      2199  100  RMSE  E03   0.01000         0 1 : Experiment 1 15000 HCMEC D3
      2200  100  RMSE  F01   0.01000         0 1 : Experiment 1 10000 HCMEC D3
      2201  100  RMSE  F02   0.02000         0 1 : Experiment 1 10000 HCMEC D3
      2202  100  RMSE  F03   0.02000         0 1 : Experiment 1 10000 HCMEC D3
      2203  100  RMSE  G01   0.05000         0 1 : Experiment 1  5000 HCMEC D3
      2204  100  RMSE  G02   0.05000         0 1 : Experiment 1  5000 HCMEC D3
      2205  100  RMSE  G03   0.05000         0 1 : Experiment 1  5000 HCMEC D3
      2206  105 Alpha  A01   3.54000         0 1 : Experiment 1 35000 HCMEC D3
      2207  105 Alpha  A02   3.59000         0 1 : Experiment 1 35000 HCMEC D3
      2208  105 Alpha  A03   3.52000         0 1 : Experiment 1 35000 HCMEC D3
      2209  105 Alpha  B01   3.84000         0 1 : Experiment 1 30000 HCMEC D3
      2210  105 Alpha  B02   3.92000         0 1 : Experiment 1 30000 HCMEC D3
      2211  105 Alpha  B03   3.83000         0 1 : Experiment 1 30000 HCMEC D3
      2212  105 Alpha  C01   4.00000         0 1 : Experiment 1 25000 HCMEC D3
      2213  105 Alpha  C02   4.06000         0 1 : Experiment 1 25000 HCMEC D3
      2214  105 Alpha  C03   3.96000         0 1 : Experiment 1 25000 HCMEC D3
      2215  105 Alpha  D01   4.21000         0 1 : Experiment 1 20000 HCMEC D3
      2216  105 Alpha  D02   4.25000         0 1 : Experiment 1 20000 HCMEC D3
      2217  105 Alpha  D03   4.15000         0 1 : Experiment 1 20000 HCMEC D3
      2218  105 Alpha  E01   4.35000         0 1 : Experiment 1 15000 HCMEC D3
      2219  105 Alpha  E02   4.47000         0 1 : Experiment 1 15000 HCMEC D3
      2220  105 Alpha  E03   4.46000         0 1 : Experiment 1 15000 HCMEC D3
      2221  105 Alpha  F01   4.68000         0 1 : Experiment 1 10000 HCMEC D3
      2222  105 Alpha  F02   5.28000         0 1 : Experiment 1 10000 HCMEC D3
      2223  105 Alpha  F03   4.94000         0 1 : Experiment 1 10000 HCMEC D3
      2224  105 Alpha  G01   4.22000         0 1 : Experiment 1  5000 HCMEC D3
      2225  105 Alpha  G02   4.37000         0 1 : Experiment 1  5000 HCMEC D3
      2226  105 Alpha  G03   4.35000         0 1 : Experiment 1  5000 HCMEC D3
      2227  105    Cm  A01   1.20000         0 1 : Experiment 1 35000 HCMEC D3
      2228  105    Cm  A02   1.13000         0 1 : Experiment 1 35000 HCMEC D3
      2229  105    Cm  A03   1.16000         0 1 : Experiment 1 35000 HCMEC D3
      2230  105    Cm  B01   1.11000         0 1 : Experiment 1 30000 HCMEC D3
      2231  105    Cm  B02   1.08000         0 1 : Experiment 1 30000 HCMEC D3
      2232  105    Cm  B03   1.10000         0 1 : Experiment 1 30000 HCMEC D3
      2233  105    Cm  C01   1.08000         0 1 : Experiment 1 25000 HCMEC D3
      2234  105    Cm  C02   1.05000         0 1 : Experiment 1 25000 HCMEC D3
      2235  105    Cm  C03   1.07000         0 1 : Experiment 1 25000 HCMEC D3
      2236  105    Cm  D01   1.10000         0 1 : Experiment 1 20000 HCMEC D3
      2237  105    Cm  D02   1.08000         0 1 : Experiment 1 20000 HCMEC D3
      2238  105    Cm  D03   1.11000         0 1 : Experiment 1 20000 HCMEC D3
      2239  105    Cm  E01   1.09000         0 1 : Experiment 1 15000 HCMEC D3
      2240  105    Cm  E02   1.05000         0 1 : Experiment 1 15000 HCMEC D3
      2241  105    Cm  E03   1.08000         0 1 : Experiment 1 15000 HCMEC D3
      2242  105    Cm  F01   1.11000         0 1 : Experiment 1 10000 HCMEC D3
      2243  105    Cm  F02   1.38000         0 1 : Experiment 1 10000 HCMEC D3
      2244  105    Cm  F03   1.27000         0 1 : Experiment 1 10000 HCMEC D3
      2245  105    Cm  G01   7.29000         0 1 : Experiment 1  5000 HCMEC D3
      2246  105    Cm  G02   6.48000         0 1 : Experiment 1  5000 HCMEC D3
      2247  105    Cm  G03   4.86000         0 1 : Experiment 1  5000 HCMEC D3
      2248  105 Drift  A01  -5.35000         0 1 : Experiment 1 35000 HCMEC D3
      2249  105 Drift  A02  -5.67000         0 1 : Experiment 1 35000 HCMEC D3
      2250  105 Drift  A03  -5.12000         0 1 : Experiment 1 35000 HCMEC D3
      2251  105 Drift  B01  -5.90000         0 1 : Experiment 1 30000 HCMEC D3
      2252  105 Drift  B02  -6.17000         0 1 : Experiment 1 30000 HCMEC D3
      2253  105 Drift  B03  -5.67000         0 1 : Experiment 1 30000 HCMEC D3
      2254  105 Drift  C01  -6.23000         0 1 : Experiment 1 25000 HCMEC D3
      2255  105 Drift  C02  -6.48000         0 1 : Experiment 1 25000 HCMEC D3
      2256  105 Drift  C03  -5.92000         0 1 : Experiment 1 25000 HCMEC D3
      2257  105 Drift  D01  -6.01000         0 1 : Experiment 1 20000 HCMEC D3
      2258  105 Drift  D02  -6.36000         0 1 : Experiment 1 20000 HCMEC D3
      2259  105 Drift  D03  -5.53000         0 1 : Experiment 1 20000 HCMEC D3
      2260  105 Drift  E01  -4.92000         0 1 : Experiment 1 15000 HCMEC D3
      2261  105 Drift  E02  -5.28000         0 1 : Experiment 1 15000 HCMEC D3
      2262  105 Drift  E03  -5.08000         0 1 : Experiment 1 15000 HCMEC D3
      2263  105 Drift  F01  -4.92000         0 1 : Experiment 1 10000 HCMEC D3
      2264  105 Drift  F02  -5.01000         0 1 : Experiment 1 10000 HCMEC D3
      2265  105 Drift  F03  -4.65000         0 1 : Experiment 1 10000 HCMEC D3
      2266  105 Drift  G01  -4.12000         0 1 : Experiment 1  5000 HCMEC D3
      2267  105 Drift  G02  -4.28000         0 1 : Experiment 1  5000 HCMEC D3
      2268  105 Drift  G03  -3.73000         0 1 : Experiment 1  5000 HCMEC D3
      2269  105    Rb  A01   1.95000         0 1 : Experiment 1 35000 HCMEC D3
      2270  105    Rb  A02   2.04000         0 1 : Experiment 1 35000 HCMEC D3
      2271  105    Rb  A03   1.99000         0 1 : Experiment 1 35000 HCMEC D3
      2272  105    Rb  B01   2.25000         0 1 : Experiment 1 30000 HCMEC D3
      2273  105    Rb  B02   2.33000         0 1 : Experiment 1 30000 HCMEC D3
      2274  105    Rb  B03   2.28000         0 1 : Experiment 1 30000 HCMEC D3
      2275  105    Rb  C01   2.40000         0 1 : Experiment 1 25000 HCMEC D3
      2276  105    Rb  C02   2.43000         0 1 : Experiment 1 25000 HCMEC D3
      2277  105    Rb  C03   2.44000         0 1 : Experiment 1 25000 HCMEC D3
      2278  105    Rb  D01   2.45000         0 1 : Experiment 1 20000 HCMEC D3
      2279  105    Rb  D02   2.55000         0 1 : Experiment 1 20000 HCMEC D3
      2280  105    Rb  D03   2.42000         0 1 : Experiment 1 20000 HCMEC D3
      2281  105    Rb  E01   2.54000         0 1 : Experiment 1 15000 HCMEC D3
      2282  105    Rb  E02   2.49000         0 1 : Experiment 1 15000 HCMEC D3
      2283  105    Rb  E03   2.50000         0 1 : Experiment 1 15000 HCMEC D3
      2284  105    Rb  F01   2.29000         0 1 : Experiment 1 10000 HCMEC D3
      2285  105    Rb  F02   1.29000         0 1 : Experiment 1 10000 HCMEC D3
      2286  105    Rb  F03   1.74000         0 1 : Experiment 1 10000 HCMEC D3
      2287  105    Rb  G01   0.00000         0 1 : Experiment 1  5000 HCMEC D3
      2288  105    Rb  G02   0.00000         0 1 : Experiment 1  5000 HCMEC D3
      2289  105    Rb  G03   0.00000         0 1 : Experiment 1  5000 HCMEC D3
      2290  105  RMSE  A01   0.01000         0 1 : Experiment 1 35000 HCMEC D3
      2291  105  RMSE  A02   0.01000         0 1 : Experiment 1 35000 HCMEC D3
      2292  105  RMSE  A03   0.01000         0 1 : Experiment 1 35000 HCMEC D3
      2293  105  RMSE  B01   0.01000         0 1 : Experiment 1 30000 HCMEC D3
      2294  105  RMSE  B02   0.01000         0 1 : Experiment 1 30000 HCMEC D3
      2295  105  RMSE  B03   0.01000         0 1 : Experiment 1 30000 HCMEC D3
      2296  105  RMSE  C01   0.01000         0 1 : Experiment 1 25000 HCMEC D3
      2297  105  RMSE  C02   0.01000         0 1 : Experiment 1 25000 HCMEC D3
      2298  105  RMSE  C03   0.01000         0 1 : Experiment 1 25000 HCMEC D3
      2299  105  RMSE  D01   0.01000         0 1 : Experiment 1 20000 HCMEC D3
      2300  105  RMSE  D02   0.01000         0 1 : Experiment 1 20000 HCMEC D3
      2301  105  RMSE  D03   0.01000         0 1 : Experiment 1 20000 HCMEC D3
      2302  105  RMSE  E01   0.01000         0 1 : Experiment 1 15000 HCMEC D3
      2303  105  RMSE  E02   0.01000         0 1 : Experiment 1 15000 HCMEC D3
      2304  105  RMSE  E03   0.01000         0 1 : Experiment 1 15000 HCMEC D3
      2305  105  RMSE  F01   0.01000         0 1 : Experiment 1 10000 HCMEC D3
      2306  105  RMSE  F02   0.02000         0 1 : Experiment 1 10000 HCMEC D3
      2307  105  RMSE  F03   0.01000         0 1 : Experiment 1 10000 HCMEC D3
      2308  105  RMSE  G01   0.05000         0 1 : Experiment 1  5000 HCMEC D3
      2309  105  RMSE  G02   0.05000         0 1 : Experiment 1  5000 HCMEC D3
      2310  105  RMSE  G03   0.04000         0 1 : Experiment 1  5000 HCMEC D3
      2311  110 Alpha  A01   3.49000         0 1 : Experiment 1 35000 HCMEC D3
      2312  110 Alpha  A02   3.52000         0 1 : Experiment 1 35000 HCMEC D3
      2313  110 Alpha  A03   3.50000         0 1 : Experiment 1 35000 HCMEC D3
      2314  110 Alpha  B01   3.79000         0 1 : Experiment 1 30000 HCMEC D3
      2315  110 Alpha  B02   3.88000         0 1 : Experiment 1 30000 HCMEC D3
      2316  110 Alpha  B03   3.79000         0 1 : Experiment 1 30000 HCMEC D3
      2317  110 Alpha  C01   3.91000         0 1 : Experiment 1 25000 HCMEC D3
      2318  110 Alpha  C02   3.97000         0 1 : Experiment 1 25000 HCMEC D3
      2319  110 Alpha  C03   3.96000         0 1 : Experiment 1 25000 HCMEC D3
      2320  110 Alpha  D01   4.16000         0 1 : Experiment 1 20000 HCMEC D3
      2321  110 Alpha  D02   4.16000         0 1 : Experiment 1 20000 HCMEC D3
      2322  110 Alpha  D03   4.09000         0 1 : Experiment 1 20000 HCMEC D3
      2323  110 Alpha  E01   4.30000         0 1 : Experiment 1 15000 HCMEC D3
      2324  110 Alpha  E02   4.38000         0 1 : Experiment 1 15000 HCMEC D3
      2325  110 Alpha  E03   4.35000         0 1 : Experiment 1 15000 HCMEC D3
      2326  110 Alpha  F01   4.55000         0 1 : Experiment 1 10000 HCMEC D3
      2327  110 Alpha  F02   5.09000         0 1 : Experiment 1 10000 HCMEC D3
      2328  110 Alpha  F03   4.69000         0 1 : Experiment 1 10000 HCMEC D3
      2329  110 Alpha  G01   4.43000         0 1 : Experiment 1  5000 HCMEC D3
      2330  110 Alpha  G02   4.53000         0 1 : Experiment 1  5000 HCMEC D3
      2331  110 Alpha  G03   4.58000         0 1 : Experiment 1  5000 HCMEC D3
      2332  110    Cm  A01   1.22000         0 1 : Experiment 1 35000 HCMEC D3
      2333  110    Cm  A02   1.14000         0 1 : Experiment 1 35000 HCMEC D3
      2334  110    Cm  A03   1.15000         0 1 : Experiment 1 35000 HCMEC D3
      2335  110    Cm  B01   1.10000         0 1 : Experiment 1 30000 HCMEC D3
      2336  110    Cm  B02   1.09000         0 1 : Experiment 1 30000 HCMEC D3
      2337  110    Cm  B03   1.10000         0 1 : Experiment 1 30000 HCMEC D3
      2338  110    Cm  C01   1.08000         0 1 : Experiment 1 25000 HCMEC D3
      2339  110    Cm  C02   1.05000         0 1 : Experiment 1 25000 HCMEC D3
      2340  110    Cm  C03   1.09000         0 1 : Experiment 1 25000 HCMEC D3
      2341  110    Cm  D01   1.08000         0 1 : Experiment 1 20000 HCMEC D3
      2342  110    Cm  D02   1.07000         0 1 : Experiment 1 20000 HCMEC D3
      2343  110    Cm  D03   1.09000         0 1 : Experiment 1 20000 HCMEC D3
      2344  110    Cm  E01   1.08000         0 1 : Experiment 1 15000 HCMEC D3
      2345  110    Cm  E02   1.05000         0 1 : Experiment 1 15000 HCMEC D3
      2346  110    Cm  E03   1.06000         0 1 : Experiment 1 15000 HCMEC D3
      2347  110    Cm  F01   1.08000         0 1 : Experiment 1 10000 HCMEC D3
      2348  110    Cm  F02   1.27000         0 1 : Experiment 1 10000 HCMEC D3
      2349  110    Cm  F03   1.13000         0 1 : Experiment 1 10000 HCMEC D3
      2350  110    Cm  G01   5.95000         0 1 : Experiment 1  5000 HCMEC D3
      2351  110    Cm  G02   5.27000         0 1 : Experiment 1  5000 HCMEC D3
      2352  110    Cm  G03   3.67000         0 1 : Experiment 1  5000 HCMEC D3
      2353  110 Drift  A01  -5.32000         0 1 : Experiment 1 35000 HCMEC D3
      2354  110 Drift  A02  -5.64000         0 1 : Experiment 1 35000 HCMEC D3
      2355  110 Drift  A03  -5.10000         0 1 : Experiment 1 35000 HCMEC D3
      2356  110 Drift  B01  -5.88000         0 1 : Experiment 1 30000 HCMEC D3
      2357  110 Drift  B02  -6.16000         0 1 : Experiment 1 30000 HCMEC D3
      2358  110 Drift  B03  -5.66000         0 1 : Experiment 1 30000 HCMEC D3
      2359  110 Drift  C01  -6.20000         0 1 : Experiment 1 25000 HCMEC D3
      2360  110 Drift  C02  -6.47000         0 1 : Experiment 1 25000 HCMEC D3
      2361  110 Drift  C03  -5.92000         0 1 : Experiment 1 25000 HCMEC D3
      2362  110 Drift  D01  -6.00000         0 1 : Experiment 1 20000 HCMEC D3
      2363  110 Drift  D02  -6.31000         0 1 : Experiment 1 20000 HCMEC D3
      2364  110 Drift  D03  -5.52000         0 1 : Experiment 1 20000 HCMEC D3
      2365  110 Drift  E01  -4.91000         0 1 : Experiment 1 15000 HCMEC D3
      2366  110 Drift  E02  -5.28000         0 1 : Experiment 1 15000 HCMEC D3
      2367  110 Drift  E03  -5.05000         0 1 : Experiment 1 15000 HCMEC D3
      2368  110 Drift  F01  -4.90000         0 1 : Experiment 1 10000 HCMEC D3
      2369  110 Drift  F02  -5.01000         0 1 : Experiment 1 10000 HCMEC D3
      2370  110 Drift  F03  -4.65000         0 1 : Experiment 1 10000 HCMEC D3
      2371  110 Drift  G01  -4.16000         0 1 : Experiment 1  5000 HCMEC D3
      2372  110 Drift  G02  -4.28000         0 1 : Experiment 1  5000 HCMEC D3
      2373  110 Drift  G03  -3.77000         0 1 : Experiment 1  5000 HCMEC D3
      2374  110    Rb  A01   1.81000         0 1 : Experiment 1 35000 HCMEC D3
      2375  110    Rb  A02   1.98000         0 1 : Experiment 1 35000 HCMEC D3
      2376  110    Rb  A03   1.91000         0 1 : Experiment 1 35000 HCMEC D3
      2377  110    Rb  B01   2.17000         0 1 : Experiment 1 30000 HCMEC D3
      2378  110    Rb  B02   2.19000         0 1 : Experiment 1 30000 HCMEC D3
      2379  110    Rb  B03   2.12000         0 1 : Experiment 1 30000 HCMEC D3
      2380  110    Rb  C01   2.32000         0 1 : Experiment 1 25000 HCMEC D3
      2381  110    Rb  C02   2.36000         0 1 : Experiment 1 25000 HCMEC D3
      2382  110    Rb  C03   2.27000         0 1 : Experiment 1 25000 HCMEC D3
      2383  110    Rb  D01   2.39000         0 1 : Experiment 1 20000 HCMEC D3
      2384  110    Rb  D02   2.49000         0 1 : Experiment 1 20000 HCMEC D3
      2385  110    Rb  D03   2.35000         0 1 : Experiment 1 20000 HCMEC D3
      2386  110    Rb  E01   2.55000         0 1 : Experiment 1 15000 HCMEC D3
      2387  110    Rb  E02   2.46000         0 1 : Experiment 1 15000 HCMEC D3
      2388  110    Rb  E03   2.52000         0 1 : Experiment 1 15000 HCMEC D3
      2389  110    Rb  F01   2.41000         0 1 : Experiment 1 10000 HCMEC D3
      2390  110    Rb  F02   1.65000         0 1 : Experiment 1 10000 HCMEC D3
      2391  110    Rb  F03   2.17000         0 1 : Experiment 1 10000 HCMEC D3
      2392  110    Rb  G01   0.00000         0 1 : Experiment 1  5000 HCMEC D3
      2393  110    Rb  G02   0.00000         0 1 : Experiment 1  5000 HCMEC D3
      2394  110    Rb  G03   0.00000         0 1 : Experiment 1  5000 HCMEC D3
      2395  110  RMSE  A01   0.01000         0 1 : Experiment 1 35000 HCMEC D3
      2396  110  RMSE  A02   0.01000         0 1 : Experiment 1 35000 HCMEC D3
      2397  110  RMSE  A03   0.01000         0 1 : Experiment 1 35000 HCMEC D3
      2398  110  RMSE  B01   0.01000         0 1 : Experiment 1 30000 HCMEC D3
      2399  110  RMSE  B02   0.01000         0 1 : Experiment 1 30000 HCMEC D3
      2400  110  RMSE  B03   0.01000         0 1 : Experiment 1 30000 HCMEC D3
      2401  110  RMSE  C01   0.01000         0 1 : Experiment 1 25000 HCMEC D3
      2402  110  RMSE  C02   0.01000         0 1 : Experiment 1 25000 HCMEC D3
      2403  110  RMSE  C03   0.01000         0 1 : Experiment 1 25000 HCMEC D3
      2404  110  RMSE  D01   0.01000         0 1 : Experiment 1 20000 HCMEC D3
      2405  110  RMSE  D02   0.01000         0 1 : Experiment 1 20000 HCMEC D3
      2406  110  RMSE  D03   0.01000         0 1 : Experiment 1 20000 HCMEC D3
      2407  110  RMSE  E01   0.01000         0 1 : Experiment 1 15000 HCMEC D3
      2408  110  RMSE  E02   0.01000         0 1 : Experiment 1 15000 HCMEC D3
      2409  110  RMSE  E03   0.01000         0 1 : Experiment 1 15000 HCMEC D3
      2410  110  RMSE  F01   0.01000         0 1 : Experiment 1 10000 HCMEC D3
      2411  110  RMSE  F02   0.01000         0 1 : Experiment 1 10000 HCMEC D3
      2412  110  RMSE  F03   0.01000         0 1 : Experiment 1 10000 HCMEC D3
      2413  110  RMSE  G01   0.05000         0 1 : Experiment 1  5000 HCMEC D3
      2414  110  RMSE  G02   0.05000         0 1 : Experiment 1  5000 HCMEC D3
      2415  110  RMSE  G03   0.04000         0 1 : Experiment 1  5000 HCMEC D3
      2416  115 Alpha  A01   3.45000         0 1 : Experiment 1 35000 HCMEC D3
      2417  115 Alpha  A02   3.48000         0 1 : Experiment 1 35000 HCMEC D3
      2418  115 Alpha  A03   3.42000         0 1 : Experiment 1 35000 HCMEC D3
      2419  115 Alpha  B01   3.72000         0 1 : Experiment 1 30000 HCMEC D3
      2420  115 Alpha  B02   3.80000         0 1 : Experiment 1 30000 HCMEC D3
      2421  115 Alpha  B03   3.72000         0 1 : Experiment 1 30000 HCMEC D3
      2422  115 Alpha  C01   3.85000         0 1 : Experiment 1 25000 HCMEC D3
      2423  115 Alpha  C02   3.89000         0 1 : Experiment 1 25000 HCMEC D3
      2424  115 Alpha  C03   3.89000         0 1 : Experiment 1 25000 HCMEC D3
      2425  115 Alpha  D01   4.12000         0 1 : Experiment 1 20000 HCMEC D3
      2426  115 Alpha  D02   4.14000         0 1 : Experiment 1 20000 HCMEC D3
      2427  115 Alpha  D03   4.03000         0 1 : Experiment 1 20000 HCMEC D3
      2428  115 Alpha  E01   4.20000         0 1 : Experiment 1 15000 HCMEC D3
      2429  115 Alpha  E02   4.29000         0 1 : Experiment 1 15000 HCMEC D3
      2430  115 Alpha  E03   4.26000         0 1 : Experiment 1 15000 HCMEC D3
      2431  115 Alpha  F01   4.44000         0 1 : Experiment 1 10000 HCMEC D3
      2432  115 Alpha  F02   4.90000         0 1 : Experiment 1 10000 HCMEC D3
      2433  115 Alpha  F03   4.53000         0 1 : Experiment 1 10000 HCMEC D3
      2434  115 Alpha  G01   4.60000         0 1 : Experiment 1  5000 HCMEC D3
      2435  115 Alpha  G02   4.70000         0 1 : Experiment 1  5000 HCMEC D3
      2436  115 Alpha  G03   4.70000         0 1 : Experiment 1  5000 HCMEC D3
      2437  115    Cm  A01   1.22000         0 1 : Experiment 1 35000 HCMEC D3
      2438  115    Cm  A02   1.15000         0 1 : Experiment 1 35000 HCMEC D3
      2439  115    Cm  A03   1.17000         0 1 : Experiment 1 35000 HCMEC D3
      2440  115    Cm  B01   1.10000         0 1 : Experiment 1 30000 HCMEC D3
      2441  115    Cm  B02   1.08000         0 1 : Experiment 1 30000 HCMEC D3
      2442  115    Cm  B03   1.09000         0 1 : Experiment 1 30000 HCMEC D3
      2443  115    Cm  C01   1.08000         0 1 : Experiment 1 25000 HCMEC D3
      2444  115    Cm  C02   1.05000         0 1 : Experiment 1 25000 HCMEC D3
      2445  115    Cm  C03   1.08000         0 1 : Experiment 1 25000 HCMEC D3
      2446  115    Cm  D01   1.09000         0 1 : Experiment 1 20000 HCMEC D3
      2447  115    Cm  D02   1.07000         0 1 : Experiment 1 20000 HCMEC D3
      2448  115    Cm  D03   1.09000         0 1 : Experiment 1 20000 HCMEC D3
      2449  115    Cm  E01   1.07000         0 1 : Experiment 1 15000 HCMEC D3
      2450  115    Cm  E02   1.06000         0 1 : Experiment 1 15000 HCMEC D3
      2451  115    Cm  E03   1.05000         0 1 : Experiment 1 15000 HCMEC D3
      2452  115    Cm  F01   1.07000         0 1 : Experiment 1 10000 HCMEC D3
      2453  115    Cm  F02   1.21000         0 1 : Experiment 1 10000 HCMEC D3
      2454  115    Cm  F03   1.06000         0 1 : Experiment 1 10000 HCMEC D3
      2455  115    Cm  G01   4.63000         0 1 : Experiment 1  5000 HCMEC D3
      2456  115    Cm  G02   4.32000         0 1 : Experiment 1  5000 HCMEC D3
      2457  115    Cm  G03   3.10000         0 1 : Experiment 1  5000 HCMEC D3
      2458  115 Drift  A01  -5.26000         0 1 : Experiment 1 35000 HCMEC D3
      2459  115 Drift  A02  -5.59000         0 1 : Experiment 1 35000 HCMEC D3
      2460  115 Drift  A03  -5.03000         0 1 : Experiment 1 35000 HCMEC D3
      2461  115 Drift  B01  -5.85000         0 1 : Experiment 1 30000 HCMEC D3
      2462  115 Drift  B02  -6.10000         0 1 : Experiment 1 30000 HCMEC D3
      2463  115 Drift  B03  -5.62000         0 1 : Experiment 1 30000 HCMEC D3
      2464  115 Drift  C01  -6.17000         0 1 : Experiment 1 25000 HCMEC D3
      2465  115 Drift  C02  -6.44000         0 1 : Experiment 1 25000 HCMEC D3
      2466  115 Drift  C03  -5.88000         0 1 : Experiment 1 25000 HCMEC D3
      2467  115 Drift  D01  -5.96000         0 1 : Experiment 1 20000 HCMEC D3
      2468  115 Drift  D02  -6.25000         0 1 : Experiment 1 20000 HCMEC D3
      2469  115 Drift  D03  -5.48000         0 1 : Experiment 1 20000 HCMEC D3
      2470  115 Drift  E01  -4.86000         0 1 : Experiment 1 15000 HCMEC D3
      2471  115 Drift  E02  -5.26000         0 1 : Experiment 1 15000 HCMEC D3
      2472  115 Drift  E03  -5.00000         0 1 : Experiment 1 15000 HCMEC D3
      2473  115 Drift  F01  -4.85000         0 1 : Experiment 1 10000 HCMEC D3
      2474  115 Drift  F02  -4.96000         0 1 : Experiment 1 10000 HCMEC D3
      2475  115 Drift  F03  -4.59000         0 1 : Experiment 1 10000 HCMEC D3
      2476  115 Drift  G01  -4.15000         0 1 : Experiment 1  5000 HCMEC D3
      2477  115 Drift  G02  -4.28000         0 1 : Experiment 1  5000 HCMEC D3
      2478  115 Drift  G03  -3.81000         0 1 : Experiment 1  5000 HCMEC D3
      2479  115    Rb  A01   1.75000         0 1 : Experiment 1 35000 HCMEC D3
      2480  115    Rb  A02   1.86000         0 1 : Experiment 1 35000 HCMEC D3
      2481  115    Rb  A03   1.80000         0 1 : Experiment 1 35000 HCMEC D3
      2482  115    Rb  B01   2.11000         0 1 : Experiment 1 30000 HCMEC D3
      2483  115    Rb  B02   2.09000         0 1 : Experiment 1 30000 HCMEC D3
      2484  115    Rb  B03   2.05000         0 1 : Experiment 1 30000 HCMEC D3
      2485  115    Rb  C01   2.22000         0 1 : Experiment 1 25000 HCMEC D3
      2486  115    Rb  C02   2.27000         0 1 : Experiment 1 25000 HCMEC D3
      2487  115    Rb  C03   2.20000         0 1 : Experiment 1 25000 HCMEC D3
      2488  115    Rb  D01   2.23000         0 1 : Experiment 1 20000 HCMEC D3
      2489  115    Rb  D02   2.35000         0 1 : Experiment 1 20000 HCMEC D3
      2490  115    Rb  D03   2.22000         0 1 : Experiment 1 20000 HCMEC D3
      2491  115    Rb  E01   2.47000         0 1 : Experiment 1 15000 HCMEC D3
      2492  115    Rb  E02   2.35000         0 1 : Experiment 1 15000 HCMEC D3
      2493  115    Rb  E03   2.52000         0 1 : Experiment 1 15000 HCMEC D3
      2494  115    Rb  F01   2.41000         0 1 : Experiment 1 10000 HCMEC D3
      2495  115    Rb  F02   1.83000         0 1 : Experiment 1 10000 HCMEC D3
      2496  115    Rb  F03   2.34000         0 1 : Experiment 1 10000 HCMEC D3
      2497  115    Rb  G01   0.00000         0 1 : Experiment 1  5000 HCMEC D3
      2498  115    Rb  G02   0.00000         0 1 : Experiment 1  5000 HCMEC D3
      2499  115    Rb  G03   0.00000         0 1 : Experiment 1  5000 HCMEC D3
      2500  115  RMSE  A01   0.01000         0 1 : Experiment 1 35000 HCMEC D3
      2501  115  RMSE  A02   0.01000         0 1 : Experiment 1 35000 HCMEC D3
      2502  115  RMSE  A03   0.01000         0 1 : Experiment 1 35000 HCMEC D3
      2503  115  RMSE  B01   0.01000         0 1 : Experiment 1 30000 HCMEC D3
      2504  115  RMSE  B02   0.01000         0 1 : Experiment 1 30000 HCMEC D3
      2505  115  RMSE  B03   0.01000         0 1 : Experiment 1 30000 HCMEC D3
      2506  115  RMSE  C01   0.01000         0 1 : Experiment 1 25000 HCMEC D3
      2507  115  RMSE  C02   0.01000         0 1 : Experiment 1 25000 HCMEC D3
      2508  115  RMSE  C03   0.01000         0 1 : Experiment 1 25000 HCMEC D3
      2509  115  RMSE  D01   0.01000         0 1 : Experiment 1 20000 HCMEC D3
      2510  115  RMSE  D02   0.01000         0 1 : Experiment 1 20000 HCMEC D3
      2511  115  RMSE  D03   0.01000         0 1 : Experiment 1 20000 HCMEC D3
      2512  115  RMSE  E01   0.01000         0 1 : Experiment 1 15000 HCMEC D3
      2513  115  RMSE  E02   0.01000         0 1 : Experiment 1 15000 HCMEC D3
      2514  115  RMSE  E03   0.01000         0 1 : Experiment 1 15000 HCMEC D3
      2515  115  RMSE  F01   0.01000         0 1 : Experiment 1 10000 HCMEC D3
      2516  115  RMSE  F02   0.01000         0 1 : Experiment 1 10000 HCMEC D3
      2517  115  RMSE  F03   0.01000         0 1 : Experiment 1 10000 HCMEC D3
      2518  115  RMSE  G01   0.04000         0 1 : Experiment 1  5000 HCMEC D3
      2519  115  RMSE  G02   0.04000         0 1 : Experiment 1  5000 HCMEC D3
      2520  115  RMSE  G03   0.03000         0 1 : Experiment 1  5000 HCMEC D3
      2521  120 Alpha  A01   3.43000         0 1 : Experiment 1 35000 HCMEC D3
      2522  120 Alpha  A02   3.45000         0 1 : Experiment 1 35000 HCMEC D3
      2523  120 Alpha  A03   3.39000         0 1 : Experiment 1 35000 HCMEC D3
      2524  120 Alpha  B01   3.70000         0 1 : Experiment 1 30000 HCMEC D3
      2525  120 Alpha  B02   3.76000         0 1 : Experiment 1 30000 HCMEC D3
      2526  120 Alpha  B03   3.66000         0 1 : Experiment 1 30000 HCMEC D3
      2527  120 Alpha  C01   3.81000         0 1 : Experiment 1 25000 HCMEC D3
      2528  120 Alpha  C02   3.85000         0 1 : Experiment 1 25000 HCMEC D3
      2529  120 Alpha  C03   3.82000         0 1 : Experiment 1 25000 HCMEC D3
      2530  120 Alpha  D01   4.05000         0 1 : Experiment 1 20000 HCMEC D3
      2531  120 Alpha  D02   4.08000         0 1 : Experiment 1 20000 HCMEC D3
      2532  120 Alpha  D03   3.95000         0 1 : Experiment 1 20000 HCMEC D3
      2533  120 Alpha  E01   4.12000         0 1 : Experiment 1 15000 HCMEC D3
      2534  120 Alpha  E02   4.23000         0 1 : Experiment 1 15000 HCMEC D3
      2535  120 Alpha  E03   4.22000         0 1 : Experiment 1 15000 HCMEC D3
      2536  120 Alpha  F01   4.38000         0 1 : Experiment 1 10000 HCMEC D3
      2537  120 Alpha  F02   4.66000         0 1 : Experiment 1 10000 HCMEC D3
      2538  120 Alpha  F03   4.44000         0 1 : Experiment 1 10000 HCMEC D3
      2539  120 Alpha  G01   4.74000         0 1 : Experiment 1  5000 HCMEC D3
      2540  120 Alpha  G02   4.85000         0 1 : Experiment 1  5000 HCMEC D3
      2541  120 Alpha  G03   4.87000         0 1 : Experiment 1  5000 HCMEC D3
      2542  120    Cm  A01   1.23000         0 1 : Experiment 1 35000 HCMEC D3
      2543  120    Cm  A02   1.14000         0 1 : Experiment 1 35000 HCMEC D3
      2544  120    Cm  A03   1.18000         0 1 : Experiment 1 35000 HCMEC D3
      2545  120    Cm  B01   1.10000         0 1 : Experiment 1 30000 HCMEC D3
      2546  120    Cm  B02   1.08000         0 1 : Experiment 1 30000 HCMEC D3
      2547  120    Cm  B03   1.10000         0 1 : Experiment 1 30000 HCMEC D3
      2548  120    Cm  C01   1.08000         0 1 : Experiment 1 25000 HCMEC D3
      2549  120    Cm  C02   1.06000         0 1 : Experiment 1 25000 HCMEC D3
      2550  120    Cm  C03   1.09000         0 1 : Experiment 1 25000 HCMEC D3
      2551  120    Cm  D01   1.08000         0 1 : Experiment 1 20000 HCMEC D3
      2552  120    Cm  D02   1.08000         0 1 : Experiment 1 20000 HCMEC D3
      2553  120    Cm  D03   1.09000         0 1 : Experiment 1 20000 HCMEC D3
      2554  120    Cm  E01   1.08000         0 1 : Experiment 1 15000 HCMEC D3
      2555  120    Cm  E02   1.04000         0 1 : Experiment 1 15000 HCMEC D3
      2556  120    Cm  E03   1.06000         0 1 : Experiment 1 15000 HCMEC D3
      2557  120    Cm  F01   1.08000         0 1 : Experiment 1 10000 HCMEC D3
      2558  120    Cm  F02   1.12000         0 1 : Experiment 1 10000 HCMEC D3
      2559  120    Cm  F03   1.05000         0 1 : Experiment 1 10000 HCMEC D3
      2560  120    Cm  G01   3.73000         0 1 : Experiment 1  5000 HCMEC D3
      2561  120    Cm  G02   3.47000         0 1 : Experiment 1  5000 HCMEC D3
      2562  120    Cm  G03   2.36000         0 1 : Experiment 1  5000 HCMEC D3
      2563  120 Drift  A01  -5.20000         0 1 : Experiment 1 35000 HCMEC D3
      2564  120 Drift  A02  -5.53000         0 1 : Experiment 1 35000 HCMEC D3
      2565  120 Drift  A03  -4.97000         0 1 : Experiment 1 35000 HCMEC D3
      2566  120 Drift  B01  -5.79000         0 1 : Experiment 1 30000 HCMEC D3
      2567  120 Drift  B02  -6.06000         0 1 : Experiment 1 30000 HCMEC D3
      2568  120 Drift  B03  -5.57000         0 1 : Experiment 1 30000 HCMEC D3
      2569  120 Drift  C01  -6.11000         0 1 : Experiment 1 25000 HCMEC D3
      2570  120 Drift  C02  -6.39000         0 1 : Experiment 1 25000 HCMEC D3
      2571  120 Drift  C03  -5.83000         0 1 : Experiment 1 25000 HCMEC D3
      2572  120 Drift  D01  -5.93000         0 1 : Experiment 1 20000 HCMEC D3
      2573  120 Drift  D02  -6.20000         0 1 : Experiment 1 20000 HCMEC D3
      2574  120 Drift  D03  -5.44000         0 1 : Experiment 1 20000 HCMEC D3
      2575  120 Drift  E01  -4.82000         0 1 : Experiment 1 15000 HCMEC D3
      2576  120 Drift  E02  -5.22000         0 1 : Experiment 1 15000 HCMEC D3
      2577  120 Drift  E03  -4.97000         0 1 : Experiment 1 15000 HCMEC D3
      2578  120 Drift  F01  -4.81000         0 1 : Experiment 1 10000 HCMEC D3
      2579  120 Drift  F02  -4.93000         0 1 : Experiment 1 10000 HCMEC D3
      2580  120 Drift  F03  -4.54000         0 1 : Experiment 1 10000 HCMEC D3
      2581  120 Drift  G01  -4.11000         0 1 : Experiment 1  5000 HCMEC D3
      2582  120 Drift  G02  -4.27000         0 1 : Experiment 1  5000 HCMEC D3
      2583  120 Drift  G03  -3.77000         0 1 : Experiment 1  5000 HCMEC D3
      2584  120    Rb  A01   1.65000         0 1 : Experiment 1 35000 HCMEC D3
      2585  120    Rb  A02   1.77000         0 1 : Experiment 1 35000 HCMEC D3
      2586  120    Rb  A03   1.71000         0 1 : Experiment 1 35000 HCMEC D3
      2587  120    Rb  B01   1.96000         0 1 : Experiment 1 30000 HCMEC D3
      2588  120    Rb  B02   2.00000         0 1 : Experiment 1 30000 HCMEC D3
      2589  120    Rb  B03   1.96000         0 1 : Experiment 1 30000 HCMEC D3
      2590  120    Rb  C01   2.10000         0 1 : Experiment 1 25000 HCMEC D3
      2591  120    Rb  C02   2.15000         0 1 : Experiment 1 25000 HCMEC D3
      2592  120    Rb  C03   2.07000         0 1 : Experiment 1 25000 HCMEC D3
      2593  120    Rb  D01   2.14000         0 1 : Experiment 1 20000 HCMEC D3
      2594  120    Rb  D02   2.17000         0 1 : Experiment 1 20000 HCMEC D3
      2595  120    Rb  D03   2.14000         0 1 : Experiment 1 20000 HCMEC D3
      2596  120    Rb  E01   2.35000         0 1 : Experiment 1 15000 HCMEC D3
      2597  120    Rb  E02   2.31000         0 1 : Experiment 1 15000 HCMEC D3
      2598  120    Rb  E03   2.44000         0 1 : Experiment 1 15000 HCMEC D3
      2599  120    Rb  F01   2.37000         0 1 : Experiment 1 10000 HCMEC D3
      2600  120    Rb  F02   2.03000         0 1 : Experiment 1 10000 HCMEC D3
      2601  120    Rb  F03   2.30000         0 1 : Experiment 1 10000 HCMEC D3
      2602  120    Rb  G01   0.00000         0 1 : Experiment 1  5000 HCMEC D3
      2603  120    Rb  G02   0.00000         0 1 : Experiment 1  5000 HCMEC D3
      2604  120    Rb  G03   0.00000         0 1 : Experiment 1  5000 HCMEC D3
      2605  120  RMSE  A01   0.01000         0 1 : Experiment 1 35000 HCMEC D3
      2606  120  RMSE  A02   0.01000         0 1 : Experiment 1 35000 HCMEC D3
      2607  120  RMSE  A03   0.01000         0 1 : Experiment 1 35000 HCMEC D3
      2608  120  RMSE  B01   0.01000         0 1 : Experiment 1 30000 HCMEC D3
      2609  120  RMSE  B02   0.01000         0 1 : Experiment 1 30000 HCMEC D3
      2610  120  RMSE  B03   0.01000         0 1 : Experiment 1 30000 HCMEC D3
      2611  120  RMSE  C01   0.01000         0 1 : Experiment 1 25000 HCMEC D3
      2612  120  RMSE  C02   0.01000         0 1 : Experiment 1 25000 HCMEC D3
      2613  120  RMSE  C03   0.01000         0 1 : Experiment 1 25000 HCMEC D3
      2614  120  RMSE  D01   0.01000         0 1 : Experiment 1 20000 HCMEC D3
      2615  120  RMSE  D02   0.01000         0 1 : Experiment 1 20000 HCMEC D3
      2616  120  RMSE  D03   0.01000         0 1 : Experiment 1 20000 HCMEC D3
      2617  120  RMSE  E01   0.01000         0 1 : Experiment 1 15000 HCMEC D3
      2618  120  RMSE  E02   0.01000         0 1 : Experiment 1 15000 HCMEC D3
      2619  120  RMSE  E03   0.01000         0 1 : Experiment 1 15000 HCMEC D3
      2620  120  RMSE  F01   0.01000         0 1 : Experiment 1 10000 HCMEC D3
      2621  120  RMSE  F02   0.01000         0 1 : Experiment 1 10000 HCMEC D3
      2622  120  RMSE  F03   0.01000         0 1 : Experiment 1 10000 HCMEC D3
      2623  120  RMSE  G01   0.04000         0 1 : Experiment 1  5000 HCMEC D3
      2624  120  RMSE  G02   0.04000         0 1 : Experiment 1  5000 HCMEC D3
      2625  120  RMSE  G03   0.03000         0 1 : Experiment 1  5000 HCMEC D3
      2626  125 Alpha  A01   3.38000         0 1 : Experiment 1 35000 HCMEC D3
      2627  125 Alpha  A02   3.40000         0 1 : Experiment 1 35000 HCMEC D3
      2628  125 Alpha  A03   3.36000         0 1 : Experiment 1 35000 HCMEC D3
      2629  125 Alpha  B01   3.63000         0 1 : Experiment 1 30000 HCMEC D3
      2630  125 Alpha  B02   3.69000         0 1 : Experiment 1 30000 HCMEC D3
      2631  125 Alpha  B03   3.60000         0 1 : Experiment 1 30000 HCMEC D3
      2632  125 Alpha  C01   3.77000         0 1 : Experiment 1 25000 HCMEC D3
      2633  125 Alpha  C02   3.82000         0 1 : Experiment 1 25000 HCMEC D3
      2634  125 Alpha  C03   3.81000         0 1 : Experiment 1 25000 HCMEC D3
      2635  125 Alpha  D01   3.99000         0 1 : Experiment 1 20000 HCMEC D3
      2636  125 Alpha  D02   4.01000         0 1 : Experiment 1 20000 HCMEC D3
      2637  125 Alpha  D03   3.93000         0 1 : Experiment 1 20000 HCMEC D3
      2638  125 Alpha  E01   4.08000         0 1 : Experiment 1 15000 HCMEC D3
      2639  125 Alpha  E02   4.19000         0 1 : Experiment 1 15000 HCMEC D3
      2640  125 Alpha  E03   4.13000         0 1 : Experiment 1 15000 HCMEC D3
      2641  125 Alpha  F01   4.34000         0 1 : Experiment 1 10000 HCMEC D3
      2642  125 Alpha  F02   4.55000         0 1 : Experiment 1 10000 HCMEC D3
      2643  125 Alpha  F03   4.37000         0 1 : Experiment 1 10000 HCMEC D3
      2644  125 Alpha  G01   4.80000         0 1 : Experiment 1  5000 HCMEC D3
      2645  125 Alpha  G02   5.03000         0 1 : Experiment 1  5000 HCMEC D3
      2646  125 Alpha  G03   4.92000         0 1 : Experiment 1  5000 HCMEC D3
      2647  125    Cm  A01   1.24000         0 1 : Experiment 1 35000 HCMEC D3
      2648  125    Cm  A02   1.14000         0 1 : Experiment 1 35000 HCMEC D3
      2649  125    Cm  A03   1.18000         0 1 : Experiment 1 35000 HCMEC D3
      2650  125    Cm  B01   1.10000         0 1 : Experiment 1 30000 HCMEC D3
      2651  125    Cm  B02   1.09000         0 1 : Experiment 1 30000 HCMEC D3
      2652  125    Cm  B03   1.10000         0 1 : Experiment 1 30000 HCMEC D3
      2653  125    Cm  C01   1.09000         0 1 : Experiment 1 25000 HCMEC D3
      2654  125    Cm  C02   1.05000         0 1 : Experiment 1 25000 HCMEC D3
      2655  125    Cm  C03   1.08000         0 1 : Experiment 1 25000 HCMEC D3
      2656  125    Cm  D01   1.09000         0 1 : Experiment 1 20000 HCMEC D3
      2657  125    Cm  D02   1.07000         0 1 : Experiment 1 20000 HCMEC D3
      2658  125    Cm  D03   1.09000         0 1 : Experiment 1 20000 HCMEC D3
      2659  125    Cm  E01   1.09000         0 1 : Experiment 1 15000 HCMEC D3
      2660  125    Cm  E02   1.06000         0 1 : Experiment 1 15000 HCMEC D3
      2661  125    Cm  E03   1.07000         0 1 : Experiment 1 15000 HCMEC D3
      2662  125    Cm  F01   1.10000         0 1 : Experiment 1 10000 HCMEC D3
      2663  125    Cm  F02   1.08000         0 1 : Experiment 1 10000 HCMEC D3
      2664  125    Cm  F03   1.05000         0 1 : Experiment 1 10000 HCMEC D3
      2665  125    Cm  G01   3.19000         0 1 : Experiment 1  5000 HCMEC D3
      2666  125    Cm  G02   2.67000         0 1 : Experiment 1  5000 HCMEC D3
      2667  125    Cm  G03   2.19000         0 1 : Experiment 1  5000 HCMEC D3
      2668  125 Drift  A01  -5.11000         0 1 : Experiment 1 35000 HCMEC D3
      2669  125 Drift  A02  -5.45000         0 1 : Experiment 1 35000 HCMEC D3
      2670  125 Drift  A03  -4.87000         0 1 : Experiment 1 35000 HCMEC D3
      2671  125 Drift  B01  -5.72000         0 1 : Experiment 1 30000 HCMEC D3
      2672  125 Drift  B02  -5.98000         0 1 : Experiment 1 30000 HCMEC D3
      2673  125 Drift  B03  -5.48000         0 1 : Experiment 1 30000 HCMEC D3
      2674  125 Drift  C01  -6.04000         0 1 : Experiment 1 25000 HCMEC D3
      2675  125 Drift  C02  -6.32000         0 1 : Experiment 1 25000 HCMEC D3
      2676  125 Drift  C03  -5.76000         0 1 : Experiment 1 25000 HCMEC D3
      2677  125 Drift  D01  -5.85000         0 1 : Experiment 1 20000 HCMEC D3
      2678  125 Drift  D02  -6.10000         0 1 : Experiment 1 20000 HCMEC D3
      2679  125 Drift  D03  -5.37000         0 1 : Experiment 1 20000 HCMEC D3
      2680  125 Drift  E01  -4.75000         0 1 : Experiment 1 15000 HCMEC D3
      2681  125 Drift  E02  -5.18000         0 1 : Experiment 1 15000 HCMEC D3
      2682  125 Drift  E03  -4.87000         0 1 : Experiment 1 15000 HCMEC D3
      2683  125 Drift  F01  -4.74000         0 1 : Experiment 1 10000 HCMEC D3
      2684  125 Drift  F02  -4.88000         0 1 : Experiment 1 10000 HCMEC D3
      2685  125 Drift  F03  -4.47000         0 1 : Experiment 1 10000 HCMEC D3
      2686  125 Drift  G01  -4.04000         0 1 : Experiment 1  5000 HCMEC D3
      2687  125 Drift  G02  -4.20000         0 1 : Experiment 1  5000 HCMEC D3
      2688  125 Drift  G03  -3.67000         0 1 : Experiment 1  5000 HCMEC D3
      2689  125    Rb  A01   1.53000         0 1 : Experiment 1 35000 HCMEC D3
      2690  125    Rb  A02   1.68000         0 1 : Experiment 1 35000 HCMEC D3
      2691  125    Rb  A03   1.64000         0 1 : Experiment 1 35000 HCMEC D3
      2692  125    Rb  B01   1.91000         0 1 : Experiment 1 30000 HCMEC D3
      2693  125    Rb  B02   1.92000         0 1 : Experiment 1 30000 HCMEC D3
      2694  125    Rb  B03   1.89000         0 1 : Experiment 1 30000 HCMEC D3
      2695  125    Rb  C01   1.99000         0 1 : Experiment 1 25000 HCMEC D3
      2696  125    Rb  C02   2.01000         0 1 : Experiment 1 25000 HCMEC D3
      2697  125    Rb  C03   2.02000         0 1 : Experiment 1 25000 HCMEC D3
      2698  125    Rb  D01   1.98000         0 1 : Experiment 1 20000 HCMEC D3
      2699  125    Rb  D02   2.07000         0 1 : Experiment 1 20000 HCMEC D3
      2700  125    Rb  D03   2.04000         0 1 : Experiment 1 20000 HCMEC D3
      2701  125    Rb  E01   2.23000         0 1 : Experiment 1 15000 HCMEC D3
      2702  125    Rb  E02   2.20000         0 1 : Experiment 1 15000 HCMEC D3
      2703  125    Rb  E03   2.27000         0 1 : Experiment 1 15000 HCMEC D3
      2704  125    Rb  F01   2.30000         0 1 : Experiment 1 10000 HCMEC D3
      2705  125    Rb  F02   2.15000         0 1 : Experiment 1 10000 HCMEC D3
      2706  125    Rb  F03   2.35000         0 1 : Experiment 1 10000 HCMEC D3
      2707  125    Rb  G01   0.00000         0 1 : Experiment 1  5000 HCMEC D3
      2708  125    Rb  G02   0.00000         0 1 : Experiment 1  5000 HCMEC D3
      2709  125    Rb  G03   0.00000         0 1 : Experiment 1  5000 HCMEC D3
      2710  125  RMSE  A01   0.01000         0 1 : Experiment 1 35000 HCMEC D3
      2711  125  RMSE  A02   0.01000         0 1 : Experiment 1 35000 HCMEC D3
      2712  125  RMSE  A03   0.01000         0 1 : Experiment 1 35000 HCMEC D3
      2713  125  RMSE  B01   0.01000         0 1 : Experiment 1 30000 HCMEC D3
      2714  125  RMSE  B02   0.01000         0 1 : Experiment 1 30000 HCMEC D3
      2715  125  RMSE  B03   0.01000         0 1 : Experiment 1 30000 HCMEC D3
      2716  125  RMSE  C01   0.01000         0 1 : Experiment 1 25000 HCMEC D3
      2717  125  RMSE  C02   0.01000         0 1 : Experiment 1 25000 HCMEC D3
      2718  125  RMSE  C03   0.01000         0 1 : Experiment 1 25000 HCMEC D3
      2719  125  RMSE  D01   0.01000         0 1 : Experiment 1 20000 HCMEC D3
      2720  125  RMSE  D02   0.01000         0 1 : Experiment 1 20000 HCMEC D3
      2721  125  RMSE  D03   0.01000         0 1 : Experiment 1 20000 HCMEC D3
      2722  125  RMSE  E01   0.01000         0 1 : Experiment 1 15000 HCMEC D3
      2723  125  RMSE  E02   0.01000         0 1 : Experiment 1 15000 HCMEC D3
      2724  125  RMSE  E03   0.01000         0 1 : Experiment 1 15000 HCMEC D3
      2725  125  RMSE  F01   0.01000         0 1 : Experiment 1 10000 HCMEC D3
      2726  125  RMSE  F02   0.01000         0 1 : Experiment 1 10000 HCMEC D3
      2727  125  RMSE  F03   0.01000         0 1 : Experiment 1 10000 HCMEC D3
      2728  125  RMSE  G01   0.04000         0 1 : Experiment 1  5000 HCMEC D3
      2729  125  RMSE  G02   0.03000         0 1 : Experiment 1  5000 HCMEC D3
      2730  125  RMSE  G03   0.03000         0 1 : Experiment 1  5000 HCMEC D3
      2731  130 Alpha  A01   3.30000         0 1 : Experiment 1 35000 HCMEC D3
      2732  130 Alpha  A02   3.35000         0 1 : Experiment 1 35000 HCMEC D3
      2733  130 Alpha  A03   3.32000         0 1 : Experiment 1 35000 HCMEC D3
      2734  130 Alpha  B01   3.56000         0 1 : Experiment 1 30000 HCMEC D3
      2735  130 Alpha  B02   3.63000         0 1 : Experiment 1 30000 HCMEC D3
      2736  130 Alpha  B03   3.56000         0 1 : Experiment 1 30000 HCMEC D3
      2737  130 Alpha  C01   3.73000         0 1 : Experiment 1 25000 HCMEC D3
      2738  130 Alpha  C02   3.77000         0 1 : Experiment 1 25000 HCMEC D3
      2739  130 Alpha  C03   3.77000         0 1 : Experiment 1 25000 HCMEC D3
      2740  130 Alpha  D01   3.89000         0 1 : Experiment 1 20000 HCMEC D3
      2741  130 Alpha  D02   3.91000         0 1 : Experiment 1 20000 HCMEC D3
      2742  130 Alpha  D03   3.86000         0 1 : Experiment 1 20000 HCMEC D3
      2743  130 Alpha  E01   4.05000         0 1 : Experiment 1 15000 HCMEC D3
      2744  130 Alpha  E02   4.12000         0 1 : Experiment 1 15000 HCMEC D3
      2745  130 Alpha  E03   4.06000         0 1 : Experiment 1 15000 HCMEC D3
      2746  130 Alpha  F01   4.26000         0 1 : Experiment 1 10000 HCMEC D3
      2747  130 Alpha  F02   4.48000         0 1 : Experiment 1 10000 HCMEC D3
      2748  130 Alpha  F03   4.34000         0 1 : Experiment 1 10000 HCMEC D3
      2749  130 Alpha  G01   5.00000         0 1 : Experiment 1  5000 HCMEC D3
      2750  130 Alpha  G02   5.24000         0 1 : Experiment 1  5000 HCMEC D3
      2751  130 Alpha  G03   5.06000         0 1 : Experiment 1  5000 HCMEC D3
      2752  130    Cm  A01   1.26000         0 1 : Experiment 1 35000 HCMEC D3
      2753  130    Cm  A02   1.16000         0 1 : Experiment 1 35000 HCMEC D3
      2754  130    Cm  A03   1.18000         0 1 : Experiment 1 35000 HCMEC D3
      2755  130    Cm  B01   1.11000         0 1 : Experiment 1 30000 HCMEC D3
      2756  130    Cm  B02   1.08000         0 1 : Experiment 1 30000 HCMEC D3
      2757  130    Cm  B03   1.11000         0 1 : Experiment 1 30000 HCMEC D3
      2758  130    Cm  C01   1.09000         0 1 : Experiment 1 25000 HCMEC D3
      2759  130    Cm  C02   1.06000         0 1 : Experiment 1 25000 HCMEC D3
      2760  130    Cm  C03   1.09000         0 1 : Experiment 1 25000 HCMEC D3
      2761  130    Cm  D01   1.09000         0 1 : Experiment 1 20000 HCMEC D3
      2762  130    Cm  D02   1.07000         0 1 : Experiment 1 20000 HCMEC D3
      2763  130    Cm  D03   1.09000         0 1 : Experiment 1 20000 HCMEC D3
      2764  130    Cm  E01   1.09000         0 1 : Experiment 1 15000 HCMEC D3
      2765  130    Cm  E02   1.06000         0 1 : Experiment 1 15000 HCMEC D3
      2766  130    Cm  E03   1.06000         0 1 : Experiment 1 15000 HCMEC D3
      2767  130    Cm  F01   1.07000         0 1 : Experiment 1 10000 HCMEC D3
      2768  130    Cm  F02   1.07000         0 1 : Experiment 1 10000 HCMEC D3
      2769  130    Cm  F03   1.05000         0 1 : Experiment 1 10000 HCMEC D3
      2770  130    Cm  G01   2.47000         0 1 : Experiment 1  5000 HCMEC D3
      2771  130    Cm  G02   2.07000         0 1 : Experiment 1  5000 HCMEC D3
      2772  130    Cm  G03   1.71000         0 1 : Experiment 1  5000 HCMEC D3
      2773  130 Drift  A01  -4.99000         0 1 : Experiment 1 35000 HCMEC D3
      2774  130 Drift  A02  -5.34000         0 1 : Experiment 1 35000 HCMEC D3
      2775  130 Drift  A03  -4.75000         0 1 : Experiment 1 35000 HCMEC D3
      2776  130 Drift  B01  -5.61000         0 1 : Experiment 1 30000 HCMEC D3
      2777  130 Drift  B02  -5.88000         0 1 : Experiment 1 30000 HCMEC D3
      2778  130 Drift  B03  -5.37000         0 1 : Experiment 1 30000 HCMEC D3
      2779  130 Drift  C01  -5.94000         0 1 : Experiment 1 25000 HCMEC D3
      2780  130 Drift  C02  -6.25000         0 1 : Experiment 1 25000 HCMEC D3
      2781  130 Drift  C03  -5.67000         0 1 : Experiment 1 25000 HCMEC D3
      2782  130 Drift  D01  -5.75000         0 1 : Experiment 1 20000 HCMEC D3
      2783  130 Drift  D02  -6.03000         0 1 : Experiment 1 20000 HCMEC D3
      2784  130 Drift  D03  -5.28000         0 1 : Experiment 1 20000 HCMEC D3
      2785  130 Drift  E01  -4.67000         0 1 : Experiment 1 15000 HCMEC D3
      2786  130 Drift  E02  -5.10000         0 1 : Experiment 1 15000 HCMEC D3
      2787  130 Drift  E03  -4.79000         0 1 : Experiment 1 15000 HCMEC D3
      2788  130 Drift  F01  -4.66000         0 1 : Experiment 1 10000 HCMEC D3
      2789  130 Drift  F02  -4.80000         0 1 : Experiment 1 10000 HCMEC D3
      2790  130 Drift  F03  -4.39000         0 1 : Experiment 1 10000 HCMEC D3
      2791  130 Drift  G01  -3.97000         0 1 : Experiment 1  5000 HCMEC D3
      2792  130 Drift  G02  -4.13000         0 1 : Experiment 1  5000 HCMEC D3
      2793  130 Drift  G03  -3.57000         0 1 : Experiment 1  5000 HCMEC D3
      2794  130    Rb  A01   1.46000         0 1 : Experiment 1 35000 HCMEC D3
      2795  130    Rb  A02   1.58000         0 1 : Experiment 1 35000 HCMEC D3
      2796  130    Rb  A03   1.53000         0 1 : Experiment 1 35000 HCMEC D3
      2797  130    Rb  B01   1.80000         0 1 : Experiment 1 30000 HCMEC D3
      2798  130    Rb  B02   1.84000         0 1 : Experiment 1 30000 HCMEC D3
      2799  130    Rb  B03   1.75000         0 1 : Experiment 1 30000 HCMEC D3
      2800  130    Rb  C01   1.88000         0 1 : Experiment 1 25000 HCMEC D3
      2801  130    Rb  C02   1.88000         0 1 : Experiment 1 25000 HCMEC D3
      2802  130    Rb  C03   1.88000         0 1 : Experiment 1 25000 HCMEC D3
      2803  130    Rb  D01   1.90000         0 1 : Experiment 1 20000 HCMEC D3
      2804  130    Rb  D02   1.98000         0 1 : Experiment 1 20000 HCMEC D3
      2805  130    Rb  D03   1.91000         0 1 : Experiment 1 20000 HCMEC D3
      2806  130    Rb  E01   2.19000         0 1 : Experiment 1 15000 HCMEC D3
      2807  130    Rb  E02   2.11000         0 1 : Experiment 1 15000 HCMEC D3
      2808  130    Rb  E03   2.23000         0 1 : Experiment 1 15000 HCMEC D3
      2809  130    Rb  F01   2.26000         0 1 : Experiment 1 10000 HCMEC D3
      2810  130    Rb  F02   2.12000         0 1 : Experiment 1 10000 HCMEC D3
      2811  130    Rb  F03   2.23000         0 1 : Experiment 1 10000 HCMEC D3
      2812  130    Rb  G01   0.00000         0 1 : Experiment 1  5000 HCMEC D3
      2813  130    Rb  G02   0.00000         0 1 : Experiment 1  5000 HCMEC D3
      2814  130    Rb  G03   0.00000         0 1 : Experiment 1  5000 HCMEC D3
      2815  130  RMSE  A01   0.01000         0 1 : Experiment 1 35000 HCMEC D3
      2816  130  RMSE  A02   0.01000         0 1 : Experiment 1 35000 HCMEC D3
      2817  130  RMSE  A03   0.01000         0 1 : Experiment 1 35000 HCMEC D3
      2818  130  RMSE  B01   0.01000         0 1 : Experiment 1 30000 HCMEC D3
      2819  130  RMSE  B02   0.01000         0 1 : Experiment 1 30000 HCMEC D3
      2820  130  RMSE  B03   0.01000         0 1 : Experiment 1 30000 HCMEC D3
      2821  130  RMSE  C01   0.01000         0 1 : Experiment 1 25000 HCMEC D3
      2822  130  RMSE  C02   0.01000         0 1 : Experiment 1 25000 HCMEC D3
      2823  130  RMSE  C03   0.01000         0 1 : Experiment 1 25000 HCMEC D3
      2824  130  RMSE  D01   0.01000         0 1 : Experiment 1 20000 HCMEC D3
      2825  130  RMSE  D02   0.01000         0 1 : Experiment 1 20000 HCMEC D3
      2826  130  RMSE  D03   0.01000         0 1 : Experiment 1 20000 HCMEC D3
      2827  130  RMSE  E01   0.01000         0 1 : Experiment 1 15000 HCMEC D3
      2828  130  RMSE  E02   0.01000         0 1 : Experiment 1 15000 HCMEC D3
      2829  130  RMSE  E03   0.01000         0 1 : Experiment 1 15000 HCMEC D3
      2830  130  RMSE  F01   0.01000         0 1 : Experiment 1 10000 HCMEC D3
      2831  130  RMSE  F02   0.01000         0 1 : Experiment 1 10000 HCMEC D3
      2832  130  RMSE  F03   0.01000         0 1 : Experiment 1 10000 HCMEC D3
      2833  130  RMSE  G01   0.03000         0 1 : Experiment 1  5000 HCMEC D3
      2834  130  RMSE  G02   0.02000         0 1 : Experiment 1  5000 HCMEC D3
      2835  130  RMSE  G03   0.02000         0 1 : Experiment 1  5000 HCMEC D3
      2836  135 Alpha  A01   3.26000         0 1 : Experiment 1 35000 HCMEC D3
      2837  135 Alpha  A02   3.29000         0 1 : Experiment 1 35000 HCMEC D3
      2838  135 Alpha  A03   3.27000         0 1 : Experiment 1 35000 HCMEC D3
      2839  135 Alpha  B01   3.52000         0 1 : Experiment 1 30000 HCMEC D3
      2840  135 Alpha  B02   3.58000         0 1 : Experiment 1 30000 HCMEC D3
      2841  135 Alpha  B03   3.51000         0 1 : Experiment 1 30000 HCMEC D3
      2842  135 Alpha  C01   3.70000         0 1 : Experiment 1 25000 HCMEC D3
      2843  135 Alpha  C02   3.68000         0 1 : Experiment 1 25000 HCMEC D3
      2844  135 Alpha  C03   3.72000         0 1 : Experiment 1 25000 HCMEC D3
      2845  135 Alpha  D01   3.83000         0 1 : Experiment 1 20000 HCMEC D3
      2846  135 Alpha  D02   3.87000         0 1 : Experiment 1 20000 HCMEC D3
      2847  135 Alpha  D03   3.83000         0 1 : Experiment 1 20000 HCMEC D3
      2848  135 Alpha  E01   4.00000         0 1 : Experiment 1 15000 HCMEC D3
      2849  135 Alpha  E02   4.04000         0 1 : Experiment 1 15000 HCMEC D3
      2850  135 Alpha  E03   3.99000         0 1 : Experiment 1 15000 HCMEC D3
      2851  135 Alpha  F01   4.18000         0 1 : Experiment 1 10000 HCMEC D3
      2852  135 Alpha  F02   4.36000         0 1 : Experiment 1 10000 HCMEC D3
      2853  135 Alpha  F03   4.22000         0 1 : Experiment 1 10000 HCMEC D3
      2854  135 Alpha  G01   5.18000         0 1 : Experiment 1  5000 HCMEC D3
      2855  135 Alpha  G02   5.38000         0 1 : Experiment 1  5000 HCMEC D3
      2856  135 Alpha  G03   5.09000         0 1 : Experiment 1  5000 HCMEC D3
      2857  135    Cm  A01   1.26000         0 1 : Experiment 1 35000 HCMEC D3
      2858  135    Cm  A02   1.16000         0 1 : Experiment 1 35000 HCMEC D3
      2859  135    Cm  A03   1.19000         0 1 : Experiment 1 35000 HCMEC D3
      2860  135    Cm  B01   1.11000         0 1 : Experiment 1 30000 HCMEC D3
      2861  135    Cm  B02   1.08000         0 1 : Experiment 1 30000 HCMEC D3
      2862  135    Cm  B03   1.09000         0 1 : Experiment 1 30000 HCMEC D3
      2863  135    Cm  C01   1.09000         0 1 : Experiment 1 25000 HCMEC D3
      2864  135    Cm  C02   1.06000         0 1 : Experiment 1 25000 HCMEC D3
      2865  135    Cm  C03   1.09000         0 1 : Experiment 1 25000 HCMEC D3
      2866  135    Cm  D01   1.10000         0 1 : Experiment 1 20000 HCMEC D3
      2867  135    Cm  D02   1.07000         0 1 : Experiment 1 20000 HCMEC D3
      2868  135    Cm  D03   1.09000         0 1 : Experiment 1 20000 HCMEC D3
      2869  135    Cm  E01   1.07000         0 1 : Experiment 1 15000 HCMEC D3
      2870  135    Cm  E02   1.04000         0 1 : Experiment 1 15000 HCMEC D3
      2871  135    Cm  E03   1.07000         0 1 : Experiment 1 15000 HCMEC D3
      2872  135    Cm  F01   1.07000         0 1 : Experiment 1 10000 HCMEC D3
      2873  135    Cm  F02   1.06000         0 1 : Experiment 1 10000 HCMEC D3
      2874  135    Cm  F03   1.05000         0 1 : Experiment 1 10000 HCMEC D3
      2875  135    Cm  G01   2.05000         0 1 : Experiment 1  5000 HCMEC D3
      2876  135    Cm  G02   1.57000         0 1 : Experiment 1  5000 HCMEC D3
      2877  135    Cm  G03   1.46000         0 1 : Experiment 1  5000 HCMEC D3
      2878  135 Drift  A01  -4.88000         0 1 : Experiment 1 35000 HCMEC D3
      2879  135 Drift  A02  -5.21000         0 1 : Experiment 1 35000 HCMEC D3
      2880  135 Drift  A03  -4.62000         0 1 : Experiment 1 35000 HCMEC D3
      2881  135 Drift  B01  -5.51000         0 1 : Experiment 1 30000 HCMEC D3
      2882  135 Drift  B02  -5.78000         0 1 : Experiment 1 30000 HCMEC D3
      2883  135 Drift  B03  -5.27000         0 1 : Experiment 1 30000 HCMEC D3
      2884  135 Drift  C01  -5.86000         0 1 : Experiment 1 25000 HCMEC D3
      2885  135 Drift  C02  -6.14000         0 1 : Experiment 1 25000 HCMEC D3
      2886  135 Drift  C03  -5.58000         0 1 : Experiment 1 25000 HCMEC D3
      2887  135 Drift  D01  -5.66000         0 1 : Experiment 1 20000 HCMEC D3
      2888  135 Drift  D02  -5.90000         0 1 : Experiment 1 20000 HCMEC D3
      2889  135 Drift  D03  -5.20000         0 1 : Experiment 1 20000 HCMEC D3
      2890  135 Drift  E01  -4.59000         0 1 : Experiment 1 15000 HCMEC D3
      2891  135 Drift  E02  -5.01000         0 1 : Experiment 1 15000 HCMEC D3
      2892  135 Drift  E03  -4.68000         0 1 : Experiment 1 15000 HCMEC D3
      2893  135 Drift  F01  -4.57000         0 1 : Experiment 1 10000 HCMEC D3
      2894  135 Drift  F02  -4.70000         0 1 : Experiment 1 10000 HCMEC D3
      2895  135 Drift  F03  -4.29000         0 1 : Experiment 1 10000 HCMEC D3
      2896  135 Drift  G01  -3.87000         0 1 : Experiment 1  5000 HCMEC D3
      2897  135 Drift  G02  -4.05000         0 1 : Experiment 1  5000 HCMEC D3
      2898  135 Drift  G03  -3.43000         0 1 : Experiment 1  5000 HCMEC D3
      2899  135    Rb  A01   1.39000         0 1 : Experiment 1 35000 HCMEC D3
      2900  135    Rb  A02   1.52000         0 1 : Experiment 1 35000 HCMEC D3
      2901  135    Rb  A03   1.47000         0 1 : Experiment 1 35000 HCMEC D3
      2902  135    Rb  B01   1.70000         0 1 : Experiment 1 30000 HCMEC D3
      2903  135    Rb  B02   1.74000         0 1 : Experiment 1 30000 HCMEC D3
      2904  135    Rb  B03   1.72000         0 1 : Experiment 1 30000 HCMEC D3
      2905  135    Rb  C01   1.77000         0 1 : Experiment 1 25000 HCMEC D3
      2906  135    Rb  C02   1.80000         0 1 : Experiment 1 25000 HCMEC D3
      2907  135    Rb  C03   1.79000         0 1 : Experiment 1 25000 HCMEC D3
      2908  135    Rb  D01   1.76000         0 1 : Experiment 1 20000 HCMEC D3
      2909  135    Rb  D02   1.87000         0 1 : Experiment 1 20000 HCMEC D3
      2910  135    Rb  D03   1.81000         0 1 : Experiment 1 20000 HCMEC D3
      2911  135    Rb  E01   2.12000         0 1 : Experiment 1 15000 HCMEC D3
      2912  135    Rb  E02   2.08000         0 1 : Experiment 1 15000 HCMEC D3
      2913  135    Rb  E03   2.12000         0 1 : Experiment 1 15000 HCMEC D3
      2914  135    Rb  F01   2.22000         0 1 : Experiment 1 10000 HCMEC D3
      2915  135    Rb  F02   2.10000         0 1 : Experiment 1 10000 HCMEC D3
      2916  135    Rb  F03   2.25000         0 1 : Experiment 1 10000 HCMEC D3
      2917  135    Rb  G01   0.00000         0 1 : Experiment 1  5000 HCMEC D3
      2918  135    Rb  G02   0.00000         0 1 : Experiment 1  5000 HCMEC D3
      2919  135    Rb  G03   0.00000         0 1 : Experiment 1  5000 HCMEC D3
      2920  135  RMSE  A01   0.01000         0 1 : Experiment 1 35000 HCMEC D3
      2921  135  RMSE  A02   0.01000         0 1 : Experiment 1 35000 HCMEC D3
      2922  135  RMSE  A03   0.01000         0 1 : Experiment 1 35000 HCMEC D3
      2923  135  RMSE  B01   0.01000         0 1 : Experiment 1 30000 HCMEC D3
      2924  135  RMSE  B02   0.01000         0 1 : Experiment 1 30000 HCMEC D3
      2925  135  RMSE  B03   0.01000         0 1 : Experiment 1 30000 HCMEC D3
      2926  135  RMSE  C01   0.01000         0 1 : Experiment 1 25000 HCMEC D3
      2927  135  RMSE  C02   0.01000         0 1 : Experiment 1 25000 HCMEC D3
      2928  135  RMSE  C03   0.01000         0 1 : Experiment 1 25000 HCMEC D3
      2929  135  RMSE  D01   0.01000         0 1 : Experiment 1 20000 HCMEC D3
      2930  135  RMSE  D02   0.01000         0 1 : Experiment 1 20000 HCMEC D3
      2931  135  RMSE  D03   0.01000         0 1 : Experiment 1 20000 HCMEC D3
      2932  135  RMSE  E01   0.01000         0 1 : Experiment 1 15000 HCMEC D3
      2933  135  RMSE  E02   0.01000         0 1 : Experiment 1 15000 HCMEC D3
      2934  135  RMSE  E03   0.01000         0 1 : Experiment 1 15000 HCMEC D3
      2935  135  RMSE  F01   0.01000         0 1 : Experiment 1 10000 HCMEC D3
      2936  135  RMSE  F02   0.01000         0 1 : Experiment 1 10000 HCMEC D3
      2937  135  RMSE  F03   0.01000         0 1 : Experiment 1 10000 HCMEC D3
      2938  135  RMSE  G01   0.02000         0 1 : Experiment 1  5000 HCMEC D3
      2939  135  RMSE  G02   0.02000         0 1 : Experiment 1  5000 HCMEC D3
      2940  135  RMSE  G03   0.01000         0 1 : Experiment 1  5000 HCMEC D3
      2941  140 Alpha  A01   3.22000         0 1 : Experiment 1 35000 HCMEC D3
      2942  140 Alpha  A02   3.24000         0 1 : Experiment 1 35000 HCMEC D3
      2943  140 Alpha  A03   3.24000         0 1 : Experiment 1 35000 HCMEC D3
      2944  140 Alpha  B01   3.45000         0 1 : Experiment 1 30000 HCMEC D3
      2945  140 Alpha  B02   3.53000         0 1 : Experiment 1 30000 HCMEC D3
      2946  140 Alpha  B03   3.48000         0 1 : Experiment 1 30000 HCMEC D3
      2947  140 Alpha  C01   3.64000         0 1 : Experiment 1 25000 HCMEC D3
      2948  140 Alpha  C02   3.65000         0 1 : Experiment 1 25000 HCMEC D3
      2949  140 Alpha  C03   3.71000         0 1 : Experiment 1 25000 HCMEC D3
      2950  140 Alpha  D01   3.83000         0 1 : Experiment 1 20000 HCMEC D3
      2951  140 Alpha  D02   3.89000         0 1 : Experiment 1 20000 HCMEC D3
      2952  140 Alpha  D03   3.80000         0 1 : Experiment 1 20000 HCMEC D3
      2953  140 Alpha  E01   3.93000         0 1 : Experiment 1 15000 HCMEC D3
      2954  140 Alpha  E02   4.01000         0 1 : Experiment 1 15000 HCMEC D3
      2955  140 Alpha  E03   3.92000         0 1 : Experiment 1 15000 HCMEC D3
      2956  140 Alpha  F01   4.10000         0 1 : Experiment 1 10000 HCMEC D3
      2957  140 Alpha  F02   4.29000         0 1 : Experiment 1 10000 HCMEC D3
      2958  140 Alpha  F03   4.19000         0 1 : Experiment 1 10000 HCMEC D3
      2959  140 Alpha  G01   5.25000         0 1 : Experiment 1  5000 HCMEC D3
      2960  140 Alpha  G02   5.41000         0 1 : Experiment 1  5000 HCMEC D3
      2961  140 Alpha  G03   5.17000         0 1 : Experiment 1  5000 HCMEC D3
      2962  140    Cm  A01   1.26000         0 1 : Experiment 1 35000 HCMEC D3
      2963  140    Cm  A02   1.16000         0 1 : Experiment 1 35000 HCMEC D3
      2964  140    Cm  A03   1.20000         0 1 : Experiment 1 35000 HCMEC D3
      2965  140    Cm  B01   1.11000         0 1 : Experiment 1 30000 HCMEC D3
      2966  140    Cm  B02   1.08000         0 1 : Experiment 1 30000 HCMEC D3
      2967  140    Cm  B03   1.09000         0 1 : Experiment 1 30000 HCMEC D3
      2968  140    Cm  C01   1.08000         0 1 : Experiment 1 25000 HCMEC D3
      2969  140    Cm  C02   1.06000         0 1 : Experiment 1 25000 HCMEC D3
      2970  140    Cm  C03   1.09000         0 1 : Experiment 1 25000 HCMEC D3
      2971  140    Cm  D01   1.11000         0 1 : Experiment 1 20000 HCMEC D3
      2972  140    Cm  D02   1.10000         0 1 : Experiment 1 20000 HCMEC D3
      2973  140    Cm  D03   1.10000         0 1 : Experiment 1 20000 HCMEC D3
      2974  140    Cm  E01   1.08000         0 1 : Experiment 1 15000 HCMEC D3
      2975  140    Cm  E02   1.05000         0 1 : Experiment 1 15000 HCMEC D3
      2976  140    Cm  E03   1.05000         0 1 : Experiment 1 15000 HCMEC D3
      2977  140    Cm  F01   1.05000         0 1 : Experiment 1 10000 HCMEC D3
      2978  140    Cm  F02   1.06000         0 1 : Experiment 1 10000 HCMEC D3
      2979  140    Cm  F03   1.07000         0 1 : Experiment 1 10000 HCMEC D3
      2980  140    Cm  G01   1.75000         0 1 : Experiment 1  5000 HCMEC D3
      2981  140    Cm  G02   1.40000         0 1 : Experiment 1  5000 HCMEC D3
      2982  140    Cm  G03   1.19000         0 1 : Experiment 1  5000 HCMEC D3
      2983  140 Drift  A01  -4.71000         0 1 : Experiment 1 35000 HCMEC D3
      2984  140 Drift  A02  -5.08000         0 1 : Experiment 1 35000 HCMEC D3
      2985  140 Drift  A03  -4.47000         0 1 : Experiment 1 35000 HCMEC D3
      2986  140 Drift  B01  -5.38000         0 1 : Experiment 1 30000 HCMEC D3
      2987  140 Drift  B02  -5.64000         0 1 : Experiment 1 30000 HCMEC D3
      2988  140 Drift  B03  -5.14000         0 1 : Experiment 1 30000 HCMEC D3
      2989  140 Drift  C01  -5.73000         0 1 : Experiment 1 25000 HCMEC D3
      2990  140 Drift  C02  -6.03000         0 1 : Experiment 1 25000 HCMEC D3
      2991  140 Drift  C03  -5.45000         0 1 : Experiment 1 25000 HCMEC D3
      2992  140 Drift  D01  -5.56000         0 1 : Experiment 1 20000 HCMEC D3
      2993  140 Drift  D02  -5.79000         0 1 : Experiment 1 20000 HCMEC D3
      2994  140 Drift  D03  -5.08000         0 1 : Experiment 1 20000 HCMEC D3
      2995  140 Drift  E01  -4.47000         0 1 : Experiment 1 15000 HCMEC D3
      2996  140 Drift  E02  -4.91000         0 1 : Experiment 1 15000 HCMEC D3
      2997  140 Drift  E03  -4.57000         0 1 : Experiment 1 15000 HCMEC D3
      2998  140 Drift  F01  -4.45000         0 1 : Experiment 1 10000 HCMEC D3
      2999  140 Drift  F02  -4.60000         0 1 : Experiment 1 10000 HCMEC D3
      3000  140 Drift  F03  -4.17000         0 1 : Experiment 1 10000 HCMEC D3
      3001  140 Drift  G01  -3.78000         0 1 : Experiment 1  5000 HCMEC D3
      3002  140 Drift  G02  -3.93000         0 1 : Experiment 1  5000 HCMEC D3
      3003  140 Drift  G03  -3.33000         0 1 : Experiment 1  5000 HCMEC D3
      3004  140    Rb  A01   1.31000         0 1 : Experiment 1 35000 HCMEC D3
      3005  140    Rb  A02   1.43000         0 1 : Experiment 1 35000 HCMEC D3
      3006  140    Rb  A03   1.40000         0 1 : Experiment 1 35000 HCMEC D3
      3007  140    Rb  B01   1.60000         0 1 : Experiment 1 30000 HCMEC D3
      3008  140    Rb  B02   1.70000         0 1 : Experiment 1 30000 HCMEC D3
      3009  140    Rb  B03   1.65000         0 1 : Experiment 1 30000 HCMEC D3
      3010  140    Rb  C01   1.67000         0 1 : Experiment 1 25000 HCMEC D3
      3011  140    Rb  C02   1.70000         0 1 : Experiment 1 25000 HCMEC D3
      3012  140    Rb  C03   1.69000         0 1 : Experiment 1 25000 HCMEC D3
      3013  140    Rb  D01   1.63000         0 1 : Experiment 1 20000 HCMEC D3
      3014  140    Rb  D02   1.69000         0 1 : Experiment 1 20000 HCMEC D3
      3015  140    Rb  D03   1.71000         0 1 : Experiment 1 20000 HCMEC D3
      3016  140    Rb  E01   1.99000         0 1 : Experiment 1 15000 HCMEC D3
      3017  140    Rb  E02   1.91000         0 1 : Experiment 1 15000 HCMEC D3
      3018  140    Rb  E03   2.05000         0 1 : Experiment 1 15000 HCMEC D3
      3019  140    Rb  F01   2.08000         0 1 : Experiment 1 10000 HCMEC D3
      3020  140    Rb  F02   2.02000         0 1 : Experiment 1 10000 HCMEC D3
      3021  140    Rb  F03   2.02000         0 1 : Experiment 1 10000 HCMEC D3
      3022  140    Rb  G01   0.00000         0 1 : Experiment 1  5000 HCMEC D3
      3023  140    Rb  G02   0.00000         0 1 : Experiment 1  5000 HCMEC D3
      3024  140    Rb  G03   0.00000         0 1 : Experiment 1  5000 HCMEC D3
      3025  140  RMSE  A01   0.01000         0 1 : Experiment 1 35000 HCMEC D3
      3026  140  RMSE  A02   0.01000         0 1 : Experiment 1 35000 HCMEC D3
      3027  140  RMSE  A03   0.01000         0 1 : Experiment 1 35000 HCMEC D3
      3028  140  RMSE  B01   0.01000         0 1 : Experiment 1 30000 HCMEC D3
      3029  140  RMSE  B02   0.01000         0 1 : Experiment 1 30000 HCMEC D3
      3030  140  RMSE  B03   0.01000         0 1 : Experiment 1 30000 HCMEC D3
      3031  140  RMSE  C01   0.01000         0 1 : Experiment 1 25000 HCMEC D3
      3032  140  RMSE  C02   0.01000         0 1 : Experiment 1 25000 HCMEC D3
      3033  140  RMSE  C03   0.01000         0 1 : Experiment 1 25000 HCMEC D3
      3034  140  RMSE  D01   0.01000         0 1 : Experiment 1 20000 HCMEC D3
      3035  140  RMSE  D02   0.01000         0 1 : Experiment 1 20000 HCMEC D3
      3036  140  RMSE  D03   0.01000         0 1 : Experiment 1 20000 HCMEC D3
      3037  140  RMSE  E01   0.01000         0 1 : Experiment 1 15000 HCMEC D3
      3038  140  RMSE  E02   0.01000         0 1 : Experiment 1 15000 HCMEC D3
      3039  140  RMSE  E03   0.01000         0 1 : Experiment 1 15000 HCMEC D3
      3040  140  RMSE  F01   0.01000         0 1 : Experiment 1 10000 HCMEC D3
      3041  140  RMSE  F02   0.01000         0 1 : Experiment 1 10000 HCMEC D3
      3042  140  RMSE  F03   0.01000         0 1 : Experiment 1 10000 HCMEC D3
      3043  140  RMSE  G01   0.02000         0 1 : Experiment 1  5000 HCMEC D3
      3044  140  RMSE  G02   0.01000         0 1 : Experiment 1  5000 HCMEC D3
      3045  140  RMSE  G03   0.01000         0 1 : Experiment 1  5000 HCMEC D3
      3046  145 Alpha  A01   3.20000         0 1 : Experiment 1 35000 HCMEC D3
      3047  145 Alpha  A02   3.17000         0 1 : Experiment 1 35000 HCMEC D3
      3048  145 Alpha  A03   3.17000         0 1 : Experiment 1 35000 HCMEC D3
      3049  145 Alpha  B01   3.40000         0 1 : Experiment 1 30000 HCMEC D3
      3050  145 Alpha  B02   3.51000         0 1 : Experiment 1 30000 HCMEC D3
      3051  145 Alpha  B03   3.44000         0 1 : Experiment 1 30000 HCMEC D3
      3052  145 Alpha  C01   3.60000         0 1 : Experiment 1 25000 HCMEC D3
      3053  145 Alpha  C02   3.57000         0 1 : Experiment 1 25000 HCMEC D3
      3054  145 Alpha  C03   3.68000         0 1 : Experiment 1 25000 HCMEC D3
      3055  145 Alpha  D01   3.78000         0 1 : Experiment 1 20000 HCMEC D3
      3056  145 Alpha  D02   3.83000         0 1 : Experiment 1 20000 HCMEC D3
      3057  145 Alpha  D03   3.73000         0 1 : Experiment 1 20000 HCMEC D3
      3058  145 Alpha  E01   3.90000         0 1 : Experiment 1 15000 HCMEC D3
      3059  145 Alpha  E02   3.93000         0 1 : Experiment 1 15000 HCMEC D3
      3060  145 Alpha  E03   3.88000         0 1 : Experiment 1 15000 HCMEC D3
      3061  145 Alpha  F01   4.08000         0 1 : Experiment 1 10000 HCMEC D3
      3062  145 Alpha  F02   4.19000         0 1 : Experiment 1 10000 HCMEC D3
      3063  145 Alpha  F03   4.07000         0 1 : Experiment 1 10000 HCMEC D3
      3064  145 Alpha  G01   5.33000         0 1 : Experiment 1  5000 HCMEC D3
      3065  145 Alpha  G02   5.41000         0 1 : Experiment 1  5000 HCMEC D3
      3066  145 Alpha  G03   5.26000         0 1 : Experiment 1  5000 HCMEC D3
      3067  145    Cm  A01   1.27000         0 1 : Experiment 1 35000 HCMEC D3
      3068  145    Cm  A02   1.18000         0 1 : Experiment 1 35000 HCMEC D3
      3069  145    Cm  A03   1.21000         0 1 : Experiment 1 35000 HCMEC D3
      3070  145    Cm  B01   1.11000         0 1 : Experiment 1 30000 HCMEC D3
      3071  145    Cm  B02   1.07000         0 1 : Experiment 1 30000 HCMEC D3
      3072  145    Cm  B03   1.09000         0 1 : Experiment 1 30000 HCMEC D3
      3073  145    Cm  C01   1.08000         0 1 : Experiment 1 25000 HCMEC D3
      3074  145    Cm  C02   1.04000         0 1 : Experiment 1 25000 HCMEC D3
      3075  145    Cm  C03   1.09000         0 1 : Experiment 1 25000 HCMEC D3
      3076  145    Cm  D01   1.09000         0 1 : Experiment 1 20000 HCMEC D3
      3077  145    Cm  D02   1.08000         0 1 : Experiment 1 20000 HCMEC D3
      3078  145    Cm  D03   1.08000         0 1 : Experiment 1 20000 HCMEC D3
      3079  145    Cm  E01   1.10000         0 1 : Experiment 1 15000 HCMEC D3
      3080  145    Cm  E02   1.02000         0 1 : Experiment 1 15000 HCMEC D3
      3081  145    Cm  E03   1.07000         0 1 : Experiment 1 15000 HCMEC D3
      3082  145    Cm  F01   1.06000         0 1 : Experiment 1 10000 HCMEC D3
      3083  145    Cm  F02   1.07000         0 1 : Experiment 1 10000 HCMEC D3
      3084  145    Cm  F03   1.05000         0 1 : Experiment 1 10000 HCMEC D3
      3085  145    Cm  G01   1.35000         0 1 : Experiment 1  5000 HCMEC D3
      3086  145    Cm  G02   1.29000         0 1 : Experiment 1  5000 HCMEC D3
      3087  145    Cm  G03   1.09000         0 1 : Experiment 1  5000 HCMEC D3
      3088  145 Drift  A01  -4.56000         0 1 : Experiment 1 35000 HCMEC D3
      3089  145 Drift  A02  -4.93000         0 1 : Experiment 1 35000 HCMEC D3
      3090  145 Drift  A03  -4.31000         0 1 : Experiment 1 35000 HCMEC D3
      3091  145 Drift  B01  -5.24000         0 1 : Experiment 1 30000 HCMEC D3
      3092  145 Drift  B02  -5.51000         0 1 : Experiment 1 30000 HCMEC D3
      3093  145 Drift  B03  -5.00000         0 1 : Experiment 1 30000 HCMEC D3
      3094  145 Drift  C01  -5.61000         0 1 : Experiment 1 25000 HCMEC D3
      3095  145 Drift  C02  -5.90000         0 1 : Experiment 1 25000 HCMEC D3
      3096  145 Drift  C03  -5.34000         0 1 : Experiment 1 25000 HCMEC D3
      3097  145 Drift  D01  -5.44000         0 1 : Experiment 1 20000 HCMEC D3
      3098  145 Drift  D02  -5.65000         0 1 : Experiment 1 20000 HCMEC D3
      3099  145 Drift  D03  -4.96000         0 1 : Experiment 1 20000 HCMEC D3
      3100  145 Drift  E01  -4.35000         0 1 : Experiment 1 15000 HCMEC D3
      3101  145 Drift  E02  -4.81000         0 1 : Experiment 1 15000 HCMEC D3
      3102  145 Drift  E03  -4.43000         0 1 : Experiment 1 15000 HCMEC D3
      3103  145 Drift  F01  -4.34000         0 1 : Experiment 1 10000 HCMEC D3
      3104  145 Drift  F02  -4.49000         0 1 : Experiment 1 10000 HCMEC D3
      3105  145 Drift  F03  -4.04000         0 1 : Experiment 1 10000 HCMEC D3
      3106  145 Drift  G01  -3.63000         0 1 : Experiment 1  5000 HCMEC D3
      3107  145 Drift  G02  -3.83000         0 1 : Experiment 1  5000 HCMEC D3
      3108  145 Drift  G03  -3.24000         0 1 : Experiment 1  5000 HCMEC D3
      3109  145    Rb  A01   1.26000         0 1 : Experiment 1 35000 HCMEC D3
      3110  145    Rb  A02   1.35000         0 1 : Experiment 1 35000 HCMEC D3
      3111  145    Rb  A03   1.34000         0 1 : Experiment 1 35000 HCMEC D3
      3112  145    Rb  B01   1.55000         0 1 : Experiment 1 30000 HCMEC D3
      3113  145    Rb  B02   1.62000         0 1 : Experiment 1 30000 HCMEC D3
      3114  145    Rb  B03   1.56000         0 1 : Experiment 1 30000 HCMEC D3
      3115  145    Rb  C01   1.56000         0 1 : Experiment 1 25000 HCMEC D3
      3116  145    Rb  C02   1.63000         0 1 : Experiment 1 25000 HCMEC D3
      3117  145    Rb  C03   1.60000         0 1 : Experiment 1 25000 HCMEC D3
      3118  145    Rb  D01   1.57000         0 1 : Experiment 1 20000 HCMEC D3
      3119  145    Rb  D02   1.64000         0 1 : Experiment 1 20000 HCMEC D3
      3120  145    Rb  D03   1.63000         0 1 : Experiment 1 20000 HCMEC D3
      3121  145    Rb  E01   1.83000         0 1 : Experiment 1 15000 HCMEC D3
      3122  145    Rb  E02   1.89000         0 1 : Experiment 1 15000 HCMEC D3
      3123  145    Rb  E03   1.90000         0 1 : Experiment 1 15000 HCMEC D3
      3124  145    Rb  F01   1.92000         0 1 : Experiment 1 10000 HCMEC D3
      3125  145    Rb  F02   1.98000         0 1 : Experiment 1 10000 HCMEC D3
      3126  145    Rb  F03   2.04000         0 1 : Experiment 1 10000 HCMEC D3
      3127  145    Rb  G01   0.00000         0 1 : Experiment 1  5000 HCMEC D3
      3128  145    Rb  G02   0.15000         0 1 : Experiment 1  5000 HCMEC D3
      3129  145    Rb  G03   0.00000         0 1 : Experiment 1  5000 HCMEC D3
      3130  145  RMSE  A01   0.01000         0 1 : Experiment 1 35000 HCMEC D3
      3131  145  RMSE  A02   0.01000         0 1 : Experiment 1 35000 HCMEC D3
      3132  145  RMSE  A03   0.01000         0 1 : Experiment 1 35000 HCMEC D3
      3133  145  RMSE  B01   0.01000         0 1 : Experiment 1 30000 HCMEC D3
      3134  145  RMSE  B02   0.01000         0 1 : Experiment 1 30000 HCMEC D3
      3135  145  RMSE  B03   0.01000         0 1 : Experiment 1 30000 HCMEC D3
      3136  145  RMSE  C01   0.01000         0 1 : Experiment 1 25000 HCMEC D3
      3137  145  RMSE  C02   0.01000         0 1 : Experiment 1 25000 HCMEC D3
      3138  145  RMSE  C03   0.01000         0 1 : Experiment 1 25000 HCMEC D3
      3139  145  RMSE  D01   0.01000         0 1 : Experiment 1 20000 HCMEC D3
      3140  145  RMSE  D02   0.01000         0 1 : Experiment 1 20000 HCMEC D3
      3141  145  RMSE  D03   0.01000         0 1 : Experiment 1 20000 HCMEC D3
      3142  145  RMSE  E01   0.01000         0 1 : Experiment 1 15000 HCMEC D3
      3143  145  RMSE  E02   0.01000         0 1 : Experiment 1 15000 HCMEC D3
      3144  145  RMSE  E03   0.01000         0 1 : Experiment 1 15000 HCMEC D3
      3145  145  RMSE  F01   0.01000         0 1 : Experiment 1 10000 HCMEC D3
      3146  145  RMSE  F02   0.01000         0 1 : Experiment 1 10000 HCMEC D3
      3147  145  RMSE  F03   0.01000         0 1 : Experiment 1 10000 HCMEC D3
      3148  145  RMSE  G01   0.01000         0 1 : Experiment 1  5000 HCMEC D3
      3149  145  RMSE  G02   0.01000         0 1 : Experiment 1  5000 HCMEC D3
      3150  145  RMSE  G03   0.01000         0 1 : Experiment 1  5000 HCMEC D3
      3151  150 Alpha  A01   3.15000         0 1 : Experiment 1 35000 HCMEC D3
      3152  150 Alpha  A02   3.13000         0 1 : Experiment 1 35000 HCMEC D3
      3153  150 Alpha  A03   3.14000         0 1 : Experiment 1 35000 HCMEC D3
      3154  150 Alpha  B01   3.35000         0 1 : Experiment 1 30000 HCMEC D3
      3155  150 Alpha  B02   3.46000         0 1 : Experiment 1 30000 HCMEC D3
      3156  150 Alpha  B03   3.38000         0 1 : Experiment 1 30000 HCMEC D3
      3157  150 Alpha  C01   3.53000         0 1 : Experiment 1 25000 HCMEC D3
      3158  150 Alpha  C02   3.51000         0 1 : Experiment 1 25000 HCMEC D3
      3159  150 Alpha  C03   3.62000         0 1 : Experiment 1 25000 HCMEC D3
      3160  150 Alpha  D01   3.71000         0 1 : Experiment 1 20000 HCMEC D3
      3161  150 Alpha  D02   3.74000         0 1 : Experiment 1 20000 HCMEC D3
      3162  150 Alpha  D03   3.65000         0 1 : Experiment 1 20000 HCMEC D3
      3163  150 Alpha  E01   3.82000         0 1 : Experiment 1 15000 HCMEC D3
      3164  150 Alpha  E02   3.90000         0 1 : Experiment 1 15000 HCMEC D3
      3165  150 Alpha  E03   3.85000         0 1 : Experiment 1 15000 HCMEC D3
      3166  150 Alpha  F01   4.03000         0 1 : Experiment 1 10000 HCMEC D3
      3167  150 Alpha  F02   4.16000         0 1 : Experiment 1 10000 HCMEC D3
      3168  150 Alpha  F03   4.03000         0 1 : Experiment 1 10000 HCMEC D3
      3169  150 Alpha  G01   5.27000         0 1 : Experiment 1  5000 HCMEC D3
      3170  150 Alpha  G02   5.29000         0 1 : Experiment 1  5000 HCMEC D3
      3171  150 Alpha  G03   5.26000         0 1 : Experiment 1  5000 HCMEC D3
      3172  150    Cm  A01   1.29000         0 1 : Experiment 1 35000 HCMEC D3
      3173  150    Cm  A02   1.18000         0 1 : Experiment 1 35000 HCMEC D3
      3174  150    Cm  A03   1.24000         0 1 : Experiment 1 35000 HCMEC D3
      3175  150    Cm  B01   1.10000         0 1 : Experiment 1 30000 HCMEC D3
      3176  150    Cm  B02   1.07000         0 1 : Experiment 1 30000 HCMEC D3
      3177  150    Cm  B03   1.10000         0 1 : Experiment 1 30000 HCMEC D3
      3178  150    Cm  C01   1.09000         0 1 : Experiment 1 25000 HCMEC D3
      3179  150    Cm  C02   1.04000         0 1 : Experiment 1 25000 HCMEC D3
      3180  150    Cm  C03   1.09000         0 1 : Experiment 1 25000 HCMEC D3
      3181  150    Cm  D01   1.09000         0 1 : Experiment 1 20000 HCMEC D3
      3182  150    Cm  D02   1.07000         0 1 : Experiment 1 20000 HCMEC D3
      3183  150    Cm  D03   1.08000         0 1 : Experiment 1 20000 HCMEC D3
      3184  150    Cm  E01   1.10000         0 1 : Experiment 1 15000 HCMEC D3
      3185  150    Cm  E02   1.04000         0 1 : Experiment 1 15000 HCMEC D3
      3186  150    Cm  E03   1.07000         0 1 : Experiment 1 15000 HCMEC D3
      3187  150    Cm  F01   1.06000         0 1 : Experiment 1 10000 HCMEC D3
      3188  150    Cm  F02   1.07000         0 1 : Experiment 1 10000 HCMEC D3
      3189  150    Cm  F03   1.05000         0 1 : Experiment 1 10000 HCMEC D3
      3190  150    Cm  G01   1.40000         0 1 : Experiment 1  5000 HCMEC D3
      3191  150    Cm  G02   1.37000         0 1 : Experiment 1  5000 HCMEC D3
      3192  150    Cm  G03   1.14000         0 1 : Experiment 1  5000 HCMEC D3
      3193  150 Drift  A01  -4.40000         0 1 : Experiment 1 35000 HCMEC D3
      3194  150 Drift  A02  -4.78000         0 1 : Experiment 1 35000 HCMEC D3
      3195  150 Drift  A03  -4.14000         0 1 : Experiment 1 35000 HCMEC D3
      3196  150 Drift  B01  -5.10000         0 1 : Experiment 1 30000 HCMEC D3
      3197  150 Drift  B02  -5.37000         0 1 : Experiment 1 30000 HCMEC D3
      3198  150 Drift  B03  -4.85000         0 1 : Experiment 1 30000 HCMEC D3
      3199  150 Drift  C01  -5.47000         0 1 : Experiment 1 25000 HCMEC D3
      3200  150 Drift  C02  -5.76000         0 1 : Experiment 1 25000 HCMEC D3
      3201  150 Drift  C03  -5.20000         0 1 : Experiment 1 25000 HCMEC D3
      3202  150 Drift  D01  -5.29000         0 1 : Experiment 1 20000 HCMEC D3
      3203  150 Drift  D02  -5.51000         0 1 : Experiment 1 20000 HCMEC D3
      3204  150 Drift  D03  -4.82000         0 1 : Experiment 1 20000 HCMEC D3
      3205  150 Drift  E01  -4.22000         0 1 : Experiment 1 15000 HCMEC D3
      3206  150 Drift  E02  -4.70000         0 1 : Experiment 1 15000 HCMEC D3
      3207  150 Drift  E03  -4.30000         0 1 : Experiment 1 15000 HCMEC D3
      3208  150 Drift  F01  -4.22000         0 1 : Experiment 1 10000 HCMEC D3
      3209  150 Drift  F02  -4.39000         0 1 : Experiment 1 10000 HCMEC D3
      3210  150 Drift  F03  -3.90000         0 1 : Experiment 1 10000 HCMEC D3
      3211  150 Drift  G01  -3.49000         0 1 : Experiment 1  5000 HCMEC D3
      3212  150 Drift  G02  -3.69000         0 1 : Experiment 1  5000 HCMEC D3
      3213  150 Drift  G03  -3.11000         0 1 : Experiment 1  5000 HCMEC D3
      3214  150    Rb  A01   1.17000         0 1 : Experiment 1 35000 HCMEC D3
      3215  150    Rb  A02   1.31000         0 1 : Experiment 1 35000 HCMEC D3
      3216  150    Rb  A03   1.26000         0 1 : Experiment 1 35000 HCMEC D3
      3217  150    Rb  B01   1.49000         0 1 : Experiment 1 30000 HCMEC D3
      3218  150    Rb  B02   1.55000         0 1 : Experiment 1 30000 HCMEC D3
      3219  150    Rb  B03   1.46000         0 1 : Experiment 1 30000 HCMEC D3
      3220  150    Rb  C01   1.46000         0 1 : Experiment 1 25000 HCMEC D3
      3221  150    Rb  C02   1.54000         0 1 : Experiment 1 25000 HCMEC D3
      3222  150    Rb  C03   1.48000         0 1 : Experiment 1 25000 HCMEC D3
      3223  150    Rb  D01   1.46000         0 1 : Experiment 1 20000 HCMEC D3
      3224  150    Rb  D02   1.57000         0 1 : Experiment 1 20000 HCMEC D3
      3225  150    Rb  D03   1.54000         0 1 : Experiment 1 20000 HCMEC D3
      3226  150    Rb  E01   1.75000         0 1 : Experiment 1 15000 HCMEC D3
      3227  150    Rb  E02   1.72000         0 1 : Experiment 1 15000 HCMEC D3
      3228  150    Rb  E03   1.85000         0 1 : Experiment 1 15000 HCMEC D3
      3229  150    Rb  F01   1.86000         0 1 : Experiment 1 10000 HCMEC D3
      3230  150    Rb  F02   1.87000         0 1 : Experiment 1 10000 HCMEC D3
      3231  150    Rb  F03   1.95000         0 1 : Experiment 1 10000 HCMEC D3
      3232  150    Rb  G01   0.12000         0 1 : Experiment 1  5000 HCMEC D3
      3233  150    Rb  G02   0.35000         0 1 : Experiment 1  5000 HCMEC D3
      3234  150    Rb  G03   0.11000         0 1 : Experiment 1  5000 HCMEC D3
      3235  150  RMSE  A01   0.01000         0 1 : Experiment 1 35000 HCMEC D3
      3236  150  RMSE  A02   0.01000         0 1 : Experiment 1 35000 HCMEC D3
      3237  150  RMSE  A03   0.01000         0 1 : Experiment 1 35000 HCMEC D3
      3238  150  RMSE  B01   0.01000         0 1 : Experiment 1 30000 HCMEC D3
      3239  150  RMSE  B02   0.01000         0 1 : Experiment 1 30000 HCMEC D3
      3240  150  RMSE  B03   0.01000         0 1 : Experiment 1 30000 HCMEC D3
      3241  150  RMSE  C01   0.01000         0 1 : Experiment 1 25000 HCMEC D3
      3242  150  RMSE  C02   0.01000         0 1 : Experiment 1 25000 HCMEC D3
      3243  150  RMSE  C03   0.01000         0 1 : Experiment 1 25000 HCMEC D3
      3244  150  RMSE  D01   0.01000         0 1 : Experiment 1 20000 HCMEC D3
      3245  150  RMSE  D02   0.01000         0 1 : Experiment 1 20000 HCMEC D3
      3246  150  RMSE  D03   0.01000         0 1 : Experiment 1 20000 HCMEC D3
      3247  150  RMSE  E01   0.01000         0 1 : Experiment 1 15000 HCMEC D3
      3248  150  RMSE  E02   0.01000         0 1 : Experiment 1 15000 HCMEC D3
      3249  150  RMSE  E03   0.01000         0 1 : Experiment 1 15000 HCMEC D3
      3250  150  RMSE  F01   0.01000         0 1 : Experiment 1 10000 HCMEC D3
      3251  150  RMSE  F02   0.01000         0 1 : Experiment 1 10000 HCMEC D3
      3252  150  RMSE  F03   0.01000         0 1 : Experiment 1 10000 HCMEC D3
      3253  150  RMSE  G01   0.01000         0 1 : Experiment 1  5000 HCMEC D3
      3254  150  RMSE  G02   0.01000         0 1 : Experiment 1  5000 HCMEC D3
      3255  150  RMSE  G03   0.01000         0 1 : Experiment 1  5000 HCMEC D3
      3256  155 Alpha  A01   3.12000         0 1 : Experiment 1 35000 HCMEC D3
      3257  155 Alpha  A02   3.12000         0 1 : Experiment 1 35000 HCMEC D3
      3258  155 Alpha  A03   3.08000         0 1 : Experiment 1 35000 HCMEC D3
      3259  155 Alpha  B01   3.34000         0 1 : Experiment 1 30000 HCMEC D3
      3260  155 Alpha  B02   3.43000         0 1 : Experiment 1 30000 HCMEC D3
      3261  155 Alpha  B03   3.35000         0 1 : Experiment 1 30000 HCMEC D3
      3262  155 Alpha  C01   3.48000         0 1 : Experiment 1 25000 HCMEC D3
      3263  155 Alpha  C02   3.47000         0 1 : Experiment 1 25000 HCMEC D3
      3264  155 Alpha  C03   3.58000         0 1 : Experiment 1 25000 HCMEC D3
      3265  155 Alpha  D01   3.61000         0 1 : Experiment 1 20000 HCMEC D3
      3266  155 Alpha  D02   3.70000         0 1 : Experiment 1 20000 HCMEC D3
      3267  155 Alpha  D03   3.63000         0 1 : Experiment 1 20000 HCMEC D3
      3268  155 Alpha  E01   3.78000         0 1 : Experiment 1 15000 HCMEC D3
      3269  155 Alpha  E02   3.85000         0 1 : Experiment 1 15000 HCMEC D3
      3270  155 Alpha  E03   3.80000         0 1 : Experiment 1 15000 HCMEC D3
      3271  155 Alpha  F01   4.01000         0 1 : Experiment 1 10000 HCMEC D3
      3272  155 Alpha  F02   4.07000         0 1 : Experiment 1 10000 HCMEC D3
      3273  155 Alpha  F03   3.97000         0 1 : Experiment 1 10000 HCMEC D3
      3274  155 Alpha  G01   5.18000         0 1 : Experiment 1  5000 HCMEC D3
      3275  155 Alpha  G02   5.23000         0 1 : Experiment 1  5000 HCMEC D3
      3276  155 Alpha  G03   5.16000         0 1 : Experiment 1  5000 HCMEC D3
      3277  155    Cm  A01   1.30000         0 1 : Experiment 1 35000 HCMEC D3
      3278  155    Cm  A02   1.18000         0 1 : Experiment 1 35000 HCMEC D3
      3279  155    Cm  A03   1.24000         0 1 : Experiment 1 35000 HCMEC D3
      3280  155    Cm  B01   1.11000         0 1 : Experiment 1 30000 HCMEC D3
      3281  155    Cm  B02   1.08000         0 1 : Experiment 1 30000 HCMEC D3
      3282  155    Cm  B03   1.09000         0 1 : Experiment 1 30000 HCMEC D3
      3283  155    Cm  C01   1.08000         0 1 : Experiment 1 25000 HCMEC D3
      3284  155    Cm  C02   1.05000         0 1 : Experiment 1 25000 HCMEC D3
      3285  155    Cm  C03   1.09000         0 1 : Experiment 1 25000 HCMEC D3
      3286  155    Cm  D01   1.08000         0 1 : Experiment 1 20000 HCMEC D3
      3287  155    Cm  D02   1.06000         0 1 : Experiment 1 20000 HCMEC D3
      3288  155    Cm  D03   1.07000         0 1 : Experiment 1 20000 HCMEC D3
      3289  155    Cm  E01   1.11000         0 1 : Experiment 1 15000 HCMEC D3
      3290  155    Cm  E02   1.05000         0 1 : Experiment 1 15000 HCMEC D3
      3291  155    Cm  E03   1.07000         0 1 : Experiment 1 15000 HCMEC D3
      3292  155    Cm  F01   1.08000         0 1 : Experiment 1 10000 HCMEC D3
      3293  155    Cm  F02   1.04000         0 1 : Experiment 1 10000 HCMEC D3
      3294  155    Cm  F03   1.03000         0 1 : Experiment 1 10000 HCMEC D3
      3295  155    Cm  G01   1.50000         0 1 : Experiment 1  5000 HCMEC D3
      3296  155    Cm  G02   1.40000         0 1 : Experiment 1  5000 HCMEC D3
      3297  155    Cm  G03   1.17000         0 1 : Experiment 1  5000 HCMEC D3
      3298  155 Drift  A01  -4.22000         0 1 : Experiment 1 35000 HCMEC D3
      3299  155 Drift  A02  -4.60000         0 1 : Experiment 1 35000 HCMEC D3
      3300  155 Drift  A03  -3.94000         0 1 : Experiment 1 35000 HCMEC D3
      3301  155 Drift  B01  -4.94000         0 1 : Experiment 1 30000 HCMEC D3
      3302  155 Drift  B02  -5.20000         0 1 : Experiment 1 30000 HCMEC D3
      3303  155 Drift  B03  -4.68000         0 1 : Experiment 1 30000 HCMEC D3
      3304  155 Drift  C01  -5.29000         0 1 : Experiment 1 25000 HCMEC D3
      3305  155 Drift  C02  -5.61000         0 1 : Experiment 1 25000 HCMEC D3
      3306  155 Drift  C03  -5.04000         0 1 : Experiment 1 25000 HCMEC D3
      3307  155 Drift  D01  -5.15000         0 1 : Experiment 1 20000 HCMEC D3
      3308  155 Drift  D02  -5.36000         0 1 : Experiment 1 20000 HCMEC D3
      3309  155 Drift  D03  -4.67000         0 1 : Experiment 1 20000 HCMEC D3
      3310  155 Drift  E01  -4.07000         0 1 : Experiment 1 15000 HCMEC D3
      3311  155 Drift  E02  -4.50000         0 1 : Experiment 1 15000 HCMEC D3
      3312  155 Drift  E03  -4.15000         0 1 : Experiment 1 15000 HCMEC D3
      3313  155 Drift  F01  -4.08000         0 1 : Experiment 1 10000 HCMEC D3
      3314  155 Drift  F02  -4.24000         0 1 : Experiment 1 10000 HCMEC D3
      3315  155 Drift  F03  -3.75000         0 1 : Experiment 1 10000 HCMEC D3
      3316  155 Drift  G01  -3.35000         0 1 : Experiment 1  5000 HCMEC D3
      3317  155 Drift  G02  -3.56000         0 1 : Experiment 1  5000 HCMEC D3
      3318  155 Drift  G03  -2.97000         0 1 : Experiment 1  5000 HCMEC D3
      3319  155    Rb  A01   1.11000         0 1 : Experiment 1 35000 HCMEC D3
      3320  155    Rb  A02   1.25000         0 1 : Experiment 1 35000 HCMEC D3
      3321  155    Rb  A03   1.18000         0 1 : Experiment 1 35000 HCMEC D3
      3322  155    Rb  B01   1.38000         0 1 : Experiment 1 30000 HCMEC D3
      3323  155    Rb  B02   1.44000         0 1 : Experiment 1 30000 HCMEC D3
      3324  155    Rb  B03   1.40000         0 1 : Experiment 1 30000 HCMEC D3
      3325  155    Rb  C01   1.42000         0 1 : Experiment 1 25000 HCMEC D3
      3326  155    Rb  C02   1.43000         0 1 : Experiment 1 25000 HCMEC D3
      3327  155    Rb  C03   1.40000         0 1 : Experiment 1 25000 HCMEC D3
      3328  155    Rb  D01   1.42000         0 1 : Experiment 1 20000 HCMEC D3
      3329  155    Rb  D02   1.51000         0 1 : Experiment 1 20000 HCMEC D3
      3330  155    Rb  D03   1.45000         0 1 : Experiment 1 20000 HCMEC D3
      3331  155    Rb  E01   1.61000         0 1 : Experiment 1 15000 HCMEC D3
      3332  155    Rb  E02   1.64000         0 1 : Experiment 1 15000 HCMEC D3
      3333  155    Rb  E03   1.71000         0 1 : Experiment 1 15000 HCMEC D3
      3334  155    Rb  F01   1.73000         0 1 : Experiment 1 10000 HCMEC D3
      3335  155    Rb  F02   1.87000         0 1 : Experiment 1 10000 HCMEC D3
      3336  155    Rb  F03   1.91000         0 1 : Experiment 1 10000 HCMEC D3
      3337  155    Rb  G01   0.35000         0 1 : Experiment 1  5000 HCMEC D3
      3338  155    Rb  G02   0.49000         0 1 : Experiment 1  5000 HCMEC D3
      3339  155    Rb  G03   0.15000         0 1 : Experiment 1  5000 HCMEC D3
      3340  155  RMSE  A01   0.01000         0 1 : Experiment 1 35000 HCMEC D3
      3341  155  RMSE  A02   0.01000         0 1 : Experiment 1 35000 HCMEC D3
      3342  155  RMSE  A03   0.01000         0 1 : Experiment 1 35000 HCMEC D3
      3343  155  RMSE  B01   0.01000         0 1 : Experiment 1 30000 HCMEC D3
      3344  155  RMSE  B02   0.01000         0 1 : Experiment 1 30000 HCMEC D3
      3345  155  RMSE  B03   0.01000         0 1 : Experiment 1 30000 HCMEC D3
      3346  155  RMSE  C01   0.01000         0 1 : Experiment 1 25000 HCMEC D3
      3347  155  RMSE  C02   0.01000         0 1 : Experiment 1 25000 HCMEC D3
      3348  155  RMSE  C03   0.01000         0 1 : Experiment 1 25000 HCMEC D3
      3349  155  RMSE  D01   0.01000         0 1 : Experiment 1 20000 HCMEC D3
      3350  155  RMSE  D02   0.01000         0 1 : Experiment 1 20000 HCMEC D3
      3351  155  RMSE  D03   0.01000         0 1 : Experiment 1 20000 HCMEC D3
      3352  155  RMSE  E01   0.01000         0 1 : Experiment 1 15000 HCMEC D3
      3353  155  RMSE  E02   0.01000         0 1 : Experiment 1 15000 HCMEC D3
      3354  155  RMSE  E03   0.01000         0 1 : Experiment 1 15000 HCMEC D3
      3355  155  RMSE  F01   0.01000         0 1 : Experiment 1 10000 HCMEC D3
      3356  155  RMSE  F02   0.01000         0 1 : Experiment 1 10000 HCMEC D3
      3357  155  RMSE  F03   0.01000         0 1 : Experiment 1 10000 HCMEC D3
      3358  155  RMSE  G01   0.01000         0 1 : Experiment 1  5000 HCMEC D3
      3359  155  RMSE  G02   0.01000         0 1 : Experiment 1  5000 HCMEC D3
      3360  155  RMSE  G03   0.01000         0 1 : Experiment 1  5000 HCMEC D3
      3361  160 Alpha  A01   3.08000         0 1 : Experiment 1 35000 HCMEC D3
      3362  160 Alpha  A02   3.06000         0 1 : Experiment 1 35000 HCMEC D3
      3363  160 Alpha  A03   3.03000         0 1 : Experiment 1 35000 HCMEC D3
      3364  160 Alpha  B01   3.26000         0 1 : Experiment 1 30000 HCMEC D3
      3365  160 Alpha  B02   3.38000         0 1 : Experiment 1 30000 HCMEC D3
      3366  160 Alpha  B03   3.32000         0 1 : Experiment 1 30000 HCMEC D3
      3367  160 Alpha  C01   3.44000         0 1 : Experiment 1 25000 HCMEC D3
      3368  160 Alpha  C02   3.46000         0 1 : Experiment 1 25000 HCMEC D3
      3369  160 Alpha  C03   3.53000         0 1 : Experiment 1 25000 HCMEC D3
      3370  160 Alpha  D01   3.58000         0 1 : Experiment 1 20000 HCMEC D3
      3371  160 Alpha  D02   3.66000         0 1 : Experiment 1 20000 HCMEC D3
      3372  160 Alpha  D03   3.56000         0 1 : Experiment 1 20000 HCMEC D3
      3373  160 Alpha  E01   3.70000         0 1 : Experiment 1 15000 HCMEC D3
      3374  160 Alpha  E02   3.79000         0 1 : Experiment 1 15000 HCMEC D3
      3375  160 Alpha  E03   3.74000         0 1 : Experiment 1 15000 HCMEC D3
      3376  160 Alpha  F01   3.96000         0 1 : Experiment 1 10000 HCMEC D3
      3377  160 Alpha  F02   4.05000         0 1 : Experiment 1 10000 HCMEC D3
      3378  160 Alpha  F03   3.98000         0 1 : Experiment 1 10000 HCMEC D3
      3379  160 Alpha  G01   5.11000         0 1 : Experiment 1  5000 HCMEC D3
      3380  160 Alpha  G02   5.12000         0 1 : Experiment 1  5000 HCMEC D3
      3381  160 Alpha  G03   5.05000         0 1 : Experiment 1  5000 HCMEC D3
      3382  160    Cm  A01   1.33000         0 1 : Experiment 1 35000 HCMEC D3
      3383  160    Cm  A02   1.18000         0 1 : Experiment 1 35000 HCMEC D3
      3384  160    Cm  A03   1.26000         0 1 : Experiment 1 35000 HCMEC D3
      3385  160    Cm  B01   1.09000         0 1 : Experiment 1 30000 HCMEC D3
      3386  160    Cm  B02   1.07000         0 1 : Experiment 1 30000 HCMEC D3
      3387  160    Cm  B03   1.11000         0 1 : Experiment 1 30000 HCMEC D3
      3388  160    Cm  C01   1.08000         0 1 : Experiment 1 25000 HCMEC D3
      3389  160    Cm  C02   1.05000         0 1 : Experiment 1 25000 HCMEC D3
      3390  160    Cm  C03   1.07000         0 1 : Experiment 1 25000 HCMEC D3
      3391  160    Cm  D01   1.08000         0 1 : Experiment 1 20000 HCMEC D3
      3392  160    Cm  D02   1.04000         0 1 : Experiment 1 20000 HCMEC D3
      3393  160    Cm  D03   1.08000         0 1 : Experiment 1 20000 HCMEC D3
      3394  160    Cm  E01   1.07000         0 1 : Experiment 1 15000 HCMEC D3
      3395  160    Cm  E02   1.04000         0 1 : Experiment 1 15000 HCMEC D3
      3396  160    Cm  E03   1.07000         0 1 : Experiment 1 15000 HCMEC D3
      3397  160    Cm  F01   1.07000         0 1 : Experiment 1 10000 HCMEC D3
      3398  160    Cm  F02   1.06000         0 1 : Experiment 1 10000 HCMEC D3
      3399  160    Cm  F03   1.06000         0 1 : Experiment 1 10000 HCMEC D3
      3400  160    Cm  G01   1.43000         0 1 : Experiment 1  5000 HCMEC D3
      3401  160    Cm  G02   1.38000         0 1 : Experiment 1  5000 HCMEC D3
      3402  160    Cm  G03   1.29000         0 1 : Experiment 1  5000 HCMEC D3
      3403  160 Drift  A01  -4.03000         0 1 : Experiment 1 35000 HCMEC D3
      3404  160 Drift  A02  -4.42000         0 1 : Experiment 1 35000 HCMEC D3
      3405  160 Drift  A03  -3.74000         0 1 : Experiment 1 35000 HCMEC D3
      3406  160 Drift  B01  -4.77000         0 1 : Experiment 1 30000 HCMEC D3
      3407  160 Drift  B02  -5.02000         0 1 : Experiment 1 30000 HCMEC D3
      3408  160 Drift  B03  -4.50000         0 1 : Experiment 1 30000 HCMEC D3
      3409  160 Drift  C01  -5.13000         0 1 : Experiment 1 25000 HCMEC D3
      3410  160 Drift  C02  -5.45000         0 1 : Experiment 1 25000 HCMEC D3
      3411  160 Drift  C03  -4.87000         0 1 : Experiment 1 25000 HCMEC D3
      3412  160 Drift  D01  -4.99000         0 1 : Experiment 1 20000 HCMEC D3
      3413  160 Drift  D02  -5.20000         0 1 : Experiment 1 20000 HCMEC D3
      3414  160 Drift  D03  -4.51000         0 1 : Experiment 1 20000 HCMEC D3
      3415  160 Drift  E01  -3.91000         0 1 : Experiment 1 15000 HCMEC D3
      3416  160 Drift  E02  -4.37000         0 1 : Experiment 1 15000 HCMEC D3
      3417  160 Drift  E03  -3.99000         0 1 : Experiment 1 15000 HCMEC D3
      3418  160 Drift  F01  -3.94000         0 1 : Experiment 1 10000 HCMEC D3
      3419  160 Drift  F02  -4.10000         0 1 : Experiment 1 10000 HCMEC D3
      3420  160 Drift  F03  -3.60000         0 1 : Experiment 1 10000 HCMEC D3
      3421  160 Drift  G01  -3.19000         0 1 : Experiment 1  5000 HCMEC D3
      3422  160 Drift  G02  -3.40000         0 1 : Experiment 1  5000 HCMEC D3
      3423  160 Drift  G03  -2.81000         0 1 : Experiment 1  5000 HCMEC D3
      3424  160    Rb  A01   1.04000         0 1 : Experiment 1 35000 HCMEC D3
      3425  160    Rb  A02   1.19000         0 1 : Experiment 1 35000 HCMEC D3
      3426  160    Rb  A03   1.12000         0 1 : Experiment 1 35000 HCMEC D3
      3427  160    Rb  B01   1.35000         0 1 : Experiment 1 30000 HCMEC D3
      3428  160    Rb  B02   1.36000         0 1 : Experiment 1 30000 HCMEC D3
      3429  160    Rb  B03   1.30000         0 1 : Experiment 1 30000 HCMEC D3
      3430  160    Rb  C01   1.31000         0 1 : Experiment 1 25000 HCMEC D3
      3431  160    Rb  C02   1.33000         0 1 : Experiment 1 25000 HCMEC D3
      3432  160    Rb  C03   1.39000         0 1 : Experiment 1 25000 HCMEC D3
      3433  160    Rb  D01   1.34000         0 1 : Experiment 1 20000 HCMEC D3
      3434  160    Rb  D02   1.46000         0 1 : Experiment 1 20000 HCMEC D3
      3435  160    Rb  D03   1.38000         0 1 : Experiment 1 20000 HCMEC D3
      3436  160    Rb  E01   1.60000         0 1 : Experiment 1 15000 HCMEC D3
      3437  160    Rb  E02   1.57000         0 1 : Experiment 1 15000 HCMEC D3
      3438  160    Rb  E03   1.63000         0 1 : Experiment 1 15000 HCMEC D3
      3439  160    Rb  F01   1.60000         0 1 : Experiment 1 10000 HCMEC D3
      3440  160    Rb  F02   1.77000         0 1 : Experiment 1 10000 HCMEC D3
      3441  160    Rb  F03   1.74000         0 1 : Experiment 1 10000 HCMEC D3
      3442  160    Rb  G01   0.32000         0 1 : Experiment 1  5000 HCMEC D3
      3443  160    Rb  G02   0.64000         0 1 : Experiment 1  5000 HCMEC D3
      3444  160    Rb  G03   0.35000         0 1 : Experiment 1  5000 HCMEC D3
      3445  160  RMSE  A01   0.01000         0 1 : Experiment 1 35000 HCMEC D3
      3446  160  RMSE  A02   0.01000         0 1 : Experiment 1 35000 HCMEC D3
      3447  160  RMSE  A03   0.01000         0 1 : Experiment 1 35000 HCMEC D3
      3448  160  RMSE  B01   0.01000         0 1 : Experiment 1 30000 HCMEC D3
      3449  160  RMSE  B02   0.01000         0 1 : Experiment 1 30000 HCMEC D3
      3450  160  RMSE  B03   0.01000         0 1 : Experiment 1 30000 HCMEC D3
      3451  160  RMSE  C01   0.01000         0 1 : Experiment 1 25000 HCMEC D3
      3452  160  RMSE  C02   0.01000         0 1 : Experiment 1 25000 HCMEC D3
      3453  160  RMSE  C03   0.01000         0 1 : Experiment 1 25000 HCMEC D3
      3454  160  RMSE  D01   0.01000         0 1 : Experiment 1 20000 HCMEC D3
      3455  160  RMSE  D02   0.01000         0 1 : Experiment 1 20000 HCMEC D3
      3456  160  RMSE  D03   0.01000         0 1 : Experiment 1 20000 HCMEC D3
      3457  160  RMSE  E01   0.01000         0 1 : Experiment 1 15000 HCMEC D3
      3458  160  RMSE  E02   0.01000         0 1 : Experiment 1 15000 HCMEC D3
      3459  160  RMSE  E03   0.01000         0 1 : Experiment 1 15000 HCMEC D3
      3460  160  RMSE  F01   0.01000         0 1 : Experiment 1 10000 HCMEC D3
      3461  160  RMSE  F02   0.01000         0 1 : Experiment 1 10000 HCMEC D3
      3462  160  RMSE  F03   0.01000         0 1 : Experiment 1 10000 HCMEC D3
      3463  160  RMSE  G01   0.01000         0 1 : Experiment 1  5000 HCMEC D3
      3464  160  RMSE  G02   0.01000         0 1 : Experiment 1  5000 HCMEC D3
      3465  160  RMSE  G03   0.01000         0 1 : Experiment 1  5000 HCMEC D3
      3466  165 Alpha  A01   3.02000         0 1 : Experiment 1 35000 HCMEC D3
      3467  165 Alpha  A02   3.03000         0 1 : Experiment 1 35000 HCMEC D3
      3468  165 Alpha  A03   2.97000         0 1 : Experiment 1 35000 HCMEC D3
      3469  165 Alpha  B01   3.25000         0 1 : Experiment 1 30000 HCMEC D3
      3470  165 Alpha  B02   3.35000         0 1 : Experiment 1 30000 HCMEC D3
      3471  165 Alpha  B03   3.27000         0 1 : Experiment 1 30000 HCMEC D3
      3472  165 Alpha  C01   3.36000         0 1 : Experiment 1 25000 HCMEC D3
      3473  165 Alpha  C02   3.37000         0 1 : Experiment 1 25000 HCMEC D3
      3474  165 Alpha  C03   3.47000         0 1 : Experiment 1 25000 HCMEC D3
      3475  165 Alpha  D01   3.51000         0 1 : Experiment 1 20000 HCMEC D3
      3476  165 Alpha  D02   3.62000         0 1 : Experiment 1 20000 HCMEC D3
      3477  165 Alpha  D03   3.50000         0 1 : Experiment 1 20000 HCMEC D3
      3478  165 Alpha  E01   3.67000         0 1 : Experiment 1 15000 HCMEC D3
      3479  165 Alpha  E02   3.71000         0 1 : Experiment 1 15000 HCMEC D3
      3480  165 Alpha  E03   3.66000         0 1 : Experiment 1 15000 HCMEC D3
      3481  165 Alpha  F01   3.92000         0 1 : Experiment 1 10000 HCMEC D3
      3482  165 Alpha  F02   3.98000         0 1 : Experiment 1 10000 HCMEC D3
      3483  165 Alpha  F03   3.91000         0 1 : Experiment 1 10000 HCMEC D3
      3484  165 Alpha  G01   5.02000         0 1 : Experiment 1  5000 HCMEC D3
      3485  165 Alpha  G02   5.03000         0 1 : Experiment 1  5000 HCMEC D3
      3486  165 Alpha  G03   4.92000         0 1 : Experiment 1  5000 HCMEC D3
      3487  165    Cm  A01   1.34000         0 1 : Experiment 1 35000 HCMEC D3
      3488  165    Cm  A02   1.19000         0 1 : Experiment 1 35000 HCMEC D3
      3489  165    Cm  A03   1.26000         0 1 : Experiment 1 35000 HCMEC D3
      3490  165    Cm  B01   1.11000         0 1 : Experiment 1 30000 HCMEC D3
      3491  165    Cm  B02   1.07000         0 1 : Experiment 1 30000 HCMEC D3
      3492  165    Cm  B03   1.10000         0 1 : Experiment 1 30000 HCMEC D3
      3493  165    Cm  C01   1.08000         0 1 : Experiment 1 25000 HCMEC D3
      3494  165    Cm  C02   1.04000         0 1 : Experiment 1 25000 HCMEC D3
      3495  165    Cm  C03   1.07000         0 1 : Experiment 1 25000 HCMEC D3
      3496  165    Cm  D01   1.08000         0 1 : Experiment 1 20000 HCMEC D3
      3497  165    Cm  D02   1.06000         0 1 : Experiment 1 20000 HCMEC D3
      3498  165    Cm  D03   1.09000         0 1 : Experiment 1 20000 HCMEC D3
      3499  165    Cm  E01   1.06000         0 1 : Experiment 1 15000 HCMEC D3
      3500  165    Cm  E02   1.03000         0 1 : Experiment 1 15000 HCMEC D3
      3501  165    Cm  E03   1.07000         0 1 : Experiment 1 15000 HCMEC D3
      3502  165    Cm  F01   1.07000         0 1 : Experiment 1 10000 HCMEC D3
      3503  165    Cm  F02   1.05000         0 1 : Experiment 1 10000 HCMEC D3
      3504  165    Cm  F03   1.07000         0 1 : Experiment 1 10000 HCMEC D3
      3505  165    Cm  G01   1.43000         0 1 : Experiment 1  5000 HCMEC D3
      3506  165    Cm  G02   1.37000         0 1 : Experiment 1  5000 HCMEC D3
      3507  165    Cm  G03   1.28000         0 1 : Experiment 1  5000 HCMEC D3
      3508  165 Drift  A01  -3.82000         0 1 : Experiment 1 35000 HCMEC D3
      3509  165 Drift  A02  -4.22000         0 1 : Experiment 1 35000 HCMEC D3
      3510  165 Drift  A03  -3.52000         0 1 : Experiment 1 35000 HCMEC D3
      3511  165 Drift  B01  -4.58000         0 1 : Experiment 1 30000 HCMEC D3
      3512  165 Drift  B02  -4.84000         0 1 : Experiment 1 30000 HCMEC D3
      3513  165 Drift  B03  -4.31000         0 1 : Experiment 1 30000 HCMEC D3
      3514  165 Drift  C01  -4.95000         0 1 : Experiment 1 25000 HCMEC D3
      3515  165 Drift  C02  -5.28000         0 1 : Experiment 1 25000 HCMEC D3
      3516  165 Drift  C03  -4.68000         0 1 : Experiment 1 25000 HCMEC D3
      3517  165 Drift  D01  -4.83000         0 1 : Experiment 1 20000 HCMEC D3
      3518  165 Drift  D02  -5.03000         0 1 : Experiment 1 20000 HCMEC D3
      3519  165 Drift  D03  -4.32000         0 1 : Experiment 1 20000 HCMEC D3
      3520  165 Drift  E01  -3.74000         0 1 : Experiment 1 15000 HCMEC D3
      3521  165 Drift  E02  -4.19000         0 1 : Experiment 1 15000 HCMEC D3
      3522  165 Drift  E03  -3.81000         0 1 : Experiment 1 15000 HCMEC D3
      3523  165 Drift  F01  -3.77000         0 1 : Experiment 1 10000 HCMEC D3
      3524  165 Drift  F02  -3.97000         0 1 : Experiment 1 10000 HCMEC D3
      3525  165 Drift  F03  -3.41000         0 1 : Experiment 1 10000 HCMEC D3
      3526  165 Drift  G01  -3.03000         0 1 : Experiment 1  5000 HCMEC D3
      3527  165 Drift  G02  -3.24000         0 1 : Experiment 1  5000 HCMEC D3
      3528  165 Drift  G03  -2.63000         0 1 : Experiment 1  5000 HCMEC D3
      3529  165    Rb  A01   0.99000         0 1 : Experiment 1 35000 HCMEC D3
      3530  165    Rb  A02   1.13000         0 1 : Experiment 1 35000 HCMEC D3
      3531  165    Rb  A03   1.06000         0 1 : Experiment 1 35000 HCMEC D3
      3532  165    Rb  B01   1.26000         0 1 : Experiment 1 30000 HCMEC D3
      3533  165    Rb  B02   1.28000         0 1 : Experiment 1 30000 HCMEC D3
      3534  165    Rb  B03   1.26000         0 1 : Experiment 1 30000 HCMEC D3
      3535  165    Rb  C01   1.27000         0 1 : Experiment 1 25000 HCMEC D3
      3536  165    Rb  C02   1.30000         0 1 : Experiment 1 25000 HCMEC D3
      3537  165    Rb  C03   1.28000         0 1 : Experiment 1 25000 HCMEC D3
      3538  165    Rb  D01   1.26000         0 1 : Experiment 1 20000 HCMEC D3
      3539  165    Rb  D02   1.33000         0 1 : Experiment 1 20000 HCMEC D3
      3540  165    Rb  D03   1.30000         0 1 : Experiment 1 20000 HCMEC D3
      3541  165    Rb  E01   1.53000         0 1 : Experiment 1 15000 HCMEC D3
      3542  165    Rb  E02   1.48000         0 1 : Experiment 1 15000 HCMEC D3
      3543  165    Rb  E03   1.54000         0 1 : Experiment 1 15000 HCMEC D3
      3544  165    Rb  F01   1.55000         0 1 : Experiment 1 10000 HCMEC D3
      3545  165    Rb  F02   1.61000         0 1 : Experiment 1 10000 HCMEC D3
      3546  165    Rb  F03   1.64000         0 1 : Experiment 1 10000 HCMEC D3
      3547  165    Rb  G01   0.39000         0 1 : Experiment 1  5000 HCMEC D3
      3548  165    Rb  G02   0.68000         0 1 : Experiment 1  5000 HCMEC D3
      3549  165    Rb  G03   0.49000         0 1 : Experiment 1  5000 HCMEC D3
      3550  165  RMSE  A01   0.01000         0 1 : Experiment 1 35000 HCMEC D3
      3551  165  RMSE  A02   0.01000         0 1 : Experiment 1 35000 HCMEC D3
      3552  165  RMSE  A03   0.01000         0 1 : Experiment 1 35000 HCMEC D3
      3553  165  RMSE  B01   0.01000         0 1 : Experiment 1 30000 HCMEC D3
      3554  165  RMSE  B02   0.01000         0 1 : Experiment 1 30000 HCMEC D3
      3555  165  RMSE  B03   0.01000         0 1 : Experiment 1 30000 HCMEC D3
      3556  165  RMSE  C01   0.01000         0 1 : Experiment 1 25000 HCMEC D3
      3557  165  RMSE  C02   0.01000         0 1 : Experiment 1 25000 HCMEC D3
      3558  165  RMSE  C03   0.01000         0 1 : Experiment 1 25000 HCMEC D3
      3559  165  RMSE  D01   0.01000         0 1 : Experiment 1 20000 HCMEC D3
      3560  165  RMSE  D02   0.01000         0 1 : Experiment 1 20000 HCMEC D3
      3561  165  RMSE  D03   0.01000         0 1 : Experiment 1 20000 HCMEC D3
      3562  165  RMSE  E01   0.01000         0 1 : Experiment 1 15000 HCMEC D3
      3563  165  RMSE  E02   0.01000         0 1 : Experiment 1 15000 HCMEC D3
      3564  165  RMSE  E03   0.01000         0 1 : Experiment 1 15000 HCMEC D3
      3565  165  RMSE  F01   0.01000         0 1 : Experiment 1 10000 HCMEC D3
      3566  165  RMSE  F02   0.01000         0 1 : Experiment 1 10000 HCMEC D3
      3567  165  RMSE  F03   0.01000         0 1 : Experiment 1 10000 HCMEC D3
      3568  165  RMSE  G01   0.01000         0 1 : Experiment 1  5000 HCMEC D3
      3569  165  RMSE  G02   0.01000         0 1 : Experiment 1  5000 HCMEC D3
      3570  165  RMSE  G03   0.01000         0 1 : Experiment 1  5000 HCMEC D3
      3571  170 Alpha  A01   2.97000         0 1 : Experiment 1 35000 HCMEC D3
      3572  170 Alpha  A02   3.01000         0 1 : Experiment 1 35000 HCMEC D3
      3573  170 Alpha  A03   2.94000         0 1 : Experiment 1 35000 HCMEC D3
      3574  170 Alpha  B01   3.19000         0 1 : Experiment 1 30000 HCMEC D3
      3575  170 Alpha  B02   3.30000         0 1 : Experiment 1 30000 HCMEC D3
      3576  170 Alpha  B03   3.22000         0 1 : Experiment 1 30000 HCMEC D3
      3577  170 Alpha  C01   3.31000         0 1 : Experiment 1 25000 HCMEC D3
      3578  170 Alpha  C02   3.33000         0 1 : Experiment 1 25000 HCMEC D3
      3579  170 Alpha  C03   3.44000         0 1 : Experiment 1 25000 HCMEC D3
      3580  170 Alpha  D01   4.78000         0 1 : Experiment 1 20000 HCMEC D3
      3581  170 Alpha  D02   3.58000         0 1 : Experiment 1 20000 HCMEC D3
      3582  170 Alpha  D03   3.47000         0 1 : Experiment 1 20000 HCMEC D3
      3583  170 Alpha  E01   3.61000         0 1 : Experiment 1 15000 HCMEC D3
      3584  170 Alpha  E02   3.66000         0 1 : Experiment 1 15000 HCMEC D3
      3585  170 Alpha  E03   3.62000         0 1 : Experiment 1 15000 HCMEC D3
      3586  170 Alpha  F01   3.87000         0 1 : Experiment 1 10000 HCMEC D3
      3587  170 Alpha  F02   3.96000         0 1 : Experiment 1 10000 HCMEC D3
      3588  170 Alpha  F03   3.82000         0 1 : Experiment 1 10000 HCMEC D3
      3589  170 Alpha  G01   4.95000         0 1 : Experiment 1  5000 HCMEC D3
      3590  170 Alpha  G02   4.98000         0 1 : Experiment 1  5000 HCMEC D3
      3591  170 Alpha  G03   4.81000         0 1 : Experiment 1  5000 HCMEC D3
      3592  170    Cm  A01   1.33000         0 1 : Experiment 1 35000 HCMEC D3
      3593  170    Cm  A02   1.18000         0 1 : Experiment 1 35000 HCMEC D3
      3594  170    Cm  A03   1.28000         0 1 : Experiment 1 35000 HCMEC D3
      3595  170    Cm  B01   1.10000         0 1 : Experiment 1 30000 HCMEC D3
      3596  170    Cm  B02   1.06000         0 1 : Experiment 1 30000 HCMEC D3
      3597  170    Cm  B03   1.11000         0 1 : Experiment 1 30000 HCMEC D3
      3598  170    Cm  C01   1.08000         0 1 : Experiment 1 25000 HCMEC D3
      3599  170    Cm  C02   1.02000         0 1 : Experiment 1 25000 HCMEC D3
      3600  170    Cm  C03   1.08000         0 1 : Experiment 1 25000 HCMEC D3
      3601  170    Cm  D01   0.93000         0 1 : Experiment 1 20000 HCMEC D3
      3602  170    Cm  D02   1.06000         0 1 : Experiment 1 20000 HCMEC D3
      3603  170    Cm  D03   1.07000         0 1 : Experiment 1 20000 HCMEC D3
      3604  170    Cm  E01   1.06000         0 1 : Experiment 1 15000 HCMEC D3
      3605  170    Cm  E02   1.04000         0 1 : Experiment 1 15000 HCMEC D3
      3606  170    Cm  E03   1.07000         0 1 : Experiment 1 15000 HCMEC D3
      3607  170    Cm  F01   1.09000         0 1 : Experiment 1 10000 HCMEC D3
      3608  170    Cm  F02   1.03000         0 1 : Experiment 1 10000 HCMEC D3
      3609  170    Cm  F03   1.06000         0 1 : Experiment 1 10000 HCMEC D3
      3610  170    Cm  G01   1.43000         0 1 : Experiment 1  5000 HCMEC D3
      3611  170    Cm  G02   1.25000         0 1 : Experiment 1  5000 HCMEC D3
      3612  170    Cm  G03   1.25000         0 1 : Experiment 1  5000 HCMEC D3
      3613  170 Drift  A01  -3.61000         0 1 : Experiment 1 35000 HCMEC D3
      3614  170 Drift  A02  -4.02000         0 1 : Experiment 1 35000 HCMEC D3
      3615  170 Drift  A03  -3.30000         0 1 : Experiment 1 35000 HCMEC D3
      3616  170 Drift  B01  -4.39000         0 1 : Experiment 1 30000 HCMEC D3
      3617  170 Drift  B02  -4.66000         0 1 : Experiment 1 30000 HCMEC D3
      3618  170 Drift  B03  -4.11000         0 1 : Experiment 1 30000 HCMEC D3
      3619  170 Drift  C01  -4.75000         0 1 : Experiment 1 25000 HCMEC D3
      3620  170 Drift  C02  -5.09000         0 1 : Experiment 1 25000 HCMEC D3
      3621  170 Drift  C03  -4.49000         0 1 : Experiment 1 25000 HCMEC D3
      3622  170 Drift  D01  -5.51000         0 1 : Experiment 1 20000 HCMEC D3
      3623  170 Drift  D02  -4.84000         0 1 : Experiment 1 20000 HCMEC D3
      3624  170 Drift  D03  -4.13000         0 1 : Experiment 1 20000 HCMEC D3
      3625  170 Drift  E01  -3.57000         0 1 : Experiment 1 15000 HCMEC D3
      3626  170 Drift  E02  -4.00000         0 1 : Experiment 1 15000 HCMEC D3
      3627  170 Drift  E03  -3.63000         0 1 : Experiment 1 15000 HCMEC D3
      3628  170 Drift  F01  -3.60000         0 1 : Experiment 1 10000 HCMEC D3
      3629  170 Drift  F02  -3.82000         0 1 : Experiment 1 10000 HCMEC D3
      3630  170 Drift  F03  -3.23000         0 1 : Experiment 1 10000 HCMEC D3
      3631  170 Drift  G01  -2.85000         0 1 : Experiment 1  5000 HCMEC D3
      3632  170 Drift  G02  -3.12000         0 1 : Experiment 1  5000 HCMEC D3
      3633  170 Drift  G03  -2.43000         0 1 : Experiment 1  5000 HCMEC D3
      3634  170    Rb  A01   0.97000         0 1 : Experiment 1 35000 HCMEC D3
      3635  170    Rb  A02   1.05000         0 1 : Experiment 1 35000 HCMEC D3
      3636  170    Rb  A03   0.99000         0 1 : Experiment 1 35000 HCMEC D3
      3637  170    Rb  B01   1.22000         0 1 : Experiment 1 30000 HCMEC D3
      3638  170    Rb  B02   1.24000         0 1 : Experiment 1 30000 HCMEC D3
      3639  170    Rb  B03   1.16000         0 1 : Experiment 1 30000 HCMEC D3
      3640  170    Rb  C01   1.17000         0 1 : Experiment 1 25000 HCMEC D3
      3641  170    Rb  C02   1.24000         0 1 : Experiment 1 25000 HCMEC D3
      3642  170    Rb  C03   1.19000         0 1 : Experiment 1 25000 HCMEC D3
      3643  170    Rb  D01   2.54000         0 1 : Experiment 1 20000 HCMEC D3
      3644  170    Rb  D02   1.24000         0 1 : Experiment 1 20000 HCMEC D3
      3645  170    Rb  D03   1.24000         0 1 : Experiment 1 20000 HCMEC D3
      3646  170    Rb  E01   1.50000         0 1 : Experiment 1 15000 HCMEC D3
      3647  170    Rb  E02   1.39000         0 1 : Experiment 1 15000 HCMEC D3
      3648  170    Rb  E03   1.45000         0 1 : Experiment 1 15000 HCMEC D3
      3649  170    Rb  F01   1.42000         0 1 : Experiment 1 10000 HCMEC D3
      3650  170    Rb  F02   1.52000         0 1 : Experiment 1 10000 HCMEC D3
      3651  170    Rb  F03   1.59000         0 1 : Experiment 1 10000 HCMEC D3
      3652  170    Rb  G01   0.48000         0 1 : Experiment 1  5000 HCMEC D3
      3653  170    Rb  G02   0.74000         0 1 : Experiment 1  5000 HCMEC D3
      3654  170    Rb  G03   0.60000         0 1 : Experiment 1  5000 HCMEC D3
      3655  170  RMSE  A01   0.01000         0 1 : Experiment 1 35000 HCMEC D3
      3656  170  RMSE  A02   0.01000         0 1 : Experiment 1 35000 HCMEC D3
      3657  170  RMSE  A03   0.01000         0 1 : Experiment 1 35000 HCMEC D3
      3658  170  RMSE  B01   0.01000         0 1 : Experiment 1 30000 HCMEC D3
      3659  170  RMSE  B02   0.01000         0 1 : Experiment 1 30000 HCMEC D3
      3660  170  RMSE  B03   0.01000         0 1 : Experiment 1 30000 HCMEC D3
      3661  170  RMSE  C01   0.01000         0 1 : Experiment 1 25000 HCMEC D3
      3662  170  RMSE  C02   0.01000         0 1 : Experiment 1 25000 HCMEC D3
      3663  170  RMSE  C03   0.01000         0 1 : Experiment 1 25000 HCMEC D3
      3664  170  RMSE  D01   0.01000         0 1 : Experiment 1 20000 HCMEC D3
      3665  170  RMSE  D02   0.01000         0 1 : Experiment 1 20000 HCMEC D3
      3666  170  RMSE  D03   0.01000         0 1 : Experiment 1 20000 HCMEC D3
      3667  170  RMSE  E01   0.01000         0 1 : Experiment 1 15000 HCMEC D3
      3668  170  RMSE  E02   0.01000         0 1 : Experiment 1 15000 HCMEC D3
      3669  170  RMSE  E03   0.01000         0 1 : Experiment 1 15000 HCMEC D3
      3670  170  RMSE  F01   0.01000         0 1 : Experiment 1 10000 HCMEC D3
      3671  170  RMSE  F02   0.01000         0 1 : Experiment 1 10000 HCMEC D3
      3672  170  RMSE  F03   0.01000         0 1 : Experiment 1 10000 HCMEC D3
      3673  170  RMSE  G01   0.01000         0 1 : Experiment 1  5000 HCMEC D3
      3674  170  RMSE  G02   0.01000         0 1 : Experiment 1  5000 HCMEC D3
      3675  170  RMSE  G03   0.01000         0 1 : Experiment 1  5000 HCMEC D3
      3676  175 Alpha  A01   2.92000         0 1 : Experiment 1 35000 HCMEC D3
      3677  175 Alpha  A02   3.02000         0 1 : Experiment 1 35000 HCMEC D3
      3678  175 Alpha  A03   2.90000         0 1 : Experiment 1 35000 HCMEC D3
      3679  175 Alpha  B01   3.15000         0 1 : Experiment 1 30000 HCMEC D3
      3680  175 Alpha  B02   3.26000         0 1 : Experiment 1 30000 HCMEC D3
      3681  175 Alpha  B03   3.19000         0 1 : Experiment 1 30000 HCMEC D3
      3682  175 Alpha  C01   3.28000         0 1 : Experiment 1 25000 HCMEC D3
      3683  175 Alpha  C02   3.28000         0 1 : Experiment 1 25000 HCMEC D3
      3684  175 Alpha  C03   3.41000         0 1 : Experiment 1 25000 HCMEC D3
      3685  175 Alpha  D01   4.73000         0 1 : Experiment 1 20000 HCMEC D3
      3686  175 Alpha  D02   3.51000         0 1 : Experiment 1 20000 HCMEC D3
      3687  175 Alpha  D03   3.41000         0 1 : Experiment 1 20000 HCMEC D3
      3688  175 Alpha  E01   3.57000         0 1 : Experiment 1 15000 HCMEC D3
      3689  175 Alpha  E02   3.64000         0 1 : Experiment 1 15000 HCMEC D3
      3690  175 Alpha  E03   3.56000         0 1 : Experiment 1 15000 HCMEC D3
      3691  175 Alpha  F01   3.82000         0 1 : Experiment 1 10000 HCMEC D3
      3692  175 Alpha  F02   3.94000         0 1 : Experiment 1 10000 HCMEC D3
      3693  175 Alpha  F03   3.78000         0 1 : Experiment 1 10000 HCMEC D3
      3694  175 Alpha  G01   4.82000         0 1 : Experiment 1  5000 HCMEC D3
      3695  175 Alpha  G02   4.86000         0 1 : Experiment 1  5000 HCMEC D3
      3696  175 Alpha  G03   4.76000         0 1 : Experiment 1  5000 HCMEC D3
      3697  175    Cm  A01   1.36000         0 1 : Experiment 1 35000 HCMEC D3
      3698  175    Cm  A02   1.18000         0 1 : Experiment 1 35000 HCMEC D3
      3699  175    Cm  A03   1.29000         0 1 : Experiment 1 35000 HCMEC D3
      3700  175    Cm  B01   1.09000         0 1 : Experiment 1 30000 HCMEC D3
      3701  175    Cm  B02   1.08000         0 1 : Experiment 1 30000 HCMEC D3
      3702  175    Cm  B03   1.10000         0 1 : Experiment 1 30000 HCMEC D3
      3703  175    Cm  C01   1.08000         0 1 : Experiment 1 25000 HCMEC D3
      3704  175    Cm  C02   1.02000         0 1 : Experiment 1 25000 HCMEC D3
      3705  175    Cm  C03   1.07000         0 1 : Experiment 1 25000 HCMEC D3
      3706  175    Cm  D01   0.95000         0 1 : Experiment 1 20000 HCMEC D3
      3707  175    Cm  D02   1.03000         0 1 : Experiment 1 20000 HCMEC D3
      3708  175    Cm  D03   1.07000         0 1 : Experiment 1 20000 HCMEC D3
      3709  175    Cm  E01   1.06000         0 1 : Experiment 1 15000 HCMEC D3
      3710  175    Cm  E02   1.03000         0 1 : Experiment 1 15000 HCMEC D3
      3711  175    Cm  E03   1.07000         0 1 : Experiment 1 15000 HCMEC D3
      3712  175    Cm  F01   1.08000         0 1 : Experiment 1 10000 HCMEC D3
      3713  175    Cm  F02   1.05000         0 1 : Experiment 1 10000 HCMEC D3
      3714  175    Cm  F03   1.03000         0 1 : Experiment 1 10000 HCMEC D3
      3715  175    Cm  G01   1.37000         0 1 : Experiment 1  5000 HCMEC D3
      3716  175    Cm  G02   1.29000         0 1 : Experiment 1  5000 HCMEC D3
      3717  175    Cm  G03   1.17000         0 1 : Experiment 1  5000 HCMEC D3
      3718  175 Drift  A01  -3.36000         0 1 : Experiment 1 35000 HCMEC D3
      3719  175 Drift  A02  -3.81000         0 1 : Experiment 1 35000 HCMEC D3
      3720  175 Drift  A03  -3.05000         0 1 : Experiment 1 35000 HCMEC D3
      3721  175 Drift  B01  -4.17000         0 1 : Experiment 1 30000 HCMEC D3
      3722  175 Drift  B02  -4.44000         0 1 : Experiment 1 30000 HCMEC D3
      3723  175 Drift  B03  -3.89000         0 1 : Experiment 1 30000 HCMEC D3
      3724  175 Drift  C01  -4.54000         0 1 : Experiment 1 25000 HCMEC D3
      3725  175 Drift  C02  -4.88000         0 1 : Experiment 1 25000 HCMEC D3
      3726  175 Drift  C03  -4.28000         0 1 : Experiment 1 25000 HCMEC D3
      3727  175 Drift  D01  -5.27000         0 1 : Experiment 1 20000 HCMEC D3
      3728  175 Drift  D02  -4.63000         0 1 : Experiment 1 20000 HCMEC D3
      3729  175 Drift  D03  -3.92000         0 1 : Experiment 1 20000 HCMEC D3
      3730  175 Drift  E01  -3.36000         0 1 : Experiment 1 15000 HCMEC D3
      3731  175 Drift  E02  -3.83000         0 1 : Experiment 1 15000 HCMEC D3
      3732  175 Drift  E03  -3.43000         0 1 : Experiment 1 15000 HCMEC D3
      3733  175 Drift  F01  -3.41000         0 1 : Experiment 1 10000 HCMEC D3
      3734  175 Drift  F02  -3.68000         0 1 : Experiment 1 10000 HCMEC D3
      3735  175 Drift  F03  -3.03000         0 1 : Experiment 1 10000 HCMEC D3
      3736  175 Drift  G01  -2.65000         0 1 : Experiment 1  5000 HCMEC D3
      3737  175 Drift  G02  -2.88000         0 1 : Experiment 1  5000 HCMEC D3
      3738  175 Drift  G03  -2.24000         0 1 : Experiment 1  5000 HCMEC D3
      3739  175    Rb  A01   0.88000         0 1 : Experiment 1 35000 HCMEC D3
      3740  175    Rb  A02   0.99000         0 1 : Experiment 1 35000 HCMEC D3
      3741  175    Rb  A03   0.94000         0 1 : Experiment 1 35000 HCMEC D3
      3742  175    Rb  B01   1.16000         0 1 : Experiment 1 30000 HCMEC D3
      3743  175    Rb  B02   1.16000         0 1 : Experiment 1 30000 HCMEC D3
      3744  175    Rb  B03   1.09000         0 1 : Experiment 1 30000 HCMEC D3
      3745  175    Rb  C01   1.14000         0 1 : Experiment 1 25000 HCMEC D3
      3746  175    Rb  C02   1.17000         0 1 : Experiment 1 25000 HCMEC D3
      3747  175    Rb  C03   1.13000         0 1 : Experiment 1 25000 HCMEC D3
      3748  175    Rb  D01   2.62000         0 1 : Experiment 1 20000 HCMEC D3
      3749  175    Rb  D02   1.21000         0 1 : Experiment 1 20000 HCMEC D3
      3750  175    Rb  D03   1.18000         0 1 : Experiment 1 20000 HCMEC D3
      3751  175    Rb  E01   1.38000         0 1 : Experiment 1 15000 HCMEC D3
      3752  175    Rb  E02   1.33000         0 1 : Experiment 1 15000 HCMEC D3
      3753  175    Rb  E03   1.39000         0 1 : Experiment 1 15000 HCMEC D3
      3754  175    Rb  F01   1.33000         0 1 : Experiment 1 10000 HCMEC D3
      3755  175    Rb  F02   1.38000         0 1 : Experiment 1 10000 HCMEC D3
      3756  175    Rb  F03   1.57000         0 1 : Experiment 1 10000 HCMEC D3
      3757  175    Rb  G01   0.58000         0 1 : Experiment 1  5000 HCMEC D3
      3758  175    Rb  G02   0.71000         0 1 : Experiment 1  5000 HCMEC D3
      3759  175    Rb  G03   0.58000         0 1 : Experiment 1  5000 HCMEC D3
      3760  175  RMSE  A01   0.01000         0 1 : Experiment 1 35000 HCMEC D3
      3761  175  RMSE  A02   0.01000         0 1 : Experiment 1 35000 HCMEC D3
      3762  175  RMSE  A03   0.01000         0 1 : Experiment 1 35000 HCMEC D3
      3763  175  RMSE  B01   0.01000         0 1 : Experiment 1 30000 HCMEC D3
      3764  175  RMSE  B02   0.01000         0 1 : Experiment 1 30000 HCMEC D3
      3765  175  RMSE  B03   0.01000         0 1 : Experiment 1 30000 HCMEC D3
      3766  175  RMSE  C01   0.01000         0 1 : Experiment 1 25000 HCMEC D3
      3767  175  RMSE  C02   0.01000         0 1 : Experiment 1 25000 HCMEC D3
      3768  175  RMSE  C03   0.01000         0 1 : Experiment 1 25000 HCMEC D3
      3769  175  RMSE  D01   0.01000         0 1 : Experiment 1 20000 HCMEC D3
      3770  175  RMSE  D02   0.01000         0 1 : Experiment 1 20000 HCMEC D3
      3771  175  RMSE  D03   0.01000         0 1 : Experiment 1 20000 HCMEC D3
      3772  175  RMSE  E01   0.01000         0 1 : Experiment 1 15000 HCMEC D3
      3773  175  RMSE  E02   0.01000         0 1 : Experiment 1 15000 HCMEC D3
      3774  175  RMSE  E03   0.01000         0 1 : Experiment 1 15000 HCMEC D3
      3775  175  RMSE  F01   0.01000         0 1 : Experiment 1 10000 HCMEC D3
      3776  175  RMSE  F02   0.01000         0 1 : Experiment 1 10000 HCMEC D3
      3777  175  RMSE  F03   0.01000         0 1 : Experiment 1 10000 HCMEC D3
      3778  175  RMSE  G01   0.01000         0 1 : Experiment 1  5000 HCMEC D3
      3779  175  RMSE  G02   0.01000         0 1 : Experiment 1  5000 HCMEC D3
      3780  175  RMSE  G03   0.01000         0 1 : Experiment 1  5000 HCMEC D3
      3781  180 Alpha  A01   2.86000         0 1 : Experiment 1 35000 HCMEC D3
      3782  180 Alpha  A02   2.98000         0 1 : Experiment 1 35000 HCMEC D3
      3783  180 Alpha  A03   2.89000         0 1 : Experiment 1 35000 HCMEC D3
      3784  180 Alpha  B01   3.10000         0 1 : Experiment 1 30000 HCMEC D3
      3785  180 Alpha  B02   3.20000         0 1 : Experiment 1 30000 HCMEC D3
      3786  180 Alpha  B03   3.17000         0 1 : Experiment 1 30000 HCMEC D3
      3787  180 Alpha  C01   3.23000         0 1 : Experiment 1 25000 HCMEC D3
      3788  180 Alpha  C02   3.23000         0 1 : Experiment 1 25000 HCMEC D3
      3789  180 Alpha  C03   3.33000         0 1 : Experiment 1 25000 HCMEC D3
      3790  180 Alpha  D01   4.71000         0 1 : Experiment 1 20000 HCMEC D3
      3791  180 Alpha  D02   3.44000         0 1 : Experiment 1 20000 HCMEC D3
      3792  180 Alpha  D03   3.41000         0 1 : Experiment 1 20000 HCMEC D3
      3793  180 Alpha  E01   3.52000         0 1 : Experiment 1 15000 HCMEC D3
      3794  180 Alpha  E02   3.58000         0 1 : Experiment 1 15000 HCMEC D3
      3795  180 Alpha  E03   3.52000         0 1 : Experiment 1 15000 HCMEC D3
      3796  180 Alpha  F01   3.75000         0 1 : Experiment 1 10000 HCMEC D3
      3797  180 Alpha  F02   3.81000         0 1 : Experiment 1 10000 HCMEC D3
      3798  180 Alpha  F03   3.76000         0 1 : Experiment 1 10000 HCMEC D3
      3799  180 Alpha  G01   4.76000         0 1 : Experiment 1  5000 HCMEC D3
      3800  180 Alpha  G02   4.78000         0 1 : Experiment 1  5000 HCMEC D3
      3801  180 Alpha  G03   4.71000         0 1 : Experiment 1  5000 HCMEC D3
      3802  180    Cm  A01   1.38000         0 1 : Experiment 1 35000 HCMEC D3
      3803  180    Cm  A02   1.20000         0 1 : Experiment 1 35000 HCMEC D3
      3804  180    Cm  A03   1.31000         0 1 : Experiment 1 35000 HCMEC D3
      3805  180    Cm  B01   1.09000         0 1 : Experiment 1 30000 HCMEC D3
      3806  180    Cm  B02   1.06000         0 1 : Experiment 1 30000 HCMEC D3
      3807  180    Cm  B03   1.10000         0 1 : Experiment 1 30000 HCMEC D3
      3808  180    Cm  C01   1.09000         0 1 : Experiment 1 25000 HCMEC D3
      3809  180    Cm  C02   1.04000         0 1 : Experiment 1 25000 HCMEC D3
      3810  180    Cm  C03   1.06000         0 1 : Experiment 1 25000 HCMEC D3
      3811  180    Cm  D01   0.95000         0 1 : Experiment 1 20000 HCMEC D3
      3812  180    Cm  D02   1.04000         0 1 : Experiment 1 20000 HCMEC D3
      3813  180    Cm  D03   1.09000         0 1 : Experiment 1 20000 HCMEC D3
      3814  180    Cm  E01   1.06000         0 1 : Experiment 1 15000 HCMEC D3
      3815  180    Cm  E02   1.01000         0 1 : Experiment 1 15000 HCMEC D3
      3816  180    Cm  E03   1.07000         0 1 : Experiment 1 15000 HCMEC D3
      3817  180    Cm  F01   1.07000         0 1 : Experiment 1 10000 HCMEC D3
      3818  180    Cm  F02   1.03000         0 1 : Experiment 1 10000 HCMEC D3
      3819  180    Cm  F03   1.02000         0 1 : Experiment 1 10000 HCMEC D3
      3820  180    Cm  G01   1.39000         0 1 : Experiment 1  5000 HCMEC D3
      3821  180    Cm  G02   1.26000         0 1 : Experiment 1  5000 HCMEC D3
      3822  180    Cm  G03   1.20000         0 1 : Experiment 1  5000 HCMEC D3
      3823  180 Drift  A01  -3.13000         0 1 : Experiment 1 35000 HCMEC D3
      3824  180 Drift  A02  -3.58000         0 1 : Experiment 1 35000 HCMEC D3
      3825  180 Drift  A03  -2.81000         0 1 : Experiment 1 35000 HCMEC D3
      3826  180 Drift  B01  -3.95000         0 1 : Experiment 1 30000 HCMEC D3
      3827  180 Drift  B02  -4.22000         0 1 : Experiment 1 30000 HCMEC D3
      3828  180 Drift  B03  -3.67000         0 1 : Experiment 1 30000 HCMEC D3
      3829  180 Drift  C01  -4.33000         0 1 : Experiment 1 25000 HCMEC D3
      3830  180 Drift  C02  -4.65000         0 1 : Experiment 1 25000 HCMEC D3
      3831  180 Drift  C03  -4.06000         0 1 : Experiment 1 25000 HCMEC D3
      3832  180 Drift  D01  -5.03000         0 1 : Experiment 1 20000 HCMEC D3
      3833  180 Drift  D02  -4.43000         0 1 : Experiment 1 20000 HCMEC D3
      3834  180 Drift  D03  -3.71000         0 1 : Experiment 1 20000 HCMEC D3
      3835  180 Drift  E01  -3.16000         0 1 : Experiment 1 15000 HCMEC D3
      3836  180 Drift  E02  -3.62000         0 1 : Experiment 1 15000 HCMEC D3
      3837  180 Drift  E03  -3.21000         0 1 : Experiment 1 15000 HCMEC D3
      3838  180 Drift  F01  -3.20000         0 1 : Experiment 1 10000 HCMEC D3
      3839  180 Drift  F02  -3.49000         0 1 : Experiment 1 10000 HCMEC D3
      3840  180 Drift  F03  -2.82000         0 1 : Experiment 1 10000 HCMEC D3
      3841  180 Drift  G01  -2.46000         0 1 : Experiment 1  5000 HCMEC D3
      3842  180 Drift  G02  -2.67000         0 1 : Experiment 1  5000 HCMEC D3
      3843  180 Drift  G03  -2.02000         0 1 : Experiment 1  5000 HCMEC D3
      3844  180    Rb  A01   0.81000         0 1 : Experiment 1 35000 HCMEC D3
      3845  180    Rb  A02   0.94000         0 1 : Experiment 1 35000 HCMEC D3
      3846  180    Rb  A03   0.87000         0 1 : Experiment 1 35000 HCMEC D3
      3847  180    Rb  B01   1.12000         0 1 : Experiment 1 30000 HCMEC D3
      3848  180    Rb  B02   1.14000         0 1 : Experiment 1 30000 HCMEC D3
      3849  180    Rb  B03   1.01000         0 1 : Experiment 1 30000 HCMEC D3
      3850  180    Rb  C01   1.05000         0 1 : Experiment 1 25000 HCMEC D3
      3851  180    Rb  C02   1.07000         0 1 : Experiment 1 25000 HCMEC D3
      3852  180    Rb  C03   1.06000         0 1 : Experiment 1 25000 HCMEC D3
      3853  180    Rb  D01   2.28000         0 1 : Experiment 1 20000 HCMEC D3
      3854  180    Rb  D02   1.15000         0 1 : Experiment 1 20000 HCMEC D3
      3855  180    Rb  D03   1.05000         0 1 : Experiment 1 20000 HCMEC D3
      3856  180    Rb  E01   1.34000         0 1 : Experiment 1 15000 HCMEC D3
      3857  180    Rb  E02   1.29000         0 1 : Experiment 1 15000 HCMEC D3
      3858  180    Rb  E03   1.32000         0 1 : Experiment 1 15000 HCMEC D3
      3859  180    Rb  F01   1.28000         0 1 : Experiment 1 10000 HCMEC D3
      3860  180    Rb  F02   1.36000         0 1 : Experiment 1 10000 HCMEC D3
      3861  180    Rb  F03   1.48000         0 1 : Experiment 1 10000 HCMEC D3
      3862  180    Rb  G01   0.65000         0 1 : Experiment 1  5000 HCMEC D3
      3863  180    Rb  G02   0.78000         0 1 : Experiment 1  5000 HCMEC D3
      3864  180    Rb  G03   0.62000         0 1 : Experiment 1  5000 HCMEC D3
      3865  180  RMSE  A01   0.01000         0 1 : Experiment 1 35000 HCMEC D3
      3866  180  RMSE  A02   0.01000         0 1 : Experiment 1 35000 HCMEC D3
      3867  180  RMSE  A03   0.01000         0 1 : Experiment 1 35000 HCMEC D3
      3868  180  RMSE  B01   0.01000         0 1 : Experiment 1 30000 HCMEC D3
      3869  180  RMSE  B02   0.01000         0 1 : Experiment 1 30000 HCMEC D3
      3870  180  RMSE  B03   0.01000         0 1 : Experiment 1 30000 HCMEC D3
      3871  180  RMSE  C01   0.01000         0 1 : Experiment 1 25000 HCMEC D3
      3872  180  RMSE  C02   0.01000         0 1 : Experiment 1 25000 HCMEC D3
      3873  180  RMSE  C03   0.01000         0 1 : Experiment 1 25000 HCMEC D3
      3874  180  RMSE  D01   0.01000         0 1 : Experiment 1 20000 HCMEC D3
      3875  180  RMSE  D02   0.01000         0 1 : Experiment 1 20000 HCMEC D3
      3876  180  RMSE  D03   0.01000         0 1 : Experiment 1 20000 HCMEC D3
      3877  180  RMSE  E01   0.01000         0 1 : Experiment 1 15000 HCMEC D3
      3878  180  RMSE  E02   0.01000         0 1 : Experiment 1 15000 HCMEC D3
      3879  180  RMSE  E03   0.01000         0 1 : Experiment 1 15000 HCMEC D3
      3880  180  RMSE  F01   0.01000         0 1 : Experiment 1 10000 HCMEC D3
      3881  180  RMSE  F02   0.01000         0 1 : Experiment 1 10000 HCMEC D3
      3882  180  RMSE  F03   0.01000         0 1 : Experiment 1 10000 HCMEC D3
      3883  180  RMSE  G01   0.01000         0 1 : Experiment 1  5000 HCMEC D3
      3884  180  RMSE  G02   0.01000         0 1 : Experiment 1  5000 HCMEC D3
      3885  180  RMSE  G03   0.01000         0 1 : Experiment 1  5000 HCMEC D3
      3886  185 Alpha  A01   2.80000         0 1 : Experiment 1 35000 HCMEC D3
      3887  185 Alpha  A02   2.92000         0 1 : Experiment 1 35000 HCMEC D3
      3888  185 Alpha  A03   2.84000         0 1 : Experiment 1 35000 HCMEC D3
      3889  185 Alpha  B01   3.11000         0 1 : Experiment 1 30000 HCMEC D3
      3890  185 Alpha  B02   3.19000         0 1 : Experiment 1 30000 HCMEC D3
      3891  185 Alpha  B03   3.12000         0 1 : Experiment 1 30000 HCMEC D3
      3892  185 Alpha  C01   3.21000         0 1 : Experiment 1 25000 HCMEC D3
      3893  185 Alpha  C02   3.16000         0 1 : Experiment 1 25000 HCMEC D3
      3894  185 Alpha  C03   3.30000         0 1 : Experiment 1 25000 HCMEC D3
      3895  185 Alpha  D01   4.65000         0 1 : Experiment 1 20000 HCMEC D3
      3896  185 Alpha  D02   3.39000         0 1 : Experiment 1 20000 HCMEC D3
      3897  185 Alpha  D03   3.36000         0 1 : Experiment 1 20000 HCMEC D3
      3898  185 Alpha  E01   3.50000         0 1 : Experiment 1 15000 HCMEC D3
      3899  185 Alpha  E02   3.54000         0 1 : Experiment 1 15000 HCMEC D3
      3900  185 Alpha  E03   3.50000         0 1 : Experiment 1 15000 HCMEC D3
      3901  185 Alpha  F01   3.73000         0 1 : Experiment 1 10000 HCMEC D3
      3902  185 Alpha  F02   3.78000         0 1 : Experiment 1 10000 HCMEC D3
      3903  185 Alpha  F03   3.74000         0 1 : Experiment 1 10000 HCMEC D3
      3904  185 Alpha  G01   4.65000         0 1 : Experiment 1  5000 HCMEC D3
      3905  185 Alpha  G02   4.69000         0 1 : Experiment 1  5000 HCMEC D3
      3906  185 Alpha  G03   4.70000         0 1 : Experiment 1  5000 HCMEC D3
      3907  185    Cm  A01   1.39000         0 1 : Experiment 1 35000 HCMEC D3
      3908  185    Cm  A02   1.20000         0 1 : Experiment 1 35000 HCMEC D3
      3909  185    Cm  A03   1.33000         0 1 : Experiment 1 35000 HCMEC D3
      3910  185    Cm  B01   1.10000         0 1 : Experiment 1 30000 HCMEC D3
      3911  185    Cm  B02   1.06000         0 1 : Experiment 1 30000 HCMEC D3
      3912  185    Cm  B03   1.12000         0 1 : Experiment 1 30000 HCMEC D3
      3913  185    Cm  C01   1.08000         0 1 : Experiment 1 25000 HCMEC D3
      3914  185    Cm  C02   1.04000         0 1 : Experiment 1 25000 HCMEC D3
      3915  185    Cm  C03   1.08000         0 1 : Experiment 1 25000 HCMEC D3
      3916  185    Cm  D01   0.93000         0 1 : Experiment 1 20000 HCMEC D3
      3917  185    Cm  D02   1.05000         0 1 : Experiment 1 20000 HCMEC D3
      3918  185    Cm  D03   1.08000         0 1 : Experiment 1 20000 HCMEC D3
      3919  185    Cm  E01   1.06000         0 1 : Experiment 1 15000 HCMEC D3
      3920  185    Cm  E02   1.00000         0 1 : Experiment 1 15000 HCMEC D3
      3921  185    Cm  E03   1.07000         0 1 : Experiment 1 15000 HCMEC D3
      3922  185    Cm  F01   1.06000         0 1 : Experiment 1 10000 HCMEC D3
      3923  185    Cm  F02   1.04000         0 1 : Experiment 1 10000 HCMEC D3
      3924  185    Cm  F03   1.04000         0 1 : Experiment 1 10000 HCMEC D3
      3925  185    Cm  G01   1.37000         0 1 : Experiment 1  5000 HCMEC D3
      3926  185    Cm  G02   1.20000         0 1 : Experiment 1  5000 HCMEC D3
      3927  185    Cm  G03   1.18000         0 1 : Experiment 1  5000 HCMEC D3
      3928  185 Drift  A01  -2.88000         0 1 : Experiment 1 35000 HCMEC D3
      3929  185 Drift  A02  -3.34000         0 1 : Experiment 1 35000 HCMEC D3
      3930  185 Drift  A03  -2.56000         0 1 : Experiment 1 35000 HCMEC D3
      3931  185 Drift  B01  -3.72000         0 1 : Experiment 1 30000 HCMEC D3
      3932  185 Drift  B02  -3.99000         0 1 : Experiment 1 30000 HCMEC D3
      3933  185 Drift  B03  -3.43000         0 1 : Experiment 1 30000 HCMEC D3
      3934  185 Drift  C01  -4.09000         0 1 : Experiment 1 25000 HCMEC D3
      3935  185 Drift  C02  -4.43000         0 1 : Experiment 1 25000 HCMEC D3
      3936  185 Drift  C03  -3.83000         0 1 : Experiment 1 25000 HCMEC D3
      3937  185 Drift  D01  -4.82000         0 1 : Experiment 1 20000 HCMEC D3
      3938  185 Drift  D02  -4.20000         0 1 : Experiment 1 20000 HCMEC D3
      3939  185 Drift  D03  -3.48000         0 1 : Experiment 1 20000 HCMEC D3
      3940  185 Drift  E01  -2.93000         0 1 : Experiment 1 15000 HCMEC D3
      3941  185 Drift  E02  -3.41000         0 1 : Experiment 1 15000 HCMEC D3
      3942  185 Drift  E03  -2.99000         0 1 : Experiment 1 15000 HCMEC D3
      3943  185 Drift  F01  -2.98000         0 1 : Experiment 1 10000 HCMEC D3
      3944  185 Drift  F02  -3.31000         0 1 : Experiment 1 10000 HCMEC D3
      3945  185 Drift  F03  -2.61000         0 1 : Experiment 1 10000 HCMEC D3
      3946  185 Drift  G01  -2.23000         0 1 : Experiment 1  5000 HCMEC D3
      3947  185 Drift  G02  -2.47000         0 1 : Experiment 1  5000 HCMEC D3
      3948  185 Drift  G03  -1.83000         0 1 : Experiment 1  5000 HCMEC D3
      3949  185    Rb  A01   0.77000         0 1 : Experiment 1 35000 HCMEC D3
      3950  185    Rb  A02   0.90000         0 1 : Experiment 1 35000 HCMEC D3
      3951  185    Rb  A03   0.80000         0 1 : Experiment 1 35000 HCMEC D3
      3952  185    Rb  B01   1.04000         0 1 : Experiment 1 30000 HCMEC D3
      3953  185    Rb  B02   1.04000         0 1 : Experiment 1 30000 HCMEC D3
      3954  185    Rb  B03   0.96000         0 1 : Experiment 1 30000 HCMEC D3
      3955  185    Rb  C01   0.98000         0 1 : Experiment 1 25000 HCMEC D3
      3956  185    Rb  C02   1.05000         0 1 : Experiment 1 25000 HCMEC D3
      3957  185    Rb  C03   0.98000         0 1 : Experiment 1 25000 HCMEC D3
      3958  185    Rb  D01   1.99000         0 1 : Experiment 1 20000 HCMEC D3
      3959  185    Rb  D02   1.05000         0 1 : Experiment 1 20000 HCMEC D3
      3960  185    Rb  D03   1.02000         0 1 : Experiment 1 20000 HCMEC D3
      3961  185    Rb  E01   1.27000         0 1 : Experiment 1 15000 HCMEC D3
      3962  185    Rb  E02   1.22000         0 1 : Experiment 1 15000 HCMEC D3
      3963  185    Rb  E03   1.23000         0 1 : Experiment 1 15000 HCMEC D3
      3964  185    Rb  F01   1.24000         0 1 : Experiment 1 10000 HCMEC D3
      3965  185    Rb  F02   1.26000         0 1 : Experiment 1 10000 HCMEC D3
      3966  185    Rb  F03   1.37000         0 1 : Experiment 1 10000 HCMEC D3
      3967  185    Rb  G01   0.66000         0 1 : Experiment 1  5000 HCMEC D3
      3968  185    Rb  G02   0.93000         0 1 : Experiment 1  5000 HCMEC D3
      3969  185    Rb  G03   0.58000         0 1 : Experiment 1  5000 HCMEC D3
      3970  185  RMSE  A01   0.01000         0 1 : Experiment 1 35000 HCMEC D3
      3971  185  RMSE  A02   0.01000         0 1 : Experiment 1 35000 HCMEC D3
      3972  185  RMSE  A03   0.01000         0 1 : Experiment 1 35000 HCMEC D3
      3973  185  RMSE  B01   0.01000         0 1 : Experiment 1 30000 HCMEC D3
      3974  185  RMSE  B02   0.01000         0 1 : Experiment 1 30000 HCMEC D3
      3975  185  RMSE  B03   0.01000         0 1 : Experiment 1 30000 HCMEC D3
      3976  185  RMSE  C01   0.01000         0 1 : Experiment 1 25000 HCMEC D3
      3977  185  RMSE  C02   0.01000         0 1 : Experiment 1 25000 HCMEC D3
      3978  185  RMSE  C03   0.01000         0 1 : Experiment 1 25000 HCMEC D3
      3979  185  RMSE  D01   0.01000         0 1 : Experiment 1 20000 HCMEC D3
      3980  185  RMSE  D02   0.01000         0 1 : Experiment 1 20000 HCMEC D3
      3981  185  RMSE  D03   0.01000         0 1 : Experiment 1 20000 HCMEC D3
      3982  185  RMSE  E01   0.01000         0 1 : Experiment 1 15000 HCMEC D3
      3983  185  RMSE  E02   0.01000         0 1 : Experiment 1 15000 HCMEC D3
      3984  185  RMSE  E03   0.01000         0 1 : Experiment 1 15000 HCMEC D3
      3985  185  RMSE  F01   0.01000         0 1 : Experiment 1 10000 HCMEC D3
      3986  185  RMSE  F02   0.01000         0 1 : Experiment 1 10000 HCMEC D3
      3987  185  RMSE  F03   0.01000         0 1 : Experiment 1 10000 HCMEC D3
      3988  185  RMSE  G01   0.01000         0 1 : Experiment 1  5000 HCMEC D3
      3989  185  RMSE  G02   0.01000         0 1 : Experiment 1  5000 HCMEC D3
      3990  185  RMSE  G03   0.01000         0 1 : Experiment 1  5000 HCMEC D3
      3991  190 Alpha  A01   2.77000         0 1 : Experiment 1 35000 HCMEC D3
      3992  190 Alpha  A02   2.90000         0 1 : Experiment 1 35000 HCMEC D3
      3993  190 Alpha  A03   2.79000         0 1 : Experiment 1 35000 HCMEC D3
      3994  190 Alpha  B01   3.11000         0 1 : Experiment 1 30000 HCMEC D3
      3995  190 Alpha  B02   3.17000         0 1 : Experiment 1 30000 HCMEC D3
      3996  190 Alpha  B03   3.11000         0 1 : Experiment 1 30000 HCMEC D3
      3997  190 Alpha  C01   3.17000         0 1 : Experiment 1 25000 HCMEC D3
      3998  190 Alpha  C02   3.14000         0 1 : Experiment 1 25000 HCMEC D3
      3999  190 Alpha  C03   3.26000         0 1 : Experiment 1 25000 HCMEC D3
      4000  190 Alpha  D01   4.58000         0 1 : Experiment 1 20000 HCMEC D3
      4001  190 Alpha  D02   3.36000         0 1 : Experiment 1 20000 HCMEC D3
      4002  190 Alpha  D03   3.31000         0 1 : Experiment 1 20000 HCMEC D3
      4003  190 Alpha  E01   3.46000         0 1 : Experiment 1 15000 HCMEC D3
      4004  190 Alpha  E02   3.51000         0 1 : Experiment 1 15000 HCMEC D3
      4005  190 Alpha  E03   3.46000         0 1 : Experiment 1 15000 HCMEC D3
      4006  190 Alpha  F01   3.70000         0 1 : Experiment 1 10000 HCMEC D3
      4007  190 Alpha  F02   3.72000         0 1 : Experiment 1 10000 HCMEC D3
      4008  190 Alpha  F03   3.70000         0 1 : Experiment 1 10000 HCMEC D3
      4009  190 Alpha  G01   4.52000         0 1 : Experiment 1  5000 HCMEC D3
      4010  190 Alpha  G02   4.63000         0 1 : Experiment 1  5000 HCMEC D3
      4011  190 Alpha  G03   4.55000         0 1 : Experiment 1  5000 HCMEC D3
      4012  190    Cm  A01   1.43000         0 1 : Experiment 1 35000 HCMEC D3
      4013  190    Cm  A02   1.21000         0 1 : Experiment 1 35000 HCMEC D3
      4014  190    Cm  A03   1.34000         0 1 : Experiment 1 35000 HCMEC D3
      4015  190    Cm  B01   1.09000         0 1 : Experiment 1 30000 HCMEC D3
      4016  190    Cm  B02   1.06000         0 1 : Experiment 1 30000 HCMEC D3
      4017  190    Cm  B03   1.09000         0 1 : Experiment 1 30000 HCMEC D3
      4018  190    Cm  C01   1.07000         0 1 : Experiment 1 25000 HCMEC D3
      4019  190    Cm  C02   1.02000         0 1 : Experiment 1 25000 HCMEC D3
      4020  190    Cm  C03   1.06000         0 1 : Experiment 1 25000 HCMEC D3
      4021  190    Cm  D01   0.92000         0 1 : Experiment 1 20000 HCMEC D3
      4022  190    Cm  D02   1.03000         0 1 : Experiment 1 20000 HCMEC D3
      4023  190    Cm  D03   1.09000         0 1 : Experiment 1 20000 HCMEC D3
      4024  190    Cm  E01   1.07000         0 1 : Experiment 1 15000 HCMEC D3
      4025  190    Cm  E02   1.02000         0 1 : Experiment 1 15000 HCMEC D3
      4026  190    Cm  E03   1.06000         0 1 : Experiment 1 15000 HCMEC D3
      4027  190    Cm  F01   1.06000         0 1 : Experiment 1 10000 HCMEC D3
      4028  190    Cm  F02   1.02000         0 1 : Experiment 1 10000 HCMEC D3
      4029  190    Cm  F03   1.04000         0 1 : Experiment 1 10000 HCMEC D3
      4030  190    Cm  G01   1.35000         0 1 : Experiment 1  5000 HCMEC D3
      4031  190    Cm  G02   1.17000         0 1 : Experiment 1  5000 HCMEC D3
      4032  190    Cm  G03   1.17000         0 1 : Experiment 1  5000 HCMEC D3
      4033  190 Drift  A01  -2.62000         0 1 : Experiment 1 35000 HCMEC D3
      4034  190 Drift  A02  -3.08000         0 1 : Experiment 1 35000 HCMEC D3
      4035  190 Drift  A03  -2.28000         0 1 : Experiment 1 35000 HCMEC D3
      4036  190 Drift  B01  -3.47000         0 1 : Experiment 1 30000 HCMEC D3
      4037  190 Drift  B02  -3.74000         0 1 : Experiment 1 30000 HCMEC D3
      4038  190 Drift  B03  -3.16000         0 1 : Experiment 1 30000 HCMEC D3
      4039  190 Drift  C01  -3.84000         0 1 : Experiment 1 25000 HCMEC D3
      4040  190 Drift  C02  -4.18000         0 1 : Experiment 1 25000 HCMEC D3
      4041  190 Drift  C03  -3.57000         0 1 : Experiment 1 25000 HCMEC D3
      4042  190 Drift  D01  -4.53000         0 1 : Experiment 1 20000 HCMEC D3
      4043  190 Drift  D02  -3.94000         0 1 : Experiment 1 20000 HCMEC D3
      4044  190 Drift  D03  -3.23000         0 1 : Experiment 1 20000 HCMEC D3
      4045  190 Drift  E01  -2.69000         0 1 : Experiment 1 15000 HCMEC D3
      4046  190 Drift  E02  -3.16000         0 1 : Experiment 1 15000 HCMEC D3
      4047  190 Drift  E03  -2.73000         0 1 : Experiment 1 15000 HCMEC D3
      4048  190 Drift  F01  -2.74000         0 1 : Experiment 1 10000 HCMEC D3
      4049  190 Drift  F02  -3.11000         0 1 : Experiment 1 10000 HCMEC D3
      4050  190 Drift  F03  -2.35000         0 1 : Experiment 1 10000 HCMEC D3
      4051  190 Drift  G01  -1.98000         0 1 : Experiment 1  5000 HCMEC D3
      4052  190 Drift  G02  -2.22000         0 1 : Experiment 1  5000 HCMEC D3
      4053  190 Drift  G03  -1.53000         0 1 : Experiment 1  5000 HCMEC D3
      4054  190    Rb  A01   0.68000         0 1 : Experiment 1 35000 HCMEC D3
      4055  190    Rb  A02   0.85000         0 1 : Experiment 1 35000 HCMEC D3
      4056  190    Rb  A03   0.75000         0 1 : Experiment 1 35000 HCMEC D3
      4057  190    Rb  B01   0.97000         0 1 : Experiment 1 30000 HCMEC D3
      4058  190    Rb  B02   1.00000         0 1 : Experiment 1 30000 HCMEC D3
      4059  190    Rb  B03   0.92000         0 1 : Experiment 1 30000 HCMEC D3
      4060  190    Rb  C01   0.94000         0 1 : Experiment 1 25000 HCMEC D3
      4061  190    Rb  C02   0.99000         0 1 : Experiment 1 25000 HCMEC D3
      4062  190    Rb  C03   0.96000         0 1 : Experiment 1 25000 HCMEC D3
      4063  190    Rb  D01   1.55000         0 1 : Experiment 1 20000 HCMEC D3
      4064  190    Rb  D02   1.00000         0 1 : Experiment 1 20000 HCMEC D3
      4065  190    Rb  D03   0.96000         0 1 : Experiment 1 20000 HCMEC D3
      4066  190    Rb  E01   1.18000         0 1 : Experiment 1 15000 HCMEC D3
      4067  190    Rb  E02   1.15000         0 1 : Experiment 1 15000 HCMEC D3
      4068  190    Rb  E03   1.18000         0 1 : Experiment 1 15000 HCMEC D3
      4069  190    Rb  F01   1.20000         0 1 : Experiment 1 10000 HCMEC D3
      4070  190    Rb  F02   1.25000         0 1 : Experiment 1 10000 HCMEC D3
      4071  190    Rb  F03   1.29000         0 1 : Experiment 1 10000 HCMEC D3
      4072  190    Rb  G01   0.78000         0 1 : Experiment 1  5000 HCMEC D3
      4073  190    Rb  G02   0.96000         0 1 : Experiment 1  5000 HCMEC D3
      4074  190    Rb  G03   0.65000         0 1 : Experiment 1  5000 HCMEC D3
      4075  190  RMSE  A01   0.01000         0 1 : Experiment 1 35000 HCMEC D3
      4076  190  RMSE  A02   0.01000         0 1 : Experiment 1 35000 HCMEC D3
      4077  190  RMSE  A03   0.01000         0 1 : Experiment 1 35000 HCMEC D3
      4078  190  RMSE  B01   0.01000         0 1 : Experiment 1 30000 HCMEC D3
      4079  190  RMSE  B02   0.01000         0 1 : Experiment 1 30000 HCMEC D3
      4080  190  RMSE  B03   0.01000         0 1 : Experiment 1 30000 HCMEC D3
      4081  190  RMSE  C01   0.01000         0 1 : Experiment 1 25000 HCMEC D3
      4082  190  RMSE  C02   0.01000         0 1 : Experiment 1 25000 HCMEC D3
      4083  190  RMSE  C03   0.01000         0 1 : Experiment 1 25000 HCMEC D3
      4084  190  RMSE  D01   0.01000         0 1 : Experiment 1 20000 HCMEC D3
      4085  190  RMSE  D02   0.01000         0 1 : Experiment 1 20000 HCMEC D3
      4086  190  RMSE  D03   0.01000         0 1 : Experiment 1 20000 HCMEC D3
      4087  190  RMSE  E01   0.01000         0 1 : Experiment 1 15000 HCMEC D3
      4088  190  RMSE  E02   0.01000         0 1 : Experiment 1 15000 HCMEC D3
      4089  190  RMSE  E03   0.01000         0 1 : Experiment 1 15000 HCMEC D3
      4090  190  RMSE  F01   0.01000         0 1 : Experiment 1 10000 HCMEC D3
      4091  190  RMSE  F02   0.01000         0 1 : Experiment 1 10000 HCMEC D3
      4092  190  RMSE  F03   0.01000         0 1 : Experiment 1 10000 HCMEC D3
      4093  190  RMSE  G01   0.01000         0 1 : Experiment 1  5000 HCMEC D3
      4094  190  RMSE  G02   0.01000         0 1 : Experiment 1  5000 HCMEC D3
      4095  190  RMSE  G03   0.01000         0 1 : Experiment 1  5000 HCMEC D3
      4096  195 Alpha  A01   2.71000         0 1 : Experiment 1 35000 HCMEC D3
      4097  195 Alpha  A02   2.90000         0 1 : Experiment 1 35000 HCMEC D3
      4098  195 Alpha  A03   2.78000         0 1 : Experiment 1 35000 HCMEC D3
      4099  195 Alpha  B01   3.03000         0 1 : Experiment 1 30000 HCMEC D3
      4100  195 Alpha  B02   3.12000         0 1 : Experiment 1 30000 HCMEC D3
      4101  195 Alpha  B03   3.06000         0 1 : Experiment 1 30000 HCMEC D3
      4102  195 Alpha  C01   3.16000         0 1 : Experiment 1 25000 HCMEC D3
      4103  195 Alpha  C02   3.12000         0 1 : Experiment 1 25000 HCMEC D3
      4104  195 Alpha  C03   3.25000         0 1 : Experiment 1 25000 HCMEC D3
      4105  195 Alpha  D01   4.50000         0 1 : Experiment 1 20000 HCMEC D3
      4106  195 Alpha  D02   3.35000         0 1 : Experiment 1 20000 HCMEC D3
      4107  195 Alpha  D03   3.31000         0 1 : Experiment 1 20000 HCMEC D3
      4108  195 Alpha  E01   3.41000         0 1 : Experiment 1 15000 HCMEC D3
      4109  195 Alpha  E02   3.45000         0 1 : Experiment 1 15000 HCMEC D3
      4110  195 Alpha  E03   3.41000         0 1 : Experiment 1 15000 HCMEC D3
      4111  195 Alpha  F01   3.65000         0 1 : Experiment 1 10000 HCMEC D3
      4112  195 Alpha  F02   3.65000         0 1 : Experiment 1 10000 HCMEC D3
      4113  195 Alpha  F03   3.65000         0 1 : Experiment 1 10000 HCMEC D3
      4114  195 Alpha  G01   4.47000         0 1 : Experiment 1  5000 HCMEC D3
      4115  195 Alpha  G02   4.52000         0 1 : Experiment 1  5000 HCMEC D3
      4116  195 Alpha  G03   4.57000         0 1 : Experiment 1  5000 HCMEC D3
      4117  195    Cm  A01   1.43000         0 1 : Experiment 1 35000 HCMEC D3
      4118  195    Cm  A02   1.23000         0 1 : Experiment 1 35000 HCMEC D3
      4119  195    Cm  A03   1.32000         0 1 : Experiment 1 35000 HCMEC D3
      4120  195    Cm  B01   1.11000         0 1 : Experiment 1 30000 HCMEC D3
      4121  195    Cm  B02   1.06000         0 1 : Experiment 1 30000 HCMEC D3
      4122  195    Cm  B03   1.11000         0 1 : Experiment 1 30000 HCMEC D3
      4123  195    Cm  C01   1.10000         0 1 : Experiment 1 25000 HCMEC D3
      4124  195    Cm  C02   1.02000         0 1 : Experiment 1 25000 HCMEC D3
      4125  195    Cm  C03   1.10000         0 1 : Experiment 1 25000 HCMEC D3
      4126  195    Cm  D01   0.90000         0 1 : Experiment 1 20000 HCMEC D3
      4127  195    Cm  D02   1.06000         0 1 : Experiment 1 20000 HCMEC D3
      4128  195    Cm  D03   1.08000         0 1 : Experiment 1 20000 HCMEC D3
      4129  195    Cm  E01   1.06000         0 1 : Experiment 1 15000 HCMEC D3
      4130  195    Cm  E02   1.02000         0 1 : Experiment 1 15000 HCMEC D3
      4131  195    Cm  E03   1.05000         0 1 : Experiment 1 15000 HCMEC D3
      4132  195    Cm  F01   1.05000         0 1 : Experiment 1 10000 HCMEC D3
      4133  195    Cm  F02   1.03000         0 1 : Experiment 1 10000 HCMEC D3
      4134  195    Cm  F03   1.04000         0 1 : Experiment 1 10000 HCMEC D3
      4135  195    Cm  G01   1.29000         0 1 : Experiment 1  5000 HCMEC D3
      4136  195    Cm  G02   1.18000         0 1 : Experiment 1  5000 HCMEC D3
      4137  195    Cm  G03   1.19000         0 1 : Experiment 1  5000 HCMEC D3
      4138  195 Drift  A01  -2.40000         0 1 : Experiment 1 35000 HCMEC D3
      4139  195 Drift  A02  -2.84000         0 1 : Experiment 1 35000 HCMEC D3
      4140  195 Drift  A03  -2.02000         0 1 : Experiment 1 35000 HCMEC D3
      4141  195 Drift  B01  -3.23000         0 1 : Experiment 1 30000 HCMEC D3
      4142  195 Drift  B02  -3.49000         0 1 : Experiment 1 30000 HCMEC D3
      4143  195 Drift  B03  -2.92000         0 1 : Experiment 1 30000 HCMEC D3
      4144  195 Drift  C01  -3.60000         0 1 : Experiment 1 25000 HCMEC D3
      4145  195 Drift  C02  -3.95000         0 1 : Experiment 1 25000 HCMEC D3
      4146  195 Drift  C03  -3.33000         0 1 : Experiment 1 25000 HCMEC D3
      4147  195 Drift  D01  -4.28000         0 1 : Experiment 1 20000 HCMEC D3
      4148  195 Drift  D02  -3.72000         0 1 : Experiment 1 20000 HCMEC D3
      4149  195 Drift  D03  -2.99000         0 1 : Experiment 1 20000 HCMEC D3
      4150  195 Drift  E01  -2.46000         0 1 : Experiment 1 15000 HCMEC D3
      4151  195 Drift  E02  -2.95000         0 1 : Experiment 1 15000 HCMEC D3
      4152  195 Drift  E03  -2.50000         0 1 : Experiment 1 15000 HCMEC D3
      4153  195 Drift  F01  -2.50000         0 1 : Experiment 1 10000 HCMEC D3
      4154  195 Drift  F02  -2.88000         0 1 : Experiment 1 10000 HCMEC D3
      4155  195 Drift  F03  -2.11000         0 1 : Experiment 1 10000 HCMEC D3
      4156  195 Drift  G01  -1.74000         0 1 : Experiment 1  5000 HCMEC D3
      4157  195 Drift  G02  -1.98000         0 1 : Experiment 1  5000 HCMEC D3
      4158  195 Drift  G03  -1.33000         0 1 : Experiment 1  5000 HCMEC D3
      4159  195    Rb  A01   0.62000         0 1 : Experiment 1 35000 HCMEC D3
      4160  195    Rb  A02   0.77000         0 1 : Experiment 1 35000 HCMEC D3
      4161  195    Rb  A03   0.69000         0 1 : Experiment 1 35000 HCMEC D3
      4162  195    Rb  B01   0.92000         0 1 : Experiment 1 30000 HCMEC D3
      4163  195    Rb  B02   0.93000         0 1 : Experiment 1 30000 HCMEC D3
      4164  195    Rb  B03   0.85000         0 1 : Experiment 1 30000 HCMEC D3
      4165  195    Rb  C01   0.84000         0 1 : Experiment 1 25000 HCMEC D3
      4166  195    Rb  C02   0.92000         0 1 : Experiment 1 25000 HCMEC D3
      4167  195    Rb  C03   0.87000         0 1 : Experiment 1 25000 HCMEC D3
      4168  195    Rb  D01   1.31000         0 1 : Experiment 1 20000 HCMEC D3
      4169  195    Rb  D02   0.88000         0 1 : Experiment 1 20000 HCMEC D3
      4170  195    Rb  D03   0.88000         0 1 : Experiment 1 20000 HCMEC D3
      4171  195    Rb  E01   1.12000         0 1 : Experiment 1 15000 HCMEC D3
      4172  195    Rb  E02   1.07000         0 1 : Experiment 1 15000 HCMEC D3
      4173  195    Rb  E03   1.13000         0 1 : Experiment 1 15000 HCMEC D3
      4174  195    Rb  F01   1.11000         0 1 : Experiment 1 10000 HCMEC D3
      4175  195    Rb  F02   1.15000         0 1 : Experiment 1 10000 HCMEC D3
      4176  195    Rb  F03   1.22000         0 1 : Experiment 1 10000 HCMEC D3
      4177  195    Rb  G01   0.80000         0 1 : Experiment 1  5000 HCMEC D3
      4178  195    Rb  G02   1.00000         0 1 : Experiment 1  5000 HCMEC D3
      4179  195    Rb  G03   0.58000         0 1 : Experiment 1  5000 HCMEC D3
      4180  195  RMSE  A01   0.01000         0 1 : Experiment 1 35000 HCMEC D3
      4181  195  RMSE  A02   0.01000         0 1 : Experiment 1 35000 HCMEC D3
      4182  195  RMSE  A03   0.01000         0 1 : Experiment 1 35000 HCMEC D3
      4183  195  RMSE  B01   0.01000         0 1 : Experiment 1 30000 HCMEC D3
      4184  195  RMSE  B02   0.01000         0 1 : Experiment 1 30000 HCMEC D3
      4185  195  RMSE  B03   0.01000         0 1 : Experiment 1 30000 HCMEC D3
      4186  195  RMSE  C01   0.01000         0 1 : Experiment 1 25000 HCMEC D3
      4187  195  RMSE  C02   0.01000         0 1 : Experiment 1 25000 HCMEC D3
      4188  195  RMSE  C03   0.01000         0 1 : Experiment 1 25000 HCMEC D3
      4189  195  RMSE  D01   0.01000         0 1 : Experiment 1 20000 HCMEC D3
      4190  195  RMSE  D02   0.01000         0 1 : Experiment 1 20000 HCMEC D3
      4191  195  RMSE  D03   0.01000         0 1 : Experiment 1 20000 HCMEC D3
      4192  195  RMSE  E01   0.01000         0 1 : Experiment 1 15000 HCMEC D3
      4193  195  RMSE  E02   0.01000         0 1 : Experiment 1 15000 HCMEC D3
      4194  195  RMSE  E03   0.01000         0 1 : Experiment 1 15000 HCMEC D3
      4195  195  RMSE  F01   0.01000         0 1 : Experiment 1 10000 HCMEC D3
      4196  195  RMSE  F02   0.01000         0 1 : Experiment 1 10000 HCMEC D3
      4197  195  RMSE  F03   0.01000         0 1 : Experiment 1 10000 HCMEC D3
      4198  195  RMSE  G01   0.01000         0 1 : Experiment 1  5000 HCMEC D3
      4199  195  RMSE  G02   0.01000         0 1 : Experiment 1  5000 HCMEC D3
      4200  195  RMSE  G03   0.01000         0 1 : Experiment 1  5000 HCMEC D3
      4201  200 Alpha  A01        NA         0 1 : Experiment 1 35000 HCMEC D3
      4202  200 Alpha  A02        NA         0 1 : Experiment 1 35000 HCMEC D3
      4203  200 Alpha  A03        NA         0 1 : Experiment 1 35000 HCMEC D3
      4204  200 Alpha  B01        NA         0 1 : Experiment 1 30000 HCMEC D3
      4205  200 Alpha  B02        NA         0 1 : Experiment 1 30000 HCMEC D3
      4206  200 Alpha  B03        NA         0 1 : Experiment 1 30000 HCMEC D3
      4207  200 Alpha  C01        NA         0 1 : Experiment 1 25000 HCMEC D3
      4208  200 Alpha  C02        NA         0 1 : Experiment 1 25000 HCMEC D3
      4209  200 Alpha  C03        NA         0 1 : Experiment 1 25000 HCMEC D3
      4210  200 Alpha  D01        NA         0 1 : Experiment 1 20000 HCMEC D3
      4211  200 Alpha  D02        NA         0 1 : Experiment 1 20000 HCMEC D3
      4212  200 Alpha  D03        NA         0 1 : Experiment 1 20000 HCMEC D3
      4213  200 Alpha  E01        NA         0 1 : Experiment 1 15000 HCMEC D3
      4214  200 Alpha  E02        NA         0 1 : Experiment 1 15000 HCMEC D3
      4215  200 Alpha  E03        NA         0 1 : Experiment 1 15000 HCMEC D3
      4216  200 Alpha  F01        NA         0 1 : Experiment 1 10000 HCMEC D3
      4217  200 Alpha  F02        NA         0 1 : Experiment 1 10000 HCMEC D3
      4218  200 Alpha  F03        NA         0 1 : Experiment 1 10000 HCMEC D3
      4219  200 Alpha  G01        NA         0 1 : Experiment 1  5000 HCMEC D3
      4220  200 Alpha  G02        NA         0 1 : Experiment 1  5000 HCMEC D3
      4221  200 Alpha  G03        NA         0 1 : Experiment 1  5000 HCMEC D3
      4222  200    Cm  A01        NA         0 1 : Experiment 1 35000 HCMEC D3
      4223  200    Cm  A02        NA         0 1 : Experiment 1 35000 HCMEC D3
      4224  200    Cm  A03        NA         0 1 : Experiment 1 35000 HCMEC D3
      4225  200    Cm  B01        NA         0 1 : Experiment 1 30000 HCMEC D3
      4226  200    Cm  B02        NA         0 1 : Experiment 1 30000 HCMEC D3
      4227  200    Cm  B03        NA         0 1 : Experiment 1 30000 HCMEC D3
      4228  200    Cm  C01        NA         0 1 : Experiment 1 25000 HCMEC D3
      4229  200    Cm  C02        NA         0 1 : Experiment 1 25000 HCMEC D3
      4230  200    Cm  C03        NA         0 1 : Experiment 1 25000 HCMEC D3
      4231  200    Cm  D01        NA         0 1 : Experiment 1 20000 HCMEC D3
      4232  200    Cm  D02        NA         0 1 : Experiment 1 20000 HCMEC D3
      4233  200    Cm  D03        NA         0 1 : Experiment 1 20000 HCMEC D3
      4234  200    Cm  E01        NA         0 1 : Experiment 1 15000 HCMEC D3
      4235  200    Cm  E02        NA         0 1 : Experiment 1 15000 HCMEC D3
      4236  200    Cm  E03        NA         0 1 : Experiment 1 15000 HCMEC D3
      4237  200    Cm  F01        NA         0 1 : Experiment 1 10000 HCMEC D3
      4238  200    Cm  F02        NA         0 1 : Experiment 1 10000 HCMEC D3
      4239  200    Cm  F03        NA         0 1 : Experiment 1 10000 HCMEC D3
      4240  200    Cm  G01        NA         0 1 : Experiment 1  5000 HCMEC D3
      4241  200    Cm  G02        NA         0 1 : Experiment 1  5000 HCMEC D3
      4242  200    Cm  G03        NA         0 1 : Experiment 1  5000 HCMEC D3
      4243  200 Drift  A01        NA         0 1 : Experiment 1 35000 HCMEC D3
      4244  200 Drift  A02        NA         0 1 : Experiment 1 35000 HCMEC D3
      4245  200 Drift  A03        NA         0 1 : Experiment 1 35000 HCMEC D3
      4246  200 Drift  B01        NA         0 1 : Experiment 1 30000 HCMEC D3
      4247  200 Drift  B02        NA         0 1 : Experiment 1 30000 HCMEC D3
      4248  200 Drift  B03        NA         0 1 : Experiment 1 30000 HCMEC D3
      4249  200 Drift  C01        NA         0 1 : Experiment 1 25000 HCMEC D3
      4250  200 Drift  C02        NA         0 1 : Experiment 1 25000 HCMEC D3
      4251  200 Drift  C03        NA         0 1 : Experiment 1 25000 HCMEC D3
      4252  200 Drift  D01        NA         0 1 : Experiment 1 20000 HCMEC D3
      4253  200 Drift  D02        NA         0 1 : Experiment 1 20000 HCMEC D3
      4254  200 Drift  D03        NA         0 1 : Experiment 1 20000 HCMEC D3
      4255  200 Drift  E01        NA         0 1 : Experiment 1 15000 HCMEC D3
      4256  200 Drift  E02        NA         0 1 : Experiment 1 15000 HCMEC D3
      4257  200 Drift  E03        NA         0 1 : Experiment 1 15000 HCMEC D3
      4258  200 Drift  F01        NA         0 1 : Experiment 1 10000 HCMEC D3
      4259  200 Drift  F02        NA         0 1 : Experiment 1 10000 HCMEC D3
      4260  200 Drift  F03        NA         0 1 : Experiment 1 10000 HCMEC D3
      4261  200 Drift  G01        NA         0 1 : Experiment 1  5000 HCMEC D3
      4262  200 Drift  G02        NA         0 1 : Experiment 1  5000 HCMEC D3
      4263  200 Drift  G03        NA         0 1 : Experiment 1  5000 HCMEC D3
      4264  200    Rb  A01        NA         0 1 : Experiment 1 35000 HCMEC D3
      4265  200    Rb  A02        NA         0 1 : Experiment 1 35000 HCMEC D3
      4266  200    Rb  A03        NA         0 1 : Experiment 1 35000 HCMEC D3
      4267  200    Rb  B01        NA         0 1 : Experiment 1 30000 HCMEC D3
      4268  200    Rb  B02        NA         0 1 : Experiment 1 30000 HCMEC D3
      4269  200    Rb  B03        NA         0 1 : Experiment 1 30000 HCMEC D3
      4270  200    Rb  C01        NA         0 1 : Experiment 1 25000 HCMEC D3
      4271  200    Rb  C02        NA         0 1 : Experiment 1 25000 HCMEC D3
      4272  200    Rb  C03        NA         0 1 : Experiment 1 25000 HCMEC D3
      4273  200    Rb  D01        NA         0 1 : Experiment 1 20000 HCMEC D3
      4274  200    Rb  D02        NA         0 1 : Experiment 1 20000 HCMEC D3
      4275  200    Rb  D03        NA         0 1 : Experiment 1 20000 HCMEC D3
      4276  200    Rb  E01        NA         0 1 : Experiment 1 15000 HCMEC D3
      4277  200    Rb  E02        NA         0 1 : Experiment 1 15000 HCMEC D3
      4278  200    Rb  E03        NA         0 1 : Experiment 1 15000 HCMEC D3
      4279  200    Rb  F01        NA         0 1 : Experiment 1 10000 HCMEC D3
      4280  200    Rb  F02        NA         0 1 : Experiment 1 10000 HCMEC D3
      4281  200    Rb  F03        NA         0 1 : Experiment 1 10000 HCMEC D3
      4282  200    Rb  G01        NA         0 1 : Experiment 1  5000 HCMEC D3
      4283  200    Rb  G02        NA         0 1 : Experiment 1  5000 HCMEC D3
      4284  200    Rb  G03        NA         0 1 : Experiment 1  5000 HCMEC D3
      4285  200  RMSE  A01        NA         0 1 : Experiment 1 35000 HCMEC D3
      4286  200  RMSE  A02        NA         0 1 : Experiment 1 35000 HCMEC D3
      4287  200  RMSE  A03        NA         0 1 : Experiment 1 35000 HCMEC D3
      4288  200  RMSE  B01        NA         0 1 : Experiment 1 30000 HCMEC D3
      4289  200  RMSE  B02        NA         0 1 : Experiment 1 30000 HCMEC D3
      4290  200  RMSE  B03        NA         0 1 : Experiment 1 30000 HCMEC D3
      4291  200  RMSE  C01        NA         0 1 : Experiment 1 25000 HCMEC D3
      4292  200  RMSE  C02        NA         0 1 : Experiment 1 25000 HCMEC D3
      4293  200  RMSE  C03        NA         0 1 : Experiment 1 25000 HCMEC D3
      4294  200  RMSE  D01        NA         0 1 : Experiment 1 20000 HCMEC D3
      4295  200  RMSE  D02        NA         0 1 : Experiment 1 20000 HCMEC D3
      4296  200  RMSE  D03        NA         0 1 : Experiment 1 20000 HCMEC D3
      4297  200  RMSE  E01        NA         0 1 : Experiment 1 15000 HCMEC D3
      4298  200  RMSE  E02        NA         0 1 : Experiment 1 15000 HCMEC D3
      4299  200  RMSE  E03        NA         0 1 : Experiment 1 15000 HCMEC D3
      4300  200  RMSE  F01        NA         0 1 : Experiment 1 10000 HCMEC D3
      4301  200  RMSE  F02        NA         0 1 : Experiment 1 10000 HCMEC D3
      4302  200  RMSE  F03        NA         0 1 : Experiment 1 10000 HCMEC D3
      4303  200  RMSE  G01        NA         0 1 : Experiment 1  5000 HCMEC D3
      4304  200  RMSE  G02        NA         0 1 : Experiment 1  5000 HCMEC D3
      4305  200  RMSE  G03        NA         0 1 : Experiment 1  5000 HCMEC D3
      4306    0     C  A01        NA      1000 1 : Experiment 1 35000 HCMEC D3
      4307    5     C  A01 117.84576      1000 1 : Experiment 1 35000 HCMEC D3
      4308   10     C  A01 116.92351      1000 1 : Experiment 1 35000 HCMEC D3
      4309   15     C  A01 115.57385      1000 1 : Experiment 1 35000 HCMEC D3
      4310   20     C  A01 114.94466      1000 1 : Experiment 1 35000 HCMEC D3
      4311   25     C  A01 114.78655      1000 1 : Experiment 1 35000 HCMEC D3
      4312   30     C  A01 115.32148      1000 1 : Experiment 1 35000 HCMEC D3
      4313   35     C  A01 115.48468      1000 1 : Experiment 1 35000 HCMEC D3
      4314   40     C  A01 116.12190      1000 1 : Experiment 1 35000 HCMEC D3
      4315   45     C  A01 116.98194      1000 1 : Experiment 1 35000 HCMEC D3
      4316   50     C  A01 117.91218      1000 1 : Experiment 1 35000 HCMEC D3
      4317   55     C  A01 118.71455      1000 1 : Experiment 1 35000 HCMEC D3
      4318   60     C  A01 119.34482      1000 1 : Experiment 1 35000 HCMEC D3
      4319   65     C  A01 119.96451      1000 1 : Experiment 1 35000 HCMEC D3
      4320   70     C  A01 120.56143      1000 1 : Experiment 1 35000 HCMEC D3
      4321   75     C  A01 120.94865      1000 1 : Experiment 1 35000 HCMEC D3
      4322   80     C  A01 121.33362      1000 1 : Experiment 1 35000 HCMEC D3
      4323   85     C  A01 121.71808      1000 1 : Experiment 1 35000 HCMEC D3
      4324   90     C  A01 121.97599      1000 1 : Experiment 1 35000 HCMEC D3
      4325   95     C  A01 122.26871      1000 1 : Experiment 1 35000 HCMEC D3
      4326  100     C  A01 122.46997      1000 1 : Experiment 1 35000 HCMEC D3
      4327  105     C  A01 122.82769      1000 1 : Experiment 1 35000 HCMEC D3
      4328  110     C  A01 123.16506      1000 1 : Experiment 1 35000 HCMEC D3
      4329  115     C  A01 123.32736      1000 1 : Experiment 1 35000 HCMEC D3
      4330  120     C  A01 123.57619      1000 1 : Experiment 1 35000 HCMEC D3
      4331  125     C  A01 123.77549      1000 1 : Experiment 1 35000 HCMEC D3
      4332  130     C  A01 124.00030      1000 1 : Experiment 1 35000 HCMEC D3
      4333  135     C  A01 124.23253      1000 1 : Experiment 1 35000 HCMEC D3
      4334  140     C  A01 124.44092      1000 1 : Experiment 1 35000 HCMEC D3
      4335  145     C  A01 124.59529      1000 1 : Experiment 1 35000 HCMEC D3
      4336  150     C  A01 124.85012      1000 1 : Experiment 1 35000 HCMEC D3
      4337  155     C  A01 124.97768      1000 1 : Experiment 1 35000 HCMEC D3
      4338  160     C  A01 125.20618      1000 1 : Experiment 1 35000 HCMEC D3
      4339  165     C  A01 125.42740      1000 1 : Experiment 1 35000 HCMEC D3
      4340  170     C  A01 125.57698      1000 1 : Experiment 1 35000 HCMEC D3
      4341  175     C  A01 125.78225      1000 1 : Experiment 1 35000 HCMEC D3
      4342  180     C  A01 125.93935      1000 1 : Experiment 1 35000 HCMEC D3
      4343  185     C  A01 126.09663      1000 1 : Experiment 1 35000 HCMEC D3
      4344  190     C  A01 126.20072      1000 1 : Experiment 1 35000 HCMEC D3
      4345  195     C  A01 126.30873      1000 1 : Experiment 1 35000 HCMEC D3
      4346  200     C  A01        NA      1000 1 : Experiment 1 35000 HCMEC D3
      4347    0     C  A01        NA     16000 1 : Experiment 1 35000 HCMEC D3
      4348    5     C  A01  79.36012     16000 1 : Experiment 1 35000 HCMEC D3
      4349   10     C  A01  69.98077     16000 1 : Experiment 1 35000 HCMEC D3
      4350   15     C  A01  58.99523     16000 1 : Experiment 1 35000 HCMEC D3
      4351   20     C  A01  51.34751     16000 1 : Experiment 1 35000 HCMEC D3
      4352   25     C  A01  47.46892     16000 1 : Experiment 1 35000 HCMEC D3
      4353   30     C  A01  46.05375     16000 1 : Experiment 1 35000 HCMEC D3
      4354   35     C  A01  43.99531     16000 1 : Experiment 1 35000 HCMEC D3
      4355   40     C  A01  42.59318     16000 1 : Experiment 1 35000 HCMEC D3
      4356   45     C  A01  42.25120     16000 1 : Experiment 1 35000 HCMEC D3
      4357   50     C  A01  42.55949     16000 1 : Experiment 1 35000 HCMEC D3
      4358   55     C  A01  43.31542     16000 1 : Experiment 1 35000 HCMEC D3
      4359   60     C  A01  43.82494     16000 1 : Experiment 1 35000 HCMEC D3
      4360   65     C  A01  44.53030     16000 1 : Experiment 1 35000 HCMEC D3
      4361   70     C  A01  45.51089     16000 1 : Experiment 1 35000 HCMEC D3
      4362   75     C  A01  46.35622     16000 1 : Experiment 1 35000 HCMEC D3
      4363   80     C  A01  47.72342     16000 1 : Experiment 1 35000 HCMEC D3
      4364   85     C  A01  49.03148     16000 1 : Experiment 1 35000 HCMEC D3
      4365   90     C  A01  49.98514     16000 1 : Experiment 1 35000 HCMEC D3
      4366   95     C  A01  51.27412     16000 1 : Experiment 1 35000 HCMEC D3
      4367  100     C  A01  52.69573     16000 1 : Experiment 1 35000 HCMEC D3
      4368  105     C  A01  54.72573     16000 1 : Experiment 1 35000 HCMEC D3
      4369  110     C  A01  56.64348     16000 1 : Experiment 1 35000 HCMEC D3
      4370  115     C  A01  57.79391     16000 1 : Experiment 1 35000 HCMEC D3
      4371  120     C  A01  58.87112     16000 1 : Experiment 1 35000 HCMEC D3
      4372  125     C  A01  60.62649     16000 1 : Experiment 1 35000 HCMEC D3
      4373  130     C  A01  62.34203     16000 1 : Experiment 1 35000 HCMEC D3
      4374  135     C  A01  63.51840     16000 1 : Experiment 1 35000 HCMEC D3
      4375  140     C  A01  64.99880     16000 1 : Experiment 1 35000 HCMEC D3
      4376  145     C  A01  65.77113     16000 1 : Experiment 1 35000 HCMEC D3
      4377  150     C  A01  67.36103     16000 1 : Experiment 1 35000 HCMEC D3
      4378  155     C  A01  68.36551     16000 1 : Experiment 1 35000 HCMEC D3
      4379  160     C  A01  69.68458     16000 1 : Experiment 1 35000 HCMEC D3
      4380  165     C  A01  70.92706     16000 1 : Experiment 1 35000 HCMEC D3
      4381  170     C  A01  72.03146     16000 1 : Experiment 1 35000 HCMEC D3
      4382  175     C  A01  73.65866     16000 1 : Experiment 1 35000 HCMEC D3
      4383  180     C  A01  75.29787     16000 1 : Experiment 1 35000 HCMEC D3
      4384  185     C  A01  76.68229     16000 1 : Experiment 1 35000 HCMEC D3
      4385  190     C  A01  78.02089     16000 1 : Experiment 1 35000 HCMEC D3
      4386  195     C  A01  79.76957     16000 1 : Experiment 1 35000 HCMEC D3
      4387  200     C  A01        NA     16000 1 : Experiment 1 35000 HCMEC D3
      4388    0     C  A01        NA      2000 1 : Experiment 1 35000 HCMEC D3
      4389    5     C  A01 112.84547      2000 1 : Experiment 1 35000 HCMEC D3
      4390   10     C  A01 110.02839      2000 1 : Experiment 1 35000 HCMEC D3
      4391   15     C  A01 106.43806      2000 1 : Experiment 1 35000 HCMEC D3
      4392   20     C  A01 104.46145      2000 1 : Experiment 1 35000 HCMEC D3
      4393   25     C  A01 103.75781      2000 1 : Experiment 1 35000 HCMEC D3
      4394   30     C  A01 104.14078      2000 1 : Experiment 1 35000 HCMEC D3
      4395   35     C  A01 104.29296      2000 1 : Experiment 1 35000 HCMEC D3
      4396   40     C  A01 105.38779      2000 1 : Experiment 1 35000 HCMEC D3
      4397   45     C  A01 106.92864      2000 1 : Experiment 1 35000 HCMEC D3
      4398   50     C  A01 108.57518      2000 1 : Experiment 1 35000 HCMEC D3
      4399   55     C  A01 110.08092      2000 1 : Experiment 1 35000 HCMEC D3
      4400   60     C  A01 111.03963      2000 1 : Experiment 1 35000 HCMEC D3
      4401   65     C  A01 112.07060      2000 1 : Experiment 1 35000 HCMEC D3
      4402   70     C  A01 112.97584      2000 1 : Experiment 1 35000 HCMEC D3
      4403   75     C  A01 113.50210      2000 1 : Experiment 1 35000 HCMEC D3
      4404   80     C  A01 114.14763      2000 1 : Experiment 1 35000 HCMEC D3
      4405   85     C  A01 114.83288      2000 1 : Experiment 1 35000 HCMEC D3
      4406   90     C  A01 115.24456      2000 1 : Experiment 1 35000 HCMEC D3
      4407   95     C  A01 115.75062      2000 1 : Experiment 1 35000 HCMEC D3
      4408  100     C  A01 116.09957      2000 1 : Experiment 1 35000 HCMEC D3
      4409  105     C  A01 116.81112      2000 1 : Experiment 1 35000 HCMEC D3
      4410  110     C  A01 117.49101      2000 1 : Experiment 1 35000 HCMEC D3
      4411  115     C  A01 117.75625      2000 1 : Experiment 1 35000 HCMEC D3
      4412  120     C  A01 118.20879      2000 1 : Experiment 1 35000 HCMEC D3
      4413  125     C  A01 118.59669      2000 1 : Experiment 1 35000 HCMEC D3
      4414  130     C  A01 119.08800      2000 1 : Experiment 1 35000 HCMEC D3
      4415  135     C  A01 119.54289      2000 1 : Experiment 1 35000 HCMEC D3
      4416  140     C  A01 119.89648      2000 1 : Experiment 1 35000 HCMEC D3
      4417  145     C  A01 120.16434      2000 1 : Experiment 1 35000 HCMEC D3
      4418  150     C  A01 120.67791      2000 1 : Experiment 1 35000 HCMEC D3
      4419  155     C  A01 120.91185      2000 1 : Experiment 1 35000 HCMEC D3
      4420  160     C  A01 121.38791      2000 1 : Experiment 1 35000 HCMEC D3
      4421  165     C  A01 121.85412      2000 1 : Experiment 1 35000 HCMEC D3
      4422  170     C  A01 122.14356      2000 1 : Experiment 1 35000 HCMEC D3
      4423  175     C  A01 122.59871      2000 1 : Experiment 1 35000 HCMEC D3
      4424  180     C  A01 122.98614      2000 1 : Experiment 1 35000 HCMEC D3
      4425  185     C  A01 123.37529      2000 1 : Experiment 1 35000 HCMEC D3
      4426  190     C  A01 123.67160      2000 1 : Experiment 1 35000 HCMEC D3
      4427  195     C  A01 123.98483      2000 1 : Experiment 1 35000 HCMEC D3
      4428  200     C  A01        NA      2000 1 : Experiment 1 35000 HCMEC D3
      4429    0     C  A01        NA       250 1 : Experiment 1 35000 HCMEC D3
      4430    5     C  A01 123.26230       250 1 : Experiment 1 35000 HCMEC D3
      4431   10     C  A01 123.11698       250 1 : Experiment 1 35000 HCMEC D3
      4432   15     C  A01 122.92755       250 1 : Experiment 1 35000 HCMEC D3
      4433   20     C  A01 122.92461       250 1 : Experiment 1 35000 HCMEC D3
      4434   25     C  A01 123.06066       250 1 : Experiment 1 35000 HCMEC D3
      4435   30     C  A01 123.35987       250 1 : Experiment 1 35000 HCMEC D3
      4436   35     C  A01 123.57683       250 1 : Experiment 1 35000 HCMEC D3
      4437   40     C  A01 123.89626       250 1 : Experiment 1 35000 HCMEC D3
      4438   45     C  A01 124.25142       250 1 : Experiment 1 35000 HCMEC D3
      4439   50     C  A01 124.62006       250 1 : Experiment 1 35000 HCMEC D3
      4440   55     C  A01 124.95087       250 1 : Experiment 1 35000 HCMEC D3
      4441   60     C  A01 125.29221       250 1 : Experiment 1 35000 HCMEC D3
      4442   65     C  A01 125.60117       250 1 : Experiment 1 35000 HCMEC D3
      4443   70     C  A01 125.88533       250 1 : Experiment 1 35000 HCMEC D3
      4444   75     C  A01 126.11319       250 1 : Experiment 1 35000 HCMEC D3
      4445   80     C  A01 126.33054       250 1 : Experiment 1 35000 HCMEC D3
      4446   85     C  A01 126.54861       250 1 : Experiment 1 35000 HCMEC D3
      4447   90     C  A01 126.73464       250 1 : Experiment 1 35000 HCMEC D3
      4448   95     C  A01 126.91832       250 1 : Experiment 1 35000 HCMEC D3
      4449  100     C  A01 127.06544       250 1 : Experiment 1 35000 HCMEC D3
      4450  105     C  A01 127.24044       250 1 : Experiment 1 35000 HCMEC D3
      4451  110     C  A01 127.38906       250 1 : Experiment 1 35000 HCMEC D3
      4452  115     C  A01 127.53299       250 1 : Experiment 1 35000 HCMEC D3
      4453  120     C  A01 127.66290       250 1 : Experiment 1 35000 HCMEC D3
      4454  125     C  A01 127.77935       250 1 : Experiment 1 35000 HCMEC D3
      4455  130     C  A01 127.90236       250 1 : Experiment 1 35000 HCMEC D3
      4456  135     C  A01 128.01068       250 1 : Experiment 1 35000 HCMEC D3
      4457  140     C  A01 128.14599       250 1 : Experiment 1 35000 HCMEC D3
      4458  145     C  A01 128.25821       250 1 : Experiment 1 35000 HCMEC D3
      4459  150     C  A01 128.35569       250 1 : Experiment 1 35000 HCMEC D3
      4460  155     C  A01 128.44398       250 1 : Experiment 1 35000 HCMEC D3
      4461  160     C  A01 128.53784       250 1 : Experiment 1 35000 HCMEC D3
      4462  165     C  A01 128.63105       250 1 : Experiment 1 35000 HCMEC D3
      4463  170     C  A01 128.71624       250 1 : Experiment 1 35000 HCMEC D3
      4464  175     C  A01 128.80521       250 1 : Experiment 1 35000 HCMEC D3
      4465  180     C  A01 128.86954       250 1 : Experiment 1 35000 HCMEC D3
      4466  185     C  A01 128.92863       250 1 : Experiment 1 35000 HCMEC D3
      4467  190     C  A01 128.96446       250 1 : Experiment 1 35000 HCMEC D3
      4468  195     C  A01 128.97348       250 1 : Experiment 1 35000 HCMEC D3
      4469  200     C  A01        NA       250 1 : Experiment 1 35000 HCMEC D3
      4470    0     C  A01        NA     32000 1 : Experiment 1 35000 HCMEC D3
      4471    5     C  A01  66.65768     32000 1 : Experiment 1 35000 HCMEC D3
      4472   10     C  A01  57.14920     32000 1 : Experiment 1 35000 HCMEC D3
      4473   15     C  A01  46.02891     32000 1 : Experiment 1 35000 HCMEC D3
      4474   20     C  A01  37.98628     32000 1 : Experiment 1 35000 HCMEC D3
      4475   25     C  A01  33.55287     32000 1 : Experiment 1 35000 HCMEC D3
      4476   30     C  A01  31.82642     32000 1 : Experiment 1 35000 HCMEC D3
      4477   35     C  A01  29.13370     32000 1 : Experiment 1 35000 HCMEC D3
      4478   40     C  A01  26.29429     32000 1 : Experiment 1 35000 HCMEC D3
      4479   45     C  A01  24.23323     32000 1 : Experiment 1 35000 HCMEC D3
      4480   50     C  A01  23.16552     32000 1 : Experiment 1 35000 HCMEC D3
      4481   55     C  A01  22.61333     32000 1 : Experiment 1 35000 HCMEC D3
      4482   60     C  A01  22.46643     32000 1 : Experiment 1 35000 HCMEC D3
      4483   65     C  A01  22.51257     32000 1 : Experiment 1 35000 HCMEC D3
      4484   70     C  A01  22.92491     32000 1 : Experiment 1 35000 HCMEC D3
      4485   75     C  A01  23.35998     32000 1 : Experiment 1 35000 HCMEC D3
      4486   80     C  A01  24.39090     32000 1 : Experiment 1 35000 HCMEC D3
      4487   85     C  A01  25.07271     32000 1 : Experiment 1 35000 HCMEC D3
      4488   90     C  A01  25.71895     32000 1 : Experiment 1 35000 HCMEC D3
      4489   95     C  A01  26.65939     32000 1 : Experiment 1 35000 HCMEC D3
      4490  100     C  A01  27.69167     32000 1 : Experiment 1 35000 HCMEC D3
      4491  105     C  A01  28.97373     32000 1 : Experiment 1 35000 HCMEC D3
      4492  110     C  A01  30.47634     32000 1 : Experiment 1 35000 HCMEC D3
      4493  115     C  A01  31.28135     32000 1 : Experiment 1 35000 HCMEC D3
      4494  120     C  A01  32.20544     32000 1 : Experiment 1 35000 HCMEC D3
      4495  125     C  A01  33.71680     32000 1 : Experiment 1 35000 HCMEC D3
      4496  130     C  A01  35.05647     32000 1 : Experiment 1 35000 HCMEC D3
      4497  135     C  A01  36.07956     32000 1 : Experiment 1 35000 HCMEC D3
      4498  140     C  A01  37.39259     32000 1 : Experiment 1 35000 HCMEC D3
      4499  145     C  A01  38.13059     32000 1 : Experiment 1 35000 HCMEC D3
      4500  150     C  A01  39.62031     32000 1 : Experiment 1 35000 HCMEC D3
      4501  155     C  A01  40.59143     32000 1 : Experiment 1 35000 HCMEC D3
      4502  160     C  A01  41.89756     32000 1 : Experiment 1 35000 HCMEC D3
      4503  165     C  A01  43.05081     32000 1 : Experiment 1 35000 HCMEC D3
      4504  170     C  A01  44.01092     32000 1 : Experiment 1 35000 HCMEC D3
      4505  175     C  A01  45.71191     32000 1 : Experiment 1 35000 HCMEC D3
      4506  180     C  A01  47.41311     32000 1 : Experiment 1 35000 HCMEC D3
      4507  185     C  A01  48.82418     32000 1 : Experiment 1 35000 HCMEC D3
      4508  190     C  A01  50.44780     32000 1 : Experiment 1 35000 HCMEC D3
      4509  195     C  A01  52.38377     32000 1 : Experiment 1 35000 HCMEC D3
      4510  200     C  A01        NA     32000 1 : Experiment 1 35000 HCMEC D3
      4511    0     C  A01        NA      4000 1 : Experiment 1 35000 HCMEC D3
      4512    5     C  A01 104.21521      4000 1 : Experiment 1 35000 HCMEC D3
      4513   10     C  A01  98.82943      4000 1 : Experiment 1 35000 HCMEC D3
      4514   15     C  A01  92.29687      4000 1 : Experiment 1 35000 HCMEC D3
      4515   20     C  A01  88.41540      4000 1 : Experiment 1 35000 HCMEC D3
      4516   25     C  A01  86.89610      4000 1 : Experiment 1 35000 HCMEC D3
      4517   30     C  A01  86.82697      4000 1 : Experiment 1 35000 HCMEC D3
      4518   35     C  A01  86.71116      4000 1 : Experiment 1 35000 HCMEC D3
      4519   40     C  A01  87.94536      4000 1 : Experiment 1 35000 HCMEC D3
      4520   45     C  A01  90.01151      4000 1 : Experiment 1 35000 HCMEC D3
      4521   50     C  A01  92.25425      4000 1 : Experiment 1 35000 HCMEC D3
      4522   55     C  A01  94.64856      4000 1 : Experiment 1 35000 HCMEC D3
      4523   60     C  A01  96.00462      4000 1 : Experiment 1 35000 HCMEC D3
      4524   65     C  A01  97.52413      4000 1 : Experiment 1 35000 HCMEC D3
      4525   70     C  A01  98.87883      4000 1 : Experiment 1 35000 HCMEC D3
      4526   75     C  A01  99.65159      4000 1 : Experiment 1 35000 HCMEC D3
      4527   80     C  A01 100.51863      4000 1 : Experiment 1 35000 HCMEC D3
      4528   85     C  A01 101.57623      4000 1 : Experiment 1 35000 HCMEC D3
      4529   90     C  A01 102.19627      4000 1 : Experiment 1 35000 HCMEC D3
      4530   95     C  A01 102.96324      4000 1 : Experiment 1 35000 HCMEC D3
      4531  100     C  A01 103.62687      4000 1 : Experiment 1 35000 HCMEC D3
      4532  105     C  A01 104.83472      4000 1 : Experiment 1 35000 HCMEC D3
      4533  110     C  A01 105.87271      4000 1 : Experiment 1 35000 HCMEC D3
      4534  115     C  A01 106.34093      4000 1 : Experiment 1 35000 HCMEC D3
      4535  120     C  A01 107.03358      4000 1 : Experiment 1 35000 HCMEC D3
      4536  125     C  A01 107.76118      4000 1 : Experiment 1 35000 HCMEC D3
      4537  130     C  A01 108.64374      4000 1 : Experiment 1 35000 HCMEC D3
      4538  135     C  A01 109.33146      4000 1 : Experiment 1 35000 HCMEC D3
      4539  140     C  A01 109.93311      4000 1 : Experiment 1 35000 HCMEC D3
      4540  145     C  A01 110.34703      4000 1 : Experiment 1 35000 HCMEC D3
      4541  150     C  A01 111.15544      4000 1 : Experiment 1 35000 HCMEC D3
      4542  155     C  A01 111.58944      4000 1 : Experiment 1 35000 HCMEC D3
      4543  160     C  A01 112.35916      4000 1 : Experiment 1 35000 HCMEC D3
      4544  165     C  A01 113.11025      4000 1 : Experiment 1 35000 HCMEC D3
      4545  170     C  A01 113.64546      4000 1 : Experiment 1 35000 HCMEC D3
      4546  175     C  A01 114.46644      4000 1 : Experiment 1 35000 HCMEC D3
      4547  180     C  A01 115.17358      4000 1 : Experiment 1 35000 HCMEC D3
      4548  185     C  A01 115.89029      4000 1 : Experiment 1 35000 HCMEC D3
      4549  190     C  A01 116.48087      4000 1 : Experiment 1 35000 HCMEC D3
      4550  195     C  A01 117.14075      4000 1 : Experiment 1 35000 HCMEC D3
      4551  200     C  A01        NA      4000 1 : Experiment 1 35000 HCMEC D3
      4552    0     C  A01        NA       500 1 : Experiment 1 35000 HCMEC D3
      4553    5     C  A01 121.04961       500 1 : Experiment 1 35000 HCMEC D3
      4554   10     C  A01 120.80763       500 1 : Experiment 1 35000 HCMEC D3
      4555   15     C  A01 120.38595       500 1 : Experiment 1 35000 HCMEC D3
      4556   20     C  A01 120.26552       500 1 : Experiment 1 35000 HCMEC D3
      4557   25     C  A01 120.32529       500 1 : Experiment 1 35000 HCMEC D3
      4558   30     C  A01 120.75071       500 1 : Experiment 1 35000 HCMEC D3
      4559   35     C  A01 120.91645       500 1 : Experiment 1 35000 HCMEC D3
      4560   40     C  A01 121.33249       500 1 : Experiment 1 35000 HCMEC D3
      4561   45     C  A01 121.83752       500 1 : Experiment 1 35000 HCMEC D3
      4562   50     C  A01 122.35440       500 1 : Experiment 1 35000 HCMEC D3
      4563   55     C  A01 122.81457       500 1 : Experiment 1 35000 HCMEC D3
      4564   60     C  A01 123.23422       500 1 : Experiment 1 35000 HCMEC D3
      4565   65     C  A01 123.63999       500 1 : Experiment 1 35000 HCMEC D3
      4566   70     C  A01 124.00537       500 1 : Experiment 1 35000 HCMEC D3
      4567   75     C  A01 124.29232       500 1 : Experiment 1 35000 HCMEC D3
      4568   80     C  A01 124.55940       500 1 : Experiment 1 35000 HCMEC D3
      4569   85     C  A01 124.80853       500 1 : Experiment 1 35000 HCMEC D3
      4570   90     C  A01 125.00816       500 1 : Experiment 1 35000 HCMEC D3
      4571   95     C  A01 125.21681       500 1 : Experiment 1 35000 HCMEC D3
      4572  100     C  A01 125.37207       500 1 : Experiment 1 35000 HCMEC D3
      4573  105     C  A01 125.58261       500 1 : Experiment 1 35000 HCMEC D3
      4574  110     C  A01 125.78755       500 1 : Experiment 1 35000 HCMEC D3
      4575  115     C  A01 125.93591       500 1 : Experiment 1 35000 HCMEC D3
      4576  120     C  A01 126.09557       500 1 : Experiment 1 35000 HCMEC D3
      4577  125     C  A01 126.23667       500 1 : Experiment 1 35000 HCMEC D3
      4578  130     C  A01 126.38452       500 1 : Experiment 1 35000 HCMEC D3
      4579  135     C  A01 126.53269       500 1 : Experiment 1 35000 HCMEC D3
      4580  140     C  A01 126.66795       500 1 : Experiment 1 35000 HCMEC D3
      4581  145     C  A01 126.79141       500 1 : Experiment 1 35000 HCMEC D3
      4582  150     C  A01 126.92979       500 1 : Experiment 1 35000 HCMEC D3
      4583  155     C  A01 127.03047       500 1 : Experiment 1 35000 HCMEC D3
      4584  160     C  A01 127.15009       500 1 : Experiment 1 35000 HCMEC D3
      4585  165     C  A01 127.27461       500 1 : Experiment 1 35000 HCMEC D3
      4586  170     C  A01 127.37762       500 1 : Experiment 1 35000 HCMEC D3
      4587  175     C  A01 127.48395       500 1 : Experiment 1 35000 HCMEC D3
      4588  180     C  A01 127.56922       500 1 : Experiment 1 35000 HCMEC D3
      4589  185     C  A01 127.64077       500 1 : Experiment 1 35000 HCMEC D3
      4590  190     C  A01 127.68873       500 1 : Experiment 1 35000 HCMEC D3
      4591  195     C  A01 127.72512       500 1 : Experiment 1 35000 HCMEC D3
      4592  200     C  A01        NA       500 1 : Experiment 1 35000 HCMEC D3
      4593    0     C  A01        NA     64000 1 : Experiment 1 35000 HCMEC D3
      4594    5     C  A01  50.80751     64000 1 : Experiment 1 35000 HCMEC D3
      4595   10     C  A01  43.08633     64000 1 : Experiment 1 35000 HCMEC D3
      4596   15     C  A01  34.14057     64000 1 : Experiment 1 35000 HCMEC D3
      4597   20     C  A01  27.42713     64000 1 : Experiment 1 35000 HCMEC D3
      4598   25     C  A01  23.42749     64000 1 : Experiment 1 35000 HCMEC D3
      4599   30     C  A01  21.84604     64000 1 : Experiment 1 35000 HCMEC D3
      4600   35     C  A01  19.29789     64000 1 : Experiment 1 35000 HCMEC D3
      4601   40     C  A01  16.17391     64000 1 : Experiment 1 35000 HCMEC D3
      4602   45     C  A01  13.63127     64000 1 : Experiment 1 35000 HCMEC D3
      4603   50     C  A01  12.30024     64000 1 : Experiment 1 35000 HCMEC D3
      4604   55     C  A01  11.57828     64000 1 : Experiment 1 35000 HCMEC D3
      4605   60     C  A01  11.34759     64000 1 : Experiment 1 35000 HCMEC D3
      4606   65     C  A01  11.27950     64000 1 : Experiment 1 35000 HCMEC D3
      4607   70     C  A01  11.43510     64000 1 : Experiment 1 35000 HCMEC D3
      4608   75     C  A01  11.62374     64000 1 : Experiment 1 35000 HCMEC D3
      4609   80     C  A01  12.14572     64000 1 : Experiment 1 35000 HCMEC D3
      4610   85     C  A01  12.37027     64000 1 : Experiment 1 35000 HCMEC D3
      4611   90     C  A01  12.67713     64000 1 : Experiment 1 35000 HCMEC D3
      4612   95     C  A01  13.12622     64000 1 : Experiment 1 35000 HCMEC D3
      4613  100     C  A01  13.61308     64000 1 : Experiment 1 35000 HCMEC D3
      4614  105     C  A01  14.13416     64000 1 : Experiment 1 35000 HCMEC D3
      4615  110     C  A01  14.88225     64000 1 : Experiment 1 35000 HCMEC D3
      4616  115     C  A01  15.24003     64000 1 : Experiment 1 35000 HCMEC D3
      4617  120     C  A01  15.77113     64000 1 : Experiment 1 35000 HCMEC D3
      4618  125     C  A01  16.53689     64000 1 : Experiment 1 35000 HCMEC D3
      4619  130     C  A01  17.17909     64000 1 : Experiment 1 35000 HCMEC D3
      4620  135     C  A01  17.71104     64000 1 : Experiment 1 35000 HCMEC D3
      4621  140     C  A01  18.40899     64000 1 : Experiment 1 35000 HCMEC D3
      4622  145     C  A01  18.83345     64000 1 : Experiment 1 35000 HCMEC D3
      4623  150     C  A01  19.69903     64000 1 : Experiment 1 35000 HCMEC D3
      4624  155     C  A01  20.30073     64000 1 : Experiment 1 35000 HCMEC D3
      4625  160     C  A01  21.14324     64000 1 : Experiment 1 35000 HCMEC D3
      4626  165     C  A01  21.84081     64000 1 : Experiment 1 35000 HCMEC D3
      4627  170     C  A01  22.33079     64000 1 : Experiment 1 35000 HCMEC D3
      4628  175     C  A01  23.48989     64000 1 : Experiment 1 35000 HCMEC D3
      4629  180     C  A01  24.58434     64000 1 : Experiment 1 35000 HCMEC D3
      4630  185     C  A01  25.51675     64000 1 : Experiment 1 35000 HCMEC D3
      4631  190     C  A01  26.83636     64000 1 : Experiment 1 35000 HCMEC D3
      4632  195     C  A01  28.16434     64000 1 : Experiment 1 35000 HCMEC D3
      4633  200     C  A01        NA     64000 1 : Experiment 1 35000 HCMEC D3
      4634    0     C  A01        NA      8000 1 : Experiment 1 35000 HCMEC D3
      4635    5     C  A01  91.83237      8000 1 : Experiment 1 35000 HCMEC D3
      4636   10     C  A01  84.02854      8000 1 : Experiment 1 35000 HCMEC D3
      4637   15     C  A01  74.86533      8000 1 : Experiment 1 35000 HCMEC D3
      4638   20     C  A01  68.96727      8000 1 : Experiment 1 35000 HCMEC D3
      4639   25     C  A01  66.22502      8000 1 : Experiment 1 35000 HCMEC D3
      4640   30     C  A01  65.47479      8000 1 : Experiment 1 35000 HCMEC D3
      4641   35     C  A01  64.43723      8000 1 : Experiment 1 35000 HCMEC D3
      4642   40     C  A01  64.80977      8000 1 : Experiment 1 35000 HCMEC D3
      4643   45     C  A01  66.34196      8000 1 : Experiment 1 35000 HCMEC D3
      4644   50     C  A01  68.24287      8000 1 : Experiment 1 35000 HCMEC D3
      4645   55     C  A01  70.56264      8000 1 : Experiment 1 35000 HCMEC D3
      4646   60     C  A01  71.85768      8000 1 : Experiment 1 35000 HCMEC D3
      4647   65     C  A01  73.34298      8000 1 : Experiment 1 35000 HCMEC D3
      4648   70     C  A01  74.77755      8000 1 : Experiment 1 35000 HCMEC D3
      4649   75     C  A01  75.76682      8000 1 : Experiment 1 35000 HCMEC D3
      4650   80     C  A01  76.95821      8000 1 : Experiment 1 35000 HCMEC D3
      4651   85     C  A01  78.36387      8000 1 : Experiment 1 35000 HCMEC D3
      4652   90     C  A01  79.23605      8000 1 : Experiment 1 35000 HCMEC D3
      4653   95     C  A01  80.36408      8000 1 : Experiment 1 35000 HCMEC D3
      4654  100     C  A01  81.53214      8000 1 : Experiment 1 35000 HCMEC D3
      4655  105     C  A01  83.38086      8000 1 : Experiment 1 35000 HCMEC D3
      4656  110     C  A01  84.96062      8000 1 : Experiment 1 35000 HCMEC D3
      4657  115     C  A01  85.82966      8000 1 : Experiment 1 35000 HCMEC D3
      4658  120     C  A01  86.70826      8000 1 : Experiment 1 35000 HCMEC D3
      4659  125     C  A01  88.02514      8000 1 : Experiment 1 35000 HCMEC D3
      4660  130     C  A01  89.46354      8000 1 : Experiment 1 35000 HCMEC D3
      4661  135     C  A01  90.40686      8000 1 : Experiment 1 35000 HCMEC D3
      4662  140     C  A01  91.46035      8000 1 : Experiment 1 35000 HCMEC D3
      4663  145     C  A01  92.05005      8000 1 : Experiment 1 35000 HCMEC D3
      4664  150     C  A01  93.22461      8000 1 : Experiment 1 35000 HCMEC D3
      4665  155     C  A01  93.93193      8000 1 : Experiment 1 35000 HCMEC D3
      4666  160     C  A01  94.97776      8000 1 : Experiment 1 35000 HCMEC D3
      4667  165     C  A01  95.97223      8000 1 : Experiment 1 35000 HCMEC D3
      4668  170     C  A01  96.82509      8000 1 : Experiment 1 35000 HCMEC D3
      4669  175     C  A01  98.00582      8000 1 : Experiment 1 35000 HCMEC D3
      4670  180     C  A01  99.13624      8000 1 : Experiment 1 35000 HCMEC D3
      4671  185     C  A01 100.21659      8000 1 : Experiment 1 35000 HCMEC D3
      4672  190     C  A01 101.07764      8000 1 : Experiment 1 35000 HCMEC D3
      4673  195     C  A01 102.25136      8000 1 : Experiment 1 35000 HCMEC D3
      4674  200     C  A01        NA      8000 1 : Experiment 1 35000 HCMEC D3
      4675    0     C  A02        NA      1000 1 : Experiment 1 35000 HCMEC D3
      4676    5     C  A02 117.14241      1000 1 : Experiment 1 35000 HCMEC D3
      4677   10     C  A02 115.70241      1000 1 : Experiment 1 35000 HCMEC D3
      4678   15     C  A02 114.49107      1000 1 : Experiment 1 35000 HCMEC D3
      4679   20     C  A02 114.35148      1000 1 : Experiment 1 35000 HCMEC D3
      4680   25     C  A02 114.65560      1000 1 : Experiment 1 35000 HCMEC D3
      4681   30     C  A02 115.10754      1000 1 : Experiment 1 35000 HCMEC D3
      4682   35     C  A02 115.62474      1000 1 : Experiment 1 35000 HCMEC D3
      4683   40     C  A02 116.46235      1000 1 : Experiment 1 35000 HCMEC D3
      4684   45     C  A02 117.28690      1000 1 : Experiment 1 35000 HCMEC D3
      4685   50     C  A02 118.01279      1000 1 : Experiment 1 35000 HCMEC D3
      4686   55     C  A02 118.49316      1000 1 : Experiment 1 35000 HCMEC D3
      4687   60     C  A02 119.12550      1000 1 : Experiment 1 35000 HCMEC D3
      4688   65     C  A02 119.76180      1000 1 : Experiment 1 35000 HCMEC D3
      4689   70     C  A02 120.20497      1000 1 : Experiment 1 35000 HCMEC D3
      4690   75     C  A02 120.60100      1000 1 : Experiment 1 35000 HCMEC D3
      4691   80     C  A02 120.88741      1000 1 : Experiment 1 35000 HCMEC D3
      4692   85     C  A02 121.29300      1000 1 : Experiment 1 35000 HCMEC D3
      4693   90     C  A02 121.60679      1000 1 : Experiment 1 35000 HCMEC D3
      4694   95     C  A02 121.89513      1000 1 : Experiment 1 35000 HCMEC D3
      4695  100     C  A02 122.14642      1000 1 : Experiment 1 35000 HCMEC D3
      4696  105     C  A02 122.43542      1000 1 : Experiment 1 35000 HCMEC D3
      4697  110     C  A02 122.72018      1000 1 : Experiment 1 35000 HCMEC D3
      4698  115     C  A02 122.94003      1000 1 : Experiment 1 35000 HCMEC D3
      4699  120     C  A02 123.10200      1000 1 : Experiment 1 35000 HCMEC D3
      4700  125     C  A02 123.30511      1000 1 : Experiment 1 35000 HCMEC D3
      4701  130     C  A02 123.56943      1000 1 : Experiment 1 35000 HCMEC D3
      4702  135     C  A02 123.78395      1000 1 : Experiment 1 35000 HCMEC D3
      4703  140     C  A02 124.02547      1000 1 : Experiment 1 35000 HCMEC D3
      4704  145     C  A02 124.22248      1000 1 : Experiment 1 35000 HCMEC D3
      4705  150     C  A02 124.37938      1000 1 : Experiment 1 35000 HCMEC D3
      4706  155     C  A02 124.47917      1000 1 : Experiment 1 35000 HCMEC D3
      4707  160     C  A02 124.68265      1000 1 : Experiment 1 35000 HCMEC D3
      4708  165     C  A02 124.82699      1000 1 : Experiment 1 35000 HCMEC D3
      4709  170     C  A02 124.92989      1000 1 : Experiment 1 35000 HCMEC D3
      4710  175     C  A02 124.99763      1000 1 : Experiment 1 35000 HCMEC D3
      4711  180     C  A02 125.16193      1000 1 : Experiment 1 35000 HCMEC D3
      4712  185     C  A02 125.34484      1000 1 : Experiment 1 35000 HCMEC D3
      4713  190     C  A02 125.40708      1000 1 : Experiment 1 35000 HCMEC D3
      4714  195     C  A02 125.48399      1000 1 : Experiment 1 35000 HCMEC D3
      4715  200     C  A02        NA      1000 1 : Experiment 1 35000 HCMEC D3
      4716    0     C  A02        NA     16000 1 : Experiment 1 35000 HCMEC D3
      4717    5     C  A02  75.59721     16000 1 : Experiment 1 35000 HCMEC D3
      4718   10     C  A02  63.34768     16000 1 : Experiment 1 35000 HCMEC D3
      4719   15     C  A02  53.42305     16000 1 : Experiment 1 35000 HCMEC D3
      4720   20     C  A02  47.97371     16000 1 : Experiment 1 35000 HCMEC D3
      4721   25     C  A02  45.19191     16000 1 : Experiment 1 35000 HCMEC D3
      4722   30     C  A02  43.26918     16000 1 : Experiment 1 35000 HCMEC D3
      4723   35     C  A02  42.52611     16000 1 : Experiment 1 35000 HCMEC D3
      4724   40     C  A02  42.09808     16000 1 : Experiment 1 35000 HCMEC D3
      4725   45     C  A02  41.87243     16000 1 : Experiment 1 35000 HCMEC D3
      4726   50     C  A02  42.02026     16000 1 : Experiment 1 35000 HCMEC D3
      4727   55     C  A02  42.50293     16000 1 : Experiment 1 35000 HCMEC D3
      4728   60     C  A02  42.70816     16000 1 : Experiment 1 35000 HCMEC D3
      4729   65     C  A02  43.53804     16000 1 : Experiment 1 35000 HCMEC D3
      4730   70     C  A02  44.58299     16000 1 : Experiment 1 35000 HCMEC D3
      4731   75     C  A02  45.51862     16000 1 : Experiment 1 35000 HCMEC D3
      4732   80     C  A02  46.37416     16000 1 : Experiment 1 35000 HCMEC D3
      4733   85     C  A02  47.92039     16000 1 : Experiment 1 35000 HCMEC D3
      4734   90     C  A02  49.43701     16000 1 : Experiment 1 35000 HCMEC D3
      4735   95     C  A02  51.13524     16000 1 : Experiment 1 35000 HCMEC D3
      4736  100     C  A02  52.69280     16000 1 : Experiment 1 35000 HCMEC D3
      4737  105     C  A02  54.05277     16000 1 : Experiment 1 35000 HCMEC D3
      4738  110     C  A02  55.42086     16000 1 : Experiment 1 35000 HCMEC D3
      4739  115     C  A02  56.98524     16000 1 : Experiment 1 35000 HCMEC D3
      4740  120     C  A02  58.28521     16000 1 : Experiment 1 35000 HCMEC D3
      4741  125     C  A02  59.81487     16000 1 : Experiment 1 35000 HCMEC D3
      4742  130     C  A02  61.20044     16000 1 : Experiment 1 35000 HCMEC D3
      4743  135     C  A02  62.82237     16000 1 : Experiment 1 35000 HCMEC D3
      4744  140     C  A02  64.33190     16000 1 : Experiment 1 35000 HCMEC D3
      4745  145     C  A02  65.99160     16000 1 : Experiment 1 35000 HCMEC D3
      4746  150     C  A02  67.01055     16000 1 : Experiment 1 35000 HCMEC D3
      4747  155     C  A02  67.88116     16000 1 : Experiment 1 35000 HCMEC D3
      4748  160     C  A02  69.35420     16000 1 : Experiment 1 35000 HCMEC D3
      4749  165     C  A02  70.49300     16000 1 : Experiment 1 35000 HCMEC D3
      4750  170     C  A02  71.61701     16000 1 : Experiment 1 35000 HCMEC D3
      4751  175     C  A02  72.24534     16000 1 : Experiment 1 35000 HCMEC D3
      4752  180     C  A02  73.12728     16000 1 : Experiment 1 35000 HCMEC D3
      4753  185     C  A02  74.56090     16000 1 : Experiment 1 35000 HCMEC D3
      4754  190     C  A02  75.41955     16000 1 : Experiment 1 35000 HCMEC D3
      4755  195     C  A02  76.07838     16000 1 : Experiment 1 35000 HCMEC D3
      4756  200     C  A02        NA     16000 1 : Experiment 1 35000 HCMEC D3
      4757    0     C  A02        NA      2000 1 : Experiment 1 35000 HCMEC D3
      4758    5     C  A02 111.75486      2000 1 : Experiment 1 35000 HCMEC D3
      4759   10     C  A02 107.92748      2000 1 : Experiment 1 35000 HCMEC D3
      4760   15     C  A02 104.76594      2000 1 : Experiment 1 35000 HCMEC D3
      4761   20     C  A02 103.93682      2000 1 : Experiment 1 35000 HCMEC D3
      4762   25     C  A02 103.82452      2000 1 : Experiment 1 35000 HCMEC D3
      4763   30     C  A02 104.38425      2000 1 : Experiment 1 35000 HCMEC D3
      4764   35     C  A02 105.13762      2000 1 : Experiment 1 35000 HCMEC D3
      4765   40     C  A02 106.62794      2000 1 : Experiment 1 35000 HCMEC D3
      4766   45     C  A02 108.09368      2000 1 : Experiment 1 35000 HCMEC D3
      4767   50     C  A02 109.21944      2000 1 : Experiment 1 35000 HCMEC D3
      4768   55     C  A02 109.96879      2000 1 : Experiment 1 35000 HCMEC D3
      4769   60     C  A02 110.96077      2000 1 : Experiment 1 35000 HCMEC D3
      4770   65     C  A02 111.80998      2000 1 : Experiment 1 35000 HCMEC D3
      4771   70     C  A02 112.54096      2000 1 : Experiment 1 35000 HCMEC D3
      4772   75     C  A02 113.07652      2000 1 : Experiment 1 35000 HCMEC D3
      4773   80     C  A02 113.47935      2000 1 : Experiment 1 35000 HCMEC D3
      4774   85     C  A02 114.25500      2000 1 : Experiment 1 35000 HCMEC D3
      4775   90     C  A02 114.82915      2000 1 : Experiment 1 35000 HCMEC D3
      4776   95     C  A02 115.40724      2000 1 : Experiment 1 35000 HCMEC D3
      4777  100     C  A02 115.90761      2000 1 : Experiment 1 35000 HCMEC D3
      4778  105     C  A02 116.40695      2000 1 : Experiment 1 35000 HCMEC D3
      4779  110     C  A02 116.93674      2000 1 : Experiment 1 35000 HCMEC D3
      4780  115     C  A02 117.34291      2000 1 : Experiment 1 35000 HCMEC D3
      4781  120     C  A02 117.66029      2000 1 : Experiment 1 35000 HCMEC D3
      4782  125     C  A02 118.06365      2000 1 : Experiment 1 35000 HCMEC D3
      4783  130     C  A02 118.57396      2000 1 : Experiment 1 35000 HCMEC D3
      4784  135     C  A02 118.99481      2000 1 : Experiment 1 35000 HCMEC D3
      4785  140     C  A02 119.47996      2000 1 : Experiment 1 35000 HCMEC D3
      4786  145     C  A02 119.93633      2000 1 : Experiment 1 35000 HCMEC D3
      4787  150     C  A02 120.22639      2000 1 : Experiment 1 35000 HCMEC D3
      4788  155     C  A02 120.43212      2000 1 : Experiment 1 35000 HCMEC D3
      4789  160     C  A02 120.86905      2000 1 : Experiment 1 35000 HCMEC D3
      4790  165     C  A02 121.13071      2000 1 : Experiment 1 35000 HCMEC D3
      4791  170     C  A02 121.34166      2000 1 : Experiment 1 35000 HCMEC D3
      4792  175     C  A02 121.43282      2000 1 : Experiment 1 35000 HCMEC D3
      4793  180     C  A02 121.79153      2000 1 : Experiment 1 35000 HCMEC D3
      4794  185     C  A02 122.23099      2000 1 : Experiment 1 35000 HCMEC D3
      4795  190     C  A02 122.39160      2000 1 : Experiment 1 35000 HCMEC D3
      4796  195     C  A02 122.53069      2000 1 : Experiment 1 35000 HCMEC D3
      4797  200     C  A02        NA      2000 1 : Experiment 1 35000 HCMEC D3
      4798    0     C  A02        NA       250 1 : Experiment 1 35000 HCMEC D3
      4799    5     C  A02 122.91601       250 1 : Experiment 1 35000 HCMEC D3
      4800   10     C  A02 122.52396       250 1 : Experiment 1 35000 HCMEC D3
      4801   15     C  A02 122.32011       250 1 : Experiment 1 35000 HCMEC D3
      4802   20     C  A02 122.44003       250 1 : Experiment 1 35000 HCMEC D3
      4803   25     C  A02 122.68900       250 1 : Experiment 1 35000 HCMEC D3
      4804   30     C  A02 122.96120       250 1 : Experiment 1 35000 HCMEC D3
      4805   35     C  A02 123.26946       250 1 : Experiment 1 35000 HCMEC D3
      4806   40     C  A02 123.63402       250 1 : Experiment 1 35000 HCMEC D3
      4807   45     C  A02 124.01620       250 1 : Experiment 1 35000 HCMEC D3
      4808   50     C  A02 124.39084       250 1 : Experiment 1 35000 HCMEC D3
      4809   55     C  A02 124.69670       250 1 : Experiment 1 35000 HCMEC D3
      4810   60     C  A02 125.00493       250 1 : Experiment 1 35000 HCMEC D3
      4811   65     C  A02 125.32222       250 1 : Experiment 1 35000 HCMEC D3
      4812   70     C  A02 125.56109       250 1 : Experiment 1 35000 HCMEC D3
      4813   75     C  A02 125.77337       250 1 : Experiment 1 35000 HCMEC D3
      4814   80     C  A02 125.97626       250 1 : Experiment 1 35000 HCMEC D3
      4815   85     C  A02 126.17798       250 1 : Experiment 1 35000 HCMEC D3
      4816   90     C  A02 126.34586       250 1 : Experiment 1 35000 HCMEC D3
      4817   95     C  A02 126.51078       250 1 : Experiment 1 35000 HCMEC D3
      4818  100     C  A02 126.66283       250 1 : Experiment 1 35000 HCMEC D3
      4819  105     C  A02 126.82158       250 1 : Experiment 1 35000 HCMEC D3
      4820  110     C  A02 126.95885       250 1 : Experiment 1 35000 HCMEC D3
      4821  115     C  A02 127.08530       250 1 : Experiment 1 35000 HCMEC D3
      4822  120     C  A02 127.21162       250 1 : Experiment 1 35000 HCMEC D3
      4823  125     C  A02 127.32815       250 1 : Experiment 1 35000 HCMEC D3
      4824  130     C  A02 127.43575       250 1 : Experiment 1 35000 HCMEC D3
      4825  135     C  A02 127.55530       250 1 : Experiment 1 35000 HCMEC D3
      4826  140     C  A02 127.65991       250 1 : Experiment 1 35000 HCMEC D3
      4827  145     C  A02 127.75551       250 1 : Experiment 1 35000 HCMEC D3
      4828  150     C  A02 127.84629       250 1 : Experiment 1 35000 HCMEC D3
      4829  155     C  A02 127.93887       250 1 : Experiment 1 35000 HCMEC D3
      4830  160     C  A02 128.01647       250 1 : Experiment 1 35000 HCMEC D3
      4831  165     C  A02 128.09959       250 1 : Experiment 1 35000 HCMEC D3
      4832  170     C  A02 128.16033       250 1 : Experiment 1 35000 HCMEC D3
      4833  175     C  A02 128.21668       250 1 : Experiment 1 35000 HCMEC D3
      4834  180     C  A02 128.27584       250 1 : Experiment 1 35000 HCMEC D3
      4835  185     C  A02 128.32706       250 1 : Experiment 1 35000 HCMEC D3
      4836  190     C  A02 128.36328       250 1 : Experiment 1 35000 HCMEC D3
      4837  195     C  A02 128.39348       250 1 : Experiment 1 35000 HCMEC D3
      4838  200     C  A02        NA       250 1 : Experiment 1 35000 HCMEC D3
      4839    0     C  A02        NA     32000 1 : Experiment 1 35000 HCMEC D3
      4840    5     C  A02  62.48397     32000 1 : Experiment 1 35000 HCMEC D3
      4841   10     C  A02  49.93819     32000 1 : Experiment 1 35000 HCMEC D3
      4842   15     C  A02  39.47179     32000 1 : Experiment 1 35000 HCMEC D3
      4843   20     C  A02  33.18358     32000 1 : Experiment 1 35000 HCMEC D3
      4844   25     C  A02  30.02368     32000 1 : Experiment 1 35000 HCMEC D3
      4845   30     C  A02  27.49747     32000 1 : Experiment 1 35000 HCMEC D3
      4846   35     C  A02  25.89151     32000 1 : Experiment 1 35000 HCMEC D3
      4847   40     C  A02  23.79984     32000 1 : Experiment 1 35000 HCMEC D3
      4848   45     C  A02  22.42341     32000 1 : Experiment 1 35000 HCMEC D3
      4849   50     C  A02  21.76919     32000 1 : Experiment 1 35000 HCMEC D3
      4850   55     C  A02  21.65167     32000 1 : Experiment 1 35000 HCMEC D3
      4851   60     C  A02  21.53631     32000 1 : Experiment 1 35000 HCMEC D3
      4852   65     C  A02  21.89250     32000 1 : Experiment 1 35000 HCMEC D3
      4853   70     C  A02  22.38358     32000 1 : Experiment 1 35000 HCMEC D3
      4854   75     C  A02  22.96132     32000 1 : Experiment 1 35000 HCMEC D3
      4855   80     C  A02  23.40862     32000 1 : Experiment 1 35000 HCMEC D3
      4856   85     C  A02  24.37793     32000 1 : Experiment 1 35000 HCMEC D3
      4857   90     C  A02  25.37897     32000 1 : Experiment 1 35000 HCMEC D3
      4858   95     C  A02  26.42383     32000 1 : Experiment 1 35000 HCMEC D3
      4859  100     C  A02  27.49869     32000 1 : Experiment 1 35000 HCMEC D3
      4860  105     C  A02  28.51028     32000 1 : Experiment 1 35000 HCMEC D3
      4861  110     C  A02  29.36623     32000 1 : Experiment 1 35000 HCMEC D3
      4862  115     C  A02  30.58884     32000 1 : Experiment 1 35000 HCMEC D3
      4863  120     C  A02  31.63880     32000 1 : Experiment 1 35000 HCMEC D3
      4864  125     C  A02  32.81640     32000 1 : Experiment 1 35000 HCMEC D3
      4865  130     C  A02  34.01755     32000 1 : Experiment 1 35000 HCMEC D3
      4866  135     C  A02  35.24990     32000 1 : Experiment 1 35000 HCMEC D3
      4867  140     C  A02  36.59819     32000 1 : Experiment 1 35000 HCMEC D3
      4868  145     C  A02  38.02091     32000 1 : Experiment 1 35000 HCMEC D3
      4869  150     C  A02  38.90798     32000 1 : Experiment 1 35000 HCMEC D3
      4870  155     C  A02  39.81059     32000 1 : Experiment 1 35000 HCMEC D3
      4871  160     C  A02  41.15959     32000 1 : Experiment 1 35000 HCMEC D3
      4872  165     C  A02  42.28495     32000 1 : Experiment 1 35000 HCMEC D3
      4873  170     C  A02  43.60895     32000 1 : Experiment 1 35000 HCMEC D3
      4874  175     C  A02  44.45037     32000 1 : Experiment 1 35000 HCMEC D3
      4875  180     C  A02  45.33946     32000 1 : Experiment 1 35000 HCMEC D3
      4876  185     C  A02  46.74633     32000 1 : Experiment 1 35000 HCMEC D3
      4877  190     C  A02  47.76807     32000 1 : Experiment 1 35000 HCMEC D3
      4878  195     C  A02  48.77086     32000 1 : Experiment 1 35000 HCMEC D3
      4879  200     C  A02        NA     32000 1 : Experiment 1 35000 HCMEC D3
      4880    0     C  A02        NA      4000 1 : Experiment 1 35000 HCMEC D3
      4881    5     C  A02 102.47403      4000 1 : Experiment 1 35000 HCMEC D3
      4882   10     C  A02  95.39733      4000 1 : Experiment 1 35000 HCMEC D3
      4883   15     C  A02  89.73144      4000 1 : Experiment 1 35000 HCMEC D3
      4884   20     C  A02  87.81246      4000 1 : Experiment 1 35000 HCMEC D3
      4885   25     C  A02  86.92457      4000 1 : Experiment 1 35000 HCMEC D3
      4886   30     C  A02  87.09611      4000 1 : Experiment 1 35000 HCMEC D3
      4887   35     C  A02  87.92794      4000 1 : Experiment 1 35000 HCMEC D3
      4888   40     C  A02  89.96883      4000 1 : Experiment 1 35000 HCMEC D3
      4889   45     C  A02  91.88145      4000 1 : Experiment 1 35000 HCMEC D3
      4890   50     C  A02  93.40100      4000 1 : Experiment 1 35000 HCMEC D3
      4891   55     C  A02  94.60065      4000 1 : Experiment 1 35000 HCMEC D3
      4892   60     C  A02  95.81250      4000 1 : Experiment 1 35000 HCMEC D3
      4893   65     C  A02  96.98878      4000 1 : Experiment 1 35000 HCMEC D3
      4894   70     C  A02  98.17984      4000 1 : Experiment 1 35000 HCMEC D3
      4895   75     C  A02  98.91973      4000 1 : Experiment 1 35000 HCMEC D3
      4896   80     C  A02  99.59053      4000 1 : Experiment 1 35000 HCMEC D3
      4897   85     C  A02 100.85839      4000 1 : Experiment 1 35000 HCMEC D3
      4898   90     C  A02 101.77363      4000 1 : Experiment 1 35000 HCMEC D3
      4899   95     C  A02 102.80891      4000 1 : Experiment 1 35000 HCMEC D3
      4900  100     C  A02 103.71030      4000 1 : Experiment 1 35000 HCMEC D3
      4901  105     C  A02 104.41681      4000 1 : Experiment 1 35000 HCMEC D3
      4902  110     C  A02 105.29858      4000 1 : Experiment 1 35000 HCMEC D3
      4903  115     C  A02 105.98910      4000 1 : Experiment 1 35000 HCMEC D3
      4904  120     C  A02 106.52668      4000 1 : Experiment 1 35000 HCMEC D3
      4905  125     C  A02 107.26717      4000 1 : Experiment 1 35000 HCMEC D3
      4906  130     C  A02 108.01271      4000 1 : Experiment 1 35000 HCMEC D3
      4907  135     C  A02 108.76433      4000 1 : Experiment 1 35000 HCMEC D3
      4908  140     C  A02 109.56337      4000 1 : Experiment 1 35000 HCMEC D3
      4909  145     C  A02 110.41373      4000 1 : Experiment 1 35000 HCMEC D3
      4910  150     C  A02 110.88943      4000 1 : Experiment 1 35000 HCMEC D3
      4911  155     C  A02 111.25800      4000 1 : Experiment 1 35000 HCMEC D3
      4912  160     C  A02 112.02105      4000 1 : Experiment 1 35000 HCMEC D3
      4913  165     C  A02 112.45939      4000 1 : Experiment 1 35000 HCMEC D3
      4914  170     C  A02 112.82087      4000 1 : Experiment 1 35000 HCMEC D3
      4915  175     C  A02 112.95894      4000 1 : Experiment 1 35000 HCMEC D3
      4916  180     C  A02 113.53227      4000 1 : Experiment 1 35000 HCMEC D3
      4917  185     C  A02 114.30658      4000 1 : Experiment 1 35000 HCMEC D3
      4918  190     C  A02 114.63919      4000 1 : Experiment 1 35000 HCMEC D3
      4919  195     C  A02 114.86193      4000 1 : Experiment 1 35000 HCMEC D3
      4920  200     C  A02        NA      4000 1 : Experiment 1 35000 HCMEC D3
      4921    0     C  A02        NA       500 1 : Experiment 1 35000 HCMEC D3
      4922    5     C  A02 120.54442       500 1 : Experiment 1 35000 HCMEC D3
      4923   10     C  A02 119.99490       500 1 : Experiment 1 35000 HCMEC D3
      4924   15     C  A02 119.58659       500 1 : Experiment 1 35000 HCMEC D3
      4925   20     C  A02 119.65247       500 1 : Experiment 1 35000 HCMEC D3
      4926   25     C  A02 119.97956       500 1 : Experiment 1 35000 HCMEC D3
      4927   30     C  A02 120.32462       500 1 : Experiment 1 35000 HCMEC D3
      4928   35     C  A02 120.70079       500 1 : Experiment 1 35000 HCMEC D3
      4929   40     C  A02 121.20956       500 1 : Experiment 1 35000 HCMEC D3
      4930   45     C  A02 121.71093       500 1 : Experiment 1 35000 HCMEC D3
      4931   50     C  A02 122.19421       500 1 : Experiment 1 35000 HCMEC D3
      4932   55     C  A02 122.55343       500 1 : Experiment 1 35000 HCMEC D3
      4933   60     C  A02 122.95200       500 1 : Experiment 1 35000 HCMEC D3
      4934   65     C  A02 123.39715       500 1 : Experiment 1 35000 HCMEC D3
      4935   70     C  A02 123.69996       500 1 : Experiment 1 35000 HCMEC D3
      4936   75     C  A02 123.96471       500 1 : Experiment 1 35000 HCMEC D3
      4937   80     C  A02 124.18138       500 1 : Experiment 1 35000 HCMEC D3
      4938   85     C  A02 124.43008       500 1 : Experiment 1 35000 HCMEC D3
      4939   90     C  A02 124.63836       500 1 : Experiment 1 35000 HCMEC D3
      4940   95     C  A02 124.82699       500 1 : Experiment 1 35000 HCMEC D3
      4941  100     C  A02 125.01056       500 1 : Experiment 1 35000 HCMEC D3
      4942  105     C  A02 125.19766       500 1 : Experiment 1 35000 HCMEC D3
      4943  110     C  A02 125.37607       500 1 : Experiment 1 35000 HCMEC D3
      4944  115     C  A02 125.51711       500 1 : Experiment 1 35000 HCMEC D3
      4945  120     C  A02 125.65867       500 1 : Experiment 1 35000 HCMEC D3
      4946  125     C  A02 125.79377       500 1 : Experiment 1 35000 HCMEC D3
      4947  130     C  A02 125.94888       500 1 : Experiment 1 35000 HCMEC D3
      4948  135     C  A02 126.08041       500 1 : Experiment 1 35000 HCMEC D3
      4949  140     C  A02 126.21546       500 1 : Experiment 1 35000 HCMEC D3
      4950  145     C  A02 126.32909       500 1 : Experiment 1 35000 HCMEC D3
      4951  150     C  A02 126.43403       500 1 : Experiment 1 35000 HCMEC D3
      4952  155     C  A02 126.53361       500 1 : Experiment 1 35000 HCMEC D3
      4953  160     C  A02 126.64321       500 1 : Experiment 1 35000 HCMEC D3
      4954  165     C  A02 126.73212       500 1 : Experiment 1 35000 HCMEC D3
      4955  170     C  A02 126.80611       500 1 : Experiment 1 35000 HCMEC D3
      4956  175     C  A02 126.86426       500 1 : Experiment 1 35000 HCMEC D3
      4957  180     C  A02 126.94783       500 1 : Experiment 1 35000 HCMEC D3
      4958  185     C  A02 127.03479       500 1 : Experiment 1 35000 HCMEC D3
      4959  190     C  A02 127.07015       500 1 : Experiment 1 35000 HCMEC D3
      4960  195     C  A02 127.10760       500 1 : Experiment 1 35000 HCMEC D3
      4961  200     C  A02        NA       500 1 : Experiment 1 35000 HCMEC D3
      4962    0     C  A02        NA     64000 1 : Experiment 1 35000 HCMEC D3
      4963    5     C  A02  47.18325     64000 1 : Experiment 1 35000 HCMEC D3
      4964   10     C  A02  37.02599     64000 1 : Experiment 1 35000 HCMEC D3
      4965   15     C  A02  28.15502     64000 1 : Experiment 1 35000 HCMEC D3
      4966   20     C  A02  22.52256     64000 1 : Experiment 1 35000 HCMEC D3
      4967   25     C  A02  19.73266     64000 1 : Experiment 1 35000 HCMEC D3
      4968   30     C  A02  17.36838     64000 1 : Experiment 1 35000 HCMEC D3
      4969   35     C  A02  15.59026     64000 1 : Experiment 1 35000 HCMEC D3
      4970   40     C  A02  13.14130     64000 1 : Experiment 1 35000 HCMEC D3
      4971   45     C  A02  11.75151     64000 1 : Experiment 1 35000 HCMEC D3
      4972   50     C  A02  11.16185     64000 1 : Experiment 1 35000 HCMEC D3
      4973   55     C  A02  11.00064     64000 1 : Experiment 1 35000 HCMEC D3
      4974   60     C  A02  10.93658     64000 1 : Experiment 1 35000 HCMEC D3
      4975   65     C  A02  11.07334     64000 1 : Experiment 1 35000 HCMEC D3
      4976   70     C  A02  11.26068     64000 1 : Experiment 1 35000 HCMEC D3
      4977   75     C  A02  11.52518     64000 1 : Experiment 1 35000 HCMEC D3
      4978   80     C  A02  11.67687     64000 1 : Experiment 1 35000 HCMEC D3
      4979   85     C  A02  12.09968     64000 1 : Experiment 1 35000 HCMEC D3
      4980   90     C  A02  12.57562     64000 1 : Experiment 1 35000 HCMEC D3
      4981   95     C  A02  12.96615     64000 1 : Experiment 1 35000 HCMEC D3
      4982  100     C  A02  13.44330     64000 1 : Experiment 1 35000 HCMEC D3
      4983  105     C  A02  13.93475     64000 1 : Experiment 1 35000 HCMEC D3
      4984  110     C  A02  14.25523     64000 1 : Experiment 1 35000 HCMEC D3
      4985  115     C  A02  14.86485     64000 1 : Experiment 1 35000 HCMEC D3
      4986  120     C  A02  15.37402     64000 1 : Experiment 1 35000 HCMEC D3
      4987  125     C  A02  15.97260     64000 1 : Experiment 1 35000 HCMEC D3
      4988  130     C  A02  16.57023     64000 1 : Experiment 1 35000 HCMEC D3
      4989  135     C  A02  17.16611     64000 1 : Experiment 1 35000 HCMEC D3
      4990  140     C  A02  17.87636     64000 1 : Experiment 1 35000 HCMEC D3
      4991  145     C  A02  18.63761     64000 1 : Experiment 1 35000 HCMEC D3
      4992  150     C  A02  19.06418     64000 1 : Experiment 1 35000 HCMEC D3
      4993  155     C  A02  19.65871     64000 1 : Experiment 1 35000 HCMEC D3
      4994  160     C  A02  20.39463     64000 1 : Experiment 1 35000 HCMEC D3
      4995  165     C  A02  21.05449     64000 1 : Experiment 1 35000 HCMEC D3
      4996  170     C  A02  21.95193     64000 1 : Experiment 1 35000 HCMEC D3
      4997  175     C  A02  22.54167     64000 1 : Experiment 1 35000 HCMEC D3
      4998  180     C  A02  23.19637     64000 1 : Experiment 1 35000 HCMEC D3
      4999  185     C  A02  24.10706     64000 1 : Experiment 1 35000 HCMEC D3
      5000  190     C  A02  24.76939     64000 1 : Experiment 1 35000 HCMEC D3
      5001  195     C  A02  25.67945     64000 1 : Experiment 1 35000 HCMEC D3
      5002  200     C  A02        NA     64000 1 : Experiment 1 35000 HCMEC D3
      5003    0     C  A02        NA      8000 1 : Experiment 1 35000 HCMEC D3
      5004    5     C  A02  89.05617      8000 1 : Experiment 1 35000 HCMEC D3
      5005   10     C  A02  78.98141      8000 1 : Experiment 1 35000 HCMEC D3
      5006   15     C  A02  70.99549      8000 1 : Experiment 1 35000 HCMEC D3
      5007   20     C  A02  67.33588      8000 1 : Experiment 1 35000 HCMEC D3
      5008   25     C  A02  65.38854      8000 1 : Experiment 1 35000 HCMEC D3
      5009   30     C  A02  64.57370      8000 1 : Experiment 1 35000 HCMEC D3
      5010   35     C  A02  64.95723      8000 1 : Experiment 1 35000 HCMEC D3
      5011   40     C  A02  66.45491      8000 1 : Experiment 1 35000 HCMEC D3
      5012   45     C  A02  67.83357      8000 1 : Experiment 1 35000 HCMEC D3
      5013   50     C  A02  69.13714      8000 1 : Experiment 1 35000 HCMEC D3
      5014   55     C  A02  70.33780      8000 1 : Experiment 1 35000 HCMEC D3
      5015   60     C  A02  71.20469      8000 1 : Experiment 1 35000 HCMEC D3
      5016   65     C  A02  72.47491      8000 1 : Experiment 1 35000 HCMEC D3
      5017   70     C  A02  73.87417      8000 1 : Experiment 1 35000 HCMEC D3
      5018   75     C  A02  74.79107      8000 1 : Experiment 1 35000 HCMEC D3
      5019   80     C  A02  75.73364      8000 1 : Experiment 1 35000 HCMEC D3
      5020   85     C  A02  77.36926      8000 1 : Experiment 1 35000 HCMEC D3
      5021   90     C  A02  78.74388      8000 1 : Experiment 1 35000 HCMEC D3
      5022   95     C  A02  80.34927      8000 1 : Experiment 1 35000 HCMEC D3
      5023  100     C  A02  81.77920      8000 1 : Experiment 1 35000 HCMEC D3
      5024  105     C  A02  82.83536      8000 1 : Experiment 1 35000 HCMEC D3
      5025  110     C  A02  84.13400      8000 1 : Experiment 1 35000 HCMEC D3
      5026  115     C  A02  85.31203      8000 1 : Experiment 1 35000 HCMEC D3
      5027  120     C  A02  86.24959      8000 1 : Experiment 1 35000 HCMEC D3
      5028  125     C  A02  87.47588      8000 1 : Experiment 1 35000 HCMEC D3
      5029  130     C  A02  88.56722      8000 1 : Experiment 1 35000 HCMEC D3
      5030  135     C  A02  89.84370      8000 1 : Experiment 1 35000 HCMEC D3
      5031  140     C  A02  91.02331      8000 1 : Experiment 1 35000 HCMEC D3
      5032  145     C  A02  92.40510      8000 1 : Experiment 1 35000 HCMEC D3
      5033  150     C  A02  93.15989      8000 1 : Experiment 1 35000 HCMEC D3
      5034  155     C  A02  93.74154      8000 1 : Experiment 1 35000 HCMEC D3
      5035  160     C  A02  94.86760      8000 1 : Experiment 1 35000 HCMEC D3
      5036  165     C  A02  95.56667      8000 1 : Experiment 1 35000 HCMEC D3
      5037  170     C  A02  96.25010      8000 1 : Experiment 1 35000 HCMEC D3
      5038  175     C  A02  96.49753      8000 1 : Experiment 1 35000 HCMEC D3
      5039  180     C  A02  97.21776      8000 1 : Experiment 1 35000 HCMEC D3
      5040  185     C  A02  98.32557      8000 1 : Experiment 1 35000 HCMEC D3
      5041  190     C  A02  98.86513      8000 1 : Experiment 1 35000 HCMEC D3
      5042  195     C  A02  99.18570      8000 1 : Experiment 1 35000 HCMEC D3
      5043  200     C  A02        NA      8000 1 : Experiment 1 35000 HCMEC D3
      5044    0     C  A03        NA      1000 1 : Experiment 1 35000 HCMEC D3
      5045    5     C  A03 118.06626      1000 1 : Experiment 1 35000 HCMEC D3
      5046   10     C  A03 117.22765      1000 1 : Experiment 1 35000 HCMEC D3
      5047   15     C  A03 115.77691      1000 1 : Experiment 1 35000 HCMEC D3
      5048   20     C  A03 115.30408      1000 1 : Experiment 1 35000 HCMEC D3
      5049   25     C  A03 115.22148      1000 1 : Experiment 1 35000 HCMEC D3
      5050   30     C  A03 115.84586      1000 1 : Experiment 1 35000 HCMEC D3
      5051   35     C  A03 116.38068      1000 1 : Experiment 1 35000 HCMEC D3
      5052   40     C  A03 117.08894      1000 1 : Experiment 1 35000 HCMEC D3
      5053   45     C  A03 117.78619      1000 1 : Experiment 1 35000 HCMEC D3
      5054   50     C  A03 118.51341      1000 1 : Experiment 1 35000 HCMEC D3
      5055   55     C  A03 119.20349      1000 1 : Experiment 1 35000 HCMEC D3
      5056   60     C  A03 119.88700      1000 1 : Experiment 1 35000 HCMEC D3
      5057   65     C  A03 120.44896      1000 1 : Experiment 1 35000 HCMEC D3
      5058   70     C  A03 120.94278      1000 1 : Experiment 1 35000 HCMEC D3
      5059   75     C  A03 121.36597      1000 1 : Experiment 1 35000 HCMEC D3
      5060   80     C  A03 121.70477      1000 1 : Experiment 1 35000 HCMEC D3
      5061   85     C  A03 122.08047      1000 1 : Experiment 1 35000 HCMEC D3
      5062   90     C  A03 122.47411      1000 1 : Experiment 1 35000 HCMEC D3
      5063   95     C  A03 122.70517      1000 1 : Experiment 1 35000 HCMEC D3
      5064  100     C  A03 122.98384      1000 1 : Experiment 1 35000 HCMEC D3
      5065  105     C  A03 123.21737      1000 1 : Experiment 1 35000 HCMEC D3
      5066  110     C  A03 123.41130      1000 1 : Experiment 1 35000 HCMEC D3
      5067  115     C  A03 123.68831      1000 1 : Experiment 1 35000 HCMEC D3
      5068  120     C  A03 123.93290      1000 1 : Experiment 1 35000 HCMEC D3
      5069  125     C  A03 124.13951      1000 1 : Experiment 1 35000 HCMEC D3
      5070  130     C  A03 124.35583      1000 1 : Experiment 1 35000 HCMEC D3
      5071  135     C  A03 124.57121      1000 1 : Experiment 1 35000 HCMEC D3
      5072  140     C  A03 124.73801      1000 1 : Experiment 1 35000 HCMEC D3
      5073  145     C  A03 124.95601      1000 1 : Experiment 1 35000 HCMEC D3
      5074  150     C  A03 125.13580      1000 1 : Experiment 1 35000 HCMEC D3
      5075  155     C  A03 125.37015      1000 1 : Experiment 1 35000 HCMEC D3
      5076  160     C  A03 125.60941      1000 1 : Experiment 1 35000 HCMEC D3
      5077  165     C  A03 125.78399      1000 1 : Experiment 1 35000 HCMEC D3
      5078  170     C  A03 125.98173      1000 1 : Experiment 1 35000 HCMEC D3
      5079  175     C  A03 126.14276      1000 1 : Experiment 1 35000 HCMEC D3
      5080  180     C  A03 126.27197      1000 1 : Experiment 1 35000 HCMEC D3
      5081  185     C  A03 126.42326      1000 1 : Experiment 1 35000 HCMEC D3
      5082  190     C  A03 126.55670      1000 1 : Experiment 1 35000 HCMEC D3
      5083  195     C  A03 126.64011      1000 1 : Experiment 1 35000 HCMEC D3
      5084  200     C  A03        NA      1000 1 : Experiment 1 35000 HCMEC D3
      5085    0     C  A03        NA     16000 1 : Experiment 1 35000 HCMEC D3
      5086    5     C  A03  79.35875     16000 1 : Experiment 1 35000 HCMEC D3
      5087   10     C  A03  71.16109     16000 1 : Experiment 1 35000 HCMEC D3
      5088   15     C  A03  60.62088     16000 1 : Experiment 1 35000 HCMEC D3
      5089   20     C  A03  53.72353     16000 1 : Experiment 1 35000 HCMEC D3
      5090   25     C  A03  48.88170     16000 1 : Experiment 1 35000 HCMEC D3
      5091   30     C  A03  46.35717     16000 1 : Experiment 1 35000 HCMEC D3
      5092   35     C  A03  45.13368     16000 1 : Experiment 1 35000 HCMEC D3
      5093   40     C  A03  43.87975     16000 1 : Experiment 1 35000 HCMEC D3
      5094   45     C  A03  43.37920     16000 1 : Experiment 1 35000 HCMEC D3
      5095   50     C  A03  43.32112     16000 1 : Experiment 1 35000 HCMEC D3
      5096   55     C  A03  43.81949     16000 1 : Experiment 1 35000 HCMEC D3
      5097   60     C  A03  44.51485     16000 1 : Experiment 1 35000 HCMEC D3
      5098   65     C  A03  45.60465     16000 1 : Experiment 1 35000 HCMEC D3
      5099   70     C  A03  45.88300     16000 1 : Experiment 1 35000 HCMEC D3
      5100   75     C  A03  47.19652     16000 1 : Experiment 1 35000 HCMEC D3
      5101   80     C  A03  48.19147     16000 1 : Experiment 1 35000 HCMEC D3
      5102   85     C  A03  49.35851     16000 1 : Experiment 1 35000 HCMEC D3
      5103   90     C  A03  50.93503     16000 1 : Experiment 1 35000 HCMEC D3
      5104   95     C  A03  52.15264     16000 1 : Experiment 1 35000 HCMEC D3
      5105  100     C  A03  53.71555     16000 1 : Experiment 1 35000 HCMEC D3
      5106  105     C  A03  55.10267     16000 1 : Experiment 1 35000 HCMEC D3
      5107  110     C  A03  56.40627     16000 1 : Experiment 1 35000 HCMEC D3
      5108  115     C  A03  58.14183     16000 1 : Experiment 1 35000 HCMEC D3
      5109  120     C  A03  59.40320     16000 1 : Experiment 1 35000 HCMEC D3
      5110  125     C  A03  60.56633     16000 1 : Experiment 1 35000 HCMEC D3
      5111  130     C  A03  62.16513     16000 1 : Experiment 1 35000 HCMEC D3
      5112  135     C  A03  63.31815     16000 1 : Experiment 1 35000 HCMEC D3
      5113  140     C  A03  64.56734     16000 1 : Experiment 1 35000 HCMEC D3
      5114  145     C  A03  66.03018     16000 1 : Experiment 1 35000 HCMEC D3
      5115  150     C  A03  67.14481     16000 1 : Experiment 1 35000 HCMEC D3
      5116  155     C  A03  68.83087     16000 1 : Experiment 1 35000 HCMEC D3
      5117  160     C  A03  70.26045     16000 1 : Experiment 1 35000 HCMEC D3
      5118  165     C  A03  71.75029     16000 1 : Experiment 1 35000 HCMEC D3
      5119  170     C  A03  72.79587     16000 1 : Experiment 1 35000 HCMEC D3
      5120  175     C  A03  74.07287     16000 1 : Experiment 1 35000 HCMEC D3
      5121  180     C  A03  74.94612     16000 1 : Experiment 1 35000 HCMEC D3
      5122  185     C  A03  76.41746     16000 1 : Experiment 1 35000 HCMEC D3
      5123  190     C  A03  77.78857     16000 1 : Experiment 1 35000 HCMEC D3
      5124  195     C  A03  78.70812     16000 1 : Experiment 1 35000 HCMEC D3
      5125  200     C  A03        NA     16000 1 : Experiment 1 35000 HCMEC D3
      5126    0     C  A03        NA      2000 1 : Experiment 1 35000 HCMEC D3
      5127    5     C  A03 112.86843      2000 1 : Experiment 1 35000 HCMEC D3
      5128   10     C  A03 110.51160      2000 1 : Experiment 1 35000 HCMEC D3
      5129   15     C  A03 106.93893      2000 1 : Experiment 1 35000 HCMEC D3
      5130   20     C  A03 105.22721      2000 1 : Experiment 1 35000 HCMEC D3
      5131   25     C  A03 104.39545      2000 1 : Experiment 1 35000 HCMEC D3
      5132   30     C  A03 105.00159      2000 1 : Experiment 1 35000 HCMEC D3
      5133   35     C  A03 105.74282      2000 1 : Experiment 1 35000 HCMEC D3
      5134   40     C  A03 106.67323      2000 1 : Experiment 1 35000 HCMEC D3
      5135   45     C  A03 107.97117      2000 1 : Experiment 1 35000 HCMEC D3
      5136   50     C  A03 109.19989      2000 1 : Experiment 1 35000 HCMEC D3
      5137   55     C  A03 110.42675      2000 1 : Experiment 1 35000 HCMEC D3
      5138   60     C  A03 111.62942      2000 1 : Experiment 1 35000 HCMEC D3
      5139   65     C  A03 112.60559      2000 1 : Experiment 1 35000 HCMEC D3
      5140   70     C  A03 113.36362      2000 1 : Experiment 1 35000 HCMEC D3
      5141   75     C  A03 114.09173      2000 1 : Experiment 1 35000 HCMEC D3
      5142   80     C  A03 114.67442      2000 1 : Experiment 1 35000 HCMEC D3
      5143   85     C  A03 115.27689      2000 1 : Experiment 1 35000 HCMEC D3
      5144   90     C  A03 115.97831      2000 1 : Experiment 1 35000 HCMEC D3
      5145   95     C  A03 116.35695      2000 1 : Experiment 1 35000 HCMEC D3
      5146  100     C  A03 116.88866      2000 1 : Experiment 1 35000 HCMEC D3
      5147  105     C  A03 117.35390      2000 1 : Experiment 1 35000 HCMEC D3
      5148  110     C  A03 117.64494      2000 1 : Experiment 1 35000 HCMEC D3
      5149  115     C  A03 118.23572      2000 1 : Experiment 1 35000 HCMEC D3
      5150  120     C  A03 118.65509      2000 1 : Experiment 1 35000 HCMEC D3
      5151  125     C  A03 118.97954      2000 1 : Experiment 1 35000 HCMEC D3
      5152  130     C  A03 119.41292      2000 1 : Experiment 1 35000 HCMEC D3
      5153  135     C  A03 119.78051      2000 1 : Experiment 1 35000 HCMEC D3
      5154  140     C  A03 120.08262      2000 1 : Experiment 1 35000 HCMEC D3
      5155  145     C  A03 120.53552      2000 1 : Experiment 1 35000 HCMEC D3
      5156  150     C  A03 120.87666      2000 1 : Experiment 1 35000 HCMEC D3
      5157  155     C  A03 121.32852      2000 1 : Experiment 1 35000 HCMEC D3
      5158  160     C  A03 121.84709      2000 1 : Experiment 1 35000 HCMEC D3
      5159  165     C  A03 122.21751      2000 1 : Experiment 1 35000 HCMEC D3
      5160  170     C  A03 122.59968      2000 1 : Experiment 1 35000 HCMEC D3
      5161  175     C  A03 122.92345      2000 1 : Experiment 1 35000 HCMEC D3
      5162  180     C  A03 123.13256      2000 1 : Experiment 1 35000 HCMEC D3
      5163  185     C  A03 123.46889      2000 1 : Experiment 1 35000 HCMEC D3
      5164  190     C  A03 123.80711      2000 1 : Experiment 1 35000 HCMEC D3
      5165  195     C  A03 123.98380      2000 1 : Experiment 1 35000 HCMEC D3
      5166  200     C  A03        NA      2000 1 : Experiment 1 35000 HCMEC D3
      5167    0     C  A03        NA       250 1 : Experiment 1 35000 HCMEC D3
      5168    5     C  A03 123.61705       250 1 : Experiment 1 35000 HCMEC D3
      5169   10     C  A03 123.40468       250 1 : Experiment 1 35000 HCMEC D3
      5170   15     C  A03 123.10083       250 1 : Experiment 1 35000 HCMEC D3
      5171   20     C  A03 123.18798       250 1 : Experiment 1 35000 HCMEC D3
      5172   25     C  A03 123.40516       250 1 : Experiment 1 35000 HCMEC D3
      5173   30     C  A03 123.75502       250 1 : Experiment 1 35000 HCMEC D3
      5174   35     C  A03 124.01799       250 1 : Experiment 1 35000 HCMEC D3
      5175   40     C  A03 124.33309       250 1 : Experiment 1 35000 HCMEC D3
      5176   45     C  A03 124.67257       250 1 : Experiment 1 35000 HCMEC D3
      5177   50     C  A03 125.00728       250 1 : Experiment 1 35000 HCMEC D3
      5178   55     C  A03 125.32972       250 1 : Experiment 1 35000 HCMEC D3
      5179   60     C  A03 125.64068       250 1 : Experiment 1 35000 HCMEC D3
      5180   65     C  A03 125.91985       250 1 : Experiment 1 35000 HCMEC D3
      5181   70     C  A03 126.18659       250 1 : Experiment 1 35000 HCMEC D3
      5182   75     C  A03 126.42782       250 1 : Experiment 1 35000 HCMEC D3
      5183   80     C  A03 126.64073       250 1 : Experiment 1 35000 HCMEC D3
      5184   85     C  A03 126.84899       250 1 : Experiment 1 35000 HCMEC D3
      5185   90     C  A03 127.04044       250 1 : Experiment 1 35000 HCMEC D3
      5186   95     C  A03 127.21381       250 1 : Experiment 1 35000 HCMEC D3
      5187  100     C  A03 127.38453       250 1 : Experiment 1 35000 HCMEC D3
      5188  105     C  A03 127.54959       250 1 : Experiment 1 35000 HCMEC D3
      5189  110     C  A03 127.68824       250 1 : Experiment 1 35000 HCMEC D3
      5190  115     C  A03 127.84028       250 1 : Experiment 1 35000 HCMEC D3
      5191  120     C  A03 127.96904       250 1 : Experiment 1 35000 HCMEC D3
      5192  125     C  A03 128.10983       250 1 : Experiment 1 35000 HCMEC D3
      5193  130     C  A03 128.23389       250 1 : Experiment 1 35000 HCMEC D3
      5194  135     C  A03 128.35780       250 1 : Experiment 1 35000 HCMEC D3
      5195  140     C  A03 128.47755       250 1 : Experiment 1 35000 HCMEC D3
      5196  145     C  A03 128.59528       250 1 : Experiment 1 35000 HCMEC D3
      5197  150     C  A03 128.70226       250 1 : Experiment 1 35000 HCMEC D3
      5198  155     C  A03 128.82203       250 1 : Experiment 1 35000 HCMEC D3
      5199  160     C  A03 128.92583       250 1 : Experiment 1 35000 HCMEC D3
      5200  165     C  A03 129.02396       250 1 : Experiment 1 35000 HCMEC D3
      5201  170     C  A03 129.11924       250 1 : Experiment 1 35000 HCMEC D3
      5202  175     C  A03 129.22616       250 1 : Experiment 1 35000 HCMEC D3
      5203  180     C  A03 129.29032       250 1 : Experiment 1 35000 HCMEC D3
      5204  185     C  A03 129.35838       250 1 : Experiment 1 35000 HCMEC D3
      5205  190     C  A03 129.42065       250 1 : Experiment 1 35000 HCMEC D3
      5206  195     C  A03 129.47791       250 1 : Experiment 1 35000 HCMEC D3
      5207  200     C  A03        NA       250 1 : Experiment 1 35000 HCMEC D3
      5208    0     C  A03        NA     32000 1 : Experiment 1 35000 HCMEC D3
      5209    5     C  A03  66.33106     32000 1 : Experiment 1 35000 HCMEC D3
      5210   10     C  A03  57.88796     32000 1 : Experiment 1 35000 HCMEC D3
      5211   15     C  A03  47.35816     32000 1 : Experiment 1 35000 HCMEC D3
      5212   20     C  A03  40.25465     32000 1 : Experiment 1 35000 HCMEC D3
      5213   25     C  A03  35.12571     32000 1 : Experiment 1 35000 HCMEC D3
      5214   30     C  A03  31.72974     32000 1 : Experiment 1 35000 HCMEC D3
      5215   35     C  A03  29.61097     32000 1 : Experiment 1 35000 HCMEC D3
      5216   40     C  A03  27.36108     32000 1 : Experiment 1 35000 HCMEC D3
      5217   45     C  A03  25.09269     32000 1 : Experiment 1 35000 HCMEC D3
      5218   50     C  A03  23.81238     32000 1 : Experiment 1 35000 HCMEC D3
      5219   55     C  A03  23.07735     32000 1 : Experiment 1 35000 HCMEC D3
      5220   60     C  A03  22.93953     32000 1 : Experiment 1 35000 HCMEC D3
      5221   65     C  A03  23.21835     32000 1 : Experiment 1 35000 HCMEC D3
      5222   70     C  A03  23.17613     32000 1 : Experiment 1 35000 HCMEC D3
      5223   75     C  A03  23.85276     32000 1 : Experiment 1 35000 HCMEC D3
      5224   80     C  A03  24.51569     32000 1 : Experiment 1 35000 HCMEC D3
      5225   85     C  A03  25.26522     32000 1 : Experiment 1 35000 HCMEC D3
      5226   90     C  A03  26.29272     32000 1 : Experiment 1 35000 HCMEC D3
      5227   95     C  A03  27.15228     32000 1 : Experiment 1 35000 HCMEC D3
      5228  100     C  A03  28.14761     32000 1 : Experiment 1 35000 HCMEC D3
      5229  105     C  A03  29.11159     32000 1 : Experiment 1 35000 HCMEC D3
      5230  110     C  A03  30.05632     32000 1 : Experiment 1 35000 HCMEC D3
      5231  115     C  A03  31.31890     32000 1 : Experiment 1 35000 HCMEC D3
      5232  120     C  A03  32.34224     32000 1 : Experiment 1 35000 HCMEC D3
      5233  125     C  A03  33.32421     32000 1 : Experiment 1 35000 HCMEC D3
      5234  130     C  A03  34.70848     32000 1 : Experiment 1 35000 HCMEC D3
      5235  135     C  A03  35.67812     32000 1 : Experiment 1 35000 HCMEC D3
      5236  140     C  A03  36.78391     32000 1 : Experiment 1 35000 HCMEC D3
      5237  145     C  A03  37.94664     32000 1 : Experiment 1 35000 HCMEC D3
      5238  150     C  A03  39.07571     32000 1 : Experiment 1 35000 HCMEC D3
      5239  155     C  A03  40.59435     32000 1 : Experiment 1 35000 HCMEC D3
      5240  160     C  A03  41.92526     32000 1 : Experiment 1 35000 HCMEC D3
      5241  165     C  A03  43.36704     32000 1 : Experiment 1 35000 HCMEC D3
      5242  170     C  A03  44.48680     32000 1 : Experiment 1 35000 HCMEC D3
      5243  175     C  A03  45.73606     32000 1 : Experiment 1 35000 HCMEC D3
      5244  180     C  A03  46.83095     32000 1 : Experiment 1 35000 HCMEC D3
      5245  185     C  A03  48.48739     32000 1 : Experiment 1 35000 HCMEC D3
      5246  190     C  A03  49.89138     32000 1 : Experiment 1 35000 HCMEC D3
      5247  195     C  A03  51.13119     32000 1 : Experiment 1 35000 HCMEC D3
      5248  200     C  A03        NA     32000 1 : Experiment 1 35000 HCMEC D3
      5249    0     C  A03        NA      4000 1 : Experiment 1 35000 HCMEC D3
      5250    5     C  A03 104.13720      4000 1 : Experiment 1 35000 HCMEC D3
      5251   10     C  A03  99.59732      4000 1 : Experiment 1 35000 HCMEC D3
      5252   15     C  A03  93.21698      4000 1 : Experiment 1 35000 HCMEC D3
      5253   20     C  A03  89.69707      4000 1 : Experiment 1 35000 HCMEC D3
      5254   25     C  A03  87.70841      4000 1 : Experiment 1 35000 HCMEC D3
      5255   30     C  A03  87.88362      4000 1 : Experiment 1 35000 HCMEC D3
      5256   35     C  A03  88.58571      4000 1 : Experiment 1 35000 HCMEC D3
      5257   40     C  A03  89.39257      4000 1 : Experiment 1 35000 HCMEC D3
      5258   45     C  A03  91.28464      4000 1 : Experiment 1 35000 HCMEC D3
      5259   50     C  A03  93.00583      4000 1 : Experiment 1 35000 HCMEC D3
      5260   55     C  A03  94.86179      4000 1 : Experiment 1 35000 HCMEC D3
      5261   60     C  A03  96.64789      4000 1 : Experiment 1 35000 HCMEC D3
      5262   65     C  A03  98.23431      4000 1 : Experiment 1 35000 HCMEC D3
      5263   70     C  A03  99.23058      4000 1 : Experiment 1 35000 HCMEC D3
      5264   75     C  A03 100.44810      4000 1 : Experiment 1 35000 HCMEC D3
      5265   80     C  A03 101.25635      4000 1 : Experiment 1 35000 HCMEC D3
      5266   85     C  A03 102.10571      4000 1 : Experiment 1 35000 HCMEC D3
      5267   90     C  A03 103.15855      4000 1 : Experiment 1 35000 HCMEC D3
      5268   95     C  A03 103.78851      4000 1 : Experiment 1 35000 HCMEC D3
      5269  100     C  A03 104.72566      4000 1 : Experiment 1 35000 HCMEC D3
      5270  105     C  A03 105.51319      4000 1 : Experiment 1 35000 HCMEC D3
      5271  110     C  A03 106.02145      4000 1 : Experiment 1 35000 HCMEC D3
      5272  115     C  A03 107.02401      4000 1 : Experiment 1 35000 HCMEC D3
      5273  120     C  A03 107.67107      4000 1 : Experiment 1 35000 HCMEC D3
      5274  125     C  A03 108.16645      4000 1 : Experiment 1 35000 HCMEC D3
      5275  130     C  A03 108.88934      4000 1 : Experiment 1 35000 HCMEC D3
      5276  135     C  A03 109.47714      4000 1 : Experiment 1 35000 HCMEC D3
      5277  140     C  A03 109.99860      4000 1 : Experiment 1 35000 HCMEC D3
      5278  145     C  A03 110.81347      4000 1 : Experiment 1 35000 HCMEC D3
      5279  150     C  A03 111.33399      4000 1 : Experiment 1 35000 HCMEC D3
      5280  155     C  A03 112.15114      4000 1 : Experiment 1 35000 HCMEC D3
      5281  160     C  A03 112.97682      4000 1 : Experiment 1 35000 HCMEC D3
      5282  165     C  A03 113.64773      4000 1 : Experiment 1 35000 HCMEC D3
      5283  170     C  A03 114.23775      4000 1 : Experiment 1 35000 HCMEC D3
      5284  175     C  A03 114.82378      4000 1 : Experiment 1 35000 HCMEC D3
      5285  180     C  A03 115.13544      4000 1 : Experiment 1 35000 HCMEC D3
      5286  185     C  A03 115.74862      4000 1 : Experiment 1 35000 HCMEC D3
      5287  190     C  A03 116.41380      4000 1 : Experiment 1 35000 HCMEC D3
      5288  195     C  A03 116.70397      4000 1 : Experiment 1 35000 HCMEC D3
      5289  200     C  A03        NA      4000 1 : Experiment 1 35000 HCMEC D3
      5290    0     C  A03        NA       500 1 : Experiment 1 35000 HCMEC D3
      5291    5     C  A03 121.35217       500 1 : Experiment 1 35000 HCMEC D3
      5292   10     C  A03 121.04807       500 1 : Experiment 1 35000 HCMEC D3
      5293   15     C  A03 120.47824       500 1 : Experiment 1 35000 HCMEC D3
      5294   20     C  A03 120.47187       500 1 : Experiment 1 35000 HCMEC D3
      5295   25     C  A03 120.65367       500 1 : Experiment 1 35000 HCMEC D3
      5296   30     C  A03 121.13364       500 1 : Experiment 1 35000 HCMEC D3
      5297   35     C  A03 121.49270       500 1 : Experiment 1 35000 HCMEC D3
      5298   40     C  A03 121.95879       500 1 : Experiment 1 35000 HCMEC D3
      5299   45     C  A03 122.38948       500 1 : Experiment 1 35000 HCMEC D3
      5300   50     C  A03 122.84115       500 1 : Experiment 1 35000 HCMEC D3
      5301   55     C  A03 123.26857       500 1 : Experiment 1 35000 HCMEC D3
      5302   60     C  A03 123.67468       500 1 : Experiment 1 35000 HCMEC D3
      5303   65     C  A03 124.02605       500 1 : Experiment 1 35000 HCMEC D3
      5304   70     C  A03 124.35122       500 1 : Experiment 1 35000 HCMEC D3
      5305   75     C  A03 124.61786       500 1 : Experiment 1 35000 HCMEC D3
      5306   80     C  A03 124.87509       500 1 : Experiment 1 35000 HCMEC D3
      5307   85     C  A03 125.13105       500 1 : Experiment 1 35000 HCMEC D3
      5308   90     C  A03 125.37127       500 1 : Experiment 1 35000 HCMEC D3
      5309   95     C  A03 125.56086       500 1 : Experiment 1 35000 HCMEC D3
      5310  100     C  A03 125.75328       500 1 : Experiment 1 35000 HCMEC D3
      5311  105     C  A03 125.92867       500 1 : Experiment 1 35000 HCMEC D3
      5312  110     C  A03 126.07953       500 1 : Experiment 1 35000 HCMEC D3
      5313  115     C  A03 126.25914       500 1 : Experiment 1 35000 HCMEC D3
      5314  120     C  A03 126.42233       500 1 : Experiment 1 35000 HCMEC D3
      5315  125     C  A03 126.57905       500 1 : Experiment 1 35000 HCMEC D3
      5316  130     C  A03 126.71634       500 1 : Experiment 1 35000 HCMEC D3
      5317  135     C  A03 126.86594       500 1 : Experiment 1 35000 HCMEC D3
      5318  140     C  A03 127.00583       500 1 : Experiment 1 35000 HCMEC D3
      5319  145     C  A03 127.14015       500 1 : Experiment 1 35000 HCMEC D3
      5320  150     C  A03 127.26967       500 1 : Experiment 1 35000 HCMEC D3
      5321  155     C  A03 127.40533       500 1 : Experiment 1 35000 HCMEC D3
      5322  160     C  A03 127.53965       500 1 : Experiment 1 35000 HCMEC D3
      5323  165     C  A03 127.65658       500 1 : Experiment 1 35000 HCMEC D3
      5324  170     C  A03 127.76432       500 1 : Experiment 1 35000 HCMEC D3
      5325  175     C  A03 127.88963       500 1 : Experiment 1 35000 HCMEC D3
      5326  180     C  A03 127.96701       500 1 : Experiment 1 35000 HCMEC D3
      5327  185     C  A03 128.05155       500 1 : Experiment 1 35000 HCMEC D3
      5328  190     C  A03 128.12874       500 1 : Experiment 1 35000 HCMEC D3
      5329  195     C  A03 128.18042       500 1 : Experiment 1 35000 HCMEC D3
      5330  200     C  A03        NA       500 1 : Experiment 1 35000 HCMEC D3
      5331    0     C  A03        NA     64000 1 : Experiment 1 35000 HCMEC D3
      5332    5     C  A03  50.11403     64000 1 : Experiment 1 35000 HCMEC D3
      5333   10     C  A03  43.30432     64000 1 : Experiment 1 35000 HCMEC D3
      5334   15     C  A03  34.75050     64000 1 : Experiment 1 35000 HCMEC D3
      5335   20     C  A03  28.87170     64000 1 : Experiment 1 35000 HCMEC D3
      5336   25     C  A03  24.67238     64000 1 : Experiment 1 35000 HCMEC D3
      5337   30     C  A03  21.46411     64000 1 : Experiment 1 35000 HCMEC D3
      5338   35     C  A03  19.21780     64000 1 : Experiment 1 35000 HCMEC D3
      5339   40     C  A03  16.92001     64000 1 : Experiment 1 35000 HCMEC D3
      5340   45     C  A03  14.19162     64000 1 : Experiment 1 35000 HCMEC D3
      5341   50     C  A03  12.75980     64000 1 : Experiment 1 35000 HCMEC D3
      5342   55     C  A03  11.81327     64000 1 : Experiment 1 35000 HCMEC D3
      5343   60     C  A03  11.58355     64000 1 : Experiment 1 35000 HCMEC D3
      5344   65     C  A03  11.59594     64000 1 : Experiment 1 35000 HCMEC D3
      5345   70     C  A03  11.51990     64000 1 : Experiment 1 35000 HCMEC D3
      5346   75     C  A03  11.79923     64000 1 : Experiment 1 35000 HCMEC D3
      5347   80     C  A03  12.11396     64000 1 : Experiment 1 35000 HCMEC D3
      5348   85     C  A03  12.47013     64000 1 : Experiment 1 35000 HCMEC D3
      5349   90     C  A03  12.91951     64000 1 : Experiment 1 35000 HCMEC D3
      5350   95     C  A03  13.30511     64000 1 : Experiment 1 35000 HCMEC D3
      5351  100     C  A03  13.72936     64000 1 : Experiment 1 35000 HCMEC D3
      5352  105     C  A03  14.16101     64000 1 : Experiment 1 35000 HCMEC D3
      5353  110     C  A03  14.58290     64000 1 : Experiment 1 35000 HCMEC D3
      5354  115     C  A03  15.21043     64000 1 : Experiment 1 35000 HCMEC D3
      5355  120     C  A03  15.71146     64000 1 : Experiment 1 35000 HCMEC D3
      5356  125     C  A03  16.18952     64000 1 : Experiment 1 35000 HCMEC D3
      5357  130     C  A03  16.90708     64000 1 : Experiment 1 35000 HCMEC D3
      5358  135     C  A03  17.40305     64000 1 : Experiment 1 35000 HCMEC D3
      5359  140     C  A03  17.96241     64000 1 : Experiment 1 35000 HCMEC D3
      5360  145     C  A03  18.54348     64000 1 : Experiment 1 35000 HCMEC D3
      5361  150     C  A03  19.22934     64000 1 : Experiment 1 35000 HCMEC D3
      5362  155     C  A03  20.09759     64000 1 : Experiment 1 35000 HCMEC D3
      5363  160     C  A03  20.87611     64000 1 : Experiment 1 35000 HCMEC D3
      5364  165     C  A03  21.71399     64000 1 : Experiment 1 35000 HCMEC D3
      5365  170     C  A03  22.49837     64000 1 : Experiment 1 35000 HCMEC D3
      5366  175     C  A03  23.26099     64000 1 : Experiment 1 35000 HCMEC D3
      5367  180     C  A03  24.11076     64000 1 : Experiment 1 35000 HCMEC D3
      5368  185     C  A03  25.21442     64000 1 : Experiment 1 35000 HCMEC D3
      5369  190     C  A03  26.14548     64000 1 : Experiment 1 35000 HCMEC D3
      5370  195     C  A03  27.10604     64000 1 : Experiment 1 35000 HCMEC D3
      5371  200     C  A03        NA     64000 1 : Experiment 1 35000 HCMEC D3
      5372    0     C  A03        NA      8000 1 : Experiment 1 35000 HCMEC D3
      5373    5     C  A03  91.86031      8000 1 : Experiment 1 35000 HCMEC D3
      5374   10     C  A03  85.16184      8000 1 : Experiment 1 35000 HCMEC D3
      5375   15     C  A03  76.25393      8000 1 : Experiment 1 35000 HCMEC D3
      5376   20     C  A03  70.84075      8000 1 : Experiment 1 35000 HCMEC D3
      5377   25     C  A03  67.31815      8000 1 : Experiment 1 35000 HCMEC D3
      5378   30     C  A03  66.21567      8000 1 : Experiment 1 35000 HCMEC D3
      5379   35     C  A03  66.16903      8000 1 : Experiment 1 35000 HCMEC D3
      5380   40     C  A03  66.22184      8000 1 : Experiment 1 35000 HCMEC D3
      5381   45     C  A03  67.64857      8000 1 : Experiment 1 35000 HCMEC D3
      5382   50     C  A03  69.05647      8000 1 : Experiment 1 35000 HCMEC D3
      5383   55     C  A03  70.84506      8000 1 : Experiment 1 35000 HCMEC D3
      5384   60     C  A03  72.56161      8000 1 : Experiment 1 35000 HCMEC D3
      5385   65     C  A03  74.33095      8000 1 : Experiment 1 35000 HCMEC D3
      5386   70     C  A03  75.15244      8000 1 : Experiment 1 35000 HCMEC D3
      5387   75     C  A03  76.69203      8000 1 : Experiment 1 35000 HCMEC D3
      5388   80     C  A03  77.70892      8000 1 : Experiment 1 35000 HCMEC D3
      5389   85     C  A03  78.85485      8000 1 : Experiment 1 35000 HCMEC D3
      5390   90     C  A03  80.36376      8000 1 : Experiment 1 35000 HCMEC D3
      5391   95     C  A03  81.37505      8000 1 : Experiment 1 35000 HCMEC D3
      5392  100     C  A03  82.80787      8000 1 : Experiment 1 35000 HCMEC D3
      5393  105     C  A03  84.04682      8000 1 : Experiment 1 35000 HCMEC D3
      5394  110     C  A03  85.00727      8000 1 : Experiment 1 35000 HCMEC D3
      5395  115     C  A03  86.53314      8000 1 : Experiment 1 35000 HCMEC D3
      5396  120     C  A03  87.49334      8000 1 : Experiment 1 35000 HCMEC D3
      5397  125     C  A03  88.31387      8000 1 : Experiment 1 35000 HCMEC D3
      5398  130     C  A03  89.50354      8000 1 : Experiment 1 35000 HCMEC D3
      5399  135     C  A03  90.42173      8000 1 : Experiment 1 35000 HCMEC D3
      5400  140     C  A03  91.33591      8000 1 : Experiment 1 35000 HCMEC D3
      5401  145     C  A03  92.58215      8000 1 : Experiment 1 35000 HCMEC D3
      5402  150     C  A03  93.37326      8000 1 : Experiment 1 35000 HCMEC D3
      5403  155     C  A03  94.62710      8000 1 : Experiment 1 35000 HCMEC D3
      5404  160     C  A03  95.76859      8000 1 : Experiment 1 35000 HCMEC D3
      5405  165     C  A03  96.82385      8000 1 : Experiment 1 35000 HCMEC D3
      5406  170     C  A03  97.59611      8000 1 : Experiment 1 35000 HCMEC D3
      5407  175     C  A03  98.49230      8000 1 : Experiment 1 35000 HCMEC D3
      5408  180     C  A03  99.02707      8000 1 : Experiment 1 35000 HCMEC D3
      5409  185     C  A03  99.97911      8000 1 : Experiment 1 35000 HCMEC D3
      5410  190     C  A03 100.96438      8000 1 : Experiment 1 35000 HCMEC D3
      5411  195     C  A03 101.45964      8000 1 : Experiment 1 35000 HCMEC D3
      5412  200     C  A03        NA      8000 1 : Experiment 1 35000 HCMEC D3
      5413    0     C  B01        NA      1000 1 : Experiment 1 30000 HCMEC D3
      5414    5     C  B01 117.54290      1000 1 : Experiment 1 30000 HCMEC D3
      5415   10     C  B01 116.79815      1000 1 : Experiment 1 30000 HCMEC D3
      5416   15     C  B01 115.36584      1000 1 : Experiment 1 30000 HCMEC D3
      5417   20     C  B01 114.58072      1000 1 : Experiment 1 30000 HCMEC D3
      5418   25     C  B01 114.61220      1000 1 : Experiment 1 30000 HCMEC D3
      5419   30     C  B01 114.39601      1000 1 : Experiment 1 30000 HCMEC D3
      5420   35     C  B01 115.13241      1000 1 : Experiment 1 30000 HCMEC D3
      5421   40     C  B01 115.92191      1000 1 : Experiment 1 30000 HCMEC D3
      5422   45     C  B01 116.47510      1000 1 : Experiment 1 30000 HCMEC D3
      5423   50     C  B01 117.06329      1000 1 : Experiment 1 30000 HCMEC D3
      5424   55     C  B01 118.02619      1000 1 : Experiment 1 30000 HCMEC D3
      5425   60     C  B01 118.59094      1000 1 : Experiment 1 30000 HCMEC D3
      5426   65     C  B01 119.00072      1000 1 : Experiment 1 30000 HCMEC D3
      5427   70     C  B01 119.39671      1000 1 : Experiment 1 30000 HCMEC D3
      5428   75     C  B01 119.82700      1000 1 : Experiment 1 30000 HCMEC D3
      5429   80     C  B01 120.20115      1000 1 : Experiment 1 30000 HCMEC D3
      5430   85     C  B01 120.44292      1000 1 : Experiment 1 30000 HCMEC D3
      5431   90     C  B01 120.65663      1000 1 : Experiment 1 30000 HCMEC D3
      5432   95     C  B01 121.08245      1000 1 : Experiment 1 30000 HCMEC D3
      5433  100     C  B01 121.32625      1000 1 : Experiment 1 30000 HCMEC D3
      5434  105     C  B01 121.67179      1000 1 : Experiment 1 30000 HCMEC D3
      5435  110     C  B01 121.86394      1000 1 : Experiment 1 30000 HCMEC D3
      5436  115     C  B01 122.10525      1000 1 : Experiment 1 30000 HCMEC D3
      5437  120     C  B01 122.25666      1000 1 : Experiment 1 30000 HCMEC D3
      5438  125     C  B01 122.48456      1000 1 : Experiment 1 30000 HCMEC D3
      5439  130     C  B01 122.76418      1000 1 : Experiment 1 30000 HCMEC D3
      5440  135     C  B01 122.96269      1000 1 : Experiment 1 30000 HCMEC D3
      5441  140     C  B01 123.17455      1000 1 : Experiment 1 30000 HCMEC D3
      5442  145     C  B01 123.38325      1000 1 : Experiment 1 30000 HCMEC D3
      5443  150     C  B01 123.56057      1000 1 : Experiment 1 30000 HCMEC D3
      5444  155     C  B01 123.70688      1000 1 : Experiment 1 30000 HCMEC D3
      5445  160     C  B01 123.84945      1000 1 : Experiment 1 30000 HCMEC D3
      5446  165     C  B01 124.05130      1000 1 : Experiment 1 30000 HCMEC D3
      5447  170     C  B01 124.19574      1000 1 : Experiment 1 30000 HCMEC D3
      5448  175     C  B01 124.31065      1000 1 : Experiment 1 30000 HCMEC D3
      5449  180     C  B01 124.44103      1000 1 : Experiment 1 30000 HCMEC D3
      5450  185     C  B01 124.52662      1000 1 : Experiment 1 30000 HCMEC D3
      5451  190     C  B01 124.53145      1000 1 : Experiment 1 30000 HCMEC D3
      5452  195     C  B01 124.77677      1000 1 : Experiment 1 30000 HCMEC D3
      5453  200     C  B01        NA      1000 1 : Experiment 1 30000 HCMEC D3
      5454    0     C  B01        NA     16000 1 : Experiment 1 30000 HCMEC D3
      5455    5     C  B01  81.27067     16000 1 : Experiment 1 30000 HCMEC D3
      5456   10     C  B01  72.21993     16000 1 : Experiment 1 30000 HCMEC D3
      5457   15     C  B01  61.57589     16000 1 : Experiment 1 30000 HCMEC D3
      5458   20     C  B01  53.25006     16000 1 : Experiment 1 30000 HCMEC D3
      5459   25     C  B01  49.44370     16000 1 : Experiment 1 30000 HCMEC D3
      5460   30     C  B01  46.70971     16000 1 : Experiment 1 30000 HCMEC D3
      5461   35     C  B01  44.66990     16000 1 : Experiment 1 30000 HCMEC D3
      5462   40     C  B01  42.94546     16000 1 : Experiment 1 30000 HCMEC D3
      5463   45     C  B01  42.24517     16000 1 : Experiment 1 30000 HCMEC D3
      5464   50     C  B01  41.52590     16000 1 : Experiment 1 30000 HCMEC D3
      5465   55     C  B01  41.80390     16000 1 : Experiment 1 30000 HCMEC D3
      5466   60     C  B01  41.75462     16000 1 : Experiment 1 30000 HCMEC D3
      5467   65     C  B01  41.85278     16000 1 : Experiment 1 30000 HCMEC D3
      5468   70     C  B01  42.01835     16000 1 : Experiment 1 30000 HCMEC D3
      5469   75     C  B01  43.02838     16000 1 : Experiment 1 30000 HCMEC D3
      5470   80     C  B01  43.83023     16000 1 : Experiment 1 30000 HCMEC D3
      5471   85     C  B01  44.51788     16000 1 : Experiment 1 30000 HCMEC D3
      5472   90     C  B01  45.33896     16000 1 : Experiment 1 30000 HCMEC D3
      5473   95     C  B01  46.91627     16000 1 : Experiment 1 30000 HCMEC D3
      5474  100     C  B01  48.30251     16000 1 : Experiment 1 30000 HCMEC D3
      5475  105     C  B01  49.80256     16000 1 : Experiment 1 30000 HCMEC D3
      5476  110     C  B01  51.14274     16000 1 : Experiment 1 30000 HCMEC D3
      5477  115     C  B01  52.35430     16000 1 : Experiment 1 30000 HCMEC D3
      5478  120     C  B01  53.99063     16000 1 : Experiment 1 30000 HCMEC D3
      5479  125     C  B01  55.30927     16000 1 : Experiment 1 30000 HCMEC D3
      5480  130     C  B01  56.98105     16000 1 : Experiment 1 30000 HCMEC D3
      5481  135     C  B01  58.45023     16000 1 : Experiment 1 30000 HCMEC D3
      5482  140     C  B01  60.31004     16000 1 : Experiment 1 30000 HCMEC D3
      5483  145     C  B01  61.45394     16000 1 : Experiment 1 30000 HCMEC D3
      5484  150     C  B01  62.97597     16000 1 : Experiment 1 30000 HCMEC D3
      5485  155     C  B01  64.07074     16000 1 : Experiment 1 30000 HCMEC D3
      5486  160     C  B01  65.61948     16000 1 : Experiment 1 30000 HCMEC D3
      5487  165     C  B01  66.44798     16000 1 : Experiment 1 30000 HCMEC D3
      5488  170     C  B01  67.92289     16000 1 : Experiment 1 30000 HCMEC D3
      5489  175     C  B01  69.09320     16000 1 : Experiment 1 30000 HCMEC D3
      5490  180     C  B01  70.25572     16000 1 : Experiment 1 30000 HCMEC D3
      5491  185     C  B01  70.86503     16000 1 : Experiment 1 30000 HCMEC D3
      5492  190     C  B01  71.79569     16000 1 : Experiment 1 30000 HCMEC D3
      5493  195     C  B01  73.13324     16000 1 : Experiment 1 30000 HCMEC D3
      5494  200     C  B01        NA     16000 1 : Experiment 1 30000 HCMEC D3
      5495    0     C  B01        NA      2000 1 : Experiment 1 30000 HCMEC D3
      5496    5     C  B01 112.93538      2000 1 : Experiment 1 30000 HCMEC D3
      5497   10     C  B01 110.37727      2000 1 : Experiment 1 30000 HCMEC D3
      5498   15     C  B01 106.81961      2000 1 : Experiment 1 30000 HCMEC D3
      5499   20     C  B01 104.46948      2000 1 : Experiment 1 30000 HCMEC D3
      5500   25     C  B01 104.08814      2000 1 : Experiment 1 30000 HCMEC D3
      5501   30     C  B01 103.30537      2000 1 : Experiment 1 30000 HCMEC D3
      5502   35     C  B01 104.18678      2000 1 : Experiment 1 30000 HCMEC D3
      5503   40     C  B01 105.30648      2000 1 : Experiment 1 30000 HCMEC D3
      5504   45     C  B01 106.23578      2000 1 : Experiment 1 30000 HCMEC D3
      5505   50     C  B01 107.29446      2000 1 : Experiment 1 30000 HCMEC D3
      5506   55     C  B01 108.85304      2000 1 : Experiment 1 30000 HCMEC D3
      5507   60     C  B01 109.73863      2000 1 : Experiment 1 30000 HCMEC D3
      5508   65     C  B01 110.32887      2000 1 : Experiment 1 30000 HCMEC D3
      5509   70     C  B01 110.93131      2000 1 : Experiment 1 30000 HCMEC D3
      5510   75     C  B01 111.59406      2000 1 : Experiment 1 30000 HCMEC D3
      5511   80     C  B01 112.21878      2000 1 : Experiment 1 30000 HCMEC D3
      5512   85     C  B01 112.48611      2000 1 : Experiment 1 30000 HCMEC D3
      5513   90     C  B01 112.81928      2000 1 : Experiment 1 30000 HCMEC D3
      5514   95     C  B01 113.53950      2000 1 : Experiment 1 30000 HCMEC D3
      5515  100     C  B01 114.01858      2000 1 : Experiment 1 30000 HCMEC D3
      5516  105     C  B01 114.68221      2000 1 : Experiment 1 30000 HCMEC D3
      5517  110     C  B01 115.07326      2000 1 : Experiment 1 30000 HCMEC D3
      5518  115     C  B01 115.55084      2000 1 : Experiment 1 30000 HCMEC D3
      5519  120     C  B01 115.87205      2000 1 : Experiment 1 30000 HCMEC D3
      5520  125     C  B01 116.32933      2000 1 : Experiment 1 30000 HCMEC D3
      5521  130     C  B01 116.95697      2000 1 : Experiment 1 30000 HCMEC D3
      5522  135     C  B01 117.33526      2000 1 : Experiment 1 30000 HCMEC D3
      5523  140     C  B01 117.83357      2000 1 : Experiment 1 30000 HCMEC D3
      5524  145     C  B01 118.24966      2000 1 : Experiment 1 30000 HCMEC D3
      5525  150     C  B01 118.63917      2000 1 : Experiment 1 30000 HCMEC D3
      5526  155     C  B01 118.93155      2000 1 : Experiment 1 30000 HCMEC D3
      5527  160     C  B01 119.29283      2000 1 : Experiment 1 30000 HCMEC D3
      5528  165     C  B01 119.66633      2000 1 : Experiment 1 30000 HCMEC D3
      5529  170     C  B01 119.98834      2000 1 : Experiment 1 30000 HCMEC D3
      5530  175     C  B01 120.27683      2000 1 : Experiment 1 30000 HCMEC D3
      5531  180     C  B01 120.57430      2000 1 : Experiment 1 30000 HCMEC D3
      5532  185     C  B01 120.70647      2000 1 : Experiment 1 30000 HCMEC D3
      5533  190     C  B01 120.73580      2000 1 : Experiment 1 30000 HCMEC D3
      5534  195     C  B01 121.37053      2000 1 : Experiment 1 30000 HCMEC D3
      5535  200     C  B01        NA      2000 1 : Experiment 1 30000 HCMEC D3
      5536    0     C  B01        NA       250 1 : Experiment 1 30000 HCMEC D3
      5537    5     C  B01 122.92621       250 1 : Experiment 1 30000 HCMEC D3
      5538   10     C  B01 122.76626       250 1 : Experiment 1 30000 HCMEC D3
      5539   15     C  B01 122.52724       250 1 : Experiment 1 30000 HCMEC D3
      5540   20     C  B01 122.50440       250 1 : Experiment 1 30000 HCMEC D3
      5541   25     C  B01 122.63964       250 1 : Experiment 1 30000 HCMEC D3
      5542   30     C  B01 122.81762       250 1 : Experiment 1 30000 HCMEC D3
      5543   35     C  B01 123.13115       250 1 : Experiment 1 30000 HCMEC D3
      5544   40     C  B01 123.47385       250 1 : Experiment 1 30000 HCMEC D3
      5545   45     C  B01 123.78157       250 1 : Experiment 1 30000 HCMEC D3
      5546   50     C  B01 124.08147       250 1 : Experiment 1 30000 HCMEC D3
      5547   55     C  B01 124.48482       250 1 : Experiment 1 30000 HCMEC D3
      5548   60     C  B01 124.77788       250 1 : Experiment 1 30000 HCMEC D3
      5549   65     C  B01 125.06043       250 1 : Experiment 1 30000 HCMEC D3
      5550   70     C  B01 125.29284       250 1 : Experiment 1 30000 HCMEC D3
      5551   75     C  B01 125.51337       250 1 : Experiment 1 30000 HCMEC D3
      5552   80     C  B01 125.71507       250 1 : Experiment 1 30000 HCMEC D3
      5553   85     C  B01 125.88991       250 1 : Experiment 1 30000 HCMEC D3
      5554   90     C  B01 126.05122       250 1 : Experiment 1 30000 HCMEC D3
      5555   95     C  B01 126.21316       250 1 : Experiment 1 30000 HCMEC D3
      5556  100     C  B01 126.35972       250 1 : Experiment 1 30000 HCMEC D3
      5557  105     C  B01 126.50818       250 1 : Experiment 1 30000 HCMEC D3
      5558  110     C  B01 126.63376       250 1 : Experiment 1 30000 HCMEC D3
      5559  115     C  B01 126.74028       250 1 : Experiment 1 30000 HCMEC D3
      5560  120     C  B01 126.86145       250 1 : Experiment 1 30000 HCMEC D3
      5561  125     C  B01 126.96298       250 1 : Experiment 1 30000 HCMEC D3
      5562  130     C  B01 127.07269       250 1 : Experiment 1 30000 HCMEC D3
      5563  135     C  B01 127.16388       250 1 : Experiment 1 30000 HCMEC D3
      5564  140     C  B01 127.25745       250 1 : Experiment 1 30000 HCMEC D3
      5565  145     C  B01 127.33480       250 1 : Experiment 1 30000 HCMEC D3
      5566  150     C  B01 127.41052       250 1 : Experiment 1 30000 HCMEC D3
      5567  155     C  B01 127.48070       250 1 : Experiment 1 30000 HCMEC D3
      5568  160     C  B01 127.54744       250 1 : Experiment 1 30000 HCMEC D3
      5569  165     C  B01 127.60799       250 1 : Experiment 1 30000 HCMEC D3
      5570  170     C  B01 127.67401       250 1 : Experiment 1 30000 HCMEC D3
      5571  175     C  B01 127.73103       250 1 : Experiment 1 30000 HCMEC D3
      5572  180     C  B01 127.77204       250 1 : Experiment 1 30000 HCMEC D3
      5573  185     C  B01 127.81833       250 1 : Experiment 1 30000 HCMEC D3
      5574  190     C  B01 127.83806       250 1 : Experiment 1 30000 HCMEC D3
      5575  195     C  B01 127.87835       250 1 : Experiment 1 30000 HCMEC D3
      5576  200     C  B01        NA       250 1 : Experiment 1 30000 HCMEC D3
      5577    0     C  B01        NA     32000 1 : Experiment 1 30000 HCMEC D3
      5578    5     C  B01  68.10479     32000 1 : Experiment 1 30000 HCMEC D3
      5579   10     C  B01  59.05755     32000 1 : Experiment 1 30000 HCMEC D3
      5580   15     C  B01  48.37903     32000 1 : Experiment 1 30000 HCMEC D3
      5581   20     C  B01  39.81400     32000 1 : Experiment 1 30000 HCMEC D3
      5582   25     C  B01  35.40265     32000 1 : Experiment 1 30000 HCMEC D3
      5583   30     C  B01  32.49471     32000 1 : Experiment 1 30000 HCMEC D3
      5584   35     C  B01  29.72440     32000 1 : Experiment 1 30000 HCMEC D3
      5585   40     C  B01  26.82444     32000 1 : Experiment 1 30000 HCMEC D3
      5586   45     C  B01  24.91821     32000 1 : Experiment 1 30000 HCMEC D3
      5587   50     C  B01  22.87659     32000 1 : Experiment 1 30000 HCMEC D3
      5588   55     C  B01  21.88296     32000 1 : Experiment 1 30000 HCMEC D3
      5589   60     C  B01  21.40196     32000 1 : Experiment 1 30000 HCMEC D3
      5590   65     C  B01  21.23562     32000 1 : Experiment 1 30000 HCMEC D3
      5591   70     C  B01  21.08434     32000 1 : Experiment 1 30000 HCMEC D3
      5592   75     C  B01  21.62195     32000 1 : Experiment 1 30000 HCMEC D3
      5593   80     C  B01  22.03187     32000 1 : Experiment 1 30000 HCMEC D3
      5594   85     C  B01  22.53590     32000 1 : Experiment 1 30000 HCMEC D3
      5595   90     C  B01  23.02692     32000 1 : Experiment 1 30000 HCMEC D3
      5596   95     C  B01  23.97082     32000 1 : Experiment 1 30000 HCMEC D3
      5597  100     C  B01  24.88441     32000 1 : Experiment 1 30000 HCMEC D3
      5598  105     C  B01  25.89797     32000 1 : Experiment 1 30000 HCMEC D3
      5599  110     C  B01  26.73949     32000 1 : Experiment 1 30000 HCMEC D3
      5600  115     C  B01  27.50220     32000 1 : Experiment 1 30000 HCMEC D3
      5601  120     C  B01  28.79101     32000 1 : Experiment 1 30000 HCMEC D3
      5602  125     C  B01  29.63141     32000 1 : Experiment 1 30000 HCMEC D3
      5603  130     C  B01  30.93027     32000 1 : Experiment 1 30000 HCMEC D3
      5604  135     C  B01  32.10033     32000 1 : Experiment 1 30000 HCMEC D3
      5605  140     C  B01  33.53916     32000 1 : Experiment 1 30000 HCMEC D3
      5606  145     C  B01  34.46034     32000 1 : Experiment 1 30000 HCMEC D3
      5607  150     C  B01  35.68331     32000 1 : Experiment 1 30000 HCMEC D3
      5608  155     C  B01  36.85431     32000 1 : Experiment 1 30000 HCMEC D3
      5609  160     C  B01  38.02985     32000 1 : Experiment 1 30000 HCMEC D3
      5610  165     C  B01  39.10294     32000 1 : Experiment 1 30000 HCMEC D3
      5611  170     C  B01  40.34969     32000 1 : Experiment 1 30000 HCMEC D3
      5612  175     C  B01  41.42341     32000 1 : Experiment 1 30000 HCMEC D3
      5613  180     C  B01  42.49538     32000 1 : Experiment 1 30000 HCMEC D3
      5614  185     C  B01  43.35686     32000 1 : Experiment 1 30000 HCMEC D3
      5615  190     C  B01  44.52726     32000 1 : Experiment 1 30000 HCMEC D3
      5616  195     C  B01  45.77613     32000 1 : Experiment 1 30000 HCMEC D3
      5617  200     C  B01        NA     32000 1 : Experiment 1 30000 HCMEC D3
      5618    0     C  B01        NA      4000 1 : Experiment 1 30000 HCMEC D3
      5619    5     C  B01 105.03710      4000 1 : Experiment 1 30000 HCMEC D3
      5620   10     C  B01  99.91225      4000 1 : Experiment 1 30000 HCMEC D3
      5621   15     C  B01  93.58549      4000 1 : Experiment 1 30000 HCMEC D3
      5622   20     C  B01  89.11487      4000 1 : Experiment 1 30000 HCMEC D3
      5623   25     C  B01  87.91499      4000 1 : Experiment 1 30000 HCMEC D3
      5624   30     C  B01  86.51154      4000 1 : Experiment 1 30000 HCMEC D3
      5625   35     C  B01  87.02628      4000 1 : Experiment 1 30000 HCMEC D3
      5626   40     C  B01  87.94797      4000 1 : Experiment 1 30000 HCMEC D3
      5627   45     C  B01  89.12589      4000 1 : Experiment 1 30000 HCMEC D3
      5628   50     C  B01  90.53797      4000 1 : Experiment 1 30000 HCMEC D3
      5629   55     C  B01  92.65245      4000 1 : Experiment 1 30000 HCMEC D3
      5630   60     C  B01  93.79222      4000 1 : Experiment 1 30000 HCMEC D3
      5631   65     C  B01  94.57155      4000 1 : Experiment 1 30000 HCMEC D3
      5632   70     C  B01  95.41775      4000 1 : Experiment 1 30000 HCMEC D3
      5633   75     C  B01  96.43280      4000 1 : Experiment 1 30000 HCMEC D3
      5634   80     C  B01  97.37613      4000 1 : Experiment 1 30000 HCMEC D3
      5635   85     C  B01  97.76983      4000 1 : Experiment 1 30000 HCMEC D3
      5636   90     C  B01  98.34988      4000 1 : Experiment 1 30000 HCMEC D3
      5637   95     C  B01  99.55877      4000 1 : Experiment 1 30000 HCMEC D3
      5638  100     C  B01 100.39547      4000 1 : Experiment 1 30000 HCMEC D3
      5639  105     C  B01 101.39487      4000 1 : Experiment 1 30000 HCMEC D3
      5640  110     C  B01 102.14520      4000 1 : Experiment 1 30000 HCMEC D3
      5641  115     C  B01 102.98897      4000 1 : Experiment 1 30000 HCMEC D3
      5642  120     C  B01 103.60136      4000 1 : Experiment 1 30000 HCMEC D3
      5643  125     C  B01 104.37832      4000 1 : Experiment 1 30000 HCMEC D3
      5644  130     C  B01 105.44195      4000 1 : Experiment 1 30000 HCMEC D3
      5645  135     C  B01 106.08532      4000 1 : Experiment 1 30000 HCMEC D3
      5646  140     C  B01 107.02358      4000 1 : Experiment 1 30000 HCMEC D3
      5647  145     C  B01 107.65791      4000 1 : Experiment 1 30000 HCMEC D3
      5648  150     C  B01 108.38693      4000 1 : Experiment 1 30000 HCMEC D3
      5649  155     C  B01 108.85832      4000 1 : Experiment 1 30000 HCMEC D3
      5650  160     C  B01 109.59882      4000 1 : Experiment 1 30000 HCMEC D3
      5651  165     C  B01 110.02386      4000 1 : Experiment 1 30000 HCMEC D3
      5652  170     C  B01 110.67251      4000 1 : Experiment 1 30000 HCMEC D3
      5653  175     C  B01 111.21310      4000 1 : Experiment 1 30000 HCMEC D3
      5654  180     C  B01 111.75750      4000 1 : Experiment 1 30000 HCMEC D3
      5655  185     C  B01 111.90350      4000 1 : Experiment 1 30000 HCMEC D3
      5656  190     C  B01 112.06645      4000 1 : Experiment 1 30000 HCMEC D3
      5657  195     C  B01 113.10230      4000 1 : Experiment 1 30000 HCMEC D3
      5658  200     C  B01        NA      4000 1 : Experiment 1 30000 HCMEC D3
      5659    0     C  B01        NA       500 1 : Experiment 1 30000 HCMEC D3
      5660    5     C  B01 120.67470       500 1 : Experiment 1 30000 HCMEC D3
      5661   10     C  B01 120.48803       500 1 : Experiment 1 30000 HCMEC D3
      5662   15     C  B01 119.97435       500 1 : Experiment 1 30000 HCMEC D3
      5663   20     C  B01 119.81917       500 1 : Experiment 1 30000 HCMEC D3
      5664   25     C  B01 119.94553       500 1 : Experiment 1 30000 HCMEC D3
      5665   30     C  B01 120.01888       500 1 : Experiment 1 30000 HCMEC D3
      5666   35     C  B01 120.49391       500 1 : Experiment 1 30000 HCMEC D3
      5667   40     C  B01 120.99860       500 1 : Experiment 1 30000 HCMEC D3
      5668   45     C  B01 121.38750       500 1 : Experiment 1 30000 HCMEC D3
      5669   50     C  B01 121.74373       500 1 : Experiment 1 30000 HCMEC D3
      5670   55     C  B01 122.34100       500 1 : Experiment 1 30000 HCMEC D3
      5671   60     C  B01 122.70733       500 1 : Experiment 1 30000 HCMEC D3
      5672   65     C  B01 123.01291       500 1 : Experiment 1 30000 HCMEC D3
      5673   70     C  B01 123.30379       500 1 : Experiment 1 30000 HCMEC D3
      5674   75     C  B01 123.58235       500 1 : Experiment 1 30000 HCMEC D3
      5675   80     C  B01 123.82390       500 1 : Experiment 1 30000 HCMEC D3
      5676   85     C  B01 124.02396       500 1 : Experiment 1 30000 HCMEC D3
      5677   90     C  B01 124.18898       500 1 : Experiment 1 30000 HCMEC D3
      5678   95     C  B01 124.43173       500 1 : Experiment 1 30000 HCMEC D3
      5679  100     C  B01 124.58936       500 1 : Experiment 1 30000 HCMEC D3
      5680  105     C  B01 124.79657       500 1 : Experiment 1 30000 HCMEC D3
      5681  110     C  B01 124.94231       500 1 : Experiment 1 30000 HCMEC D3
      5682  115     C  B01 125.07760       500 1 : Experiment 1 30000 HCMEC D3
      5683  120     C  B01 125.19242       500 1 : Experiment 1 30000 HCMEC D3
      5684  125     C  B01 125.33784       500 1 : Experiment 1 30000 HCMEC D3
      5685  130     C  B01 125.48229       500 1 : Experiment 1 30000 HCMEC D3
      5686  135     C  B01 125.60354       500 1 : Experiment 1 30000 HCMEC D3
      5687  140     C  B01 125.71269       500 1 : Experiment 1 30000 HCMEC D3
      5688  145     C  B01 125.83043       500 1 : Experiment 1 30000 HCMEC D3
      5689  150     C  B01 125.92773       500 1 : Experiment 1 30000 HCMEC D3
      5690  155     C  B01 126.01859       500 1 : Experiment 1 30000 HCMEC D3
      5691  160     C  B01 126.10138       500 1 : Experiment 1 30000 HCMEC D3
      5692  165     C  B01 126.20222       500 1 : Experiment 1 30000 HCMEC D3
      5693  170     C  B01 126.27718       500 1 : Experiment 1 30000 HCMEC D3
      5694  175     C  B01 126.34943       500 1 : Experiment 1 30000 HCMEC D3
      5695  180     C  B01 126.41298       500 1 : Experiment 1 30000 HCMEC D3
      5696  185     C  B01 126.46242       500 1 : Experiment 1 30000 HCMEC D3
      5697  190     C  B01 126.47328       500 1 : Experiment 1 30000 HCMEC D3
      5698  195     C  B01 126.57265       500 1 : Experiment 1 30000 HCMEC D3
      5699  200     C  B01        NA       500 1 : Experiment 1 30000 HCMEC D3
      5700    0     C  B01        NA     64000 1 : Experiment 1 30000 HCMEC D3
      5701    5     C  B01  50.99575     64000 1 : Experiment 1 30000 HCMEC D3
      5702   10     C  B01  44.00106     64000 1 : Experiment 1 30000 HCMEC D3
      5703   15     C  B01  35.52260     64000 1 : Experiment 1 30000 HCMEC D3
      5704   20     C  B01  28.61250     64000 1 : Experiment 1 30000 HCMEC D3
      5705   25     C  B01  24.75430     64000 1 : Experiment 1 30000 HCMEC D3
      5706   30     C  B01  22.25422     64000 1 : Experiment 1 30000 HCMEC D3
      5707   35     C  B01  19.70160     64000 1 : Experiment 1 30000 HCMEC D3
      5708   40     C  B01  16.68797     64000 1 : Experiment 1 30000 HCMEC D3
      5709   45     C  B01  14.50212     64000 1 : Experiment 1 30000 HCMEC D3
      5710   50     C  B01  12.37032     64000 1 : Experiment 1 30000 HCMEC D3
      5711   55     C  B01  11.28086     64000 1 : Experiment 1 30000 HCMEC D3
      5712   60     C  B01  10.95535     64000 1 : Experiment 1 30000 HCMEC D3
      5713   65     C  B01  10.83580     64000 1 : Experiment 1 30000 HCMEC D3
      5714   70     C  B01  10.72190     64000 1 : Experiment 1 30000 HCMEC D3
      5715   75     C  B01  10.94472     64000 1 : Experiment 1 30000 HCMEC D3
      5716   80     C  B01  11.13164     64000 1 : Experiment 1 30000 HCMEC D3
      5717   85     C  B01  11.38451     64000 1 : Experiment 1 30000 HCMEC D3
      5718   90     C  B01  11.58116     64000 1 : Experiment 1 30000 HCMEC D3
      5719   95     C  B01  11.99450     64000 1 : Experiment 1 30000 HCMEC D3
      5720  100     C  B01  12.38907     64000 1 : Experiment 1 30000 HCMEC D3
      5721  105     C  B01  12.85270     64000 1 : Experiment 1 30000 HCMEC D3
      5722  110     C  B01  13.17532     64000 1 : Experiment 1 30000 HCMEC D3
      5723  115     C  B01  13.47836     64000 1 : Experiment 1 30000 HCMEC D3
      5724  120     C  B01  14.12629     64000 1 : Experiment 1 30000 HCMEC D3
      5725  125     C  B01  14.44490     64000 1 : Experiment 1 30000 HCMEC D3
      5726  130     C  B01  15.11421     64000 1 : Experiment 1 30000 HCMEC D3
      5727  135     C  B01  15.69989     64000 1 : Experiment 1 30000 HCMEC D3
      5728  140     C  B01  16.39639     64000 1 : Experiment 1 30000 HCMEC D3
      5729  145     C  B01  16.83870     64000 1 : Experiment 1 30000 HCMEC D3
      5730  150     C  B01  17.42208     64000 1 : Experiment 1 30000 HCMEC D3
      5731  155     C  B01  18.19860     64000 1 : Experiment 1 30000 HCMEC D3
      5732  160     C  B01  18.69089     64000 1 : Experiment 1 30000 HCMEC D3
      5733  165     C  B01  19.41012     64000 1 : Experiment 1 30000 HCMEC D3
      5734  170     C  B01  20.03165     64000 1 : Experiment 1 30000 HCMEC D3
      5735  175     C  B01  20.68211     64000 1 : Experiment 1 30000 HCMEC D3
      5736  180     C  B01  21.30670     64000 1 : Experiment 1 30000 HCMEC D3
      5737  185     C  B01  21.97114     64000 1 : Experiment 1 30000 HCMEC D3
      5738  190     C  B01  22.80789     64000 1 : Experiment 1 30000 HCMEC D3
      5739  195     C  B01  23.64469     64000 1 : Experiment 1 30000 HCMEC D3
      5740  200     C  B01        NA     64000 1 : Experiment 1 30000 HCMEC D3
      5741    0     C  B01        NA      8000 1 : Experiment 1 30000 HCMEC D3
      5742    5     C  B01  93.43615      8000 1 : Experiment 1 30000 HCMEC D3
      5743   10     C  B01  85.89770      8000 1 : Experiment 1 30000 HCMEC D3
      5744   15     C  B01  77.02715      8000 1 : Experiment 1 30000 HCMEC D3
      5745   20     C  B01  70.42620      8000 1 : Experiment 1 30000 HCMEC D3
      5746   25     C  B01  67.92036      8000 1 : Experiment 1 30000 HCMEC D3
      5747   30     C  B01  65.76566      8000 1 : Experiment 1 30000 HCMEC D3
      5748   35     C  B01  65.05019      8000 1 : Experiment 1 30000 HCMEC D3
      5749   40     C  B01  64.92353      8000 1 : Experiment 1 30000 HCMEC D3
      5750   45     C  B01  65.64441      8000 1 : Experiment 1 30000 HCMEC D3
      5751   50     C  B01  66.58110      8000 1 : Experiment 1 30000 HCMEC D3
      5752   55     C  B01  68.42634      8000 1 : Experiment 1 30000 HCMEC D3
      5753   60     C  B01  69.22465      8000 1 : Experiment 1 30000 HCMEC D3
      5754   65     C  B01  69.84391      8000 1 : Experiment 1 30000 HCMEC D3
      5755   70     C  B01  70.58099      8000 1 : Experiment 1 30000 HCMEC D3
      5756   75     C  B01  71.79536      8000 1 : Experiment 1 30000 HCMEC D3
      5757   80     C  B01  72.86314      8000 1 : Experiment 1 30000 HCMEC D3
      5758   85     C  B01  73.41820      8000 1 : Experiment 1 30000 HCMEC D3
      5759   90     C  B01  74.26198      8000 1 : Experiment 1 30000 HCMEC D3
      5760   95     C  B01  75.86224      8000 1 : Experiment 1 30000 HCMEC D3
      5761  100     C  B01  77.16812      8000 1 : Experiment 1 30000 HCMEC D3
      5762  105     C  B01  78.57707      8000 1 : Experiment 1 30000 HCMEC D3
      5763  110     C  B01  79.79585      8000 1 : Experiment 1 30000 HCMEC D3
      5764  115     C  B01  81.00216      8000 1 : Experiment 1 30000 HCMEC D3
      5765  120     C  B01  82.20338      8000 1 : Experiment 1 30000 HCMEC D3
      5766  125     C  B01  83.39091      8000 1 : Experiment 1 30000 HCMEC D3
      5767  130     C  B01  84.86661      8000 1 : Experiment 1 30000 HCMEC D3
      5768  135     C  B01  85.99026      8000 1 : Experiment 1 30000 HCMEC D3
      5769  140     C  B01  87.51107      8000 1 : Experiment 1 30000 HCMEC D3
      5770  145     C  B01  88.44016      8000 1 : Experiment 1 30000 HCMEC D3
      5771  150     C  B01  89.61944      8000 1 : Experiment 1 30000 HCMEC D3
      5772  155     C  B01  90.40139      8000 1 : Experiment 1 30000 HCMEC D3
      5773  160     C  B01  91.64503      8000 1 : Experiment 1 30000 HCMEC D3
      5774  165     C  B01  92.17553      8000 1 : Experiment 1 30000 HCMEC D3
      5775  170     C  B01  93.26799      8000 1 : Experiment 1 30000 HCMEC D3
      5776  175     C  B01  94.12870      8000 1 : Experiment 1 30000 HCMEC D3
      5777  180     C  B01  94.98037      8000 1 : Experiment 1 30000 HCMEC D3
      5778  185     C  B01  95.23503      8000 1 : Experiment 1 30000 HCMEC D3
      5779  190     C  B01  95.68340      8000 1 : Experiment 1 30000 HCMEC D3
      5780  195     C  B01  96.91540      8000 1 : Experiment 1 30000 HCMEC D3
      5781  200     C  B01        NA      8000 1 : Experiment 1 30000 HCMEC D3
      5782    0     C  B02        NA      1000 1 : Experiment 1 30000 HCMEC D3
      5783    5     C  B02 117.47402      1000 1 : Experiment 1 30000 HCMEC D3
      5784   10     C  B02 116.10632      1000 1 : Experiment 1 30000 HCMEC D3
      5785   15     C  B02 114.94367      1000 1 : Experiment 1 30000 HCMEC D3
      5786   20     C  B02 114.30128      1000 1 : Experiment 1 30000 HCMEC D3
      5787   25     C  B02 114.08017      1000 1 : Experiment 1 30000 HCMEC D3
      5788   30     C  B02 114.26361      1000 1 : Experiment 1 30000 HCMEC D3
      5789   35     C  B02 114.92020      1000 1 : Experiment 1 30000 HCMEC D3
      5790   40     C  B02 115.32646      1000 1 : Experiment 1 30000 HCMEC D3
      5791   45     C  B02 115.99526      1000 1 : Experiment 1 30000 HCMEC D3
      5792   50     C  B02 116.74503      1000 1 : Experiment 1 30000 HCMEC D3
      5793   55     C  B02 117.28254      1000 1 : Experiment 1 30000 HCMEC D3
      5794   60     C  B02 117.73159      1000 1 : Experiment 1 30000 HCMEC D3
      5795   65     C  B02 118.30824      1000 1 : Experiment 1 30000 HCMEC D3
      5796   70     C  B02 118.85804      1000 1 : Experiment 1 30000 HCMEC D3
      5797   75     C  B02 119.23800      1000 1 : Experiment 1 30000 HCMEC D3
      5798   80     C  B02 119.48925      1000 1 : Experiment 1 30000 HCMEC D3
      5799   85     C  B02 119.76450      1000 1 : Experiment 1 30000 HCMEC D3
      5800   90     C  B02 120.10211      1000 1 : Experiment 1 30000 HCMEC D3
      5801   95     C  B02 120.45556      1000 1 : Experiment 1 30000 HCMEC D3
      5802  100     C  B02 120.66056      1000 1 : Experiment 1 30000 HCMEC D3
      5803  105     C  B02 120.98517      1000 1 : Experiment 1 30000 HCMEC D3
      5804  110     C  B02 121.26692      1000 1 : Experiment 1 30000 HCMEC D3
      5805  115     C  B02 121.60483      1000 1 : Experiment 1 30000 HCMEC D3
      5806  120     C  B02 121.81981      1000 1 : Experiment 1 30000 HCMEC D3
      5807  125     C  B02 122.11203      1000 1 : Experiment 1 30000 HCMEC D3
      5808  130     C  B02 122.28230      1000 1 : Experiment 1 30000 HCMEC D3
      5809  135     C  B02 122.55841      1000 1 : Experiment 1 30000 HCMEC D3
      5810  140     C  B02 122.72418      1000 1 : Experiment 1 30000 HCMEC D3
      5811  145     C  B02 122.82403      1000 1 : Experiment 1 30000 HCMEC D3
      5812  150     C  B02 122.99982      1000 1 : Experiment 1 30000 HCMEC D3
      5813  155     C  B02 123.19941      1000 1 : Experiment 1 30000 HCMEC D3
      5814  160     C  B02 123.42439      1000 1 : Experiment 1 30000 HCMEC D3
      5815  165     C  B02 123.55243      1000 1 : Experiment 1 30000 HCMEC D3
      5816  170     C  B02 123.65859      1000 1 : Experiment 1 30000 HCMEC D3
      5817  175     C  B02 123.88553      1000 1 : Experiment 1 30000 HCMEC D3
      5818  180     C  B02 124.05062      1000 1 : Experiment 1 30000 HCMEC D3
      5819  185     C  B02 124.16525      1000 1 : Experiment 1 30000 HCMEC D3
      5820  190     C  B02 124.21811      1000 1 : Experiment 1 30000 HCMEC D3
      5821  195     C  B02 124.35682      1000 1 : Experiment 1 30000 HCMEC D3
      5822  200     C  B02        NA      1000 1 : Experiment 1 30000 HCMEC D3
      5823    0     C  B02        NA     16000 1 : Experiment 1 30000 HCMEC D3
      5824    5     C  B02  80.06229     16000 1 : Experiment 1 30000 HCMEC D3
      5825   10     C  B02  69.84090     16000 1 : Experiment 1 30000 HCMEC D3
      5826   15     C  B02  60.06885     16000 1 : Experiment 1 30000 HCMEC D3
      5827   20     C  B02  52.64781     16000 1 : Experiment 1 30000 HCMEC D3
      5828   25     C  B02  48.49555     16000 1 : Experiment 1 30000 HCMEC D3
      5829   30     C  B02  45.88667     16000 1 : Experiment 1 30000 HCMEC D3
      5830   35     C  B02  44.51907     16000 1 : Experiment 1 30000 HCMEC D3
      5831   40     C  B02  42.66947     16000 1 : Experiment 1 30000 HCMEC D3
      5832   45     C  B02  41.49089     16000 1 : Experiment 1 30000 HCMEC D3
      5833   50     C  B02  41.06238     16000 1 : Experiment 1 30000 HCMEC D3
      5834   55     C  B02  40.95837     16000 1 : Experiment 1 30000 HCMEC D3
      5835   60     C  B02  40.84921     16000 1 : Experiment 1 30000 HCMEC D3
      5836   65     C  B02  41.23168     16000 1 : Experiment 1 30000 HCMEC D3
      5837   70     C  B02  41.77300     16000 1 : Experiment 1 30000 HCMEC D3
      5838   75     C  B02  42.14170     16000 1 : Experiment 1 30000 HCMEC D3
      5839   80     C  B02  42.87633     16000 1 : Experiment 1 30000 HCMEC D3
      5840   85     C  B02  43.57907     16000 1 : Experiment 1 30000 HCMEC D3
      5841   90     C  B02  44.66039     16000 1 : Experiment 1 30000 HCMEC D3
      5842   95     C  B02  46.20447     16000 1 : Experiment 1 30000 HCMEC D3
      5843  100     C  B02  47.32932     16000 1 : Experiment 1 30000 HCMEC D3
      5844  105     C  B02  48.70496     16000 1 : Experiment 1 30000 HCMEC D3
      5845  110     C  B02  50.08650     16000 1 : Experiment 1 30000 HCMEC D3
      5846  115     C  B02  52.01101     16000 1 : Experiment 1 30000 HCMEC D3
      5847  120     C  B02  53.15940     16000 1 : Experiment 1 30000 HCMEC D3
      5848  125     C  B02  54.65538     16000 1 : Experiment 1 30000 HCMEC D3
      5849  130     C  B02  56.10970     16000 1 : Experiment 1 30000 HCMEC D3
      5850  135     C  B02  57.62970     16000 1 : Experiment 1 30000 HCMEC D3
      5851  140     C  B02  58.68389     16000 1 : Experiment 1 30000 HCMEC D3
      5852  145     C  B02  59.81006     16000 1 : Experiment 1 30000 HCMEC D3
      5853  150     C  B02  61.08287     16000 1 : Experiment 1 30000 HCMEC D3
      5854  155     C  B02  62.56250     16000 1 : Experiment 1 30000 HCMEC D3
      5855  160     C  B02  64.09558     16000 1 : Experiment 1 30000 HCMEC D3
      5856  165     C  B02  65.13902     16000 1 : Experiment 1 30000 HCMEC D3
      5857  170     C  B02  66.28805     16000 1 : Experiment 1 30000 HCMEC D3
      5858  175     C  B02  67.52638     16000 1 : Experiment 1 30000 HCMEC D3
      5859  180     C  B02  68.77816     16000 1 : Experiment 1 30000 HCMEC D3
      5860  185     C  B02  69.74866     16000 1 : Experiment 1 30000 HCMEC D3
      5861  190     C  B02  70.50923     16000 1 : Experiment 1 30000 HCMEC D3
      5862  195     C  B02  72.01058     16000 1 : Experiment 1 30000 HCMEC D3
      5863  200     C  B02        NA     16000 1 : Experiment 1 30000 HCMEC D3
      5864    0     C  B02        NA      2000 1 : Experiment 1 30000 HCMEC D3
      5865    5     C  B02 112.31892      2000 1 : Experiment 1 30000 HCMEC D3
      5866   10     C  B02 108.88187      2000 1 : Experiment 1 30000 HCMEC D3
      5867   15     C  B02 105.72906      2000 1 : Experiment 1 30000 HCMEC D3
      5868   20     C  B02 103.75585      2000 1 : Experiment 1 30000 HCMEC D3
      5869   25     C  B02 103.04244      2000 1 : Experiment 1 30000 HCMEC D3
      5870   30     C  B02 102.96848      2000 1 : Experiment 1 30000 HCMEC D3
      5871   35     C  B02 103.73518      2000 1 : Experiment 1 30000 HCMEC D3
      5872   40     C  B02 104.32372      2000 1 : Experiment 1 30000 HCMEC D3
      5873   45     C  B02 105.39708      2000 1 : Experiment 1 30000 HCMEC D3
      5874   50     C  B02 106.69766      2000 1 : Experiment 1 30000 HCMEC D3
      5875   55     C  B02 107.89938      2000 1 : Experiment 1 30000 HCMEC D3
      5876   60     C  B02 108.54850      2000 1 : Experiment 1 30000 HCMEC D3
      5877   65     C  B02 109.40549      2000 1 : Experiment 1 30000 HCMEC D3
      5878   70     C  B02 110.31369      2000 1 : Experiment 1 30000 HCMEC D3
      5879   75     C  B02 110.81746      2000 1 : Experiment 1 30000 HCMEC D3
      5880   80     C  B02 111.16454      2000 1 : Experiment 1 30000 HCMEC D3
      5881   85     C  B02 111.58955      2000 1 : Experiment 1 30000 HCMEC D3
      5882   90     C  B02 112.09651      2000 1 : Experiment 1 30000 HCMEC D3
      5883   95     C  B02 112.74520      2000 1 : Experiment 1 30000 HCMEC D3
      5884  100     C  B02 113.07072      2000 1 : Experiment 1 30000 HCMEC D3
      5885  105     C  B02 113.65552      2000 1 : Experiment 1 30000 HCMEC D3
      5886  110     C  B02 114.20890      2000 1 : Experiment 1 30000 HCMEC D3
      5887  115     C  B02 114.85604      2000 1 : Experiment 1 30000 HCMEC D3
      5888  120     C  B02 115.28604      2000 1 : Experiment 1 30000 HCMEC D3
      5889  125     C  B02 115.89235      2000 1 : Experiment 1 30000 HCMEC D3
      5890  130     C  B02 116.24667      2000 1 : Experiment 1 30000 HCMEC D3
      5891  135     C  B02 116.79226      2000 1 : Experiment 1 30000 HCMEC D3
      5892  140     C  B02 117.12209      2000 1 : Experiment 1 30000 HCMEC D3
      5893  145     C  B02 117.30372      2000 1 : Experiment 1 30000 HCMEC D3
      5894  150     C  B02 117.67682      2000 1 : Experiment 1 30000 HCMEC D3
      5895  155     C  B02 118.09629      2000 1 : Experiment 1 30000 HCMEC D3
      5896  160     C  B02 118.58104      2000 1 : Experiment 1 30000 HCMEC D3
      5897  165     C  B02 118.85274      2000 1 : Experiment 1 30000 HCMEC D3
      5898  170     C  B02 119.09077      2000 1 : Experiment 1 30000 HCMEC D3
      5899  175     C  B02 119.60417      2000 1 : Experiment 1 30000 HCMEC D3
      5900  180     C  B02 119.98441      2000 1 : Experiment 1 30000 HCMEC D3
      5901  185     C  B02 120.26598      2000 1 : Experiment 1 30000 HCMEC D3
      5902  190     C  B02 120.35678      2000 1 : Experiment 1 30000 HCMEC D3
      5903  195     C  B02 120.74307      2000 1 : Experiment 1 30000 HCMEC D3
      5904  200     C  B02        NA      2000 1 : Experiment 1 30000 HCMEC D3
      5905    0     C  B02        NA       250 1 : Experiment 1 30000 HCMEC D3
      5906    5     C  B02 123.05728       250 1 : Experiment 1 30000 HCMEC D3
      5907   10     C  B02 122.69680       250 1 : Experiment 1 30000 HCMEC D3
      5908   15     C  B02 122.50832       250 1 : Experiment 1 30000 HCMEC D3
      5909   20     C  B02 122.48228       250 1 : Experiment 1 30000 HCMEC D3
      5910   25     C  B02 122.52821       250 1 : Experiment 1 30000 HCMEC D3
      5911   30     C  B02 122.69987       250 1 : Experiment 1 30000 HCMEC D3
      5912   35     C  B02 122.99361       250 1 : Experiment 1 30000 HCMEC D3
      5913   40     C  B02 123.25587       250 1 : Experiment 1 30000 HCMEC D3
      5914   45     C  B02 123.56828       250 1 : Experiment 1 30000 HCMEC D3
      5915   50     C  B02 123.90062       250 1 : Experiment 1 30000 HCMEC D3
      5916   55     C  B02 124.17365       250 1 : Experiment 1 30000 HCMEC D3
      5917   60     C  B02 124.44924       250 1 : Experiment 1 30000 HCMEC D3
      5918   65     C  B02 124.72991       250 1 : Experiment 1 30000 HCMEC D3
      5919   70     C  B02 124.96760       250 1 : Experiment 1 30000 HCMEC D3
      5920   75     C  B02 125.18186       250 1 : Experiment 1 30000 HCMEC D3
      5921   80     C  B02 125.37873       250 1 : Experiment 1 30000 HCMEC D3
      5922   85     C  B02 125.54236       250 1 : Experiment 1 30000 HCMEC D3
      5923   90     C  B02 125.70249       250 1 : Experiment 1 30000 HCMEC D3
      5924   95     C  B02 125.86357       250 1 : Experiment 1 30000 HCMEC D3
      5925  100     C  B02 125.98704       250 1 : Experiment 1 30000 HCMEC D3
      5926  105     C  B02 126.14537       250 1 : Experiment 1 30000 HCMEC D3
      5927  110     C  B02 126.26003       250 1 : Experiment 1 30000 HCMEC D3
      5928  115     C  B02 126.40137       250 1 : Experiment 1 30000 HCMEC D3
      5929  120     C  B02 126.50606       250 1 : Experiment 1 30000 HCMEC D3
      5930  125     C  B02 126.61381       250 1 : Experiment 1 30000 HCMEC D3
      5931  130     C  B02 126.70539       250 1 : Experiment 1 30000 HCMEC D3
      5932  135     C  B02 126.79912       250 1 : Experiment 1 30000 HCMEC D3
      5933  140     C  B02 126.89791       250 1 : Experiment 1 30000 HCMEC D3
      5934  145     C  B02 126.97963       250 1 : Experiment 1 30000 HCMEC D3
      5935  150     C  B02 127.05219       250 1 : Experiment 1 30000 HCMEC D3
      5936  155     C  B02 127.12423       250 1 : Experiment 1 30000 HCMEC D3
      5937  160     C  B02 127.20334       250 1 : Experiment 1 30000 HCMEC D3
      5938  165     C  B02 127.25932       250 1 : Experiment 1 30000 HCMEC D3
      5939  170     C  B02 127.31381       250 1 : Experiment 1 30000 HCMEC D3
      5940  175     C  B02 127.37480       250 1 : Experiment 1 30000 HCMEC D3
      5941  180     C  B02 127.41786       250 1 : Experiment 1 30000 HCMEC D3
      5942  185     C  B02 127.46520       250 1 : Experiment 1 30000 HCMEC D3
      5943  190     C  B02 127.49125       250 1 : Experiment 1 30000 HCMEC D3
      5944  195     C  B02 127.53207       250 1 : Experiment 1 30000 HCMEC D3
      5945  200     C  B02        NA       250 1 : Experiment 1 30000 HCMEC D3
      5946    0     C  B02        NA     32000 1 : Experiment 1 30000 HCMEC D3
      5947    5     C  B02  67.55532     32000 1 : Experiment 1 30000 HCMEC D3
      5948   10     C  B02  57.21802     32000 1 : Experiment 1 30000 HCMEC D3
      5949   15     C  B02  47.30611     32000 1 : Experiment 1 30000 HCMEC D3
      5950   20     C  B02  39.44140     32000 1 : Experiment 1 30000 HCMEC D3
      5951   25     C  B02  34.84962     32000 1 : Experiment 1 30000 HCMEC D3
      5952   30     C  B02  31.80778     32000 1 : Experiment 1 30000 HCMEC D3
      5953   35     C  B02  30.01293     32000 1 : Experiment 1 30000 HCMEC D3
      5954   40     C  B02  27.27705     32000 1 : Experiment 1 30000 HCMEC D3
      5955   45     C  B02  24.73291     32000 1 : Experiment 1 30000 HCMEC D3
      5956   50     C  B02  23.04561     32000 1 : Experiment 1 30000 HCMEC D3
      5957   55     C  B02  21.48129     32000 1 : Experiment 1 30000 HCMEC D3
      5958   60     C  B02  21.00990     32000 1 : Experiment 1 30000 HCMEC D3
      5959   65     C  B02  20.92781     32000 1 : Experiment 1 30000 HCMEC D3
      5960   70     C  B02  21.01736     32000 1 : Experiment 1 30000 HCMEC D3
      5961   75     C  B02  21.24698     32000 1 : Experiment 1 30000 HCMEC D3
      5962   80     C  B02  21.58623     32000 1 : Experiment 1 30000 HCMEC D3
      5963   85     C  B02  22.07037     32000 1 : Experiment 1 30000 HCMEC D3
      5964   90     C  B02  22.70925     32000 1 : Experiment 1 30000 HCMEC D3
      5965   95     C  B02  23.59014     32000 1 : Experiment 1 30000 HCMEC D3
      5966  100     C  B02  24.37185     32000 1 : Experiment 1 30000 HCMEC D3
      5967  105     C  B02  25.23160     32000 1 : Experiment 1 30000 HCMEC D3
      5968  110     C  B02  26.24986     32000 1 : Experiment 1 30000 HCMEC D3
      5969  115     C  B02  27.47367     32000 1 : Experiment 1 30000 HCMEC D3
      5970  120     C  B02  28.32166     32000 1 : Experiment 1 30000 HCMEC D3
      5971  125     C  B02  29.35130     32000 1 : Experiment 1 30000 HCMEC D3
      5972  130     C  B02  30.36844     32000 1 : Experiment 1 30000 HCMEC D3
      5973  135     C  B02  31.53843     32000 1 : Experiment 1 30000 HCMEC D3
      5974  140     C  B02  32.29792     32000 1 : Experiment 1 30000 HCMEC D3
      5975  145     C  B02  33.26104     32000 1 : Experiment 1 30000 HCMEC D3
      5976  150     C  B02  34.30746     32000 1 : Experiment 1 30000 HCMEC D3
      5977  155     C  B02  35.70953     32000 1 : Experiment 1 30000 HCMEC D3
      5978  160     C  B02  37.13792     32000 1 : Experiment 1 30000 HCMEC D3
      5979  165     C  B02  38.16006     32000 1 : Experiment 1 30000 HCMEC D3
      5980  170     C  B02  39.16546     32000 1 : Experiment 1 30000 HCMEC D3
      5981  175     C  B02  40.36439     32000 1 : Experiment 1 30000 HCMEC D3
      5982  180     C  B02  41.49671     32000 1 : Experiment 1 30000 HCMEC D3
      5983  185     C  B02  42.68877     32000 1 : Experiment 1 30000 HCMEC D3
      5984  190     C  B02  43.48051     32000 1 : Experiment 1 30000 HCMEC D3
      5985  195     C  B02  45.01531     32000 1 : Experiment 1 30000 HCMEC D3
      5986  200     C  B02        NA     32000 1 : Experiment 1 30000 HCMEC D3
      5987    0     C  B02        NA      4000 1 : Experiment 1 30000 HCMEC D3
      5988    5     C  B02 103.84050      4000 1 : Experiment 1 30000 HCMEC D3
      5989   10     C  B02  97.70354      4000 1 : Experiment 1 30000 HCMEC D3
      5990   15     C  B02  91.94278      4000 1 : Experiment 1 30000 HCMEC D3
      5991   20     C  B02  88.12983      4000 1 : Experiment 1 30000 HCMEC D3
      5992   25     C  B02  86.54613      4000 1 : Experiment 1 30000 HCMEC D3
      5993   30     C  B02  85.87049      4000 1 : Experiment 1 30000 HCMEC D3
      5994   35     C  B02  86.23973      4000 1 : Experiment 1 30000 HCMEC D3
      5995   40     C  B02  86.63220      4000 1 : Experiment 1 30000 HCMEC D3
      5996   45     C  B02  87.82641      4000 1 : Experiment 1 30000 HCMEC D3
      5997   50     C  B02  89.57362      4000 1 : Experiment 1 30000 HCMEC D3
      5998   55     C  B02  91.50867      4000 1 : Experiment 1 30000 HCMEC D3
      5999   60     C  B02  92.36282      4000 1 : Experiment 1 30000 HCMEC D3
      6000   65     C  B02  93.52595      4000 1 : Experiment 1 30000 HCMEC D3
      6001   70     C  B02  94.79713      4000 1 : Experiment 1 30000 HCMEC D3
      6002   75     C  B02  95.37840      4000 1 : Experiment 1 30000 HCMEC D3
      6003   80     C  B02  96.04762      4000 1 : Experiment 1 30000 HCMEC D3
      6004   85     C  B02  96.63924      4000 1 : Experiment 1 30000 HCMEC D3
      6005   90     C  B02  97.44475      4000 1 : Experiment 1 30000 HCMEC D3
      6006   95     C  B02  98.63133      4000 1 : Experiment 1 30000 HCMEC D3
      6007  100     C  B02  99.26099      4000 1 : Experiment 1 30000 HCMEC D3
      6008  105     C  B02 100.22743      4000 1 : Experiment 1 30000 HCMEC D3
      6009  110     C  B02 101.05796      4000 1 : Experiment 1 30000 HCMEC D3
      6010  115     C  B02 102.18536      4000 1 : Experiment 1 30000 HCMEC D3
      6011  120     C  B02 102.84041      4000 1 : Experiment 1 30000 HCMEC D3
      6012  125     C  B02 103.85152      4000 1 : Experiment 1 30000 HCMEC D3
      6013  130     C  B02 104.51374      4000 1 : Experiment 1 30000 HCMEC D3
      6014  135     C  B02 105.44425      4000 1 : Experiment 1 30000 HCMEC D3
      6015  140     C  B02 105.98672      4000 1 : Experiment 1 30000 HCMEC D3
      6016  145     C  B02 106.31824      4000 1 : Experiment 1 30000 HCMEC D3
      6017  150     C  B02 106.96581      4000 1 : Experiment 1 30000 HCMEC D3
      6018  155     C  B02 107.65736      4000 1 : Experiment 1 30000 HCMEC D3
      6019  160     C  B02 108.43197      4000 1 : Experiment 1 30000 HCMEC D3
      6020  165     C  B02 108.89594      4000 1 : Experiment 1 30000 HCMEC D3
      6021  170     C  B02 109.35669      4000 1 : Experiment 1 30000 HCMEC D3
      6022  175     C  B02 110.16567      4000 1 : Experiment 1 30000 HCMEC D3
      6023  180     C  B02 110.81711      4000 1 : Experiment 1 30000 HCMEC D3
      6024  185     C  B02 111.24954      4000 1 : Experiment 1 30000 HCMEC D3
      6025  190     C  B02 111.45218      4000 1 : Experiment 1 30000 HCMEC D3
      6026  195     C  B02 112.21073      4000 1 : Experiment 1 30000 HCMEC D3
      6027  200     C  B02        NA      4000 1 : Experiment 1 30000 HCMEC D3
      6028    0     C  B02        NA       500 1 : Experiment 1 30000 HCMEC D3
      6029    5     C  B02 120.79591       500 1 : Experiment 1 30000 HCMEC D3
      6030   10     C  B02 120.25906       500 1 : Experiment 1 30000 HCMEC D3
      6031   15     C  B02 119.89570       500 1 : Experiment 1 30000 HCMEC D3
      6032   20     C  B02 119.75623       500 1 : Experiment 1 30000 HCMEC D3
      6033   25     C  B02 119.72338       500 1 : Experiment 1 30000 HCMEC D3
      6034   30     C  B02 119.89460       500 1 : Experiment 1 30000 HCMEC D3
      6035   35     C  B02 120.33532       500 1 : Experiment 1 30000 HCMEC D3
      6036   40     C  B02 120.66019       500 1 : Experiment 1 30000 HCMEC D3
      6037   45     C  B02 121.09217       500 1 : Experiment 1 30000 HCMEC D3
      6038   50     C  B02 121.56059       500 1 : Experiment 1 30000 HCMEC D3
      6039   55     C  B02 121.87071       500 1 : Experiment 1 30000 HCMEC D3
      6040   60     C  B02 122.19154       500 1 : Experiment 1 30000 HCMEC D3
      6041   65     C  B02 122.57658       500 1 : Experiment 1 30000 HCMEC D3
      6042   70     C  B02 122.90059       500 1 : Experiment 1 30000 HCMEC D3
      6043   75     C  B02 123.17267       500 1 : Experiment 1 30000 HCMEC D3
      6044   80     C  B02 123.37846       500 1 : Experiment 1 30000 HCMEC D3
      6045   85     C  B02 123.56975       500 1 : Experiment 1 30000 HCMEC D3
      6046   90     C  B02 123.78845       500 1 : Experiment 1 30000 HCMEC D3
      6047   95     C  B02 123.98659       500 1 : Experiment 1 30000 HCMEC D3
      6048  100     C  B02 124.13743       500 1 : Experiment 1 30000 HCMEC D3
      6049  105     C  B02 124.33394       500 1 : Experiment 1 30000 HCMEC D3
      6050  110     C  B02 124.49623       500 1 : Experiment 1 30000 HCMEC D3
      6051  115     C  B02 124.69191       500 1 : Experiment 1 30000 HCMEC D3
      6052  120     C  B02 124.82652       500 1 : Experiment 1 30000 HCMEC D3
      6053  125     C  B02 124.97694       500 1 : Experiment 1 30000 HCMEC D3
      6054  130     C  B02 125.10419       500 1 : Experiment 1 30000 HCMEC D3
      6055  135     C  B02 125.24445       500 1 : Experiment 1 30000 HCMEC D3
      6056  140     C  B02 125.35330       500 1 : Experiment 1 30000 HCMEC D3
      6057  145     C  B02 125.42973       500 1 : Experiment 1 30000 HCMEC D3
      6058  150     C  B02 125.53517       500 1 : Experiment 1 30000 HCMEC D3
      6059  155     C  B02 125.64060       500 1 : Experiment 1 30000 HCMEC D3
      6060  160     C  B02 125.73986       500 1 : Experiment 1 30000 HCMEC D3
      6061  165     C  B02 125.82357       500 1 : Experiment 1 30000 HCMEC D3
      6062  170     C  B02 125.88962       500 1 : Experiment 1 30000 HCMEC D3
      6063  175     C  B02 125.99081       500 1 : Experiment 1 30000 HCMEC D3
      6064  180     C  B02 126.07240       500 1 : Experiment 1 30000 HCMEC D3
      6065  185     C  B02 126.12017       500 1 : Experiment 1 30000 HCMEC D3
      6066  190     C  B02 126.15668       500 1 : Experiment 1 30000 HCMEC D3
      6067  195     C  B02 126.22098       500 1 : Experiment 1 30000 HCMEC D3
      6068  200     C  B02        NA       500 1 : Experiment 1 30000 HCMEC D3
      6069    0     C  B02        NA     64000 1 : Experiment 1 30000 HCMEC D3
      6070    5     C  B02  51.38436     64000 1 : Experiment 1 30000 HCMEC D3
      6071   10     C  B02  43.08274     64000 1 : Experiment 1 30000 HCMEC D3
      6072   15     C  B02  34.99041     64000 1 : Experiment 1 30000 HCMEC D3
      6073   20     C  B02  28.35793     64000 1 : Experiment 1 30000 HCMEC D3
      6074   25     C  B02  24.45435     64000 1 : Experiment 1 30000 HCMEC D3
      6075   30     C  B02  21.76230     64000 1 : Experiment 1 30000 HCMEC D3
      6076   35     C  B02  20.08548     64000 1 : Experiment 1 30000 HCMEC D3
      6077   40     C  B02  17.38373     64000 1 : Experiment 1 30000 HCMEC D3
      6078   45     C  B02  14.54821     64000 1 : Experiment 1 30000 HCMEC D3
      6079   50     C  B02  12.75969     64000 1 : Experiment 1 30000 HCMEC D3
      6080   55     C  B02  11.14880     64000 1 : Experiment 1 30000 HCMEC D3
      6081   60     C  B02  10.81134     64000 1 : Experiment 1 30000 HCMEC D3
      6082   65     C  B02  10.71027     64000 1 : Experiment 1 30000 HCMEC D3
      6083   70     C  B02  10.69881     64000 1 : Experiment 1 30000 HCMEC D3
      6084   75     C  B02  10.86312     64000 1 : Experiment 1 30000 HCMEC D3
      6085   80     C  B02  10.96966     64000 1 : Experiment 1 30000 HCMEC D3
      6086   85     C  B02  11.20665     64000 1 : Experiment 1 30000 HCMEC D3
      6087   90     C  B02  11.47660     64000 1 : Experiment 1 30000 HCMEC D3
      6088   95     C  B02  11.80564     64000 1 : Experiment 1 30000 HCMEC D3
      6089  100     C  B02  12.19301     64000 1 : Experiment 1 30000 HCMEC D3
      6090  105     C  B02  12.52562     64000 1 : Experiment 1 30000 HCMEC D3
      6091  110     C  B02  13.06557     64000 1 : Experiment 1 30000 HCMEC D3
      6092  115     C  B02  13.54239     64000 1 : Experiment 1 30000 HCMEC D3
      6093  120     C  B02  13.95081     64000 1 : Experiment 1 30000 HCMEC D3
      6094  125     C  B02  14.40766     64000 1 : Experiment 1 30000 HCMEC D3
      6095  130     C  B02  14.85494     64000 1 : Experiment 1 30000 HCMEC D3
      6096  135     C  B02  15.46884     64000 1 : Experiment 1 30000 HCMEC D3
      6097  140     C  B02  15.78142     64000 1 : Experiment 1 30000 HCMEC D3
      6098  145     C  B02  16.25959     64000 1 : Experiment 1 30000 HCMEC D3
      6099  150     C  B02  16.81753     64000 1 : Experiment 1 30000 HCMEC D3
      6100  155     C  B02  17.60501     64000 1 : Experiment 1 30000 HCMEC D3
      6101  160     C  B02  18.41213     64000 1 : Experiment 1 30000 HCMEC D3
      6102  165     C  B02  19.05070     64000 1 : Experiment 1 30000 HCMEC D3
      6103  170     C  B02  19.54391     64000 1 : Experiment 1 30000 HCMEC D3
      6104  175     C  B02  20.38117     64000 1 : Experiment 1 30000 HCMEC D3
      6105  180     C  B02  20.90354     64000 1 : Experiment 1 30000 HCMEC D3
      6106  185     C  B02  21.84501     64000 1 : Experiment 1 30000 HCMEC D3
      6107  190     C  B02  22.30848     64000 1 : Experiment 1 30000 HCMEC D3
      6108  195     C  B02  23.34426     64000 1 : Experiment 1 30000 HCMEC D3
      6109  200     C  B02        NA     64000 1 : Experiment 1 30000 HCMEC D3
      6110    0     C  B02        NA      8000 1 : Experiment 1 30000 HCMEC D3
      6111    5     C  B02  92.01741      8000 1 : Experiment 1 30000 HCMEC D3
      6112   10     C  B02  83.39373      8000 1 : Experiment 1 30000 HCMEC D3
      6113   15     C  B02  75.24545      8000 1 : Experiment 1 30000 HCMEC D3
      6114   20     C  B02  69.50576      8000 1 : Experiment 1 30000 HCMEC D3
      6115   25     C  B02  66.59559      8000 1 : Experiment 1 30000 HCMEC D3
      6116   30     C  B02  64.90192      8000 1 : Experiment 1 30000 HCMEC D3
      6117   35     C  B02  64.39615      8000 1 : Experiment 1 30000 HCMEC D3
      6118   40     C  B02  63.86291      8000 1 : Experiment 1 30000 HCMEC D3
      6119   45     C  B02  64.33716      8000 1 : Experiment 1 30000 HCMEC D3
      6120   50     C  B02  65.56941      8000 1 : Experiment 1 30000 HCMEC D3
      6121   55     C  B02  67.27172      8000 1 : Experiment 1 30000 HCMEC D3
      6122   60     C  B02  67.89720      8000 1 : Experiment 1 30000 HCMEC D3
      6123   65     C  B02  68.94140      8000 1 : Experiment 1 30000 HCMEC D3
      6124   70     C  B02  70.09191      8000 1 : Experiment 1 30000 HCMEC D3
      6125   75     C  B02  70.61151      8000 1 : Experiment 1 30000 HCMEC D3
      6126   80     C  B02  71.52801      8000 1 : Experiment 1 30000 HCMEC D3
      6127   85     C  B02  72.22399      8000 1 : Experiment 1 30000 HCMEC D3
      6128   90     C  B02  73.34551      8000 1 : Experiment 1 30000 HCMEC D3
      6129   95     C  B02  74.95841      8000 1 : Experiment 1 30000 HCMEC D3
      6130  100     C  B02  75.96642      8000 1 : Experiment 1 30000 HCMEC D3
      6131  105     C  B02  77.33799      8000 1 : Experiment 1 30000 HCMEC D3
      6132  110     C  B02  78.54704      8000 1 : Experiment 1 30000 HCMEC D3
      6133  115     C  B02  80.28715      8000 1 : Experiment 1 30000 HCMEC D3
      6134  120     C  B02  81.27700      8000 1 : Experiment 1 30000 HCMEC D3
      6135  125     C  B02  82.65434      8000 1 : Experiment 1 30000 HCMEC D3
      6136  130     C  B02  83.85291      8000 1 : Experiment 1 30000 HCMEC D3
      6137  135     C  B02  85.20306      8000 1 : Experiment 1 30000 HCMEC D3
      6138  140     C  B02  86.04485      8000 1 : Experiment 1 30000 HCMEC D3
      6139  145     C  B02  86.79953      8000 1 : Experiment 1 30000 HCMEC D3
      6140  150     C  B02  87.80223      8000 1 : Experiment 1 30000 HCMEC D3
      6141  155     C  B02  88.89846      8000 1 : Experiment 1 30000 HCMEC D3
      6142  160     C  B02  90.09145      8000 1 : Experiment 1 30000 HCMEC D3
      6143  165     C  B02  90.82824      8000 1 : Experiment 1 30000 HCMEC D3
      6144  170     C  B02  91.64422      8000 1 : Experiment 1 30000 HCMEC D3
      6145  175     C  B02  92.69155      8000 1 : Experiment 1 30000 HCMEC D3
      6146  180     C  B02  93.65171      8000 1 : Experiment 1 30000 HCMEC D3
      6147  185     C  B02  94.28367      8000 1 : Experiment 1 30000 HCMEC D3
      6148  190     C  B02  94.67942      8000 1 : Experiment 1 30000 HCMEC D3
      6149  195     C  B02  95.81262      8000 1 : Experiment 1 30000 HCMEC D3
      6150  200     C  B02        NA      8000 1 : Experiment 1 30000 HCMEC D3
      6151    0     C  B03        NA      1000 1 : Experiment 1 30000 HCMEC D3
      6152    5     C  B03 118.66826      1000 1 : Experiment 1 30000 HCMEC D3
      6153   10     C  B03 117.81245      1000 1 : Experiment 1 30000 HCMEC D3
      6154   15     C  B03 116.44761      1000 1 : Experiment 1 30000 HCMEC D3
      6155   20     C  B03 115.65036      1000 1 : Experiment 1 30000 HCMEC D3
      6156   25     C  B03 115.12326      1000 1 : Experiment 1 30000 HCMEC D3
      6157   30     C  B03 114.96674      1000 1 : Experiment 1 30000 HCMEC D3
      6158   35     C  B03 115.36798      1000 1 : Experiment 1 30000 HCMEC D3
      6159   40     C  B03 115.35884      1000 1 : Experiment 1 30000 HCMEC D3
      6160   45     C  B03 116.13126      1000 1 : Experiment 1 30000 HCMEC D3
      6161   50     C  B03 116.79973      1000 1 : Experiment 1 30000 HCMEC D3
      6162   55     C  B03 117.60490      1000 1 : Experiment 1 30000 HCMEC D3
      6163   60     C  B03 118.28590      1000 1 : Experiment 1 30000 HCMEC D3
      6164   65     C  B03 119.00908      1000 1 : Experiment 1 30000 HCMEC D3
      6165   70     C  B03 119.66373      1000 1 : Experiment 1 30000 HCMEC D3
      6166   75     C  B03 120.12228      1000 1 : Experiment 1 30000 HCMEC D3
      6167   80     C  B03 120.32605      1000 1 : Experiment 1 30000 HCMEC D3
      6168   85     C  B03 120.61748      1000 1 : Experiment 1 30000 HCMEC D3
      6169   90     C  B03 121.00725      1000 1 : Experiment 1 30000 HCMEC D3
      6170   95     C  B03 121.36197      1000 1 : Experiment 1 30000 HCMEC D3
      6171  100     C  B03 121.67013      1000 1 : Experiment 1 30000 HCMEC D3
      6172  105     C  B03 121.93454      1000 1 : Experiment 1 30000 HCMEC D3
      6173  110     C  B03 122.21446      1000 1 : Experiment 1 30000 HCMEC D3
      6174  115     C  B03 122.41908      1000 1 : Experiment 1 30000 HCMEC D3
      6175  120     C  B03 122.68092      1000 1 : Experiment 1 30000 HCMEC D3
      6176  125     C  B03 123.02156      1000 1 : Experiment 1 30000 HCMEC D3
      6177  130     C  B03 123.26308      1000 1 : Experiment 1 30000 HCMEC D3
      6178  135     C  B03 123.40532      1000 1 : Experiment 1 30000 HCMEC D3
      6179  140     C  B03 123.54515      1000 1 : Experiment 1 30000 HCMEC D3
      6180  145     C  B03 123.67579      1000 1 : Experiment 1 30000 HCMEC D3
      6181  150     C  B03 123.91393      1000 1 : Experiment 1 30000 HCMEC D3
      6182  155     C  B03 123.99516      1000 1 : Experiment 1 30000 HCMEC D3
      6183  160     C  B03 124.23099      1000 1 : Experiment 1 30000 HCMEC D3
      6184  165     C  B03 124.38803      1000 1 : Experiment 1 30000 HCMEC D3
      6185  170     C  B03 124.55257      1000 1 : Experiment 1 30000 HCMEC D3
      6186  175     C  B03 124.71827      1000 1 : Experiment 1 30000 HCMEC D3
      6187  180     C  B03 124.80101      1000 1 : Experiment 1 30000 HCMEC D3
      6188  185     C  B03 124.97050      1000 1 : Experiment 1 30000 HCMEC D3
      6189  190     C  B03 124.98902      1000 1 : Experiment 1 30000 HCMEC D3
      6190  195     C  B03 125.12292      1000 1 : Experiment 1 30000 HCMEC D3
      6191  200     C  B03        NA      1000 1 : Experiment 1 30000 HCMEC D3
      6192    0     C  B03        NA     16000 1 : Experiment 1 30000 HCMEC D3
      6193    5     C  B03  84.83278     16000 1 : Experiment 1 30000 HCMEC D3
      6194   10     C  B03  77.30691     16000 1 : Experiment 1 30000 HCMEC D3
      6195   15     C  B03  68.36439     16000 1 : Experiment 1 30000 HCMEC D3
      6196   20     C  B03  61.09856     16000 1 : Experiment 1 30000 HCMEC D3
      6197   25     C  B03  54.88399     16000 1 : Experiment 1 30000 HCMEC D3
      6198   30     C  B03  51.19706     16000 1 : Experiment 1 30000 HCMEC D3
      6199   35     C  B03  48.98987     16000 1 : Experiment 1 30000 HCMEC D3
      6200   40     C  B03  45.53939     16000 1 : Experiment 1 30000 HCMEC D3
      6201   45     C  B03  43.63705     16000 1 : Experiment 1 30000 HCMEC D3
      6202   50     C  B03  42.66192     16000 1 : Experiment 1 30000 HCMEC D3
      6203   55     C  B03  41.56091     16000 1 : Experiment 1 30000 HCMEC D3
      6204   60     C  B03  41.63825     16000 1 : Experiment 1 30000 HCMEC D3
      6205   65     C  B03  41.92252     16000 1 : Experiment 1 30000 HCMEC D3
      6206   70     C  B03  42.44134     16000 1 : Experiment 1 30000 HCMEC D3
      6207   75     C  B03  43.11969     16000 1 : Experiment 1 30000 HCMEC D3
      6208   80     C  B03  43.27717     16000 1 : Experiment 1 30000 HCMEC D3
      6209   85     C  B03  44.33565     16000 1 : Experiment 1 30000 HCMEC D3
      6210   90     C  B03  45.25127     16000 1 : Experiment 1 30000 HCMEC D3
      6211   95     C  B03  47.11848     16000 1 : Experiment 1 30000 HCMEC D3
      6212  100     C  B03  48.26454     16000 1 : Experiment 1 30000 HCMEC D3
      6213  105     C  B03  49.87210     16000 1 : Experiment 1 30000 HCMEC D3
      6214  110     C  B03  51.67456     16000 1 : Experiment 1 30000 HCMEC D3
      6215  115     C  B03  53.04802     16000 1 : Experiment 1 30000 HCMEC D3
      6216  120     C  B03  54.48021     16000 1 : Experiment 1 30000 HCMEC D3
      6217  125     C  B03  55.98402     16000 1 : Experiment 1 30000 HCMEC D3
      6218  130     C  B03  57.51257     16000 1 : Experiment 1 30000 HCMEC D3
      6219  135     C  B03  58.70012     16000 1 : Experiment 1 30000 HCMEC D3
      6220  140     C  B03  59.81365     16000 1 : Experiment 1 30000 HCMEC D3
      6221  145     C  B03  61.21784     16000 1 : Experiment 1 30000 HCMEC D3
      6222  150     C  B03  62.78159     16000 1 : Experiment 1 30000 HCMEC D3
      6223  155     C  B03  63.95767     16000 1 : Experiment 1 30000 HCMEC D3
      6224  160     C  B03  65.18428     16000 1 : Experiment 1 30000 HCMEC D3
      6225  165     C  B03  66.43638     16000 1 : Experiment 1 30000 HCMEC D3
      6226  170     C  B03  67.97609     16000 1 : Experiment 1 30000 HCMEC D3
      6227  175     C  B03  69.23450     16000 1 : Experiment 1 30000 HCMEC D3
      6228  180     C  B03  70.44851     16000 1 : Experiment 1 30000 HCMEC D3
      6229  185     C  B03  71.56999     16000 1 : Experiment 1 30000 HCMEC D3
      6230  190     C  B03  72.39812     16000 1 : Experiment 1 30000 HCMEC D3
      6231  195     C  B03  73.60798     16000 1 : Experiment 1 30000 HCMEC D3
      6232  200     C  B03        NA     16000 1 : Experiment 1 30000 HCMEC D3
      6233    0     C  B03        NA      2000 1 : Experiment 1 30000 HCMEC D3
      6234    5     C  B03 114.40839      2000 1 : Experiment 1 30000 HCMEC D3
      6235   10     C  B03 111.91508      2000 1 : Experiment 1 30000 HCMEC D3
      6236   15     C  B03 108.46146      2000 1 : Experiment 1 30000 HCMEC D3
      6237   20     C  B03 106.28748      2000 1 : Experiment 1 30000 HCMEC D3
      6238   25     C  B03 104.66524      2000 1 : Experiment 1 30000 HCMEC D3
      6239   30     C  B03 103.87504      2000 1 : Experiment 1 30000 HCMEC D3
      6240   35     C  B03 104.08162      2000 1 : Experiment 1 30000 HCMEC D3
      6241   40     C  B03 103.71400      2000 1 : Experiment 1 30000 HCMEC D3
      6242   45     C  B03 104.74353      2000 1 : Experiment 1 30000 HCMEC D3
      6243   50     C  B03 105.75723      2000 1 : Experiment 1 30000 HCMEC D3
      6244   55     C  B03 107.24012      2000 1 : Experiment 1 30000 HCMEC D3
      6245   60     C  B03 108.57713      2000 1 : Experiment 1 30000 HCMEC D3
      6246   65     C  B03 109.86340      2000 1 : Experiment 1 30000 HCMEC D3
      6247   70     C  B03 110.94933      2000 1 : Experiment 1 30000 HCMEC D3
      6248   75     C  B03 111.78723      2000 1 : Experiment 1 30000 HCMEC D3
      6249   80     C  B03 111.97213      2000 1 : Experiment 1 30000 HCMEC D3
      6250   85     C  B03 112.45497      2000 1 : Experiment 1 30000 HCMEC D3
      6251   90     C  B03 113.07943      2000 1 : Experiment 1 30000 HCMEC D3
      6252   95     C  B03 113.75314      2000 1 : Experiment 1 30000 HCMEC D3
      6253  100     C  B03 114.32957      2000 1 : Experiment 1 30000 HCMEC D3
      6254  105     C  B03 114.88122      2000 1 : Experiment 1 30000 HCMEC D3
      6255  110     C  B03 115.45132      2000 1 : Experiment 1 30000 HCMEC D3
      6256  115     C  B03 115.88440      2000 1 : Experiment 1 30000 HCMEC D3
      6257  120     C  B03 116.42922      2000 1 : Experiment 1 30000 HCMEC D3
      6258  125     C  B03 117.06818      2000 1 : Experiment 1 30000 HCMEC D3
      6259  130     C  B03 117.56179      2000 1 : Experiment 1 30000 HCMEC D3
      6260  135     C  B03 117.81977      2000 1 : Experiment 1 30000 HCMEC D3
      6261  140     C  B03 118.11636      2000 1 : Experiment 1 30000 HCMEC D3
      6262  145     C  B03 118.39390      2000 1 : Experiment 1 30000 HCMEC D3
      6263  150     C  B03 118.93497      2000 1 : Experiment 1 30000 HCMEC D3
      6264  155     C  B03 119.09125      2000 1 : Experiment 1 30000 HCMEC D3
      6265  160     C  B03 119.55708      2000 1 : Experiment 1 30000 HCMEC D3
      6266  165     C  B03 119.88491      2000 1 : Experiment 1 30000 HCMEC D3
      6267  170     C  B03 120.27025      2000 1 : Experiment 1 30000 HCMEC D3
      6268  175     C  B03 120.61726      2000 1 : Experiment 1 30000 HCMEC D3
      6269  180     C  B03 120.83663      2000 1 : Experiment 1 30000 HCMEC D3
      6270  185     C  B03 121.22202      2000 1 : Experiment 1 30000 HCMEC D3
      6271  190     C  B03 121.27080      2000 1 : Experiment 1 30000 HCMEC D3
      6272  195     C  B03 121.61526      2000 1 : Experiment 1 30000 HCMEC D3
      6273  200     C  B03        NA      2000 1 : Experiment 1 30000 HCMEC D3
      6274    0     C  B03        NA       250 1 : Experiment 1 30000 HCMEC D3
      6275    5     C  B03 123.70990       250 1 : Experiment 1 30000 HCMEC D3
      6276   10     C  B03 123.55254       250 1 : Experiment 1 30000 HCMEC D3
      6277   15     C  B03 123.38106       250 1 : Experiment 1 30000 HCMEC D3
      6278   20     C  B03 123.29480       250 1 : Experiment 1 30000 HCMEC D3
      6279   25     C  B03 123.31034       250 1 : Experiment 1 30000 HCMEC D3
      6280   30     C  B03 123.41445       250 1 : Experiment 1 30000 HCMEC D3
      6281   35     C  B03 123.64891       250 1 : Experiment 1 30000 HCMEC D3
      6282   40     C  B03 123.80606       250 1 : Experiment 1 30000 HCMEC D3
      6283   45     C  B03 124.13552       250 1 : Experiment 1 30000 HCMEC D3
      6284   50     C  B03 124.43145       250 1 : Experiment 1 30000 HCMEC D3
      6285   55     C  B03 124.71308       250 1 : Experiment 1 30000 HCMEC D3
      6286   60     C  B03 125.00234       250 1 : Experiment 1 30000 HCMEC D3
      6287   65     C  B03 125.29368       250 1 : Experiment 1 30000 HCMEC D3
      6288   70     C  B03 125.56834       250 1 : Experiment 1 30000 HCMEC D3
      6289   75     C  B03 125.79665       250 1 : Experiment 1 30000 HCMEC D3
      6290   80     C  B03 126.00656       250 1 : Experiment 1 30000 HCMEC D3
      6291   85     C  B03 126.18881       250 1 : Experiment 1 30000 HCMEC D3
      6292   90     C  B03 126.35736       250 1 : Experiment 1 30000 HCMEC D3
      6293   95     C  B03 126.51557       250 1 : Experiment 1 30000 HCMEC D3
      6294  100     C  B03 126.67367       250 1 : Experiment 1 30000 HCMEC D3
      6295  105     C  B03 126.81196       250 1 : Experiment 1 30000 HCMEC D3
      6296  110     C  B03 126.94121       250 1 : Experiment 1 30000 HCMEC D3
      6297  115     C  B03 127.05141       250 1 : Experiment 1 30000 HCMEC D3
      6298  120     C  B03 127.16463       250 1 : Experiment 1 30000 HCMEC D3
      6299  125     C  B03 127.28959       250 1 : Experiment 1 30000 HCMEC D3
      6300  130     C  B03 127.39434       250 1 : Experiment 1 30000 HCMEC D3
      6301  135     C  B03 127.48492       250 1 : Experiment 1 30000 HCMEC D3
      6302  140     C  B03 127.57739       250 1 : Experiment 1 30000 HCMEC D3
      6303  145     C  B03 127.66318       250 1 : Experiment 1 30000 HCMEC D3
      6304  150     C  B03 127.74984       250 1 : Experiment 1 30000 HCMEC D3
      6305  155     C  B03 127.82136       250 1 : Experiment 1 30000 HCMEC D3
      6306  160     C  B03 127.90303       250 1 : Experiment 1 30000 HCMEC D3
      6307  165     C  B03 127.97017       250 1 : Experiment 1 30000 HCMEC D3
      6308  170     C  B03 128.03829       250 1 : Experiment 1 30000 HCMEC D3
      6309  175     C  B03 128.10271       250 1 : Experiment 1 30000 HCMEC D3
      6310  180     C  B03 128.15548       250 1 : Experiment 1 30000 HCMEC D3
      6311  185     C  B03 128.20707       250 1 : Experiment 1 30000 HCMEC D3
      6312  190     C  B03 128.24743       250 1 : Experiment 1 30000 HCMEC D3
      6313  195     C  B03 128.28541       250 1 : Experiment 1 30000 HCMEC D3
      6314  200     C  B03        NA       250 1 : Experiment 1 30000 HCMEC D3
      6315    0     C  B03        NA     32000 1 : Experiment 1 30000 HCMEC D3
      6316    5     C  B03  72.00210     32000 1 : Experiment 1 30000 HCMEC D3
      6317   10     C  B03  64.52269     32000 1 : Experiment 1 30000 HCMEC D3
      6318   15     C  B03  55.75817     32000 1 : Experiment 1 30000 HCMEC D3
      6319   20     C  B03  48.33985     32000 1 : Experiment 1 30000 HCMEC D3
      6320   25     C  B03  41.89711     32000 1 : Experiment 1 30000 HCMEC D3
      6321   30     C  B03  38.28614     32000 1 : Experiment 1 30000 HCMEC D3
      6322   35     C  B03  35.75571     32000 1 : Experiment 1 30000 HCMEC D3
      6323   40     C  B03  31.96224     32000 1 : Experiment 1 30000 HCMEC D3
      6324   45     C  B03  28.81506     32000 1 : Experiment 1 30000 HCMEC D3
      6325   50     C  B03  26.79464     32000 1 : Experiment 1 30000 HCMEC D3
      6326   55     C  B03  24.03573     32000 1 : Experiment 1 30000 HCMEC D3
      6327   60     C  B03  22.79002     32000 1 : Experiment 1 30000 HCMEC D3
      6328   65     C  B03  22.07478     32000 1 : Experiment 1 30000 HCMEC D3
      6329   70     C  B03  21.82167     32000 1 : Experiment 1 30000 HCMEC D3
      6330   75     C  B03  21.75473     32000 1 : Experiment 1 30000 HCMEC D3
      6331   80     C  B03  21.86191     32000 1 : Experiment 1 30000 HCMEC D3
      6332   85     C  B03  22.48928     32000 1 : Experiment 1 30000 HCMEC D3
      6333   90     C  B03  22.94354     32000 1 : Experiment 1 30000 HCMEC D3
      6334   95     C  B03  24.02099     32000 1 : Experiment 1 30000 HCMEC D3
      6335  100     C  B03  24.85925     32000 1 : Experiment 1 30000 HCMEC D3
      6336  105     C  B03  25.88938     32000 1 : Experiment 1 30000 HCMEC D3
      6337  110     C  B03  27.20031     32000 1 : Experiment 1 30000 HCMEC D3
      6338  115     C  B03  28.06533     32000 1 : Experiment 1 30000 HCMEC D3
      6339  120     C  B03  29.08176     32000 1 : Experiment 1 30000 HCMEC D3
      6340  125     C  B03  30.12679     32000 1 : Experiment 1 30000 HCMEC D3
      6341  130     C  B03  31.40315     32000 1 : Experiment 1 30000 HCMEC D3
      6342  135     C  B03  32.20115     32000 1 : Experiment 1 30000 HCMEC D3
      6343  140     C  B03  33.12084     32000 1 : Experiment 1 30000 HCMEC D3
      6344  145     C  B03  34.32974     32000 1 : Experiment 1 30000 HCMEC D3
      6345  150     C  B03  35.66609     32000 1 : Experiment 1 30000 HCMEC D3
      6346  155     C  B03  36.73655     32000 1 : Experiment 1 30000 HCMEC D3
      6347  160     C  B03  37.96747     32000 1 : Experiment 1 30000 HCMEC D3
      6348  165     C  B03  39.06786     32000 1 : Experiment 1 30000 HCMEC D3
      6349  170     C  B03  40.60181     32000 1 : Experiment 1 30000 HCMEC D3
      6350  175     C  B03  41.89599     32000 1 : Experiment 1 30000 HCMEC D3
      6351  180     C  B03  43.25992     32000 1 : Experiment 1 30000 HCMEC D3
      6352  185     C  B03  44.36839     32000 1 : Experiment 1 30000 HCMEC D3
      6353  190     C  B03  45.27733     32000 1 : Experiment 1 30000 HCMEC D3
      6354  195     C  B03  46.51299     32000 1 : Experiment 1 30000 HCMEC D3
      6355  200     C  B03        NA     32000 1 : Experiment 1 30000 HCMEC D3
      6356    0     C  B03        NA      4000 1 : Experiment 1 30000 HCMEC D3
      6357    5     C  B03 107.01997      4000 1 : Experiment 1 30000 HCMEC D3
      6358   10     C  B03 102.49834      4000 1 : Experiment 1 30000 HCMEC D3
      6359   15     C  B03  96.55791      4000 1 : Experiment 1 30000 HCMEC D3
      6360   20     C  B03  92.46916      4000 1 : Experiment 1 30000 HCMEC D3
      6361   25     C  B03  89.23135      4000 1 : Experiment 1 30000 HCMEC D3
      6362   30     C  B03  87.43118      4000 1 : Experiment 1 30000 HCMEC D3
      6363   35     C  B03  87.03411      4000 1 : Experiment 1 30000 HCMEC D3
      6364   40     C  B03  85.92075      4000 1 : Experiment 1 30000 HCMEC D3
      6365   45     C  B03  86.71498      4000 1 : Experiment 1 30000 HCMEC D3
      6366   50     C  B03  87.75071      4000 1 : Experiment 1 30000 HCMEC D3
      6367   55     C  B03  89.62368      4000 1 : Experiment 1 30000 HCMEC D3
      6368   60     C  B03  91.64434      4000 1 : Experiment 1 30000 HCMEC D3
      6369   65     C  B03  93.46365      4000 1 : Experiment 1 30000 HCMEC D3
      6370   70     C  B03  95.01383      4000 1 : Experiment 1 30000 HCMEC D3
      6371   75     C  B03  96.45466      4000 1 : Experiment 1 30000 HCMEC D3
      6372   80     C  B03  96.58759      4000 1 : Experiment 1 30000 HCMEC D3
      6373   85     C  B03  97.49465      4000 1 : Experiment 1 30000 HCMEC D3
      6374   90     C  B03  98.39706      4000 1 : Experiment 1 30000 HCMEC D3
      6375   95     C  B03  99.76221      4000 1 : Experiment 1 30000 HCMEC D3
      6376  100     C  B03 100.61967      4000 1 : Experiment 1 30000 HCMEC D3
      6377  105     C  B03 101.59352      4000 1 : Experiment 1 30000 HCMEC D3
      6378  110     C  B03 102.55995      4000 1 : Experiment 1 30000 HCMEC D3
      6379  115     C  B03 103.39540      4000 1 : Experiment 1 30000 HCMEC D3
      6380  120     C  B03 104.23921      4000 1 : Experiment 1 30000 HCMEC D3
      6381  125     C  B03 105.21753      4000 1 : Experiment 1 30000 HCMEC D3
      6382  130     C  B03 105.99543      4000 1 : Experiment 1 30000 HCMEC D3
      6383  135     C  B03 106.49095      4000 1 : Experiment 1 30000 HCMEC D3
      6384  140     C  B03 107.06248      4000 1 : Experiment 1 30000 HCMEC D3
      6385  145     C  B03 107.58006      4000 1 : Experiment 1 30000 HCMEC D3
      6386  150     C  B03 108.49242      4000 1 : Experiment 1 30000 HCMEC D3
      6387  155     C  B03 108.85473      4000 1 : Experiment 1 30000 HCMEC D3
      6388  160     C  B03 109.49910      4000 1 : Experiment 1 30000 HCMEC D3
      6389  165     C  B03 110.09731      4000 1 : Experiment 1 30000 HCMEC D3
      6390  170     C  B03 110.75572      4000 1 : Experiment 1 30000 HCMEC D3
      6391  175     C  B03 111.35800      4000 1 : Experiment 1 30000 HCMEC D3
      6392  180     C  B03 111.77602      4000 1 : Experiment 1 30000 HCMEC D3
      6393  185     C  B03 112.43159      4000 1 : Experiment 1 30000 HCMEC D3
      6394  190     C  B03 112.59419      4000 1 : Experiment 1 30000 HCMEC D3
      6395  195     C  B03 113.24811      4000 1 : Experiment 1 30000 HCMEC D3
      6396  200     C  B03        NA      4000 1 : Experiment 1 30000 HCMEC D3
      6397    0     C  B03        NA       500 1 : Experiment 1 30000 HCMEC D3
      6398    5     C  B03 121.57443       500 1 : Experiment 1 30000 HCMEC D3
      6399   10     C  B03 121.33851       500 1 : Experiment 1 30000 HCMEC D3
      6400   15     C  B03 120.91041       500 1 : Experiment 1 30000 HCMEC D3
      6401   20     C  B03 120.69256       500 1 : Experiment 1 30000 HCMEC D3
      6402   25     C  B03 120.58669       500 1 : Experiment 1 30000 HCMEC D3
      6403   30     C  B03 120.62323       500 1 : Experiment 1 30000 HCMEC D3
      6404   35     C  B03 120.94812       500 1 : Experiment 1 30000 HCMEC D3
      6405   40     C  B03 121.07102       500 1 : Experiment 1 30000 HCMEC D3
      6406   45     C  B03 121.56462       500 1 : Experiment 1 30000 HCMEC D3
      6407   50     C  B03 121.98027       500 1 : Experiment 1 30000 HCMEC D3
      6408   55     C  B03 122.42851       500 1 : Experiment 1 30000 HCMEC D3
      6409   60     C  B03 122.80673       500 1 : Experiment 1 30000 HCMEC D3
      6410   65     C  B03 123.21931       500 1 : Experiment 1 30000 HCMEC D3
      6411   70     C  B03 123.59754       500 1 : Experiment 1 30000 HCMEC D3
      6412   75     C  B03 123.88487       500 1 : Experiment 1 30000 HCMEC D3
      6413   80     C  B03 124.08540       500 1 : Experiment 1 30000 HCMEC D3
      6414   85     C  B03 124.29571       500 1 : Experiment 1 30000 HCMEC D3
      6415   90     C  B03 124.54311       500 1 : Experiment 1 30000 HCMEC D3
      6416   95     C  B03 124.73757       500 1 : Experiment 1 30000 HCMEC D3
      6417  100     C  B03 124.92989       500 1 : Experiment 1 30000 HCMEC D3
      6418  105     C  B03 125.09798       500 1 : Experiment 1 30000 HCMEC D3
      6419  110     C  B03 125.25385       500 1 : Experiment 1 30000 HCMEC D3
      6420  115     C  B03 125.38856       500 1 : Experiment 1 30000 HCMEC D3
      6421  120     C  B03 125.54793       500 1 : Experiment 1 30000 HCMEC D3
      6422  125     C  B03 125.72812       500 1 : Experiment 1 30000 HCMEC D3
      6423  130     C  B03 125.85803       500 1 : Experiment 1 30000 HCMEC D3
      6424  135     C  B03 125.96360       500 1 : Experiment 1 30000 HCMEC D3
      6425  140     C  B03 126.06499       500 1 : Experiment 1 30000 HCMEC D3
      6426  145     C  B03 126.15795       500 1 : Experiment 1 30000 HCMEC D3
      6427  150     C  B03 126.28068       500 1 : Experiment 1 30000 HCMEC D3
      6428  155     C  B03 126.35403       500 1 : Experiment 1 30000 HCMEC D3
      6429  160     C  B03 126.47153       500 1 : Experiment 1 30000 HCMEC D3
      6430  165     C  B03 126.56648       500 1 : Experiment 1 30000 HCMEC D3
      6431  170     C  B03 126.64604       500 1 : Experiment 1 30000 HCMEC D3
      6432  175     C  B03 126.73038       500 1 : Experiment 1 30000 HCMEC D3
      6433  180     C  B03 126.80011       500 1 : Experiment 1 30000 HCMEC D3
      6434  185     C  B03 126.87322       500 1 : Experiment 1 30000 HCMEC D3
      6435  190     C  B03 126.90266       500 1 : Experiment 1 30000 HCMEC D3
      6436  195     C  B03 126.95908       500 1 : Experiment 1 30000 HCMEC D3
      6437  200     C  B03        NA       500 1 : Experiment 1 30000 HCMEC D3
      6438    0     C  B03        NA     64000 1 : Experiment 1 30000 HCMEC D3
      6439    5     C  B03  54.58037     64000 1 : Experiment 1 30000 HCMEC D3
      6440   10     C  B03  48.67117     64000 1 : Experiment 1 30000 HCMEC D3
      6441   15     C  B03  41.81233     64000 1 : Experiment 1 30000 HCMEC D3
      6442   20     C  B03  35.71130     64000 1 : Experiment 1 30000 HCMEC D3
      6443   25     C  B03  30.40152     64000 1 : Experiment 1 30000 HCMEC D3
      6444   30     C  B03  27.59718     64000 1 : Experiment 1 30000 HCMEC D3
      6445   35     C  B03  25.42759     64000 1 : Experiment 1 30000 HCMEC D3
      6446   40     C  B03  22.21933     64000 1 : Experiment 1 30000 HCMEC D3
      6447   45     C  B03  18.83674     64000 1 : Experiment 1 30000 HCMEC D3
      6448   50     C  B03  16.65108     64000 1 : Experiment 1 30000 HCMEC D3
      6449   55     C  B03  13.67354     64000 1 : Experiment 1 30000 HCMEC D3
      6450   60     C  B03  12.28366     64000 1 : Experiment 1 30000 HCMEC D3
      6451   65     C  B03  11.49318     64000 1 : Experiment 1 30000 HCMEC D3
      6452   70     C  B03  11.14268     64000 1 : Experiment 1 30000 HCMEC D3
      6453   75     C  B03  10.94968     64000 1 : Experiment 1 30000 HCMEC D3
      6454   80     C  B03  11.02124     64000 1 : Experiment 1 30000 HCMEC D3
      6455   85     C  B03  11.31666     64000 1 : Experiment 1 30000 HCMEC D3
      6456   90     C  B03  11.47233     64000 1 : Experiment 1 30000 HCMEC D3
      6457   95     C  B03  11.91758     64000 1 : Experiment 1 30000 HCMEC D3
      6458  100     C  B03  12.32402     64000 1 : Experiment 1 30000 HCMEC D3
      6459  105     C  B03  12.76478     64000 1 : Experiment 1 30000 HCMEC D3
      6460  110     C  B03  13.40857     64000 1 : Experiment 1 30000 HCMEC D3
      6461  115     C  B03  13.73996     64000 1 : Experiment 1 30000 HCMEC D3
      6462  120     C  B03  14.19094     64000 1 : Experiment 1 30000 HCMEC D3
      6463  125     C  B03  14.66177     64000 1 : Experiment 1 30000 HCMEC D3
      6464  130     C  B03  15.37414     64000 1 : Experiment 1 30000 HCMEC D3
      6465  135     C  B03  15.67624     64000 1 : Experiment 1 30000 HCMEC D3
      6466  140     C  B03  16.12556     64000 1 : Experiment 1 30000 HCMEC D3
      6467  145     C  B03  16.75915     64000 1 : Experiment 1 30000 HCMEC D3
      6468  150     C  B03  17.50743     64000 1 : Experiment 1 30000 HCMEC D3
      6469  155     C  B03  18.05438     64000 1 : Experiment 1 30000 HCMEC D3
      6470  160     C  B03  18.80531     64000 1 : Experiment 1 30000 HCMEC D3
      6471  165     C  B03  19.38540     64000 1 : Experiment 1 30000 HCMEC D3
      6472  170     C  B03  20.35577     64000 1 : Experiment 1 30000 HCMEC D3
      6473  175     C  B03  21.12125     64000 1 : Experiment 1 30000 HCMEC D3
      6474  180     C  B03  22.03012     64000 1 : Experiment 1 30000 HCMEC D3
      6475  185     C  B03  22.79232     64000 1 : Experiment 1 30000 HCMEC D3
      6476  190     C  B03  23.32789     64000 1 : Experiment 1 30000 HCMEC D3
      6477  195     C  B03  24.27568     64000 1 : Experiment 1 30000 HCMEC D3
      6478  200     C  B03        NA     64000 1 : Experiment 1 30000 HCMEC D3
      6479    0     C  B03        NA      8000 1 : Experiment 1 30000 HCMEC D3
      6480    5     C  B03  96.30395      8000 1 : Experiment 1 30000 HCMEC D3
      6481   10     C  B03  89.81992      8000 1 : Experiment 1 30000 HCMEC D3
      6482   15     C  B03  81.97285      8000 1 : Experiment 1 30000 HCMEC D3
      6483   20     C  B03  76.02534      8000 1 : Experiment 1 30000 HCMEC D3
      6484   25     C  B03  71.11943      8000 1 : Experiment 1 30000 HCMEC D3
      6485   30     C  B03  68.19158      8000 1 : Experiment 1 30000 HCMEC D3
      6486   35     C  B03  66.83784      8000 1 : Experiment 1 30000 HCMEC D3
      6487   40     C  B03  64.42017      8000 1 : Experiment 1 30000 HCMEC D3
      6488   45     C  B03  64.08956      8000 1 : Experiment 1 30000 HCMEC D3
      6489   50     C  B03  64.45348      8000 1 : Experiment 1 30000 HCMEC D3
      6490   55     C  B03  65.50609      8000 1 : Experiment 1 30000 HCMEC D3
      6491   60     C  B03  67.20463      8000 1 : Experiment 1 30000 HCMEC D3
      6492   65     C  B03  68.74473      8000 1 : Experiment 1 30000 HCMEC D3
      6493   70     C  B03  70.21633      8000 1 : Experiment 1 30000 HCMEC D3
      6494   75     C  B03  71.75280      8000 1 : Experiment 1 30000 HCMEC D3
      6495   80     C  B03  71.88199      8000 1 : Experiment 1 30000 HCMEC D3
      6496   85     C  B03  73.05697      8000 1 : Experiment 1 30000 HCMEC D3
      6497   90     C  B03  74.15029      8000 1 : Experiment 1 30000 HCMEC D3
      6498   95     C  B03  76.12526      8000 1 : Experiment 1 30000 HCMEC D3
      6499  100     C  B03  77.19700      8000 1 : Experiment 1 30000 HCMEC D3
      6500  105     C  B03  78.72738      8000 1 : Experiment 1 30000 HCMEC D3
      6501  110     C  B03  80.25614      8000 1 : Experiment 1 30000 HCMEC D3
      6502  115     C  B03  81.55477      8000 1 : Experiment 1 30000 HCMEC D3
      6503  120     C  B03  82.80426      8000 1 : Experiment 1 30000 HCMEC D3
      6504  125     C  B03  84.16819      8000 1 : Experiment 1 30000 HCMEC D3
      6505  130     C  B03  85.31540      8000 1 : Experiment 1 30000 HCMEC D3
      6506  135     C  B03  86.27672      8000 1 : Experiment 1 30000 HCMEC D3
      6507  140     C  B03  87.18116      8000 1 : Experiment 1 30000 HCMEC D3
      6508  145     C  B03  88.17882      8000 1 : Experiment 1 30000 HCMEC D3
      6509  150     C  B03  89.47201      8000 1 : Experiment 1 30000 HCMEC D3
      6510  155     C  B03  90.27904      8000 1 : Experiment 1 30000 HCMEC D3
      6511  160     C  B03  91.17113      8000 1 : Experiment 1 30000 HCMEC D3
      6512  165     C  B03  92.14950      8000 1 : Experiment 1 30000 HCMEC D3
      6513  170     C  B03  93.21334      8000 1 : Experiment 1 30000 HCMEC D3
      6514  175     C  B03  94.08515      8000 1 : Experiment 1 30000 HCMEC D3
      6515  180     C  B03  94.79398      8000 1 : Experiment 1 30000 HCMEC D3
      6516  185     C  B03  95.71911      8000 1 : Experiment 1 30000 HCMEC D3
      6517  190     C  B03  96.15320      8000 1 : Experiment 1 30000 HCMEC D3
      6518  195     C  B03  97.11230      8000 1 : Experiment 1 30000 HCMEC D3
      6519  200     C  B03        NA      8000 1 : Experiment 1 30000 HCMEC D3
      6520    0     C  C01        NA      1000 1 : Experiment 1 25000 HCMEC D3
      6521    5     C  C01 118.06220      1000 1 : Experiment 1 25000 HCMEC D3
      6522   10     C  C01 117.21453      1000 1 : Experiment 1 25000 HCMEC D3
      6523   15     C  C01 116.14031      1000 1 : Experiment 1 25000 HCMEC D3
      6524   20     C  C01 115.03389      1000 1 : Experiment 1 25000 HCMEC D3
      6525   25     C  C01 114.43425      1000 1 : Experiment 1 25000 HCMEC D3
      6526   30     C  C01 114.34331      1000 1 : Experiment 1 25000 HCMEC D3
      6527   35     C  C01 114.55417      1000 1 : Experiment 1 25000 HCMEC D3
      6528   40     C  C01 114.64716      1000 1 : Experiment 1 25000 HCMEC D3
      6529   45     C  C01 114.83780      1000 1 : Experiment 1 25000 HCMEC D3
      6530   50     C  C01 115.50575      1000 1 : Experiment 1 25000 HCMEC D3
      6531   55     C  C01 115.84906      1000 1 : Experiment 1 25000 HCMEC D3
      6532   60     C  C01 116.87566      1000 1 : Experiment 1 25000 HCMEC D3
      6533   65     C  C01 117.69030      1000 1 : Experiment 1 25000 HCMEC D3
      6534   70     C  C01 118.22587      1000 1 : Experiment 1 25000 HCMEC D3
      6535   75     C  C01 118.86897      1000 1 : Experiment 1 25000 HCMEC D3
      6536   80     C  C01 119.33174      1000 1 : Experiment 1 25000 HCMEC D3
      6537   85     C  C01 119.63097      1000 1 : Experiment 1 25000 HCMEC D3
      6538   90     C  C01 119.91816      1000 1 : Experiment 1 25000 HCMEC D3
      6539   95     C  C01 120.28962      1000 1 : Experiment 1 25000 HCMEC D3
      6540  100     C  C01 120.43593      1000 1 : Experiment 1 25000 HCMEC D3
      6541  105     C  C01 120.79898      1000 1 : Experiment 1 25000 HCMEC D3
      6542  110     C  C01 121.16021      1000 1 : Experiment 1 25000 HCMEC D3
      6543  115     C  C01 121.36381      1000 1 : Experiment 1 25000 HCMEC D3
      6544  120     C  C01 121.65580      1000 1 : Experiment 1 25000 HCMEC D3
      6545  125     C  C01 121.89118      1000 1 : Experiment 1 25000 HCMEC D3
      6546  130     C  C01 122.01693      1000 1 : Experiment 1 25000 HCMEC D3
      6547  135     C  C01 122.19449      1000 1 : Experiment 1 25000 HCMEC D3
      6548  140     C  C01 122.42078      1000 1 : Experiment 1 25000 HCMEC D3
      6549  145     C  C01 122.47850      1000 1 : Experiment 1 25000 HCMEC D3
      6550  150     C  C01 122.80876      1000 1 : Experiment 1 25000 HCMEC D3
      6551  155     C  C01 123.08677      1000 1 : Experiment 1 25000 HCMEC D3
      6552  160     C  C01 123.22577      1000 1 : Experiment 1 25000 HCMEC D3
      6553  165     C  C01 123.41682      1000 1 : Experiment 1 25000 HCMEC D3
      6554  170     C  C01 123.64003      1000 1 : Experiment 1 25000 HCMEC D3
      6555  175     C  C01 123.76037      1000 1 : Experiment 1 25000 HCMEC D3
      6556  180     C  C01 123.92949      1000 1 : Experiment 1 25000 HCMEC D3
      6557  185     C  C01 124.03052      1000 1 : Experiment 1 25000 HCMEC D3
      6558  190     C  C01 124.13313      1000 1 : Experiment 1 25000 HCMEC D3
      6559  195     C  C01 124.27204      1000 1 : Experiment 1 25000 HCMEC D3
      6560  200     C  C01        NA      1000 1 : Experiment 1 25000 HCMEC D3
      6561    0     C  C01        NA     16000 1 : Experiment 1 25000 HCMEC D3
      6562    5     C  C01  86.58603     16000 1 : Experiment 1 25000 HCMEC D3
      6563   10     C  C01  79.22759     16000 1 : Experiment 1 25000 HCMEC D3
      6564   15     C  C01  70.72677     16000 1 : Experiment 1 25000 HCMEC D3
      6565   20     C  C01  62.64714     16000 1 : Experiment 1 25000 HCMEC D3
      6566   25     C  C01  57.43470     16000 1 : Experiment 1 25000 HCMEC D3
      6567   30     C  C01  54.60213     16000 1 : Experiment 1 25000 HCMEC D3
      6568   35     C  C01  52.05983     16000 1 : Experiment 1 25000 HCMEC D3
      6569   40     C  C01  48.99040     16000 1 : Experiment 1 25000 HCMEC D3
      6570   45     C  C01  45.46218     16000 1 : Experiment 1 25000 HCMEC D3
      6571   50     C  C01  42.45753     16000 1 : Experiment 1 25000 HCMEC D3
      6572   55     C  C01  40.83809     16000 1 : Experiment 1 25000 HCMEC D3
      6573   60     C  C01  40.16794     16000 1 : Experiment 1 25000 HCMEC D3
      6574   65     C  C01  40.59216     16000 1 : Experiment 1 25000 HCMEC D3
      6575   70     C  C01  40.47279     16000 1 : Experiment 1 25000 HCMEC D3
      6576   75     C  C01  41.47303     16000 1 : Experiment 1 25000 HCMEC D3
      6577   80     C  C01  41.98132     16000 1 : Experiment 1 25000 HCMEC D3
      6578   85     C  C01  42.49571     16000 1 : Experiment 1 25000 HCMEC D3
      6579   90     C  C01  43.28447     16000 1 : Experiment 1 25000 HCMEC D3
      6580   95     C  C01  44.77895     16000 1 : Experiment 1 25000 HCMEC D3
      6581  100     C  C01  45.59024     16000 1 : Experiment 1 25000 HCMEC D3
      6582  105     C  C01  47.40768     16000 1 : Experiment 1 25000 HCMEC D3
      6583  110     C  C01  48.92326     16000 1 : Experiment 1 25000 HCMEC D3
      6584  115     C  C01  50.35145     16000 1 : Experiment 1 25000 HCMEC D3
      6585  120     C  C01  51.74703     16000 1 : Experiment 1 25000 HCMEC D3
      6586  125     C  C01  53.08311     16000 1 : Experiment 1 25000 HCMEC D3
      6587  130     C  C01  54.41403     16000 1 : Experiment 1 25000 HCMEC D3
      6588  135     C  C01  55.82552     16000 1 : Experiment 1 25000 HCMEC D3
      6589  140     C  C01  57.57708     16000 1 : Experiment 1 25000 HCMEC D3
      6590  145     C  C01  59.22925     16000 1 : Experiment 1 25000 HCMEC D3
      6591  150     C  C01  60.97270     16000 1 : Experiment 1 25000 HCMEC D3
      6592  155     C  C01  61.98677     16000 1 : Experiment 1 25000 HCMEC D3
      6593  160     C  C01  63.56441     16000 1 : Experiment 1 25000 HCMEC D3
      6594  165     C  C01  64.95165     16000 1 : Experiment 1 25000 HCMEC D3
      6595  170     C  C01  66.53713     16000 1 : Experiment 1 25000 HCMEC D3
      6596  175     C  C01  67.43934     16000 1 : Experiment 1 25000 HCMEC D3
      6597  180     C  C01  68.85754     16000 1 : Experiment 1 25000 HCMEC D3
      6598  185     C  C01  69.97618     16000 1 : Experiment 1 25000 HCMEC D3
      6599  190     C  C01  70.95264     16000 1 : Experiment 1 25000 HCMEC D3
      6600  195     C  C01  71.77503     16000 1 : Experiment 1 25000 HCMEC D3
      6601  200     C  C01        NA     16000 1 : Experiment 1 25000 HCMEC D3
      6602    0     C  C01        NA      2000 1 : Experiment 1 25000 HCMEC D3
      6603    5     C  C01 114.33173      2000 1 : Experiment 1 25000 HCMEC D3
      6604   10     C  C01 111.84962      2000 1 : Experiment 1 25000 HCMEC D3
      6605   15     C  C01 108.95556      2000 1 : Experiment 1 25000 HCMEC D3
      6606   20     C  C01 106.04338      2000 1 : Experiment 1 25000 HCMEC D3
      6607   25     C  C01 104.41520      2000 1 : Experiment 1 25000 HCMEC D3
      6608   30     C  C01 103.72947      2000 1 : Experiment 1 25000 HCMEC D3
      6609   35     C  C01 103.64239      2000 1 : Experiment 1 25000 HCMEC D3
      6610   40     C  C01 103.19280      2000 1 : Experiment 1 25000 HCMEC D3
      6611   45     C  C01 103.06190      2000 1 : Experiment 1 25000 HCMEC D3
      6612   50     C  C01 103.86553      2000 1 : Experiment 1 25000 HCMEC D3
      6613   55     C  C01 104.64613      2000 1 : Experiment 1 25000 HCMEC D3
      6614   60     C  C01 106.46681      2000 1 : Experiment 1 25000 HCMEC D3
      6615   65     C  C01 108.00820      2000 1 : Experiment 1 25000 HCMEC D3
      6616   70     C  C01 108.98982      2000 1 : Experiment 1 25000 HCMEC D3
      6617   75     C  C01 110.00117      2000 1 : Experiment 1 25000 HCMEC D3
      6618   80     C  C01 110.66368      2000 1 : Experiment 1 25000 HCMEC D3
      6619   85     C  C01 111.13363      2000 1 : Experiment 1 25000 HCMEC D3
      6620   90     C  C01 111.56322      2000 1 : Experiment 1 25000 HCMEC D3
      6621   95     C  C01 112.17688      2000 1 : Experiment 1 25000 HCMEC D3
      6622  100     C  C01 112.44399      2000 1 : Experiment 1 25000 HCMEC D3
      6623  105     C  C01 113.08788      2000 1 : Experiment 1 25000 HCMEC D3
      6624  110     C  C01 113.82684      2000 1 : Experiment 1 25000 HCMEC D3
      6625  115     C  C01 114.29761      2000 1 : Experiment 1 25000 HCMEC D3
      6626  120     C  C01 114.86720      2000 1 : Experiment 1 25000 HCMEC D3
      6627  125     C  C01 115.35969      2000 1 : Experiment 1 25000 HCMEC D3
      6628  130     C  C01 115.64795      2000 1 : Experiment 1 25000 HCMEC D3
      6629  135     C  C01 115.99295      2000 1 : Experiment 1 25000 HCMEC D3
      6630  140     C  C01 116.45162      2000 1 : Experiment 1 25000 HCMEC D3
      6631  145     C  C01 116.65160      2000 1 : Experiment 1 25000 HCMEC D3
      6632  150     C  C01 117.35381      2000 1 : Experiment 1 25000 HCMEC D3
      6633  155     C  C01 117.87475      2000 1 : Experiment 1 25000 HCMEC D3
      6634  160     C  C01 118.19054      2000 1 : Experiment 1 25000 HCMEC D3
      6635  165     C  C01 118.62535      2000 1 : Experiment 1 25000 HCMEC D3
      6636  170     C  C01 119.13761      2000 1 : Experiment 1 25000 HCMEC D3
      6637  175     C  C01 119.43329      2000 1 : Experiment 1 25000 HCMEC D3
      6638  180     C  C01 119.83702      2000 1 : Experiment 1 25000 HCMEC D3
      6639  185     C  C01 120.08533      2000 1 : Experiment 1 25000 HCMEC D3
      6640  190     C  C01 120.35394      2000 1 : Experiment 1 25000 HCMEC D3
      6641  195     C  C01 120.70069      2000 1 : Experiment 1 25000 HCMEC D3
      6642  200     C  C01        NA      2000 1 : Experiment 1 25000 HCMEC D3
      6643    0     C  C01        NA       250 1 : Experiment 1 25000 HCMEC D3
      6644    5     C  C01 122.86553       250 1 : Experiment 1 25000 HCMEC D3
      6645   10     C  C01 122.74178       250 1 : Experiment 1 25000 HCMEC D3
      6646   15     C  C01 122.61430       250 1 : Experiment 1 25000 HCMEC D3
      6647   20     C  C01 122.50499       250 1 : Experiment 1 25000 HCMEC D3
      6648   25     C  C01 122.53290       250 1 : Experiment 1 25000 HCMEC D3
      6649   30     C  C01 122.70150       250 1 : Experiment 1 25000 HCMEC D3
      6650   35     C  C01 122.92137       250 1 : Experiment 1 25000 HCMEC D3
      6651   40     C  C01 123.15415       250 1 : Experiment 1 25000 HCMEC D3
      6652   45     C  C01 123.34972       250 1 : Experiment 1 25000 HCMEC D3
      6653   50     C  C01 123.62718       250 1 : Experiment 1 25000 HCMEC D3
      6654   55     C  C01 123.85786       250 1 : Experiment 1 25000 HCMEC D3
      6655   60     C  C01 124.21824       250 1 : Experiment 1 25000 HCMEC D3
      6656   65     C  C01 124.52802       250 1 : Experiment 1 25000 HCMEC D3
      6657   70     C  C01 124.80185       250 1 : Experiment 1 25000 HCMEC D3
      6658   75     C  C01 125.05739       250 1 : Experiment 1 25000 HCMEC D3
      6659   80     C  C01 125.28223       250 1 : Experiment 1 25000 HCMEC D3
      6660   85     C  C01 125.48655       250 1 : Experiment 1 25000 HCMEC D3
      6661   90     C  C01 125.65363       250 1 : Experiment 1 25000 HCMEC D3
      6662   95     C  C01 125.81189       250 1 : Experiment 1 25000 HCMEC D3
      6663  100     C  C01 125.93731       250 1 : Experiment 1 25000 HCMEC D3
      6664  105     C  C01 126.06858       250 1 : Experiment 1 25000 HCMEC D3
      6665  110     C  C01 126.20681       250 1 : Experiment 1 25000 HCMEC D3
      6666  115     C  C01 126.31093       250 1 : Experiment 1 25000 HCMEC D3
      6667  120     C  C01 126.42960       250 1 : Experiment 1 25000 HCMEC D3
      6668  125     C  C01 126.53605       250 1 : Experiment 1 25000 HCMEC D3
      6669  130     C  C01 126.62659       250 1 : Experiment 1 25000 HCMEC D3
      6670  135     C  C01 126.69368       250 1 : Experiment 1 25000 HCMEC D3
      6671  140     C  C01 126.77799       250 1 : Experiment 1 25000 HCMEC D3
      6672  145     C  C01 126.84077       250 1 : Experiment 1 25000 HCMEC D3
      6673  150     C  C01 126.92170       250 1 : Experiment 1 25000 HCMEC D3
      6674  155     C  C01 127.00969       250 1 : Experiment 1 25000 HCMEC D3
      6675  160     C  C01 127.06229       250 1 : Experiment 1 25000 HCMEC D3
      6676  165     C  C01 127.12162       250 1 : Experiment 1 25000 HCMEC D3
      6677  170     C  C01 127.18790       250 1 : Experiment 1 25000 HCMEC D3
      6678  175     C  C01 127.23920       250 1 : Experiment 1 25000 HCMEC D3
      6679  180     C  C01 127.27742       250 1 : Experiment 1 25000 HCMEC D3
      6680  185     C  C01 127.33245       250 1 : Experiment 1 25000 HCMEC D3
      6681  190     C  C01 127.34735       250 1 : Experiment 1 25000 HCMEC D3
      6682  195     C  C01 127.38678       250 1 : Experiment 1 25000 HCMEC D3
      6683  200     C  C01        NA       250 1 : Experiment 1 25000 HCMEC D3
      6684    0     C  C01        NA     32000 1 : Experiment 1 25000 HCMEC D3
      6685    5     C  C01  73.39965     32000 1 : Experiment 1 25000 HCMEC D3
      6686   10     C  C01  66.34921     32000 1 : Experiment 1 25000 HCMEC D3
      6687   15     C  C01  58.14601     32000 1 : Experiment 1 25000 HCMEC D3
      6688   20     C  C01  50.35396     32000 1 : Experiment 1 25000 HCMEC D3
      6689   25     C  C01  45.02373     32000 1 : Experiment 1 25000 HCMEC D3
      6690   30     C  C01  42.11897     32000 1 : Experiment 1 25000 HCMEC D3
      6691   35     C  C01  39.52145     32000 1 : Experiment 1 25000 HCMEC D3
      6692   40     C  C01  36.47387     32000 1 : Experiment 1 25000 HCMEC D3
      6693   45     C  C01  32.30942     32000 1 : Experiment 1 25000 HCMEC D3
      6694   50     C  C01  28.45204     32000 1 : Experiment 1 25000 HCMEC D3
      6695   55     C  C01  25.29111     32000 1 : Experiment 1 25000 HCMEC D3
      6696   60     C  C01  22.88204     32000 1 : Experiment 1 25000 HCMEC D3
      6697   65     C  C01  21.72215     32000 1 : Experiment 1 25000 HCMEC D3
      6698   70     C  C01  20.79679     32000 1 : Experiment 1 25000 HCMEC D3
      6699   75     C  C01  21.13614     32000 1 : Experiment 1 25000 HCMEC D3
      6700   80     C  C01  21.24510     32000 1 : Experiment 1 25000 HCMEC D3
      6701   85     C  C01  21.51692     32000 1 : Experiment 1 25000 HCMEC D3
      6702   90     C  C01  21.98639     32000 1 : Experiment 1 25000 HCMEC D3
      6703   95     C  C01  22.87682     32000 1 : Experiment 1 25000 HCMEC D3
      6704  100     C  C01  23.28994     32000 1 : Experiment 1 25000 HCMEC D3
      6705  105     C  C01  24.45900     32000 1 : Experiment 1 25000 HCMEC D3
      6706  110     C  C01  25.34786     32000 1 : Experiment 1 25000 HCMEC D3
      6707  115     C  C01  26.28508     32000 1 : Experiment 1 25000 HCMEC D3
      6708  120     C  C01  27.32039     32000 1 : Experiment 1 25000 HCMEC D3
      6709  125     C  C01  28.31467     32000 1 : Experiment 1 25000 HCMEC D3
      6710  130     C  C01  29.35120     32000 1 : Experiment 1 25000 HCMEC D3
      6711  135     C  C01  30.47711     32000 1 : Experiment 1 25000 HCMEC D3
      6712  140     C  C01  31.83022     32000 1 : Experiment 1 25000 HCMEC D3
      6713  145     C  C01  33.18513     32000 1 : Experiment 1 25000 HCMEC D3
      6714  150     C  C01  34.70581     32000 1 : Experiment 1 25000 HCMEC D3
      6715  155     C  C01  35.49861     32000 1 : Experiment 1 25000 HCMEC D3
      6716  160     C  C01  37.00299     32000 1 : Experiment 1 25000 HCMEC D3
      6717  165     C  C01  38.12434     32000 1 : Experiment 1 25000 HCMEC D3
      6718  170     C  C01  39.70307     32000 1 : Experiment 1 25000 HCMEC D3
      6719  175     C  C01  40.54199     32000 1 : Experiment 1 25000 HCMEC D3
      6720  180     C  C01  41.98592     32000 1 : Experiment 1 25000 HCMEC D3
      6721  185     C  C01  43.20296     32000 1 : Experiment 1 25000 HCMEC D3
      6722  190     C  C01  44.21631     32000 1 : Experiment 1 25000 HCMEC D3
      6723  195     C  C01  45.26160     32000 1 : Experiment 1 25000 HCMEC D3
      6724  200     C  C01        NA     32000 1 : Experiment 1 25000 HCMEC D3
      6725    0     C  C01        NA      4000 1 : Experiment 1 25000 HCMEC D3
      6726    5     C  C01 107.69272      4000 1 : Experiment 1 25000 HCMEC D3
      6727   10     C  C01 103.15050      4000 1 : Experiment 1 25000 HCMEC D3
      6728   15     C  C01  97.85722      4000 1 : Experiment 1 25000 HCMEC D3
      6729   20     C  C01  92.72031      4000 1 : Experiment 1 25000 HCMEC D3
      6730   25     C  C01  89.80675      4000 1 : Experiment 1 25000 HCMEC D3
      6731   30     C  C01  88.31482      4000 1 : Experiment 1 25000 HCMEC D3
      6732   35     C  C01  87.46990      4000 1 : Experiment 1 25000 HCMEC D3
      6733   40     C  C01  86.07287      4000 1 : Experiment 1 25000 HCMEC D3
      6734   45     C  C01  85.19493      4000 1 : Experiment 1 25000 HCMEC D3
      6735   50     C  C01  85.27559      4000 1 : Experiment 1 25000 HCMEC D3
      6736   55     C  C01  86.46035      4000 1 : Experiment 1 25000 HCMEC D3
      6737   60     C  C01  88.77434      4000 1 : Experiment 1 25000 HCMEC D3
      6738   65     C  C01  91.08243      4000 1 : Experiment 1 25000 HCMEC D3
      6739   70     C  C01  92.46237      4000 1 : Experiment 1 25000 HCMEC D3
      6740   75     C  C01  93.99473      4000 1 : Experiment 1 25000 HCMEC D3
      6741   80     C  C01  94.86362      4000 1 : Experiment 1 25000 HCMEC D3
      6742   85     C  C01  95.59868      4000 1 : Experiment 1 25000 HCMEC D3
      6743   90     C  C01  96.27549      4000 1 : Experiment 1 25000 HCMEC D3
      6744   95     C  C01  97.39506      4000 1 : Experiment 1 25000 HCMEC D3
      6745  100     C  C01  97.99037      4000 1 : Experiment 1 25000 HCMEC D3
      6746  105     C  C01  99.16970      4000 1 : Experiment 1 25000 HCMEC D3
      6747  110     C  C01 100.37531      4000 1 : Experiment 1 25000 HCMEC D3
      6748  115     C  C01 101.26624      4000 1 : Experiment 1 25000 HCMEC D3
      6749  120     C  C01 102.10279      4000 1 : Experiment 1 25000 HCMEC D3
      6750  125     C  C01 102.90683      4000 1 : Experiment 1 25000 HCMEC D3
      6751  130     C  C01 103.44056      4000 1 : Experiment 1 25000 HCMEC D3
      6752  135     C  C01 104.04892      4000 1 : Experiment 1 25000 HCMEC D3
      6753  140     C  C01 104.83087      4000 1 : Experiment 1 25000 HCMEC D3
      6754  145     C  C01 105.37493      4000 1 : Experiment 1 25000 HCMEC D3
      6755  150     C  C01 106.44577      4000 1 : Experiment 1 25000 HCMEC D3
      6756  155     C  C01 107.17714      4000 1 : Experiment 1 25000 HCMEC D3
      6757  160     C  C01 107.78594      4000 1 : Experiment 1 25000 HCMEC D3
      6758  165     C  C01 108.55964      4000 1 : Experiment 1 25000 HCMEC D3
      6759  170     C  C01 109.37371      4000 1 : Experiment 1 25000 HCMEC D3
      6760  175     C  C01 109.89516      4000 1 : Experiment 1 25000 HCMEC D3
      6761  180     C  C01 110.63773      4000 1 : Experiment 1 25000 HCMEC D3
      6762  185     C  C01 111.05385      4000 1 : Experiment 1 25000 HCMEC D3
      6763  190     C  C01 111.53210      4000 1 : Experiment 1 25000 HCMEC D3
      6764  195     C  C01 112.09450      4000 1 : Experiment 1 25000 HCMEC D3
      6765  200     C  C01        NA      4000 1 : Experiment 1 25000 HCMEC D3
      6766    0     C  C01        NA       500 1 : Experiment 1 25000 HCMEC D3
      6767    5     C  C01 120.78287       500 1 : Experiment 1 25000 HCMEC D3
      6768   10     C  C01 120.55659       500 1 : Experiment 1 25000 HCMEC D3
      6769   15     C  C01 120.23225       500 1 : Experiment 1 25000 HCMEC D3
      6770   20     C  C01 119.91406       500 1 : Experiment 1 25000 HCMEC D3
      6771   25     C  C01 119.79546       500 1 : Experiment 1 25000 HCMEC D3
      6772   30     C  C01 119.91610       500 1 : Experiment 1 25000 HCMEC D3
      6773   35     C  C01 120.16264       500 1 : Experiment 1 25000 HCMEC D3
      6774   40     C  C01 120.38355       500 1 : Experiment 1 25000 HCMEC D3
      6775   45     C  C01 120.60149       500 1 : Experiment 1 25000 HCMEC D3
      6776   50     C  C01 121.02454       500 1 : Experiment 1 25000 HCMEC D3
      6777   55     C  C01 121.26546       500 1 : Experiment 1 25000 HCMEC D3
      6778   60     C  C01 121.84008       500 1 : Experiment 1 25000 HCMEC D3
      6779   65     C  C01 122.28055       500 1 : Experiment 1 25000 HCMEC D3
      6780   70     C  C01 122.62583       500 1 : Experiment 1 25000 HCMEC D3
      6781   75     C  C01 123.00290       500 1 : Experiment 1 25000 HCMEC D3
      6782   80     C  C01 123.30096       500 1 : Experiment 1 25000 HCMEC D3
      6783   85     C  C01 123.52140       500 1 : Experiment 1 25000 HCMEC D3
      6784   90     C  C01 123.72253       500 1 : Experiment 1 25000 HCMEC D3
      6785   95     C  C01 123.93791       500 1 : Experiment 1 25000 HCMEC D3
      6786  100     C  C01 124.07819       500 1 : Experiment 1 25000 HCMEC D3
      6787  105     C  C01 124.26892       500 1 : Experiment 1 25000 HCMEC D3
      6788  110     C  C01 124.46805       500 1 : Experiment 1 25000 HCMEC D3
      6789  115     C  C01 124.58224       500 1 : Experiment 1 25000 HCMEC D3
      6790  120     C  C01 124.74723       500 1 : Experiment 1 25000 HCMEC D3
      6791  125     C  C01 124.87988       500 1 : Experiment 1 25000 HCMEC D3
      6792  130     C  C01 124.97737       500 1 : Experiment 1 25000 HCMEC D3
      6793  135     C  C01 125.08528       500 1 : Experiment 1 25000 HCMEC D3
      6794  140     C  C01 125.19600       500 1 : Experiment 1 25000 HCMEC D3
      6795  145     C  C01 125.25833       500 1 : Experiment 1 25000 HCMEC D3
      6796  150     C  C01 125.40765       500 1 : Experiment 1 25000 HCMEC D3
      6797  155     C  C01 125.53736       500 1 : Experiment 1 25000 HCMEC D3
      6798  160     C  C01 125.61192       500 1 : Experiment 1 25000 HCMEC D3
      6799  165     C  C01 125.70158       500 1 : Experiment 1 25000 HCMEC D3
      6800  170     C  C01 125.80385       500 1 : Experiment 1 25000 HCMEC D3
      6801  175     C  C01 125.86798       500 1 : Experiment 1 25000 HCMEC D3
      6802  180     C  C01 125.94337       500 1 : Experiment 1 25000 HCMEC D3
      6803  185     C  C01 125.99624       500 1 : Experiment 1 25000 HCMEC D3
      6804  190     C  C01 126.03703       500 1 : Experiment 1 25000 HCMEC D3
      6805  195     C  C01 126.09847       500 1 : Experiment 1 25000 HCMEC D3
      6806  200     C  C01        NA       500 1 : Experiment 1 25000 HCMEC D3
      6807    0     C  C01        NA     64000 1 : Experiment 1 25000 HCMEC D3
      6808    5     C  C01  54.70134     64000 1 : Experiment 1 25000 HCMEC D3
      6809   10     C  C01  49.46644     64000 1 : Experiment 1 25000 HCMEC D3
      6810   15     C  C01  43.25482     64000 1 : Experiment 1 25000 HCMEC D3
      6811   20     C  C01  37.37697     64000 1 : Experiment 1 25000 HCMEC D3
      6812   25     C  C01  33.16469     64000 1 : Experiment 1 25000 HCMEC D3
      6813   30     C  C01  30.78922     64000 1 : Experiment 1 25000 HCMEC D3
      6814   35     C  C01  28.75843     64000 1 : Experiment 1 25000 HCMEC D3
      6815   40     C  C01  26.22846     64000 1 : Experiment 1 25000 HCMEC D3
      6816   45     C  C01  22.50425     64000 1 : Experiment 1 25000 HCMEC D3
      6817   50     C  C01  18.95996     64000 1 : Experiment 1 25000 HCMEC D3
      6818   55     C  C01  15.67067     64000 1 : Experiment 1 25000 HCMEC D3
      6819   60     C  C01  13.03936     64000 1 : Experiment 1 25000 HCMEC D3
      6820   65     C  C01  11.55486     64000 1 : Experiment 1 25000 HCMEC D3
      6821   70     C  C01  10.72494     64000 1 : Experiment 1 25000 HCMEC D3
      6822   75     C  C01  10.81915     64000 1 : Experiment 1 25000 HCMEC D3
      6823   80     C  C01  10.81681     64000 1 : Experiment 1 25000 HCMEC D3
      6824   85     C  C01  10.94850     64000 1 : Experiment 1 25000 HCMEC D3
      6825   90     C  C01  11.17962     64000 1 : Experiment 1 25000 HCMEC D3
      6826   95     C  C01  11.54944     64000 1 : Experiment 1 25000 HCMEC D3
      6827  100     C  C01  11.71555     64000 1 : Experiment 1 25000 HCMEC D3
      6828  105     C  C01  12.22379     64000 1 : Experiment 1 25000 HCMEC D3
      6829  110     C  C01  12.56472     64000 1 : Experiment 1 25000 HCMEC D3
      6830  115     C  C01  12.95618     64000 1 : Experiment 1 25000 HCMEC D3
      6831  120     C  C01  13.46340     64000 1 : Experiment 1 25000 HCMEC D3
      6832  125     C  C01  13.98091     64000 1 : Experiment 1 25000 HCMEC D3
      6833  130     C  C01  14.46953     64000 1 : Experiment 1 25000 HCMEC D3
      6834  135     C  C01  15.03051     64000 1 : Experiment 1 25000 HCMEC D3
      6835  140     C  C01  15.67922     64000 1 : Experiment 1 25000 HCMEC D3
      6836  145     C  C01  16.38253     64000 1 : Experiment 1 25000 HCMEC D3
      6837  150     C  C01  17.17575     64000 1 : Experiment 1 25000 HCMEC D3
      6838  155     C  C01  17.55419     64000 1 : Experiment 1 25000 HCMEC D3
      6839  160     C  C01  18.46561     64000 1 : Experiment 1 25000 HCMEC D3
      6840  165     C  C01  18.99394     64000 1 : Experiment 1 25000 HCMEC D3
      6841  170     C  C01  19.98630     64000 1 : Experiment 1 25000 HCMEC D3
      6842  175     C  C01  20.44745     64000 1 : Experiment 1 25000 HCMEC D3
      6843  180     C  C01  21.44724     64000 1 : Experiment 1 25000 HCMEC D3
      6844  185     C  C01  22.24970     64000 1 : Experiment 1 25000 HCMEC D3
      6845  190     C  C01  22.87220     64000 1 : Experiment 1 25000 HCMEC D3
      6846  195     C  C01  23.88511     64000 1 : Experiment 1 25000 HCMEC D3
      6847  200     C  C01        NA     64000 1 : Experiment 1 25000 HCMEC D3
      6848    0     C  C01        NA      8000 1 : Experiment 1 25000 HCMEC D3
      6849    5     C  C01  97.65125      8000 1 : Experiment 1 25000 HCMEC D3
      6850   10     C  C01  91.21680      8000 1 : Experiment 1 25000 HCMEC D3
      6851   15     C  C01  83.86100      8000 1 : Experiment 1 25000 HCMEC D3
      6852   20     C  C01  76.88011      8000 1 : Experiment 1 25000 HCMEC D3
      6853   25     C  C01  72.67757      8000 1 : Experiment 1 25000 HCMEC D3
      6854   30     C  C01  70.40954      8000 1 : Experiment 1 25000 HCMEC D3
      6855   35     C  C01  68.57570      8000 1 : Experiment 1 25000 HCMEC D3
      6856   40     C  C01  66.13199      8000 1 : Experiment 1 25000 HCMEC D3
      6857   45     C  C01  63.87771      8000 1 : Experiment 1 25000 HCMEC D3
      6858   50     C  C01  62.43061      8000 1 : Experiment 1 25000 HCMEC D3
      6859   55     C  C01  62.85524      8000 1 : Experiment 1 25000 HCMEC D3
      6860   60     C  C01  64.38270      8000 1 : Experiment 1 25000 HCMEC D3
      6861   65     C  C01  66.50341      8000 1 : Experiment 1 25000 HCMEC D3
      6862   70     C  C01  67.58649      8000 1 : Experiment 1 25000 HCMEC D3
      6863   75     C  C01  69.19566      8000 1 : Experiment 1 25000 HCMEC D3
      6864   80     C  C01  70.08779      8000 1 : Experiment 1 25000 HCMEC D3
      6865   85     C  C01  70.85470      8000 1 : Experiment 1 25000 HCMEC D3
      6866   90     C  C01  71.71559      8000 1 : Experiment 1 25000 HCMEC D3
      6867   95     C  C01  73.28572      8000 1 : Experiment 1 25000 HCMEC D3
      6868  100     C  C01  74.19059      8000 1 : Experiment 1 25000 HCMEC D3
      6869  105     C  C01  75.91866      8000 1 : Experiment 1 25000 HCMEC D3
      6870  110     C  C01  77.54315      8000 1 : Experiment 1 25000 HCMEC D3
      6871  115     C  C01  78.88289      8000 1 : Experiment 1 25000 HCMEC D3
      6872  120     C  C01  80.05956      8000 1 : Experiment 1 25000 HCMEC D3
      6873  125     C  C01  81.24359      8000 1 : Experiment 1 25000 HCMEC D3
      6874  130     C  C01  82.24018      8000 1 : Experiment 1 25000 HCMEC D3
      6875  135     C  C01  83.28776      8000 1 : Experiment 1 25000 HCMEC D3
      6876  140     C  C01  84.64003      8000 1 : Experiment 1 25000 HCMEC D3
      6877  145     C  C01  85.81907      8000 1 : Experiment 1 25000 HCMEC D3
      6878  150     C  C01  87.26042      8000 1 : Experiment 1 25000 HCMEC D3
      6879  155     C  C01  88.19381      8000 1 : Experiment 1 25000 HCMEC D3
      6880  160     C  C01  89.31076      8000 1 : Experiment 1 25000 HCMEC D3
      6881  165     C  C01  90.47065      8000 1 : Experiment 1 25000 HCMEC D3
      6882  170     C  C01  91.69476      8000 1 : Experiment 1 25000 HCMEC D3
      6883  175     C  C01  92.39902      8000 1 : Experiment 1 25000 HCMEC D3
      6884  180     C  C01  93.48357      8000 1 : Experiment 1 25000 HCMEC D3
      6885  185     C  C01  94.15245      8000 1 : Experiment 1 25000 HCMEC D3
      6886  190     C  C01  94.84738      8000 1 : Experiment 1 25000 HCMEC D3
      6887  195     C  C01  95.50418      8000 1 : Experiment 1 25000 HCMEC D3
      6888  200     C  C01        NA      8000 1 : Experiment 1 25000 HCMEC D3
      6889    0     C  C02        NA      1000 1 : Experiment 1 25000 HCMEC D3
      6890    5     C  C02 117.70803      1000 1 : Experiment 1 25000 HCMEC D3
      6891   10     C  C02 116.90740      1000 1 : Experiment 1 25000 HCMEC D3
      6892   15     C  C02 115.70348      1000 1 : Experiment 1 25000 HCMEC D3
      6893   20     C  C02 115.02346      1000 1 : Experiment 1 25000 HCMEC D3
      6894   25     C  C02 114.27553      1000 1 : Experiment 1 25000 HCMEC D3
      6895   30     C  C02 114.13410      1000 1 : Experiment 1 25000 HCMEC D3
      6896   35     C  C02 114.42870      1000 1 : Experiment 1 25000 HCMEC D3
      6897   40     C  C02 114.71191      1000 1 : Experiment 1 25000 HCMEC D3
      6898   45     C  C02 115.13496      1000 1 : Experiment 1 25000 HCMEC D3
      6899   50     C  C02 115.54587      1000 1 : Experiment 1 25000 HCMEC D3
      6900   55     C  C02 116.39732      1000 1 : Experiment 1 25000 HCMEC D3
      6901   60     C  C02 116.93491      1000 1 : Experiment 1 25000 HCMEC D3
      6902   65     C  C02 117.73111      1000 1 : Experiment 1 25000 HCMEC D3
      6903   70     C  C02 118.15695      1000 1 : Experiment 1 25000 HCMEC D3
      6904   75     C  C02 118.68590      1000 1 : Experiment 1 25000 HCMEC D3
      6905   80     C  C02 119.30338      1000 1 : Experiment 1 25000 HCMEC D3
      6906   85     C  C02 119.61410      1000 1 : Experiment 1 25000 HCMEC D3
      6907   90     C  C02 119.80867      1000 1 : Experiment 1 25000 HCMEC D3
      6908   95     C  C02 120.06611      1000 1 : Experiment 1 25000 HCMEC D3
      6909  100     C  C02 120.33420      1000 1 : Experiment 1 25000 HCMEC D3
      6910  105     C  C02 120.48908      1000 1 : Experiment 1 25000 HCMEC D3
      6911  110     C  C02 120.79891      1000 1 : Experiment 1 25000 HCMEC D3
      6912  115     C  C02 121.11441      1000 1 : Experiment 1 25000 HCMEC D3
      6913  120     C  C02 121.33385      1000 1 : Experiment 1 25000 HCMEC D3
      6914  125     C  C02 121.48797      1000 1 : Experiment 1 25000 HCMEC D3
      6915  130     C  C02 121.65797      1000 1 : Experiment 1 25000 HCMEC D3
      6916  135     C  C02 121.99231      1000 1 : Experiment 1 25000 HCMEC D3
      6917  140     C  C02 122.13837      1000 1 : Experiment 1 25000 HCMEC D3
      6918  145     C  C02 122.32567      1000 1 : Experiment 1 25000 HCMEC D3
      6919  150     C  C02 122.50768      1000 1 : Experiment 1 25000 HCMEC D3
      6920  155     C  C02 122.59149      1000 1 : Experiment 1 25000 HCMEC D3
      6921  160     C  C02 122.70636      1000 1 : Experiment 1 25000 HCMEC D3
      6922  165     C  C02 122.89771      1000 1 : Experiment 1 25000 HCMEC D3
      6923  170     C  C02 122.98584      1000 1 : Experiment 1 25000 HCMEC D3
      6924  175     C  C02 123.17184      1000 1 : Experiment 1 25000 HCMEC D3
      6925  180     C  C02 123.44513      1000 1 : Experiment 1 25000 HCMEC D3
      6926  185     C  C02 123.60477      1000 1 : Experiment 1 25000 HCMEC D3
      6927  190     C  C02 123.61440      1000 1 : Experiment 1 25000 HCMEC D3
      6928  195     C  C02 123.69599      1000 1 : Experiment 1 25000 HCMEC D3
      6929  200     C  C02        NA      1000 1 : Experiment 1 25000 HCMEC D3
      6930    0     C  C02        NA     16000 1 : Experiment 1 25000 HCMEC D3
      6931    5     C  C02  84.40516     16000 1 : Experiment 1 25000 HCMEC D3
      6932   10     C  C02  76.97338     16000 1 : Experiment 1 25000 HCMEC D3
      6933   15     C  C02  68.29495     16000 1 : Experiment 1 25000 HCMEC D3
      6934   20     C  C02  61.60130     16000 1 : Experiment 1 25000 HCMEC D3
      6935   25     C  C02  56.26264     16000 1 : Experiment 1 25000 HCMEC D3
      6936   30     C  C02  52.10084     16000 1 : Experiment 1 25000 HCMEC D3
      6937   35     C  C02  50.11411     16000 1 : Experiment 1 25000 HCMEC D3
      6938   40     C  C02  47.81387     16000 1 : Experiment 1 25000 HCMEC D3
      6939   45     C  C02  44.62580     16000 1 : Experiment 1 25000 HCMEC D3
      6940   50     C  C02  42.49268     16000 1 : Experiment 1 25000 HCMEC D3
      6941   55     C  C02  41.63425     16000 1 : Experiment 1 25000 HCMEC D3
      6942   60     C  C02  40.83627     16000 1 : Experiment 1 25000 HCMEC D3
      6943   65     C  C02  40.91032     16000 1 : Experiment 1 25000 HCMEC D3
      6944   70     C  C02  41.38565     16000 1 : Experiment 1 25000 HCMEC D3
      6945   75     C  C02  41.49712     16000 1 : Experiment 1 25000 HCMEC D3
      6946   80     C  C02  42.49018     16000 1 : Experiment 1 25000 HCMEC D3
      6947   85     C  C02  43.37279     16000 1 : Experiment 1 25000 HCMEC D3
      6948   90     C  C02  43.55283     16000 1 : Experiment 1 25000 HCMEC D3
      6949   95     C  C02  44.83388     16000 1 : Experiment 1 25000 HCMEC D3
      6950  100     C  C02  46.05438     16000 1 : Experiment 1 25000 HCMEC D3
      6951  105     C  C02  46.79323     16000 1 : Experiment 1 25000 HCMEC D3
      6952  110     C  C02  48.28164     16000 1 : Experiment 1 25000 HCMEC D3
      6953  115     C  C02  49.80669     16000 1 : Experiment 1 25000 HCMEC D3
      6954  120     C  C02  51.01273     16000 1 : Experiment 1 25000 HCMEC D3
      6955  125     C  C02  52.79209     16000 1 : Experiment 1 25000 HCMEC D3
      6956  130     C  C02  54.26765     16000 1 : Experiment 1 25000 HCMEC D3
      6957  135     C  C02  55.94536     16000 1 : Experiment 1 25000 HCMEC D3
      6958  140     C  C02  57.37509     16000 1 : Experiment 1 25000 HCMEC D3
      6959  145     C  C02  59.26354     16000 1 : Experiment 1 25000 HCMEC D3
      6960  150     C  C02  60.87606     16000 1 : Experiment 1 25000 HCMEC D3
      6961  155     C  C02  62.25698     16000 1 : Experiment 1 25000 HCMEC D3
      6962  160     C  C02  63.27177     16000 1 : Experiment 1 25000 HCMEC D3
      6963  165     C  C02  64.87112     16000 1 : Experiment 1 25000 HCMEC D3
      6964  170     C  C02  66.17017     16000 1 : Experiment 1 25000 HCMEC D3
      6965  175     C  C02  67.43816     16000 1 : Experiment 1 25000 HCMEC D3
      6966  180     C  C02  69.01273     16000 1 : Experiment 1 25000 HCMEC D3
      6967  185     C  C02  70.23961     16000 1 : Experiment 1 25000 HCMEC D3
      6968  190     C  C02  71.32053     16000 1 : Experiment 1 25000 HCMEC D3
      6969  195     C  C02  72.21162     16000 1 : Experiment 1 25000 HCMEC D3
      6970  200     C  C02        NA     16000 1 : Experiment 1 25000 HCMEC D3
      6971    0     C  C02        NA      2000 1 : Experiment 1 25000 HCMEC D3
      6972    5     C  C02 113.54420      2000 1 : Experiment 1 25000 HCMEC D3
      6973   10     C  C02 111.16091      2000 1 : Experiment 1 25000 HCMEC D3
      6974   15     C  C02 107.97012      2000 1 : Experiment 1 25000 HCMEC D3
      6975   20     C  C02 106.08511      2000 1 : Experiment 1 25000 HCMEC D3
      6976   25     C  C02 104.18632      2000 1 : Experiment 1 25000 HCMEC D3
      6977   30     C  C02 103.40732      2000 1 : Experiment 1 25000 HCMEC D3
      6978   35     C  C02 103.39585      2000 1 : Experiment 1 25000 HCMEC D3
      6979   40     C  C02 103.41529      2000 1 : Experiment 1 25000 HCMEC D3
      6980   45     C  C02 103.58275      2000 1 : Experiment 1 25000 HCMEC D3
      6981   50     C  C02 104.10850      2000 1 : Experiment 1 25000 HCMEC D3
      6982   55     C  C02 105.84485      2000 1 : Experiment 1 25000 HCMEC D3
      6983   60     C  C02 106.77474      2000 1 : Experiment 1 25000 HCMEC D3
      6984   65     C  C02 108.18281      2000 1 : Experiment 1 25000 HCMEC D3
      6985   70     C  C02 108.97474      2000 1 : Experiment 1 25000 HCMEC D3
      6986   75     C  C02 109.88172      2000 1 : Experiment 1 25000 HCMEC D3
      6987   80     C  C02 110.87894      2000 1 : Experiment 1 25000 HCMEC D3
      6988   85     C  C02 111.41009      2000 1 : Experiment 1 25000 HCMEC D3
      6989   90     C  C02 111.70231      2000 1 : Experiment 1 25000 HCMEC D3
      6990   95     C  C02 112.18416      2000 1 : Experiment 1 25000 HCMEC D3
      6991  100     C  C02 112.57531      2000 1 : Experiment 1 25000 HCMEC D3
      6992  105     C  C02 112.78851      2000 1 : Experiment 1 25000 HCMEC D3
      6993  110     C  C02 113.42272      2000 1 : Experiment 1 25000 HCMEC D3
      6994  115     C  C02 114.08795      2000 1 : Experiment 1 25000 HCMEC D3
      6995  120     C  C02 114.55247      2000 1 : Experiment 1 25000 HCMEC D3
      6996  125     C  C02 114.87628      2000 1 : Experiment 1 25000 HCMEC D3
      6997  130     C  C02 115.29311      2000 1 : Experiment 1 25000 HCMEC D3
      6998  135     C  C02 115.98623      2000 1 : Experiment 1 25000 HCMEC D3
      6999  140     C  C02 116.30611      2000 1 : Experiment 1 25000 HCMEC D3
      7000  145     C  C02 116.75072      2000 1 : Experiment 1 25000 HCMEC D3
      7001  150     C  C02 117.19376      2000 1 : Experiment 1 25000 HCMEC D3
      7002  155     C  C02 117.45392      2000 1 : Experiment 1 25000 HCMEC D3
      7003  160     C  C02 117.70459      2000 1 : Experiment 1 25000 HCMEC D3
      7004  165     C  C02 118.15620      2000 1 : Experiment 1 25000 HCMEC D3
      7005  170     C  C02 118.41736      2000 1 : Experiment 1 25000 HCMEC D3
      7006  175     C  C02 118.79396      2000 1 : Experiment 1 25000 HCMEC D3
      7007  180     C  C02 119.39163      2000 1 : Experiment 1 25000 HCMEC D3
      7008  185     C  C02 119.75910      2000 1 : Experiment 1 25000 HCMEC D3
      7009  190     C  C02 119.87475      2000 1 : Experiment 1 25000 HCMEC D3
      7010  195     C  C02 120.12335      2000 1 : Experiment 1 25000 HCMEC D3
      7011  200     C  C02        NA      2000 1 : Experiment 1 25000 HCMEC D3
      7012    0     C  C02        NA       250 1 : Experiment 1 25000 HCMEC D3
      7013    5     C  C02 122.82796       250 1 : Experiment 1 25000 HCMEC D3
      7014   10     C  C02 122.67108       250 1 : Experiment 1 25000 HCMEC D3
      7015   15     C  C02 122.47325       250 1 : Experiment 1 25000 HCMEC D3
      7016   20     C  C02 122.40576       250 1 : Experiment 1 25000 HCMEC D3
      7017   25     C  C02 122.40945       250 1 : Experiment 1 25000 HCMEC D3
      7018   30     C  C02 122.49704       250 1 : Experiment 1 25000 HCMEC D3
      7019   35     C  C02 122.74662       250 1 : Experiment 1 25000 HCMEC D3
      7020   40     C  C02 122.99281       250 1 : Experiment 1 25000 HCMEC D3
      7021   45     C  C02 123.27349       250 1 : Experiment 1 25000 HCMEC D3
      7022   50     C  C02 123.50732       250 1 : Experiment 1 25000 HCMEC D3
      7023   55     C  C02 123.76414       250 1 : Experiment 1 25000 HCMEC D3
      7024   60     C  C02 124.04094       250 1 : Experiment 1 25000 HCMEC D3
      7025   65     C  C02 124.32992       250 1 : Experiment 1 25000 HCMEC D3
      7026   70     C  C02 124.55751       250 1 : Experiment 1 25000 HCMEC D3
      7027   75     C  C02 124.77990       250 1 : Experiment 1 25000 HCMEC D3
      7028   80     C  C02 125.01068       250 1 : Experiment 1 25000 HCMEC D3
      7029   85     C  C02 125.17139       250 1 : Experiment 1 25000 HCMEC D3
      7030   90     C  C02 125.32814       250 1 : Experiment 1 25000 HCMEC D3
      7031   95     C  C02 125.47402       250 1 : Experiment 1 25000 HCMEC D3
      7032  100     C  C02 125.59650       250 1 : Experiment 1 25000 HCMEC D3
      7033  105     C  C02 125.72798       250 1 : Experiment 1 25000 HCMEC D3
      7034  110     C  C02 125.84964       250 1 : Experiment 1 25000 HCMEC D3
      7035  115     C  C02 125.94348       250 1 : Experiment 1 25000 HCMEC D3
      7036  120     C  C02 126.06401       250 1 : Experiment 1 25000 HCMEC D3
      7037  125     C  C02 126.15272       250 1 : Experiment 1 25000 HCMEC D3
      7038  130     C  C02 126.20953       250 1 : Experiment 1 25000 HCMEC D3
      7039  135     C  C02 126.30973       250 1 : Experiment 1 25000 HCMEC D3
      7040  140     C  C02 126.38115       250 1 : Experiment 1 25000 HCMEC D3
      7041  145     C  C02 126.45458       250 1 : Experiment 1 25000 HCMEC D3
      7042  150     C  C02 126.52712       250 1 : Experiment 1 25000 HCMEC D3
      7043  155     C  C02 126.57633       250 1 : Experiment 1 25000 HCMEC D3
      7044  160     C  C02 126.63437       250 1 : Experiment 1 25000 HCMEC D3
      7045  165     C  C02 126.67690       250 1 : Experiment 1 25000 HCMEC D3
      7046  170     C  C02 126.72864       250 1 : Experiment 1 25000 HCMEC D3
      7047  175     C  C02 126.78763       250 1 : Experiment 1 25000 HCMEC D3
      7048  180     C  C02 126.84020       250 1 : Experiment 1 25000 HCMEC D3
      7049  185     C  C02 126.87991       250 1 : Experiment 1 25000 HCMEC D3
      7050  190     C  C02 126.89755       250 1 : Experiment 1 25000 HCMEC D3
      7051  195     C  C02 126.92316       250 1 : Experiment 1 25000 HCMEC D3
      7052  200     C  C02        NA       250 1 : Experiment 1 25000 HCMEC D3
      7053    0     C  C02        NA     32000 1 : Experiment 1 25000 HCMEC D3
      7054    5     C  C02  71.73581     32000 1 : Experiment 1 25000 HCMEC D3
      7055   10     C  C02  64.13532     32000 1 : Experiment 1 25000 HCMEC D3
      7056   15     C  C02  55.67558     32000 1 : Experiment 1 25000 HCMEC D3
      7057   20     C  C02  48.94287     32000 1 : Experiment 1 25000 HCMEC D3
      7058   25     C  C02  43.77491     32000 1 : Experiment 1 25000 HCMEC D3
      7059   30     C  C02  39.37446     32000 1 : Experiment 1 25000 HCMEC D3
      7060   35     C  C02  37.06588     32000 1 : Experiment 1 25000 HCMEC D3
      7061   40     C  C02  34.67453     32000 1 : Experiment 1 25000 HCMEC D3
      7062   45     C  C02  30.75043     32000 1 : Experiment 1 25000 HCMEC D3
      7063   50     C  C02  27.85945     32000 1 : Experiment 1 25000 HCMEC D3
      7064   55     C  C02  24.81098     32000 1 : Experiment 1 25000 HCMEC D3
      7065   60     C  C02  22.98208     32000 1 : Experiment 1 25000 HCMEC D3
      7066   65     C  C02  21.80206     32000 1 : Experiment 1 25000 HCMEC D3
      7067   70     C  C02  21.50548     32000 1 : Experiment 1 25000 HCMEC D3
      7068   75     C  C02  21.25554     32000 1 : Experiment 1 25000 HCMEC D3
      7069   80     C  C02  21.66904     32000 1 : Experiment 1 25000 HCMEC D3
      7070   85     C  C02  22.05436     32000 1 : Experiment 1 25000 HCMEC D3
      7071   90     C  C02  22.08855     32000 1 : Experiment 1 25000 HCMEC D3
      7072   95     C  C02  22.82546     32000 1 : Experiment 1 25000 HCMEC D3
      7073  100     C  C02  23.65810     32000 1 : Experiment 1 25000 HCMEC D3
      7074  105     C  C02  24.21205     32000 1 : Experiment 1 25000 HCMEC D3
      7075  110     C  C02  25.05369     32000 1 : Experiment 1 25000 HCMEC D3
      7076  115     C  C02  26.00018     32000 1 : Experiment 1 25000 HCMEC D3
      7077  120     C  C02  26.88746     32000 1 : Experiment 1 25000 HCMEC D3
      7078  125     C  C02  28.23141     32000 1 : Experiment 1 25000 HCMEC D3
      7079  130     C  C02  29.36704     32000 1 : Experiment 1 25000 HCMEC D3
      7080  135     C  C02  30.54716     32000 1 : Experiment 1 25000 HCMEC D3
      7081  140     C  C02  31.70302     32000 1 : Experiment 1 25000 HCMEC D3
      7082  145     C  C02  33.09063     32000 1 : Experiment 1 25000 HCMEC D3
      7083  150     C  C02  34.40526     32000 1 : Experiment 1 25000 HCMEC D3
      7084  155     C  C02  35.72279     32000 1 : Experiment 1 25000 HCMEC D3
      7085  160     C  C02  36.84834     32000 1 : Experiment 1 25000 HCMEC D3
      7086  165     C  C02  38.07694     32000 1 : Experiment 1 25000 HCMEC D3
      7087  170     C  C02  39.26402     32000 1 : Experiment 1 25000 HCMEC D3
      7088  175     C  C02  40.48704     32000 1 : Experiment 1 25000 HCMEC D3
      7089  180     C  C02  42.10669     32000 1 : Experiment 1 25000 HCMEC D3
      7090  185     C  C02  43.13289     32000 1 : Experiment 1 25000 HCMEC D3
      7091  190     C  C02  44.35412     32000 1 : Experiment 1 25000 HCMEC D3
      7092  195     C  C02  45.39834     32000 1 : Experiment 1 25000 HCMEC D3
      7093  200     C  C02        NA     32000 1 : Experiment 1 25000 HCMEC D3
      7094    0     C  C02        NA      4000 1 : Experiment 1 25000 HCMEC D3
      7095    5     C  C02 106.34090      4000 1 : Experiment 1 25000 HCMEC D3
      7096   10     C  C02 101.93033      4000 1 : Experiment 1 25000 HCMEC D3
      7097   15     C  C02  96.22381      4000 1 : Experiment 1 25000 HCMEC D3
      7098   20     C  C02  92.57134      4000 1 : Experiment 1 25000 HCMEC D3
      7099   25     C  C02  89.28726      4000 1 : Experiment 1 25000 HCMEC D3
      7100   30     C  C02  87.42862      4000 1 : Experiment 1 25000 HCMEC D3
      7101   35     C  C02  86.90308      4000 1 : Experiment 1 25000 HCMEC D3
      7102   40     C  C02  86.23552      4000 1 : Experiment 1 25000 HCMEC D3
      7103   45     C  C02  85.70753      4000 1 : Experiment 1 25000 HCMEC D3
      7104   50     C  C02  85.89297      4000 1 : Experiment 1 25000 HCMEC D3
      7105   55     C  C02  88.28365      4000 1 : Experiment 1 25000 HCMEC D3
      7106   60     C  C02  89.47069      4000 1 : Experiment 1 25000 HCMEC D3
      7107   65     C  C02  91.42114      4000 1 : Experiment 1 25000 HCMEC D3
      7108   70     C  C02  92.66024      4000 1 : Experiment 1 25000 HCMEC D3
      7109   75     C  C02  93.84270      4000 1 : Experiment 1 25000 HCMEC D3
      7110   80     C  C02  95.28567      4000 1 : Experiment 1 25000 HCMEC D3
      7111   85     C  C02  96.19609      4000 1 : Experiment 1 25000 HCMEC D3
      7112   90     C  C02  96.62383      4000 1 : Experiment 1 25000 HCMEC D3
      7113   95     C  C02  97.58221      4000 1 : Experiment 1 25000 HCMEC D3
      7114  100     C  C02  98.31236      4000 1 : Experiment 1 25000 HCMEC D3
      7115  105     C  C02  98.71832      4000 1 : Experiment 1 25000 HCMEC D3
      7116  110     C  C02  99.84850      4000 1 : Experiment 1 25000 HCMEC D3
      7117  115     C  C02 100.94565      4000 1 : Experiment 1 25000 HCMEC D3
      7118  120     C  C02 101.68781      4000 1 : Experiment 1 25000 HCMEC D3
      7119  125     C  C02 102.33869      4000 1 : Experiment 1 25000 HCMEC D3
      7120  130     C  C02 103.11485      4000 1 : Experiment 1 25000 HCMEC D3
      7121  135     C  C02 104.20900      4000 1 : Experiment 1 25000 HCMEC D3
      7122  140     C  C02 104.81487      4000 1 : Experiment 1 25000 HCMEC D3
      7123  145     C  C02 105.67135      4000 1 : Experiment 1 25000 HCMEC D3
      7124  150     C  C02 106.49956      4000 1 : Experiment 1 25000 HCMEC D3
      7125  155     C  C02 107.03352      4000 1 : Experiment 1 25000 HCMEC D3
      7126  160     C  C02 107.47203      4000 1 : Experiment 1 25000 HCMEC D3
      7127  165     C  C02 108.30312      4000 1 : Experiment 1 25000 HCMEC D3
      7128  170     C  C02 108.87697      4000 1 : Experiment 1 25000 HCMEC D3
      7129  175     C  C02 109.46301      4000 1 : Experiment 1 25000 HCMEC D3
      7130  180     C  C02 110.39290      4000 1 : Experiment 1 25000 HCMEC D3
      7131  185     C  C02 111.10596      4000 1 : Experiment 1 25000 HCMEC D3
      7132  190     C  C02 111.41372      4000 1 : Experiment 1 25000 HCMEC D3
      7133  195     C  C02 111.81613      4000 1 : Experiment 1 25000 HCMEC D3
      7134  200     C  C02        NA      4000 1 : Experiment 1 25000 HCMEC D3
      7135    0     C  C02        NA       500 1 : Experiment 1 25000 HCMEC D3
      7136    5     C  C02 120.64100       500 1 : Experiment 1 25000 HCMEC D3
      7137   10     C  C02 120.41674       500 1 : Experiment 1 25000 HCMEC D3
      7138   15     C  C02 120.02286       500 1 : Experiment 1 25000 HCMEC D3
      7139   20     C  C02 119.82170       500 1 : Experiment 1 25000 HCMEC D3
      7140   25     C  C02 119.62660       500 1 : Experiment 1 25000 HCMEC D3
      7141   30     C  C02 119.69087       500 1 : Experiment 1 25000 HCMEC D3
      7142   35     C  C02 119.99737       500 1 : Experiment 1 25000 HCMEC D3
      7143   40     C  C02 120.29480       500 1 : Experiment 1 25000 HCMEC D3
      7144   45     C  C02 120.67753       500 1 : Experiment 1 25000 HCMEC D3
      7145   50     C  C02 120.96358       500 1 : Experiment 1 25000 HCMEC D3
      7146   55     C  C02 121.39682       500 1 : Experiment 1 25000 HCMEC D3
      7147   60     C  C02 121.75049       500 1 : Experiment 1 25000 HCMEC D3
      7148   65     C  C02 122.18384       500 1 : Experiment 1 25000 HCMEC D3
      7149   70     C  C02 122.46503       500 1 : Experiment 1 25000 HCMEC D3
      7150   75     C  C02 122.76761       500 1 : Experiment 1 25000 HCMEC D3
      7151   80     C  C02 123.10728       500 1 : Experiment 1 25000 HCMEC D3
      7152   85     C  C02 123.31170       500 1 : Experiment 1 25000 HCMEC D3
      7153   90     C  C02 123.47203       500 1 : Experiment 1 25000 HCMEC D3
      7154   95     C  C02 123.63334       500 1 : Experiment 1 25000 HCMEC D3
      7155  100     C  C02 123.80277       500 1 : Experiment 1 25000 HCMEC D3
      7156  105     C  C02 123.93529       500 1 : Experiment 1 25000 HCMEC D3
      7157  110     C  C02 124.09788       500 1 : Experiment 1 25000 HCMEC D3
      7158  115     C  C02 124.26583       500 1 : Experiment 1 25000 HCMEC D3
      7159  120     C  C02 124.39492       500 1 : Experiment 1 25000 HCMEC D3
      7160  125     C  C02 124.49326       500 1 : Experiment 1 25000 HCMEC D3
      7161  130     C  C02 124.59163       500 1 : Experiment 1 25000 HCMEC D3
      7162  135     C  C02 124.74285       500 1 : Experiment 1 25000 HCMEC D3
      7163  140     C  C02 124.83913       500 1 : Experiment 1 25000 HCMEC D3
      7164  145     C  C02 124.93932       500 1 : Experiment 1 25000 HCMEC D3
      7165  150     C  C02 125.02890       500 1 : Experiment 1 25000 HCMEC D3
      7166  155     C  C02 125.08368       500 1 : Experiment 1 25000 HCMEC D3
      7167  160     C  C02 125.14774       500 1 : Experiment 1 25000 HCMEC D3
      7168  165     C  C02 125.23920       500 1 : Experiment 1 25000 HCMEC D3
      7169  170     C  C02 125.28714       500 1 : Experiment 1 25000 HCMEC D3
      7170  175     C  C02 125.38092       500 1 : Experiment 1 25000 HCMEC D3
      7171  180     C  C02 125.49271       500 1 : Experiment 1 25000 HCMEC D3
      7172  185     C  C02 125.56232       500 1 : Experiment 1 25000 HCMEC D3
      7173  190     C  C02 125.55906       500 1 : Experiment 1 25000 HCMEC D3
      7174  195     C  C02 125.60037       500 1 : Experiment 1 25000 HCMEC D3
      7175  200     C  C02        NA       500 1 : Experiment 1 25000 HCMEC D3
      7176    0     C  C02        NA     64000 1 : Experiment 1 25000 HCMEC D3
      7177    5     C  C02  54.45206     64000 1 : Experiment 1 25000 HCMEC D3
      7178   10     C  C02  48.18728     64000 1 : Experiment 1 25000 HCMEC D3
      7179   15     C  C02  41.49570     64000 1 : Experiment 1 25000 HCMEC D3
      7180   20     C  C02  36.06491     64000 1 : Experiment 1 25000 HCMEC D3
      7181   25     C  C02  32.23353     64000 1 : Experiment 1 25000 HCMEC D3
      7182   30     C  C02  28.54222     64000 1 : Experiment 1 25000 HCMEC D3
      7183   35     C  C02  26.38594     64000 1 : Experiment 1 25000 HCMEC D3
      7184   40     C  C02  24.38645     64000 1 : Experiment 1 25000 HCMEC D3
      7185   45     C  C02  20.83631     64000 1 : Experiment 1 25000 HCMEC D3
      7186   50     C  C02  18.11951     64000 1 : Experiment 1 25000 HCMEC D3
      7187   55     C  C02  14.62832     64000 1 : Experiment 1 25000 HCMEC D3
      7188   60     C  C02  12.81325     64000 1 : Experiment 1 25000 HCMEC D3
      7189   65     C  C02  11.52762     64000 1 : Experiment 1 25000 HCMEC D3
      7190   70     C  C02  11.09406     64000 1 : Experiment 1 25000 HCMEC D3
      7191   75     C  C02  10.89085     64000 1 : Experiment 1 25000 HCMEC D3
      7192   80     C  C02  11.04345     64000 1 : Experiment 1 25000 HCMEC D3
      7193   85     C  C02  11.12412     64000 1 : Experiment 1 25000 HCMEC D3
      7194   90     C  C02  11.17582     64000 1 : Experiment 1 25000 HCMEC D3
      7195   95     C  C02  11.46311     64000 1 : Experiment 1 25000 HCMEC D3
      7196  100     C  C02  11.87419     64000 1 : Experiment 1 25000 HCMEC D3
      7197  105     C  C02  12.14129     64000 1 : Experiment 1 25000 HCMEC D3
      7198  110     C  C02  12.43964     64000 1 : Experiment 1 25000 HCMEC D3
      7199  115     C  C02  12.84904     64000 1 : Experiment 1 25000 HCMEC D3
      7200  120     C  C02  13.30167     64000 1 : Experiment 1 25000 HCMEC D3
      7201  125     C  C02  13.92143     64000 1 : Experiment 1 25000 HCMEC D3
      7202  130     C  C02  14.54958     64000 1 : Experiment 1 25000 HCMEC D3
      7203  135     C  C02  15.03757     64000 1 : Experiment 1 25000 HCMEC D3
      7204  140     C  C02  15.67239     64000 1 : Experiment 1 25000 HCMEC D3
      7205  145     C  C02  16.24002     64000 1 : Experiment 1 25000 HCMEC D3
      7206  150     C  C02  16.93643     64000 1 : Experiment 1 25000 HCMEC D3
      7207  155     C  C02  17.68563     64000 1 : Experiment 1 25000 HCMEC D3
      7208  160     C  C02  18.43072     64000 1 : Experiment 1 25000 HCMEC D3
      7209  165     C  C02  18.99445     64000 1 : Experiment 1 25000 HCMEC D3
      7210  170     C  C02  19.68497     64000 1 : Experiment 1 25000 HCMEC D3
      7211  175     C  C02  20.40215     64000 1 : Experiment 1 25000 HCMEC D3
      7212  180     C  C02  21.52895     64000 1 : Experiment 1 25000 HCMEC D3
      7213  185     C  C02  22.05177     64000 1 : Experiment 1 25000 HCMEC D3
      7214  190     C  C02  22.85598     64000 1 : Experiment 1 25000 HCMEC D3
      7215  195     C  C02  23.70310     64000 1 : Experiment 1 25000 HCMEC D3
      7216  200     C  C02        NA     64000 1 : Experiment 1 25000 HCMEC D3
      7217    0     C  C02        NA      8000 1 : Experiment 1 25000 HCMEC D3
      7218    5     C  C02  95.72708      8000 1 : Experiment 1 25000 HCMEC D3
      7219   10     C  C02  89.38786      8000 1 : Experiment 1 25000 HCMEC D3
      7220   15     C  C02  81.74106      8000 1 : Experiment 1 25000 HCMEC D3
      7221   20     C  C02  76.32993      8000 1 : Experiment 1 25000 HCMEC D3
      7222   25     C  C02  71.78476      8000 1 : Experiment 1 25000 HCMEC D3
      7223   30     C  C02  68.68716      8000 1 : Experiment 1 25000 HCMEC D3
      7224   35     C  C02  67.41146      8000 1 : Experiment 1 25000 HCMEC D3
      7225   40     C  C02  65.73475      8000 1 : Experiment 1 25000 HCMEC D3
      7226   45     C  C02  63.90646      8000 1 : Experiment 1 25000 HCMEC D3
      7227   50     C  C02  63.06509      8000 1 : Experiment 1 25000 HCMEC D3
      7228   55     C  C02  64.67215      8000 1 : Experiment 1 25000 HCMEC D3
      7229   60     C  C02  65.34944      8000 1 : Experiment 1 25000 HCMEC D3
      7230   65     C  C02  66.94598      8000 1 : Experiment 1 25000 HCMEC D3
      7231   70     C  C02  68.22094      8000 1 : Experiment 1 25000 HCMEC D3
      7232   75     C  C02  69.05679      8000 1 : Experiment 1 25000 HCMEC D3
      7233   80     C  C02  70.59028      8000 1 : Experiment 1 25000 HCMEC D3
      7234   85     C  C02  71.70490      8000 1 : Experiment 1 25000 HCMEC D3
      7235   90     C  C02  72.12885      8000 1 : Experiment 1 25000 HCMEC D3
      7236   95     C  C02  73.46654      8000 1 : Experiment 1 25000 HCMEC D3
      7237  100     C  C02  74.59447      8000 1 : Experiment 1 25000 HCMEC D3
      7238  105     C  C02  75.20802      8000 1 : Experiment 1 25000 HCMEC D3
      7239  110     C  C02  76.79847      8000 1 : Experiment 1 25000 HCMEC D3
      7240  115     C  C02  78.33472      8000 1 : Experiment 1 25000 HCMEC D3
      7241  120     C  C02  79.40618      8000 1 : Experiment 1 25000 HCMEC D3
      7242  125     C  C02  80.71757      8000 1 : Experiment 1 25000 HCMEC D3
      7243  130     C  C02  81.95080      8000 1 : Experiment 1 25000 HCMEC D3
      7244  135     C  C02  83.47123      8000 1 : Experiment 1 25000 HCMEC D3
      7245  140     C  C02  84.55500      8000 1 : Experiment 1 25000 HCMEC D3
      7246  145     C  C02  86.04408      8000 1 : Experiment 1 25000 HCMEC D3
      7247  150     C  C02  87.36400      8000 1 : Experiment 1 25000 HCMEC D3
      7248  155     C  C02  88.35755      8000 1 : Experiment 1 25000 HCMEC D3
      7249  160     C  C02  89.04440      8000 1 : Experiment 1 25000 HCMEC D3
      7250  165     C  C02  90.37624      8000 1 : Experiment 1 25000 HCMEC D3
      7251  170     C  C02  91.40117      8000 1 : Experiment 1 25000 HCMEC D3
      7252  175     C  C02  92.29191      8000 1 : Experiment 1 25000 HCMEC D3
      7253  180     C  C02  93.50613      8000 1 : Experiment 1 25000 HCMEC D3
      7254  185     C  C02  94.55223      8000 1 : Experiment 1 25000 HCMEC D3
      7255  190     C  C02  95.18211      8000 1 : Experiment 1 25000 HCMEC D3
      7256  195     C  C02  95.73448      8000 1 : Experiment 1 25000 HCMEC D3
      7257  200     C  C02        NA      8000 1 : Experiment 1 25000 HCMEC D3
      7258    0     C  C03        NA      1000 1 : Experiment 1 25000 HCMEC D3
      7259    5     C  C03 118.24939      1000 1 : Experiment 1 25000 HCMEC D3
      7260   10     C  C03 117.76417      1000 1 : Experiment 1 25000 HCMEC D3
      7261   15     C  C03 116.84750      1000 1 : Experiment 1 25000 HCMEC D3
      7262   20     C  C03 116.12553      1000 1 : Experiment 1 25000 HCMEC D3
      7263   25     C  C03 115.69914      1000 1 : Experiment 1 25000 HCMEC D3
      7264   30     C  C03 115.34104      1000 1 : Experiment 1 25000 HCMEC D3
      7265   35     C  C03 115.65920      1000 1 : Experiment 1 25000 HCMEC D3
      7266   40     C  C03 115.88392      1000 1 : Experiment 1 25000 HCMEC D3
      7267   45     C  C03 116.02732      1000 1 : Experiment 1 25000 HCMEC D3
      7268   50     C  C03 116.35170      1000 1 : Experiment 1 25000 HCMEC D3
      7269   55     C  C03 116.62171      1000 1 : Experiment 1 25000 HCMEC D3
      7270   60     C  C03 117.58845      1000 1 : Experiment 1 25000 HCMEC D3
      7271   65     C  C03 118.26795      1000 1 : Experiment 1 25000 HCMEC D3
      7272   70     C  C03 118.90772      1000 1 : Experiment 1 25000 HCMEC D3
      7273   75     C  C03 119.40413      1000 1 : Experiment 1 25000 HCMEC D3
      7274   80     C  C03 119.87722      1000 1 : Experiment 1 25000 HCMEC D3
      7275   85     C  C03 120.18923      1000 1 : Experiment 1 25000 HCMEC D3
      7276   90     C  C03 120.43141      1000 1 : Experiment 1 25000 HCMEC D3
      7277   95     C  C03 120.69498      1000 1 : Experiment 1 25000 HCMEC D3
      7278  100     C  C03 120.95639      1000 1 : Experiment 1 25000 HCMEC D3
      7279  105     C  C03 121.25009      1000 1 : Experiment 1 25000 HCMEC D3
      7280  110     C  C03 121.48663      1000 1 : Experiment 1 25000 HCMEC D3
      7281  115     C  C03 121.74950      1000 1 : Experiment 1 25000 HCMEC D3
      7282  120     C  C03 122.08382      1000 1 : Experiment 1 25000 HCMEC D3
      7283  125     C  C03 122.23497      1000 1 : Experiment 1 25000 HCMEC D3
      7284  130     C  C03 122.50310      1000 1 : Experiment 1 25000 HCMEC D3
      7285  135     C  C03 122.63650      1000 1 : Experiment 1 25000 HCMEC D3
      7286  140     C  C03 122.80127      1000 1 : Experiment 1 25000 HCMEC D3
      7287  145     C  C03 122.90141      1000 1 : Experiment 1 25000 HCMEC D3
      7288  150     C  C03 123.04370      1000 1 : Experiment 1 25000 HCMEC D3
      7289  155     C  C03 123.21964      1000 1 : Experiment 1 25000 HCMEC D3
      7290  160     C  C03 123.37733      1000 1 : Experiment 1 25000 HCMEC D3
      7291  165     C  C03 123.59092      1000 1 : Experiment 1 25000 HCMEC D3
      7292  170     C  C03 123.71666      1000 1 : Experiment 1 25000 HCMEC D3
      7293  175     C  C03 123.87072      1000 1 : Experiment 1 25000 HCMEC D3
      7294  180     C  C03 124.09564      1000 1 : Experiment 1 25000 HCMEC D3
      7295  185     C  C03 124.21561      1000 1 : Experiment 1 25000 HCMEC D3
      7296  190     C  C03 124.31706      1000 1 : Experiment 1 25000 HCMEC D3
      7297  195     C  C03 124.43675      1000 1 : Experiment 1 25000 HCMEC D3
      7298  200     C  C03        NA      1000 1 : Experiment 1 25000 HCMEC D3
      7299    0     C  C03        NA     16000 1 : Experiment 1 25000 HCMEC D3
      7300    5     C  C03  84.84654     16000 1 : Experiment 1 25000 HCMEC D3
      7301   10     C  C03  78.49876     16000 1 : Experiment 1 25000 HCMEC D3
      7302   15     C  C03  71.62379     16000 1 : Experiment 1 25000 HCMEC D3
      7303   20     C  C03  64.87344     16000 1 : Experiment 1 25000 HCMEC D3
      7304   25     C  C03  59.98997     16000 1 : Experiment 1 25000 HCMEC D3
      7305   30     C  C03  55.42217     16000 1 : Experiment 1 25000 HCMEC D3
      7306   35     C  C03  53.55622     16000 1 : Experiment 1 25000 HCMEC D3
      7307   40     C  C03  50.99727     16000 1 : Experiment 1 25000 HCMEC D3
      7308   45     C  C03  47.41774     16000 1 : Experiment 1 25000 HCMEC D3
      7309   50     C  C03  45.12558     16000 1 : Experiment 1 25000 HCMEC D3
      7310   55     C  C03  43.23381     16000 1 : Experiment 1 25000 HCMEC D3
      7311   60     C  C03  42.41935     16000 1 : Experiment 1 25000 HCMEC D3
      7312   65     C  C03  42.32086     16000 1 : Experiment 1 25000 HCMEC D3
      7313   70     C  C03  42.65629     16000 1 : Experiment 1 25000 HCMEC D3
      7314   75     C  C03  42.62389     16000 1 : Experiment 1 25000 HCMEC D3
      7315   80     C  C03  43.38711     16000 1 : Experiment 1 25000 HCMEC D3
      7316   85     C  C03  44.35837     16000 1 : Experiment 1 25000 HCMEC D3
      7317   90     C  C03  45.14964     16000 1 : Experiment 1 25000 HCMEC D3
      7318   95     C  C03  45.20413     16000 1 : Experiment 1 25000 HCMEC D3
      7319  100     C  C03  46.44655     16000 1 : Experiment 1 25000 HCMEC D3
      7320  105     C  C03  47.65618     16000 1 : Experiment 1 25000 HCMEC D3
      7321  110     C  C03  48.89853     16000 1 : Experiment 1 25000 HCMEC D3
      7322  115     C  C03  50.19335     16000 1 : Experiment 1 25000 HCMEC D3
      7323  120     C  C03  51.85923     16000 1 : Experiment 1 25000 HCMEC D3
      7324  125     C  C03  52.59297     16000 1 : Experiment 1 25000 HCMEC D3
      7325  130     C  C03  54.18869     16000 1 : Experiment 1 25000 HCMEC D3
      7326  135     C  C03  55.51334     16000 1 : Experiment 1 25000 HCMEC D3
      7327  140     C  C03  56.50519     16000 1 : Experiment 1 25000 HCMEC D3
      7328  145     C  C03  57.90366     16000 1 : Experiment 1 25000 HCMEC D3
      7329  150     C  C03  59.59201     16000 1 : Experiment 1 25000 HCMEC D3
      7330  155     C  C03  60.85094     16000 1 : Experiment 1 25000 HCMEC D3
      7331  160     C  C03  61.93704     16000 1 : Experiment 1 25000 HCMEC D3
      7332  165     C  C03  63.61269     16000 1 : Experiment 1 25000 HCMEC D3
      7333  170     C  C03  64.85895     16000 1 : Experiment 1 25000 HCMEC D3
      7334  175     C  C03  65.93156     16000 1 : Experiment 1 25000 HCMEC D3
      7335  180     C  C03  67.69641     16000 1 : Experiment 1 25000 HCMEC D3
      7336  185     C  C03  68.77175     16000 1 : Experiment 1 25000 HCMEC D3
      7337  190     C  C03  69.71484     16000 1 : Experiment 1 25000 HCMEC D3
      7338  195     C  C03  70.45432     16000 1 : Experiment 1 25000 HCMEC D3
      7339  200     C  C03        NA     16000 1 : Experiment 1 25000 HCMEC D3
      7340    0     C  C03        NA      2000 1 : Experiment 1 25000 HCMEC D3
      7341    5     C  C03 113.82309      2000 1 : Experiment 1 25000 HCMEC D3
      7342   10     C  C03 112.01708      2000 1 : Experiment 1 25000 HCMEC D3
      7343   15     C  C03 109.54874      2000 1 : Experiment 1 25000 HCMEC D3
      7344   20     C  C03 107.45261      2000 1 : Experiment 1 25000 HCMEC D3
      7345   25     C  C03 106.07757      2000 1 : Experiment 1 25000 HCMEC D3
      7346   30     C  C03 104.82208      2000 1 : Experiment 1 25000 HCMEC D3
      7347   35     C  C03 105.05554      2000 1 : Experiment 1 25000 HCMEC D3
      7348   40     C  C03 104.94840      2000 1 : Experiment 1 25000 HCMEC D3
      7349   45     C  C03 104.55566      2000 1 : Experiment 1 25000 HCMEC D3
      7350   50     C  C03 104.83085      2000 1 : Experiment 1 25000 HCMEC D3
      7351   55     C  C03 105.32346      2000 1 : Experiment 1 25000 HCMEC D3
      7352   60     C  C03 107.13308      2000 1 : Experiment 1 25000 HCMEC D3
      7353   65     C  C03 108.48040      2000 1 : Experiment 1 25000 HCMEC D3
      7354   70     C  C03 109.64177      2000 1 : Experiment 1 25000 HCMEC D3
      7355   75     C  C03 110.57816      2000 1 : Experiment 1 25000 HCMEC D3
      7356   80     C  C03 111.38214      2000 1 : Experiment 1 25000 HCMEC D3
      7357   85     C  C03 111.94444      2000 1 : Experiment 1 25000 HCMEC D3
      7358   90     C  C03 112.29301      2000 1 : Experiment 1 25000 HCMEC D3
      7359   95     C  C03 112.65077      2000 1 : Experiment 1 25000 HCMEC D3
      7360  100     C  C03 113.00274      2000 1 : Experiment 1 25000 HCMEC D3
      7361  105     C  C03 113.51433      2000 1 : Experiment 1 25000 HCMEC D3
      7362  110     C  C03 113.96512      2000 1 : Experiment 1 25000 HCMEC D3
      7363  115     C  C03 114.50283      2000 1 : Experiment 1 25000 HCMEC D3
      7364  120     C  C03 115.17897      2000 1 : Experiment 1 25000 HCMEC D3
      7365  125     C  C03 115.44941      2000 1 : Experiment 1 25000 HCMEC D3
      7366  130     C  C03 115.99830      2000 1 : Experiment 1 25000 HCMEC D3
      7367  135     C  C03 116.31011      2000 1 : Experiment 1 25000 HCMEC D3
      7368  140     C  C03 116.62849      2000 1 : Experiment 1 25000 HCMEC D3
      7369  145     C  C03 116.82939      2000 1 : Experiment 1 25000 HCMEC D3
      7370  150     C  C03 117.22231      2000 1 : Experiment 1 25000 HCMEC D3
      7371  155     C  C03 117.59078      2000 1 : Experiment 1 25000 HCMEC D3
      7372  160     C  C03 117.95640      2000 1 : Experiment 1 25000 HCMEC D3
      7373  165     C  C03 118.45684      2000 1 : Experiment 1 25000 HCMEC D3
      7374  170     C  C03 118.74126      2000 1 : Experiment 1 25000 HCMEC D3
      7375  175     C  C03 119.09055      2000 1 : Experiment 1 25000 HCMEC D3
      7376  180     C  C03 119.64514      2000 1 : Experiment 1 25000 HCMEC D3
      7377  185     C  C03 119.93158      2000 1 : Experiment 1 25000 HCMEC D3
      7378  190     C  C03 120.17488      2000 1 : Experiment 1 25000 HCMEC D3
      7379  195     C  C03 120.44601      2000 1 : Experiment 1 25000 HCMEC D3
      7380  200     C  C03        NA      2000 1 : Experiment 1 25000 HCMEC D3
      7381    0     C  C03        NA       250 1 : Experiment 1 25000 HCMEC D3
      7382    5     C  C03 123.46692       250 1 : Experiment 1 25000 HCMEC D3
      7383   10     C  C03 123.36754       250 1 : Experiment 1 25000 HCMEC D3
      7384   15     C  C03 123.26872       250 1 : Experiment 1 25000 HCMEC D3
      7385   20     C  C03 123.23862       250 1 : Experiment 1 25000 HCMEC D3
      7386   25     C  C03 123.26192       250 1 : Experiment 1 25000 HCMEC D3
      7387   30     C  C03 123.34965       250 1 : Experiment 1 25000 HCMEC D3
      7388   35     C  C03 123.57059       250 1 : Experiment 1 25000 HCMEC D3
      7389   40     C  C03 123.76910       250 1 : Experiment 1 25000 HCMEC D3
      7390   45     C  C03 123.97634       250 1 : Experiment 1 25000 HCMEC D3
      7391   50     C  C03 124.19832       250 1 : Experiment 1 25000 HCMEC D3
      7392   55     C  C03 124.40091       250 1 : Experiment 1 25000 HCMEC D3
      7393   60     C  C03 124.69693       250 1 : Experiment 1 25000 HCMEC D3
      7394   65     C  C03 124.95970       250 1 : Experiment 1 25000 HCMEC D3
      7395   70     C  C03 125.23451       250 1 : Experiment 1 25000 HCMEC D3
      7396   75     C  C03 125.46833       250 1 : Experiment 1 25000 HCMEC D3
      7397   80     C  C03 125.70438       250 1 : Experiment 1 25000 HCMEC D3
      7398   85     C  C03 125.87901       250 1 : Experiment 1 25000 HCMEC D3
      7399   90     C  C03 126.03382       250 1 : Experiment 1 25000 HCMEC D3
      7400   95     C  C03 126.19193       250 1 : Experiment 1 25000 HCMEC D3
      7401  100     C  C03 126.34296       250 1 : Experiment 1 25000 HCMEC D3
      7402  105     C  C03 126.48423       250 1 : Experiment 1 25000 HCMEC D3
      7403  110     C  C03 126.58935       250 1 : Experiment 1 25000 HCMEC D3
      7404  115     C  C03 126.70393       250 1 : Experiment 1 25000 HCMEC D3
      7405  120     C  C03 126.81280       250 1 : Experiment 1 25000 HCMEC D3
      7406  125     C  C03 126.90969       250 1 : Experiment 1 25000 HCMEC D3
      7407  130     C  C03 126.99881       250 1 : Experiment 1 25000 HCMEC D3
      7408  135     C  C03 127.06124       250 1 : Experiment 1 25000 HCMEC D3
      7409  140     C  C03 127.15652       250 1 : Experiment 1 25000 HCMEC D3
      7410  145     C  C03 127.21275       250 1 : Experiment 1 25000 HCMEC D3
      7411  150     C  C03 127.28035       250 1 : Experiment 1 25000 HCMEC D3
      7412  155     C  C03 127.34780       250 1 : Experiment 1 25000 HCMEC D3
      7413  160     C  C03 127.41047       250 1 : Experiment 1 25000 HCMEC D3
      7414  165     C  C03 127.47639       250 1 : Experiment 1 25000 HCMEC D3
      7415  170     C  C03 127.53067       250 1 : Experiment 1 25000 HCMEC D3
      7416  175     C  C03 127.58238       250 1 : Experiment 1 25000 HCMEC D3
      7417  180     C  C03 127.63111       250 1 : Experiment 1 25000 HCMEC D3
      7418  185     C  C03 127.67733       250 1 : Experiment 1 25000 HCMEC D3
      7419  190     C  C03 127.71024       250 1 : Experiment 1 25000 HCMEC D3
      7420  195     C  C03 127.74258       250 1 : Experiment 1 25000 HCMEC D3
      7421  200     C  C03        NA       250 1 : Experiment 1 25000 HCMEC D3
      7422    0     C  C03        NA     32000 1 : Experiment 1 25000 HCMEC D3
      7423    5     C  C03  72.34458     32000 1 : Experiment 1 25000 HCMEC D3
      7424   10     C  C03  66.09190     32000 1 : Experiment 1 25000 HCMEC D3
      7425   15     C  C03  59.29172     32000 1 : Experiment 1 25000 HCMEC D3
      7426   20     C  C03  52.52457     32000 1 : Experiment 1 25000 HCMEC D3
      7427   25     C  C03  47.62557     32000 1 : Experiment 1 25000 HCMEC D3
      7428   30     C  C03  43.03916     32000 1 : Experiment 1 25000 HCMEC D3
      7429   35     C  C03  41.04046     32000 1 : Experiment 1 25000 HCMEC D3
      7430   40     C  C03  38.26786     32000 1 : Experiment 1 25000 HCMEC D3
      7431   45     C  C03  34.44003     32000 1 : Experiment 1 25000 HCMEC D3
      7432   50     C  C03  31.34786     32000 1 : Experiment 1 25000 HCMEC D3
      7433   55     C  C03  28.15801     32000 1 : Experiment 1 25000 HCMEC D3
      7434   60     C  C03  25.38929     32000 1 : Experiment 1 25000 HCMEC D3
      7435   65     C  C03  23.58188     32000 1 : Experiment 1 25000 HCMEC D3
      7436   70     C  C03  22.83923     32000 1 : Experiment 1 25000 HCMEC D3
      7437   75     C  C03  21.91682     32000 1 : Experiment 1 25000 HCMEC D3
      7438   80     C  C03  22.14806     32000 1 : Experiment 1 25000 HCMEC D3
      7439   85     C  C03  22.66377     32000 1 : Experiment 1 25000 HCMEC D3
      7440   90     C  C03  23.17788     32000 1 : Experiment 1 25000 HCMEC D3
      7441   95     C  C03  22.96391     32000 1 : Experiment 1 25000 HCMEC D3
      7442  100     C  C03  23.89166     32000 1 : Experiment 1 25000 HCMEC D3
      7443  105     C  C03  24.48479     32000 1 : Experiment 1 25000 HCMEC D3
      7444  110     C  C03  25.50404     32000 1 : Experiment 1 25000 HCMEC D3
      7445  115     C  C03  26.27508     32000 1 : Experiment 1 25000 HCMEC D3
      7446  120     C  C03  27.47159     32000 1 : Experiment 1 25000 HCMEC D3
      7447  125     C  C03  28.00687     32000 1 : Experiment 1 25000 HCMEC D3
      7448  130     C  C03  29.27140     32000 1 : Experiment 1 25000 HCMEC D3
      7449  135     C  C03  30.30520     32000 1 : Experiment 1 25000 HCMEC D3
      7450  140     C  C03  31.17419     32000 1 : Experiment 1 25000 HCMEC D3
      7451  145     C  C03  32.33558     32000 1 : Experiment 1 25000 HCMEC D3
      7452  150     C  C03  33.75999     32000 1 : Experiment 1 25000 HCMEC D3
      7453  155     C  C03  34.81972     32000 1 : Experiment 1 25000 HCMEC D3
      7454  160     C  C03  35.65843     32000 1 : Experiment 1 25000 HCMEC D3
      7455  165     C  C03  37.21602     32000 1 : Experiment 1 25000 HCMEC D3
      7456  170     C  C03  38.50362     32000 1 : Experiment 1 25000 HCMEC D3
      7457  175     C  C03  39.55101     32000 1 : Experiment 1 25000 HCMEC D3
      7458  180     C  C03  41.16578     32000 1 : Experiment 1 25000 HCMEC D3
      7459  185     C  C03  42.28855     32000 1 : Experiment 1 25000 HCMEC D3
      7460  190     C  C03  43.18278     32000 1 : Experiment 1 25000 HCMEC D3
      7461  195     C  C03  44.10210     32000 1 : Experiment 1 25000 HCMEC D3
      7462  200     C  C03        NA     32000 1 : Experiment 1 25000 HCMEC D3
      7463    0     C  C03        NA      4000 1 : Experiment 1 25000 HCMEC D3
      7464    5     C  C03 106.41565      4000 1 : Experiment 1 25000 HCMEC D3
      7465   10     C  C03 102.78555      4000 1 : Experiment 1 25000 HCMEC D3
      7466   15     C  C03  98.39162      4000 1 : Experiment 1 25000 HCMEC D3
      7467   20     C  C03  94.45457      4000 1 : Experiment 1 25000 HCMEC D3
      7468   25     C  C03  91.71333      4000 1 : Experiment 1 25000 HCMEC D3
      7469   30     C  C03  89.20286      4000 1 : Experiment 1 25000 HCMEC D3
      7470   35     C  C03  88.93207      4000 1 : Experiment 1 25000 HCMEC D3
      7471   40     C  C03  88.06193      4000 1 : Experiment 1 25000 HCMEC D3
      7472   45     C  C03  86.73419      4000 1 : Experiment 1 25000 HCMEC D3
      7473   50     C  C03  86.71675      4000 1 : Experiment 1 25000 HCMEC D3
      7474   55     C  C03  87.27466      4000 1 : Experiment 1 25000 HCMEC D3
      7475   60     C  C03  89.61277      4000 1 : Experiment 1 25000 HCMEC D3
      7476   65     C  C03  91.60613      4000 1 : Experiment 1 25000 HCMEC D3
      7477   70     C  C03  93.31547      4000 1 : Experiment 1 25000 HCMEC D3
      7478   75     C  C03  94.67146      4000 1 : Experiment 1 25000 HCMEC D3
      7479   80     C  C03  95.89807      4000 1 : Experiment 1 25000 HCMEC D3
      7480   85     C  C03  96.91188      4000 1 : Experiment 1 25000 HCMEC D3
      7481   90     C  C03  97.53079      4000 1 : Experiment 1 25000 HCMEC D3
      7482   95     C  C03  97.97449      4000 1 : Experiment 1 25000 HCMEC D3
      7483  100     C  C03  98.59103      4000 1 : Experiment 1 25000 HCMEC D3
      7484  105     C  C03  99.60193      4000 1 : Experiment 1 25000 HCMEC D3
      7485  110     C  C03 100.20486      4000 1 : Experiment 1 25000 HCMEC D3
      7486  115     C  C03 101.09934      4000 1 : Experiment 1 25000 HCMEC D3
      7487  120     C  C03 102.20353      4000 1 : Experiment 1 25000 HCMEC D3
      7488  125     C  C03 102.60635      4000 1 : Experiment 1 25000 HCMEC D3
      7489  130     C  C03 103.45336      4000 1 : Experiment 1 25000 HCMEC D3
      7490  135     C  C03 104.06100      4000 1 : Experiment 1 25000 HCMEC D3
      7491  140     C  C03 104.54543      4000 1 : Experiment 1 25000 HCMEC D3
      7492  145     C  C03 104.98851      4000 1 : Experiment 1 25000 HCMEC D3
      7493  150     C  C03 105.78372      4000 1 : Experiment 1 25000 HCMEC D3
      7494  155     C  C03 106.40821      4000 1 : Experiment 1 25000 HCMEC D3
      7495  160     C  C03 107.05910      4000 1 : Experiment 1 25000 HCMEC D3
      7496  165     C  C03 107.90492      4000 1 : Experiment 1 25000 HCMEC D3
      7497  170     C  C03 108.42765      4000 1 : Experiment 1 25000 HCMEC D3
      7498  175     C  C03 108.99981      4000 1 : Experiment 1 25000 HCMEC D3
      7499  180     C  C03 109.95670      4000 1 : Experiment 1 25000 HCMEC D3
      7500  185     C  C03 110.46638      4000 1 : Experiment 1 25000 HCMEC D3
      7501  190     C  C03 110.90604      4000 1 : Experiment 1 25000 HCMEC D3
      7502  195     C  C03 111.32362      4000 1 : Experiment 1 25000 HCMEC D3
      7503  200     C  C03        NA      4000 1 : Experiment 1 25000 HCMEC D3
      7504    0     C  C03        NA       500 1 : Experiment 1 25000 HCMEC D3
      7505    5     C  C03 121.29452       500 1 : Experiment 1 25000 HCMEC D3
      7506   10     C  C03 121.19115       500 1 : Experiment 1 25000 HCMEC D3
      7507   15     C  C03 120.93607       500 1 : Experiment 1 25000 HCMEC D3
      7508   20     C  C03 120.77514       500 1 : Experiment 1 25000 HCMEC D3
      7509   25     C  C03 120.72201       500 1 : Experiment 1 25000 HCMEC D3
      7510   30     C  C03 120.70939       500 1 : Experiment 1 25000 HCMEC D3
      7511   35     C  C03 120.97680       500 1 : Experiment 1 25000 HCMEC D3
      7512   40     C  C03 121.19804       500 1 : Experiment 1 25000 HCMEC D3
      7513   45     C  C03 121.44690       500 1 : Experiment 1 25000 HCMEC D3
      7514   50     C  C03 121.71785       500 1 : Experiment 1 25000 HCMEC D3
      7515   55     C  C03 121.92405       500 1 : Experiment 1 25000 HCMEC D3
      7516   60     C  C03 122.41563       500 1 : Experiment 1 25000 HCMEC D3
      7517   65     C  C03 122.80001       500 1 : Experiment 1 25000 HCMEC D3
      7518   70     C  C03 123.16811       500 1 : Experiment 1 25000 HCMEC D3
      7519   75     C  C03 123.45616       500 1 : Experiment 1 25000 HCMEC D3
      7520   80     C  C03 123.74539       500 1 : Experiment 1 25000 HCMEC D3
      7521   85     C  C03 123.95826       500 1 : Experiment 1 25000 HCMEC D3
      7522   90     C  C03 124.14201       500 1 : Experiment 1 25000 HCMEC D3
      7523   95     C  C03 124.33127       500 1 : Experiment 1 25000 HCMEC D3
      7524  100     C  C03 124.51464       500 1 : Experiment 1 25000 HCMEC D3
      7525  105     C  C03 124.70450       500 1 : Experiment 1 25000 HCMEC D3
      7526  110     C  C03 124.84197       500 1 : Experiment 1 25000 HCMEC D3
      7527  115     C  C03 124.99753       500 1 : Experiment 1 25000 HCMEC D3
      7528  120     C  C03 125.16276       500 1 : Experiment 1 25000 HCMEC D3
      7529  125     C  C03 125.27790       500 1 : Experiment 1 25000 HCMEC D3
      7530  130     C  C03 125.40748       500 1 : Experiment 1 25000 HCMEC D3
      7531  135     C  C03 125.48717       500 1 : Experiment 1 25000 HCMEC D3
      7532  140     C  C03 125.59764       500 1 : Experiment 1 25000 HCMEC D3
      7533  145     C  C03 125.67007       500 1 : Experiment 1 25000 HCMEC D3
      7534  150     C  C03 125.74300       500 1 : Experiment 1 25000 HCMEC D3
      7535  155     C  C03 125.83540       500 1 : Experiment 1 25000 HCMEC D3
      7536  160     C  C03 125.92576       500 1 : Experiment 1 25000 HCMEC D3
      7537  165     C  C03 126.02177       500 1 : Experiment 1 25000 HCMEC D3
      7538  170     C  C03 126.08268       500 1 : Experiment 1 25000 HCMEC D3
      7539  175     C  C03 126.16149       500 1 : Experiment 1 25000 HCMEC D3
      7540  180     C  C03 126.25696       500 1 : Experiment 1 25000 HCMEC D3
      7541  185     C  C03 126.31767       500 1 : Experiment 1 25000 HCMEC D3
      7542  190     C  C03 126.36937       500 1 : Experiment 1 25000 HCMEC D3
      7543  195     C  C03 126.42014       500 1 : Experiment 1 25000 HCMEC D3
      7544  200     C  C03        NA       500 1 : Experiment 1 25000 HCMEC D3
      7545    0     C  C03        NA     64000 1 : Experiment 1 25000 HCMEC D3
      7546    5     C  C03  54.82683     64000 1 : Experiment 1 25000 HCMEC D3
      7547   10     C  C03  50.11125     64000 1 : Experiment 1 25000 HCMEC D3
      7548   15     C  C03  44.81080     64000 1 : Experiment 1 25000 HCMEC D3
      7549   20     C  C03  39.39440     64000 1 : Experiment 1 25000 HCMEC D3
      7550   25     C  C03  35.50932     64000 1 : Experiment 1 25000 HCMEC D3
      7551   30     C  C03  31.73315     64000 1 : Experiment 1 25000 HCMEC D3
      7552   35     C  C03  30.06938     64000 1 : Experiment 1 25000 HCMEC D3
      7553   40     C  C03  27.70662     64000 1 : Experiment 1 25000 HCMEC D3
      7554   45     C  C03  24.43503     64000 1 : Experiment 1 25000 HCMEC D3
      7555   50     C  C03  21.51102     64000 1 : Experiment 1 25000 HCMEC D3
      7556   55     C  C03  18.28022     64000 1 : Experiment 1 25000 HCMEC D3
      7557   60     C  C03  15.09648     64000 1 : Experiment 1 25000 HCMEC D3
      7558   65     C  C03  12.87735     64000 1 : Experiment 1 25000 HCMEC D3
      7559   70     C  C03  11.98691     64000 1 : Experiment 1 25000 HCMEC D3
      7560   75     C  C03  11.09839     64000 1 : Experiment 1 25000 HCMEC D3
      7561   80     C  C03  11.15868     64000 1 : Experiment 1 25000 HCMEC D3
      7562   85     C  C03  11.39164     64000 1 : Experiment 1 25000 HCMEC D3
      7563   90     C  C03  11.64104     64000 1 : Experiment 1 25000 HCMEC D3
      7564   95     C  C03  11.46248     64000 1 : Experiment 1 25000 HCMEC D3
      7565  100     C  C03  11.92647     64000 1 : Experiment 1 25000 HCMEC D3
      7566  105     C  C03  12.09749     64000 1 : Experiment 1 25000 HCMEC D3
      7567  110     C  C03  12.65761     64000 1 : Experiment 1 25000 HCMEC D3
      7568  115     C  C03  12.95530     64000 1 : Experiment 1 25000 HCMEC D3
      7569  120     C  C03  13.53934     64000 1 : Experiment 1 25000 HCMEC D3
      7570  125     C  C03  13.77593     64000 1 : Experiment 1 25000 HCMEC D3
      7571  130     C  C03  14.42179     64000 1 : Experiment 1 25000 HCMEC D3
      7572  135     C  C03  14.89818     64000 1 : Experiment 1 25000 HCMEC D3
      7573  140     C  C03  15.44035     64000 1 : Experiment 1 25000 HCMEC D3
      7574  145     C  C03  15.99780     64000 1 : Experiment 1 25000 HCMEC D3
      7575  150     C  C03  16.79659     64000 1 : Experiment 1 25000 HCMEC D3
      7576  155     C  C03  17.38108     64000 1 : Experiment 1 25000 HCMEC D3
      7577  160     C  C03  17.70196     64000 1 : Experiment 1 25000 HCMEC D3
      7578  165     C  C03  18.62698     64000 1 : Experiment 1 25000 HCMEC D3
      7579  170     C  C03  19.46791     64000 1 : Experiment 1 25000 HCMEC D3
      7580  175     C  C03  20.13406     64000 1 : Experiment 1 25000 HCMEC D3
      7581  180     C  C03  21.01272     64000 1 : Experiment 1 25000 HCMEC D3
      7582  185     C  C03  21.85465     64000 1 : Experiment 1 25000 HCMEC D3
      7583  190     C  C03  22.32523     64000 1 : Experiment 1 25000 HCMEC D3
      7584  195     C  C03  23.16304     64000 1 : Experiment 1 25000 HCMEC D3
      7585  200     C  C03        NA     64000 1 : Experiment 1 25000 HCMEC D3
      7586    0     C  C03        NA      8000 1 : Experiment 1 25000 HCMEC D3
      7587    5     C  C03  95.90551      8000 1 : Experiment 1 25000 HCMEC D3
      7588   10     C  C03  90.49811      8000 1 : Experiment 1 25000 HCMEC D3
      7589   15     C  C03  84.53077      8000 1 : Experiment 1 25000 HCMEC D3
      7590   20     C  C03  78.90271      8000 1 : Experiment 1 25000 HCMEC D3
      7591   25     C  C03  74.87326      8000 1 : Experiment 1 25000 HCMEC D3
      7592   30     C  C03  71.13161      8000 1 : Experiment 1 25000 HCMEC D3
      7593   35     C  C03  69.98760      8000 1 : Experiment 1 25000 HCMEC D3
      7594   40     C  C03  68.19965      8000 1 : Experiment 1 25000 HCMEC D3
      7595   45     C  C03  65.58823      8000 1 : Experiment 1 25000 HCMEC D3
      7596   50     C  C03  64.56805      8000 1 : Experiment 1 25000 HCMEC D3
      7597   55     C  C03  64.28743      8000 1 : Experiment 1 25000 HCMEC D3
      7598   60     C  C03  65.79040      8000 1 : Experiment 1 25000 HCMEC D3
      7599   65     C  C03  67.47560      8000 1 : Experiment 1 25000 HCMEC D3
      7600   70     C  C03  69.01311      8000 1 : Experiment 1 25000 HCMEC D3
      7601   75     C  C03  70.15213      8000 1 : Experiment 1 25000 HCMEC D3
      7602   80     C  C03  71.45497      8000 1 : Experiment 1 25000 HCMEC D3
      7603   85     C  C03  72.69418      8000 1 : Experiment 1 25000 HCMEC D3
      7604   90     C  C03  73.50305      8000 1 : Experiment 1 25000 HCMEC D3
      7605   95     C  C03  73.89404      8000 1 : Experiment 1 25000 HCMEC D3
      7606  100     C  C03  74.88555      8000 1 : Experiment 1 25000 HCMEC D3
      7607  105     C  C03  76.32577      8000 1 : Experiment 1 25000 HCMEC D3
      7608  110     C  C03  77.25259      8000 1 : Experiment 1 25000 HCMEC D3
      7609  115     C  C03  78.52188      8000 1 : Experiment 1 25000 HCMEC D3
      7610  120     C  C03  80.11072      8000 1 : Experiment 1 25000 HCMEC D3
      7611  125     C  C03  80.71591      8000 1 : Experiment 1 25000 HCMEC D3
      7612  130     C  C03  81.97520      8000 1 : Experiment 1 25000 HCMEC D3
      7613  135     C  C03  83.01733      8000 1 : Experiment 1 25000 HCMEC D3
      7614  140     C  C03  83.75745      8000 1 : Experiment 1 25000 HCMEC D3
      7615  145     C  C03  84.71360      8000 1 : Experiment 1 25000 HCMEC D3
      7616  150     C  C03  86.06151      8000 1 : Experiment 1 25000 HCMEC D3
      7617  155     C  C03  87.05103      8000 1 : Experiment 1 25000 HCMEC D3
      7618  160     C  C03  87.98783      8000 1 : Experiment 1 25000 HCMEC D3
      7619  165     C  C03  89.29092      8000 1 : Experiment 1 25000 HCMEC D3
      7620  170     C  C03  90.17353      8000 1 : Experiment 1 25000 HCMEC D3
      7621  175     C  C03  90.99616      8000 1 : Experiment 1 25000 HCMEC D3
      7622  180     C  C03  92.41210      8000 1 : Experiment 1 25000 HCMEC D3
      7623  185     C  C03  93.16908      8000 1 : Experiment 1 25000 HCMEC D3
      7624  190     C  C03  93.83854      8000 1 : Experiment 1 25000 HCMEC D3
      7625  195     C  C03  94.36490      8000 1 : Experiment 1 25000 HCMEC D3
      7626  200     C  C03        NA      8000 1 : Experiment 1 25000 HCMEC D3
      7627    0     C  D01        NA      1000 1 : Experiment 1 20000 HCMEC D3
      7628    5     C  D01 118.27255      1000 1 : Experiment 1 20000 HCMEC D3
      7629   10     C  D01 118.01159      1000 1 : Experiment 1 20000 HCMEC D3
      7630   15     C  D01 117.02219      1000 1 : Experiment 1 20000 HCMEC D3
      7631   20     C  D01 115.98055      1000 1 : Experiment 1 20000 HCMEC D3
      7632   25     C  D01 115.16296      1000 1 : Experiment 1 20000 HCMEC D3
      7633   30     C  D01 114.69472      1000 1 : Experiment 1 20000 HCMEC D3
      7634   35     C  D01 114.86024      1000 1 : Experiment 1 20000 HCMEC D3
      7635   40     C  D01 114.68446      1000 1 : Experiment 1 20000 HCMEC D3
      7636   45     C  D01 114.62359      1000 1 : Experiment 1 20000 HCMEC D3
      7637   50     C  D01 115.01686      1000 1 : Experiment 1 20000 HCMEC D3
      7638   55     C  D01 115.16074      1000 1 : Experiment 1 20000 HCMEC D3
      7639   60     C  D01 115.95150      1000 1 : Experiment 1 20000 HCMEC D3
      7640   65     C  D01 116.67318      1000 1 : Experiment 1 20000 HCMEC D3
      7641   70     C  D01 117.30312      1000 1 : Experiment 1 20000 HCMEC D3
      7642   75     C  D01 117.95657      1000 1 : Experiment 1 20000 HCMEC D3
      7643   80     C  D01 118.52551      1000 1 : Experiment 1 20000 HCMEC D3
      7644   85     C  D01 119.21537      1000 1 : Experiment 1 20000 HCMEC D3
      7645   90     C  D01 119.65669      1000 1 : Experiment 1 20000 HCMEC D3
      7646   95     C  D01 120.27016      1000 1 : Experiment 1 20000 HCMEC D3
      7647  100     C  D01 120.44685      1000 1 : Experiment 1 20000 HCMEC D3
      7648  105     C  D01 120.57124      1000 1 : Experiment 1 20000 HCMEC D3
      7649  110     C  D01 120.72878      1000 1 : Experiment 1 20000 HCMEC D3
      7650  115     C  D01 120.91065      1000 1 : Experiment 1 20000 HCMEC D3
      7651  120     C  D01 121.19094      1000 1 : Experiment 1 20000 HCMEC D3
      7652  125     C  D01 121.61544      1000 1 : Experiment 1 20000 HCMEC D3
      7653  130     C  D01 121.90686      1000 1 : Experiment 1 20000 HCMEC D3
      7654  135     C  D01 122.24843      1000 1 : Experiment 1 20000 HCMEC D3
      7655  140     C  D01 122.24323      1000 1 : Experiment 1 20000 HCMEC D3
      7656  145     C  D01 122.36406      1000 1 : Experiment 1 20000 HCMEC D3
      7657  150     C  D01 122.69192      1000 1 : Experiment 1 20000 HCMEC D3
      7658  155     C  D01 122.97343      1000 1 : Experiment 1 20000 HCMEC D3
      7659  160     C  D01 123.14876      1000 1 : Experiment 1 20000 HCMEC D3
      7660  165     C  D01 123.29953      1000 1 : Experiment 1 20000 HCMEC D3
      7661  170     C  D01 118.70181      1000 1 : Experiment 1 20000 HCMEC D3
      7662  175     C  D01 119.22247      1000 1 : Experiment 1 20000 HCMEC D3
      7663  180     C  D01 119.80090      1000 1 : Experiment 1 20000 HCMEC D3
      7664  185     C  D01 120.03479      1000 1 : Experiment 1 20000 HCMEC D3
      7665  190     C  D01 120.84305      1000 1 : Experiment 1 20000 HCMEC D3
      7666  195     C  D01 121.30488      1000 1 : Experiment 1 20000 HCMEC D3
      7667  200     C  D01        NA      1000 1 : Experiment 1 20000 HCMEC D3
      7668    0     C  D01        NA     16000 1 : Experiment 1 20000 HCMEC D3
      7669    5     C  D01  90.84631     16000 1 : Experiment 1 20000 HCMEC D3
      7670   10     C  D01  85.72800     16000 1 : Experiment 1 20000 HCMEC D3
      7671   15     C  D01  79.18104     16000 1 : Experiment 1 20000 HCMEC D3
      7672   20     C  D01  72.59819     16000 1 : Experiment 1 20000 HCMEC D3
      7673   25     C  D01  67.37450     16000 1 : Experiment 1 20000 HCMEC D3
      7674   30     C  D01  63.42144     16000 1 : Experiment 1 20000 HCMEC D3
      7675   35     C  D01  60.60111     16000 1 : Experiment 1 20000 HCMEC D3
      7676   40     C  D01  57.01521     16000 1 : Experiment 1 20000 HCMEC D3
      7677   45     C  D01  53.45007     16000 1 : Experiment 1 20000 HCMEC D3
      7678   50     C  D01  50.68010     16000 1 : Experiment 1 20000 HCMEC D3
      7679   55     C  D01  46.59964     16000 1 : Experiment 1 20000 HCMEC D3
      7680   60     C  D01  43.44071     16000 1 : Experiment 1 20000 HCMEC D3
      7681   65     C  D01  41.48963     16000 1 : Experiment 1 20000 HCMEC D3
      7682   70     C  D01  41.06432     16000 1 : Experiment 1 20000 HCMEC D3
      7683   75     C  D01  41.21612     16000 1 : Experiment 1 20000 HCMEC D3
      7684   80     C  D01  41.62799     16000 1 : Experiment 1 20000 HCMEC D3
      7685   85     C  D01  42.06384     16000 1 : Experiment 1 20000 HCMEC D3
      7686   90     C  D01  42.63176     16000 1 : Experiment 1 20000 HCMEC D3
      7687   95     C  D01  43.57562     16000 1 : Experiment 1 20000 HCMEC D3
      7688  100     C  D01  44.00825     16000 1 : Experiment 1 20000 HCMEC D3
      7689  105     C  D01  45.02363     16000 1 : Experiment 1 20000 HCMEC D3
      7690  110     C  D01  46.18240     16000 1 : Experiment 1 20000 HCMEC D3
      7691  115     C  D01  47.74347     16000 1 : Experiment 1 20000 HCMEC D3
      7692  120     C  D01  49.14092     16000 1 : Experiment 1 20000 HCMEC D3
           Instrument SampleID Excluded                         Sample
      1          ECIS        1       no 35,00Cell Free + HCMEC D3_line
      2          ECIS        1       no 35,00Cell Free + HCMEC D3_line
      3          ECIS        1       no 35,00Cell Free + HCMEC D3_line
      4          ECIS        2       no 30,00Cell Free + HCMEC D3_line
      5          ECIS        2       no 30,00Cell Free + HCMEC D3_line
      6          ECIS        2       no 30,00Cell Free + HCMEC D3_line
      7          ECIS        3       no 25,00Cell Free + HCMEC D3_line
      8          ECIS        3       no 25,00Cell Free + HCMEC D3_line
      9          ECIS        3       no 25,00Cell Free + HCMEC D3_line
      10         ECIS        4       no 20,00Cell Free + HCMEC D3_line
      11         ECIS        4       no 20,00Cell Free + HCMEC D3_line
      12         ECIS        4       no 20,00Cell Free + HCMEC D3_line
      13         ECIS        5       no 15,00Cell Free + HCMEC D3_line
      14         ECIS        5       no 15,00Cell Free + HCMEC D3_line
      15         ECIS        5       no 15,00Cell Free + HCMEC D3_line
      16         ECIS        6       no 10,00Cell Free + HCMEC D3_line
      17         ECIS        6       no 10,00Cell Free + HCMEC D3_line
      18         ECIS        6       no 10,00Cell Free + HCMEC D3_line
      19         ECIS        7       no  5,00Cell Free + HCMEC D3_line
      20         ECIS        7       no  5,00Cell Free + HCMEC D3_line
      21         ECIS        7       no  5,00Cell Free + HCMEC D3_line
      22         ECIS        1       no 35,00Cell Free + HCMEC D3_line
      23         ECIS        1       no 35,00Cell Free + HCMEC D3_line
      24         ECIS        1       no 35,00Cell Free + HCMEC D3_line
      25         ECIS        2       no 30,00Cell Free + HCMEC D3_line
      26         ECIS        2       no 30,00Cell Free + HCMEC D3_line
      27         ECIS        2       no 30,00Cell Free + HCMEC D3_line
      28         ECIS        3       no 25,00Cell Free + HCMEC D3_line
      29         ECIS        3       no 25,00Cell Free + HCMEC D3_line
      30         ECIS        3       no 25,00Cell Free + HCMEC D3_line
      31         ECIS        4       no 20,00Cell Free + HCMEC D3_line
      32         ECIS        4       no 20,00Cell Free + HCMEC D3_line
      33         ECIS        4       no 20,00Cell Free + HCMEC D3_line
      34         ECIS        5       no 15,00Cell Free + HCMEC D3_line
      35         ECIS        5       no 15,00Cell Free + HCMEC D3_line
      36         ECIS        5       no 15,00Cell Free + HCMEC D3_line
      37         ECIS        6       no 10,00Cell Free + HCMEC D3_line
      38         ECIS        6       no 10,00Cell Free + HCMEC D3_line
      39         ECIS        6       no 10,00Cell Free + HCMEC D3_line
      40         ECIS        7       no  5,00Cell Free + HCMEC D3_line
      41         ECIS        7       no  5,00Cell Free + HCMEC D3_line
      42         ECIS        7       no  5,00Cell Free + HCMEC D3_line
      43         ECIS        1       no 35,00Cell Free + HCMEC D3_line
      44         ECIS        1       no 35,00Cell Free + HCMEC D3_line
      45         ECIS        1       no 35,00Cell Free + HCMEC D3_line
      46         ECIS        2       no 30,00Cell Free + HCMEC D3_line
      47         ECIS        2       no 30,00Cell Free + HCMEC D3_line
      48         ECIS        2       no 30,00Cell Free + HCMEC D3_line
      49         ECIS        3       no 25,00Cell Free + HCMEC D3_line
      50         ECIS        3       no 25,00Cell Free + HCMEC D3_line
      51         ECIS        3       no 25,00Cell Free + HCMEC D3_line
      52         ECIS        4       no 20,00Cell Free + HCMEC D3_line
      53         ECIS        4       no 20,00Cell Free + HCMEC D3_line
      54         ECIS        4       no 20,00Cell Free + HCMEC D3_line
      55         ECIS        5       no 15,00Cell Free + HCMEC D3_line
      56         ECIS        5       no 15,00Cell Free + HCMEC D3_line
      57         ECIS        5       no 15,00Cell Free + HCMEC D3_line
      58         ECIS        6       no 10,00Cell Free + HCMEC D3_line
      59         ECIS        6       no 10,00Cell Free + HCMEC D3_line
      60         ECIS        6       no 10,00Cell Free + HCMEC D3_line
      61         ECIS        7       no  5,00Cell Free + HCMEC D3_line
      62         ECIS        7       no  5,00Cell Free + HCMEC D3_line
      63         ECIS        7       no  5,00Cell Free + HCMEC D3_line
      64         ECIS        1       no 35,00Cell Free + HCMEC D3_line
      65         ECIS        1       no 35,00Cell Free + HCMEC D3_line
      66         ECIS        1       no 35,00Cell Free + HCMEC D3_line
      67         ECIS        2       no 30,00Cell Free + HCMEC D3_line
      68         ECIS        2       no 30,00Cell Free + HCMEC D3_line
      69         ECIS        2       no 30,00Cell Free + HCMEC D3_line
      70         ECIS        3       no 25,00Cell Free + HCMEC D3_line
      71         ECIS        3       no 25,00Cell Free + HCMEC D3_line
      72         ECIS        3       no 25,00Cell Free + HCMEC D3_line
      73         ECIS        4       no 20,00Cell Free + HCMEC D3_line
      74         ECIS        4       no 20,00Cell Free + HCMEC D3_line
      75         ECIS        4       no 20,00Cell Free + HCMEC D3_line
      76         ECIS        5       no 15,00Cell Free + HCMEC D3_line
      77         ECIS        5       no 15,00Cell Free + HCMEC D3_line
      78         ECIS        5       no 15,00Cell Free + HCMEC D3_line
      79         ECIS        6       no 10,00Cell Free + HCMEC D3_line
      80         ECIS        6       no 10,00Cell Free + HCMEC D3_line
      81         ECIS        6       no 10,00Cell Free + HCMEC D3_line
      82         ECIS        7       no  5,00Cell Free + HCMEC D3_line
      83         ECIS        7       no  5,00Cell Free + HCMEC D3_line
      84         ECIS        7       no  5,00Cell Free + HCMEC D3_line
      85         ECIS        1       no 35,00Cell Free + HCMEC D3_line
      86         ECIS        1       no 35,00Cell Free + HCMEC D3_line
      87         ECIS        1       no 35,00Cell Free + HCMEC D3_line
      88         ECIS        2       no 30,00Cell Free + HCMEC D3_line
      89         ECIS        2       no 30,00Cell Free + HCMEC D3_line
      90         ECIS        2       no 30,00Cell Free + HCMEC D3_line
      91         ECIS        3       no 25,00Cell Free + HCMEC D3_line
      92         ECIS        3       no 25,00Cell Free + HCMEC D3_line
      93         ECIS        3       no 25,00Cell Free + HCMEC D3_line
      94         ECIS        4       no 20,00Cell Free + HCMEC D3_line
      95         ECIS        4       no 20,00Cell Free + HCMEC D3_line
      96         ECIS        4       no 20,00Cell Free + HCMEC D3_line
      97         ECIS        5       no 15,00Cell Free + HCMEC D3_line
      98         ECIS        5       no 15,00Cell Free + HCMEC D3_line
      99         ECIS        5       no 15,00Cell Free + HCMEC D3_line
      100        ECIS        6       no 10,00Cell Free + HCMEC D3_line
      101        ECIS        6       no 10,00Cell Free + HCMEC D3_line
      102        ECIS        6       no 10,00Cell Free + HCMEC D3_line
      103        ECIS        7       no  5,00Cell Free + HCMEC D3_line
      104        ECIS        7       no  5,00Cell Free + HCMEC D3_line
      105        ECIS        7       no  5,00Cell Free + HCMEC D3_line
      106        ECIS        1       no 35,00Cell Free + HCMEC D3_line
      107        ECIS        1       no 35,00Cell Free + HCMEC D3_line
      108        ECIS        1       no 35,00Cell Free + HCMEC D3_line
      109        ECIS        2       no 30,00Cell Free + HCMEC D3_line
      110        ECIS        2       no 30,00Cell Free + HCMEC D3_line
      111        ECIS        2       no 30,00Cell Free + HCMEC D3_line
      112        ECIS        3       no 25,00Cell Free + HCMEC D3_line
      113        ECIS        3       no 25,00Cell Free + HCMEC D3_line
      114        ECIS        3       no 25,00Cell Free + HCMEC D3_line
      115        ECIS        4       no 20,00Cell Free + HCMEC D3_line
      116        ECIS        4       no 20,00Cell Free + HCMEC D3_line
      117        ECIS        4       no 20,00Cell Free + HCMEC D3_line
      118        ECIS        5       no 15,00Cell Free + HCMEC D3_line
      119        ECIS        5       no 15,00Cell Free + HCMEC D3_line
      120        ECIS        5       no 15,00Cell Free + HCMEC D3_line
      121        ECIS        6       no 10,00Cell Free + HCMEC D3_line
      122        ECIS        6       no 10,00Cell Free + HCMEC D3_line
      123        ECIS        6       no 10,00Cell Free + HCMEC D3_line
      124        ECIS        7       no  5,00Cell Free + HCMEC D3_line
      125        ECIS        7       no  5,00Cell Free + HCMEC D3_line
      126        ECIS        7       no  5,00Cell Free + HCMEC D3_line
      127        ECIS        1       no 35,00Cell Free + HCMEC D3_line
      128        ECIS        1       no 35,00Cell Free + HCMEC D3_line
      129        ECIS        1       no 35,00Cell Free + HCMEC D3_line
      130        ECIS        2       no 30,00Cell Free + HCMEC D3_line
      131        ECIS        2       no 30,00Cell Free + HCMEC D3_line
      132        ECIS        2       no 30,00Cell Free + HCMEC D3_line
      133        ECIS        3       no 25,00Cell Free + HCMEC D3_line
      134        ECIS        3       no 25,00Cell Free + HCMEC D3_line
      135        ECIS        3       no 25,00Cell Free + HCMEC D3_line
      136        ECIS        4       no 20,00Cell Free + HCMEC D3_line
      137        ECIS        4       no 20,00Cell Free + HCMEC D3_line
      138        ECIS        4       no 20,00Cell Free + HCMEC D3_line
      139        ECIS        5       no 15,00Cell Free + HCMEC D3_line
      140        ECIS        5       no 15,00Cell Free + HCMEC D3_line
      141        ECIS        5       no 15,00Cell Free + HCMEC D3_line
      142        ECIS        6       no 10,00Cell Free + HCMEC D3_line
      143        ECIS        6       no 10,00Cell Free + HCMEC D3_line
      144        ECIS        6       no 10,00Cell Free + HCMEC D3_line
      145        ECIS        7       no  5,00Cell Free + HCMEC D3_line
      146        ECIS        7       no  5,00Cell Free + HCMEC D3_line
      147        ECIS        7       no  5,00Cell Free + HCMEC D3_line
      148        ECIS        1       no 35,00Cell Free + HCMEC D3_line
      149        ECIS        1       no 35,00Cell Free + HCMEC D3_line
      150        ECIS        1       no 35,00Cell Free + HCMEC D3_line
      151        ECIS        2       no 30,00Cell Free + HCMEC D3_line
      152        ECIS        2       no 30,00Cell Free + HCMEC D3_line
      153        ECIS        2       no 30,00Cell Free + HCMEC D3_line
      154        ECIS        3       no 25,00Cell Free + HCMEC D3_line
      155        ECIS        3       no 25,00Cell Free + HCMEC D3_line
      156        ECIS        3       no 25,00Cell Free + HCMEC D3_line
      157        ECIS        4       no 20,00Cell Free + HCMEC D3_line
      158        ECIS        4       no 20,00Cell Free + HCMEC D3_line
      159        ECIS        4       no 20,00Cell Free + HCMEC D3_line
      160        ECIS        5       no 15,00Cell Free + HCMEC D3_line
      161        ECIS        5       no 15,00Cell Free + HCMEC D3_line
      162        ECIS        5       no 15,00Cell Free + HCMEC D3_line
      163        ECIS        6       no 10,00Cell Free + HCMEC D3_line
      164        ECIS        6       no 10,00Cell Free + HCMEC D3_line
      165        ECIS        6       no 10,00Cell Free + HCMEC D3_line
      166        ECIS        7       no  5,00Cell Free + HCMEC D3_line
      167        ECIS        7       no  5,00Cell Free + HCMEC D3_line
      168        ECIS        7       no  5,00Cell Free + HCMEC D3_line
      169        ECIS        1       no 35,00Cell Free + HCMEC D3_line
      170        ECIS        1       no 35,00Cell Free + HCMEC D3_line
      171        ECIS        1       no 35,00Cell Free + HCMEC D3_line
      172        ECIS        2       no 30,00Cell Free + HCMEC D3_line
      173        ECIS        2       no 30,00Cell Free + HCMEC D3_line
      174        ECIS        2       no 30,00Cell Free + HCMEC D3_line
      175        ECIS        3       no 25,00Cell Free + HCMEC D3_line
      176        ECIS        3       no 25,00Cell Free + HCMEC D3_line
      177        ECIS        3       no 25,00Cell Free + HCMEC D3_line
      178        ECIS        4       no 20,00Cell Free + HCMEC D3_line
      179        ECIS        4       no 20,00Cell Free + HCMEC D3_line
      180        ECIS        4       no 20,00Cell Free + HCMEC D3_line
      181        ECIS        5       no 15,00Cell Free + HCMEC D3_line
      182        ECIS        5       no 15,00Cell Free + HCMEC D3_line
      183        ECIS        5       no 15,00Cell Free + HCMEC D3_line
      184        ECIS        6       no 10,00Cell Free + HCMEC D3_line
      185        ECIS        6       no 10,00Cell Free + HCMEC D3_line
      186        ECIS        6       no 10,00Cell Free + HCMEC D3_line
      187        ECIS        7       no  5,00Cell Free + HCMEC D3_line
      188        ECIS        7       no  5,00Cell Free + HCMEC D3_line
      189        ECIS        7       no  5,00Cell Free + HCMEC D3_line
      190        ECIS        1       no 35,00Cell Free + HCMEC D3_line
      191        ECIS        1       no 35,00Cell Free + HCMEC D3_line
      192        ECIS        1       no 35,00Cell Free + HCMEC D3_line
      193        ECIS        2       no 30,00Cell Free + HCMEC D3_line
      194        ECIS        2       no 30,00Cell Free + HCMEC D3_line
      195        ECIS        2       no 30,00Cell Free + HCMEC D3_line
      196        ECIS        3       no 25,00Cell Free + HCMEC D3_line
      197        ECIS        3       no 25,00Cell Free + HCMEC D3_line
      198        ECIS        3       no 25,00Cell Free + HCMEC D3_line
      199        ECIS        4       no 20,00Cell Free + HCMEC D3_line
      200        ECIS        4       no 20,00Cell Free + HCMEC D3_line
      201        ECIS        4       no 20,00Cell Free + HCMEC D3_line
      202        ECIS        5       no 15,00Cell Free + HCMEC D3_line
      203        ECIS        5       no 15,00Cell Free + HCMEC D3_line
      204        ECIS        5       no 15,00Cell Free + HCMEC D3_line
      205        ECIS        6       no 10,00Cell Free + HCMEC D3_line
      206        ECIS        6       no 10,00Cell Free + HCMEC D3_line
      207        ECIS        6       no 10,00Cell Free + HCMEC D3_line
      208        ECIS        7       no  5,00Cell Free + HCMEC D3_line
      209        ECIS        7       no  5,00Cell Free + HCMEC D3_line
      210        ECIS        7       no  5,00Cell Free + HCMEC D3_line
      211        ECIS        1       no 35,00Cell Free + HCMEC D3_line
      212        ECIS        1       no 35,00Cell Free + HCMEC D3_line
      213        ECIS        1       no 35,00Cell Free + HCMEC D3_line
      214        ECIS        2       no 30,00Cell Free + HCMEC D3_line
      215        ECIS        2       no 30,00Cell Free + HCMEC D3_line
      216        ECIS        2       no 30,00Cell Free + HCMEC D3_line
      217        ECIS        3       no 25,00Cell Free + HCMEC D3_line
      218        ECIS        3       no 25,00Cell Free + HCMEC D3_line
      219        ECIS        3       no 25,00Cell Free + HCMEC D3_line
      220        ECIS        4       no 20,00Cell Free + HCMEC D3_line
      221        ECIS        4       no 20,00Cell Free + HCMEC D3_line
      222        ECIS        4       no 20,00Cell Free + HCMEC D3_line
      223        ECIS        5       no 15,00Cell Free + HCMEC D3_line
      224        ECIS        5       no 15,00Cell Free + HCMEC D3_line
      225        ECIS        5       no 15,00Cell Free + HCMEC D3_line
      226        ECIS        6       no 10,00Cell Free + HCMEC D3_line
      227        ECIS        6       no 10,00Cell Free + HCMEC D3_line
      228        ECIS        6       no 10,00Cell Free + HCMEC D3_line
      229        ECIS        7       no  5,00Cell Free + HCMEC D3_line
      230        ECIS        7       no  5,00Cell Free + HCMEC D3_line
      231        ECIS        7       no  5,00Cell Free + HCMEC D3_line
      232        ECIS        1       no 35,00Cell Free + HCMEC D3_line
      233        ECIS        1       no 35,00Cell Free + HCMEC D3_line
      234        ECIS        1       no 35,00Cell Free + HCMEC D3_line
      235        ECIS        2       no 30,00Cell Free + HCMEC D3_line
      236        ECIS        2       no 30,00Cell Free + HCMEC D3_line
      237        ECIS        2       no 30,00Cell Free + HCMEC D3_line
      238        ECIS        3       no 25,00Cell Free + HCMEC D3_line
      239        ECIS        3       no 25,00Cell Free + HCMEC D3_line
      240        ECIS        3       no 25,00Cell Free + HCMEC D3_line
      241        ECIS        4       no 20,00Cell Free + HCMEC D3_line
      242        ECIS        4       no 20,00Cell Free + HCMEC D3_line
      243        ECIS        4       no 20,00Cell Free + HCMEC D3_line
      244        ECIS        5       no 15,00Cell Free + HCMEC D3_line
      245        ECIS        5       no 15,00Cell Free + HCMEC D3_line
      246        ECIS        5       no 15,00Cell Free + HCMEC D3_line
      247        ECIS        6       no 10,00Cell Free + HCMEC D3_line
      248        ECIS        6       no 10,00Cell Free + HCMEC D3_line
      249        ECIS        6       no 10,00Cell Free + HCMEC D3_line
      250        ECIS        7       no  5,00Cell Free + HCMEC D3_line
      251        ECIS        7       no  5,00Cell Free + HCMEC D3_line
      252        ECIS        7       no  5,00Cell Free + HCMEC D3_line
      253        ECIS        1       no 35,00Cell Free + HCMEC D3_line
      254        ECIS        1       no 35,00Cell Free + HCMEC D3_line
      255        ECIS        1       no 35,00Cell Free + HCMEC D3_line
      256        ECIS        2       no 30,00Cell Free + HCMEC D3_line
      257        ECIS        2       no 30,00Cell Free + HCMEC D3_line
      258        ECIS        2       no 30,00Cell Free + HCMEC D3_line
      259        ECIS        3       no 25,00Cell Free + HCMEC D3_line
      260        ECIS        3       no 25,00Cell Free + HCMEC D3_line
      261        ECIS        3       no 25,00Cell Free + HCMEC D3_line
      262        ECIS        4       no 20,00Cell Free + HCMEC D3_line
      263        ECIS        4       no 20,00Cell Free + HCMEC D3_line
      264        ECIS        4       no 20,00Cell Free + HCMEC D3_line
      265        ECIS        5       no 15,00Cell Free + HCMEC D3_line
      266        ECIS        5       no 15,00Cell Free + HCMEC D3_line
      267        ECIS        5       no 15,00Cell Free + HCMEC D3_line
      268        ECIS        6       no 10,00Cell Free + HCMEC D3_line
      269        ECIS        6       no 10,00Cell Free + HCMEC D3_line
      270        ECIS        6       no 10,00Cell Free + HCMEC D3_line
      271        ECIS        7       no  5,00Cell Free + HCMEC D3_line
      272        ECIS        7       no  5,00Cell Free + HCMEC D3_line
      273        ECIS        7       no  5,00Cell Free + HCMEC D3_line
      274        ECIS        1       no 35,00Cell Free + HCMEC D3_line
      275        ECIS        1       no 35,00Cell Free + HCMEC D3_line
      276        ECIS        1       no 35,00Cell Free + HCMEC D3_line
      277        ECIS        2       no 30,00Cell Free + HCMEC D3_line
      278        ECIS        2       no 30,00Cell Free + HCMEC D3_line
      279        ECIS        2       no 30,00Cell Free + HCMEC D3_line
      280        ECIS        3       no 25,00Cell Free + HCMEC D3_line
      281        ECIS        3       no 25,00Cell Free + HCMEC D3_line
      282        ECIS        3       no 25,00Cell Free + HCMEC D3_line
      283        ECIS        4       no 20,00Cell Free + HCMEC D3_line
      284        ECIS        4       no 20,00Cell Free + HCMEC D3_line
      285        ECIS        4       no 20,00Cell Free + HCMEC D3_line
      286        ECIS        5       no 15,00Cell Free + HCMEC D3_line
      287        ECIS        5       no 15,00Cell Free + HCMEC D3_line
      288        ECIS        5       no 15,00Cell Free + HCMEC D3_line
      289        ECIS        6       no 10,00Cell Free + HCMEC D3_line
      290        ECIS        6       no 10,00Cell Free + HCMEC D3_line
      291        ECIS        6       no 10,00Cell Free + HCMEC D3_line
      292        ECIS        7       no  5,00Cell Free + HCMEC D3_line
      293        ECIS        7       no  5,00Cell Free + HCMEC D3_line
      294        ECIS        7       no  5,00Cell Free + HCMEC D3_line
      295        ECIS        1       no 35,00Cell Free + HCMEC D3_line
      296        ECIS        1       no 35,00Cell Free + HCMEC D3_line
      297        ECIS        1       no 35,00Cell Free + HCMEC D3_line
      298        ECIS        2       no 30,00Cell Free + HCMEC D3_line
      299        ECIS        2       no 30,00Cell Free + HCMEC D3_line
      300        ECIS        2       no 30,00Cell Free + HCMEC D3_line
      301        ECIS        3       no 25,00Cell Free + HCMEC D3_line
      302        ECIS        3       no 25,00Cell Free + HCMEC D3_line
      303        ECIS        3       no 25,00Cell Free + HCMEC D3_line
      304        ECIS        4       no 20,00Cell Free + HCMEC D3_line
      305        ECIS        4       no 20,00Cell Free + HCMEC D3_line
      306        ECIS        4       no 20,00Cell Free + HCMEC D3_line
      307        ECIS        5       no 15,00Cell Free + HCMEC D3_line
      308        ECIS        5       no 15,00Cell Free + HCMEC D3_line
      309        ECIS        5       no 15,00Cell Free + HCMEC D3_line
      310        ECIS        6       no 10,00Cell Free + HCMEC D3_line
      311        ECIS        6       no 10,00Cell Free + HCMEC D3_line
      312        ECIS        6       no 10,00Cell Free + HCMEC D3_line
      313        ECIS        7       no  5,00Cell Free + HCMEC D3_line
      314        ECIS        7       no  5,00Cell Free + HCMEC D3_line
      315        ECIS        7       no  5,00Cell Free + HCMEC D3_line
      316        ECIS        1       no 35,00Cell Free + HCMEC D3_line
      317        ECIS        1       no 35,00Cell Free + HCMEC D3_line
      318        ECIS        1       no 35,00Cell Free + HCMEC D3_line
      319        ECIS        2       no 30,00Cell Free + HCMEC D3_line
      320        ECIS        2       no 30,00Cell Free + HCMEC D3_line
      321        ECIS        2       no 30,00Cell Free + HCMEC D3_line
      322        ECIS        3       no 25,00Cell Free + HCMEC D3_line
      323        ECIS        3       no 25,00Cell Free + HCMEC D3_line
      324        ECIS        3       no 25,00Cell Free + HCMEC D3_line
      325        ECIS        4       no 20,00Cell Free + HCMEC D3_line
      326        ECIS        4       no 20,00Cell Free + HCMEC D3_line
      327        ECIS        4       no 20,00Cell Free + HCMEC D3_line
      328        ECIS        5       no 15,00Cell Free + HCMEC D3_line
      329        ECIS        5       no 15,00Cell Free + HCMEC D3_line
      330        ECIS        5       no 15,00Cell Free + HCMEC D3_line
      331        ECIS        6       no 10,00Cell Free + HCMEC D3_line
      332        ECIS        6       no 10,00Cell Free + HCMEC D3_line
      333        ECIS        6       no 10,00Cell Free + HCMEC D3_line
      334        ECIS        7       no  5,00Cell Free + HCMEC D3_line
      335        ECIS        7       no  5,00Cell Free + HCMEC D3_line
      336        ECIS        7       no  5,00Cell Free + HCMEC D3_line
      337        ECIS        1       no 35,00Cell Free + HCMEC D3_line
      338        ECIS        1       no 35,00Cell Free + HCMEC D3_line
      339        ECIS        1       no 35,00Cell Free + HCMEC D3_line
      340        ECIS        2       no 30,00Cell Free + HCMEC D3_line
      341        ECIS        2       no 30,00Cell Free + HCMEC D3_line
      342        ECIS        2       no 30,00Cell Free + HCMEC D3_line
      343        ECIS        3       no 25,00Cell Free + HCMEC D3_line
      344        ECIS        3       no 25,00Cell Free + HCMEC D3_line
      345        ECIS        3       no 25,00Cell Free + HCMEC D3_line
      346        ECIS        4       no 20,00Cell Free + HCMEC D3_line
      347        ECIS        4       no 20,00Cell Free + HCMEC D3_line
      348        ECIS        4       no 20,00Cell Free + HCMEC D3_line
      349        ECIS        5       no 15,00Cell Free + HCMEC D3_line
      350        ECIS        5       no 15,00Cell Free + HCMEC D3_line
      351        ECIS        5       no 15,00Cell Free + HCMEC D3_line
      352        ECIS        6       no 10,00Cell Free + HCMEC D3_line
      353        ECIS        6       no 10,00Cell Free + HCMEC D3_line
      354        ECIS        6       no 10,00Cell Free + HCMEC D3_line
      355        ECIS        7       no  5,00Cell Free + HCMEC D3_line
      356        ECIS        7       no  5,00Cell Free + HCMEC D3_line
      357        ECIS        7       no  5,00Cell Free + HCMEC D3_line
      358        ECIS        1       no 35,00Cell Free + HCMEC D3_line
      359        ECIS        1       no 35,00Cell Free + HCMEC D3_line
      360        ECIS        1       no 35,00Cell Free + HCMEC D3_line
      361        ECIS        2       no 30,00Cell Free + HCMEC D3_line
      362        ECIS        2       no 30,00Cell Free + HCMEC D3_line
      363        ECIS        2       no 30,00Cell Free + HCMEC D3_line
      364        ECIS        3       no 25,00Cell Free + HCMEC D3_line
      365        ECIS        3       no 25,00Cell Free + HCMEC D3_line
      366        ECIS        3       no 25,00Cell Free + HCMEC D3_line
      367        ECIS        4       no 20,00Cell Free + HCMEC D3_line
      368        ECIS        4       no 20,00Cell Free + HCMEC D3_line
      369        ECIS        4       no 20,00Cell Free + HCMEC D3_line
      370        ECIS        5       no 15,00Cell Free + HCMEC D3_line
      371        ECIS        5       no 15,00Cell Free + HCMEC D3_line
      372        ECIS        5       no 15,00Cell Free + HCMEC D3_line
      373        ECIS        6       no 10,00Cell Free + HCMEC D3_line
      374        ECIS        6       no 10,00Cell Free + HCMEC D3_line
      375        ECIS        6       no 10,00Cell Free + HCMEC D3_line
      376        ECIS        7       no  5,00Cell Free + HCMEC D3_line
      377        ECIS        7       no  5,00Cell Free + HCMEC D3_line
      378        ECIS        7       no  5,00Cell Free + HCMEC D3_line
      379        ECIS        1       no 35,00Cell Free + HCMEC D3_line
      380        ECIS        1       no 35,00Cell Free + HCMEC D3_line
      381        ECIS        1       no 35,00Cell Free + HCMEC D3_line
      382        ECIS        2       no 30,00Cell Free + HCMEC D3_line
      383        ECIS        2       no 30,00Cell Free + HCMEC D3_line
      384        ECIS        2       no 30,00Cell Free + HCMEC D3_line
      385        ECIS        3       no 25,00Cell Free + HCMEC D3_line
      386        ECIS        3       no 25,00Cell Free + HCMEC D3_line
      387        ECIS        3       no 25,00Cell Free + HCMEC D3_line
      388        ECIS        4       no 20,00Cell Free + HCMEC D3_line
      389        ECIS        4       no 20,00Cell Free + HCMEC D3_line
      390        ECIS        4       no 20,00Cell Free + HCMEC D3_line
      391        ECIS        5       no 15,00Cell Free + HCMEC D3_line
      392        ECIS        5       no 15,00Cell Free + HCMEC D3_line
      393        ECIS        5       no 15,00Cell Free + HCMEC D3_line
      394        ECIS        6       no 10,00Cell Free + HCMEC D3_line
      395        ECIS        6       no 10,00Cell Free + HCMEC D3_line
      396        ECIS        6       no 10,00Cell Free + HCMEC D3_line
      397        ECIS        7       no  5,00Cell Free + HCMEC D3_line
      398        ECIS        7       no  5,00Cell Free + HCMEC D3_line
      399        ECIS        7       no  5,00Cell Free + HCMEC D3_line
      400        ECIS        1       no 35,00Cell Free + HCMEC D3_line
      401        ECIS        1       no 35,00Cell Free + HCMEC D3_line
      402        ECIS        1       no 35,00Cell Free + HCMEC D3_line
      403        ECIS        2       no 30,00Cell Free + HCMEC D3_line
      404        ECIS        2       no 30,00Cell Free + HCMEC D3_line
      405        ECIS        2       no 30,00Cell Free + HCMEC D3_line
      406        ECIS        3       no 25,00Cell Free + HCMEC D3_line
      407        ECIS        3       no 25,00Cell Free + HCMEC D3_line
      408        ECIS        3       no 25,00Cell Free + HCMEC D3_line
      409        ECIS        4       no 20,00Cell Free + HCMEC D3_line
      410        ECIS        4       no 20,00Cell Free + HCMEC D3_line
      411        ECIS        4       no 20,00Cell Free + HCMEC D3_line
      412        ECIS        5       no 15,00Cell Free + HCMEC D3_line
      413        ECIS        5       no 15,00Cell Free + HCMEC D3_line
      414        ECIS        5       no 15,00Cell Free + HCMEC D3_line
      415        ECIS        6       no 10,00Cell Free + HCMEC D3_line
      416        ECIS        6       no 10,00Cell Free + HCMEC D3_line
      417        ECIS        6       no 10,00Cell Free + HCMEC D3_line
      418        ECIS        7       no  5,00Cell Free + HCMEC D3_line
      419        ECIS        7       no  5,00Cell Free + HCMEC D3_line
      420        ECIS        7       no  5,00Cell Free + HCMEC D3_line
      421        ECIS        1       no 35,00Cell Free + HCMEC D3_line
      422        ECIS        1       no 35,00Cell Free + HCMEC D3_line
      423        ECIS        1       no 35,00Cell Free + HCMEC D3_line
      424        ECIS        2       no 30,00Cell Free + HCMEC D3_line
      425        ECIS        2       no 30,00Cell Free + HCMEC D3_line
      426        ECIS        2       no 30,00Cell Free + HCMEC D3_line
      427        ECIS        3       no 25,00Cell Free + HCMEC D3_line
      428        ECIS        3       no 25,00Cell Free + HCMEC D3_line
      429        ECIS        3       no 25,00Cell Free + HCMEC D3_line
      430        ECIS        4       no 20,00Cell Free + HCMEC D3_line
      431        ECIS        4       no 20,00Cell Free + HCMEC D3_line
      432        ECIS        4       no 20,00Cell Free + HCMEC D3_line
      433        ECIS        5       no 15,00Cell Free + HCMEC D3_line
      434        ECIS        5       no 15,00Cell Free + HCMEC D3_line
      435        ECIS        5       no 15,00Cell Free + HCMEC D3_line
      436        ECIS        6       no 10,00Cell Free + HCMEC D3_line
      437        ECIS        6       no 10,00Cell Free + HCMEC D3_line
      438        ECIS        6       no 10,00Cell Free + HCMEC D3_line
      439        ECIS        7       no  5,00Cell Free + HCMEC D3_line
      440        ECIS        7       no  5,00Cell Free + HCMEC D3_line
      441        ECIS        7       no  5,00Cell Free + HCMEC D3_line
      442        ECIS        1       no 35,00Cell Free + HCMEC D3_line
      443        ECIS        1       no 35,00Cell Free + HCMEC D3_line
      444        ECIS        1       no 35,00Cell Free + HCMEC D3_line
      445        ECIS        2       no 30,00Cell Free + HCMEC D3_line
      446        ECIS        2       no 30,00Cell Free + HCMEC D3_line
      447        ECIS        2       no 30,00Cell Free + HCMEC D3_line
      448        ECIS        3       no 25,00Cell Free + HCMEC D3_line
      449        ECIS        3       no 25,00Cell Free + HCMEC D3_line
      450        ECIS        3       no 25,00Cell Free + HCMEC D3_line
      451        ECIS        4       no 20,00Cell Free + HCMEC D3_line
      452        ECIS        4       no 20,00Cell Free + HCMEC D3_line
      453        ECIS        4       no 20,00Cell Free + HCMEC D3_line
      454        ECIS        5       no 15,00Cell Free + HCMEC D3_line
      455        ECIS        5       no 15,00Cell Free + HCMEC D3_line
      456        ECIS        5       no 15,00Cell Free + HCMEC D3_line
      457        ECIS        6       no 10,00Cell Free + HCMEC D3_line
      458        ECIS        6       no 10,00Cell Free + HCMEC D3_line
      459        ECIS        6       no 10,00Cell Free + HCMEC D3_line
      460        ECIS        7       no  5,00Cell Free + HCMEC D3_line
      461        ECIS        7       no  5,00Cell Free + HCMEC D3_line
      462        ECIS        7       no  5,00Cell Free + HCMEC D3_line
      463        ECIS        1       no 35,00Cell Free + HCMEC D3_line
      464        ECIS        1       no 35,00Cell Free + HCMEC D3_line
      465        ECIS        1       no 35,00Cell Free + HCMEC D3_line
      466        ECIS        2       no 30,00Cell Free + HCMEC D3_line
      467        ECIS        2       no 30,00Cell Free + HCMEC D3_line
      468        ECIS        2       no 30,00Cell Free + HCMEC D3_line
      469        ECIS        3       no 25,00Cell Free + HCMEC D3_line
      470        ECIS        3       no 25,00Cell Free + HCMEC D3_line
      471        ECIS        3       no 25,00Cell Free + HCMEC D3_line
      472        ECIS        4       no 20,00Cell Free + HCMEC D3_line
      473        ECIS        4       no 20,00Cell Free + HCMEC D3_line
      474        ECIS        4       no 20,00Cell Free + HCMEC D3_line
      475        ECIS        5       no 15,00Cell Free + HCMEC D3_line
      476        ECIS        5       no 15,00Cell Free + HCMEC D3_line
      477        ECIS        5       no 15,00Cell Free + HCMEC D3_line
      478        ECIS        6       no 10,00Cell Free + HCMEC D3_line
      479        ECIS        6       no 10,00Cell Free + HCMEC D3_line
      480        ECIS        6       no 10,00Cell Free + HCMEC D3_line
      481        ECIS        7       no  5,00Cell Free + HCMEC D3_line
      482        ECIS        7       no  5,00Cell Free + HCMEC D3_line
      483        ECIS        7       no  5,00Cell Free + HCMEC D3_line
      484        ECIS        1       no 35,00Cell Free + HCMEC D3_line
      485        ECIS        1       no 35,00Cell Free + HCMEC D3_line
      486        ECIS        1       no 35,00Cell Free + HCMEC D3_line
      487        ECIS        2       no 30,00Cell Free + HCMEC D3_line
      488        ECIS        2       no 30,00Cell Free + HCMEC D3_line
      489        ECIS        2       no 30,00Cell Free + HCMEC D3_line
      490        ECIS        3       no 25,00Cell Free + HCMEC D3_line
      491        ECIS        3       no 25,00Cell Free + HCMEC D3_line
      492        ECIS        3       no 25,00Cell Free + HCMEC D3_line
      493        ECIS        4       no 20,00Cell Free + HCMEC D3_line
      494        ECIS        4       no 20,00Cell Free + HCMEC D3_line
      495        ECIS        4       no 20,00Cell Free + HCMEC D3_line
      496        ECIS        5       no 15,00Cell Free + HCMEC D3_line
      497        ECIS        5       no 15,00Cell Free + HCMEC D3_line
      498        ECIS        5       no 15,00Cell Free + HCMEC D3_line
      499        ECIS        6       no 10,00Cell Free + HCMEC D3_line
      500        ECIS        6       no 10,00Cell Free + HCMEC D3_line
      501        ECIS        6       no 10,00Cell Free + HCMEC D3_line
      502        ECIS        7       no  5,00Cell Free + HCMEC D3_line
      503        ECIS        7       no  5,00Cell Free + HCMEC D3_line
      504        ECIS        7       no  5,00Cell Free + HCMEC D3_line
      505        ECIS        1       no 35,00Cell Free + HCMEC D3_line
      506        ECIS        1       no 35,00Cell Free + HCMEC D3_line
      507        ECIS        1       no 35,00Cell Free + HCMEC D3_line
      508        ECIS        2       no 30,00Cell Free + HCMEC D3_line
      509        ECIS        2       no 30,00Cell Free + HCMEC D3_line
      510        ECIS        2       no 30,00Cell Free + HCMEC D3_line
      511        ECIS        3       no 25,00Cell Free + HCMEC D3_line
      512        ECIS        3       no 25,00Cell Free + HCMEC D3_line
      513        ECIS        3       no 25,00Cell Free + HCMEC D3_line
      514        ECIS        4       no 20,00Cell Free + HCMEC D3_line
      515        ECIS        4       no 20,00Cell Free + HCMEC D3_line
      516        ECIS        4       no 20,00Cell Free + HCMEC D3_line
      517        ECIS        5       no 15,00Cell Free + HCMEC D3_line
      518        ECIS        5       no 15,00Cell Free + HCMEC D3_line
      519        ECIS        5       no 15,00Cell Free + HCMEC D3_line
      520        ECIS        6       no 10,00Cell Free + HCMEC D3_line
      521        ECIS        6       no 10,00Cell Free + HCMEC D3_line
      522        ECIS        6       no 10,00Cell Free + HCMEC D3_line
      523        ECIS        7       no  5,00Cell Free + HCMEC D3_line
      524        ECIS        7       no  5,00Cell Free + HCMEC D3_line
      525        ECIS        7       no  5,00Cell Free + HCMEC D3_line
      526        ECIS        1       no 35,00Cell Free + HCMEC D3_line
      527        ECIS        1       no 35,00Cell Free + HCMEC D3_line
      528        ECIS        1       no 35,00Cell Free + HCMEC D3_line
      529        ECIS        2       no 30,00Cell Free + HCMEC D3_line
      530        ECIS        2       no 30,00Cell Free + HCMEC D3_line
      531        ECIS        2       no 30,00Cell Free + HCMEC D3_line
      532        ECIS        3       no 25,00Cell Free + HCMEC D3_line
      533        ECIS        3       no 25,00Cell Free + HCMEC D3_line
      534        ECIS        3       no 25,00Cell Free + HCMEC D3_line
      535        ECIS        4       no 20,00Cell Free + HCMEC D3_line
      536        ECIS        4       no 20,00Cell Free + HCMEC D3_line
      537        ECIS        4       no 20,00Cell Free + HCMEC D3_line
      538        ECIS        5       no 15,00Cell Free + HCMEC D3_line
      539        ECIS        5       no 15,00Cell Free + HCMEC D3_line
      540        ECIS        5       no 15,00Cell Free + HCMEC D3_line
      541        ECIS        6       no 10,00Cell Free + HCMEC D3_line
      542        ECIS        6       no 10,00Cell Free + HCMEC D3_line
      543        ECIS        6       no 10,00Cell Free + HCMEC D3_line
      544        ECIS        7       no  5,00Cell Free + HCMEC D3_line
      545        ECIS        7       no  5,00Cell Free + HCMEC D3_line
      546        ECIS        7       no  5,00Cell Free + HCMEC D3_line
      547        ECIS        1       no 35,00Cell Free + HCMEC D3_line
      548        ECIS        1       no 35,00Cell Free + HCMEC D3_line
      549        ECIS        1       no 35,00Cell Free + HCMEC D3_line
      550        ECIS        2       no 30,00Cell Free + HCMEC D3_line
      551        ECIS        2       no 30,00Cell Free + HCMEC D3_line
      552        ECIS        2       no 30,00Cell Free + HCMEC D3_line
      553        ECIS        3       no 25,00Cell Free + HCMEC D3_line
      554        ECIS        3       no 25,00Cell Free + HCMEC D3_line
      555        ECIS        3       no 25,00Cell Free + HCMEC D3_line
      556        ECIS        4       no 20,00Cell Free + HCMEC D3_line
      557        ECIS        4       no 20,00Cell Free + HCMEC D3_line
      558        ECIS        4       no 20,00Cell Free + HCMEC D3_line
      559        ECIS        5       no 15,00Cell Free + HCMEC D3_line
      560        ECIS        5       no 15,00Cell Free + HCMEC D3_line
      561        ECIS        5       no 15,00Cell Free + HCMEC D3_line
      562        ECIS        6       no 10,00Cell Free + HCMEC D3_line
      563        ECIS        6       no 10,00Cell Free + HCMEC D3_line
      564        ECIS        6       no 10,00Cell Free + HCMEC D3_line
      565        ECIS        7       no  5,00Cell Free + HCMEC D3_line
      566        ECIS        7       no  5,00Cell Free + HCMEC D3_line
      567        ECIS        7       no  5,00Cell Free + HCMEC D3_line
      568        ECIS        1       no 35,00Cell Free + HCMEC D3_line
      569        ECIS        1       no 35,00Cell Free + HCMEC D3_line
      570        ECIS        1       no 35,00Cell Free + HCMEC D3_line
      571        ECIS        2       no 30,00Cell Free + HCMEC D3_line
      572        ECIS        2       no 30,00Cell Free + HCMEC D3_line
      573        ECIS        2       no 30,00Cell Free + HCMEC D3_line
      574        ECIS        3       no 25,00Cell Free + HCMEC D3_line
      575        ECIS        3       no 25,00Cell Free + HCMEC D3_line
      576        ECIS        3       no 25,00Cell Free + HCMEC D3_line
      577        ECIS        4       no 20,00Cell Free + HCMEC D3_line
      578        ECIS        4       no 20,00Cell Free + HCMEC D3_line
      579        ECIS        4       no 20,00Cell Free + HCMEC D3_line
      580        ECIS        5       no 15,00Cell Free + HCMEC D3_line
      581        ECIS        5       no 15,00Cell Free + HCMEC D3_line
      582        ECIS        5       no 15,00Cell Free + HCMEC D3_line
      583        ECIS        6       no 10,00Cell Free + HCMEC D3_line
      584        ECIS        6       no 10,00Cell Free + HCMEC D3_line
      585        ECIS        6       no 10,00Cell Free + HCMEC D3_line
      586        ECIS        7       no  5,00Cell Free + HCMEC D3_line
      587        ECIS        7       no  5,00Cell Free + HCMEC D3_line
      588        ECIS        7       no  5,00Cell Free + HCMEC D3_line
      589        ECIS        1       no 35,00Cell Free + HCMEC D3_line
      590        ECIS        1       no 35,00Cell Free + HCMEC D3_line
      591        ECIS        1       no 35,00Cell Free + HCMEC D3_line
      592        ECIS        2       no 30,00Cell Free + HCMEC D3_line
      593        ECIS        2       no 30,00Cell Free + HCMEC D3_line
      594        ECIS        2       no 30,00Cell Free + HCMEC D3_line
      595        ECIS        3       no 25,00Cell Free + HCMEC D3_line
      596        ECIS        3       no 25,00Cell Free + HCMEC D3_line
      597        ECIS        3       no 25,00Cell Free + HCMEC D3_line
      598        ECIS        4       no 20,00Cell Free + HCMEC D3_line
      599        ECIS        4       no 20,00Cell Free + HCMEC D3_line
      600        ECIS        4       no 20,00Cell Free + HCMEC D3_line
      601        ECIS        5       no 15,00Cell Free + HCMEC D3_line
      602        ECIS        5       no 15,00Cell Free + HCMEC D3_line
      603        ECIS        5       no 15,00Cell Free + HCMEC D3_line
      604        ECIS        6       no 10,00Cell Free + HCMEC D3_line
      605        ECIS        6       no 10,00Cell Free + HCMEC D3_line
      606        ECIS        6       no 10,00Cell Free + HCMEC D3_line
      607        ECIS        7       no  5,00Cell Free + HCMEC D3_line
      608        ECIS        7       no  5,00Cell Free + HCMEC D3_line
      609        ECIS        7       no  5,00Cell Free + HCMEC D3_line
      610        ECIS        1       no 35,00Cell Free + HCMEC D3_line
      611        ECIS        1       no 35,00Cell Free + HCMEC D3_line
      612        ECIS        1       no 35,00Cell Free + HCMEC D3_line
      613        ECIS        2       no 30,00Cell Free + HCMEC D3_line
      614        ECIS        2       no 30,00Cell Free + HCMEC D3_line
      615        ECIS        2       no 30,00Cell Free + HCMEC D3_line
      616        ECIS        3       no 25,00Cell Free + HCMEC D3_line
      617        ECIS        3       no 25,00Cell Free + HCMEC D3_line
      618        ECIS        3       no 25,00Cell Free + HCMEC D3_line
      619        ECIS        4       no 20,00Cell Free + HCMEC D3_line
      620        ECIS        4       no 20,00Cell Free + HCMEC D3_line
      621        ECIS        4       no 20,00Cell Free + HCMEC D3_line
      622        ECIS        5       no 15,00Cell Free + HCMEC D3_line
      623        ECIS        5       no 15,00Cell Free + HCMEC D3_line
      624        ECIS        5       no 15,00Cell Free + HCMEC D3_line
      625        ECIS        6       no 10,00Cell Free + HCMEC D3_line
      626        ECIS        6       no 10,00Cell Free + HCMEC D3_line
      627        ECIS        6       no 10,00Cell Free + HCMEC D3_line
      628        ECIS        7       no  5,00Cell Free + HCMEC D3_line
      629        ECIS        7       no  5,00Cell Free + HCMEC D3_line
      630        ECIS        7       no  5,00Cell Free + HCMEC D3_line
      631        ECIS        1       no 35,00Cell Free + HCMEC D3_line
      632        ECIS        1       no 35,00Cell Free + HCMEC D3_line
      633        ECIS        1       no 35,00Cell Free + HCMEC D3_line
      634        ECIS        2       no 30,00Cell Free + HCMEC D3_line
      635        ECIS        2       no 30,00Cell Free + HCMEC D3_line
      636        ECIS        2       no 30,00Cell Free + HCMEC D3_line
      637        ECIS        3       no 25,00Cell Free + HCMEC D3_line
      638        ECIS        3       no 25,00Cell Free + HCMEC D3_line
      639        ECIS        3       no 25,00Cell Free + HCMEC D3_line
      640        ECIS        4       no 20,00Cell Free + HCMEC D3_line
      641        ECIS        4       no 20,00Cell Free + HCMEC D3_line
      642        ECIS        4       no 20,00Cell Free + HCMEC D3_line
      643        ECIS        5       no 15,00Cell Free + HCMEC D3_line
      644        ECIS        5       no 15,00Cell Free + HCMEC D3_line
      645        ECIS        5       no 15,00Cell Free + HCMEC D3_line
      646        ECIS        6       no 10,00Cell Free + HCMEC D3_line
      647        ECIS        6       no 10,00Cell Free + HCMEC D3_line
      648        ECIS        6       no 10,00Cell Free + HCMEC D3_line
      649        ECIS        7       no  5,00Cell Free + HCMEC D3_line
      650        ECIS        7       no  5,00Cell Free + HCMEC D3_line
      651        ECIS        7       no  5,00Cell Free + HCMEC D3_line
      652        ECIS        1       no 35,00Cell Free + HCMEC D3_line
      653        ECIS        1       no 35,00Cell Free + HCMEC D3_line
      654        ECIS        1       no 35,00Cell Free + HCMEC D3_line
      655        ECIS        2       no 30,00Cell Free + HCMEC D3_line
      656        ECIS        2       no 30,00Cell Free + HCMEC D3_line
      657        ECIS        2       no 30,00Cell Free + HCMEC D3_line
      658        ECIS        3       no 25,00Cell Free + HCMEC D3_line
      659        ECIS        3       no 25,00Cell Free + HCMEC D3_line
      660        ECIS        3       no 25,00Cell Free + HCMEC D3_line
      661        ECIS        4       no 20,00Cell Free + HCMEC D3_line
      662        ECIS        4       no 20,00Cell Free + HCMEC D3_line
      663        ECIS        4       no 20,00Cell Free + HCMEC D3_line
      664        ECIS        5       no 15,00Cell Free + HCMEC D3_line
      665        ECIS        5       no 15,00Cell Free + HCMEC D3_line
      666        ECIS        5       no 15,00Cell Free + HCMEC D3_line
      667        ECIS        6       no 10,00Cell Free + HCMEC D3_line
      668        ECIS        6       no 10,00Cell Free + HCMEC D3_line
      669        ECIS        6       no 10,00Cell Free + HCMEC D3_line
      670        ECIS        7       no  5,00Cell Free + HCMEC D3_line
      671        ECIS        7       no  5,00Cell Free + HCMEC D3_line
      672        ECIS        7       no  5,00Cell Free + HCMEC D3_line
      673        ECIS        1       no 35,00Cell Free + HCMEC D3_line
      674        ECIS        1       no 35,00Cell Free + HCMEC D3_line
      675        ECIS        1       no 35,00Cell Free + HCMEC D3_line
      676        ECIS        2       no 30,00Cell Free + HCMEC D3_line
      677        ECIS        2       no 30,00Cell Free + HCMEC D3_line
      678        ECIS        2       no 30,00Cell Free + HCMEC D3_line
      679        ECIS        3       no 25,00Cell Free + HCMEC D3_line
      680        ECIS        3       no 25,00Cell Free + HCMEC D3_line
      681        ECIS        3       no 25,00Cell Free + HCMEC D3_line
      682        ECIS        4       no 20,00Cell Free + HCMEC D3_line
      683        ECIS        4       no 20,00Cell Free + HCMEC D3_line
      684        ECIS        4       no 20,00Cell Free + HCMEC D3_line
      685        ECIS        5       no 15,00Cell Free + HCMEC D3_line
      686        ECIS        5       no 15,00Cell Free + HCMEC D3_line
      687        ECIS        5       no 15,00Cell Free + HCMEC D3_line
      688        ECIS        6       no 10,00Cell Free + HCMEC D3_line
      689        ECIS        6       no 10,00Cell Free + HCMEC D3_line
      690        ECIS        6       no 10,00Cell Free + HCMEC D3_line
      691        ECIS        7       no  5,00Cell Free + HCMEC D3_line
      692        ECIS        7       no  5,00Cell Free + HCMEC D3_line
      693        ECIS        7       no  5,00Cell Free + HCMEC D3_line
      694        ECIS        1       no 35,00Cell Free + HCMEC D3_line
      695        ECIS        1       no 35,00Cell Free + HCMEC D3_line
      696        ECIS        1       no 35,00Cell Free + HCMEC D3_line
      697        ECIS        2       no 30,00Cell Free + HCMEC D3_line
      698        ECIS        2       no 30,00Cell Free + HCMEC D3_line
      699        ECIS        2       no 30,00Cell Free + HCMEC D3_line
      700        ECIS        3       no 25,00Cell Free + HCMEC D3_line
      701        ECIS        3       no 25,00Cell Free + HCMEC D3_line
      702        ECIS        3       no 25,00Cell Free + HCMEC D3_line
      703        ECIS        4       no 20,00Cell Free + HCMEC D3_line
      704        ECIS        4       no 20,00Cell Free + HCMEC D3_line
      705        ECIS        4       no 20,00Cell Free + HCMEC D3_line
      706        ECIS        5       no 15,00Cell Free + HCMEC D3_line
      707        ECIS        5       no 15,00Cell Free + HCMEC D3_line
      708        ECIS        5       no 15,00Cell Free + HCMEC D3_line
      709        ECIS        6       no 10,00Cell Free + HCMEC D3_line
      710        ECIS        6       no 10,00Cell Free + HCMEC D3_line
      711        ECIS        6       no 10,00Cell Free + HCMEC D3_line
      712        ECIS        7       no  5,00Cell Free + HCMEC D3_line
      713        ECIS        7       no  5,00Cell Free + HCMEC D3_line
      714        ECIS        7       no  5,00Cell Free + HCMEC D3_line
      715        ECIS        1       no 35,00Cell Free + HCMEC D3_line
      716        ECIS        1       no 35,00Cell Free + HCMEC D3_line
      717        ECIS        1       no 35,00Cell Free + HCMEC D3_line
      718        ECIS        2       no 30,00Cell Free + HCMEC D3_line
      719        ECIS        2       no 30,00Cell Free + HCMEC D3_line
      720        ECIS        2       no 30,00Cell Free + HCMEC D3_line
      721        ECIS        3       no 25,00Cell Free + HCMEC D3_line
      722        ECIS        3       no 25,00Cell Free + HCMEC D3_line
      723        ECIS        3       no 25,00Cell Free + HCMEC D3_line
      724        ECIS        4       no 20,00Cell Free + HCMEC D3_line
      725        ECIS        4       no 20,00Cell Free + HCMEC D3_line
      726        ECIS        4       no 20,00Cell Free + HCMEC D3_line
      727        ECIS        5       no 15,00Cell Free + HCMEC D3_line
      728        ECIS        5       no 15,00Cell Free + HCMEC D3_line
      729        ECIS        5       no 15,00Cell Free + HCMEC D3_line
      730        ECIS        6       no 10,00Cell Free + HCMEC D3_line
      731        ECIS        6       no 10,00Cell Free + HCMEC D3_line
      732        ECIS        6       no 10,00Cell Free + HCMEC D3_line
      733        ECIS        7       no  5,00Cell Free + HCMEC D3_line
      734        ECIS        7       no  5,00Cell Free + HCMEC D3_line
      735        ECIS        7       no  5,00Cell Free + HCMEC D3_line
      736        ECIS        1       no 35,00Cell Free + HCMEC D3_line
      737        ECIS        1       no 35,00Cell Free + HCMEC D3_line
      738        ECIS        1       no 35,00Cell Free + HCMEC D3_line
      739        ECIS        2       no 30,00Cell Free + HCMEC D3_line
      740        ECIS        2       no 30,00Cell Free + HCMEC D3_line
      741        ECIS        2       no 30,00Cell Free + HCMEC D3_line
      742        ECIS        3       no 25,00Cell Free + HCMEC D3_line
      743        ECIS        3       no 25,00Cell Free + HCMEC D3_line
      744        ECIS        3       no 25,00Cell Free + HCMEC D3_line
      745        ECIS        4       no 20,00Cell Free + HCMEC D3_line
      746        ECIS        4       no 20,00Cell Free + HCMEC D3_line
      747        ECIS        4       no 20,00Cell Free + HCMEC D3_line
      748        ECIS        5       no 15,00Cell Free + HCMEC D3_line
      749        ECIS        5       no 15,00Cell Free + HCMEC D3_line
      750        ECIS        5       no 15,00Cell Free + HCMEC D3_line
      751        ECIS        6       no 10,00Cell Free + HCMEC D3_line
      752        ECIS        6       no 10,00Cell Free + HCMEC D3_line
      753        ECIS        6       no 10,00Cell Free + HCMEC D3_line
      754        ECIS        7       no  5,00Cell Free + HCMEC D3_line
      755        ECIS        7       no  5,00Cell Free + HCMEC D3_line
      756        ECIS        7       no  5,00Cell Free + HCMEC D3_line
      757        ECIS        1       no 35,00Cell Free + HCMEC D3_line
      758        ECIS        1       no 35,00Cell Free + HCMEC D3_line
      759        ECIS        1       no 35,00Cell Free + HCMEC D3_line
      760        ECIS        2       no 30,00Cell Free + HCMEC D3_line
      761        ECIS        2       no 30,00Cell Free + HCMEC D3_line
      762        ECIS        2       no 30,00Cell Free + HCMEC D3_line
      763        ECIS        3       no 25,00Cell Free + HCMEC D3_line
      764        ECIS        3       no 25,00Cell Free + HCMEC D3_line
      765        ECIS        3       no 25,00Cell Free + HCMEC D3_line
      766        ECIS        4       no 20,00Cell Free + HCMEC D3_line
      767        ECIS        4       no 20,00Cell Free + HCMEC D3_line
      768        ECIS        4       no 20,00Cell Free + HCMEC D3_line
      769        ECIS        5       no 15,00Cell Free + HCMEC D3_line
      770        ECIS        5       no 15,00Cell Free + HCMEC D3_line
      771        ECIS        5       no 15,00Cell Free + HCMEC D3_line
      772        ECIS        6       no 10,00Cell Free + HCMEC D3_line
      773        ECIS        6       no 10,00Cell Free + HCMEC D3_line
      774        ECIS        6       no 10,00Cell Free + HCMEC D3_line
      775        ECIS        7       no  5,00Cell Free + HCMEC D3_line
      776        ECIS        7       no  5,00Cell Free + HCMEC D3_line
      777        ECIS        7       no  5,00Cell Free + HCMEC D3_line
      778        ECIS        1       no 35,00Cell Free + HCMEC D3_line
      779        ECIS        1       no 35,00Cell Free + HCMEC D3_line
      780        ECIS        1       no 35,00Cell Free + HCMEC D3_line
      781        ECIS        2       no 30,00Cell Free + HCMEC D3_line
      782        ECIS        2       no 30,00Cell Free + HCMEC D3_line
      783        ECIS        2       no 30,00Cell Free + HCMEC D3_line
      784        ECIS        3       no 25,00Cell Free + HCMEC D3_line
      785        ECIS        3       no 25,00Cell Free + HCMEC D3_line
      786        ECIS        3       no 25,00Cell Free + HCMEC D3_line
      787        ECIS        4       no 20,00Cell Free + HCMEC D3_line
      788        ECIS        4       no 20,00Cell Free + HCMEC D3_line
      789        ECIS        4       no 20,00Cell Free + HCMEC D3_line
      790        ECIS        5       no 15,00Cell Free + HCMEC D3_line
      791        ECIS        5       no 15,00Cell Free + HCMEC D3_line
      792        ECIS        5       no 15,00Cell Free + HCMEC D3_line
      793        ECIS        6       no 10,00Cell Free + HCMEC D3_line
      794        ECIS        6       no 10,00Cell Free + HCMEC D3_line
      795        ECIS        6       no 10,00Cell Free + HCMEC D3_line
      796        ECIS        7       no  5,00Cell Free + HCMEC D3_line
      797        ECIS        7       no  5,00Cell Free + HCMEC D3_line
      798        ECIS        7       no  5,00Cell Free + HCMEC D3_line
      799        ECIS        1       no 35,00Cell Free + HCMEC D3_line
      800        ECIS        1       no 35,00Cell Free + HCMEC D3_line
      801        ECIS        1       no 35,00Cell Free + HCMEC D3_line
      802        ECIS        2       no 30,00Cell Free + HCMEC D3_line
      803        ECIS        2       no 30,00Cell Free + HCMEC D3_line
      804        ECIS        2       no 30,00Cell Free + HCMEC D3_line
      805        ECIS        3       no 25,00Cell Free + HCMEC D3_line
      806        ECIS        3       no 25,00Cell Free + HCMEC D3_line
      807        ECIS        3       no 25,00Cell Free + HCMEC D3_line
      808        ECIS        4       no 20,00Cell Free + HCMEC D3_line
      809        ECIS        4       no 20,00Cell Free + HCMEC D3_line
      810        ECIS        4       no 20,00Cell Free + HCMEC D3_line
      811        ECIS        5       no 15,00Cell Free + HCMEC D3_line
      812        ECIS        5       no 15,00Cell Free + HCMEC D3_line
      813        ECIS        5       no 15,00Cell Free + HCMEC D3_line
      814        ECIS        6       no 10,00Cell Free + HCMEC D3_line
      815        ECIS        6       no 10,00Cell Free + HCMEC D3_line
      816        ECIS        6       no 10,00Cell Free + HCMEC D3_line
      817        ECIS        7       no  5,00Cell Free + HCMEC D3_line
      818        ECIS        7       no  5,00Cell Free + HCMEC D3_line
      819        ECIS        7       no  5,00Cell Free + HCMEC D3_line
      820        ECIS        1       no 35,00Cell Free + HCMEC D3_line
      821        ECIS        1       no 35,00Cell Free + HCMEC D3_line
      822        ECIS        1       no 35,00Cell Free + HCMEC D3_line
      823        ECIS        2       no 30,00Cell Free + HCMEC D3_line
      824        ECIS        2       no 30,00Cell Free + HCMEC D3_line
      825        ECIS        2       no 30,00Cell Free + HCMEC D3_line
      826        ECIS        3       no 25,00Cell Free + HCMEC D3_line
      827        ECIS        3       no 25,00Cell Free + HCMEC D3_line
      828        ECIS        3       no 25,00Cell Free + HCMEC D3_line
      829        ECIS        4       no 20,00Cell Free + HCMEC D3_line
      830        ECIS        4       no 20,00Cell Free + HCMEC D3_line
      831        ECIS        4       no 20,00Cell Free + HCMEC D3_line
      832        ECIS        5       no 15,00Cell Free + HCMEC D3_line
      833        ECIS        5       no 15,00Cell Free + HCMEC D3_line
      834        ECIS        5       no 15,00Cell Free + HCMEC D3_line
      835        ECIS        6       no 10,00Cell Free + HCMEC D3_line
      836        ECIS        6       no 10,00Cell Free + HCMEC D3_line
      837        ECIS        6       no 10,00Cell Free + HCMEC D3_line
      838        ECIS        7       no  5,00Cell Free + HCMEC D3_line
      839        ECIS        7       no  5,00Cell Free + HCMEC D3_line
      840        ECIS        7       no  5,00Cell Free + HCMEC D3_line
      841        ECIS        1       no 35,00Cell Free + HCMEC D3_line
      842        ECIS        1       no 35,00Cell Free + HCMEC D3_line
      843        ECIS        1       no 35,00Cell Free + HCMEC D3_line
      844        ECIS        2       no 30,00Cell Free + HCMEC D3_line
      845        ECIS        2       no 30,00Cell Free + HCMEC D3_line
      846        ECIS        2       no 30,00Cell Free + HCMEC D3_line
      847        ECIS        3       no 25,00Cell Free + HCMEC D3_line
      848        ECIS        3       no 25,00Cell Free + HCMEC D3_line
      849        ECIS        3       no 25,00Cell Free + HCMEC D3_line
      850        ECIS        4       no 20,00Cell Free + HCMEC D3_line
      851        ECIS        4       no 20,00Cell Free + HCMEC D3_line
      852        ECIS        4       no 20,00Cell Free + HCMEC D3_line
      853        ECIS        5       no 15,00Cell Free + HCMEC D3_line
      854        ECIS        5       no 15,00Cell Free + HCMEC D3_line
      855        ECIS        5       no 15,00Cell Free + HCMEC D3_line
      856        ECIS        6       no 10,00Cell Free + HCMEC D3_line
      857        ECIS        6       no 10,00Cell Free + HCMEC D3_line
      858        ECIS        6       no 10,00Cell Free + HCMEC D3_line
      859        ECIS        7       no  5,00Cell Free + HCMEC D3_line
      860        ECIS        7       no  5,00Cell Free + HCMEC D3_line
      861        ECIS        7       no  5,00Cell Free + HCMEC D3_line
      862        ECIS        1       no 35,00Cell Free + HCMEC D3_line
      863        ECIS        1       no 35,00Cell Free + HCMEC D3_line
      864        ECIS        1       no 35,00Cell Free + HCMEC D3_line
      865        ECIS        2       no 30,00Cell Free + HCMEC D3_line
      866        ECIS        2       no 30,00Cell Free + HCMEC D3_line
      867        ECIS        2       no 30,00Cell Free + HCMEC D3_line
      868        ECIS        3       no 25,00Cell Free + HCMEC D3_line
      869        ECIS        3       no 25,00Cell Free + HCMEC D3_line
      870        ECIS        3       no 25,00Cell Free + HCMEC D3_line
      871        ECIS        4       no 20,00Cell Free + HCMEC D3_line
      872        ECIS        4       no 20,00Cell Free + HCMEC D3_line
      873        ECIS        4       no 20,00Cell Free + HCMEC D3_line
      874        ECIS        5       no 15,00Cell Free + HCMEC D3_line
      875        ECIS        5       no 15,00Cell Free + HCMEC D3_line
      876        ECIS        5       no 15,00Cell Free + HCMEC D3_line
      877        ECIS        6       no 10,00Cell Free + HCMEC D3_line
      878        ECIS        6       no 10,00Cell Free + HCMEC D3_line
      879        ECIS        6       no 10,00Cell Free + HCMEC D3_line
      880        ECIS        7       no  5,00Cell Free + HCMEC D3_line
      881        ECIS        7       no  5,00Cell Free + HCMEC D3_line
      882        ECIS        7       no  5,00Cell Free + HCMEC D3_line
      883        ECIS        1       no 35,00Cell Free + HCMEC D3_line
      884        ECIS        1       no 35,00Cell Free + HCMEC D3_line
      885        ECIS        1       no 35,00Cell Free + HCMEC D3_line
      886        ECIS        2       no 30,00Cell Free + HCMEC D3_line
      887        ECIS        2       no 30,00Cell Free + HCMEC D3_line
      888        ECIS        2       no 30,00Cell Free + HCMEC D3_line
      889        ECIS        3       no 25,00Cell Free + HCMEC D3_line
      890        ECIS        3       no 25,00Cell Free + HCMEC D3_line
      891        ECIS        3       no 25,00Cell Free + HCMEC D3_line
      892        ECIS        4       no 20,00Cell Free + HCMEC D3_line
      893        ECIS        4       no 20,00Cell Free + HCMEC D3_line
      894        ECIS        4       no 20,00Cell Free + HCMEC D3_line
      895        ECIS        5       no 15,00Cell Free + HCMEC D3_line
      896        ECIS        5       no 15,00Cell Free + HCMEC D3_line
      897        ECIS        5       no 15,00Cell Free + HCMEC D3_line
      898        ECIS        6       no 10,00Cell Free + HCMEC D3_line
      899        ECIS        6       no 10,00Cell Free + HCMEC D3_line
      900        ECIS        6       no 10,00Cell Free + HCMEC D3_line
      901        ECIS        7       no  5,00Cell Free + HCMEC D3_line
      902        ECIS        7       no  5,00Cell Free + HCMEC D3_line
      903        ECIS        7       no  5,00Cell Free + HCMEC D3_line
      904        ECIS        1       no 35,00Cell Free + HCMEC D3_line
      905        ECIS        1       no 35,00Cell Free + HCMEC D3_line
      906        ECIS        1       no 35,00Cell Free + HCMEC D3_line
      907        ECIS        2       no 30,00Cell Free + HCMEC D3_line
      908        ECIS        2       no 30,00Cell Free + HCMEC D3_line
      909        ECIS        2       no 30,00Cell Free + HCMEC D3_line
      910        ECIS        3       no 25,00Cell Free + HCMEC D3_line
      911        ECIS        3       no 25,00Cell Free + HCMEC D3_line
      912        ECIS        3       no 25,00Cell Free + HCMEC D3_line
      913        ECIS        4       no 20,00Cell Free + HCMEC D3_line
      914        ECIS        4       no 20,00Cell Free + HCMEC D3_line
      915        ECIS        4       no 20,00Cell Free + HCMEC D3_line
      916        ECIS        5       no 15,00Cell Free + HCMEC D3_line
      917        ECIS        5       no 15,00Cell Free + HCMEC D3_line
      918        ECIS        5       no 15,00Cell Free + HCMEC D3_line
      919        ECIS        6       no 10,00Cell Free + HCMEC D3_line
      920        ECIS        6       no 10,00Cell Free + HCMEC D3_line
      921        ECIS        6       no 10,00Cell Free + HCMEC D3_line
      922        ECIS        7       no  5,00Cell Free + HCMEC D3_line
      923        ECIS        7       no  5,00Cell Free + HCMEC D3_line
      924        ECIS        7       no  5,00Cell Free + HCMEC D3_line
      925        ECIS        1       no 35,00Cell Free + HCMEC D3_line
      926        ECIS        1       no 35,00Cell Free + HCMEC D3_line
      927        ECIS        1       no 35,00Cell Free + HCMEC D3_line
      928        ECIS        2       no 30,00Cell Free + HCMEC D3_line
      929        ECIS        2       no 30,00Cell Free + HCMEC D3_line
      930        ECIS        2       no 30,00Cell Free + HCMEC D3_line
      931        ECIS        3       no 25,00Cell Free + HCMEC D3_line
      932        ECIS        3       no 25,00Cell Free + HCMEC D3_line
      933        ECIS        3       no 25,00Cell Free + HCMEC D3_line
      934        ECIS        4       no 20,00Cell Free + HCMEC D3_line
      935        ECIS        4       no 20,00Cell Free + HCMEC D3_line
      936        ECIS        4       no 20,00Cell Free + HCMEC D3_line
      937        ECIS        5       no 15,00Cell Free + HCMEC D3_line
      938        ECIS        5       no 15,00Cell Free + HCMEC D3_line
      939        ECIS        5       no 15,00Cell Free + HCMEC D3_line
      940        ECIS        6       no 10,00Cell Free + HCMEC D3_line
      941        ECIS        6       no 10,00Cell Free + HCMEC D3_line
      942        ECIS        6       no 10,00Cell Free + HCMEC D3_line
      943        ECIS        7       no  5,00Cell Free + HCMEC D3_line
      944        ECIS        7       no  5,00Cell Free + HCMEC D3_line
      945        ECIS        7       no  5,00Cell Free + HCMEC D3_line
      946        ECIS        1       no 35,00Cell Free + HCMEC D3_line
      947        ECIS        1       no 35,00Cell Free + HCMEC D3_line
      948        ECIS        1       no 35,00Cell Free + HCMEC D3_line
      949        ECIS        2       no 30,00Cell Free + HCMEC D3_line
      950        ECIS        2       no 30,00Cell Free + HCMEC D3_line
      951        ECIS        2       no 30,00Cell Free + HCMEC D3_line
      952        ECIS        3       no 25,00Cell Free + HCMEC D3_line
      953        ECIS        3       no 25,00Cell Free + HCMEC D3_line
      954        ECIS        3       no 25,00Cell Free + HCMEC D3_line
      955        ECIS        4       no 20,00Cell Free + HCMEC D3_line
      956        ECIS        4       no 20,00Cell Free + HCMEC D3_line
      957        ECIS        4       no 20,00Cell Free + HCMEC D3_line
      958        ECIS        5       no 15,00Cell Free + HCMEC D3_line
      959        ECIS        5       no 15,00Cell Free + HCMEC D3_line
      960        ECIS        5       no 15,00Cell Free + HCMEC D3_line
      961        ECIS        6       no 10,00Cell Free + HCMEC D3_line
      962        ECIS        6       no 10,00Cell Free + HCMEC D3_line
      963        ECIS        6       no 10,00Cell Free + HCMEC D3_line
      964        ECIS        7       no  5,00Cell Free + HCMEC D3_line
      965        ECIS        7       no  5,00Cell Free + HCMEC D3_line
      966        ECIS        7       no  5,00Cell Free + HCMEC D3_line
      967        ECIS        1       no 35,00Cell Free + HCMEC D3_line
      968        ECIS        1       no 35,00Cell Free + HCMEC D3_line
      969        ECIS        1       no 35,00Cell Free + HCMEC D3_line
      970        ECIS        2       no 30,00Cell Free + HCMEC D3_line
      971        ECIS        2       no 30,00Cell Free + HCMEC D3_line
      972        ECIS        2       no 30,00Cell Free + HCMEC D3_line
      973        ECIS        3       no 25,00Cell Free + HCMEC D3_line
      974        ECIS        3       no 25,00Cell Free + HCMEC D3_line
      975        ECIS        3       no 25,00Cell Free + HCMEC D3_line
      976        ECIS        4       no 20,00Cell Free + HCMEC D3_line
      977        ECIS        4       no 20,00Cell Free + HCMEC D3_line
      978        ECIS        4       no 20,00Cell Free + HCMEC D3_line
      979        ECIS        5       no 15,00Cell Free + HCMEC D3_line
      980        ECIS        5       no 15,00Cell Free + HCMEC D3_line
      981        ECIS        5       no 15,00Cell Free + HCMEC D3_line
      982        ECIS        6       no 10,00Cell Free + HCMEC D3_line
      983        ECIS        6       no 10,00Cell Free + HCMEC D3_line
      984        ECIS        6       no 10,00Cell Free + HCMEC D3_line
      985        ECIS        7       no  5,00Cell Free + HCMEC D3_line
      986        ECIS        7       no  5,00Cell Free + HCMEC D3_line
      987        ECIS        7       no  5,00Cell Free + HCMEC D3_line
      988        ECIS        1       no 35,00Cell Free + HCMEC D3_line
      989        ECIS        1       no 35,00Cell Free + HCMEC D3_line
      990        ECIS        1       no 35,00Cell Free + HCMEC D3_line
      991        ECIS        2       no 30,00Cell Free + HCMEC D3_line
      992        ECIS        2       no 30,00Cell Free + HCMEC D3_line
      993        ECIS        2       no 30,00Cell Free + HCMEC D3_line
      994        ECIS        3       no 25,00Cell Free + HCMEC D3_line
      995        ECIS        3       no 25,00Cell Free + HCMEC D3_line
      996        ECIS        3       no 25,00Cell Free + HCMEC D3_line
      997        ECIS        4       no 20,00Cell Free + HCMEC D3_line
      998        ECIS        4       no 20,00Cell Free + HCMEC D3_line
      999        ECIS        4       no 20,00Cell Free + HCMEC D3_line
      1000       ECIS        5       no 15,00Cell Free + HCMEC D3_line
      1001       ECIS        5       no 15,00Cell Free + HCMEC D3_line
      1002       ECIS        5       no 15,00Cell Free + HCMEC D3_line
      1003       ECIS        6       no 10,00Cell Free + HCMEC D3_line
      1004       ECIS        6       no 10,00Cell Free + HCMEC D3_line
      1005       ECIS        6       no 10,00Cell Free + HCMEC D3_line
      1006       ECIS        7       no  5,00Cell Free + HCMEC D3_line
      1007       ECIS        7       no  5,00Cell Free + HCMEC D3_line
      1008       ECIS        7       no  5,00Cell Free + HCMEC D3_line
      1009       ECIS        1       no 35,00Cell Free + HCMEC D3_line
      1010       ECIS        1       no 35,00Cell Free + HCMEC D3_line
      1011       ECIS        1       no 35,00Cell Free + HCMEC D3_line
      1012       ECIS        2       no 30,00Cell Free + HCMEC D3_line
      1013       ECIS        2       no 30,00Cell Free + HCMEC D3_line
      1014       ECIS        2       no 30,00Cell Free + HCMEC D3_line
      1015       ECIS        3       no 25,00Cell Free + HCMEC D3_line
      1016       ECIS        3       no 25,00Cell Free + HCMEC D3_line
      1017       ECIS        3       no 25,00Cell Free + HCMEC D3_line
      1018       ECIS        4       no 20,00Cell Free + HCMEC D3_line
      1019       ECIS        4       no 20,00Cell Free + HCMEC D3_line
      1020       ECIS        4       no 20,00Cell Free + HCMEC D3_line
      1021       ECIS        5       no 15,00Cell Free + HCMEC D3_line
      1022       ECIS        5       no 15,00Cell Free + HCMEC D3_line
      1023       ECIS        5       no 15,00Cell Free + HCMEC D3_line
      1024       ECIS        6       no 10,00Cell Free + HCMEC D3_line
      1025       ECIS        6       no 10,00Cell Free + HCMEC D3_line
      1026       ECIS        6       no 10,00Cell Free + HCMEC D3_line
      1027       ECIS        7       no  5,00Cell Free + HCMEC D3_line
      1028       ECIS        7       no  5,00Cell Free + HCMEC D3_line
      1029       ECIS        7       no  5,00Cell Free + HCMEC D3_line
      1030       ECIS        1       no 35,00Cell Free + HCMEC D3_line
      1031       ECIS        1       no 35,00Cell Free + HCMEC D3_line
      1032       ECIS        1       no 35,00Cell Free + HCMEC D3_line
      1033       ECIS        2       no 30,00Cell Free + HCMEC D3_line
      1034       ECIS        2       no 30,00Cell Free + HCMEC D3_line
      1035       ECIS        2       no 30,00Cell Free + HCMEC D3_line
      1036       ECIS        3       no 25,00Cell Free + HCMEC D3_line
      1037       ECIS        3       no 25,00Cell Free + HCMEC D3_line
      1038       ECIS        3       no 25,00Cell Free + HCMEC D3_line
      1039       ECIS        4       no 20,00Cell Free + HCMEC D3_line
      1040       ECIS        4       no 20,00Cell Free + HCMEC D3_line
      1041       ECIS        4       no 20,00Cell Free + HCMEC D3_line
      1042       ECIS        5       no 15,00Cell Free + HCMEC D3_line
      1043       ECIS        5       no 15,00Cell Free + HCMEC D3_line
      1044       ECIS        5       no 15,00Cell Free + HCMEC D3_line
      1045       ECIS        6       no 10,00Cell Free + HCMEC D3_line
      1046       ECIS        6       no 10,00Cell Free + HCMEC D3_line
      1047       ECIS        6       no 10,00Cell Free + HCMEC D3_line
      1048       ECIS        7       no  5,00Cell Free + HCMEC D3_line
      1049       ECIS        7       no  5,00Cell Free + HCMEC D3_line
      1050       ECIS        7       no  5,00Cell Free + HCMEC D3_line
      1051       ECIS        1       no 35,00Cell Free + HCMEC D3_line
      1052       ECIS        1       no 35,00Cell Free + HCMEC D3_line
      1053       ECIS        1       no 35,00Cell Free + HCMEC D3_line
      1054       ECIS        2       no 30,00Cell Free + HCMEC D3_line
      1055       ECIS        2       no 30,00Cell Free + HCMEC D3_line
      1056       ECIS        2       no 30,00Cell Free + HCMEC D3_line
      1057       ECIS        3       no 25,00Cell Free + HCMEC D3_line
      1058       ECIS        3       no 25,00Cell Free + HCMEC D3_line
      1059       ECIS        3       no 25,00Cell Free + HCMEC D3_line
      1060       ECIS        4       no 20,00Cell Free + HCMEC D3_line
      1061       ECIS        4       no 20,00Cell Free + HCMEC D3_line
      1062       ECIS        4       no 20,00Cell Free + HCMEC D3_line
      1063       ECIS        5       no 15,00Cell Free + HCMEC D3_line
      1064       ECIS        5       no 15,00Cell Free + HCMEC D3_line
      1065       ECIS        5       no 15,00Cell Free + HCMEC D3_line
      1066       ECIS        6       no 10,00Cell Free + HCMEC D3_line
      1067       ECIS        6       no 10,00Cell Free + HCMEC D3_line
      1068       ECIS        6       no 10,00Cell Free + HCMEC D3_line
      1069       ECIS        7       no  5,00Cell Free + HCMEC D3_line
      1070       ECIS        7       no  5,00Cell Free + HCMEC D3_line
      1071       ECIS        7       no  5,00Cell Free + HCMEC D3_line
      1072       ECIS        1       no 35,00Cell Free + HCMEC D3_line
      1073       ECIS        1       no 35,00Cell Free + HCMEC D3_line
      1074       ECIS        1       no 35,00Cell Free + HCMEC D3_line
      1075       ECIS        2       no 30,00Cell Free + HCMEC D3_line
      1076       ECIS        2       no 30,00Cell Free + HCMEC D3_line
      1077       ECIS        2       no 30,00Cell Free + HCMEC D3_line
      1078       ECIS        3       no 25,00Cell Free + HCMEC D3_line
      1079       ECIS        3       no 25,00Cell Free + HCMEC D3_line
      1080       ECIS        3       no 25,00Cell Free + HCMEC D3_line
      1081       ECIS        4       no 20,00Cell Free + HCMEC D3_line
      1082       ECIS        4       no 20,00Cell Free + HCMEC D3_line
      1083       ECIS        4       no 20,00Cell Free + HCMEC D3_line
      1084       ECIS        5       no 15,00Cell Free + HCMEC D3_line
      1085       ECIS        5       no 15,00Cell Free + HCMEC D3_line
      1086       ECIS        5       no 15,00Cell Free + HCMEC D3_line
      1087       ECIS        6       no 10,00Cell Free + HCMEC D3_line
      1088       ECIS        6       no 10,00Cell Free + HCMEC D3_line
      1089       ECIS        6       no 10,00Cell Free + HCMEC D3_line
      1090       ECIS        7       no  5,00Cell Free + HCMEC D3_line
      1091       ECIS        7       no  5,00Cell Free + HCMEC D3_line
      1092       ECIS        7       no  5,00Cell Free + HCMEC D3_line
      1093       ECIS        1       no 35,00Cell Free + HCMEC D3_line
      1094       ECIS        1       no 35,00Cell Free + HCMEC D3_line
      1095       ECIS        1       no 35,00Cell Free + HCMEC D3_line
      1096       ECIS        2       no 30,00Cell Free + HCMEC D3_line
      1097       ECIS        2       no 30,00Cell Free + HCMEC D3_line
      1098       ECIS        2       no 30,00Cell Free + HCMEC D3_line
      1099       ECIS        3       no 25,00Cell Free + HCMEC D3_line
      1100       ECIS        3       no 25,00Cell Free + HCMEC D3_line
      1101       ECIS        3       no 25,00Cell Free + HCMEC D3_line
      1102       ECIS        4       no 20,00Cell Free + HCMEC D3_line
      1103       ECIS        4       no 20,00Cell Free + HCMEC D3_line
      1104       ECIS        4       no 20,00Cell Free + HCMEC D3_line
      1105       ECIS        5       no 15,00Cell Free + HCMEC D3_line
      1106       ECIS        5       no 15,00Cell Free + HCMEC D3_line
      1107       ECIS        5       no 15,00Cell Free + HCMEC D3_line
      1108       ECIS        6       no 10,00Cell Free + HCMEC D3_line
      1109       ECIS        6       no 10,00Cell Free + HCMEC D3_line
      1110       ECIS        6       no 10,00Cell Free + HCMEC D3_line
      1111       ECIS        7       no  5,00Cell Free + HCMEC D3_line
      1112       ECIS        7       no  5,00Cell Free + HCMEC D3_line
      1113       ECIS        7       no  5,00Cell Free + HCMEC D3_line
      1114       ECIS        1       no 35,00Cell Free + HCMEC D3_line
      1115       ECIS        1       no 35,00Cell Free + HCMEC D3_line
      1116       ECIS        1       no 35,00Cell Free + HCMEC D3_line
      1117       ECIS        2       no 30,00Cell Free + HCMEC D3_line
      1118       ECIS        2       no 30,00Cell Free + HCMEC D3_line
      1119       ECIS        2       no 30,00Cell Free + HCMEC D3_line
      1120       ECIS        3       no 25,00Cell Free + HCMEC D3_line
      1121       ECIS        3       no 25,00Cell Free + HCMEC D3_line
      1122       ECIS        3       no 25,00Cell Free + HCMEC D3_line
      1123       ECIS        4       no 20,00Cell Free + HCMEC D3_line
      1124       ECIS        4       no 20,00Cell Free + HCMEC D3_line
      1125       ECIS        4       no 20,00Cell Free + HCMEC D3_line
      1126       ECIS        5       no 15,00Cell Free + HCMEC D3_line
      1127       ECIS        5       no 15,00Cell Free + HCMEC D3_line
      1128       ECIS        5       no 15,00Cell Free + HCMEC D3_line
      1129       ECIS        6       no 10,00Cell Free + HCMEC D3_line
      1130       ECIS        6       no 10,00Cell Free + HCMEC D3_line
      1131       ECIS        6       no 10,00Cell Free + HCMEC D3_line
      1132       ECIS        7       no  5,00Cell Free + HCMEC D3_line
      1133       ECIS        7       no  5,00Cell Free + HCMEC D3_line
      1134       ECIS        7       no  5,00Cell Free + HCMEC D3_line
      1135       ECIS        1       no 35,00Cell Free + HCMEC D3_line
      1136       ECIS        1       no 35,00Cell Free + HCMEC D3_line
      1137       ECIS        1       no 35,00Cell Free + HCMEC D3_line
      1138       ECIS        2       no 30,00Cell Free + HCMEC D3_line
      1139       ECIS        2       no 30,00Cell Free + HCMEC D3_line
      1140       ECIS        2       no 30,00Cell Free + HCMEC D3_line
      1141       ECIS        3       no 25,00Cell Free + HCMEC D3_line
      1142       ECIS        3       no 25,00Cell Free + HCMEC D3_line
      1143       ECIS        3       no 25,00Cell Free + HCMEC D3_line
      1144       ECIS        4       no 20,00Cell Free + HCMEC D3_line
      1145       ECIS        4       no 20,00Cell Free + HCMEC D3_line
      1146       ECIS        4       no 20,00Cell Free + HCMEC D3_line
      1147       ECIS        5       no 15,00Cell Free + HCMEC D3_line
      1148       ECIS        5       no 15,00Cell Free + HCMEC D3_line
      1149       ECIS        5       no 15,00Cell Free + HCMEC D3_line
      1150       ECIS        6       no 10,00Cell Free + HCMEC D3_line
      1151       ECIS        6       no 10,00Cell Free + HCMEC D3_line
      1152       ECIS        6       no 10,00Cell Free + HCMEC D3_line
      1153       ECIS        7       no  5,00Cell Free + HCMEC D3_line
      1154       ECIS        7       no  5,00Cell Free + HCMEC D3_line
      1155       ECIS        7       no  5,00Cell Free + HCMEC D3_line
      1156       ECIS        1       no 35,00Cell Free + HCMEC D3_line
      1157       ECIS        1       no 35,00Cell Free + HCMEC D3_line
      1158       ECIS        1       no 35,00Cell Free + HCMEC D3_line
      1159       ECIS        2       no 30,00Cell Free + HCMEC D3_line
      1160       ECIS        2       no 30,00Cell Free + HCMEC D3_line
      1161       ECIS        2       no 30,00Cell Free + HCMEC D3_line
      1162       ECIS        3       no 25,00Cell Free + HCMEC D3_line
      1163       ECIS        3       no 25,00Cell Free + HCMEC D3_line
      1164       ECIS        3       no 25,00Cell Free + HCMEC D3_line
      1165       ECIS        4       no 20,00Cell Free + HCMEC D3_line
      1166       ECIS        4       no 20,00Cell Free + HCMEC D3_line
      1167       ECIS        4       no 20,00Cell Free + HCMEC D3_line
      1168       ECIS        5       no 15,00Cell Free + HCMEC D3_line
      1169       ECIS        5       no 15,00Cell Free + HCMEC D3_line
      1170       ECIS        5       no 15,00Cell Free + HCMEC D3_line
      1171       ECIS        6       no 10,00Cell Free + HCMEC D3_line
      1172       ECIS        6       no 10,00Cell Free + HCMEC D3_line
      1173       ECIS        6       no 10,00Cell Free + HCMEC D3_line
      1174       ECIS        7       no  5,00Cell Free + HCMEC D3_line
      1175       ECIS        7       no  5,00Cell Free + HCMEC D3_line
      1176       ECIS        7       no  5,00Cell Free + HCMEC D3_line
      1177       ECIS        1       no 35,00Cell Free + HCMEC D3_line
      1178       ECIS        1       no 35,00Cell Free + HCMEC D3_line
      1179       ECIS        1       no 35,00Cell Free + HCMEC D3_line
      1180       ECIS        2       no 30,00Cell Free + HCMEC D3_line
      1181       ECIS        2       no 30,00Cell Free + HCMEC D3_line
      1182       ECIS        2       no 30,00Cell Free + HCMEC D3_line
      1183       ECIS        3       no 25,00Cell Free + HCMEC D3_line
      1184       ECIS        3       no 25,00Cell Free + HCMEC D3_line
      1185       ECIS        3       no 25,00Cell Free + HCMEC D3_line
      1186       ECIS        4       no 20,00Cell Free + HCMEC D3_line
      1187       ECIS        4       no 20,00Cell Free + HCMEC D3_line
      1188       ECIS        4       no 20,00Cell Free + HCMEC D3_line
      1189       ECIS        5       no 15,00Cell Free + HCMEC D3_line
      1190       ECIS        5       no 15,00Cell Free + HCMEC D3_line
      1191       ECIS        5       no 15,00Cell Free + HCMEC D3_line
      1192       ECIS        6       no 10,00Cell Free + HCMEC D3_line
      1193       ECIS        6       no 10,00Cell Free + HCMEC D3_line
      1194       ECIS        6       no 10,00Cell Free + HCMEC D3_line
      1195       ECIS        7       no  5,00Cell Free + HCMEC D3_line
      1196       ECIS        7       no  5,00Cell Free + HCMEC D3_line
      1197       ECIS        7       no  5,00Cell Free + HCMEC D3_line
      1198       ECIS        1       no 35,00Cell Free + HCMEC D3_line
      1199       ECIS        1       no 35,00Cell Free + HCMEC D3_line
      1200       ECIS        1       no 35,00Cell Free + HCMEC D3_line
      1201       ECIS        2       no 30,00Cell Free + HCMEC D3_line
      1202       ECIS        2       no 30,00Cell Free + HCMEC D3_line
      1203       ECIS        2       no 30,00Cell Free + HCMEC D3_line
      1204       ECIS        3       no 25,00Cell Free + HCMEC D3_line
      1205       ECIS        3       no 25,00Cell Free + HCMEC D3_line
      1206       ECIS        3       no 25,00Cell Free + HCMEC D3_line
      1207       ECIS        4       no 20,00Cell Free + HCMEC D3_line
      1208       ECIS        4       no 20,00Cell Free + HCMEC D3_line
      1209       ECIS        4       no 20,00Cell Free + HCMEC D3_line
      1210       ECIS        5       no 15,00Cell Free + HCMEC D3_line
      1211       ECIS        5       no 15,00Cell Free + HCMEC D3_line
      1212       ECIS        5       no 15,00Cell Free + HCMEC D3_line
      1213       ECIS        6       no 10,00Cell Free + HCMEC D3_line
      1214       ECIS        6       no 10,00Cell Free + HCMEC D3_line
      1215       ECIS        6       no 10,00Cell Free + HCMEC D3_line
      1216       ECIS        7       no  5,00Cell Free + HCMEC D3_line
      1217       ECIS        7       no  5,00Cell Free + HCMEC D3_line
      1218       ECIS        7       no  5,00Cell Free + HCMEC D3_line
      1219       ECIS        1       no 35,00Cell Free + HCMEC D3_line
      1220       ECIS        1       no 35,00Cell Free + HCMEC D3_line
      1221       ECIS        1       no 35,00Cell Free + HCMEC D3_line
      1222       ECIS        2       no 30,00Cell Free + HCMEC D3_line
      1223       ECIS        2       no 30,00Cell Free + HCMEC D3_line
      1224       ECIS        2       no 30,00Cell Free + HCMEC D3_line
      1225       ECIS        3       no 25,00Cell Free + HCMEC D3_line
      1226       ECIS        3       no 25,00Cell Free + HCMEC D3_line
      1227       ECIS        3       no 25,00Cell Free + HCMEC D3_line
      1228       ECIS        4       no 20,00Cell Free + HCMEC D3_line
      1229       ECIS        4       no 20,00Cell Free + HCMEC D3_line
      1230       ECIS        4       no 20,00Cell Free + HCMEC D3_line
      1231       ECIS        5       no 15,00Cell Free + HCMEC D3_line
      1232       ECIS        5       no 15,00Cell Free + HCMEC D3_line
      1233       ECIS        5       no 15,00Cell Free + HCMEC D3_line
      1234       ECIS        6       no 10,00Cell Free + HCMEC D3_line
      1235       ECIS        6       no 10,00Cell Free + HCMEC D3_line
      1236       ECIS        6       no 10,00Cell Free + HCMEC D3_line
      1237       ECIS        7       no  5,00Cell Free + HCMEC D3_line
      1238       ECIS        7       no  5,00Cell Free + HCMEC D3_line
      1239       ECIS        7       no  5,00Cell Free + HCMEC D3_line
      1240       ECIS        1       no 35,00Cell Free + HCMEC D3_line
      1241       ECIS        1       no 35,00Cell Free + HCMEC D3_line
      1242       ECIS        1       no 35,00Cell Free + HCMEC D3_line
      1243       ECIS        2       no 30,00Cell Free + HCMEC D3_line
      1244       ECIS        2       no 30,00Cell Free + HCMEC D3_line
      1245       ECIS        2       no 30,00Cell Free + HCMEC D3_line
      1246       ECIS        3       no 25,00Cell Free + HCMEC D3_line
      1247       ECIS        3       no 25,00Cell Free + HCMEC D3_line
      1248       ECIS        3       no 25,00Cell Free + HCMEC D3_line
      1249       ECIS        4       no 20,00Cell Free + HCMEC D3_line
      1250       ECIS        4       no 20,00Cell Free + HCMEC D3_line
      1251       ECIS        4       no 20,00Cell Free + HCMEC D3_line
      1252       ECIS        5       no 15,00Cell Free + HCMEC D3_line
      1253       ECIS        5       no 15,00Cell Free + HCMEC D3_line
      1254       ECIS        5       no 15,00Cell Free + HCMEC D3_line
      1255       ECIS        6       no 10,00Cell Free + HCMEC D3_line
      1256       ECIS        6       no 10,00Cell Free + HCMEC D3_line
      1257       ECIS        6       no 10,00Cell Free + HCMEC D3_line
      1258       ECIS        7       no  5,00Cell Free + HCMEC D3_line
      1259       ECIS        7       no  5,00Cell Free + HCMEC D3_line
      1260       ECIS        7       no  5,00Cell Free + HCMEC D3_line
      1261       ECIS        1       no 35,00Cell Free + HCMEC D3_line
      1262       ECIS        1       no 35,00Cell Free + HCMEC D3_line
      1263       ECIS        1       no 35,00Cell Free + HCMEC D3_line
      1264       ECIS        2       no 30,00Cell Free + HCMEC D3_line
      1265       ECIS        2       no 30,00Cell Free + HCMEC D3_line
      1266       ECIS        2       no 30,00Cell Free + HCMEC D3_line
      1267       ECIS        3       no 25,00Cell Free + HCMEC D3_line
      1268       ECIS        3       no 25,00Cell Free + HCMEC D3_line
      1269       ECIS        3       no 25,00Cell Free + HCMEC D3_line
      1270       ECIS        4       no 20,00Cell Free + HCMEC D3_line
      1271       ECIS        4       no 20,00Cell Free + HCMEC D3_line
      1272       ECIS        4       no 20,00Cell Free + HCMEC D3_line
      1273       ECIS        5       no 15,00Cell Free + HCMEC D3_line
      1274       ECIS        5       no 15,00Cell Free + HCMEC D3_line
      1275       ECIS        5       no 15,00Cell Free + HCMEC D3_line
      1276       ECIS        6       no 10,00Cell Free + HCMEC D3_line
      1277       ECIS        6       no 10,00Cell Free + HCMEC D3_line
      1278       ECIS        6       no 10,00Cell Free + HCMEC D3_line
      1279       ECIS        7       no  5,00Cell Free + HCMEC D3_line
      1280       ECIS        7       no  5,00Cell Free + HCMEC D3_line
      1281       ECIS        7       no  5,00Cell Free + HCMEC D3_line
      1282       ECIS        1       no 35,00Cell Free + HCMEC D3_line
      1283       ECIS        1       no 35,00Cell Free + HCMEC D3_line
      1284       ECIS        1       no 35,00Cell Free + HCMEC D3_line
      1285       ECIS        2       no 30,00Cell Free + HCMEC D3_line
      1286       ECIS        2       no 30,00Cell Free + HCMEC D3_line
      1287       ECIS        2       no 30,00Cell Free + HCMEC D3_line
      1288       ECIS        3       no 25,00Cell Free + HCMEC D3_line
      1289       ECIS        3       no 25,00Cell Free + HCMEC D3_line
      1290       ECIS        3       no 25,00Cell Free + HCMEC D3_line
      1291       ECIS        4       no 20,00Cell Free + HCMEC D3_line
      1292       ECIS        4       no 20,00Cell Free + HCMEC D3_line
      1293       ECIS        4       no 20,00Cell Free + HCMEC D3_line
      1294       ECIS        5       no 15,00Cell Free + HCMEC D3_line
      1295       ECIS        5       no 15,00Cell Free + HCMEC D3_line
      1296       ECIS        5       no 15,00Cell Free + HCMEC D3_line
      1297       ECIS        6       no 10,00Cell Free + HCMEC D3_line
      1298       ECIS        6       no 10,00Cell Free + HCMEC D3_line
      1299       ECIS        6       no 10,00Cell Free + HCMEC D3_line
      1300       ECIS        7       no  5,00Cell Free + HCMEC D3_line
      1301       ECIS        7       no  5,00Cell Free + HCMEC D3_line
      1302       ECIS        7       no  5,00Cell Free + HCMEC D3_line
      1303       ECIS        1       no 35,00Cell Free + HCMEC D3_line
      1304       ECIS        1       no 35,00Cell Free + HCMEC D3_line
      1305       ECIS        1       no 35,00Cell Free + HCMEC D3_line
      1306       ECIS        2       no 30,00Cell Free + HCMEC D3_line
      1307       ECIS        2       no 30,00Cell Free + HCMEC D3_line
      1308       ECIS        2       no 30,00Cell Free + HCMEC D3_line
      1309       ECIS        3       no 25,00Cell Free + HCMEC D3_line
      1310       ECIS        3       no 25,00Cell Free + HCMEC D3_line
      1311       ECIS        3       no 25,00Cell Free + HCMEC D3_line
      1312       ECIS        4       no 20,00Cell Free + HCMEC D3_line
      1313       ECIS        4       no 20,00Cell Free + HCMEC D3_line
      1314       ECIS        4       no 20,00Cell Free + HCMEC D3_line
      1315       ECIS        5       no 15,00Cell Free + HCMEC D3_line
      1316       ECIS        5       no 15,00Cell Free + HCMEC D3_line
      1317       ECIS        5       no 15,00Cell Free + HCMEC D3_line
      1318       ECIS        6       no 10,00Cell Free + HCMEC D3_line
      1319       ECIS        6       no 10,00Cell Free + HCMEC D3_line
      1320       ECIS        6       no 10,00Cell Free + HCMEC D3_line
      1321       ECIS        7       no  5,00Cell Free + HCMEC D3_line
      1322       ECIS        7       no  5,00Cell Free + HCMEC D3_line
      1323       ECIS        7       no  5,00Cell Free + HCMEC D3_line
      1324       ECIS        1       no 35,00Cell Free + HCMEC D3_line
      1325       ECIS        1       no 35,00Cell Free + HCMEC D3_line
      1326       ECIS        1       no 35,00Cell Free + HCMEC D3_line
      1327       ECIS        2       no 30,00Cell Free + HCMEC D3_line
      1328       ECIS        2       no 30,00Cell Free + HCMEC D3_line
      1329       ECIS        2       no 30,00Cell Free + HCMEC D3_line
      1330       ECIS        3       no 25,00Cell Free + HCMEC D3_line
      1331       ECIS        3       no 25,00Cell Free + HCMEC D3_line
      1332       ECIS        3       no 25,00Cell Free + HCMEC D3_line
      1333       ECIS        4       no 20,00Cell Free + HCMEC D3_line
      1334       ECIS        4       no 20,00Cell Free + HCMEC D3_line
      1335       ECIS        4       no 20,00Cell Free + HCMEC D3_line
      1336       ECIS        5       no 15,00Cell Free + HCMEC D3_line
      1337       ECIS        5       no 15,00Cell Free + HCMEC D3_line
      1338       ECIS        5       no 15,00Cell Free + HCMEC D3_line
      1339       ECIS        6       no 10,00Cell Free + HCMEC D3_line
      1340       ECIS        6       no 10,00Cell Free + HCMEC D3_line
      1341       ECIS        6       no 10,00Cell Free + HCMEC D3_line
      1342       ECIS        7       no  5,00Cell Free + HCMEC D3_line
      1343       ECIS        7       no  5,00Cell Free + HCMEC D3_line
      1344       ECIS        7       no  5,00Cell Free + HCMEC D3_line
      1345       ECIS        1       no 35,00Cell Free + HCMEC D3_line
      1346       ECIS        1       no 35,00Cell Free + HCMEC D3_line
      1347       ECIS        1       no 35,00Cell Free + HCMEC D3_line
      1348       ECIS        2       no 30,00Cell Free + HCMEC D3_line
      1349       ECIS        2       no 30,00Cell Free + HCMEC D3_line
      1350       ECIS        2       no 30,00Cell Free + HCMEC D3_line
      1351       ECIS        3       no 25,00Cell Free + HCMEC D3_line
      1352       ECIS        3       no 25,00Cell Free + HCMEC D3_line
      1353       ECIS        3       no 25,00Cell Free + HCMEC D3_line
      1354       ECIS        4       no 20,00Cell Free + HCMEC D3_line
      1355       ECIS        4       no 20,00Cell Free + HCMEC D3_line
      1356       ECIS        4       no 20,00Cell Free + HCMEC D3_line
      1357       ECIS        5       no 15,00Cell Free + HCMEC D3_line
      1358       ECIS        5       no 15,00Cell Free + HCMEC D3_line
      1359       ECIS        5       no 15,00Cell Free + HCMEC D3_line
      1360       ECIS        6       no 10,00Cell Free + HCMEC D3_line
      1361       ECIS        6       no 10,00Cell Free + HCMEC D3_line
      1362       ECIS        6       no 10,00Cell Free + HCMEC D3_line
      1363       ECIS        7       no  5,00Cell Free + HCMEC D3_line
      1364       ECIS        7       no  5,00Cell Free + HCMEC D3_line
      1365       ECIS        7       no  5,00Cell Free + HCMEC D3_line
      1366       ECIS        1       no 35,00Cell Free + HCMEC D3_line
      1367       ECIS        1       no 35,00Cell Free + HCMEC D3_line
      1368       ECIS        1       no 35,00Cell Free + HCMEC D3_line
      1369       ECIS        2       no 30,00Cell Free + HCMEC D3_line
      1370       ECIS        2       no 30,00Cell Free + HCMEC D3_line
      1371       ECIS        2       no 30,00Cell Free + HCMEC D3_line
      1372       ECIS        3       no 25,00Cell Free + HCMEC D3_line
      1373       ECIS        3       no 25,00Cell Free + HCMEC D3_line
      1374       ECIS        3       no 25,00Cell Free + HCMEC D3_line
      1375       ECIS        4       no 20,00Cell Free + HCMEC D3_line
      1376       ECIS        4       no 20,00Cell Free + HCMEC D3_line
      1377       ECIS        4       no 20,00Cell Free + HCMEC D3_line
      1378       ECIS        5       no 15,00Cell Free + HCMEC D3_line
      1379       ECIS        5       no 15,00Cell Free + HCMEC D3_line
      1380       ECIS        5       no 15,00Cell Free + HCMEC D3_line
      1381       ECIS        6       no 10,00Cell Free + HCMEC D3_line
      1382       ECIS        6       no 10,00Cell Free + HCMEC D3_line
      1383       ECIS        6       no 10,00Cell Free + HCMEC D3_line
      1384       ECIS        7       no  5,00Cell Free + HCMEC D3_line
      1385       ECIS        7       no  5,00Cell Free + HCMEC D3_line
      1386       ECIS        7       no  5,00Cell Free + HCMEC D3_line
      1387       ECIS        1       no 35,00Cell Free + HCMEC D3_line
      1388       ECIS        1       no 35,00Cell Free + HCMEC D3_line
      1389       ECIS        1       no 35,00Cell Free + HCMEC D3_line
      1390       ECIS        2       no 30,00Cell Free + HCMEC D3_line
      1391       ECIS        2       no 30,00Cell Free + HCMEC D3_line
      1392       ECIS        2       no 30,00Cell Free + HCMEC D3_line
      1393       ECIS        3       no 25,00Cell Free + HCMEC D3_line
      1394       ECIS        3       no 25,00Cell Free + HCMEC D3_line
      1395       ECIS        3       no 25,00Cell Free + HCMEC D3_line
      1396       ECIS        4       no 20,00Cell Free + HCMEC D3_line
      1397       ECIS        4       no 20,00Cell Free + HCMEC D3_line
      1398       ECIS        4       no 20,00Cell Free + HCMEC D3_line
      1399       ECIS        5       no 15,00Cell Free + HCMEC D3_line
      1400       ECIS        5       no 15,00Cell Free + HCMEC D3_line
      1401       ECIS        5       no 15,00Cell Free + HCMEC D3_line
      1402       ECIS        6       no 10,00Cell Free + HCMEC D3_line
      1403       ECIS        6       no 10,00Cell Free + HCMEC D3_line
      1404       ECIS        6       no 10,00Cell Free + HCMEC D3_line
      1405       ECIS        7       no  5,00Cell Free + HCMEC D3_line
      1406       ECIS        7       no  5,00Cell Free + HCMEC D3_line
      1407       ECIS        7       no  5,00Cell Free + HCMEC D3_line
      1408       ECIS        1       no 35,00Cell Free + HCMEC D3_line
      1409       ECIS        1       no 35,00Cell Free + HCMEC D3_line
      1410       ECIS        1       no 35,00Cell Free + HCMEC D3_line
      1411       ECIS        2       no 30,00Cell Free + HCMEC D3_line
      1412       ECIS        2       no 30,00Cell Free + HCMEC D3_line
      1413       ECIS        2       no 30,00Cell Free + HCMEC D3_line
      1414       ECIS        3       no 25,00Cell Free + HCMEC D3_line
      1415       ECIS        3       no 25,00Cell Free + HCMEC D3_line
      1416       ECIS        3       no 25,00Cell Free + HCMEC D3_line
      1417       ECIS        4       no 20,00Cell Free + HCMEC D3_line
      1418       ECIS        4       no 20,00Cell Free + HCMEC D3_line
      1419       ECIS        4       no 20,00Cell Free + HCMEC D3_line
      1420       ECIS        5       no 15,00Cell Free + HCMEC D3_line
      1421       ECIS        5       no 15,00Cell Free + HCMEC D3_line
      1422       ECIS        5       no 15,00Cell Free + HCMEC D3_line
      1423       ECIS        6       no 10,00Cell Free + HCMEC D3_line
      1424       ECIS        6       no 10,00Cell Free + HCMEC D3_line
      1425       ECIS        6       no 10,00Cell Free + HCMEC D3_line
      1426       ECIS        7       no  5,00Cell Free + HCMEC D3_line
      1427       ECIS        7       no  5,00Cell Free + HCMEC D3_line
      1428       ECIS        7       no  5,00Cell Free + HCMEC D3_line
      1429       ECIS        1       no 35,00Cell Free + HCMEC D3_line
      1430       ECIS        1       no 35,00Cell Free + HCMEC D3_line
      1431       ECIS        1       no 35,00Cell Free + HCMEC D3_line
      1432       ECIS        2       no 30,00Cell Free + HCMEC D3_line
      1433       ECIS        2       no 30,00Cell Free + HCMEC D3_line
      1434       ECIS        2       no 30,00Cell Free + HCMEC D3_line
      1435       ECIS        3       no 25,00Cell Free + HCMEC D3_line
      1436       ECIS        3       no 25,00Cell Free + HCMEC D3_line
      1437       ECIS        3       no 25,00Cell Free + HCMEC D3_line
      1438       ECIS        4       no 20,00Cell Free + HCMEC D3_line
      1439       ECIS        4       no 20,00Cell Free + HCMEC D3_line
      1440       ECIS        4       no 20,00Cell Free + HCMEC D3_line
      1441       ECIS        5       no 15,00Cell Free + HCMEC D3_line
      1442       ECIS        5       no 15,00Cell Free + HCMEC D3_line
      1443       ECIS        5       no 15,00Cell Free + HCMEC D3_line
      1444       ECIS        6       no 10,00Cell Free + HCMEC D3_line
      1445       ECIS        6       no 10,00Cell Free + HCMEC D3_line
      1446       ECIS        6       no 10,00Cell Free + HCMEC D3_line
      1447       ECIS        7       no  5,00Cell Free + HCMEC D3_line
      1448       ECIS        7       no  5,00Cell Free + HCMEC D3_line
      1449       ECIS        7       no  5,00Cell Free + HCMEC D3_line
      1450       ECIS        1       no 35,00Cell Free + HCMEC D3_line
      1451       ECIS        1       no 35,00Cell Free + HCMEC D3_line
      1452       ECIS        1       no 35,00Cell Free + HCMEC D3_line
      1453       ECIS        2       no 30,00Cell Free + HCMEC D3_line
      1454       ECIS        2       no 30,00Cell Free + HCMEC D3_line
      1455       ECIS        2       no 30,00Cell Free + HCMEC D3_line
      1456       ECIS        3       no 25,00Cell Free + HCMEC D3_line
      1457       ECIS        3       no 25,00Cell Free + HCMEC D3_line
      1458       ECIS        3       no 25,00Cell Free + HCMEC D3_line
      1459       ECIS        4       no 20,00Cell Free + HCMEC D3_line
      1460       ECIS        4       no 20,00Cell Free + HCMEC D3_line
      1461       ECIS        4       no 20,00Cell Free + HCMEC D3_line
      1462       ECIS        5       no 15,00Cell Free + HCMEC D3_line
      1463       ECIS        5       no 15,00Cell Free + HCMEC D3_line
      1464       ECIS        5       no 15,00Cell Free + HCMEC D3_line
      1465       ECIS        6       no 10,00Cell Free + HCMEC D3_line
      1466       ECIS        6       no 10,00Cell Free + HCMEC D3_line
      1467       ECIS        6       no 10,00Cell Free + HCMEC D3_line
      1468       ECIS        7       no  5,00Cell Free + HCMEC D3_line
      1469       ECIS        7       no  5,00Cell Free + HCMEC D3_line
      1470       ECIS        7       no  5,00Cell Free + HCMEC D3_line
      1471       ECIS        1       no 35,00Cell Free + HCMEC D3_line
      1472       ECIS        1       no 35,00Cell Free + HCMEC D3_line
      1473       ECIS        1       no 35,00Cell Free + HCMEC D3_line
      1474       ECIS        2       no 30,00Cell Free + HCMEC D3_line
      1475       ECIS        2       no 30,00Cell Free + HCMEC D3_line
      1476       ECIS        2       no 30,00Cell Free + HCMEC D3_line
      1477       ECIS        3       no 25,00Cell Free + HCMEC D3_line
      1478       ECIS        3       no 25,00Cell Free + HCMEC D3_line
      1479       ECIS        3       no 25,00Cell Free + HCMEC D3_line
      1480       ECIS        4       no 20,00Cell Free + HCMEC D3_line
      1481       ECIS        4       no 20,00Cell Free + HCMEC D3_line
      1482       ECIS        4       no 20,00Cell Free + HCMEC D3_line
      1483       ECIS        5       no 15,00Cell Free + HCMEC D3_line
      1484       ECIS        5       no 15,00Cell Free + HCMEC D3_line
      1485       ECIS        5       no 15,00Cell Free + HCMEC D3_line
      1486       ECIS        6       no 10,00Cell Free + HCMEC D3_line
      1487       ECIS        6       no 10,00Cell Free + HCMEC D3_line
      1488       ECIS        6       no 10,00Cell Free + HCMEC D3_line
      1489       ECIS        7       no  5,00Cell Free + HCMEC D3_line
      1490       ECIS        7       no  5,00Cell Free + HCMEC D3_line
      1491       ECIS        7       no  5,00Cell Free + HCMEC D3_line
      1492       ECIS        1       no 35,00Cell Free + HCMEC D3_line
      1493       ECIS        1       no 35,00Cell Free + HCMEC D3_line
      1494       ECIS        1       no 35,00Cell Free + HCMEC D3_line
      1495       ECIS        2       no 30,00Cell Free + HCMEC D3_line
      1496       ECIS        2       no 30,00Cell Free + HCMEC D3_line
      1497       ECIS        2       no 30,00Cell Free + HCMEC D3_line
      1498       ECIS        3       no 25,00Cell Free + HCMEC D3_line
      1499       ECIS        3       no 25,00Cell Free + HCMEC D3_line
      1500       ECIS        3       no 25,00Cell Free + HCMEC D3_line
      1501       ECIS        4       no 20,00Cell Free + HCMEC D3_line
      1502       ECIS        4       no 20,00Cell Free + HCMEC D3_line
      1503       ECIS        4       no 20,00Cell Free + HCMEC D3_line
      1504       ECIS        5       no 15,00Cell Free + HCMEC D3_line
      1505       ECIS        5       no 15,00Cell Free + HCMEC D3_line
      1506       ECIS        5       no 15,00Cell Free + HCMEC D3_line
      1507       ECIS        6       no 10,00Cell Free + HCMEC D3_line
      1508       ECIS        6       no 10,00Cell Free + HCMEC D3_line
      1509       ECIS        6       no 10,00Cell Free + HCMEC D3_line
      1510       ECIS        7       no  5,00Cell Free + HCMEC D3_line
      1511       ECIS        7       no  5,00Cell Free + HCMEC D3_line
      1512       ECIS        7       no  5,00Cell Free + HCMEC D3_line
      1513       ECIS        1       no 35,00Cell Free + HCMEC D3_line
      1514       ECIS        1       no 35,00Cell Free + HCMEC D3_line
      1515       ECIS        1       no 35,00Cell Free + HCMEC D3_line
      1516       ECIS        2       no 30,00Cell Free + HCMEC D3_line
      1517       ECIS        2       no 30,00Cell Free + HCMEC D3_line
      1518       ECIS        2       no 30,00Cell Free + HCMEC D3_line
      1519       ECIS        3       no 25,00Cell Free + HCMEC D3_line
      1520       ECIS        3       no 25,00Cell Free + HCMEC D3_line
      1521       ECIS        3       no 25,00Cell Free + HCMEC D3_line
      1522       ECIS        4       no 20,00Cell Free + HCMEC D3_line
      1523       ECIS        4       no 20,00Cell Free + HCMEC D3_line
      1524       ECIS        4       no 20,00Cell Free + HCMEC D3_line
      1525       ECIS        5       no 15,00Cell Free + HCMEC D3_line
      1526       ECIS        5       no 15,00Cell Free + HCMEC D3_line
      1527       ECIS        5       no 15,00Cell Free + HCMEC D3_line
      1528       ECIS        6       no 10,00Cell Free + HCMEC D3_line
      1529       ECIS        6       no 10,00Cell Free + HCMEC D3_line
      1530       ECIS        6       no 10,00Cell Free + HCMEC D3_line
      1531       ECIS        7       no  5,00Cell Free + HCMEC D3_line
      1532       ECIS        7       no  5,00Cell Free + HCMEC D3_line
      1533       ECIS        7       no  5,00Cell Free + HCMEC D3_line
      1534       ECIS        1       no 35,00Cell Free + HCMEC D3_line
      1535       ECIS        1       no 35,00Cell Free + HCMEC D3_line
      1536       ECIS        1       no 35,00Cell Free + HCMEC D3_line
      1537       ECIS        2       no 30,00Cell Free + HCMEC D3_line
      1538       ECIS        2       no 30,00Cell Free + HCMEC D3_line
      1539       ECIS        2       no 30,00Cell Free + HCMEC D3_line
      1540       ECIS        3       no 25,00Cell Free + HCMEC D3_line
      1541       ECIS        3       no 25,00Cell Free + HCMEC D3_line
      1542       ECIS        3       no 25,00Cell Free + HCMEC D3_line
      1543       ECIS        4       no 20,00Cell Free + HCMEC D3_line
      1544       ECIS        4       no 20,00Cell Free + HCMEC D3_line
      1545       ECIS        4       no 20,00Cell Free + HCMEC D3_line
      1546       ECIS        5       no 15,00Cell Free + HCMEC D3_line
      1547       ECIS        5       no 15,00Cell Free + HCMEC D3_line
      1548       ECIS        5       no 15,00Cell Free + HCMEC D3_line
      1549       ECIS        6       no 10,00Cell Free + HCMEC D3_line
      1550       ECIS        6       no 10,00Cell Free + HCMEC D3_line
      1551       ECIS        6       no 10,00Cell Free + HCMEC D3_line
      1552       ECIS        7       no  5,00Cell Free + HCMEC D3_line
      1553       ECIS        7       no  5,00Cell Free + HCMEC D3_line
      1554       ECIS        7       no  5,00Cell Free + HCMEC D3_line
      1555       ECIS        1       no 35,00Cell Free + HCMEC D3_line
      1556       ECIS        1       no 35,00Cell Free + HCMEC D3_line
      1557       ECIS        1       no 35,00Cell Free + HCMEC D3_line
      1558       ECIS        2       no 30,00Cell Free + HCMEC D3_line
      1559       ECIS        2       no 30,00Cell Free + HCMEC D3_line
      1560       ECIS        2       no 30,00Cell Free + HCMEC D3_line
      1561       ECIS        3       no 25,00Cell Free + HCMEC D3_line
      1562       ECIS        3       no 25,00Cell Free + HCMEC D3_line
      1563       ECIS        3       no 25,00Cell Free + HCMEC D3_line
      1564       ECIS        4       no 20,00Cell Free + HCMEC D3_line
      1565       ECIS        4       no 20,00Cell Free + HCMEC D3_line
      1566       ECIS        4       no 20,00Cell Free + HCMEC D3_line
      1567       ECIS        5       no 15,00Cell Free + HCMEC D3_line
      1568       ECIS        5       no 15,00Cell Free + HCMEC D3_line
      1569       ECIS        5       no 15,00Cell Free + HCMEC D3_line
      1570       ECIS        6       no 10,00Cell Free + HCMEC D3_line
      1571       ECIS        6       no 10,00Cell Free + HCMEC D3_line
      1572       ECIS        6       no 10,00Cell Free + HCMEC D3_line
      1573       ECIS        7       no  5,00Cell Free + HCMEC D3_line
      1574       ECIS        7       no  5,00Cell Free + HCMEC D3_line
      1575       ECIS        7       no  5,00Cell Free + HCMEC D3_line
      1576       ECIS        1       no 35,00Cell Free + HCMEC D3_line
      1577       ECIS        1       no 35,00Cell Free + HCMEC D3_line
      1578       ECIS        1       no 35,00Cell Free + HCMEC D3_line
      1579       ECIS        2       no 30,00Cell Free + HCMEC D3_line
      1580       ECIS        2       no 30,00Cell Free + HCMEC D3_line
      1581       ECIS        2       no 30,00Cell Free + HCMEC D3_line
      1582       ECIS        3       no 25,00Cell Free + HCMEC D3_line
      1583       ECIS        3       no 25,00Cell Free + HCMEC D3_line
      1584       ECIS        3       no 25,00Cell Free + HCMEC D3_line
      1585       ECIS        4       no 20,00Cell Free + HCMEC D3_line
      1586       ECIS        4       no 20,00Cell Free + HCMEC D3_line
      1587       ECIS        4       no 20,00Cell Free + HCMEC D3_line
      1588       ECIS        5       no 15,00Cell Free + HCMEC D3_line
      1589       ECIS        5       no 15,00Cell Free + HCMEC D3_line
      1590       ECIS        5       no 15,00Cell Free + HCMEC D3_line
      1591       ECIS        6       no 10,00Cell Free + HCMEC D3_line
      1592       ECIS        6       no 10,00Cell Free + HCMEC D3_line
      1593       ECIS        6       no 10,00Cell Free + HCMEC D3_line
      1594       ECIS        7       no  5,00Cell Free + HCMEC D3_line
      1595       ECIS        7       no  5,00Cell Free + HCMEC D3_line
      1596       ECIS        7       no  5,00Cell Free + HCMEC D3_line
      1597       ECIS        1       no 35,00Cell Free + HCMEC D3_line
      1598       ECIS        1       no 35,00Cell Free + HCMEC D3_line
      1599       ECIS        1       no 35,00Cell Free + HCMEC D3_line
      1600       ECIS        2       no 30,00Cell Free + HCMEC D3_line
      1601       ECIS        2       no 30,00Cell Free + HCMEC D3_line
      1602       ECIS        2       no 30,00Cell Free + HCMEC D3_line
      1603       ECIS        3       no 25,00Cell Free + HCMEC D3_line
      1604       ECIS        3       no 25,00Cell Free + HCMEC D3_line
      1605       ECIS        3       no 25,00Cell Free + HCMEC D3_line
      1606       ECIS        4       no 20,00Cell Free + HCMEC D3_line
      1607       ECIS        4       no 20,00Cell Free + HCMEC D3_line
      1608       ECIS        4       no 20,00Cell Free + HCMEC D3_line
      1609       ECIS        5       no 15,00Cell Free + HCMEC D3_line
      1610       ECIS        5       no 15,00Cell Free + HCMEC D3_line
      1611       ECIS        5       no 15,00Cell Free + HCMEC D3_line
      1612       ECIS        6       no 10,00Cell Free + HCMEC D3_line
      1613       ECIS        6       no 10,00Cell Free + HCMEC D3_line
      1614       ECIS        6       no 10,00Cell Free + HCMEC D3_line
      1615       ECIS        7       no  5,00Cell Free + HCMEC D3_line
      1616       ECIS        7       no  5,00Cell Free + HCMEC D3_line
      1617       ECIS        7       no  5,00Cell Free + HCMEC D3_line
      1618       ECIS        1       no 35,00Cell Free + HCMEC D3_line
      1619       ECIS        1       no 35,00Cell Free + HCMEC D3_line
      1620       ECIS        1       no 35,00Cell Free + HCMEC D3_line
      1621       ECIS        2       no 30,00Cell Free + HCMEC D3_line
      1622       ECIS        2       no 30,00Cell Free + HCMEC D3_line
      1623       ECIS        2       no 30,00Cell Free + HCMEC D3_line
      1624       ECIS        3       no 25,00Cell Free + HCMEC D3_line
      1625       ECIS        3       no 25,00Cell Free + HCMEC D3_line
      1626       ECIS        3       no 25,00Cell Free + HCMEC D3_line
      1627       ECIS        4       no 20,00Cell Free + HCMEC D3_line
      1628       ECIS        4       no 20,00Cell Free + HCMEC D3_line
      1629       ECIS        4       no 20,00Cell Free + HCMEC D3_line
      1630       ECIS        5       no 15,00Cell Free + HCMEC D3_line
      1631       ECIS        5       no 15,00Cell Free + HCMEC D3_line
      1632       ECIS        5       no 15,00Cell Free + HCMEC D3_line
      1633       ECIS        6       no 10,00Cell Free + HCMEC D3_line
      1634       ECIS        6       no 10,00Cell Free + HCMEC D3_line
      1635       ECIS        6       no 10,00Cell Free + HCMEC D3_line
      1636       ECIS        7       no  5,00Cell Free + HCMEC D3_line
      1637       ECIS        7       no  5,00Cell Free + HCMEC D3_line
      1638       ECIS        7       no  5,00Cell Free + HCMEC D3_line
      1639       ECIS        1       no 35,00Cell Free + HCMEC D3_line
      1640       ECIS        1       no 35,00Cell Free + HCMEC D3_line
      1641       ECIS        1       no 35,00Cell Free + HCMEC D3_line
      1642       ECIS        2       no 30,00Cell Free + HCMEC D3_line
      1643       ECIS        2       no 30,00Cell Free + HCMEC D3_line
      1644       ECIS        2       no 30,00Cell Free + HCMEC D3_line
      1645       ECIS        3       no 25,00Cell Free + HCMEC D3_line
      1646       ECIS        3       no 25,00Cell Free + HCMEC D3_line
      1647       ECIS        3       no 25,00Cell Free + HCMEC D3_line
      1648       ECIS        4       no 20,00Cell Free + HCMEC D3_line
      1649       ECIS        4       no 20,00Cell Free + HCMEC D3_line
      1650       ECIS        4       no 20,00Cell Free + HCMEC D3_line
      1651       ECIS        5       no 15,00Cell Free + HCMEC D3_line
      1652       ECIS        5       no 15,00Cell Free + HCMEC D3_line
      1653       ECIS        5       no 15,00Cell Free + HCMEC D3_line
      1654       ECIS        6       no 10,00Cell Free + HCMEC D3_line
      1655       ECIS        6       no 10,00Cell Free + HCMEC D3_line
      1656       ECIS        6       no 10,00Cell Free + HCMEC D3_line
      1657       ECIS        7       no  5,00Cell Free + HCMEC D3_line
      1658       ECIS        7       no  5,00Cell Free + HCMEC D3_line
      1659       ECIS        7       no  5,00Cell Free + HCMEC D3_line
      1660       ECIS        1       no 35,00Cell Free + HCMEC D3_line
      1661       ECIS        1       no 35,00Cell Free + HCMEC D3_line
      1662       ECIS        1       no 35,00Cell Free + HCMEC D3_line
      1663       ECIS        2       no 30,00Cell Free + HCMEC D3_line
      1664       ECIS        2       no 30,00Cell Free + HCMEC D3_line
      1665       ECIS        2       no 30,00Cell Free + HCMEC D3_line
      1666       ECIS        3       no 25,00Cell Free + HCMEC D3_line
      1667       ECIS        3       no 25,00Cell Free + HCMEC D3_line
      1668       ECIS        3       no 25,00Cell Free + HCMEC D3_line
      1669       ECIS        4       no 20,00Cell Free + HCMEC D3_line
      1670       ECIS        4       no 20,00Cell Free + HCMEC D3_line
      1671       ECIS        4       no 20,00Cell Free + HCMEC D3_line
      1672       ECIS        5       no 15,00Cell Free + HCMEC D3_line
      1673       ECIS        5       no 15,00Cell Free + HCMEC D3_line
      1674       ECIS        5       no 15,00Cell Free + HCMEC D3_line
      1675       ECIS        6       no 10,00Cell Free + HCMEC D3_line
      1676       ECIS        6       no 10,00Cell Free + HCMEC D3_line
      1677       ECIS        6       no 10,00Cell Free + HCMEC D3_line
      1678       ECIS        7       no  5,00Cell Free + HCMEC D3_line
      1679       ECIS        7       no  5,00Cell Free + HCMEC D3_line
      1680       ECIS        7       no  5,00Cell Free + HCMEC D3_line
      1681       ECIS        1       no 35,00Cell Free + HCMEC D3_line
      1682       ECIS        1       no 35,00Cell Free + HCMEC D3_line
      1683       ECIS        1       no 35,00Cell Free + HCMEC D3_line
      1684       ECIS        2       no 30,00Cell Free + HCMEC D3_line
      1685       ECIS        2       no 30,00Cell Free + HCMEC D3_line
      1686       ECIS        2       no 30,00Cell Free + HCMEC D3_line
      1687       ECIS        3       no 25,00Cell Free + HCMEC D3_line
      1688       ECIS        3       no 25,00Cell Free + HCMEC D3_line
      1689       ECIS        3       no 25,00Cell Free + HCMEC D3_line
      1690       ECIS        4       no 20,00Cell Free + HCMEC D3_line
      1691       ECIS        4       no 20,00Cell Free + HCMEC D3_line
      1692       ECIS        4       no 20,00Cell Free + HCMEC D3_line
      1693       ECIS        5       no 15,00Cell Free + HCMEC D3_line
      1694       ECIS        5       no 15,00Cell Free + HCMEC D3_line
      1695       ECIS        5       no 15,00Cell Free + HCMEC D3_line
      1696       ECIS        6       no 10,00Cell Free + HCMEC D3_line
      1697       ECIS        6       no 10,00Cell Free + HCMEC D3_line
      1698       ECIS        6       no 10,00Cell Free + HCMEC D3_line
      1699       ECIS        7       no  5,00Cell Free + HCMEC D3_line
      1700       ECIS        7       no  5,00Cell Free + HCMEC D3_line
      1701       ECIS        7       no  5,00Cell Free + HCMEC D3_line
      1702       ECIS        1       no 35,00Cell Free + HCMEC D3_line
      1703       ECIS        1       no 35,00Cell Free + HCMEC D3_line
      1704       ECIS        1       no 35,00Cell Free + HCMEC D3_line
      1705       ECIS        2       no 30,00Cell Free + HCMEC D3_line
      1706       ECIS        2       no 30,00Cell Free + HCMEC D3_line
      1707       ECIS        2       no 30,00Cell Free + HCMEC D3_line
      1708       ECIS        3       no 25,00Cell Free + HCMEC D3_line
      1709       ECIS        3       no 25,00Cell Free + HCMEC D3_line
      1710       ECIS        3       no 25,00Cell Free + HCMEC D3_line
      1711       ECIS        4       no 20,00Cell Free + HCMEC D3_line
      1712       ECIS        4       no 20,00Cell Free + HCMEC D3_line
      1713       ECIS        4       no 20,00Cell Free + HCMEC D3_line
      1714       ECIS        5       no 15,00Cell Free + HCMEC D3_line
      1715       ECIS        5       no 15,00Cell Free + HCMEC D3_line
      1716       ECIS        5       no 15,00Cell Free + HCMEC D3_line
      1717       ECIS        6       no 10,00Cell Free + HCMEC D3_line
      1718       ECIS        6       no 10,00Cell Free + HCMEC D3_line
      1719       ECIS        6       no 10,00Cell Free + HCMEC D3_line
      1720       ECIS        7       no  5,00Cell Free + HCMEC D3_line
      1721       ECIS        7       no  5,00Cell Free + HCMEC D3_line
      1722       ECIS        7       no  5,00Cell Free + HCMEC D3_line
      1723       ECIS        1       no 35,00Cell Free + HCMEC D3_line
      1724       ECIS        1       no 35,00Cell Free + HCMEC D3_line
      1725       ECIS        1       no 35,00Cell Free + HCMEC D3_line
      1726       ECIS        2       no 30,00Cell Free + HCMEC D3_line
      1727       ECIS        2       no 30,00Cell Free + HCMEC D3_line
      1728       ECIS        2       no 30,00Cell Free + HCMEC D3_line
      1729       ECIS        3       no 25,00Cell Free + HCMEC D3_line
      1730       ECIS        3       no 25,00Cell Free + HCMEC D3_line
      1731       ECIS        3       no 25,00Cell Free + HCMEC D3_line
      1732       ECIS        4       no 20,00Cell Free + HCMEC D3_line
      1733       ECIS        4       no 20,00Cell Free + HCMEC D3_line
      1734       ECIS        4       no 20,00Cell Free + HCMEC D3_line
      1735       ECIS        5       no 15,00Cell Free + HCMEC D3_line
      1736       ECIS        5       no 15,00Cell Free + HCMEC D3_line
      1737       ECIS        5       no 15,00Cell Free + HCMEC D3_line
      1738       ECIS        6       no 10,00Cell Free + HCMEC D3_line
      1739       ECIS        6       no 10,00Cell Free + HCMEC D3_line
      1740       ECIS        6       no 10,00Cell Free + HCMEC D3_line
      1741       ECIS        7       no  5,00Cell Free + HCMEC D3_line
      1742       ECIS        7       no  5,00Cell Free + HCMEC D3_line
      1743       ECIS        7       no  5,00Cell Free + HCMEC D3_line
      1744       ECIS        1       no 35,00Cell Free + HCMEC D3_line
      1745       ECIS        1       no 35,00Cell Free + HCMEC D3_line
      1746       ECIS        1       no 35,00Cell Free + HCMEC D3_line
      1747       ECIS        2       no 30,00Cell Free + HCMEC D3_line
      1748       ECIS        2       no 30,00Cell Free + HCMEC D3_line
      1749       ECIS        2       no 30,00Cell Free + HCMEC D3_line
      1750       ECIS        3       no 25,00Cell Free + HCMEC D3_line
      1751       ECIS        3       no 25,00Cell Free + HCMEC D3_line
      1752       ECIS        3       no 25,00Cell Free + HCMEC D3_line
      1753       ECIS        4       no 20,00Cell Free + HCMEC D3_line
      1754       ECIS        4       no 20,00Cell Free + HCMEC D3_line
      1755       ECIS        4       no 20,00Cell Free + HCMEC D3_line
      1756       ECIS        5       no 15,00Cell Free + HCMEC D3_line
      1757       ECIS        5       no 15,00Cell Free + HCMEC D3_line
      1758       ECIS        5       no 15,00Cell Free + HCMEC D3_line
      1759       ECIS        6       no 10,00Cell Free + HCMEC D3_line
      1760       ECIS        6       no 10,00Cell Free + HCMEC D3_line
      1761       ECIS        6       no 10,00Cell Free + HCMEC D3_line
      1762       ECIS        7       no  5,00Cell Free + HCMEC D3_line
      1763       ECIS        7       no  5,00Cell Free + HCMEC D3_line
      1764       ECIS        7       no  5,00Cell Free + HCMEC D3_line
      1765       ECIS        1       no 35,00Cell Free + HCMEC D3_line
      1766       ECIS        1       no 35,00Cell Free + HCMEC D3_line
      1767       ECIS        1       no 35,00Cell Free + HCMEC D3_line
      1768       ECIS        2       no 30,00Cell Free + HCMEC D3_line
      1769       ECIS        2       no 30,00Cell Free + HCMEC D3_line
      1770       ECIS        2       no 30,00Cell Free + HCMEC D3_line
      1771       ECIS        3       no 25,00Cell Free + HCMEC D3_line
      1772       ECIS        3       no 25,00Cell Free + HCMEC D3_line
      1773       ECIS        3       no 25,00Cell Free + HCMEC D3_line
      1774       ECIS        4       no 20,00Cell Free + HCMEC D3_line
      1775       ECIS        4       no 20,00Cell Free + HCMEC D3_line
      1776       ECIS        4       no 20,00Cell Free + HCMEC D3_line
      1777       ECIS        5       no 15,00Cell Free + HCMEC D3_line
      1778       ECIS        5       no 15,00Cell Free + HCMEC D3_line
      1779       ECIS        5       no 15,00Cell Free + HCMEC D3_line
      1780       ECIS        6       no 10,00Cell Free + HCMEC D3_line
      1781       ECIS        6       no 10,00Cell Free + HCMEC D3_line
      1782       ECIS        6       no 10,00Cell Free + HCMEC D3_line
      1783       ECIS        7       no  5,00Cell Free + HCMEC D3_line
      1784       ECIS        7       no  5,00Cell Free + HCMEC D3_line
      1785       ECIS        7       no  5,00Cell Free + HCMEC D3_line
      1786       ECIS        1       no 35,00Cell Free + HCMEC D3_line
      1787       ECIS        1       no 35,00Cell Free + HCMEC D3_line
      1788       ECIS        1       no 35,00Cell Free + HCMEC D3_line
      1789       ECIS        2       no 30,00Cell Free + HCMEC D3_line
      1790       ECIS        2       no 30,00Cell Free + HCMEC D3_line
      1791       ECIS        2       no 30,00Cell Free + HCMEC D3_line
      1792       ECIS        3       no 25,00Cell Free + HCMEC D3_line
      1793       ECIS        3       no 25,00Cell Free + HCMEC D3_line
      1794       ECIS        3       no 25,00Cell Free + HCMEC D3_line
      1795       ECIS        4       no 20,00Cell Free + HCMEC D3_line
      1796       ECIS        4       no 20,00Cell Free + HCMEC D3_line
      1797       ECIS        4       no 20,00Cell Free + HCMEC D3_line
      1798       ECIS        5       no 15,00Cell Free + HCMEC D3_line
      1799       ECIS        5       no 15,00Cell Free + HCMEC D3_line
      1800       ECIS        5       no 15,00Cell Free + HCMEC D3_line
      1801       ECIS        6       no 10,00Cell Free + HCMEC D3_line
      1802       ECIS        6       no 10,00Cell Free + HCMEC D3_line
      1803       ECIS        6       no 10,00Cell Free + HCMEC D3_line
      1804       ECIS        7       no  5,00Cell Free + HCMEC D3_line
      1805       ECIS        7       no  5,00Cell Free + HCMEC D3_line
      1806       ECIS        7       no  5,00Cell Free + HCMEC D3_line
      1807       ECIS        1       no 35,00Cell Free + HCMEC D3_line
      1808       ECIS        1       no 35,00Cell Free + HCMEC D3_line
      1809       ECIS        1       no 35,00Cell Free + HCMEC D3_line
      1810       ECIS        2       no 30,00Cell Free + HCMEC D3_line
      1811       ECIS        2       no 30,00Cell Free + HCMEC D3_line
      1812       ECIS        2       no 30,00Cell Free + HCMEC D3_line
      1813       ECIS        3       no 25,00Cell Free + HCMEC D3_line
      1814       ECIS        3       no 25,00Cell Free + HCMEC D3_line
      1815       ECIS        3       no 25,00Cell Free + HCMEC D3_line
      1816       ECIS        4       no 20,00Cell Free + HCMEC D3_line
      1817       ECIS        4       no 20,00Cell Free + HCMEC D3_line
      1818       ECIS        4       no 20,00Cell Free + HCMEC D3_line
      1819       ECIS        5       no 15,00Cell Free + HCMEC D3_line
      1820       ECIS        5       no 15,00Cell Free + HCMEC D3_line
      1821       ECIS        5       no 15,00Cell Free + HCMEC D3_line
      1822       ECIS        6       no 10,00Cell Free + HCMEC D3_line
      1823       ECIS        6       no 10,00Cell Free + HCMEC D3_line
      1824       ECIS        6       no 10,00Cell Free + HCMEC D3_line
      1825       ECIS        7       no  5,00Cell Free + HCMEC D3_line
      1826       ECIS        7       no  5,00Cell Free + HCMEC D3_line
      1827       ECIS        7       no  5,00Cell Free + HCMEC D3_line
      1828       ECIS        1       no 35,00Cell Free + HCMEC D3_line
      1829       ECIS        1       no 35,00Cell Free + HCMEC D3_line
      1830       ECIS        1       no 35,00Cell Free + HCMEC D3_line
      1831       ECIS        2       no 30,00Cell Free + HCMEC D3_line
      1832       ECIS        2       no 30,00Cell Free + HCMEC D3_line
      1833       ECIS        2       no 30,00Cell Free + HCMEC D3_line
      1834       ECIS        3       no 25,00Cell Free + HCMEC D3_line
      1835       ECIS        3       no 25,00Cell Free + HCMEC D3_line
      1836       ECIS        3       no 25,00Cell Free + HCMEC D3_line
      1837       ECIS        4       no 20,00Cell Free + HCMEC D3_line
      1838       ECIS        4       no 20,00Cell Free + HCMEC D3_line
      1839       ECIS        4       no 20,00Cell Free + HCMEC D3_line
      1840       ECIS        5       no 15,00Cell Free + HCMEC D3_line
      1841       ECIS        5       no 15,00Cell Free + HCMEC D3_line
      1842       ECIS        5       no 15,00Cell Free + HCMEC D3_line
      1843       ECIS        6       no 10,00Cell Free + HCMEC D3_line
      1844       ECIS        6       no 10,00Cell Free + HCMEC D3_line
      1845       ECIS        6       no 10,00Cell Free + HCMEC D3_line
      1846       ECIS        7       no  5,00Cell Free + HCMEC D3_line
      1847       ECIS        7       no  5,00Cell Free + HCMEC D3_line
      1848       ECIS        7       no  5,00Cell Free + HCMEC D3_line
      1849       ECIS        1       no 35,00Cell Free + HCMEC D3_line
      1850       ECIS        1       no 35,00Cell Free + HCMEC D3_line
      1851       ECIS        1       no 35,00Cell Free + HCMEC D3_line
      1852       ECIS        2       no 30,00Cell Free + HCMEC D3_line
      1853       ECIS        2       no 30,00Cell Free + HCMEC D3_line
      1854       ECIS        2       no 30,00Cell Free + HCMEC D3_line
      1855       ECIS        3       no 25,00Cell Free + HCMEC D3_line
      1856       ECIS        3       no 25,00Cell Free + HCMEC D3_line
      1857       ECIS        3       no 25,00Cell Free + HCMEC D3_line
      1858       ECIS        4       no 20,00Cell Free + HCMEC D3_line
      1859       ECIS        4       no 20,00Cell Free + HCMEC D3_line
      1860       ECIS        4       no 20,00Cell Free + HCMEC D3_line
      1861       ECIS        5       no 15,00Cell Free + HCMEC D3_line
      1862       ECIS        5       no 15,00Cell Free + HCMEC D3_line
      1863       ECIS        5       no 15,00Cell Free + HCMEC D3_line
      1864       ECIS        6       no 10,00Cell Free + HCMEC D3_line
      1865       ECIS        6       no 10,00Cell Free + HCMEC D3_line
      1866       ECIS        6       no 10,00Cell Free + HCMEC D3_line
      1867       ECIS        7       no  5,00Cell Free + HCMEC D3_line
      1868       ECIS        7       no  5,00Cell Free + HCMEC D3_line
      1869       ECIS        7       no  5,00Cell Free + HCMEC D3_line
      1870       ECIS        1       no 35,00Cell Free + HCMEC D3_line
      1871       ECIS        1       no 35,00Cell Free + HCMEC D3_line
      1872       ECIS        1       no 35,00Cell Free + HCMEC D3_line
      1873       ECIS        2       no 30,00Cell Free + HCMEC D3_line
      1874       ECIS        2       no 30,00Cell Free + HCMEC D3_line
      1875       ECIS        2       no 30,00Cell Free + HCMEC D3_line
      1876       ECIS        3       no 25,00Cell Free + HCMEC D3_line
      1877       ECIS        3       no 25,00Cell Free + HCMEC D3_line
      1878       ECIS        3       no 25,00Cell Free + HCMEC D3_line
      1879       ECIS        4       no 20,00Cell Free + HCMEC D3_line
      1880       ECIS        4       no 20,00Cell Free + HCMEC D3_line
      1881       ECIS        4       no 20,00Cell Free + HCMEC D3_line
      1882       ECIS        5       no 15,00Cell Free + HCMEC D3_line
      1883       ECIS        5       no 15,00Cell Free + HCMEC D3_line
      1884       ECIS        5       no 15,00Cell Free + HCMEC D3_line
      1885       ECIS        6       no 10,00Cell Free + HCMEC D3_line
      1886       ECIS        6       no 10,00Cell Free + HCMEC D3_line
      1887       ECIS        6       no 10,00Cell Free + HCMEC D3_line
      1888       ECIS        7       no  5,00Cell Free + HCMEC D3_line
      1889       ECIS        7       no  5,00Cell Free + HCMEC D3_line
      1890       ECIS        7       no  5,00Cell Free + HCMEC D3_line
      1891       ECIS        1       no 35,00Cell Free + HCMEC D3_line
      1892       ECIS        1       no 35,00Cell Free + HCMEC D3_line
      1893       ECIS        1       no 35,00Cell Free + HCMEC D3_line
      1894       ECIS        2       no 30,00Cell Free + HCMEC D3_line
      1895       ECIS        2       no 30,00Cell Free + HCMEC D3_line
      1896       ECIS        2       no 30,00Cell Free + HCMEC D3_line
      1897       ECIS        3       no 25,00Cell Free + HCMEC D3_line
      1898       ECIS        3       no 25,00Cell Free + HCMEC D3_line
      1899       ECIS        3       no 25,00Cell Free + HCMEC D3_line
      1900       ECIS        4       no 20,00Cell Free + HCMEC D3_line
      1901       ECIS        4       no 20,00Cell Free + HCMEC D3_line
      1902       ECIS        4       no 20,00Cell Free + HCMEC D3_line
      1903       ECIS        5       no 15,00Cell Free + HCMEC D3_line
      1904       ECIS        5       no 15,00Cell Free + HCMEC D3_line
      1905       ECIS        5       no 15,00Cell Free + HCMEC D3_line
      1906       ECIS        6       no 10,00Cell Free + HCMEC D3_line
      1907       ECIS        6       no 10,00Cell Free + HCMEC D3_line
      1908       ECIS        6       no 10,00Cell Free + HCMEC D3_line
      1909       ECIS        7       no  5,00Cell Free + HCMEC D3_line
      1910       ECIS        7       no  5,00Cell Free + HCMEC D3_line
      1911       ECIS        7       no  5,00Cell Free + HCMEC D3_line
      1912       ECIS        1       no 35,00Cell Free + HCMEC D3_line
      1913       ECIS        1       no 35,00Cell Free + HCMEC D3_line
      1914       ECIS        1       no 35,00Cell Free + HCMEC D3_line
      1915       ECIS        2       no 30,00Cell Free + HCMEC D3_line
      1916       ECIS        2       no 30,00Cell Free + HCMEC D3_line
      1917       ECIS        2       no 30,00Cell Free + HCMEC D3_line
      1918       ECIS        3       no 25,00Cell Free + HCMEC D3_line
      1919       ECIS        3       no 25,00Cell Free + HCMEC D3_line
      1920       ECIS        3       no 25,00Cell Free + HCMEC D3_line
      1921       ECIS        4       no 20,00Cell Free + HCMEC D3_line
      1922       ECIS        4       no 20,00Cell Free + HCMEC D3_line
      1923       ECIS        4       no 20,00Cell Free + HCMEC D3_line
      1924       ECIS        5       no 15,00Cell Free + HCMEC D3_line
      1925       ECIS        5       no 15,00Cell Free + HCMEC D3_line
      1926       ECIS        5       no 15,00Cell Free + HCMEC D3_line
      1927       ECIS        6       no 10,00Cell Free + HCMEC D3_line
      1928       ECIS        6       no 10,00Cell Free + HCMEC D3_line
      1929       ECIS        6       no 10,00Cell Free + HCMEC D3_line
      1930       ECIS        7       no  5,00Cell Free + HCMEC D3_line
      1931       ECIS        7       no  5,00Cell Free + HCMEC D3_line
      1932       ECIS        7       no  5,00Cell Free + HCMEC D3_line
      1933       ECIS        1       no 35,00Cell Free + HCMEC D3_line
      1934       ECIS        1       no 35,00Cell Free + HCMEC D3_line
      1935       ECIS        1       no 35,00Cell Free + HCMEC D3_line
      1936       ECIS        2       no 30,00Cell Free + HCMEC D3_line
      1937       ECIS        2       no 30,00Cell Free + HCMEC D3_line
      1938       ECIS        2       no 30,00Cell Free + HCMEC D3_line
      1939       ECIS        3       no 25,00Cell Free + HCMEC D3_line
      1940       ECIS        3       no 25,00Cell Free + HCMEC D3_line
      1941       ECIS        3       no 25,00Cell Free + HCMEC D3_line
      1942       ECIS        4       no 20,00Cell Free + HCMEC D3_line
      1943       ECIS        4       no 20,00Cell Free + HCMEC D3_line
      1944       ECIS        4       no 20,00Cell Free + HCMEC D3_line
      1945       ECIS        5       no 15,00Cell Free + HCMEC D3_line
      1946       ECIS        5       no 15,00Cell Free + HCMEC D3_line
      1947       ECIS        5       no 15,00Cell Free + HCMEC D3_line
      1948       ECIS        6       no 10,00Cell Free + HCMEC D3_line
      1949       ECIS        6       no 10,00Cell Free + HCMEC D3_line
      1950       ECIS        6       no 10,00Cell Free + HCMEC D3_line
      1951       ECIS        7       no  5,00Cell Free + HCMEC D3_line
      1952       ECIS        7       no  5,00Cell Free + HCMEC D3_line
      1953       ECIS        7       no  5,00Cell Free + HCMEC D3_line
      1954       ECIS        1       no 35,00Cell Free + HCMEC D3_line
      1955       ECIS        1       no 35,00Cell Free + HCMEC D3_line
      1956       ECIS        1       no 35,00Cell Free + HCMEC D3_line
      1957       ECIS        2       no 30,00Cell Free + HCMEC D3_line
      1958       ECIS        2       no 30,00Cell Free + HCMEC D3_line
      1959       ECIS        2       no 30,00Cell Free + HCMEC D3_line
      1960       ECIS        3       no 25,00Cell Free + HCMEC D3_line
      1961       ECIS        3       no 25,00Cell Free + HCMEC D3_line
      1962       ECIS        3       no 25,00Cell Free + HCMEC D3_line
      1963       ECIS        4       no 20,00Cell Free + HCMEC D3_line
      1964       ECIS        4       no 20,00Cell Free + HCMEC D3_line
      1965       ECIS        4       no 20,00Cell Free + HCMEC D3_line
      1966       ECIS        5       no 15,00Cell Free + HCMEC D3_line
      1967       ECIS        5       no 15,00Cell Free + HCMEC D3_line
      1968       ECIS        5       no 15,00Cell Free + HCMEC D3_line
      1969       ECIS        6       no 10,00Cell Free + HCMEC D3_line
      1970       ECIS        6       no 10,00Cell Free + HCMEC D3_line
      1971       ECIS        6       no 10,00Cell Free + HCMEC D3_line
      1972       ECIS        7       no  5,00Cell Free + HCMEC D3_line
      1973       ECIS        7       no  5,00Cell Free + HCMEC D3_line
      1974       ECIS        7       no  5,00Cell Free + HCMEC D3_line
      1975       ECIS        1       no 35,00Cell Free + HCMEC D3_line
      1976       ECIS        1       no 35,00Cell Free + HCMEC D3_line
      1977       ECIS        1       no 35,00Cell Free + HCMEC D3_line
      1978       ECIS        2       no 30,00Cell Free + HCMEC D3_line
      1979       ECIS        2       no 30,00Cell Free + HCMEC D3_line
      1980       ECIS        2       no 30,00Cell Free + HCMEC D3_line
      1981       ECIS        3       no 25,00Cell Free + HCMEC D3_line
      1982       ECIS        3       no 25,00Cell Free + HCMEC D3_line
      1983       ECIS        3       no 25,00Cell Free + HCMEC D3_line
      1984       ECIS        4       no 20,00Cell Free + HCMEC D3_line
      1985       ECIS        4       no 20,00Cell Free + HCMEC D3_line
      1986       ECIS        4       no 20,00Cell Free + HCMEC D3_line
      1987       ECIS        5       no 15,00Cell Free + HCMEC D3_line
      1988       ECIS        5       no 15,00Cell Free + HCMEC D3_line
      1989       ECIS        5       no 15,00Cell Free + HCMEC D3_line
      1990       ECIS        6       no 10,00Cell Free + HCMEC D3_line
      1991       ECIS        6       no 10,00Cell Free + HCMEC D3_line
      1992       ECIS        6       no 10,00Cell Free + HCMEC D3_line
      1993       ECIS        7       no  5,00Cell Free + HCMEC D3_line
      1994       ECIS        7       no  5,00Cell Free + HCMEC D3_line
      1995       ECIS        7       no  5,00Cell Free + HCMEC D3_line
      1996       ECIS        1       no 35,00Cell Free + HCMEC D3_line
      1997       ECIS        1       no 35,00Cell Free + HCMEC D3_line
      1998       ECIS        1       no 35,00Cell Free + HCMEC D3_line
      1999       ECIS        2       no 30,00Cell Free + HCMEC D3_line
      2000       ECIS        2       no 30,00Cell Free + HCMEC D3_line
      2001       ECIS        2       no 30,00Cell Free + HCMEC D3_line
      2002       ECIS        3       no 25,00Cell Free + HCMEC D3_line
      2003       ECIS        3       no 25,00Cell Free + HCMEC D3_line
      2004       ECIS        3       no 25,00Cell Free + HCMEC D3_line
      2005       ECIS        4       no 20,00Cell Free + HCMEC D3_line
      2006       ECIS        4       no 20,00Cell Free + HCMEC D3_line
      2007       ECIS        4       no 20,00Cell Free + HCMEC D3_line
      2008       ECIS        5       no 15,00Cell Free + HCMEC D3_line
      2009       ECIS        5       no 15,00Cell Free + HCMEC D3_line
      2010       ECIS        5       no 15,00Cell Free + HCMEC D3_line
      2011       ECIS        6       no 10,00Cell Free + HCMEC D3_line
      2012       ECIS        6       no 10,00Cell Free + HCMEC D3_line
      2013       ECIS        6       no 10,00Cell Free + HCMEC D3_line
      2014       ECIS        7       no  5,00Cell Free + HCMEC D3_line
      2015       ECIS        7       no  5,00Cell Free + HCMEC D3_line
      2016       ECIS        7       no  5,00Cell Free + HCMEC D3_line
      2017       ECIS        1       no 35,00Cell Free + HCMEC D3_line
      2018       ECIS        1       no 35,00Cell Free + HCMEC D3_line
      2019       ECIS        1       no 35,00Cell Free + HCMEC D3_line
      2020       ECIS        2       no 30,00Cell Free + HCMEC D3_line
      2021       ECIS        2       no 30,00Cell Free + HCMEC D3_line
      2022       ECIS        2       no 30,00Cell Free + HCMEC D3_line
      2023       ECIS        3       no 25,00Cell Free + HCMEC D3_line
      2024       ECIS        3       no 25,00Cell Free + HCMEC D3_line
      2025       ECIS        3       no 25,00Cell Free + HCMEC D3_line
      2026       ECIS        4       no 20,00Cell Free + HCMEC D3_line
      2027       ECIS        4       no 20,00Cell Free + HCMEC D3_line
      2028       ECIS        4       no 20,00Cell Free + HCMEC D3_line
      2029       ECIS        5       no 15,00Cell Free + HCMEC D3_line
      2030       ECIS        5       no 15,00Cell Free + HCMEC D3_line
      2031       ECIS        5       no 15,00Cell Free + HCMEC D3_line
      2032       ECIS        6       no 10,00Cell Free + HCMEC D3_line
      2033       ECIS        6       no 10,00Cell Free + HCMEC D3_line
      2034       ECIS        6       no 10,00Cell Free + HCMEC D3_line
      2035       ECIS        7       no  5,00Cell Free + HCMEC D3_line
      2036       ECIS        7       no  5,00Cell Free + HCMEC D3_line
      2037       ECIS        7       no  5,00Cell Free + HCMEC D3_line
      2038       ECIS        1       no 35,00Cell Free + HCMEC D3_line
      2039       ECIS        1       no 35,00Cell Free + HCMEC D3_line
      2040       ECIS        1       no 35,00Cell Free + HCMEC D3_line
      2041       ECIS        2       no 30,00Cell Free + HCMEC D3_line
      2042       ECIS        2       no 30,00Cell Free + HCMEC D3_line
      2043       ECIS        2       no 30,00Cell Free + HCMEC D3_line
      2044       ECIS        3       no 25,00Cell Free + HCMEC D3_line
      2045       ECIS        3       no 25,00Cell Free + HCMEC D3_line
      2046       ECIS        3       no 25,00Cell Free + HCMEC D3_line
      2047       ECIS        4       no 20,00Cell Free + HCMEC D3_line
      2048       ECIS        4       no 20,00Cell Free + HCMEC D3_line
      2049       ECIS        4       no 20,00Cell Free + HCMEC D3_line
      2050       ECIS        5       no 15,00Cell Free + HCMEC D3_line
      2051       ECIS        5       no 15,00Cell Free + HCMEC D3_line
      2052       ECIS        5       no 15,00Cell Free + HCMEC D3_line
      2053       ECIS        6       no 10,00Cell Free + HCMEC D3_line
      2054       ECIS        6       no 10,00Cell Free + HCMEC D3_line
      2055       ECIS        6       no 10,00Cell Free + HCMEC D3_line
      2056       ECIS        7       no  5,00Cell Free + HCMEC D3_line
      2057       ECIS        7       no  5,00Cell Free + HCMEC D3_line
      2058       ECIS        7       no  5,00Cell Free + HCMEC D3_line
      2059       ECIS        1       no 35,00Cell Free + HCMEC D3_line
      2060       ECIS        1       no 35,00Cell Free + HCMEC D3_line
      2061       ECIS        1       no 35,00Cell Free + HCMEC D3_line
      2062       ECIS        2       no 30,00Cell Free + HCMEC D3_line
      2063       ECIS        2       no 30,00Cell Free + HCMEC D3_line
      2064       ECIS        2       no 30,00Cell Free + HCMEC D3_line
      2065       ECIS        3       no 25,00Cell Free + HCMEC D3_line
      2066       ECIS        3       no 25,00Cell Free + HCMEC D3_line
      2067       ECIS        3       no 25,00Cell Free + HCMEC D3_line
      2068       ECIS        4       no 20,00Cell Free + HCMEC D3_line
      2069       ECIS        4       no 20,00Cell Free + HCMEC D3_line
      2070       ECIS        4       no 20,00Cell Free + HCMEC D3_line
      2071       ECIS        5       no 15,00Cell Free + HCMEC D3_line
      2072       ECIS        5       no 15,00Cell Free + HCMEC D3_line
      2073       ECIS        5       no 15,00Cell Free + HCMEC D3_line
      2074       ECIS        6       no 10,00Cell Free + HCMEC D3_line
      2075       ECIS        6       no 10,00Cell Free + HCMEC D3_line
      2076       ECIS        6       no 10,00Cell Free + HCMEC D3_line
      2077       ECIS        7       no  5,00Cell Free + HCMEC D3_line
      2078       ECIS        7       no  5,00Cell Free + HCMEC D3_line
      2079       ECIS        7       no  5,00Cell Free + HCMEC D3_line
      2080       ECIS        1       no 35,00Cell Free + HCMEC D3_line
      2081       ECIS        1       no 35,00Cell Free + HCMEC D3_line
      2082       ECIS        1       no 35,00Cell Free + HCMEC D3_line
      2083       ECIS        2       no 30,00Cell Free + HCMEC D3_line
      2084       ECIS        2       no 30,00Cell Free + HCMEC D3_line
      2085       ECIS        2       no 30,00Cell Free + HCMEC D3_line
      2086       ECIS        3       no 25,00Cell Free + HCMEC D3_line
      2087       ECIS        3       no 25,00Cell Free + HCMEC D3_line
      2088       ECIS        3       no 25,00Cell Free + HCMEC D3_line
      2089       ECIS        4       no 20,00Cell Free + HCMEC D3_line
      2090       ECIS        4       no 20,00Cell Free + HCMEC D3_line
      2091       ECIS        4       no 20,00Cell Free + HCMEC D3_line
      2092       ECIS        5       no 15,00Cell Free + HCMEC D3_line
      2093       ECIS        5       no 15,00Cell Free + HCMEC D3_line
      2094       ECIS        5       no 15,00Cell Free + HCMEC D3_line
      2095       ECIS        6       no 10,00Cell Free + HCMEC D3_line
      2096       ECIS        6       no 10,00Cell Free + HCMEC D3_line
      2097       ECIS        6       no 10,00Cell Free + HCMEC D3_line
      2098       ECIS        7       no  5,00Cell Free + HCMEC D3_line
      2099       ECIS        7       no  5,00Cell Free + HCMEC D3_line
      2100       ECIS        7       no  5,00Cell Free + HCMEC D3_line
      2101       ECIS        1       no 35,00Cell Free + HCMEC D3_line
      2102       ECIS        1       no 35,00Cell Free + HCMEC D3_line
      2103       ECIS        1       no 35,00Cell Free + HCMEC D3_line
      2104       ECIS        2       no 30,00Cell Free + HCMEC D3_line
      2105       ECIS        2       no 30,00Cell Free + HCMEC D3_line
      2106       ECIS        2       no 30,00Cell Free + HCMEC D3_line
      2107       ECIS        3       no 25,00Cell Free + HCMEC D3_line
      2108       ECIS        3       no 25,00Cell Free + HCMEC D3_line
      2109       ECIS        3       no 25,00Cell Free + HCMEC D3_line
      2110       ECIS        4       no 20,00Cell Free + HCMEC D3_line
      2111       ECIS        4       no 20,00Cell Free + HCMEC D3_line
      2112       ECIS        4       no 20,00Cell Free + HCMEC D3_line
      2113       ECIS        5       no 15,00Cell Free + HCMEC D3_line
      2114       ECIS        5       no 15,00Cell Free + HCMEC D3_line
      2115       ECIS        5       no 15,00Cell Free + HCMEC D3_line
      2116       ECIS        6       no 10,00Cell Free + HCMEC D3_line
      2117       ECIS        6       no 10,00Cell Free + HCMEC D3_line
      2118       ECIS        6       no 10,00Cell Free + HCMEC D3_line
      2119       ECIS        7       no  5,00Cell Free + HCMEC D3_line
      2120       ECIS        7       no  5,00Cell Free + HCMEC D3_line
      2121       ECIS        7       no  5,00Cell Free + HCMEC D3_line
      2122       ECIS        1       no 35,00Cell Free + HCMEC D3_line
      2123       ECIS        1       no 35,00Cell Free + HCMEC D3_line
      2124       ECIS        1       no 35,00Cell Free + HCMEC D3_line
      2125       ECIS        2       no 30,00Cell Free + HCMEC D3_line
      2126       ECIS        2       no 30,00Cell Free + HCMEC D3_line
      2127       ECIS        2       no 30,00Cell Free + HCMEC D3_line
      2128       ECIS        3       no 25,00Cell Free + HCMEC D3_line
      2129       ECIS        3       no 25,00Cell Free + HCMEC D3_line
      2130       ECIS        3       no 25,00Cell Free + HCMEC D3_line
      2131       ECIS        4       no 20,00Cell Free + HCMEC D3_line
      2132       ECIS        4       no 20,00Cell Free + HCMEC D3_line
      2133       ECIS        4       no 20,00Cell Free + HCMEC D3_line
      2134       ECIS        5       no 15,00Cell Free + HCMEC D3_line
      2135       ECIS        5       no 15,00Cell Free + HCMEC D3_line
      2136       ECIS        5       no 15,00Cell Free + HCMEC D3_line
      2137       ECIS        6       no 10,00Cell Free + HCMEC D3_line
      2138       ECIS        6       no 10,00Cell Free + HCMEC D3_line
      2139       ECIS        6       no 10,00Cell Free + HCMEC D3_line
      2140       ECIS        7       no  5,00Cell Free + HCMEC D3_line
      2141       ECIS        7       no  5,00Cell Free + HCMEC D3_line
      2142       ECIS        7       no  5,00Cell Free + HCMEC D3_line
      2143       ECIS        1       no 35,00Cell Free + HCMEC D3_line
      2144       ECIS        1       no 35,00Cell Free + HCMEC D3_line
      2145       ECIS        1       no 35,00Cell Free + HCMEC D3_line
      2146       ECIS        2       no 30,00Cell Free + HCMEC D3_line
      2147       ECIS        2       no 30,00Cell Free + HCMEC D3_line
      2148       ECIS        2       no 30,00Cell Free + HCMEC D3_line
      2149       ECIS        3       no 25,00Cell Free + HCMEC D3_line
      2150       ECIS        3       no 25,00Cell Free + HCMEC D3_line
      2151       ECIS        3       no 25,00Cell Free + HCMEC D3_line
      2152       ECIS        4       no 20,00Cell Free + HCMEC D3_line
      2153       ECIS        4       no 20,00Cell Free + HCMEC D3_line
      2154       ECIS        4       no 20,00Cell Free + HCMEC D3_line
      2155       ECIS        5       no 15,00Cell Free + HCMEC D3_line
      2156       ECIS        5       no 15,00Cell Free + HCMEC D3_line
      2157       ECIS        5       no 15,00Cell Free + HCMEC D3_line
      2158       ECIS        6       no 10,00Cell Free + HCMEC D3_line
      2159       ECIS        6       no 10,00Cell Free + HCMEC D3_line
      2160       ECIS        6       no 10,00Cell Free + HCMEC D3_line
      2161       ECIS        7       no  5,00Cell Free + HCMEC D3_line
      2162       ECIS        7       no  5,00Cell Free + HCMEC D3_line
      2163       ECIS        7       no  5,00Cell Free + HCMEC D3_line
      2164       ECIS        1       no 35,00Cell Free + HCMEC D3_line
      2165       ECIS        1       no 35,00Cell Free + HCMEC D3_line
      2166       ECIS        1       no 35,00Cell Free + HCMEC D3_line
      2167       ECIS        2       no 30,00Cell Free + HCMEC D3_line
      2168       ECIS        2       no 30,00Cell Free + HCMEC D3_line
      2169       ECIS        2       no 30,00Cell Free + HCMEC D3_line
      2170       ECIS        3       no 25,00Cell Free + HCMEC D3_line
      2171       ECIS        3       no 25,00Cell Free + HCMEC D3_line
      2172       ECIS        3       no 25,00Cell Free + HCMEC D3_line
      2173       ECIS        4       no 20,00Cell Free + HCMEC D3_line
      2174       ECIS        4       no 20,00Cell Free + HCMEC D3_line
      2175       ECIS        4       no 20,00Cell Free + HCMEC D3_line
      2176       ECIS        5       no 15,00Cell Free + HCMEC D3_line
      2177       ECIS        5       no 15,00Cell Free + HCMEC D3_line
      2178       ECIS        5       no 15,00Cell Free + HCMEC D3_line
      2179       ECIS        6       no 10,00Cell Free + HCMEC D3_line
      2180       ECIS        6       no 10,00Cell Free + HCMEC D3_line
      2181       ECIS        6       no 10,00Cell Free + HCMEC D3_line
      2182       ECIS        7       no  5,00Cell Free + HCMEC D3_line
      2183       ECIS        7       no  5,00Cell Free + HCMEC D3_line
      2184       ECIS        7       no  5,00Cell Free + HCMEC D3_line
      2185       ECIS        1       no 35,00Cell Free + HCMEC D3_line
      2186       ECIS        1       no 35,00Cell Free + HCMEC D3_line
      2187       ECIS        1       no 35,00Cell Free + HCMEC D3_line
      2188       ECIS        2       no 30,00Cell Free + HCMEC D3_line
      2189       ECIS        2       no 30,00Cell Free + HCMEC D3_line
      2190       ECIS        2       no 30,00Cell Free + HCMEC D3_line
      2191       ECIS        3       no 25,00Cell Free + HCMEC D3_line
      2192       ECIS        3       no 25,00Cell Free + HCMEC D3_line
      2193       ECIS        3       no 25,00Cell Free + HCMEC D3_line
      2194       ECIS        4       no 20,00Cell Free + HCMEC D3_line
      2195       ECIS        4       no 20,00Cell Free + HCMEC D3_line
      2196       ECIS        4       no 20,00Cell Free + HCMEC D3_line
      2197       ECIS        5       no 15,00Cell Free + HCMEC D3_line
      2198       ECIS        5       no 15,00Cell Free + HCMEC D3_line
      2199       ECIS        5       no 15,00Cell Free + HCMEC D3_line
      2200       ECIS        6       no 10,00Cell Free + HCMEC D3_line
      2201       ECIS        6       no 10,00Cell Free + HCMEC D3_line
      2202       ECIS        6       no 10,00Cell Free + HCMEC D3_line
      2203       ECIS        7       no  5,00Cell Free + HCMEC D3_line
      2204       ECIS        7       no  5,00Cell Free + HCMEC D3_line
      2205       ECIS        7       no  5,00Cell Free + HCMEC D3_line
      2206       ECIS        1       no 35,00Cell Free + HCMEC D3_line
      2207       ECIS        1       no 35,00Cell Free + HCMEC D3_line
      2208       ECIS        1       no 35,00Cell Free + HCMEC D3_line
      2209       ECIS        2       no 30,00Cell Free + HCMEC D3_line
      2210       ECIS        2       no 30,00Cell Free + HCMEC D3_line
      2211       ECIS        2       no 30,00Cell Free + HCMEC D3_line
      2212       ECIS        3       no 25,00Cell Free + HCMEC D3_line
      2213       ECIS        3       no 25,00Cell Free + HCMEC D3_line
      2214       ECIS        3       no 25,00Cell Free + HCMEC D3_line
      2215       ECIS        4       no 20,00Cell Free + HCMEC D3_line
      2216       ECIS        4       no 20,00Cell Free + HCMEC D3_line
      2217       ECIS        4       no 20,00Cell Free + HCMEC D3_line
      2218       ECIS        5       no 15,00Cell Free + HCMEC D3_line
      2219       ECIS        5       no 15,00Cell Free + HCMEC D3_line
      2220       ECIS        5       no 15,00Cell Free + HCMEC D3_line
      2221       ECIS        6       no 10,00Cell Free + HCMEC D3_line
      2222       ECIS        6       no 10,00Cell Free + HCMEC D3_line
      2223       ECIS        6       no 10,00Cell Free + HCMEC D3_line
      2224       ECIS        7       no  5,00Cell Free + HCMEC D3_line
      2225       ECIS        7       no  5,00Cell Free + HCMEC D3_line
      2226       ECIS        7       no  5,00Cell Free + HCMEC D3_line
      2227       ECIS        1       no 35,00Cell Free + HCMEC D3_line
      2228       ECIS        1       no 35,00Cell Free + HCMEC D3_line
      2229       ECIS        1       no 35,00Cell Free + HCMEC D3_line
      2230       ECIS        2       no 30,00Cell Free + HCMEC D3_line
      2231       ECIS        2       no 30,00Cell Free + HCMEC D3_line
      2232       ECIS        2       no 30,00Cell Free + HCMEC D3_line
      2233       ECIS        3       no 25,00Cell Free + HCMEC D3_line
      2234       ECIS        3       no 25,00Cell Free + HCMEC D3_line
      2235       ECIS        3       no 25,00Cell Free + HCMEC D3_line
      2236       ECIS        4       no 20,00Cell Free + HCMEC D3_line
      2237       ECIS        4       no 20,00Cell Free + HCMEC D3_line
      2238       ECIS        4       no 20,00Cell Free + HCMEC D3_line
      2239       ECIS        5       no 15,00Cell Free + HCMEC D3_line
      2240       ECIS        5       no 15,00Cell Free + HCMEC D3_line
      2241       ECIS        5       no 15,00Cell Free + HCMEC D3_line
      2242       ECIS        6       no 10,00Cell Free + HCMEC D3_line
      2243       ECIS        6       no 10,00Cell Free + HCMEC D3_line
      2244       ECIS        6       no 10,00Cell Free + HCMEC D3_line
      2245       ECIS        7       no  5,00Cell Free + HCMEC D3_line
      2246       ECIS        7       no  5,00Cell Free + HCMEC D3_line
      2247       ECIS        7       no  5,00Cell Free + HCMEC D3_line
      2248       ECIS        1       no 35,00Cell Free + HCMEC D3_line
      2249       ECIS        1       no 35,00Cell Free + HCMEC D3_line
      2250       ECIS        1       no 35,00Cell Free + HCMEC D3_line
      2251       ECIS        2       no 30,00Cell Free + HCMEC D3_line
      2252       ECIS        2       no 30,00Cell Free + HCMEC D3_line
      2253       ECIS        2       no 30,00Cell Free + HCMEC D3_line
      2254       ECIS        3       no 25,00Cell Free + HCMEC D3_line
      2255       ECIS        3       no 25,00Cell Free + HCMEC D3_line
      2256       ECIS        3       no 25,00Cell Free + HCMEC D3_line
      2257       ECIS        4       no 20,00Cell Free + HCMEC D3_line
      2258       ECIS        4       no 20,00Cell Free + HCMEC D3_line
      2259       ECIS        4       no 20,00Cell Free + HCMEC D3_line
      2260       ECIS        5       no 15,00Cell Free + HCMEC D3_line
      2261       ECIS        5       no 15,00Cell Free + HCMEC D3_line
      2262       ECIS        5       no 15,00Cell Free + HCMEC D3_line
      2263       ECIS        6       no 10,00Cell Free + HCMEC D3_line
      2264       ECIS        6       no 10,00Cell Free + HCMEC D3_line
      2265       ECIS        6       no 10,00Cell Free + HCMEC D3_line
      2266       ECIS        7       no  5,00Cell Free + HCMEC D3_line
      2267       ECIS        7       no  5,00Cell Free + HCMEC D3_line
      2268       ECIS        7       no  5,00Cell Free + HCMEC D3_line
      2269       ECIS        1       no 35,00Cell Free + HCMEC D3_line
      2270       ECIS        1       no 35,00Cell Free + HCMEC D3_line
      2271       ECIS        1       no 35,00Cell Free + HCMEC D3_line
      2272       ECIS        2       no 30,00Cell Free + HCMEC D3_line
      2273       ECIS        2       no 30,00Cell Free + HCMEC D3_line
      2274       ECIS        2       no 30,00Cell Free + HCMEC D3_line
      2275       ECIS        3       no 25,00Cell Free + HCMEC D3_line
      2276       ECIS        3       no 25,00Cell Free + HCMEC D3_line
      2277       ECIS        3       no 25,00Cell Free + HCMEC D3_line
      2278       ECIS        4       no 20,00Cell Free + HCMEC D3_line
      2279       ECIS        4       no 20,00Cell Free + HCMEC D3_line
      2280       ECIS        4       no 20,00Cell Free + HCMEC D3_line
      2281       ECIS        5       no 15,00Cell Free + HCMEC D3_line
      2282       ECIS        5       no 15,00Cell Free + HCMEC D3_line
      2283       ECIS        5       no 15,00Cell Free + HCMEC D3_line
      2284       ECIS        6       no 10,00Cell Free + HCMEC D3_line
      2285       ECIS        6       no 10,00Cell Free + HCMEC D3_line
      2286       ECIS        6       no 10,00Cell Free + HCMEC D3_line
      2287       ECIS        7       no  5,00Cell Free + HCMEC D3_line
      2288       ECIS        7       no  5,00Cell Free + HCMEC D3_line
      2289       ECIS        7       no  5,00Cell Free + HCMEC D3_line
      2290       ECIS        1       no 35,00Cell Free + HCMEC D3_line
      2291       ECIS        1       no 35,00Cell Free + HCMEC D3_line
      2292       ECIS        1       no 35,00Cell Free + HCMEC D3_line
      2293       ECIS        2       no 30,00Cell Free + HCMEC D3_line
      2294       ECIS        2       no 30,00Cell Free + HCMEC D3_line
      2295       ECIS        2       no 30,00Cell Free + HCMEC D3_line
      2296       ECIS        3       no 25,00Cell Free + HCMEC D3_line
      2297       ECIS        3       no 25,00Cell Free + HCMEC D3_line
      2298       ECIS        3       no 25,00Cell Free + HCMEC D3_line
      2299       ECIS        4       no 20,00Cell Free + HCMEC D3_line
      2300       ECIS        4       no 20,00Cell Free + HCMEC D3_line
      2301       ECIS        4       no 20,00Cell Free + HCMEC D3_line
      2302       ECIS        5       no 15,00Cell Free + HCMEC D3_line
      2303       ECIS        5       no 15,00Cell Free + HCMEC D3_line
      2304       ECIS        5       no 15,00Cell Free + HCMEC D3_line
      2305       ECIS        6       no 10,00Cell Free + HCMEC D3_line
      2306       ECIS        6       no 10,00Cell Free + HCMEC D3_line
      2307       ECIS        6       no 10,00Cell Free + HCMEC D3_line
      2308       ECIS        7       no  5,00Cell Free + HCMEC D3_line
      2309       ECIS        7       no  5,00Cell Free + HCMEC D3_line
      2310       ECIS        7       no  5,00Cell Free + HCMEC D3_line
      2311       ECIS        1       no 35,00Cell Free + HCMEC D3_line
      2312       ECIS        1       no 35,00Cell Free + HCMEC D3_line
      2313       ECIS        1       no 35,00Cell Free + HCMEC D3_line
      2314       ECIS        2       no 30,00Cell Free + HCMEC D3_line
      2315       ECIS        2       no 30,00Cell Free + HCMEC D3_line
      2316       ECIS        2       no 30,00Cell Free + HCMEC D3_line
      2317       ECIS        3       no 25,00Cell Free + HCMEC D3_line
      2318       ECIS        3       no 25,00Cell Free + HCMEC D3_line
      2319       ECIS        3       no 25,00Cell Free + HCMEC D3_line
      2320       ECIS        4       no 20,00Cell Free + HCMEC D3_line
      2321       ECIS        4       no 20,00Cell Free + HCMEC D3_line
      2322       ECIS        4       no 20,00Cell Free + HCMEC D3_line
      2323       ECIS        5       no 15,00Cell Free + HCMEC D3_line
      2324       ECIS        5       no 15,00Cell Free + HCMEC D3_line
      2325       ECIS        5       no 15,00Cell Free + HCMEC D3_line
      2326       ECIS        6       no 10,00Cell Free + HCMEC D3_line
      2327       ECIS        6       no 10,00Cell Free + HCMEC D3_line
      2328       ECIS        6       no 10,00Cell Free + HCMEC D3_line
      2329       ECIS        7       no  5,00Cell Free + HCMEC D3_line
      2330       ECIS        7       no  5,00Cell Free + HCMEC D3_line
      2331       ECIS        7       no  5,00Cell Free + HCMEC D3_line
      2332       ECIS        1       no 35,00Cell Free + HCMEC D3_line
      2333       ECIS        1       no 35,00Cell Free + HCMEC D3_line
      2334       ECIS        1       no 35,00Cell Free + HCMEC D3_line
      2335       ECIS        2       no 30,00Cell Free + HCMEC D3_line
      2336       ECIS        2       no 30,00Cell Free + HCMEC D3_line
      2337       ECIS        2       no 30,00Cell Free + HCMEC D3_line
      2338       ECIS        3       no 25,00Cell Free + HCMEC D3_line
      2339       ECIS        3       no 25,00Cell Free + HCMEC D3_line
      2340       ECIS        3       no 25,00Cell Free + HCMEC D3_line
      2341       ECIS        4       no 20,00Cell Free + HCMEC D3_line
      2342       ECIS        4       no 20,00Cell Free + HCMEC D3_line
      2343       ECIS        4       no 20,00Cell Free + HCMEC D3_line
      2344       ECIS        5       no 15,00Cell Free + HCMEC D3_line
      2345       ECIS        5       no 15,00Cell Free + HCMEC D3_line
      2346       ECIS        5       no 15,00Cell Free + HCMEC D3_line
      2347       ECIS        6       no 10,00Cell Free + HCMEC D3_line
      2348       ECIS        6       no 10,00Cell Free + HCMEC D3_line
      2349       ECIS        6       no 10,00Cell Free + HCMEC D3_line
      2350       ECIS        7       no  5,00Cell Free + HCMEC D3_line
      2351       ECIS        7       no  5,00Cell Free + HCMEC D3_line
      2352       ECIS        7       no  5,00Cell Free + HCMEC D3_line
      2353       ECIS        1       no 35,00Cell Free + HCMEC D3_line
      2354       ECIS        1       no 35,00Cell Free + HCMEC D3_line
      2355       ECIS        1       no 35,00Cell Free + HCMEC D3_line
      2356       ECIS        2       no 30,00Cell Free + HCMEC D3_line
      2357       ECIS        2       no 30,00Cell Free + HCMEC D3_line
      2358       ECIS        2       no 30,00Cell Free + HCMEC D3_line
      2359       ECIS        3       no 25,00Cell Free + HCMEC D3_line
      2360       ECIS        3       no 25,00Cell Free + HCMEC D3_line
      2361       ECIS        3       no 25,00Cell Free + HCMEC D3_line
      2362       ECIS        4       no 20,00Cell Free + HCMEC D3_line
      2363       ECIS        4       no 20,00Cell Free + HCMEC D3_line
      2364       ECIS        4       no 20,00Cell Free + HCMEC D3_line
      2365       ECIS        5       no 15,00Cell Free + HCMEC D3_line
      2366       ECIS        5       no 15,00Cell Free + HCMEC D3_line
      2367       ECIS        5       no 15,00Cell Free + HCMEC D3_line
      2368       ECIS        6       no 10,00Cell Free + HCMEC D3_line
      2369       ECIS        6       no 10,00Cell Free + HCMEC D3_line
      2370       ECIS        6       no 10,00Cell Free + HCMEC D3_line
      2371       ECIS        7       no  5,00Cell Free + HCMEC D3_line
      2372       ECIS        7       no  5,00Cell Free + HCMEC D3_line
      2373       ECIS        7       no  5,00Cell Free + HCMEC D3_line
      2374       ECIS        1       no 35,00Cell Free + HCMEC D3_line
      2375       ECIS        1       no 35,00Cell Free + HCMEC D3_line
      2376       ECIS        1       no 35,00Cell Free + HCMEC D3_line
      2377       ECIS        2       no 30,00Cell Free + HCMEC D3_line
      2378       ECIS        2       no 30,00Cell Free + HCMEC D3_line
      2379       ECIS        2       no 30,00Cell Free + HCMEC D3_line
      2380       ECIS        3       no 25,00Cell Free + HCMEC D3_line
      2381       ECIS        3       no 25,00Cell Free + HCMEC D3_line
      2382       ECIS        3       no 25,00Cell Free + HCMEC D3_line
      2383       ECIS        4       no 20,00Cell Free + HCMEC D3_line
      2384       ECIS        4       no 20,00Cell Free + HCMEC D3_line
      2385       ECIS        4       no 20,00Cell Free + HCMEC D3_line
      2386       ECIS        5       no 15,00Cell Free + HCMEC D3_line
      2387       ECIS        5       no 15,00Cell Free + HCMEC D3_line
      2388       ECIS        5       no 15,00Cell Free + HCMEC D3_line
      2389       ECIS        6       no 10,00Cell Free + HCMEC D3_line
      2390       ECIS        6       no 10,00Cell Free + HCMEC D3_line
      2391       ECIS        6       no 10,00Cell Free + HCMEC D3_line
      2392       ECIS        7       no  5,00Cell Free + HCMEC D3_line
      2393       ECIS        7       no  5,00Cell Free + HCMEC D3_line
      2394       ECIS        7       no  5,00Cell Free + HCMEC D3_line
      2395       ECIS        1       no 35,00Cell Free + HCMEC D3_line
      2396       ECIS        1       no 35,00Cell Free + HCMEC D3_line
      2397       ECIS        1       no 35,00Cell Free + HCMEC D3_line
      2398       ECIS        2       no 30,00Cell Free + HCMEC D3_line
      2399       ECIS        2       no 30,00Cell Free + HCMEC D3_line
      2400       ECIS        2       no 30,00Cell Free + HCMEC D3_line
      2401       ECIS        3       no 25,00Cell Free + HCMEC D3_line
      2402       ECIS        3       no 25,00Cell Free + HCMEC D3_line
      2403       ECIS        3       no 25,00Cell Free + HCMEC D3_line
      2404       ECIS        4       no 20,00Cell Free + HCMEC D3_line
      2405       ECIS        4       no 20,00Cell Free + HCMEC D3_line
      2406       ECIS        4       no 20,00Cell Free + HCMEC D3_line
      2407       ECIS        5       no 15,00Cell Free + HCMEC D3_line
      2408       ECIS        5       no 15,00Cell Free + HCMEC D3_line
      2409       ECIS        5       no 15,00Cell Free + HCMEC D3_line
      2410       ECIS        6       no 10,00Cell Free + HCMEC D3_line
      2411       ECIS        6       no 10,00Cell Free + HCMEC D3_line
      2412       ECIS        6       no 10,00Cell Free + HCMEC D3_line
      2413       ECIS        7       no  5,00Cell Free + HCMEC D3_line
      2414       ECIS        7       no  5,00Cell Free + HCMEC D3_line
      2415       ECIS        7       no  5,00Cell Free + HCMEC D3_line
      2416       ECIS        1       no 35,00Cell Free + HCMEC D3_line
      2417       ECIS        1       no 35,00Cell Free + HCMEC D3_line
      2418       ECIS        1       no 35,00Cell Free + HCMEC D3_line
      2419       ECIS        2       no 30,00Cell Free + HCMEC D3_line
      2420       ECIS        2       no 30,00Cell Free + HCMEC D3_line
      2421       ECIS        2       no 30,00Cell Free + HCMEC D3_line
      2422       ECIS        3       no 25,00Cell Free + HCMEC D3_line
      2423       ECIS        3       no 25,00Cell Free + HCMEC D3_line
      2424       ECIS        3       no 25,00Cell Free + HCMEC D3_line
      2425       ECIS        4       no 20,00Cell Free + HCMEC D3_line
      2426       ECIS        4       no 20,00Cell Free + HCMEC D3_line
      2427       ECIS        4       no 20,00Cell Free + HCMEC D3_line
      2428       ECIS        5       no 15,00Cell Free + HCMEC D3_line
      2429       ECIS        5       no 15,00Cell Free + HCMEC D3_line
      2430       ECIS        5       no 15,00Cell Free + HCMEC D3_line
      2431       ECIS        6       no 10,00Cell Free + HCMEC D3_line
      2432       ECIS        6       no 10,00Cell Free + HCMEC D3_line
      2433       ECIS        6       no 10,00Cell Free + HCMEC D3_line
      2434       ECIS        7       no  5,00Cell Free + HCMEC D3_line
      2435       ECIS        7       no  5,00Cell Free + HCMEC D3_line
      2436       ECIS        7       no  5,00Cell Free + HCMEC D3_line
      2437       ECIS        1       no 35,00Cell Free + HCMEC D3_line
      2438       ECIS        1       no 35,00Cell Free + HCMEC D3_line
      2439       ECIS        1       no 35,00Cell Free + HCMEC D3_line
      2440       ECIS        2       no 30,00Cell Free + HCMEC D3_line
      2441       ECIS        2       no 30,00Cell Free + HCMEC D3_line
      2442       ECIS        2       no 30,00Cell Free + HCMEC D3_line
      2443       ECIS        3       no 25,00Cell Free + HCMEC D3_line
      2444       ECIS        3       no 25,00Cell Free + HCMEC D3_line
      2445       ECIS        3       no 25,00Cell Free + HCMEC D3_line
      2446       ECIS        4       no 20,00Cell Free + HCMEC D3_line
      2447       ECIS        4       no 20,00Cell Free + HCMEC D3_line
      2448       ECIS        4       no 20,00Cell Free + HCMEC D3_line
      2449       ECIS        5       no 15,00Cell Free + HCMEC D3_line
      2450       ECIS        5       no 15,00Cell Free + HCMEC D3_line
      2451       ECIS        5       no 15,00Cell Free + HCMEC D3_line
      2452       ECIS        6       no 10,00Cell Free + HCMEC D3_line
      2453       ECIS        6       no 10,00Cell Free + HCMEC D3_line
      2454       ECIS        6       no 10,00Cell Free + HCMEC D3_line
      2455       ECIS        7       no  5,00Cell Free + HCMEC D3_line
      2456       ECIS        7       no  5,00Cell Free + HCMEC D3_line
      2457       ECIS        7       no  5,00Cell Free + HCMEC D3_line
      2458       ECIS        1       no 35,00Cell Free + HCMEC D3_line
      2459       ECIS        1       no 35,00Cell Free + HCMEC D3_line
      2460       ECIS        1       no 35,00Cell Free + HCMEC D3_line
      2461       ECIS        2       no 30,00Cell Free + HCMEC D3_line
      2462       ECIS        2       no 30,00Cell Free + HCMEC D3_line
      2463       ECIS        2       no 30,00Cell Free + HCMEC D3_line
      2464       ECIS        3       no 25,00Cell Free + HCMEC D3_line
      2465       ECIS        3       no 25,00Cell Free + HCMEC D3_line
      2466       ECIS        3       no 25,00Cell Free + HCMEC D3_line
      2467       ECIS        4       no 20,00Cell Free + HCMEC D3_line
      2468       ECIS        4       no 20,00Cell Free + HCMEC D3_line
      2469       ECIS        4       no 20,00Cell Free + HCMEC D3_line
      2470       ECIS        5       no 15,00Cell Free + HCMEC D3_line
      2471       ECIS        5       no 15,00Cell Free + HCMEC D3_line
      2472       ECIS        5       no 15,00Cell Free + HCMEC D3_line
      2473       ECIS        6       no 10,00Cell Free + HCMEC D3_line
      2474       ECIS        6       no 10,00Cell Free + HCMEC D3_line
      2475       ECIS        6       no 10,00Cell Free + HCMEC D3_line
      2476       ECIS        7       no  5,00Cell Free + HCMEC D3_line
      2477       ECIS        7       no  5,00Cell Free + HCMEC D3_line
      2478       ECIS        7       no  5,00Cell Free + HCMEC D3_line
      2479       ECIS        1       no 35,00Cell Free + HCMEC D3_line
      2480       ECIS        1       no 35,00Cell Free + HCMEC D3_line
      2481       ECIS        1       no 35,00Cell Free + HCMEC D3_line
      2482       ECIS        2       no 30,00Cell Free + HCMEC D3_line
      2483       ECIS        2       no 30,00Cell Free + HCMEC D3_line
      2484       ECIS        2       no 30,00Cell Free + HCMEC D3_line
      2485       ECIS        3       no 25,00Cell Free + HCMEC D3_line
      2486       ECIS        3       no 25,00Cell Free + HCMEC D3_line
      2487       ECIS        3       no 25,00Cell Free + HCMEC D3_line
      2488       ECIS        4       no 20,00Cell Free + HCMEC D3_line
      2489       ECIS        4       no 20,00Cell Free + HCMEC D3_line
      2490       ECIS        4       no 20,00Cell Free + HCMEC D3_line
      2491       ECIS        5       no 15,00Cell Free + HCMEC D3_line
      2492       ECIS        5       no 15,00Cell Free + HCMEC D3_line
      2493       ECIS        5       no 15,00Cell Free + HCMEC D3_line
      2494       ECIS        6       no 10,00Cell Free + HCMEC D3_line
      2495       ECIS        6       no 10,00Cell Free + HCMEC D3_line
      2496       ECIS        6       no 10,00Cell Free + HCMEC D3_line
      2497       ECIS        7       no  5,00Cell Free + HCMEC D3_line
      2498       ECIS        7       no  5,00Cell Free + HCMEC D3_line
      2499       ECIS        7       no  5,00Cell Free + HCMEC D3_line
      2500       ECIS        1       no 35,00Cell Free + HCMEC D3_line
      2501       ECIS        1       no 35,00Cell Free + HCMEC D3_line
      2502       ECIS        1       no 35,00Cell Free + HCMEC D3_line
      2503       ECIS        2       no 30,00Cell Free + HCMEC D3_line
      2504       ECIS        2       no 30,00Cell Free + HCMEC D3_line
      2505       ECIS        2       no 30,00Cell Free + HCMEC D3_line
      2506       ECIS        3       no 25,00Cell Free + HCMEC D3_line
      2507       ECIS        3       no 25,00Cell Free + HCMEC D3_line
      2508       ECIS        3       no 25,00Cell Free + HCMEC D3_line
      2509       ECIS        4       no 20,00Cell Free + HCMEC D3_line
      2510       ECIS        4       no 20,00Cell Free + HCMEC D3_line
      2511       ECIS        4       no 20,00Cell Free + HCMEC D3_line
      2512       ECIS        5       no 15,00Cell Free + HCMEC D3_line
      2513       ECIS        5       no 15,00Cell Free + HCMEC D3_line
      2514       ECIS        5       no 15,00Cell Free + HCMEC D3_line
      2515       ECIS        6       no 10,00Cell Free + HCMEC D3_line
      2516       ECIS        6       no 10,00Cell Free + HCMEC D3_line
      2517       ECIS        6       no 10,00Cell Free + HCMEC D3_line
      2518       ECIS        7       no  5,00Cell Free + HCMEC D3_line
      2519       ECIS        7       no  5,00Cell Free + HCMEC D3_line
      2520       ECIS        7       no  5,00Cell Free + HCMEC D3_line
      2521       ECIS        1       no 35,00Cell Free + HCMEC D3_line
      2522       ECIS        1       no 35,00Cell Free + HCMEC D3_line
      2523       ECIS        1       no 35,00Cell Free + HCMEC D3_line
      2524       ECIS        2       no 30,00Cell Free + HCMEC D3_line
      2525       ECIS        2       no 30,00Cell Free + HCMEC D3_line
      2526       ECIS        2       no 30,00Cell Free + HCMEC D3_line
      2527       ECIS        3       no 25,00Cell Free + HCMEC D3_line
      2528       ECIS        3       no 25,00Cell Free + HCMEC D3_line
      2529       ECIS        3       no 25,00Cell Free + HCMEC D3_line
      2530       ECIS        4       no 20,00Cell Free + HCMEC D3_line
      2531       ECIS        4       no 20,00Cell Free + HCMEC D3_line
      2532       ECIS        4       no 20,00Cell Free + HCMEC D3_line
      2533       ECIS        5       no 15,00Cell Free + HCMEC D3_line
      2534       ECIS        5       no 15,00Cell Free + HCMEC D3_line
      2535       ECIS        5       no 15,00Cell Free + HCMEC D3_line
      2536       ECIS        6       no 10,00Cell Free + HCMEC D3_line
      2537       ECIS        6       no 10,00Cell Free + HCMEC D3_line
      2538       ECIS        6       no 10,00Cell Free + HCMEC D3_line
      2539       ECIS        7       no  5,00Cell Free + HCMEC D3_line
      2540       ECIS        7       no  5,00Cell Free + HCMEC D3_line
      2541       ECIS        7       no  5,00Cell Free + HCMEC D3_line
      2542       ECIS        1       no 35,00Cell Free + HCMEC D3_line
      2543       ECIS        1       no 35,00Cell Free + HCMEC D3_line
      2544       ECIS        1       no 35,00Cell Free + HCMEC D3_line
      2545       ECIS        2       no 30,00Cell Free + HCMEC D3_line
      2546       ECIS        2       no 30,00Cell Free + HCMEC D3_line
      2547       ECIS        2       no 30,00Cell Free + HCMEC D3_line
      2548       ECIS        3       no 25,00Cell Free + HCMEC D3_line
      2549       ECIS        3       no 25,00Cell Free + HCMEC D3_line
      2550       ECIS        3       no 25,00Cell Free + HCMEC D3_line
      2551       ECIS        4       no 20,00Cell Free + HCMEC D3_line
      2552       ECIS        4       no 20,00Cell Free + HCMEC D3_line
      2553       ECIS        4       no 20,00Cell Free + HCMEC D3_line
      2554       ECIS        5       no 15,00Cell Free + HCMEC D3_line
      2555       ECIS        5       no 15,00Cell Free + HCMEC D3_line
      2556       ECIS        5       no 15,00Cell Free + HCMEC D3_line
      2557       ECIS        6       no 10,00Cell Free + HCMEC D3_line
      2558       ECIS        6       no 10,00Cell Free + HCMEC D3_line
      2559       ECIS        6       no 10,00Cell Free + HCMEC D3_line
      2560       ECIS        7       no  5,00Cell Free + HCMEC D3_line
      2561       ECIS        7       no  5,00Cell Free + HCMEC D3_line
      2562       ECIS        7       no  5,00Cell Free + HCMEC D3_line
      2563       ECIS        1       no 35,00Cell Free + HCMEC D3_line
      2564       ECIS        1       no 35,00Cell Free + HCMEC D3_line
      2565       ECIS        1       no 35,00Cell Free + HCMEC D3_line
      2566       ECIS        2       no 30,00Cell Free + HCMEC D3_line
      2567       ECIS        2       no 30,00Cell Free + HCMEC D3_line
      2568       ECIS        2       no 30,00Cell Free + HCMEC D3_line
      2569       ECIS        3       no 25,00Cell Free + HCMEC D3_line
      2570       ECIS        3       no 25,00Cell Free + HCMEC D3_line
      2571       ECIS        3       no 25,00Cell Free + HCMEC D3_line
      2572       ECIS        4       no 20,00Cell Free + HCMEC D3_line
      2573       ECIS        4       no 20,00Cell Free + HCMEC D3_line
      2574       ECIS        4       no 20,00Cell Free + HCMEC D3_line
      2575       ECIS        5       no 15,00Cell Free + HCMEC D3_line
      2576       ECIS        5       no 15,00Cell Free + HCMEC D3_line
      2577       ECIS        5       no 15,00Cell Free + HCMEC D3_line
      2578       ECIS        6       no 10,00Cell Free + HCMEC D3_line
      2579       ECIS        6       no 10,00Cell Free + HCMEC D3_line
      2580       ECIS        6       no 10,00Cell Free + HCMEC D3_line
      2581       ECIS        7       no  5,00Cell Free + HCMEC D3_line
      2582       ECIS        7       no  5,00Cell Free + HCMEC D3_line
      2583       ECIS        7       no  5,00Cell Free + HCMEC D3_line
      2584       ECIS        1       no 35,00Cell Free + HCMEC D3_line
      2585       ECIS        1       no 35,00Cell Free + HCMEC D3_line
      2586       ECIS        1       no 35,00Cell Free + HCMEC D3_line
      2587       ECIS        2       no 30,00Cell Free + HCMEC D3_line
      2588       ECIS        2       no 30,00Cell Free + HCMEC D3_line
      2589       ECIS        2       no 30,00Cell Free + HCMEC D3_line
      2590       ECIS        3       no 25,00Cell Free + HCMEC D3_line
      2591       ECIS        3       no 25,00Cell Free + HCMEC D3_line
      2592       ECIS        3       no 25,00Cell Free + HCMEC D3_line
      2593       ECIS        4       no 20,00Cell Free + HCMEC D3_line
      2594       ECIS        4       no 20,00Cell Free + HCMEC D3_line
      2595       ECIS        4       no 20,00Cell Free + HCMEC D3_line
      2596       ECIS        5       no 15,00Cell Free + HCMEC D3_line
      2597       ECIS        5       no 15,00Cell Free + HCMEC D3_line
      2598       ECIS        5       no 15,00Cell Free + HCMEC D3_line
      2599       ECIS        6       no 10,00Cell Free + HCMEC D3_line
      2600       ECIS        6       no 10,00Cell Free + HCMEC D3_line
      2601       ECIS        6       no 10,00Cell Free + HCMEC D3_line
      2602       ECIS        7       no  5,00Cell Free + HCMEC D3_line
      2603       ECIS        7       no  5,00Cell Free + HCMEC D3_line
      2604       ECIS        7       no  5,00Cell Free + HCMEC D3_line
      2605       ECIS        1       no 35,00Cell Free + HCMEC D3_line
      2606       ECIS        1       no 35,00Cell Free + HCMEC D3_line
      2607       ECIS        1       no 35,00Cell Free + HCMEC D3_line
      2608       ECIS        2       no 30,00Cell Free + HCMEC D3_line
      2609       ECIS        2       no 30,00Cell Free + HCMEC D3_line
      2610       ECIS        2       no 30,00Cell Free + HCMEC D3_line
      2611       ECIS        3       no 25,00Cell Free + HCMEC D3_line
      2612       ECIS        3       no 25,00Cell Free + HCMEC D3_line
      2613       ECIS        3       no 25,00Cell Free + HCMEC D3_line
      2614       ECIS        4       no 20,00Cell Free + HCMEC D3_line
      2615       ECIS        4       no 20,00Cell Free + HCMEC D3_line
      2616       ECIS        4       no 20,00Cell Free + HCMEC D3_line
      2617       ECIS        5       no 15,00Cell Free + HCMEC D3_line
      2618       ECIS        5       no 15,00Cell Free + HCMEC D3_line
      2619       ECIS        5       no 15,00Cell Free + HCMEC D3_line
      2620       ECIS        6       no 10,00Cell Free + HCMEC D3_line
      2621       ECIS        6       no 10,00Cell Free + HCMEC D3_line
      2622       ECIS        6       no 10,00Cell Free + HCMEC D3_line
      2623       ECIS        7       no  5,00Cell Free + HCMEC D3_line
      2624       ECIS        7       no  5,00Cell Free + HCMEC D3_line
      2625       ECIS        7       no  5,00Cell Free + HCMEC D3_line
      2626       ECIS        1       no 35,00Cell Free + HCMEC D3_line
      2627       ECIS        1       no 35,00Cell Free + HCMEC D3_line
      2628       ECIS        1       no 35,00Cell Free + HCMEC D3_line
      2629       ECIS        2       no 30,00Cell Free + HCMEC D3_line
      2630       ECIS        2       no 30,00Cell Free + HCMEC D3_line
      2631       ECIS        2       no 30,00Cell Free + HCMEC D3_line
      2632       ECIS        3       no 25,00Cell Free + HCMEC D3_line
      2633       ECIS        3       no 25,00Cell Free + HCMEC D3_line
      2634       ECIS        3       no 25,00Cell Free + HCMEC D3_line
      2635       ECIS        4       no 20,00Cell Free + HCMEC D3_line
      2636       ECIS        4       no 20,00Cell Free + HCMEC D3_line
      2637       ECIS        4       no 20,00Cell Free + HCMEC D3_line
      2638       ECIS        5       no 15,00Cell Free + HCMEC D3_line
      2639       ECIS        5       no 15,00Cell Free + HCMEC D3_line
      2640       ECIS        5       no 15,00Cell Free + HCMEC D3_line
      2641       ECIS        6       no 10,00Cell Free + HCMEC D3_line
      2642       ECIS        6       no 10,00Cell Free + HCMEC D3_line
      2643       ECIS        6       no 10,00Cell Free + HCMEC D3_line
      2644       ECIS        7       no  5,00Cell Free + HCMEC D3_line
      2645       ECIS        7       no  5,00Cell Free + HCMEC D3_line
      2646       ECIS        7       no  5,00Cell Free + HCMEC D3_line
      2647       ECIS        1       no 35,00Cell Free + HCMEC D3_line
      2648       ECIS        1       no 35,00Cell Free + HCMEC D3_line
      2649       ECIS        1       no 35,00Cell Free + HCMEC D3_line
      2650       ECIS        2       no 30,00Cell Free + HCMEC D3_line
      2651       ECIS        2       no 30,00Cell Free + HCMEC D3_line
      2652       ECIS        2       no 30,00Cell Free + HCMEC D3_line
      2653       ECIS        3       no 25,00Cell Free + HCMEC D3_line
      2654       ECIS        3       no 25,00Cell Free + HCMEC D3_line
      2655       ECIS        3       no 25,00Cell Free + HCMEC D3_line
      2656       ECIS        4       no 20,00Cell Free + HCMEC D3_line
      2657       ECIS        4       no 20,00Cell Free + HCMEC D3_line
      2658       ECIS        4       no 20,00Cell Free + HCMEC D3_line
      2659       ECIS        5       no 15,00Cell Free + HCMEC D3_line
      2660       ECIS        5       no 15,00Cell Free + HCMEC D3_line
      2661       ECIS        5       no 15,00Cell Free + HCMEC D3_line
      2662       ECIS        6       no 10,00Cell Free + HCMEC D3_line
      2663       ECIS        6       no 10,00Cell Free + HCMEC D3_line
      2664       ECIS        6       no 10,00Cell Free + HCMEC D3_line
      2665       ECIS        7       no  5,00Cell Free + HCMEC D3_line
      2666       ECIS        7       no  5,00Cell Free + HCMEC D3_line
      2667       ECIS        7       no  5,00Cell Free + HCMEC D3_line
      2668       ECIS        1       no 35,00Cell Free + HCMEC D3_line
      2669       ECIS        1       no 35,00Cell Free + HCMEC D3_line
      2670       ECIS        1       no 35,00Cell Free + HCMEC D3_line
      2671       ECIS        2       no 30,00Cell Free + HCMEC D3_line
      2672       ECIS        2       no 30,00Cell Free + HCMEC D3_line
      2673       ECIS        2       no 30,00Cell Free + HCMEC D3_line
      2674       ECIS        3       no 25,00Cell Free + HCMEC D3_line
      2675       ECIS        3       no 25,00Cell Free + HCMEC D3_line
      2676       ECIS        3       no 25,00Cell Free + HCMEC D3_line
      2677       ECIS        4       no 20,00Cell Free + HCMEC D3_line
      2678       ECIS        4       no 20,00Cell Free + HCMEC D3_line
      2679       ECIS        4       no 20,00Cell Free + HCMEC D3_line
      2680       ECIS        5       no 15,00Cell Free + HCMEC D3_line
      2681       ECIS        5       no 15,00Cell Free + HCMEC D3_line
      2682       ECIS        5       no 15,00Cell Free + HCMEC D3_line
      2683       ECIS        6       no 10,00Cell Free + HCMEC D3_line
      2684       ECIS        6       no 10,00Cell Free + HCMEC D3_line
      2685       ECIS        6       no 10,00Cell Free + HCMEC D3_line
      2686       ECIS        7       no  5,00Cell Free + HCMEC D3_line
      2687       ECIS        7       no  5,00Cell Free + HCMEC D3_line
      2688       ECIS        7       no  5,00Cell Free + HCMEC D3_line
      2689       ECIS        1       no 35,00Cell Free + HCMEC D3_line
      2690       ECIS        1       no 35,00Cell Free + HCMEC D3_line
      2691       ECIS        1       no 35,00Cell Free + HCMEC D3_line
      2692       ECIS        2       no 30,00Cell Free + HCMEC D3_line
      2693       ECIS        2       no 30,00Cell Free + HCMEC D3_line
      2694       ECIS        2       no 30,00Cell Free + HCMEC D3_line
      2695       ECIS        3       no 25,00Cell Free + HCMEC D3_line
      2696       ECIS        3       no 25,00Cell Free + HCMEC D3_line
      2697       ECIS        3       no 25,00Cell Free + HCMEC D3_line
      2698       ECIS        4       no 20,00Cell Free + HCMEC D3_line
      2699       ECIS        4       no 20,00Cell Free + HCMEC D3_line
      2700       ECIS        4       no 20,00Cell Free + HCMEC D3_line
      2701       ECIS        5       no 15,00Cell Free + HCMEC D3_line
      2702       ECIS        5       no 15,00Cell Free + HCMEC D3_line
      2703       ECIS        5       no 15,00Cell Free + HCMEC D3_line
      2704       ECIS        6       no 10,00Cell Free + HCMEC D3_line
      2705       ECIS        6       no 10,00Cell Free + HCMEC D3_line
      2706       ECIS        6       no 10,00Cell Free + HCMEC D3_line
      2707       ECIS        7       no  5,00Cell Free + HCMEC D3_line
      2708       ECIS        7       no  5,00Cell Free + HCMEC D3_line
      2709       ECIS        7       no  5,00Cell Free + HCMEC D3_line
      2710       ECIS        1       no 35,00Cell Free + HCMEC D3_line
      2711       ECIS        1       no 35,00Cell Free + HCMEC D3_line
      2712       ECIS        1       no 35,00Cell Free + HCMEC D3_line
      2713       ECIS        2       no 30,00Cell Free + HCMEC D3_line
      2714       ECIS        2       no 30,00Cell Free + HCMEC D3_line
      2715       ECIS        2       no 30,00Cell Free + HCMEC D3_line
      2716       ECIS        3       no 25,00Cell Free + HCMEC D3_line
      2717       ECIS        3       no 25,00Cell Free + HCMEC D3_line
      2718       ECIS        3       no 25,00Cell Free + HCMEC D3_line
      2719       ECIS        4       no 20,00Cell Free + HCMEC D3_line
      2720       ECIS        4       no 20,00Cell Free + HCMEC D3_line
      2721       ECIS        4       no 20,00Cell Free + HCMEC D3_line
      2722       ECIS        5       no 15,00Cell Free + HCMEC D3_line
      2723       ECIS        5       no 15,00Cell Free + HCMEC D3_line
      2724       ECIS        5       no 15,00Cell Free + HCMEC D3_line
      2725       ECIS        6       no 10,00Cell Free + HCMEC D3_line
      2726       ECIS        6       no 10,00Cell Free + HCMEC D3_line
      2727       ECIS        6       no 10,00Cell Free + HCMEC D3_line
      2728       ECIS        7       no  5,00Cell Free + HCMEC D3_line
      2729       ECIS        7       no  5,00Cell Free + HCMEC D3_line
      2730       ECIS        7       no  5,00Cell Free + HCMEC D3_line
      2731       ECIS        1       no 35,00Cell Free + HCMEC D3_line
      2732       ECIS        1       no 35,00Cell Free + HCMEC D3_line
      2733       ECIS        1       no 35,00Cell Free + HCMEC D3_line
      2734       ECIS        2       no 30,00Cell Free + HCMEC D3_line
      2735       ECIS        2       no 30,00Cell Free + HCMEC D3_line
      2736       ECIS        2       no 30,00Cell Free + HCMEC D3_line
      2737       ECIS        3       no 25,00Cell Free + HCMEC D3_line
      2738       ECIS        3       no 25,00Cell Free + HCMEC D3_line
      2739       ECIS        3       no 25,00Cell Free + HCMEC D3_line
      2740       ECIS        4       no 20,00Cell Free + HCMEC D3_line
      2741       ECIS        4       no 20,00Cell Free + HCMEC D3_line
      2742       ECIS        4       no 20,00Cell Free + HCMEC D3_line
      2743       ECIS        5       no 15,00Cell Free + HCMEC D3_line
      2744       ECIS        5       no 15,00Cell Free + HCMEC D3_line
      2745       ECIS        5       no 15,00Cell Free + HCMEC D3_line
      2746       ECIS        6       no 10,00Cell Free + HCMEC D3_line
      2747       ECIS        6       no 10,00Cell Free + HCMEC D3_line
      2748       ECIS        6       no 10,00Cell Free + HCMEC D3_line
      2749       ECIS        7       no  5,00Cell Free + HCMEC D3_line
      2750       ECIS        7       no  5,00Cell Free + HCMEC D3_line
      2751       ECIS        7       no  5,00Cell Free + HCMEC D3_line
      2752       ECIS        1       no 35,00Cell Free + HCMEC D3_line
      2753       ECIS        1       no 35,00Cell Free + HCMEC D3_line
      2754       ECIS        1       no 35,00Cell Free + HCMEC D3_line
      2755       ECIS        2       no 30,00Cell Free + HCMEC D3_line
      2756       ECIS        2       no 30,00Cell Free + HCMEC D3_line
      2757       ECIS        2       no 30,00Cell Free + HCMEC D3_line
      2758       ECIS        3       no 25,00Cell Free + HCMEC D3_line
      2759       ECIS        3       no 25,00Cell Free + HCMEC D3_line
      2760       ECIS        3       no 25,00Cell Free + HCMEC D3_line
      2761       ECIS        4       no 20,00Cell Free + HCMEC D3_line
      2762       ECIS        4       no 20,00Cell Free + HCMEC D3_line
      2763       ECIS        4       no 20,00Cell Free + HCMEC D3_line
      2764       ECIS        5       no 15,00Cell Free + HCMEC D3_line
      2765       ECIS        5       no 15,00Cell Free + HCMEC D3_line
      2766       ECIS        5       no 15,00Cell Free + HCMEC D3_line
      2767       ECIS        6       no 10,00Cell Free + HCMEC D3_line
      2768       ECIS        6       no 10,00Cell Free + HCMEC D3_line
      2769       ECIS        6       no 10,00Cell Free + HCMEC D3_line
      2770       ECIS        7       no  5,00Cell Free + HCMEC D3_line
      2771       ECIS        7       no  5,00Cell Free + HCMEC D3_line
      2772       ECIS        7       no  5,00Cell Free + HCMEC D3_line
      2773       ECIS        1       no 35,00Cell Free + HCMEC D3_line
      2774       ECIS        1       no 35,00Cell Free + HCMEC D3_line
      2775       ECIS        1       no 35,00Cell Free + HCMEC D3_line
      2776       ECIS        2       no 30,00Cell Free + HCMEC D3_line
      2777       ECIS        2       no 30,00Cell Free + HCMEC D3_line
      2778       ECIS        2       no 30,00Cell Free + HCMEC D3_line
      2779       ECIS        3       no 25,00Cell Free + HCMEC D3_line
      2780       ECIS        3       no 25,00Cell Free + HCMEC D3_line
      2781       ECIS        3       no 25,00Cell Free + HCMEC D3_line
      2782       ECIS        4       no 20,00Cell Free + HCMEC D3_line
      2783       ECIS        4       no 20,00Cell Free + HCMEC D3_line
      2784       ECIS        4       no 20,00Cell Free + HCMEC D3_line
      2785       ECIS        5       no 15,00Cell Free + HCMEC D3_line
      2786       ECIS        5       no 15,00Cell Free + HCMEC D3_line
      2787       ECIS        5       no 15,00Cell Free + HCMEC D3_line
      2788       ECIS        6       no 10,00Cell Free + HCMEC D3_line
      2789       ECIS        6       no 10,00Cell Free + HCMEC D3_line
      2790       ECIS        6       no 10,00Cell Free + HCMEC D3_line
      2791       ECIS        7       no  5,00Cell Free + HCMEC D3_line
      2792       ECIS        7       no  5,00Cell Free + HCMEC D3_line
      2793       ECIS        7       no  5,00Cell Free + HCMEC D3_line
      2794       ECIS        1       no 35,00Cell Free + HCMEC D3_line
      2795       ECIS        1       no 35,00Cell Free + HCMEC D3_line
      2796       ECIS        1       no 35,00Cell Free + HCMEC D3_line
      2797       ECIS        2       no 30,00Cell Free + HCMEC D3_line
      2798       ECIS        2       no 30,00Cell Free + HCMEC D3_line
      2799       ECIS        2       no 30,00Cell Free + HCMEC D3_line
      2800       ECIS        3       no 25,00Cell Free + HCMEC D3_line
      2801       ECIS        3       no 25,00Cell Free + HCMEC D3_line
      2802       ECIS        3       no 25,00Cell Free + HCMEC D3_line
      2803       ECIS        4       no 20,00Cell Free + HCMEC D3_line
      2804       ECIS        4       no 20,00Cell Free + HCMEC D3_line
      2805       ECIS        4       no 20,00Cell Free + HCMEC D3_line
      2806       ECIS        5       no 15,00Cell Free + HCMEC D3_line
      2807       ECIS        5       no 15,00Cell Free + HCMEC D3_line
      2808       ECIS        5       no 15,00Cell Free + HCMEC D3_line
      2809       ECIS        6       no 10,00Cell Free + HCMEC D3_line
      2810       ECIS        6       no 10,00Cell Free + HCMEC D3_line
      2811       ECIS        6       no 10,00Cell Free + HCMEC D3_line
      2812       ECIS        7       no  5,00Cell Free + HCMEC D3_line
      2813       ECIS        7       no  5,00Cell Free + HCMEC D3_line
      2814       ECIS        7       no  5,00Cell Free + HCMEC D3_line
      2815       ECIS        1       no 35,00Cell Free + HCMEC D3_line
      2816       ECIS        1       no 35,00Cell Free + HCMEC D3_line
      2817       ECIS        1       no 35,00Cell Free + HCMEC D3_line
      2818       ECIS        2       no 30,00Cell Free + HCMEC D3_line
      2819       ECIS        2       no 30,00Cell Free + HCMEC D3_line
      2820       ECIS        2       no 30,00Cell Free + HCMEC D3_line
      2821       ECIS        3       no 25,00Cell Free + HCMEC D3_line
      2822       ECIS        3       no 25,00Cell Free + HCMEC D3_line
      2823       ECIS        3       no 25,00Cell Free + HCMEC D3_line
      2824       ECIS        4       no 20,00Cell Free + HCMEC D3_line
      2825       ECIS        4       no 20,00Cell Free + HCMEC D3_line
      2826       ECIS        4       no 20,00Cell Free + HCMEC D3_line
      2827       ECIS        5       no 15,00Cell Free + HCMEC D3_line
      2828       ECIS        5       no 15,00Cell Free + HCMEC D3_line
      2829       ECIS        5       no 15,00Cell Free + HCMEC D3_line
      2830       ECIS        6       no 10,00Cell Free + HCMEC D3_line
      2831       ECIS        6       no 10,00Cell Free + HCMEC D3_line
      2832       ECIS        6       no 10,00Cell Free + HCMEC D3_line
      2833       ECIS        7       no  5,00Cell Free + HCMEC D3_line
      2834       ECIS        7       no  5,00Cell Free + HCMEC D3_line
      2835       ECIS        7       no  5,00Cell Free + HCMEC D3_line
      2836       ECIS        1       no 35,00Cell Free + HCMEC D3_line
      2837       ECIS        1       no 35,00Cell Free + HCMEC D3_line
      2838       ECIS        1       no 35,00Cell Free + HCMEC D3_line
      2839       ECIS        2       no 30,00Cell Free + HCMEC D3_line
      2840       ECIS        2       no 30,00Cell Free + HCMEC D3_line
      2841       ECIS        2       no 30,00Cell Free + HCMEC D3_line
      2842       ECIS        3       no 25,00Cell Free + HCMEC D3_line
      2843       ECIS        3       no 25,00Cell Free + HCMEC D3_line
      2844       ECIS        3       no 25,00Cell Free + HCMEC D3_line
      2845       ECIS        4       no 20,00Cell Free + HCMEC D3_line
      2846       ECIS        4       no 20,00Cell Free + HCMEC D3_line
      2847       ECIS        4       no 20,00Cell Free + HCMEC D3_line
      2848       ECIS        5       no 15,00Cell Free + HCMEC D3_line
      2849       ECIS        5       no 15,00Cell Free + HCMEC D3_line
      2850       ECIS        5       no 15,00Cell Free + HCMEC D3_line
      2851       ECIS        6       no 10,00Cell Free + HCMEC D3_line
      2852       ECIS        6       no 10,00Cell Free + HCMEC D3_line
      2853       ECIS        6       no 10,00Cell Free + HCMEC D3_line
      2854       ECIS        7       no  5,00Cell Free + HCMEC D3_line
      2855       ECIS        7       no  5,00Cell Free + HCMEC D3_line
      2856       ECIS        7       no  5,00Cell Free + HCMEC D3_line
      2857       ECIS        1       no 35,00Cell Free + HCMEC D3_line
      2858       ECIS        1       no 35,00Cell Free + HCMEC D3_line
      2859       ECIS        1       no 35,00Cell Free + HCMEC D3_line
      2860       ECIS        2       no 30,00Cell Free + HCMEC D3_line
      2861       ECIS        2       no 30,00Cell Free + HCMEC D3_line
      2862       ECIS        2       no 30,00Cell Free + HCMEC D3_line
      2863       ECIS        3       no 25,00Cell Free + HCMEC D3_line
      2864       ECIS        3       no 25,00Cell Free + HCMEC D3_line
      2865       ECIS        3       no 25,00Cell Free + HCMEC D3_line
      2866       ECIS        4       no 20,00Cell Free + HCMEC D3_line
      2867       ECIS        4       no 20,00Cell Free + HCMEC D3_line
      2868       ECIS        4       no 20,00Cell Free + HCMEC D3_line
      2869       ECIS        5       no 15,00Cell Free + HCMEC D3_line
      2870       ECIS        5       no 15,00Cell Free + HCMEC D3_line
      2871       ECIS        5       no 15,00Cell Free + HCMEC D3_line
      2872       ECIS        6       no 10,00Cell Free + HCMEC D3_line
      2873       ECIS        6       no 10,00Cell Free + HCMEC D3_line
      2874       ECIS        6       no 10,00Cell Free + HCMEC D3_line
      2875       ECIS        7       no  5,00Cell Free + HCMEC D3_line
      2876       ECIS        7       no  5,00Cell Free + HCMEC D3_line
      2877       ECIS        7       no  5,00Cell Free + HCMEC D3_line
      2878       ECIS        1       no 35,00Cell Free + HCMEC D3_line
      2879       ECIS        1       no 35,00Cell Free + HCMEC D3_line
      2880       ECIS        1       no 35,00Cell Free + HCMEC D3_line
      2881       ECIS        2       no 30,00Cell Free + HCMEC D3_line
      2882       ECIS        2       no 30,00Cell Free + HCMEC D3_line
      2883       ECIS        2       no 30,00Cell Free + HCMEC D3_line
      2884       ECIS        3       no 25,00Cell Free + HCMEC D3_line
      2885       ECIS        3       no 25,00Cell Free + HCMEC D3_line
      2886       ECIS        3       no 25,00Cell Free + HCMEC D3_line
      2887       ECIS        4       no 20,00Cell Free + HCMEC D3_line
      2888       ECIS        4       no 20,00Cell Free + HCMEC D3_line
      2889       ECIS        4       no 20,00Cell Free + HCMEC D3_line
      2890       ECIS        5       no 15,00Cell Free + HCMEC D3_line
      2891       ECIS        5       no 15,00Cell Free + HCMEC D3_line
      2892       ECIS        5       no 15,00Cell Free + HCMEC D3_line
      2893       ECIS        6       no 10,00Cell Free + HCMEC D3_line
      2894       ECIS        6       no 10,00Cell Free + HCMEC D3_line
      2895       ECIS        6       no 10,00Cell Free + HCMEC D3_line
      2896       ECIS        7       no  5,00Cell Free + HCMEC D3_line
      2897       ECIS        7       no  5,00Cell Free + HCMEC D3_line
      2898       ECIS        7       no  5,00Cell Free + HCMEC D3_line
      2899       ECIS        1       no 35,00Cell Free + HCMEC D3_line
      2900       ECIS        1       no 35,00Cell Free + HCMEC D3_line
      2901       ECIS        1       no 35,00Cell Free + HCMEC D3_line
      2902       ECIS        2       no 30,00Cell Free + HCMEC D3_line
      2903       ECIS        2       no 30,00Cell Free + HCMEC D3_line
      2904       ECIS        2       no 30,00Cell Free + HCMEC D3_line
      2905       ECIS        3       no 25,00Cell Free + HCMEC D3_line
      2906       ECIS        3       no 25,00Cell Free + HCMEC D3_line
      2907       ECIS        3       no 25,00Cell Free + HCMEC D3_line
      2908       ECIS        4       no 20,00Cell Free + HCMEC D3_line
      2909       ECIS        4       no 20,00Cell Free + HCMEC D3_line
      2910       ECIS        4       no 20,00Cell Free + HCMEC D3_line
      2911       ECIS        5       no 15,00Cell Free + HCMEC D3_line
      2912       ECIS        5       no 15,00Cell Free + HCMEC D3_line
      2913       ECIS        5       no 15,00Cell Free + HCMEC D3_line
      2914       ECIS        6       no 10,00Cell Free + HCMEC D3_line
      2915       ECIS        6       no 10,00Cell Free + HCMEC D3_line
      2916       ECIS        6       no 10,00Cell Free + HCMEC D3_line
      2917       ECIS        7       no  5,00Cell Free + HCMEC D3_line
      2918       ECIS        7       no  5,00Cell Free + HCMEC D3_line
      2919       ECIS        7       no  5,00Cell Free + HCMEC D3_line
      2920       ECIS        1       no 35,00Cell Free + HCMEC D3_line
      2921       ECIS        1       no 35,00Cell Free + HCMEC D3_line
      2922       ECIS        1       no 35,00Cell Free + HCMEC D3_line
      2923       ECIS        2       no 30,00Cell Free + HCMEC D3_line
      2924       ECIS        2       no 30,00Cell Free + HCMEC D3_line
      2925       ECIS        2       no 30,00Cell Free + HCMEC D3_line
      2926       ECIS        3       no 25,00Cell Free + HCMEC D3_line
      2927       ECIS        3       no 25,00Cell Free + HCMEC D3_line
      2928       ECIS        3       no 25,00Cell Free + HCMEC D3_line
      2929       ECIS        4       no 20,00Cell Free + HCMEC D3_line
      2930       ECIS        4       no 20,00Cell Free + HCMEC D3_line
      2931       ECIS        4       no 20,00Cell Free + HCMEC D3_line
      2932       ECIS        5       no 15,00Cell Free + HCMEC D3_line
      2933       ECIS        5       no 15,00Cell Free + HCMEC D3_line
      2934       ECIS        5       no 15,00Cell Free + HCMEC D3_line
      2935       ECIS        6       no 10,00Cell Free + HCMEC D3_line
      2936       ECIS        6       no 10,00Cell Free + HCMEC D3_line
      2937       ECIS        6       no 10,00Cell Free + HCMEC D3_line
      2938       ECIS        7       no  5,00Cell Free + HCMEC D3_line
      2939       ECIS        7       no  5,00Cell Free + HCMEC D3_line
      2940       ECIS        7       no  5,00Cell Free + HCMEC D3_line
      2941       ECIS        1       no 35,00Cell Free + HCMEC D3_line
      2942       ECIS        1       no 35,00Cell Free + HCMEC D3_line
      2943       ECIS        1       no 35,00Cell Free + HCMEC D3_line
      2944       ECIS        2       no 30,00Cell Free + HCMEC D3_line
      2945       ECIS        2       no 30,00Cell Free + HCMEC D3_line
      2946       ECIS        2       no 30,00Cell Free + HCMEC D3_line
      2947       ECIS        3       no 25,00Cell Free + HCMEC D3_line
      2948       ECIS        3       no 25,00Cell Free + HCMEC D3_line
      2949       ECIS        3       no 25,00Cell Free + HCMEC D3_line
      2950       ECIS        4       no 20,00Cell Free + HCMEC D3_line
      2951       ECIS        4       no 20,00Cell Free + HCMEC D3_line
      2952       ECIS        4       no 20,00Cell Free + HCMEC D3_line
      2953       ECIS        5       no 15,00Cell Free + HCMEC D3_line
      2954       ECIS        5       no 15,00Cell Free + HCMEC D3_line
      2955       ECIS        5       no 15,00Cell Free + HCMEC D3_line
      2956       ECIS        6       no 10,00Cell Free + HCMEC D3_line
      2957       ECIS        6       no 10,00Cell Free + HCMEC D3_line
      2958       ECIS        6       no 10,00Cell Free + HCMEC D3_line
      2959       ECIS        7       no  5,00Cell Free + HCMEC D3_line
      2960       ECIS        7       no  5,00Cell Free + HCMEC D3_line
      2961       ECIS        7       no  5,00Cell Free + HCMEC D3_line
      2962       ECIS        1       no 35,00Cell Free + HCMEC D3_line
      2963       ECIS        1       no 35,00Cell Free + HCMEC D3_line
      2964       ECIS        1       no 35,00Cell Free + HCMEC D3_line
      2965       ECIS        2       no 30,00Cell Free + HCMEC D3_line
      2966       ECIS        2       no 30,00Cell Free + HCMEC D3_line
      2967       ECIS        2       no 30,00Cell Free + HCMEC D3_line
      2968       ECIS        3       no 25,00Cell Free + HCMEC D3_line
      2969       ECIS        3       no 25,00Cell Free + HCMEC D3_line
      2970       ECIS        3       no 25,00Cell Free + HCMEC D3_line
      2971       ECIS        4       no 20,00Cell Free + HCMEC D3_line
      2972       ECIS        4       no 20,00Cell Free + HCMEC D3_line
      2973       ECIS        4       no 20,00Cell Free + HCMEC D3_line
      2974       ECIS        5       no 15,00Cell Free + HCMEC D3_line
      2975       ECIS        5       no 15,00Cell Free + HCMEC D3_line
      2976       ECIS        5       no 15,00Cell Free + HCMEC D3_line
      2977       ECIS        6       no 10,00Cell Free + HCMEC D3_line
      2978       ECIS        6       no 10,00Cell Free + HCMEC D3_line
      2979       ECIS        6       no 10,00Cell Free + HCMEC D3_line
      2980       ECIS        7       no  5,00Cell Free + HCMEC D3_line
      2981       ECIS        7       no  5,00Cell Free + HCMEC D3_line
      2982       ECIS        7       no  5,00Cell Free + HCMEC D3_line
      2983       ECIS        1       no 35,00Cell Free + HCMEC D3_line
      2984       ECIS        1       no 35,00Cell Free + HCMEC D3_line
      2985       ECIS        1       no 35,00Cell Free + HCMEC D3_line
      2986       ECIS        2       no 30,00Cell Free + HCMEC D3_line
      2987       ECIS        2       no 30,00Cell Free + HCMEC D3_line
      2988       ECIS        2       no 30,00Cell Free + HCMEC D3_line
      2989       ECIS        3       no 25,00Cell Free + HCMEC D3_line
      2990       ECIS        3       no 25,00Cell Free + HCMEC D3_line
      2991       ECIS        3       no 25,00Cell Free + HCMEC D3_line
      2992       ECIS        4       no 20,00Cell Free + HCMEC D3_line
      2993       ECIS        4       no 20,00Cell Free + HCMEC D3_line
      2994       ECIS        4       no 20,00Cell Free + HCMEC D3_line
      2995       ECIS        5       no 15,00Cell Free + HCMEC D3_line
      2996       ECIS        5       no 15,00Cell Free + HCMEC D3_line
      2997       ECIS        5       no 15,00Cell Free + HCMEC D3_line
      2998       ECIS        6       no 10,00Cell Free + HCMEC D3_line
      2999       ECIS        6       no 10,00Cell Free + HCMEC D3_line
      3000       ECIS        6       no 10,00Cell Free + HCMEC D3_line
      3001       ECIS        7       no  5,00Cell Free + HCMEC D3_line
      3002       ECIS        7       no  5,00Cell Free + HCMEC D3_line
      3003       ECIS        7       no  5,00Cell Free + HCMEC D3_line
      3004       ECIS        1       no 35,00Cell Free + HCMEC D3_line
      3005       ECIS        1       no 35,00Cell Free + HCMEC D3_line
      3006       ECIS        1       no 35,00Cell Free + HCMEC D3_line
      3007       ECIS        2       no 30,00Cell Free + HCMEC D3_line
      3008       ECIS        2       no 30,00Cell Free + HCMEC D3_line
      3009       ECIS        2       no 30,00Cell Free + HCMEC D3_line
      3010       ECIS        3       no 25,00Cell Free + HCMEC D3_line
      3011       ECIS        3       no 25,00Cell Free + HCMEC D3_line
      3012       ECIS        3       no 25,00Cell Free + HCMEC D3_line
      3013       ECIS        4       no 20,00Cell Free + HCMEC D3_line
      3014       ECIS        4       no 20,00Cell Free + HCMEC D3_line
      3015       ECIS        4       no 20,00Cell Free + HCMEC D3_line
      3016       ECIS        5       no 15,00Cell Free + HCMEC D3_line
      3017       ECIS        5       no 15,00Cell Free + HCMEC D3_line
      3018       ECIS        5       no 15,00Cell Free + HCMEC D3_line
      3019       ECIS        6       no 10,00Cell Free + HCMEC D3_line
      3020       ECIS        6       no 10,00Cell Free + HCMEC D3_line
      3021       ECIS        6       no 10,00Cell Free + HCMEC D3_line
      3022       ECIS        7       no  5,00Cell Free + HCMEC D3_line
      3023       ECIS        7       no  5,00Cell Free + HCMEC D3_line
      3024       ECIS        7       no  5,00Cell Free + HCMEC D3_line
      3025       ECIS        1       no 35,00Cell Free + HCMEC D3_line
      3026       ECIS        1       no 35,00Cell Free + HCMEC D3_line
      3027       ECIS        1       no 35,00Cell Free + HCMEC D3_line
      3028       ECIS        2       no 30,00Cell Free + HCMEC D3_line
      3029       ECIS        2       no 30,00Cell Free + HCMEC D3_line
      3030       ECIS        2       no 30,00Cell Free + HCMEC D3_line
      3031       ECIS        3       no 25,00Cell Free + HCMEC D3_line
      3032       ECIS        3       no 25,00Cell Free + HCMEC D3_line
      3033       ECIS        3       no 25,00Cell Free + HCMEC D3_line
      3034       ECIS        4       no 20,00Cell Free + HCMEC D3_line
      3035       ECIS        4       no 20,00Cell Free + HCMEC D3_line
      3036       ECIS        4       no 20,00Cell Free + HCMEC D3_line
      3037       ECIS        5       no 15,00Cell Free + HCMEC D3_line
      3038       ECIS        5       no 15,00Cell Free + HCMEC D3_line
      3039       ECIS        5       no 15,00Cell Free + HCMEC D3_line
      3040       ECIS        6       no 10,00Cell Free + HCMEC D3_line
      3041       ECIS        6       no 10,00Cell Free + HCMEC D3_line
      3042       ECIS        6       no 10,00Cell Free + HCMEC D3_line
      3043       ECIS        7       no  5,00Cell Free + HCMEC D3_line
      3044       ECIS        7       no  5,00Cell Free + HCMEC D3_line
      3045       ECIS        7       no  5,00Cell Free + HCMEC D3_line
      3046       ECIS        1       no 35,00Cell Free + HCMEC D3_line
      3047       ECIS        1       no 35,00Cell Free + HCMEC D3_line
      3048       ECIS        1       no 35,00Cell Free + HCMEC D3_line
      3049       ECIS        2       no 30,00Cell Free + HCMEC D3_line
      3050       ECIS        2       no 30,00Cell Free + HCMEC D3_line
      3051       ECIS        2       no 30,00Cell Free + HCMEC D3_line
      3052       ECIS        3       no 25,00Cell Free + HCMEC D3_line
      3053       ECIS        3       no 25,00Cell Free + HCMEC D3_line
      3054       ECIS        3       no 25,00Cell Free + HCMEC D3_line
      3055       ECIS        4       no 20,00Cell Free + HCMEC D3_line
      3056       ECIS        4       no 20,00Cell Free + HCMEC D3_line
      3057       ECIS        4       no 20,00Cell Free + HCMEC D3_line
      3058       ECIS        5       no 15,00Cell Free + HCMEC D3_line
      3059       ECIS        5       no 15,00Cell Free + HCMEC D3_line
      3060       ECIS        5       no 15,00Cell Free + HCMEC D3_line
      3061       ECIS        6       no 10,00Cell Free + HCMEC D3_line
      3062       ECIS        6       no 10,00Cell Free + HCMEC D3_line
      3063       ECIS        6       no 10,00Cell Free + HCMEC D3_line
      3064       ECIS        7       no  5,00Cell Free + HCMEC D3_line
      3065       ECIS        7       no  5,00Cell Free + HCMEC D3_line
      3066       ECIS        7       no  5,00Cell Free + HCMEC D3_line
      3067       ECIS        1       no 35,00Cell Free + HCMEC D3_line
      3068       ECIS        1       no 35,00Cell Free + HCMEC D3_line
      3069       ECIS        1       no 35,00Cell Free + HCMEC D3_line
      3070       ECIS        2       no 30,00Cell Free + HCMEC D3_line
      3071       ECIS        2       no 30,00Cell Free + HCMEC D3_line
      3072       ECIS        2       no 30,00Cell Free + HCMEC D3_line
      3073       ECIS        3       no 25,00Cell Free + HCMEC D3_line
      3074       ECIS        3       no 25,00Cell Free + HCMEC D3_line
      3075       ECIS        3       no 25,00Cell Free + HCMEC D3_line
      3076       ECIS        4       no 20,00Cell Free + HCMEC D3_line
      3077       ECIS        4       no 20,00Cell Free + HCMEC D3_line
      3078       ECIS        4       no 20,00Cell Free + HCMEC D3_line
      3079       ECIS        5       no 15,00Cell Free + HCMEC D3_line
      3080       ECIS        5       no 15,00Cell Free + HCMEC D3_line
      3081       ECIS        5       no 15,00Cell Free + HCMEC D3_line
      3082       ECIS        6       no 10,00Cell Free + HCMEC D3_line
      3083       ECIS        6       no 10,00Cell Free + HCMEC D3_line
      3084       ECIS        6       no 10,00Cell Free + HCMEC D3_line
      3085       ECIS        7       no  5,00Cell Free + HCMEC D3_line
      3086       ECIS        7       no  5,00Cell Free + HCMEC D3_line
      3087       ECIS        7       no  5,00Cell Free + HCMEC D3_line
      3088       ECIS        1       no 35,00Cell Free + HCMEC D3_line
      3089       ECIS        1       no 35,00Cell Free + HCMEC D3_line
      3090       ECIS        1       no 35,00Cell Free + HCMEC D3_line
      3091       ECIS        2       no 30,00Cell Free + HCMEC D3_line
      3092       ECIS        2       no 30,00Cell Free + HCMEC D3_line
      3093       ECIS        2       no 30,00Cell Free + HCMEC D3_line
      3094       ECIS        3       no 25,00Cell Free + HCMEC D3_line
      3095       ECIS        3       no 25,00Cell Free + HCMEC D3_line
      3096       ECIS        3       no 25,00Cell Free + HCMEC D3_line
      3097       ECIS        4       no 20,00Cell Free + HCMEC D3_line
      3098       ECIS        4       no 20,00Cell Free + HCMEC D3_line
      3099       ECIS        4       no 20,00Cell Free + HCMEC D3_line
      3100       ECIS        5       no 15,00Cell Free + HCMEC D3_line
      3101       ECIS        5       no 15,00Cell Free + HCMEC D3_line
      3102       ECIS        5       no 15,00Cell Free + HCMEC D3_line
      3103       ECIS        6       no 10,00Cell Free + HCMEC D3_line
      3104       ECIS        6       no 10,00Cell Free + HCMEC D3_line
      3105       ECIS        6       no 10,00Cell Free + HCMEC D3_line
      3106       ECIS        7       no  5,00Cell Free + HCMEC D3_line
      3107       ECIS        7       no  5,00Cell Free + HCMEC D3_line
      3108       ECIS        7       no  5,00Cell Free + HCMEC D3_line
      3109       ECIS        1       no 35,00Cell Free + HCMEC D3_line
      3110       ECIS        1       no 35,00Cell Free + HCMEC D3_line
      3111       ECIS        1       no 35,00Cell Free + HCMEC D3_line
      3112       ECIS        2       no 30,00Cell Free + HCMEC D3_line
      3113       ECIS        2       no 30,00Cell Free + HCMEC D3_line
      3114       ECIS        2       no 30,00Cell Free + HCMEC D3_line
      3115       ECIS        3       no 25,00Cell Free + HCMEC D3_line
      3116       ECIS        3       no 25,00Cell Free + HCMEC D3_line
      3117       ECIS        3       no 25,00Cell Free + HCMEC D3_line
      3118       ECIS        4       no 20,00Cell Free + HCMEC D3_line
      3119       ECIS        4       no 20,00Cell Free + HCMEC D3_line
      3120       ECIS        4       no 20,00Cell Free + HCMEC D3_line
      3121       ECIS        5       no 15,00Cell Free + HCMEC D3_line
      3122       ECIS        5       no 15,00Cell Free + HCMEC D3_line
      3123       ECIS        5       no 15,00Cell Free + HCMEC D3_line
      3124       ECIS        6       no 10,00Cell Free + HCMEC D3_line
      3125       ECIS        6       no 10,00Cell Free + HCMEC D3_line
      3126       ECIS        6       no 10,00Cell Free + HCMEC D3_line
      3127       ECIS        7       no  5,00Cell Free + HCMEC D3_line
      3128       ECIS        7       no  5,00Cell Free + HCMEC D3_line
      3129       ECIS        7       no  5,00Cell Free + HCMEC D3_line
      3130       ECIS        1       no 35,00Cell Free + HCMEC D3_line
      3131       ECIS        1       no 35,00Cell Free + HCMEC D3_line
      3132       ECIS        1       no 35,00Cell Free + HCMEC D3_line
      3133       ECIS        2       no 30,00Cell Free + HCMEC D3_line
      3134       ECIS        2       no 30,00Cell Free + HCMEC D3_line
      3135       ECIS        2       no 30,00Cell Free + HCMEC D3_line
      3136       ECIS        3       no 25,00Cell Free + HCMEC D3_line
      3137       ECIS        3       no 25,00Cell Free + HCMEC D3_line
      3138       ECIS        3       no 25,00Cell Free + HCMEC D3_line
      3139       ECIS        4       no 20,00Cell Free + HCMEC D3_line
      3140       ECIS        4       no 20,00Cell Free + HCMEC D3_line
      3141       ECIS        4       no 20,00Cell Free + HCMEC D3_line
      3142       ECIS        5       no 15,00Cell Free + HCMEC D3_line
      3143       ECIS        5       no 15,00Cell Free + HCMEC D3_line
      3144       ECIS        5       no 15,00Cell Free + HCMEC D3_line
      3145       ECIS        6       no 10,00Cell Free + HCMEC D3_line
      3146       ECIS        6       no 10,00Cell Free + HCMEC D3_line
      3147       ECIS        6       no 10,00Cell Free + HCMEC D3_line
      3148       ECIS        7       no  5,00Cell Free + HCMEC D3_line
      3149       ECIS        7       no  5,00Cell Free + HCMEC D3_line
      3150       ECIS        7       no  5,00Cell Free + HCMEC D3_line
      3151       ECIS        1       no 35,00Cell Free + HCMEC D3_line
      3152       ECIS        1       no 35,00Cell Free + HCMEC D3_line
      3153       ECIS        1       no 35,00Cell Free + HCMEC D3_line
      3154       ECIS        2       no 30,00Cell Free + HCMEC D3_line
      3155       ECIS        2       no 30,00Cell Free + HCMEC D3_line
      3156       ECIS        2       no 30,00Cell Free + HCMEC D3_line
      3157       ECIS        3       no 25,00Cell Free + HCMEC D3_line
      3158       ECIS        3       no 25,00Cell Free + HCMEC D3_line
      3159       ECIS        3       no 25,00Cell Free + HCMEC D3_line
      3160       ECIS        4       no 20,00Cell Free + HCMEC D3_line
      3161       ECIS        4       no 20,00Cell Free + HCMEC D3_line
      3162       ECIS        4       no 20,00Cell Free + HCMEC D3_line
      3163       ECIS        5       no 15,00Cell Free + HCMEC D3_line
      3164       ECIS        5       no 15,00Cell Free + HCMEC D3_line
      3165       ECIS        5       no 15,00Cell Free + HCMEC D3_line
      3166       ECIS        6       no 10,00Cell Free + HCMEC D3_line
      3167       ECIS        6       no 10,00Cell Free + HCMEC D3_line
      3168       ECIS        6       no 10,00Cell Free + HCMEC D3_line
      3169       ECIS        7       no  5,00Cell Free + HCMEC D3_line
      3170       ECIS        7       no  5,00Cell Free + HCMEC D3_line
      3171       ECIS        7       no  5,00Cell Free + HCMEC D3_line
      3172       ECIS        1       no 35,00Cell Free + HCMEC D3_line
      3173       ECIS        1       no 35,00Cell Free + HCMEC D3_line
      3174       ECIS        1       no 35,00Cell Free + HCMEC D3_line
      3175       ECIS        2       no 30,00Cell Free + HCMEC D3_line
      3176       ECIS        2       no 30,00Cell Free + HCMEC D3_line
      3177       ECIS        2       no 30,00Cell Free + HCMEC D3_line
      3178       ECIS        3       no 25,00Cell Free + HCMEC D3_line
      3179       ECIS        3       no 25,00Cell Free + HCMEC D3_line
      3180       ECIS        3       no 25,00Cell Free + HCMEC D3_line
      3181       ECIS        4       no 20,00Cell Free + HCMEC D3_line
      3182       ECIS        4       no 20,00Cell Free + HCMEC D3_line
      3183       ECIS        4       no 20,00Cell Free + HCMEC D3_line
      3184       ECIS        5       no 15,00Cell Free + HCMEC D3_line
      3185       ECIS        5       no 15,00Cell Free + HCMEC D3_line
      3186       ECIS        5       no 15,00Cell Free + HCMEC D3_line
      3187       ECIS        6       no 10,00Cell Free + HCMEC D3_line
      3188       ECIS        6       no 10,00Cell Free + HCMEC D3_line
      3189       ECIS        6       no 10,00Cell Free + HCMEC D3_line
      3190       ECIS        7       no  5,00Cell Free + HCMEC D3_line
      3191       ECIS        7       no  5,00Cell Free + HCMEC D3_line
      3192       ECIS        7       no  5,00Cell Free + HCMEC D3_line
      3193       ECIS        1       no 35,00Cell Free + HCMEC D3_line
      3194       ECIS        1       no 35,00Cell Free + HCMEC D3_line
      3195       ECIS        1       no 35,00Cell Free + HCMEC D3_line
      3196       ECIS        2       no 30,00Cell Free + HCMEC D3_line
      3197       ECIS        2       no 30,00Cell Free + HCMEC D3_line
      3198       ECIS        2       no 30,00Cell Free + HCMEC D3_line
      3199       ECIS        3       no 25,00Cell Free + HCMEC D3_line
      3200       ECIS        3       no 25,00Cell Free + HCMEC D3_line
      3201       ECIS        3       no 25,00Cell Free + HCMEC D3_line
      3202       ECIS        4       no 20,00Cell Free + HCMEC D3_line
      3203       ECIS        4       no 20,00Cell Free + HCMEC D3_line
      3204       ECIS        4       no 20,00Cell Free + HCMEC D3_line
      3205       ECIS        5       no 15,00Cell Free + HCMEC D3_line
      3206       ECIS        5       no 15,00Cell Free + HCMEC D3_line
      3207       ECIS        5       no 15,00Cell Free + HCMEC D3_line
      3208       ECIS        6       no 10,00Cell Free + HCMEC D3_line
      3209       ECIS        6       no 10,00Cell Free + HCMEC D3_line
      3210       ECIS        6       no 10,00Cell Free + HCMEC D3_line
      3211       ECIS        7       no  5,00Cell Free + HCMEC D3_line
      3212       ECIS        7       no  5,00Cell Free + HCMEC D3_line
      3213       ECIS        7       no  5,00Cell Free + HCMEC D3_line
      3214       ECIS        1       no 35,00Cell Free + HCMEC D3_line
      3215       ECIS        1       no 35,00Cell Free + HCMEC D3_line
      3216       ECIS        1       no 35,00Cell Free + HCMEC D3_line
      3217       ECIS        2       no 30,00Cell Free + HCMEC D3_line
      3218       ECIS        2       no 30,00Cell Free + HCMEC D3_line
      3219       ECIS        2       no 30,00Cell Free + HCMEC D3_line
      3220       ECIS        3       no 25,00Cell Free + HCMEC D3_line
      3221       ECIS        3       no 25,00Cell Free + HCMEC D3_line
      3222       ECIS        3       no 25,00Cell Free + HCMEC D3_line
      3223       ECIS        4       no 20,00Cell Free + HCMEC D3_line
      3224       ECIS        4       no 20,00Cell Free + HCMEC D3_line
      3225       ECIS        4       no 20,00Cell Free + HCMEC D3_line
      3226       ECIS        5       no 15,00Cell Free + HCMEC D3_line
      3227       ECIS        5       no 15,00Cell Free + HCMEC D3_line
      3228       ECIS        5       no 15,00Cell Free + HCMEC D3_line
      3229       ECIS        6       no 10,00Cell Free + HCMEC D3_line
      3230       ECIS        6       no 10,00Cell Free + HCMEC D3_line
      3231       ECIS        6       no 10,00Cell Free + HCMEC D3_line
      3232       ECIS        7       no  5,00Cell Free + HCMEC D3_line
      3233       ECIS        7       no  5,00Cell Free + HCMEC D3_line
      3234       ECIS        7       no  5,00Cell Free + HCMEC D3_line
      3235       ECIS        1       no 35,00Cell Free + HCMEC D3_line
      3236       ECIS        1       no 35,00Cell Free + HCMEC D3_line
      3237       ECIS        1       no 35,00Cell Free + HCMEC D3_line
      3238       ECIS        2       no 30,00Cell Free + HCMEC D3_line
      3239       ECIS        2       no 30,00Cell Free + HCMEC D3_line
      3240       ECIS        2       no 30,00Cell Free + HCMEC D3_line
      3241       ECIS        3       no 25,00Cell Free + HCMEC D3_line
      3242       ECIS        3       no 25,00Cell Free + HCMEC D3_line
      3243       ECIS        3       no 25,00Cell Free + HCMEC D3_line
      3244       ECIS        4       no 20,00Cell Free + HCMEC D3_line
      3245       ECIS        4       no 20,00Cell Free + HCMEC D3_line
      3246       ECIS        4       no 20,00Cell Free + HCMEC D3_line
      3247       ECIS        5       no 15,00Cell Free + HCMEC D3_line
      3248       ECIS        5       no 15,00Cell Free + HCMEC D3_line
      3249       ECIS        5       no 15,00Cell Free + HCMEC D3_line
      3250       ECIS        6       no 10,00Cell Free + HCMEC D3_line
      3251       ECIS        6       no 10,00Cell Free + HCMEC D3_line
      3252       ECIS        6       no 10,00Cell Free + HCMEC D3_line
      3253       ECIS        7       no  5,00Cell Free + HCMEC D3_line
      3254       ECIS        7       no  5,00Cell Free + HCMEC D3_line
      3255       ECIS        7       no  5,00Cell Free + HCMEC D3_line
      3256       ECIS        1       no 35,00Cell Free + HCMEC D3_line
      3257       ECIS        1       no 35,00Cell Free + HCMEC D3_line
      3258       ECIS        1       no 35,00Cell Free + HCMEC D3_line
      3259       ECIS        2       no 30,00Cell Free + HCMEC D3_line
      3260       ECIS        2       no 30,00Cell Free + HCMEC D3_line
      3261       ECIS        2       no 30,00Cell Free + HCMEC D3_line
      3262       ECIS        3       no 25,00Cell Free + HCMEC D3_line
      3263       ECIS        3       no 25,00Cell Free + HCMEC D3_line
      3264       ECIS        3       no 25,00Cell Free + HCMEC D3_line
      3265       ECIS        4       no 20,00Cell Free + HCMEC D3_line
      3266       ECIS        4       no 20,00Cell Free + HCMEC D3_line
      3267       ECIS        4       no 20,00Cell Free + HCMEC D3_line
      3268       ECIS        5       no 15,00Cell Free + HCMEC D3_line
      3269       ECIS        5       no 15,00Cell Free + HCMEC D3_line
      3270       ECIS        5       no 15,00Cell Free + HCMEC D3_line
      3271       ECIS        6       no 10,00Cell Free + HCMEC D3_line
      3272       ECIS        6       no 10,00Cell Free + HCMEC D3_line
      3273       ECIS        6       no 10,00Cell Free + HCMEC D3_line
      3274       ECIS        7       no  5,00Cell Free + HCMEC D3_line
      3275       ECIS        7       no  5,00Cell Free + HCMEC D3_line
      3276       ECIS        7       no  5,00Cell Free + HCMEC D3_line
      3277       ECIS        1       no 35,00Cell Free + HCMEC D3_line
      3278       ECIS        1       no 35,00Cell Free + HCMEC D3_line
      3279       ECIS        1       no 35,00Cell Free + HCMEC D3_line
      3280       ECIS        2       no 30,00Cell Free + HCMEC D3_line
      3281       ECIS        2       no 30,00Cell Free + HCMEC D3_line
      3282       ECIS        2       no 30,00Cell Free + HCMEC D3_line
      3283       ECIS        3       no 25,00Cell Free + HCMEC D3_line
      3284       ECIS        3       no 25,00Cell Free + HCMEC D3_line
      3285       ECIS        3       no 25,00Cell Free + HCMEC D3_line
      3286       ECIS        4       no 20,00Cell Free + HCMEC D3_line
      3287       ECIS        4       no 20,00Cell Free + HCMEC D3_line
      3288       ECIS        4       no 20,00Cell Free + HCMEC D3_line
      3289       ECIS        5       no 15,00Cell Free + HCMEC D3_line
      3290       ECIS        5       no 15,00Cell Free + HCMEC D3_line
      3291       ECIS        5       no 15,00Cell Free + HCMEC D3_line
      3292       ECIS        6       no 10,00Cell Free + HCMEC D3_line
      3293       ECIS        6       no 10,00Cell Free + HCMEC D3_line
      3294       ECIS        6       no 10,00Cell Free + HCMEC D3_line
      3295       ECIS        7       no  5,00Cell Free + HCMEC D3_line
      3296       ECIS        7       no  5,00Cell Free + HCMEC D3_line
      3297       ECIS        7       no  5,00Cell Free + HCMEC D3_line
      3298       ECIS        1       no 35,00Cell Free + HCMEC D3_line
      3299       ECIS        1       no 35,00Cell Free + HCMEC D3_line
      3300       ECIS        1       no 35,00Cell Free + HCMEC D3_line
      3301       ECIS        2       no 30,00Cell Free + HCMEC D3_line
      3302       ECIS        2       no 30,00Cell Free + HCMEC D3_line
      3303       ECIS        2       no 30,00Cell Free + HCMEC D3_line
      3304       ECIS        3       no 25,00Cell Free + HCMEC D3_line
      3305       ECIS        3       no 25,00Cell Free + HCMEC D3_line
      3306       ECIS        3       no 25,00Cell Free + HCMEC D3_line
      3307       ECIS        4       no 20,00Cell Free + HCMEC D3_line
      3308       ECIS        4       no 20,00Cell Free + HCMEC D3_line
      3309       ECIS        4       no 20,00Cell Free + HCMEC D3_line
      3310       ECIS        5       no 15,00Cell Free + HCMEC D3_line
      3311       ECIS        5       no 15,00Cell Free + HCMEC D3_line
      3312       ECIS        5       no 15,00Cell Free + HCMEC D3_line
      3313       ECIS        6       no 10,00Cell Free + HCMEC D3_line
      3314       ECIS        6       no 10,00Cell Free + HCMEC D3_line
      3315       ECIS        6       no 10,00Cell Free + HCMEC D3_line
      3316       ECIS        7       no  5,00Cell Free + HCMEC D3_line
      3317       ECIS        7       no  5,00Cell Free + HCMEC D3_line
      3318       ECIS        7       no  5,00Cell Free + HCMEC D3_line
      3319       ECIS        1       no 35,00Cell Free + HCMEC D3_line
      3320       ECIS        1       no 35,00Cell Free + HCMEC D3_line
      3321       ECIS        1       no 35,00Cell Free + HCMEC D3_line
      3322       ECIS        2       no 30,00Cell Free + HCMEC D3_line
      3323       ECIS        2       no 30,00Cell Free + HCMEC D3_line
      3324       ECIS        2       no 30,00Cell Free + HCMEC D3_line
      3325       ECIS        3       no 25,00Cell Free + HCMEC D3_line
      3326       ECIS        3       no 25,00Cell Free + HCMEC D3_line
      3327       ECIS        3       no 25,00Cell Free + HCMEC D3_line
      3328       ECIS        4       no 20,00Cell Free + HCMEC D3_line
      3329       ECIS        4       no 20,00Cell Free + HCMEC D3_line
      3330       ECIS        4       no 20,00Cell Free + HCMEC D3_line
      3331       ECIS        5       no 15,00Cell Free + HCMEC D3_line
      3332       ECIS        5       no 15,00Cell Free + HCMEC D3_line
      3333       ECIS        5       no 15,00Cell Free + HCMEC D3_line
      3334       ECIS        6       no 10,00Cell Free + HCMEC D3_line
      3335       ECIS        6       no 10,00Cell Free + HCMEC D3_line
      3336       ECIS        6       no 10,00Cell Free + HCMEC D3_line
      3337       ECIS        7       no  5,00Cell Free + HCMEC D3_line
      3338       ECIS        7       no  5,00Cell Free + HCMEC D3_line
      3339       ECIS        7       no  5,00Cell Free + HCMEC D3_line
      3340       ECIS        1       no 35,00Cell Free + HCMEC D3_line
      3341       ECIS        1       no 35,00Cell Free + HCMEC D3_line
      3342       ECIS        1       no 35,00Cell Free + HCMEC D3_line
      3343       ECIS        2       no 30,00Cell Free + HCMEC D3_line
      3344       ECIS        2       no 30,00Cell Free + HCMEC D3_line
      3345       ECIS        2       no 30,00Cell Free + HCMEC D3_line
      3346       ECIS        3       no 25,00Cell Free + HCMEC D3_line
      3347       ECIS        3       no 25,00Cell Free + HCMEC D3_line
      3348       ECIS        3       no 25,00Cell Free + HCMEC D3_line
      3349       ECIS        4       no 20,00Cell Free + HCMEC D3_line
      3350       ECIS        4       no 20,00Cell Free + HCMEC D3_line
      3351       ECIS        4       no 20,00Cell Free + HCMEC D3_line
      3352       ECIS        5       no 15,00Cell Free + HCMEC D3_line
      3353       ECIS        5       no 15,00Cell Free + HCMEC D3_line
      3354       ECIS        5       no 15,00Cell Free + HCMEC D3_line
      3355       ECIS        6       no 10,00Cell Free + HCMEC D3_line
      3356       ECIS        6       no 10,00Cell Free + HCMEC D3_line
      3357       ECIS        6       no 10,00Cell Free + HCMEC D3_line
      3358       ECIS        7       no  5,00Cell Free + HCMEC D3_line
      3359       ECIS        7       no  5,00Cell Free + HCMEC D3_line
      3360       ECIS        7       no  5,00Cell Free + HCMEC D3_line
      3361       ECIS        1       no 35,00Cell Free + HCMEC D3_line
      3362       ECIS        1       no 35,00Cell Free + HCMEC D3_line
      3363       ECIS        1       no 35,00Cell Free + HCMEC D3_line
      3364       ECIS        2       no 30,00Cell Free + HCMEC D3_line
      3365       ECIS        2       no 30,00Cell Free + HCMEC D3_line
      3366       ECIS        2       no 30,00Cell Free + HCMEC D3_line
      3367       ECIS        3       no 25,00Cell Free + HCMEC D3_line
      3368       ECIS        3       no 25,00Cell Free + HCMEC D3_line
      3369       ECIS        3       no 25,00Cell Free + HCMEC D3_line
      3370       ECIS        4       no 20,00Cell Free + HCMEC D3_line
      3371       ECIS        4       no 20,00Cell Free + HCMEC D3_line
      3372       ECIS        4       no 20,00Cell Free + HCMEC D3_line
      3373       ECIS        5       no 15,00Cell Free + HCMEC D3_line
      3374       ECIS        5       no 15,00Cell Free + HCMEC D3_line
      3375       ECIS        5       no 15,00Cell Free + HCMEC D3_line
      3376       ECIS        6       no 10,00Cell Free + HCMEC D3_line
      3377       ECIS        6       no 10,00Cell Free + HCMEC D3_line
      3378       ECIS        6       no 10,00Cell Free + HCMEC D3_line
      3379       ECIS        7       no  5,00Cell Free + HCMEC D3_line
      3380       ECIS        7       no  5,00Cell Free + HCMEC D3_line
      3381       ECIS        7       no  5,00Cell Free + HCMEC D3_line
      3382       ECIS        1       no 35,00Cell Free + HCMEC D3_line
      3383       ECIS        1       no 35,00Cell Free + HCMEC D3_line
      3384       ECIS        1       no 35,00Cell Free + HCMEC D3_line
      3385       ECIS        2       no 30,00Cell Free + HCMEC D3_line
      3386       ECIS        2       no 30,00Cell Free + HCMEC D3_line
      3387       ECIS        2       no 30,00Cell Free + HCMEC D3_line
      3388       ECIS        3       no 25,00Cell Free + HCMEC D3_line
      3389       ECIS        3       no 25,00Cell Free + HCMEC D3_line
      3390       ECIS        3       no 25,00Cell Free + HCMEC D3_line
      3391       ECIS        4       no 20,00Cell Free + HCMEC D3_line
      3392       ECIS        4       no 20,00Cell Free + HCMEC D3_line
      3393       ECIS        4       no 20,00Cell Free + HCMEC D3_line
      3394       ECIS        5       no 15,00Cell Free + HCMEC D3_line
      3395       ECIS        5       no 15,00Cell Free + HCMEC D3_line
      3396       ECIS        5       no 15,00Cell Free + HCMEC D3_line
      3397       ECIS        6       no 10,00Cell Free + HCMEC D3_line
      3398       ECIS        6       no 10,00Cell Free + HCMEC D3_line
      3399       ECIS        6       no 10,00Cell Free + HCMEC D3_line
      3400       ECIS        7       no  5,00Cell Free + HCMEC D3_line
      3401       ECIS        7       no  5,00Cell Free + HCMEC D3_line
      3402       ECIS        7       no  5,00Cell Free + HCMEC D3_line
      3403       ECIS        1       no 35,00Cell Free + HCMEC D3_line
      3404       ECIS        1       no 35,00Cell Free + HCMEC D3_line
      3405       ECIS        1       no 35,00Cell Free + HCMEC D3_line
      3406       ECIS        2       no 30,00Cell Free + HCMEC D3_line
      3407       ECIS        2       no 30,00Cell Free + HCMEC D3_line
      3408       ECIS        2       no 30,00Cell Free + HCMEC D3_line
      3409       ECIS        3       no 25,00Cell Free + HCMEC D3_line
      3410       ECIS        3       no 25,00Cell Free + HCMEC D3_line
      3411       ECIS        3       no 25,00Cell Free + HCMEC D3_line
      3412       ECIS        4       no 20,00Cell Free + HCMEC D3_line
      3413       ECIS        4       no 20,00Cell Free + HCMEC D3_line
      3414       ECIS        4       no 20,00Cell Free + HCMEC D3_line
      3415       ECIS        5       no 15,00Cell Free + HCMEC D3_line
      3416       ECIS        5       no 15,00Cell Free + HCMEC D3_line
      3417       ECIS        5       no 15,00Cell Free + HCMEC D3_line
      3418       ECIS        6       no 10,00Cell Free + HCMEC D3_line
      3419       ECIS        6       no 10,00Cell Free + HCMEC D3_line
      3420       ECIS        6       no 10,00Cell Free + HCMEC D3_line
      3421       ECIS        7       no  5,00Cell Free + HCMEC D3_line
      3422       ECIS        7       no  5,00Cell Free + HCMEC D3_line
      3423       ECIS        7       no  5,00Cell Free + HCMEC D3_line
      3424       ECIS        1       no 35,00Cell Free + HCMEC D3_line
      3425       ECIS        1       no 35,00Cell Free + HCMEC D3_line
      3426       ECIS        1       no 35,00Cell Free + HCMEC D3_line
      3427       ECIS        2       no 30,00Cell Free + HCMEC D3_line
      3428       ECIS        2       no 30,00Cell Free + HCMEC D3_line
      3429       ECIS        2       no 30,00Cell Free + HCMEC D3_line
      3430       ECIS        3       no 25,00Cell Free + HCMEC D3_line
      3431       ECIS        3       no 25,00Cell Free + HCMEC D3_line
      3432       ECIS        3       no 25,00Cell Free + HCMEC D3_line
      3433       ECIS        4       no 20,00Cell Free + HCMEC D3_line
      3434       ECIS        4       no 20,00Cell Free + HCMEC D3_line
      3435       ECIS        4       no 20,00Cell Free + HCMEC D3_line
      3436       ECIS        5       no 15,00Cell Free + HCMEC D3_line
      3437       ECIS        5       no 15,00Cell Free + HCMEC D3_line
      3438       ECIS        5       no 15,00Cell Free + HCMEC D3_line
      3439       ECIS        6       no 10,00Cell Free + HCMEC D3_line
      3440       ECIS        6       no 10,00Cell Free + HCMEC D3_line
      3441       ECIS        6       no 10,00Cell Free + HCMEC D3_line
      3442       ECIS        7       no  5,00Cell Free + HCMEC D3_line
      3443       ECIS        7       no  5,00Cell Free + HCMEC D3_line
      3444       ECIS        7       no  5,00Cell Free + HCMEC D3_line
      3445       ECIS        1       no 35,00Cell Free + HCMEC D3_line
      3446       ECIS        1       no 35,00Cell Free + HCMEC D3_line
      3447       ECIS        1       no 35,00Cell Free + HCMEC D3_line
      3448       ECIS        2       no 30,00Cell Free + HCMEC D3_line
      3449       ECIS        2       no 30,00Cell Free + HCMEC D3_line
      3450       ECIS        2       no 30,00Cell Free + HCMEC D3_line
      3451       ECIS        3       no 25,00Cell Free + HCMEC D3_line
      3452       ECIS        3       no 25,00Cell Free + HCMEC D3_line
      3453       ECIS        3       no 25,00Cell Free + HCMEC D3_line
      3454       ECIS        4       no 20,00Cell Free + HCMEC D3_line
      3455       ECIS        4       no 20,00Cell Free + HCMEC D3_line
      3456       ECIS        4       no 20,00Cell Free + HCMEC D3_line
      3457       ECIS        5       no 15,00Cell Free + HCMEC D3_line
      3458       ECIS        5       no 15,00Cell Free + HCMEC D3_line
      3459       ECIS        5       no 15,00Cell Free + HCMEC D3_line
      3460       ECIS        6       no 10,00Cell Free + HCMEC D3_line
      3461       ECIS        6       no 10,00Cell Free + HCMEC D3_line
      3462       ECIS        6       no 10,00Cell Free + HCMEC D3_line
      3463       ECIS        7       no  5,00Cell Free + HCMEC D3_line
      3464       ECIS        7       no  5,00Cell Free + HCMEC D3_line
      3465       ECIS        7       no  5,00Cell Free + HCMEC D3_line
      3466       ECIS        1       no 35,00Cell Free + HCMEC D3_line
      3467       ECIS        1       no 35,00Cell Free + HCMEC D3_line
      3468       ECIS        1       no 35,00Cell Free + HCMEC D3_line
      3469       ECIS        2       no 30,00Cell Free + HCMEC D3_line
      3470       ECIS        2       no 30,00Cell Free + HCMEC D3_line
      3471       ECIS        2       no 30,00Cell Free + HCMEC D3_line
      3472       ECIS        3       no 25,00Cell Free + HCMEC D3_line
      3473       ECIS        3       no 25,00Cell Free + HCMEC D3_line
      3474       ECIS        3       no 25,00Cell Free + HCMEC D3_line
      3475       ECIS        4       no 20,00Cell Free + HCMEC D3_line
      3476       ECIS        4       no 20,00Cell Free + HCMEC D3_line
      3477       ECIS        4       no 20,00Cell Free + HCMEC D3_line
      3478       ECIS        5       no 15,00Cell Free + HCMEC D3_line
      3479       ECIS        5       no 15,00Cell Free + HCMEC D3_line
      3480       ECIS        5       no 15,00Cell Free + HCMEC D3_line
      3481       ECIS        6       no 10,00Cell Free + HCMEC D3_line
      3482       ECIS        6       no 10,00Cell Free + HCMEC D3_line
      3483       ECIS        6       no 10,00Cell Free + HCMEC D3_line
      3484       ECIS        7       no  5,00Cell Free + HCMEC D3_line
      3485       ECIS        7       no  5,00Cell Free + HCMEC D3_line
      3486       ECIS        7       no  5,00Cell Free + HCMEC D3_line
      3487       ECIS        1       no 35,00Cell Free + HCMEC D3_line
      3488       ECIS        1       no 35,00Cell Free + HCMEC D3_line
      3489       ECIS        1       no 35,00Cell Free + HCMEC D3_line
      3490       ECIS        2       no 30,00Cell Free + HCMEC D3_line
      3491       ECIS        2       no 30,00Cell Free + HCMEC D3_line
      3492       ECIS        2       no 30,00Cell Free + HCMEC D3_line
      3493       ECIS        3       no 25,00Cell Free + HCMEC D3_line
      3494       ECIS        3       no 25,00Cell Free + HCMEC D3_line
      3495       ECIS        3       no 25,00Cell Free + HCMEC D3_line
      3496       ECIS        4       no 20,00Cell Free + HCMEC D3_line
      3497       ECIS        4       no 20,00Cell Free + HCMEC D3_line
      3498       ECIS        4       no 20,00Cell Free + HCMEC D3_line
      3499       ECIS        5       no 15,00Cell Free + HCMEC D3_line
      3500       ECIS        5       no 15,00Cell Free + HCMEC D3_line
      3501       ECIS        5       no 15,00Cell Free + HCMEC D3_line
      3502       ECIS        6       no 10,00Cell Free + HCMEC D3_line
      3503       ECIS        6       no 10,00Cell Free + HCMEC D3_line
      3504       ECIS        6       no 10,00Cell Free + HCMEC D3_line
      3505       ECIS        7       no  5,00Cell Free + HCMEC D3_line
      3506       ECIS        7       no  5,00Cell Free + HCMEC D3_line
      3507       ECIS        7       no  5,00Cell Free + HCMEC D3_line
      3508       ECIS        1       no 35,00Cell Free + HCMEC D3_line
      3509       ECIS        1       no 35,00Cell Free + HCMEC D3_line
      3510       ECIS        1       no 35,00Cell Free + HCMEC D3_line
      3511       ECIS        2       no 30,00Cell Free + HCMEC D3_line
      3512       ECIS        2       no 30,00Cell Free + HCMEC D3_line
      3513       ECIS        2       no 30,00Cell Free + HCMEC D3_line
      3514       ECIS        3       no 25,00Cell Free + HCMEC D3_line
      3515       ECIS        3       no 25,00Cell Free + HCMEC D3_line
      3516       ECIS        3       no 25,00Cell Free + HCMEC D3_line
      3517       ECIS        4       no 20,00Cell Free + HCMEC D3_line
      3518       ECIS        4       no 20,00Cell Free + HCMEC D3_line
      3519       ECIS        4       no 20,00Cell Free + HCMEC D3_line
      3520       ECIS        5       no 15,00Cell Free + HCMEC D3_line
      3521       ECIS        5       no 15,00Cell Free + HCMEC D3_line
      3522       ECIS        5       no 15,00Cell Free + HCMEC D3_line
      3523       ECIS        6       no 10,00Cell Free + HCMEC D3_line
      3524       ECIS        6       no 10,00Cell Free + HCMEC D3_line
      3525       ECIS        6       no 10,00Cell Free + HCMEC D3_line
      3526       ECIS        7       no  5,00Cell Free + HCMEC D3_line
      3527       ECIS        7       no  5,00Cell Free + HCMEC D3_line
      3528       ECIS        7       no  5,00Cell Free + HCMEC D3_line
      3529       ECIS        1       no 35,00Cell Free + HCMEC D3_line
      3530       ECIS        1       no 35,00Cell Free + HCMEC D3_line
      3531       ECIS        1       no 35,00Cell Free + HCMEC D3_line
      3532       ECIS        2       no 30,00Cell Free + HCMEC D3_line
      3533       ECIS        2       no 30,00Cell Free + HCMEC D3_line
      3534       ECIS        2       no 30,00Cell Free + HCMEC D3_line
      3535       ECIS        3       no 25,00Cell Free + HCMEC D3_line
      3536       ECIS        3       no 25,00Cell Free + HCMEC D3_line
      3537       ECIS        3       no 25,00Cell Free + HCMEC D3_line
      3538       ECIS        4       no 20,00Cell Free + HCMEC D3_line
      3539       ECIS        4       no 20,00Cell Free + HCMEC D3_line
      3540       ECIS        4       no 20,00Cell Free + HCMEC D3_line
      3541       ECIS        5       no 15,00Cell Free + HCMEC D3_line
      3542       ECIS        5       no 15,00Cell Free + HCMEC D3_line
      3543       ECIS        5       no 15,00Cell Free + HCMEC D3_line
      3544       ECIS        6       no 10,00Cell Free + HCMEC D3_line
      3545       ECIS        6       no 10,00Cell Free + HCMEC D3_line
      3546       ECIS        6       no 10,00Cell Free + HCMEC D3_line
      3547       ECIS        7       no  5,00Cell Free + HCMEC D3_line
      3548       ECIS        7       no  5,00Cell Free + HCMEC D3_line
      3549       ECIS        7       no  5,00Cell Free + HCMEC D3_line
      3550       ECIS        1       no 35,00Cell Free + HCMEC D3_line
      3551       ECIS        1       no 35,00Cell Free + HCMEC D3_line
      3552       ECIS        1       no 35,00Cell Free + HCMEC D3_line
      3553       ECIS        2       no 30,00Cell Free + HCMEC D3_line
      3554       ECIS        2       no 30,00Cell Free + HCMEC D3_line
      3555       ECIS        2       no 30,00Cell Free + HCMEC D3_line
      3556       ECIS        3       no 25,00Cell Free + HCMEC D3_line
      3557       ECIS        3       no 25,00Cell Free + HCMEC D3_line
      3558       ECIS        3       no 25,00Cell Free + HCMEC D3_line
      3559       ECIS        4       no 20,00Cell Free + HCMEC D3_line
      3560       ECIS        4       no 20,00Cell Free + HCMEC D3_line
      3561       ECIS        4       no 20,00Cell Free + HCMEC D3_line
      3562       ECIS        5       no 15,00Cell Free + HCMEC D3_line
      3563       ECIS        5       no 15,00Cell Free + HCMEC D3_line
      3564       ECIS        5       no 15,00Cell Free + HCMEC D3_line
      3565       ECIS        6       no 10,00Cell Free + HCMEC D3_line
      3566       ECIS        6       no 10,00Cell Free + HCMEC D3_line
      3567       ECIS        6       no 10,00Cell Free + HCMEC D3_line
      3568       ECIS        7       no  5,00Cell Free + HCMEC D3_line
      3569       ECIS        7       no  5,00Cell Free + HCMEC D3_line
      3570       ECIS        7       no  5,00Cell Free + HCMEC D3_line
      3571       ECIS        1       no 35,00Cell Free + HCMEC D3_line
      3572       ECIS        1       no 35,00Cell Free + HCMEC D3_line
      3573       ECIS        1       no 35,00Cell Free + HCMEC D3_line
      3574       ECIS        2       no 30,00Cell Free + HCMEC D3_line
      3575       ECIS        2       no 30,00Cell Free + HCMEC D3_line
      3576       ECIS        2       no 30,00Cell Free + HCMEC D3_line
      3577       ECIS        3       no 25,00Cell Free + HCMEC D3_line
      3578       ECIS        3       no 25,00Cell Free + HCMEC D3_line
      3579       ECIS        3       no 25,00Cell Free + HCMEC D3_line
      3580       ECIS        4       no 20,00Cell Free + HCMEC D3_line
      3581       ECIS        4       no 20,00Cell Free + HCMEC D3_line
      3582       ECIS        4       no 20,00Cell Free + HCMEC D3_line
      3583       ECIS        5       no 15,00Cell Free + HCMEC D3_line
      3584       ECIS        5       no 15,00Cell Free + HCMEC D3_line
      3585       ECIS        5       no 15,00Cell Free + HCMEC D3_line
      3586       ECIS        6       no 10,00Cell Free + HCMEC D3_line
      3587       ECIS        6       no 10,00Cell Free + HCMEC D3_line
      3588       ECIS        6       no 10,00Cell Free + HCMEC D3_line
      3589       ECIS        7       no  5,00Cell Free + HCMEC D3_line
      3590       ECIS        7       no  5,00Cell Free + HCMEC D3_line
      3591       ECIS        7       no  5,00Cell Free + HCMEC D3_line
      3592       ECIS        1       no 35,00Cell Free + HCMEC D3_line
      3593       ECIS        1       no 35,00Cell Free + HCMEC D3_line
      3594       ECIS        1       no 35,00Cell Free + HCMEC D3_line
      3595       ECIS        2       no 30,00Cell Free + HCMEC D3_line
      3596       ECIS        2       no 30,00Cell Free + HCMEC D3_line
      3597       ECIS        2       no 30,00Cell Free + HCMEC D3_line
      3598       ECIS        3       no 25,00Cell Free + HCMEC D3_line
      3599       ECIS        3       no 25,00Cell Free + HCMEC D3_line
      3600       ECIS        3       no 25,00Cell Free + HCMEC D3_line
      3601       ECIS        4       no 20,00Cell Free + HCMEC D3_line
      3602       ECIS        4       no 20,00Cell Free + HCMEC D3_line
      3603       ECIS        4       no 20,00Cell Free + HCMEC D3_line
      3604       ECIS        5       no 15,00Cell Free + HCMEC D3_line
      3605       ECIS        5       no 15,00Cell Free + HCMEC D3_line
      3606       ECIS        5       no 15,00Cell Free + HCMEC D3_line
      3607       ECIS        6       no 10,00Cell Free + HCMEC D3_line
      3608       ECIS        6       no 10,00Cell Free + HCMEC D3_line
      3609       ECIS        6       no 10,00Cell Free + HCMEC D3_line
      3610       ECIS        7       no  5,00Cell Free + HCMEC D3_line
      3611       ECIS        7       no  5,00Cell Free + HCMEC D3_line
      3612       ECIS        7       no  5,00Cell Free + HCMEC D3_line
      3613       ECIS        1       no 35,00Cell Free + HCMEC D3_line
      3614       ECIS        1       no 35,00Cell Free + HCMEC D3_line
      3615       ECIS        1       no 35,00Cell Free + HCMEC D3_line
      3616       ECIS        2       no 30,00Cell Free + HCMEC D3_line
      3617       ECIS        2       no 30,00Cell Free + HCMEC D3_line
      3618       ECIS        2       no 30,00Cell Free + HCMEC D3_line
      3619       ECIS        3       no 25,00Cell Free + HCMEC D3_line
      3620       ECIS        3       no 25,00Cell Free + HCMEC D3_line
      3621       ECIS        3       no 25,00Cell Free + HCMEC D3_line
      3622       ECIS        4       no 20,00Cell Free + HCMEC D3_line
      3623       ECIS        4       no 20,00Cell Free + HCMEC D3_line
      3624       ECIS        4       no 20,00Cell Free + HCMEC D3_line
      3625       ECIS        5       no 15,00Cell Free + HCMEC D3_line
      3626       ECIS        5       no 15,00Cell Free + HCMEC D3_line
      3627       ECIS        5       no 15,00Cell Free + HCMEC D3_line
      3628       ECIS        6       no 10,00Cell Free + HCMEC D3_line
      3629       ECIS        6       no 10,00Cell Free + HCMEC D3_line
      3630       ECIS        6       no 10,00Cell Free + HCMEC D3_line
      3631       ECIS        7       no  5,00Cell Free + HCMEC D3_line
      3632       ECIS        7       no  5,00Cell Free + HCMEC D3_line
      3633       ECIS        7       no  5,00Cell Free + HCMEC D3_line
      3634       ECIS        1       no 35,00Cell Free + HCMEC D3_line
      3635       ECIS        1       no 35,00Cell Free + HCMEC D3_line
      3636       ECIS        1       no 35,00Cell Free + HCMEC D3_line
      3637       ECIS        2       no 30,00Cell Free + HCMEC D3_line
      3638       ECIS        2       no 30,00Cell Free + HCMEC D3_line
      3639       ECIS        2       no 30,00Cell Free + HCMEC D3_line
      3640       ECIS        3       no 25,00Cell Free + HCMEC D3_line
      3641       ECIS        3       no 25,00Cell Free + HCMEC D3_line
      3642       ECIS        3       no 25,00Cell Free + HCMEC D3_line
      3643       ECIS        4       no 20,00Cell Free + HCMEC D3_line
      3644       ECIS        4       no 20,00Cell Free + HCMEC D3_line
      3645       ECIS        4       no 20,00Cell Free + HCMEC D3_line
      3646       ECIS        5       no 15,00Cell Free + HCMEC D3_line
      3647       ECIS        5       no 15,00Cell Free + HCMEC D3_line
      3648       ECIS        5       no 15,00Cell Free + HCMEC D3_line
      3649       ECIS        6       no 10,00Cell Free + HCMEC D3_line
      3650       ECIS        6       no 10,00Cell Free + HCMEC D3_line
      3651       ECIS        6       no 10,00Cell Free + HCMEC D3_line
      3652       ECIS        7       no  5,00Cell Free + HCMEC D3_line
      3653       ECIS        7       no  5,00Cell Free + HCMEC D3_line
      3654       ECIS        7       no  5,00Cell Free + HCMEC D3_line
      3655       ECIS        1       no 35,00Cell Free + HCMEC D3_line
      3656       ECIS        1       no 35,00Cell Free + HCMEC D3_line
      3657       ECIS        1       no 35,00Cell Free + HCMEC D3_line
      3658       ECIS        2       no 30,00Cell Free + HCMEC D3_line
      3659       ECIS        2       no 30,00Cell Free + HCMEC D3_line
      3660       ECIS        2       no 30,00Cell Free + HCMEC D3_line
      3661       ECIS        3       no 25,00Cell Free + HCMEC D3_line
      3662       ECIS        3       no 25,00Cell Free + HCMEC D3_line
      3663       ECIS        3       no 25,00Cell Free + HCMEC D3_line
      3664       ECIS        4       no 20,00Cell Free + HCMEC D3_line
      3665       ECIS        4       no 20,00Cell Free + HCMEC D3_line
      3666       ECIS        4       no 20,00Cell Free + HCMEC D3_line
      3667       ECIS        5       no 15,00Cell Free + HCMEC D3_line
      3668       ECIS        5       no 15,00Cell Free + HCMEC D3_line
      3669       ECIS        5       no 15,00Cell Free + HCMEC D3_line
      3670       ECIS        6       no 10,00Cell Free + HCMEC D3_line
      3671       ECIS        6       no 10,00Cell Free + HCMEC D3_line
      3672       ECIS        6       no 10,00Cell Free + HCMEC D3_line
      3673       ECIS        7       no  5,00Cell Free + HCMEC D3_line
      3674       ECIS        7       no  5,00Cell Free + HCMEC D3_line
      3675       ECIS        7       no  5,00Cell Free + HCMEC D3_line
      3676       ECIS        1       no 35,00Cell Free + HCMEC D3_line
      3677       ECIS        1       no 35,00Cell Free + HCMEC D3_line
      3678       ECIS        1       no 35,00Cell Free + HCMEC D3_line
      3679       ECIS        2       no 30,00Cell Free + HCMEC D3_line
      3680       ECIS        2       no 30,00Cell Free + HCMEC D3_line
      3681       ECIS        2       no 30,00Cell Free + HCMEC D3_line
      3682       ECIS        3       no 25,00Cell Free + HCMEC D3_line
      3683       ECIS        3       no 25,00Cell Free + HCMEC D3_line
      3684       ECIS        3       no 25,00Cell Free + HCMEC D3_line
      3685       ECIS        4       no 20,00Cell Free + HCMEC D3_line
      3686       ECIS        4       no 20,00Cell Free + HCMEC D3_line
      3687       ECIS        4       no 20,00Cell Free + HCMEC D3_line
      3688       ECIS        5       no 15,00Cell Free + HCMEC D3_line
      3689       ECIS        5       no 15,00Cell Free + HCMEC D3_line
      3690       ECIS        5       no 15,00Cell Free + HCMEC D3_line
      3691       ECIS        6       no 10,00Cell Free + HCMEC D3_line
      3692       ECIS        6       no 10,00Cell Free + HCMEC D3_line
      3693       ECIS        6       no 10,00Cell Free + HCMEC D3_line
      3694       ECIS        7       no  5,00Cell Free + HCMEC D3_line
      3695       ECIS        7       no  5,00Cell Free + HCMEC D3_line
      3696       ECIS        7       no  5,00Cell Free + HCMEC D3_line
      3697       ECIS        1       no 35,00Cell Free + HCMEC D3_line
      3698       ECIS        1       no 35,00Cell Free + HCMEC D3_line
      3699       ECIS        1       no 35,00Cell Free + HCMEC D3_line
      3700       ECIS        2       no 30,00Cell Free + HCMEC D3_line
      3701       ECIS        2       no 30,00Cell Free + HCMEC D3_line
      3702       ECIS        2       no 30,00Cell Free + HCMEC D3_line
      3703       ECIS        3       no 25,00Cell Free + HCMEC D3_line
      3704       ECIS        3       no 25,00Cell Free + HCMEC D3_line
      3705       ECIS        3       no 25,00Cell Free + HCMEC D3_line
      3706       ECIS        4       no 20,00Cell Free + HCMEC D3_line
      3707       ECIS        4       no 20,00Cell Free + HCMEC D3_line
      3708       ECIS        4       no 20,00Cell Free + HCMEC D3_line
      3709       ECIS        5       no 15,00Cell Free + HCMEC D3_line
      3710       ECIS        5       no 15,00Cell Free + HCMEC D3_line
      3711       ECIS        5       no 15,00Cell Free + HCMEC D3_line
      3712       ECIS        6       no 10,00Cell Free + HCMEC D3_line
      3713       ECIS        6       no 10,00Cell Free + HCMEC D3_line
      3714       ECIS        6       no 10,00Cell Free + HCMEC D3_line
      3715       ECIS        7       no  5,00Cell Free + HCMEC D3_line
      3716       ECIS        7       no  5,00Cell Free + HCMEC D3_line
      3717       ECIS        7       no  5,00Cell Free + HCMEC D3_line
      3718       ECIS        1       no 35,00Cell Free + HCMEC D3_line
      3719       ECIS        1       no 35,00Cell Free + HCMEC D3_line
      3720       ECIS        1       no 35,00Cell Free + HCMEC D3_line
      3721       ECIS        2       no 30,00Cell Free + HCMEC D3_line
      3722       ECIS        2       no 30,00Cell Free + HCMEC D3_line
      3723       ECIS        2       no 30,00Cell Free + HCMEC D3_line
      3724       ECIS        3       no 25,00Cell Free + HCMEC D3_line
      3725       ECIS        3       no 25,00Cell Free + HCMEC D3_line
      3726       ECIS        3       no 25,00Cell Free + HCMEC D3_line
      3727       ECIS        4       no 20,00Cell Free + HCMEC D3_line
      3728       ECIS        4       no 20,00Cell Free + HCMEC D3_line
      3729       ECIS        4       no 20,00Cell Free + HCMEC D3_line
      3730       ECIS        5       no 15,00Cell Free + HCMEC D3_line
      3731       ECIS        5       no 15,00Cell Free + HCMEC D3_line
      3732       ECIS        5       no 15,00Cell Free + HCMEC D3_line
      3733       ECIS        6       no 10,00Cell Free + HCMEC D3_line
      3734       ECIS        6       no 10,00Cell Free + HCMEC D3_line
      3735       ECIS        6       no 10,00Cell Free + HCMEC D3_line
      3736       ECIS        7       no  5,00Cell Free + HCMEC D3_line
      3737       ECIS        7       no  5,00Cell Free + HCMEC D3_line
      3738       ECIS        7       no  5,00Cell Free + HCMEC D3_line
      3739       ECIS        1       no 35,00Cell Free + HCMEC D3_line
      3740       ECIS        1       no 35,00Cell Free + HCMEC D3_line
      3741       ECIS        1       no 35,00Cell Free + HCMEC D3_line
      3742       ECIS        2       no 30,00Cell Free + HCMEC D3_line
      3743       ECIS        2       no 30,00Cell Free + HCMEC D3_line
      3744       ECIS        2       no 30,00Cell Free + HCMEC D3_line
      3745       ECIS        3       no 25,00Cell Free + HCMEC D3_line
      3746       ECIS        3       no 25,00Cell Free + HCMEC D3_line
      3747       ECIS        3       no 25,00Cell Free + HCMEC D3_line
      3748       ECIS        4       no 20,00Cell Free + HCMEC D3_line
      3749       ECIS        4       no 20,00Cell Free + HCMEC D3_line
      3750       ECIS        4       no 20,00Cell Free + HCMEC D3_line
      3751       ECIS        5       no 15,00Cell Free + HCMEC D3_line
      3752       ECIS        5       no 15,00Cell Free + HCMEC D3_line
      3753       ECIS        5       no 15,00Cell Free + HCMEC D3_line
      3754       ECIS        6       no 10,00Cell Free + HCMEC D3_line
      3755       ECIS        6       no 10,00Cell Free + HCMEC D3_line
      3756       ECIS        6       no 10,00Cell Free + HCMEC D3_line
      3757       ECIS        7       no  5,00Cell Free + HCMEC D3_line
      3758       ECIS        7       no  5,00Cell Free + HCMEC D3_line
      3759       ECIS        7       no  5,00Cell Free + HCMEC D3_line
      3760       ECIS        1       no 35,00Cell Free + HCMEC D3_line
      3761       ECIS        1       no 35,00Cell Free + HCMEC D3_line
      3762       ECIS        1       no 35,00Cell Free + HCMEC D3_line
      3763       ECIS        2       no 30,00Cell Free + HCMEC D3_line
      3764       ECIS        2       no 30,00Cell Free + HCMEC D3_line
      3765       ECIS        2       no 30,00Cell Free + HCMEC D3_line
      3766       ECIS        3       no 25,00Cell Free + HCMEC D3_line
      3767       ECIS        3       no 25,00Cell Free + HCMEC D3_line
      3768       ECIS        3       no 25,00Cell Free + HCMEC D3_line
      3769       ECIS        4       no 20,00Cell Free + HCMEC D3_line
      3770       ECIS        4       no 20,00Cell Free + HCMEC D3_line
      3771       ECIS        4       no 20,00Cell Free + HCMEC D3_line
      3772       ECIS        5       no 15,00Cell Free + HCMEC D3_line
      3773       ECIS        5       no 15,00Cell Free + HCMEC D3_line
      3774       ECIS        5       no 15,00Cell Free + HCMEC D3_line
      3775       ECIS        6       no 10,00Cell Free + HCMEC D3_line
      3776       ECIS        6       no 10,00Cell Free + HCMEC D3_line
      3777       ECIS        6       no 10,00Cell Free + HCMEC D3_line
      3778       ECIS        7       no  5,00Cell Free + HCMEC D3_line
      3779       ECIS        7       no  5,00Cell Free + HCMEC D3_line
      3780       ECIS        7       no  5,00Cell Free + HCMEC D3_line
      3781       ECIS        1       no 35,00Cell Free + HCMEC D3_line
      3782       ECIS        1       no 35,00Cell Free + HCMEC D3_line
      3783       ECIS        1       no 35,00Cell Free + HCMEC D3_line
      3784       ECIS        2       no 30,00Cell Free + HCMEC D3_line
      3785       ECIS        2       no 30,00Cell Free + HCMEC D3_line
      3786       ECIS        2       no 30,00Cell Free + HCMEC D3_line
      3787       ECIS        3       no 25,00Cell Free + HCMEC D3_line
      3788       ECIS        3       no 25,00Cell Free + HCMEC D3_line
      3789       ECIS        3       no 25,00Cell Free + HCMEC D3_line
      3790       ECIS        4       no 20,00Cell Free + HCMEC D3_line
      3791       ECIS        4       no 20,00Cell Free + HCMEC D3_line
      3792       ECIS        4       no 20,00Cell Free + HCMEC D3_line
      3793       ECIS        5       no 15,00Cell Free + HCMEC D3_line
      3794       ECIS        5       no 15,00Cell Free + HCMEC D3_line
      3795       ECIS        5       no 15,00Cell Free + HCMEC D3_line
      3796       ECIS        6       no 10,00Cell Free + HCMEC D3_line
      3797       ECIS        6       no 10,00Cell Free + HCMEC D3_line
      3798       ECIS        6       no 10,00Cell Free + HCMEC D3_line
      3799       ECIS        7       no  5,00Cell Free + HCMEC D3_line
      3800       ECIS        7       no  5,00Cell Free + HCMEC D3_line
      3801       ECIS        7       no  5,00Cell Free + HCMEC D3_line
      3802       ECIS        1       no 35,00Cell Free + HCMEC D3_line
      3803       ECIS        1       no 35,00Cell Free + HCMEC D3_line
      3804       ECIS        1       no 35,00Cell Free + HCMEC D3_line
      3805       ECIS        2       no 30,00Cell Free + HCMEC D3_line
      3806       ECIS        2       no 30,00Cell Free + HCMEC D3_line
      3807       ECIS        2       no 30,00Cell Free + HCMEC D3_line
      3808       ECIS        3       no 25,00Cell Free + HCMEC D3_line
      3809       ECIS        3       no 25,00Cell Free + HCMEC D3_line
      3810       ECIS        3       no 25,00Cell Free + HCMEC D3_line
      3811       ECIS        4       no 20,00Cell Free + HCMEC D3_line
      3812       ECIS        4       no 20,00Cell Free + HCMEC D3_line
      3813       ECIS        4       no 20,00Cell Free + HCMEC D3_line
      3814       ECIS        5       no 15,00Cell Free + HCMEC D3_line
      3815       ECIS        5       no 15,00Cell Free + HCMEC D3_line
      3816       ECIS        5       no 15,00Cell Free + HCMEC D3_line
      3817       ECIS        6       no 10,00Cell Free + HCMEC D3_line
      3818       ECIS        6       no 10,00Cell Free + HCMEC D3_line
      3819       ECIS        6       no 10,00Cell Free + HCMEC D3_line
      3820       ECIS        7       no  5,00Cell Free + HCMEC D3_line
      3821       ECIS        7       no  5,00Cell Free + HCMEC D3_line
      3822       ECIS        7       no  5,00Cell Free + HCMEC D3_line
      3823       ECIS        1       no 35,00Cell Free + HCMEC D3_line
      3824       ECIS        1       no 35,00Cell Free + HCMEC D3_line
      3825       ECIS        1       no 35,00Cell Free + HCMEC D3_line
      3826       ECIS        2       no 30,00Cell Free + HCMEC D3_line
      3827       ECIS        2       no 30,00Cell Free + HCMEC D3_line
      3828       ECIS        2       no 30,00Cell Free + HCMEC D3_line
      3829       ECIS        3       no 25,00Cell Free + HCMEC D3_line
      3830       ECIS        3       no 25,00Cell Free + HCMEC D3_line
      3831       ECIS        3       no 25,00Cell Free + HCMEC D3_line
      3832       ECIS        4       no 20,00Cell Free + HCMEC D3_line
      3833       ECIS        4       no 20,00Cell Free + HCMEC D3_line
      3834       ECIS        4       no 20,00Cell Free + HCMEC D3_line
      3835       ECIS        5       no 15,00Cell Free + HCMEC D3_line
      3836       ECIS        5       no 15,00Cell Free + HCMEC D3_line
      3837       ECIS        5       no 15,00Cell Free + HCMEC D3_line
      3838       ECIS        6       no 10,00Cell Free + HCMEC D3_line
      3839       ECIS        6       no 10,00Cell Free + HCMEC D3_line
      3840       ECIS        6       no 10,00Cell Free + HCMEC D3_line
      3841       ECIS        7       no  5,00Cell Free + HCMEC D3_line
      3842       ECIS        7       no  5,00Cell Free + HCMEC D3_line
      3843       ECIS        7       no  5,00Cell Free + HCMEC D3_line
      3844       ECIS        1       no 35,00Cell Free + HCMEC D3_line
      3845       ECIS        1       no 35,00Cell Free + HCMEC D3_line
      3846       ECIS        1       no 35,00Cell Free + HCMEC D3_line
      3847       ECIS        2       no 30,00Cell Free + HCMEC D3_line
      3848       ECIS        2       no 30,00Cell Free + HCMEC D3_line
      3849       ECIS        2       no 30,00Cell Free + HCMEC D3_line
      3850       ECIS        3       no 25,00Cell Free + HCMEC D3_line
      3851       ECIS        3       no 25,00Cell Free + HCMEC D3_line
      3852       ECIS        3       no 25,00Cell Free + HCMEC D3_line
      3853       ECIS        4       no 20,00Cell Free + HCMEC D3_line
      3854       ECIS        4       no 20,00Cell Free + HCMEC D3_line
      3855       ECIS        4       no 20,00Cell Free + HCMEC D3_line
      3856       ECIS        5       no 15,00Cell Free + HCMEC D3_line
      3857       ECIS        5       no 15,00Cell Free + HCMEC D3_line
      3858       ECIS        5       no 15,00Cell Free + HCMEC D3_line
      3859       ECIS        6       no 10,00Cell Free + HCMEC D3_line
      3860       ECIS        6       no 10,00Cell Free + HCMEC D3_line
      3861       ECIS        6       no 10,00Cell Free + HCMEC D3_line
      3862       ECIS        7       no  5,00Cell Free + HCMEC D3_line
      3863       ECIS        7       no  5,00Cell Free + HCMEC D3_line
      3864       ECIS        7       no  5,00Cell Free + HCMEC D3_line
      3865       ECIS        1       no 35,00Cell Free + HCMEC D3_line
      3866       ECIS        1       no 35,00Cell Free + HCMEC D3_line
      3867       ECIS        1       no 35,00Cell Free + HCMEC D3_line
      3868       ECIS        2       no 30,00Cell Free + HCMEC D3_line
      3869       ECIS        2       no 30,00Cell Free + HCMEC D3_line
      3870       ECIS        2       no 30,00Cell Free + HCMEC D3_line
      3871       ECIS        3       no 25,00Cell Free + HCMEC D3_line
      3872       ECIS        3       no 25,00Cell Free + HCMEC D3_line
      3873       ECIS        3       no 25,00Cell Free + HCMEC D3_line
      3874       ECIS        4       no 20,00Cell Free + HCMEC D3_line
      3875       ECIS        4       no 20,00Cell Free + HCMEC D3_line
      3876       ECIS        4       no 20,00Cell Free + HCMEC D3_line
      3877       ECIS        5       no 15,00Cell Free + HCMEC D3_line
      3878       ECIS        5       no 15,00Cell Free + HCMEC D3_line
      3879       ECIS        5       no 15,00Cell Free + HCMEC D3_line
      3880       ECIS        6       no 10,00Cell Free + HCMEC D3_line
      3881       ECIS        6       no 10,00Cell Free + HCMEC D3_line
      3882       ECIS        6       no 10,00Cell Free + HCMEC D3_line
      3883       ECIS        7       no  5,00Cell Free + HCMEC D3_line
      3884       ECIS        7       no  5,00Cell Free + HCMEC D3_line
      3885       ECIS        7       no  5,00Cell Free + HCMEC D3_line
      3886       ECIS        1       no 35,00Cell Free + HCMEC D3_line
      3887       ECIS        1       no 35,00Cell Free + HCMEC D3_line
      3888       ECIS        1       no 35,00Cell Free + HCMEC D3_line
      3889       ECIS        2       no 30,00Cell Free + HCMEC D3_line
      3890       ECIS        2       no 30,00Cell Free + HCMEC D3_line
      3891       ECIS        2       no 30,00Cell Free + HCMEC D3_line
      3892       ECIS        3       no 25,00Cell Free + HCMEC D3_line
      3893       ECIS        3       no 25,00Cell Free + HCMEC D3_line
      3894       ECIS        3       no 25,00Cell Free + HCMEC D3_line
      3895       ECIS        4       no 20,00Cell Free + HCMEC D3_line
      3896       ECIS        4       no 20,00Cell Free + HCMEC D3_line
      3897       ECIS        4       no 20,00Cell Free + HCMEC D3_line
      3898       ECIS        5       no 15,00Cell Free + HCMEC D3_line
      3899       ECIS        5       no 15,00Cell Free + HCMEC D3_line
      3900       ECIS        5       no 15,00Cell Free + HCMEC D3_line
      3901       ECIS        6       no 10,00Cell Free + HCMEC D3_line
      3902       ECIS        6       no 10,00Cell Free + HCMEC D3_line
      3903       ECIS        6       no 10,00Cell Free + HCMEC D3_line
      3904       ECIS        7       no  5,00Cell Free + HCMEC D3_line
      3905       ECIS        7       no  5,00Cell Free + HCMEC D3_line
      3906       ECIS        7       no  5,00Cell Free + HCMEC D3_line
      3907       ECIS        1       no 35,00Cell Free + HCMEC D3_line
      3908       ECIS        1       no 35,00Cell Free + HCMEC D3_line
      3909       ECIS        1       no 35,00Cell Free + HCMEC D3_line
      3910       ECIS        2       no 30,00Cell Free + HCMEC D3_line
      3911       ECIS        2       no 30,00Cell Free + HCMEC D3_line
      3912       ECIS        2       no 30,00Cell Free + HCMEC D3_line
      3913       ECIS        3       no 25,00Cell Free + HCMEC D3_line
      3914       ECIS        3       no 25,00Cell Free + HCMEC D3_line
      3915       ECIS        3       no 25,00Cell Free + HCMEC D3_line
      3916       ECIS        4       no 20,00Cell Free + HCMEC D3_line
      3917       ECIS        4       no 20,00Cell Free + HCMEC D3_line
      3918       ECIS        4       no 20,00Cell Free + HCMEC D3_line
      3919       ECIS        5       no 15,00Cell Free + HCMEC D3_line
      3920       ECIS        5       no 15,00Cell Free + HCMEC D3_line
      3921       ECIS        5       no 15,00Cell Free + HCMEC D3_line
      3922       ECIS        6       no 10,00Cell Free + HCMEC D3_line
      3923       ECIS        6       no 10,00Cell Free + HCMEC D3_line
      3924       ECIS        6       no 10,00Cell Free + HCMEC D3_line
      3925       ECIS        7       no  5,00Cell Free + HCMEC D3_line
      3926       ECIS        7       no  5,00Cell Free + HCMEC D3_line
      3927       ECIS        7       no  5,00Cell Free + HCMEC D3_line
      3928       ECIS        1       no 35,00Cell Free + HCMEC D3_line
      3929       ECIS        1       no 35,00Cell Free + HCMEC D3_line
      3930       ECIS        1       no 35,00Cell Free + HCMEC D3_line
      3931       ECIS        2       no 30,00Cell Free + HCMEC D3_line
      3932       ECIS        2       no 30,00Cell Free + HCMEC D3_line
      3933       ECIS        2       no 30,00Cell Free + HCMEC D3_line
      3934       ECIS        3       no 25,00Cell Free + HCMEC D3_line
      3935       ECIS        3       no 25,00Cell Free + HCMEC D3_line
      3936       ECIS        3       no 25,00Cell Free + HCMEC D3_line
      3937       ECIS        4       no 20,00Cell Free + HCMEC D3_line
      3938       ECIS        4       no 20,00Cell Free + HCMEC D3_line
      3939       ECIS        4       no 20,00Cell Free + HCMEC D3_line
      3940       ECIS        5       no 15,00Cell Free + HCMEC D3_line
      3941       ECIS        5       no 15,00Cell Free + HCMEC D3_line
      3942       ECIS        5       no 15,00Cell Free + HCMEC D3_line
      3943       ECIS        6       no 10,00Cell Free + HCMEC D3_line
      3944       ECIS        6       no 10,00Cell Free + HCMEC D3_line
      3945       ECIS        6       no 10,00Cell Free + HCMEC D3_line
      3946       ECIS        7       no  5,00Cell Free + HCMEC D3_line
      3947       ECIS        7       no  5,00Cell Free + HCMEC D3_line
      3948       ECIS        7       no  5,00Cell Free + HCMEC D3_line
      3949       ECIS        1       no 35,00Cell Free + HCMEC D3_line
      3950       ECIS        1       no 35,00Cell Free + HCMEC D3_line
      3951       ECIS        1       no 35,00Cell Free + HCMEC D3_line
      3952       ECIS        2       no 30,00Cell Free + HCMEC D3_line
      3953       ECIS        2       no 30,00Cell Free + HCMEC D3_line
      3954       ECIS        2       no 30,00Cell Free + HCMEC D3_line
      3955       ECIS        3       no 25,00Cell Free + HCMEC D3_line
      3956       ECIS        3       no 25,00Cell Free + HCMEC D3_line
      3957       ECIS        3       no 25,00Cell Free + HCMEC D3_line
      3958       ECIS        4       no 20,00Cell Free + HCMEC D3_line
      3959       ECIS        4       no 20,00Cell Free + HCMEC D3_line
      3960       ECIS        4       no 20,00Cell Free + HCMEC D3_line
      3961       ECIS        5       no 15,00Cell Free + HCMEC D3_line
      3962       ECIS        5       no 15,00Cell Free + HCMEC D3_line
      3963       ECIS        5       no 15,00Cell Free + HCMEC D3_line
      3964       ECIS        6       no 10,00Cell Free + HCMEC D3_line
      3965       ECIS        6       no 10,00Cell Free + HCMEC D3_line
      3966       ECIS        6       no 10,00Cell Free + HCMEC D3_line
      3967       ECIS        7       no  5,00Cell Free + HCMEC D3_line
      3968       ECIS        7       no  5,00Cell Free + HCMEC D3_line
      3969       ECIS        7       no  5,00Cell Free + HCMEC D3_line
      3970       ECIS        1       no 35,00Cell Free + HCMEC D3_line
      3971       ECIS        1       no 35,00Cell Free + HCMEC D3_line
      3972       ECIS        1       no 35,00Cell Free + HCMEC D3_line
      3973       ECIS        2       no 30,00Cell Free + HCMEC D3_line
      3974       ECIS        2       no 30,00Cell Free + HCMEC D3_line
      3975       ECIS        2       no 30,00Cell Free + HCMEC D3_line
      3976       ECIS        3       no 25,00Cell Free + HCMEC D3_line
      3977       ECIS        3       no 25,00Cell Free + HCMEC D3_line
      3978       ECIS        3       no 25,00Cell Free + HCMEC D3_line
      3979       ECIS        4       no 20,00Cell Free + HCMEC D3_line
      3980       ECIS        4       no 20,00Cell Free + HCMEC D3_line
      3981       ECIS        4       no 20,00Cell Free + HCMEC D3_line
      3982       ECIS        5       no 15,00Cell Free + HCMEC D3_line
      3983       ECIS        5       no 15,00Cell Free + HCMEC D3_line
      3984       ECIS        5       no 15,00Cell Free + HCMEC D3_line
      3985       ECIS        6       no 10,00Cell Free + HCMEC D3_line
      3986       ECIS        6       no 10,00Cell Free + HCMEC D3_line
      3987       ECIS        6       no 10,00Cell Free + HCMEC D3_line
      3988       ECIS        7       no  5,00Cell Free + HCMEC D3_line
      3989       ECIS        7       no  5,00Cell Free + HCMEC D3_line
      3990       ECIS        7       no  5,00Cell Free + HCMEC D3_line
      3991       ECIS        1       no 35,00Cell Free + HCMEC D3_line
      3992       ECIS        1       no 35,00Cell Free + HCMEC D3_line
      3993       ECIS        1       no 35,00Cell Free + HCMEC D3_line
      3994       ECIS        2       no 30,00Cell Free + HCMEC D3_line
      3995       ECIS        2       no 30,00Cell Free + HCMEC D3_line
      3996       ECIS        2       no 30,00Cell Free + HCMEC D3_line
      3997       ECIS        3       no 25,00Cell Free + HCMEC D3_line
      3998       ECIS        3       no 25,00Cell Free + HCMEC D3_line
      3999       ECIS        3       no 25,00Cell Free + HCMEC D3_line
      4000       ECIS        4       no 20,00Cell Free + HCMEC D3_line
      4001       ECIS        4       no 20,00Cell Free + HCMEC D3_line
      4002       ECIS        4       no 20,00Cell Free + HCMEC D3_line
      4003       ECIS        5       no 15,00Cell Free + HCMEC D3_line
      4004       ECIS        5       no 15,00Cell Free + HCMEC D3_line
      4005       ECIS        5       no 15,00Cell Free + HCMEC D3_line
      4006       ECIS        6       no 10,00Cell Free + HCMEC D3_line
      4007       ECIS        6       no 10,00Cell Free + HCMEC D3_line
      4008       ECIS        6       no 10,00Cell Free + HCMEC D3_line
      4009       ECIS        7       no  5,00Cell Free + HCMEC D3_line
      4010       ECIS        7       no  5,00Cell Free + HCMEC D3_line
      4011       ECIS        7       no  5,00Cell Free + HCMEC D3_line
      4012       ECIS        1       no 35,00Cell Free + HCMEC D3_line
      4013       ECIS        1       no 35,00Cell Free + HCMEC D3_line
      4014       ECIS        1       no 35,00Cell Free + HCMEC D3_line
      4015       ECIS        2       no 30,00Cell Free + HCMEC D3_line
      4016       ECIS        2       no 30,00Cell Free + HCMEC D3_line
      4017       ECIS        2       no 30,00Cell Free + HCMEC D3_line
      4018       ECIS        3       no 25,00Cell Free + HCMEC D3_line
      4019       ECIS        3       no 25,00Cell Free + HCMEC D3_line
      4020       ECIS        3       no 25,00Cell Free + HCMEC D3_line
      4021       ECIS        4       no 20,00Cell Free + HCMEC D3_line
      4022       ECIS        4       no 20,00Cell Free + HCMEC D3_line
      4023       ECIS        4       no 20,00Cell Free + HCMEC D3_line
      4024       ECIS        5       no 15,00Cell Free + HCMEC D3_line
      4025       ECIS        5       no 15,00Cell Free + HCMEC D3_line
      4026       ECIS        5       no 15,00Cell Free + HCMEC D3_line
      4027       ECIS        6       no 10,00Cell Free + HCMEC D3_line
      4028       ECIS        6       no 10,00Cell Free + HCMEC D3_line
      4029       ECIS        6       no 10,00Cell Free + HCMEC D3_line
      4030       ECIS        7       no  5,00Cell Free + HCMEC D3_line
      4031       ECIS        7       no  5,00Cell Free + HCMEC D3_line
      4032       ECIS        7       no  5,00Cell Free + HCMEC D3_line
      4033       ECIS        1       no 35,00Cell Free + HCMEC D3_line
      4034       ECIS        1       no 35,00Cell Free + HCMEC D3_line
      4035       ECIS        1       no 35,00Cell Free + HCMEC D3_line
      4036       ECIS        2       no 30,00Cell Free + HCMEC D3_line
      4037       ECIS        2       no 30,00Cell Free + HCMEC D3_line
      4038       ECIS        2       no 30,00Cell Free + HCMEC D3_line
      4039       ECIS        3       no 25,00Cell Free + HCMEC D3_line
      4040       ECIS        3       no 25,00Cell Free + HCMEC D3_line
      4041       ECIS        3       no 25,00Cell Free + HCMEC D3_line
      4042       ECIS        4       no 20,00Cell Free + HCMEC D3_line
      4043       ECIS        4       no 20,00Cell Free + HCMEC D3_line
      4044       ECIS        4       no 20,00Cell Free + HCMEC D3_line
      4045       ECIS        5       no 15,00Cell Free + HCMEC D3_line
      4046       ECIS        5       no 15,00Cell Free + HCMEC D3_line
      4047       ECIS        5       no 15,00Cell Free + HCMEC D3_line
      4048       ECIS        6       no 10,00Cell Free + HCMEC D3_line
      4049       ECIS        6       no 10,00Cell Free + HCMEC D3_line
      4050       ECIS        6       no 10,00Cell Free + HCMEC D3_line
      4051       ECIS        7       no  5,00Cell Free + HCMEC D3_line
      4052       ECIS        7       no  5,00Cell Free + HCMEC D3_line
      4053       ECIS        7       no  5,00Cell Free + HCMEC D3_line
      4054       ECIS        1       no 35,00Cell Free + HCMEC D3_line
      4055       ECIS        1       no 35,00Cell Free + HCMEC D3_line
      4056       ECIS        1       no 35,00Cell Free + HCMEC D3_line
      4057       ECIS        2       no 30,00Cell Free + HCMEC D3_line
      4058       ECIS        2       no 30,00Cell Free + HCMEC D3_line
      4059       ECIS        2       no 30,00Cell Free + HCMEC D3_line
      4060       ECIS        3       no 25,00Cell Free + HCMEC D3_line
      4061       ECIS        3       no 25,00Cell Free + HCMEC D3_line
      4062       ECIS        3       no 25,00Cell Free + HCMEC D3_line
      4063       ECIS        4       no 20,00Cell Free + HCMEC D3_line
      4064       ECIS        4       no 20,00Cell Free + HCMEC D3_line
      4065       ECIS        4       no 20,00Cell Free + HCMEC D3_line
      4066       ECIS        5       no 15,00Cell Free + HCMEC D3_line
      4067       ECIS        5       no 15,00Cell Free + HCMEC D3_line
      4068       ECIS        5       no 15,00Cell Free + HCMEC D3_line
      4069       ECIS        6       no 10,00Cell Free + HCMEC D3_line
      4070       ECIS        6       no 10,00Cell Free + HCMEC D3_line
      4071       ECIS        6       no 10,00Cell Free + HCMEC D3_line
      4072       ECIS        7       no  5,00Cell Free + HCMEC D3_line
      4073       ECIS        7       no  5,00Cell Free + HCMEC D3_line
      4074       ECIS        7       no  5,00Cell Free + HCMEC D3_line
      4075       ECIS        1       no 35,00Cell Free + HCMEC D3_line
      4076       ECIS        1       no 35,00Cell Free + HCMEC D3_line
      4077       ECIS        1       no 35,00Cell Free + HCMEC D3_line
      4078       ECIS        2       no 30,00Cell Free + HCMEC D3_line
      4079       ECIS        2       no 30,00Cell Free + HCMEC D3_line
      4080       ECIS        2       no 30,00Cell Free + HCMEC D3_line
      4081       ECIS        3       no 25,00Cell Free + HCMEC D3_line
      4082       ECIS        3       no 25,00Cell Free + HCMEC D3_line
      4083       ECIS        3       no 25,00Cell Free + HCMEC D3_line
      4084       ECIS        4       no 20,00Cell Free + HCMEC D3_line
      4085       ECIS        4       no 20,00Cell Free + HCMEC D3_line
      4086       ECIS        4       no 20,00Cell Free + HCMEC D3_line
      4087       ECIS        5       no 15,00Cell Free + HCMEC D3_line
      4088       ECIS        5       no 15,00Cell Free + HCMEC D3_line
      4089       ECIS        5       no 15,00Cell Free + HCMEC D3_line
      4090       ECIS        6       no 10,00Cell Free + HCMEC D3_line
      4091       ECIS        6       no 10,00Cell Free + HCMEC D3_line
      4092       ECIS        6       no 10,00Cell Free + HCMEC D3_line
      4093       ECIS        7       no  5,00Cell Free + HCMEC D3_line
      4094       ECIS        7       no  5,00Cell Free + HCMEC D3_line
      4095       ECIS        7       no  5,00Cell Free + HCMEC D3_line
      4096       ECIS        1       no 35,00Cell Free + HCMEC D3_line
      4097       ECIS        1       no 35,00Cell Free + HCMEC D3_line
      4098       ECIS        1       no 35,00Cell Free + HCMEC D3_line
      4099       ECIS        2       no 30,00Cell Free + HCMEC D3_line
      4100       ECIS        2       no 30,00Cell Free + HCMEC D3_line
      4101       ECIS        2       no 30,00Cell Free + HCMEC D3_line
      4102       ECIS        3       no 25,00Cell Free + HCMEC D3_line
      4103       ECIS        3       no 25,00Cell Free + HCMEC D3_line
      4104       ECIS        3       no 25,00Cell Free + HCMEC D3_line
      4105       ECIS        4       no 20,00Cell Free + HCMEC D3_line
      4106       ECIS        4       no 20,00Cell Free + HCMEC D3_line
      4107       ECIS        4       no 20,00Cell Free + HCMEC D3_line
      4108       ECIS        5       no 15,00Cell Free + HCMEC D3_line
      4109       ECIS        5       no 15,00Cell Free + HCMEC D3_line
      4110       ECIS        5       no 15,00Cell Free + HCMEC D3_line
      4111       ECIS        6       no 10,00Cell Free + HCMEC D3_line
      4112       ECIS        6       no 10,00Cell Free + HCMEC D3_line
      4113       ECIS        6       no 10,00Cell Free + HCMEC D3_line
      4114       ECIS        7       no  5,00Cell Free + HCMEC D3_line
      4115       ECIS        7       no  5,00Cell Free + HCMEC D3_line
      4116       ECIS        7       no  5,00Cell Free + HCMEC D3_line
      4117       ECIS        1       no 35,00Cell Free + HCMEC D3_line
      4118       ECIS        1       no 35,00Cell Free + HCMEC D3_line
      4119       ECIS        1       no 35,00Cell Free + HCMEC D3_line
      4120       ECIS        2       no 30,00Cell Free + HCMEC D3_line
      4121       ECIS        2       no 30,00Cell Free + HCMEC D3_line
      4122       ECIS        2       no 30,00Cell Free + HCMEC D3_line
      4123       ECIS        3       no 25,00Cell Free + HCMEC D3_line
      4124       ECIS        3       no 25,00Cell Free + HCMEC D3_line
      4125       ECIS        3       no 25,00Cell Free + HCMEC D3_line
      4126       ECIS        4       no 20,00Cell Free + HCMEC D3_line
      4127       ECIS        4       no 20,00Cell Free + HCMEC D3_line
      4128       ECIS        4       no 20,00Cell Free + HCMEC D3_line
      4129       ECIS        5       no 15,00Cell Free + HCMEC D3_line
      4130       ECIS        5       no 15,00Cell Free + HCMEC D3_line
      4131       ECIS        5       no 15,00Cell Free + HCMEC D3_line
      4132       ECIS        6       no 10,00Cell Free + HCMEC D3_line
      4133       ECIS        6       no 10,00Cell Free + HCMEC D3_line
      4134       ECIS        6       no 10,00Cell Free + HCMEC D3_line
      4135       ECIS        7       no  5,00Cell Free + HCMEC D3_line
      4136       ECIS        7       no  5,00Cell Free + HCMEC D3_line
      4137       ECIS        7       no  5,00Cell Free + HCMEC D3_line
      4138       ECIS        1       no 35,00Cell Free + HCMEC D3_line
      4139       ECIS        1       no 35,00Cell Free + HCMEC D3_line
      4140       ECIS        1       no 35,00Cell Free + HCMEC D3_line
      4141       ECIS        2       no 30,00Cell Free + HCMEC D3_line
      4142       ECIS        2       no 30,00Cell Free + HCMEC D3_line
      4143       ECIS        2       no 30,00Cell Free + HCMEC D3_line
      4144       ECIS        3       no 25,00Cell Free + HCMEC D3_line
      4145       ECIS        3       no 25,00Cell Free + HCMEC D3_line
      4146       ECIS        3       no 25,00Cell Free + HCMEC D3_line
      4147       ECIS        4       no 20,00Cell Free + HCMEC D3_line
      4148       ECIS        4       no 20,00Cell Free + HCMEC D3_line
      4149       ECIS        4       no 20,00Cell Free + HCMEC D3_line
      4150       ECIS        5       no 15,00Cell Free + HCMEC D3_line
      4151       ECIS        5       no 15,00Cell Free + HCMEC D3_line
      4152       ECIS        5       no 15,00Cell Free + HCMEC D3_line
      4153       ECIS        6       no 10,00Cell Free + HCMEC D3_line
      4154       ECIS        6       no 10,00Cell Free + HCMEC D3_line
      4155       ECIS        6       no 10,00Cell Free + HCMEC D3_line
      4156       ECIS        7       no  5,00Cell Free + HCMEC D3_line
      4157       ECIS        7       no  5,00Cell Free + HCMEC D3_line
      4158       ECIS        7       no  5,00Cell Free + HCMEC D3_line
      4159       ECIS        1       no 35,00Cell Free + HCMEC D3_line
      4160       ECIS        1       no 35,00Cell Free + HCMEC D3_line
      4161       ECIS        1       no 35,00Cell Free + HCMEC D3_line
      4162       ECIS        2       no 30,00Cell Free + HCMEC D3_line
      4163       ECIS        2       no 30,00Cell Free + HCMEC D3_line
      4164       ECIS        2       no 30,00Cell Free + HCMEC D3_line
      4165       ECIS        3       no 25,00Cell Free + HCMEC D3_line
      4166       ECIS        3       no 25,00Cell Free + HCMEC D3_line
      4167       ECIS        3       no 25,00Cell Free + HCMEC D3_line
      4168       ECIS        4       no 20,00Cell Free + HCMEC D3_line
      4169       ECIS        4       no 20,00Cell Free + HCMEC D3_line
      4170       ECIS        4       no 20,00Cell Free + HCMEC D3_line
      4171       ECIS        5       no 15,00Cell Free + HCMEC D3_line
      4172       ECIS        5       no 15,00Cell Free + HCMEC D3_line
      4173       ECIS        5       no 15,00Cell Free + HCMEC D3_line
      4174       ECIS        6       no 10,00Cell Free + HCMEC D3_line
      4175       ECIS        6       no 10,00Cell Free + HCMEC D3_line
      4176       ECIS        6       no 10,00Cell Free + HCMEC D3_line
      4177       ECIS        7       no  5,00Cell Free + HCMEC D3_line
      4178       ECIS        7       no  5,00Cell Free + HCMEC D3_line
      4179       ECIS        7       no  5,00Cell Free + HCMEC D3_line
      4180       ECIS        1       no 35,00Cell Free + HCMEC D3_line
      4181       ECIS        1       no 35,00Cell Free + HCMEC D3_line
      4182       ECIS        1       no 35,00Cell Free + HCMEC D3_line
      4183       ECIS        2       no 30,00Cell Free + HCMEC D3_line
      4184       ECIS        2       no 30,00Cell Free + HCMEC D3_line
      4185       ECIS        2       no 30,00Cell Free + HCMEC D3_line
      4186       ECIS        3       no 25,00Cell Free + HCMEC D3_line
      4187       ECIS        3       no 25,00Cell Free + HCMEC D3_line
      4188       ECIS        3       no 25,00Cell Free + HCMEC D3_line
      4189       ECIS        4       no 20,00Cell Free + HCMEC D3_line
      4190       ECIS        4       no 20,00Cell Free + HCMEC D3_line
      4191       ECIS        4       no 20,00Cell Free + HCMEC D3_line
      4192       ECIS        5       no 15,00Cell Free + HCMEC D3_line
      4193       ECIS        5       no 15,00Cell Free + HCMEC D3_line
      4194       ECIS        5       no 15,00Cell Free + HCMEC D3_line
      4195       ECIS        6       no 10,00Cell Free + HCMEC D3_line
      4196       ECIS        6       no 10,00Cell Free + HCMEC D3_line
      4197       ECIS        6       no 10,00Cell Free + HCMEC D3_line
      4198       ECIS        7       no  5,00Cell Free + HCMEC D3_line
      4199       ECIS        7       no  5,00Cell Free + HCMEC D3_line
      4200       ECIS        7       no  5,00Cell Free + HCMEC D3_line
      4201       ECIS        1       no 35,00Cell Free + HCMEC D3_line
      4202       ECIS        1       no 35,00Cell Free + HCMEC D3_line
      4203       ECIS        1       no 35,00Cell Free + HCMEC D3_line
      4204       ECIS        2       no 30,00Cell Free + HCMEC D3_line
      4205       ECIS        2       no 30,00Cell Free + HCMEC D3_line
      4206       ECIS        2       no 30,00Cell Free + HCMEC D3_line
      4207       ECIS        3       no 25,00Cell Free + HCMEC D3_line
      4208       ECIS        3       no 25,00Cell Free + HCMEC D3_line
      4209       ECIS        3       no 25,00Cell Free + HCMEC D3_line
      4210       ECIS        4       no 20,00Cell Free + HCMEC D3_line
      4211       ECIS        4       no 20,00Cell Free + HCMEC D3_line
      4212       ECIS        4       no 20,00Cell Free + HCMEC D3_line
      4213       ECIS        5       no 15,00Cell Free + HCMEC D3_line
      4214       ECIS        5       no 15,00Cell Free + HCMEC D3_line
      4215       ECIS        5       no 15,00Cell Free + HCMEC D3_line
      4216       ECIS        6       no 10,00Cell Free + HCMEC D3_line
      4217       ECIS        6       no 10,00Cell Free + HCMEC D3_line
      4218       ECIS        6       no 10,00Cell Free + HCMEC D3_line
      4219       ECIS        7       no  5,00Cell Free + HCMEC D3_line
      4220       ECIS        7       no  5,00Cell Free + HCMEC D3_line
      4221       ECIS        7       no  5,00Cell Free + HCMEC D3_line
      4222       ECIS        1       no 35,00Cell Free + HCMEC D3_line
      4223       ECIS        1       no 35,00Cell Free + HCMEC D3_line
      4224       ECIS        1       no 35,00Cell Free + HCMEC D3_line
      4225       ECIS        2       no 30,00Cell Free + HCMEC D3_line
      4226       ECIS        2       no 30,00Cell Free + HCMEC D3_line
      4227       ECIS        2       no 30,00Cell Free + HCMEC D3_line
      4228       ECIS        3       no 25,00Cell Free + HCMEC D3_line
      4229       ECIS        3       no 25,00Cell Free + HCMEC D3_line
      4230       ECIS        3       no 25,00Cell Free + HCMEC D3_line
      4231       ECIS        4       no 20,00Cell Free + HCMEC D3_line
      4232       ECIS        4       no 20,00Cell Free + HCMEC D3_line
      4233       ECIS        4       no 20,00Cell Free + HCMEC D3_line
      4234       ECIS        5       no 15,00Cell Free + HCMEC D3_line
      4235       ECIS        5       no 15,00Cell Free + HCMEC D3_line
      4236       ECIS        5       no 15,00Cell Free + HCMEC D3_line
      4237       ECIS        6       no 10,00Cell Free + HCMEC D3_line
      4238       ECIS        6       no 10,00Cell Free + HCMEC D3_line
      4239       ECIS        6       no 10,00Cell Free + HCMEC D3_line
      4240       ECIS        7       no  5,00Cell Free + HCMEC D3_line
      4241       ECIS        7       no  5,00Cell Free + HCMEC D3_line
      4242       ECIS        7       no  5,00Cell Free + HCMEC D3_line
      4243       ECIS        1       no 35,00Cell Free + HCMEC D3_line
      4244       ECIS        1       no 35,00Cell Free + HCMEC D3_line
      4245       ECIS        1       no 35,00Cell Free + HCMEC D3_line
      4246       ECIS        2       no 30,00Cell Free + HCMEC D3_line
      4247       ECIS        2       no 30,00Cell Free + HCMEC D3_line
      4248       ECIS        2       no 30,00Cell Free + HCMEC D3_line
      4249       ECIS        3       no 25,00Cell Free + HCMEC D3_line
      4250       ECIS        3       no 25,00Cell Free + HCMEC D3_line
      4251       ECIS        3       no 25,00Cell Free + HCMEC D3_line
      4252       ECIS        4       no 20,00Cell Free + HCMEC D3_line
      4253       ECIS        4       no 20,00Cell Free + HCMEC D3_line
      4254       ECIS        4       no 20,00Cell Free + HCMEC D3_line
      4255       ECIS        5       no 15,00Cell Free + HCMEC D3_line
      4256       ECIS        5       no 15,00Cell Free + HCMEC D3_line
      4257       ECIS        5       no 15,00Cell Free + HCMEC D3_line
      4258       ECIS        6       no 10,00Cell Free + HCMEC D3_line
      4259       ECIS        6       no 10,00Cell Free + HCMEC D3_line
      4260       ECIS        6       no 10,00Cell Free + HCMEC D3_line
      4261       ECIS        7       no  5,00Cell Free + HCMEC D3_line
      4262       ECIS        7       no  5,00Cell Free + HCMEC D3_line
      4263       ECIS        7       no  5,00Cell Free + HCMEC D3_line
      4264       ECIS        1       no 35,00Cell Free + HCMEC D3_line
      4265       ECIS        1       no 35,00Cell Free + HCMEC D3_line
      4266       ECIS        1       no 35,00Cell Free + HCMEC D3_line
      4267       ECIS        2       no 30,00Cell Free + HCMEC D3_line
      4268       ECIS        2       no 30,00Cell Free + HCMEC D3_line
      4269       ECIS        2       no 30,00Cell Free + HCMEC D3_line
      4270       ECIS        3       no 25,00Cell Free + HCMEC D3_line
      4271       ECIS        3       no 25,00Cell Free + HCMEC D3_line
      4272       ECIS        3       no 25,00Cell Free + HCMEC D3_line
      4273       ECIS        4       no 20,00Cell Free + HCMEC D3_line
      4274       ECIS        4       no 20,00Cell Free + HCMEC D3_line
      4275       ECIS        4       no 20,00Cell Free + HCMEC D3_line
      4276       ECIS        5       no 15,00Cell Free + HCMEC D3_line
      4277       ECIS        5       no 15,00Cell Free + HCMEC D3_line
      4278       ECIS        5       no 15,00Cell Free + HCMEC D3_line
      4279       ECIS        6       no 10,00Cell Free + HCMEC D3_line
      4280       ECIS        6       no 10,00Cell Free + HCMEC D3_line
      4281       ECIS        6       no 10,00Cell Free + HCMEC D3_line
      4282       ECIS        7       no  5,00Cell Free + HCMEC D3_line
      4283       ECIS        7       no  5,00Cell Free + HCMEC D3_line
      4284       ECIS        7       no  5,00Cell Free + HCMEC D3_line
      4285       ECIS        1       no 35,00Cell Free + HCMEC D3_line
      4286       ECIS        1       no 35,00Cell Free + HCMEC D3_line
      4287       ECIS        1       no 35,00Cell Free + HCMEC D3_line
      4288       ECIS        2       no 30,00Cell Free + HCMEC D3_line
      4289       ECIS        2       no 30,00Cell Free + HCMEC D3_line
      4290       ECIS        2       no 30,00Cell Free + HCMEC D3_line
      4291       ECIS        3       no 25,00Cell Free + HCMEC D3_line
      4292       ECIS        3       no 25,00Cell Free + HCMEC D3_line
      4293       ECIS        3       no 25,00Cell Free + HCMEC D3_line
      4294       ECIS        4       no 20,00Cell Free + HCMEC D3_line
      4295       ECIS        4       no 20,00Cell Free + HCMEC D3_line
      4296       ECIS        4       no 20,00Cell Free + HCMEC D3_line
      4297       ECIS        5       no 15,00Cell Free + HCMEC D3_line
      4298       ECIS        5       no 15,00Cell Free + HCMEC D3_line
      4299       ECIS        5       no 15,00Cell Free + HCMEC D3_line
      4300       ECIS        6       no 10,00Cell Free + HCMEC D3_line
      4301       ECIS        6       no 10,00Cell Free + HCMEC D3_line
      4302       ECIS        6       no 10,00Cell Free + HCMEC D3_line
      4303       ECIS        7       no  5,00Cell Free + HCMEC D3_line
      4304       ECIS        7       no  5,00Cell Free + HCMEC D3_line
      4305       ECIS        7       no  5,00Cell Free + HCMEC D3_line
      4306       ECIS        1       no 35,00Cell Free + HCMEC D3_line
      4307       ECIS        1       no 35,00Cell Free + HCMEC D3_line
      4308       ECIS        1       no 35,00Cell Free + HCMEC D3_line
      4309       ECIS        1       no 35,00Cell Free + HCMEC D3_line
      4310       ECIS        1       no 35,00Cell Free + HCMEC D3_line
      4311       ECIS        1       no 35,00Cell Free + HCMEC D3_line
      4312       ECIS        1       no 35,00Cell Free + HCMEC D3_line
      4313       ECIS        1       no 35,00Cell Free + HCMEC D3_line
      4314       ECIS        1       no 35,00Cell Free + HCMEC D3_line
      4315       ECIS        1       no 35,00Cell Free + HCMEC D3_line
      4316       ECIS        1       no 35,00Cell Free + HCMEC D3_line
      4317       ECIS        1       no 35,00Cell Free + HCMEC D3_line
      4318       ECIS        1       no 35,00Cell Free + HCMEC D3_line
      4319       ECIS        1       no 35,00Cell Free + HCMEC D3_line
      4320       ECIS        1       no 35,00Cell Free + HCMEC D3_line
      4321       ECIS        1       no 35,00Cell Free + HCMEC D3_line
      4322       ECIS        1       no 35,00Cell Free + HCMEC D3_line
      4323       ECIS        1       no 35,00Cell Free + HCMEC D3_line
      4324       ECIS        1       no 35,00Cell Free + HCMEC D3_line
      4325       ECIS        1       no 35,00Cell Free + HCMEC D3_line
      4326       ECIS        1       no 35,00Cell Free + HCMEC D3_line
      4327       ECIS        1       no 35,00Cell Free + HCMEC D3_line
      4328       ECIS        1       no 35,00Cell Free + HCMEC D3_line
      4329       ECIS        1       no 35,00Cell Free + HCMEC D3_line
      4330       ECIS        1       no 35,00Cell Free + HCMEC D3_line
      4331       ECIS        1       no 35,00Cell Free + HCMEC D3_line
      4332       ECIS        1       no 35,00Cell Free + HCMEC D3_line
      4333       ECIS        1       no 35,00Cell Free + HCMEC D3_line
      4334       ECIS        1       no 35,00Cell Free + HCMEC D3_line
      4335       ECIS        1       no 35,00Cell Free + HCMEC D3_line
      4336       ECIS        1       no 35,00Cell Free + HCMEC D3_line
      4337       ECIS        1       no 35,00Cell Free + HCMEC D3_line
      4338       ECIS        1       no 35,00Cell Free + HCMEC D3_line
      4339       ECIS        1       no 35,00Cell Free + HCMEC D3_line
      4340       ECIS        1       no 35,00Cell Free + HCMEC D3_line
      4341       ECIS        1       no 35,00Cell Free + HCMEC D3_line
      4342       ECIS        1       no 35,00Cell Free + HCMEC D3_line
      4343       ECIS        1       no 35,00Cell Free + HCMEC D3_line
      4344       ECIS        1       no 35,00Cell Free + HCMEC D3_line
      4345       ECIS        1       no 35,00Cell Free + HCMEC D3_line
      4346       ECIS        1       no 35,00Cell Free + HCMEC D3_line
      4347       ECIS        1       no 35,00Cell Free + HCMEC D3_line
      4348       ECIS        1       no 35,00Cell Free + HCMEC D3_line
      4349       ECIS        1       no 35,00Cell Free + HCMEC D3_line
      4350       ECIS        1       no 35,00Cell Free + HCMEC D3_line
      4351       ECIS        1       no 35,00Cell Free + HCMEC D3_line
      4352       ECIS        1       no 35,00Cell Free + HCMEC D3_line
      4353       ECIS        1       no 35,00Cell Free + HCMEC D3_line
      4354       ECIS        1       no 35,00Cell Free + HCMEC D3_line
      4355       ECIS        1       no 35,00Cell Free + HCMEC D3_line
      4356       ECIS        1       no 35,00Cell Free + HCMEC D3_line
      4357       ECIS        1       no 35,00Cell Free + HCMEC D3_line
      4358       ECIS        1       no 35,00Cell Free + HCMEC D3_line
      4359       ECIS        1       no 35,00Cell Free + HCMEC D3_line
      4360       ECIS        1       no 35,00Cell Free + HCMEC D3_line
      4361       ECIS        1       no 35,00Cell Free + HCMEC D3_line
      4362       ECIS        1       no 35,00Cell Free + HCMEC D3_line
      4363       ECIS        1       no 35,00Cell Free + HCMEC D3_line
      4364       ECIS        1       no 35,00Cell Free + HCMEC D3_line
      4365       ECIS        1       no 35,00Cell Free + HCMEC D3_line
      4366       ECIS        1       no 35,00Cell Free + HCMEC D3_line
      4367       ECIS        1       no 35,00Cell Free + HCMEC D3_line
      4368       ECIS        1       no 35,00Cell Free + HCMEC D3_line
      4369       ECIS        1       no 35,00Cell Free + HCMEC D3_line
      4370       ECIS        1       no 35,00Cell Free + HCMEC D3_line
      4371       ECIS        1       no 35,00Cell Free + HCMEC D3_line
      4372       ECIS        1       no 35,00Cell Free + HCMEC D3_line
      4373       ECIS        1       no 35,00Cell Free + HCMEC D3_line
      4374       ECIS        1       no 35,00Cell Free + HCMEC D3_line
      4375       ECIS        1       no 35,00Cell Free + HCMEC D3_line
      4376       ECIS        1       no 35,00Cell Free + HCMEC D3_line
      4377       ECIS        1       no 35,00Cell Free + HCMEC D3_line
      4378       ECIS        1       no 35,00Cell Free + HCMEC D3_line
      4379       ECIS        1       no 35,00Cell Free + HCMEC D3_line
      4380       ECIS        1       no 35,00Cell Free + HCMEC D3_line
      4381       ECIS        1       no 35,00Cell Free + HCMEC D3_line
      4382       ECIS        1       no 35,00Cell Free + HCMEC D3_line
      4383       ECIS        1       no 35,00Cell Free + HCMEC D3_line
      4384       ECIS        1       no 35,00Cell Free + HCMEC D3_line
      4385       ECIS        1       no 35,00Cell Free + HCMEC D3_line
      4386       ECIS        1       no 35,00Cell Free + HCMEC D3_line
      4387       ECIS        1       no 35,00Cell Free + HCMEC D3_line
      4388       ECIS        1       no 35,00Cell Free + HCMEC D3_line
      4389       ECIS        1       no 35,00Cell Free + HCMEC D3_line
      4390       ECIS        1       no 35,00Cell Free + HCMEC D3_line
      4391       ECIS        1       no 35,00Cell Free + HCMEC D3_line
      4392       ECIS        1       no 35,00Cell Free + HCMEC D3_line
      4393       ECIS        1       no 35,00Cell Free + HCMEC D3_line
      4394       ECIS        1       no 35,00Cell Free + HCMEC D3_line
      4395       ECIS        1       no 35,00Cell Free + HCMEC D3_line
      4396       ECIS        1       no 35,00Cell Free + HCMEC D3_line
      4397       ECIS        1       no 35,00Cell Free + HCMEC D3_line
      4398       ECIS        1       no 35,00Cell Free + HCMEC D3_line
      4399       ECIS        1       no 35,00Cell Free + HCMEC D3_line
      4400       ECIS        1       no 35,00Cell Free + HCMEC D3_line
      4401       ECIS        1       no 35,00Cell Free + HCMEC D3_line
      4402       ECIS        1       no 35,00Cell Free + HCMEC D3_line
      4403       ECIS        1       no 35,00Cell Free + HCMEC D3_line
      4404       ECIS        1       no 35,00Cell Free + HCMEC D3_line
      4405       ECIS        1       no 35,00Cell Free + HCMEC D3_line
      4406       ECIS        1       no 35,00Cell Free + HCMEC D3_line
      4407       ECIS        1       no 35,00Cell Free + HCMEC D3_line
      4408       ECIS        1       no 35,00Cell Free + HCMEC D3_line
      4409       ECIS        1       no 35,00Cell Free + HCMEC D3_line
      4410       ECIS        1       no 35,00Cell Free + HCMEC D3_line
      4411       ECIS        1       no 35,00Cell Free + HCMEC D3_line
      4412       ECIS        1       no 35,00Cell Free + HCMEC D3_line
      4413       ECIS        1       no 35,00Cell Free + HCMEC D3_line
      4414       ECIS        1       no 35,00Cell Free + HCMEC D3_line
      4415       ECIS        1       no 35,00Cell Free + HCMEC D3_line
      4416       ECIS        1       no 35,00Cell Free + HCMEC D3_line
      4417       ECIS        1       no 35,00Cell Free + HCMEC D3_line
      4418       ECIS        1       no 35,00Cell Free + HCMEC D3_line
      4419       ECIS        1       no 35,00Cell Free + HCMEC D3_line
      4420       ECIS        1       no 35,00Cell Free + HCMEC D3_line
      4421       ECIS        1       no 35,00Cell Free + HCMEC D3_line
      4422       ECIS        1       no 35,00Cell Free + HCMEC D3_line
      4423       ECIS        1       no 35,00Cell Free + HCMEC D3_line
      4424       ECIS        1       no 35,00Cell Free + HCMEC D3_line
      4425       ECIS        1       no 35,00Cell Free + HCMEC D3_line
      4426       ECIS        1       no 35,00Cell Free + HCMEC D3_line
      4427       ECIS        1       no 35,00Cell Free + HCMEC D3_line
      4428       ECIS        1       no 35,00Cell Free + HCMEC D3_line
      4429       ECIS        1       no 35,00Cell Free + HCMEC D3_line
      4430       ECIS        1       no 35,00Cell Free + HCMEC D3_line
      4431       ECIS        1       no 35,00Cell Free + HCMEC D3_line
      4432       ECIS        1       no 35,00Cell Free + HCMEC D3_line
      4433       ECIS        1       no 35,00Cell Free + HCMEC D3_line
      4434       ECIS        1       no 35,00Cell Free + HCMEC D3_line
      4435       ECIS        1       no 35,00Cell Free + HCMEC D3_line
      4436       ECIS        1       no 35,00Cell Free + HCMEC D3_line
      4437       ECIS        1       no 35,00Cell Free + HCMEC D3_line
      4438       ECIS        1       no 35,00Cell Free + HCMEC D3_line
      4439       ECIS        1       no 35,00Cell Free + HCMEC D3_line
      4440       ECIS        1       no 35,00Cell Free + HCMEC D3_line
      4441       ECIS        1       no 35,00Cell Free + HCMEC D3_line
      4442       ECIS        1       no 35,00Cell Free + HCMEC D3_line
      4443       ECIS        1       no 35,00Cell Free + HCMEC D3_line
      4444       ECIS        1       no 35,00Cell Free + HCMEC D3_line
      4445       ECIS        1       no 35,00Cell Free + HCMEC D3_line
      4446       ECIS        1       no 35,00Cell Free + HCMEC D3_line
      4447       ECIS        1       no 35,00Cell Free + HCMEC D3_line
      4448       ECIS        1       no 35,00Cell Free + HCMEC D3_line
      4449       ECIS        1       no 35,00Cell Free + HCMEC D3_line
      4450       ECIS        1       no 35,00Cell Free + HCMEC D3_line
      4451       ECIS        1       no 35,00Cell Free + HCMEC D3_line
      4452       ECIS        1       no 35,00Cell Free + HCMEC D3_line
      4453       ECIS        1       no 35,00Cell Free + HCMEC D3_line
      4454       ECIS        1       no 35,00Cell Free + HCMEC D3_line
      4455       ECIS        1       no 35,00Cell Free + HCMEC D3_line
      4456       ECIS        1       no 35,00Cell Free + HCMEC D3_line
      4457       ECIS        1       no 35,00Cell Free + HCMEC D3_line
      4458       ECIS        1       no 35,00Cell Free + HCMEC D3_line
      4459       ECIS        1       no 35,00Cell Free + HCMEC D3_line
      4460       ECIS        1       no 35,00Cell Free + HCMEC D3_line
      4461       ECIS        1       no 35,00Cell Free + HCMEC D3_line
      4462       ECIS        1       no 35,00Cell Free + HCMEC D3_line
      4463       ECIS        1       no 35,00Cell Free + HCMEC D3_line
      4464       ECIS        1       no 35,00Cell Free + HCMEC D3_line
      4465       ECIS        1       no 35,00Cell Free + HCMEC D3_line
      4466       ECIS        1       no 35,00Cell Free + HCMEC D3_line
      4467       ECIS        1       no 35,00Cell Free + HCMEC D3_line
      4468       ECIS        1       no 35,00Cell Free + HCMEC D3_line
      4469       ECIS        1       no 35,00Cell Free + HCMEC D3_line
      4470       ECIS        1       no 35,00Cell Free + HCMEC D3_line
      4471       ECIS        1       no 35,00Cell Free + HCMEC D3_line
      4472       ECIS        1       no 35,00Cell Free + HCMEC D3_line
      4473       ECIS        1       no 35,00Cell Free + HCMEC D3_line
      4474       ECIS        1       no 35,00Cell Free + HCMEC D3_line
      4475       ECIS        1       no 35,00Cell Free + HCMEC D3_line
      4476       ECIS        1       no 35,00Cell Free + HCMEC D3_line
      4477       ECIS        1       no 35,00Cell Free + HCMEC D3_line
      4478       ECIS        1       no 35,00Cell Free + HCMEC D3_line
      4479       ECIS        1       no 35,00Cell Free + HCMEC D3_line
      4480       ECIS        1       no 35,00Cell Free + HCMEC D3_line
      4481       ECIS        1       no 35,00Cell Free + HCMEC D3_line
      4482       ECIS        1       no 35,00Cell Free + HCMEC D3_line
      4483       ECIS        1       no 35,00Cell Free + HCMEC D3_line
      4484       ECIS        1       no 35,00Cell Free + HCMEC D3_line
      4485       ECIS        1       no 35,00Cell Free + HCMEC D3_line
      4486       ECIS        1       no 35,00Cell Free + HCMEC D3_line
      4487       ECIS        1       no 35,00Cell Free + HCMEC D3_line
      4488       ECIS        1       no 35,00Cell Free + HCMEC D3_line
      4489       ECIS        1       no 35,00Cell Free + HCMEC D3_line
      4490       ECIS        1       no 35,00Cell Free + HCMEC D3_line
      4491       ECIS        1       no 35,00Cell Free + HCMEC D3_line
      4492       ECIS        1       no 35,00Cell Free + HCMEC D3_line
      4493       ECIS        1       no 35,00Cell Free + HCMEC D3_line
      4494       ECIS        1       no 35,00Cell Free + HCMEC D3_line
      4495       ECIS        1       no 35,00Cell Free + HCMEC D3_line
      4496       ECIS        1       no 35,00Cell Free + HCMEC D3_line
      4497       ECIS        1       no 35,00Cell Free + HCMEC D3_line
      4498       ECIS        1       no 35,00Cell Free + HCMEC D3_line
      4499       ECIS        1       no 35,00Cell Free + HCMEC D3_line
      4500       ECIS        1       no 35,00Cell Free + HCMEC D3_line
      4501       ECIS        1       no 35,00Cell Free + HCMEC D3_line
      4502       ECIS        1       no 35,00Cell Free + HCMEC D3_line
      4503       ECIS        1       no 35,00Cell Free + HCMEC D3_line
      4504       ECIS        1       no 35,00Cell Free + HCMEC D3_line
      4505       ECIS        1       no 35,00Cell Free + HCMEC D3_line
      4506       ECIS        1       no 35,00Cell Free + HCMEC D3_line
      4507       ECIS        1       no 35,00Cell Free + HCMEC D3_line
      4508       ECIS        1       no 35,00Cell Free + HCMEC D3_line
      4509       ECIS        1       no 35,00Cell Free + HCMEC D3_line
      4510       ECIS        1       no 35,00Cell Free + HCMEC D3_line
      4511       ECIS        1       no 35,00Cell Free + HCMEC D3_line
      4512       ECIS        1       no 35,00Cell Free + HCMEC D3_line
      4513       ECIS        1       no 35,00Cell Free + HCMEC D3_line
      4514       ECIS        1       no 35,00Cell Free + HCMEC D3_line
      4515       ECIS        1       no 35,00Cell Free + HCMEC D3_line
      4516       ECIS        1       no 35,00Cell Free + HCMEC D3_line
      4517       ECIS        1       no 35,00Cell Free + HCMEC D3_line
      4518       ECIS        1       no 35,00Cell Free + HCMEC D3_line
      4519       ECIS        1       no 35,00Cell Free + HCMEC D3_line
      4520       ECIS        1       no 35,00Cell Free + HCMEC D3_line
      4521       ECIS        1       no 35,00Cell Free + HCMEC D3_line
      4522       ECIS        1       no 35,00Cell Free + HCMEC D3_line
      4523       ECIS        1       no 35,00Cell Free + HCMEC D3_line
      4524       ECIS        1       no 35,00Cell Free + HCMEC D3_line
      4525       ECIS        1       no 35,00Cell Free + HCMEC D3_line
      4526       ECIS        1       no 35,00Cell Free + HCMEC D3_line
      4527       ECIS        1       no 35,00Cell Free + HCMEC D3_line
      4528       ECIS        1       no 35,00Cell Free + HCMEC D3_line
      4529       ECIS        1       no 35,00Cell Free + HCMEC D3_line
      4530       ECIS        1       no 35,00Cell Free + HCMEC D3_line
      4531       ECIS        1       no 35,00Cell Free + HCMEC D3_line
      4532       ECIS        1       no 35,00Cell Free + HCMEC D3_line
      4533       ECIS        1       no 35,00Cell Free + HCMEC D3_line
      4534       ECIS        1       no 35,00Cell Free + HCMEC D3_line
      4535       ECIS        1       no 35,00Cell Free + HCMEC D3_line
      4536       ECIS        1       no 35,00Cell Free + HCMEC D3_line
      4537       ECIS        1       no 35,00Cell Free + HCMEC D3_line
      4538       ECIS        1       no 35,00Cell Free + HCMEC D3_line
      4539       ECIS        1       no 35,00Cell Free + HCMEC D3_line
      4540       ECIS        1       no 35,00Cell Free + HCMEC D3_line
      4541       ECIS        1       no 35,00Cell Free + HCMEC D3_line
      4542       ECIS        1       no 35,00Cell Free + HCMEC D3_line
      4543       ECIS        1       no 35,00Cell Free + HCMEC D3_line
      4544       ECIS        1       no 35,00Cell Free + HCMEC D3_line
      4545       ECIS        1       no 35,00Cell Free + HCMEC D3_line
      4546       ECIS        1       no 35,00Cell Free + HCMEC D3_line
      4547       ECIS        1       no 35,00Cell Free + HCMEC D3_line
      4548       ECIS        1       no 35,00Cell Free + HCMEC D3_line
      4549       ECIS        1       no 35,00Cell Free + HCMEC D3_line
      4550       ECIS        1       no 35,00Cell Free + HCMEC D3_line
      4551       ECIS        1       no 35,00Cell Free + HCMEC D3_line
      4552       ECIS        1       no 35,00Cell Free + HCMEC D3_line
      4553       ECIS        1       no 35,00Cell Free + HCMEC D3_line
      4554       ECIS        1       no 35,00Cell Free + HCMEC D3_line
      4555       ECIS        1       no 35,00Cell Free + HCMEC D3_line
      4556       ECIS        1       no 35,00Cell Free + HCMEC D3_line
      4557       ECIS        1       no 35,00Cell Free + HCMEC D3_line
      4558       ECIS        1       no 35,00Cell Free + HCMEC D3_line
      4559       ECIS        1       no 35,00Cell Free + HCMEC D3_line
      4560       ECIS        1       no 35,00Cell Free + HCMEC D3_line
      4561       ECIS        1       no 35,00Cell Free + HCMEC D3_line
      4562       ECIS        1       no 35,00Cell Free + HCMEC D3_line
      4563       ECIS        1       no 35,00Cell Free + HCMEC D3_line
      4564       ECIS        1       no 35,00Cell Free + HCMEC D3_line
      4565       ECIS        1       no 35,00Cell Free + HCMEC D3_line
      4566       ECIS        1       no 35,00Cell Free + HCMEC D3_line
      4567       ECIS        1       no 35,00Cell Free + HCMEC D3_line
      4568       ECIS        1       no 35,00Cell Free + HCMEC D3_line
      4569       ECIS        1       no 35,00Cell Free + HCMEC D3_line
      4570       ECIS        1       no 35,00Cell Free + HCMEC D3_line
      4571       ECIS        1       no 35,00Cell Free + HCMEC D3_line
      4572       ECIS        1       no 35,00Cell Free + HCMEC D3_line
      4573       ECIS        1       no 35,00Cell Free + HCMEC D3_line
      4574       ECIS        1       no 35,00Cell Free + HCMEC D3_line
      4575       ECIS        1       no 35,00Cell Free + HCMEC D3_line
      4576       ECIS        1       no 35,00Cell Free + HCMEC D3_line
      4577       ECIS        1       no 35,00Cell Free + HCMEC D3_line
      4578       ECIS        1       no 35,00Cell Free + HCMEC D3_line
      4579       ECIS        1       no 35,00Cell Free + HCMEC D3_line
      4580       ECIS        1       no 35,00Cell Free + HCMEC D3_line
      4581       ECIS        1       no 35,00Cell Free + HCMEC D3_line
      4582       ECIS        1       no 35,00Cell Free + HCMEC D3_line
      4583       ECIS        1       no 35,00Cell Free + HCMEC D3_line
      4584       ECIS        1       no 35,00Cell Free + HCMEC D3_line
      4585       ECIS        1       no 35,00Cell Free + HCMEC D3_line
      4586       ECIS        1       no 35,00Cell Free + HCMEC D3_line
      4587       ECIS        1       no 35,00Cell Free + HCMEC D3_line
      4588       ECIS        1       no 35,00Cell Free + HCMEC D3_line
      4589       ECIS        1       no 35,00Cell Free + HCMEC D3_line
      4590       ECIS        1       no 35,00Cell Free + HCMEC D3_line
      4591       ECIS        1       no 35,00Cell Free + HCMEC D3_line
      4592       ECIS        1       no 35,00Cell Free + HCMEC D3_line
      4593       ECIS        1       no 35,00Cell Free + HCMEC D3_line
      4594       ECIS        1       no 35,00Cell Free + HCMEC D3_line
      4595       ECIS        1       no 35,00Cell Free + HCMEC D3_line
      4596       ECIS        1       no 35,00Cell Free + HCMEC D3_line
      4597       ECIS        1       no 35,00Cell Free + HCMEC D3_line
      4598       ECIS        1       no 35,00Cell Free + HCMEC D3_line
      4599       ECIS        1       no 35,00Cell Free + HCMEC D3_line
      4600       ECIS        1       no 35,00Cell Free + HCMEC D3_line
      4601       ECIS        1       no 35,00Cell Free + HCMEC D3_line
      4602       ECIS        1       no 35,00Cell Free + HCMEC D3_line
      4603       ECIS        1       no 35,00Cell Free + HCMEC D3_line
      4604       ECIS        1       no 35,00Cell Free + HCMEC D3_line
      4605       ECIS        1       no 35,00Cell Free + HCMEC D3_line
      4606       ECIS        1       no 35,00Cell Free + HCMEC D3_line
      4607       ECIS        1       no 35,00Cell Free + HCMEC D3_line
      4608       ECIS        1       no 35,00Cell Free + HCMEC D3_line
      4609       ECIS        1       no 35,00Cell Free + HCMEC D3_line
      4610       ECIS        1       no 35,00Cell Free + HCMEC D3_line
      4611       ECIS        1       no 35,00Cell Free + HCMEC D3_line
      4612       ECIS        1       no 35,00Cell Free + HCMEC D3_line
      4613       ECIS        1       no 35,00Cell Free + HCMEC D3_line
      4614       ECIS        1       no 35,00Cell Free + HCMEC D3_line
      4615       ECIS        1       no 35,00Cell Free + HCMEC D3_line
      4616       ECIS        1       no 35,00Cell Free + HCMEC D3_line
      4617       ECIS        1       no 35,00Cell Free + HCMEC D3_line
      4618       ECIS        1       no 35,00Cell Free + HCMEC D3_line
      4619       ECIS        1       no 35,00Cell Free + HCMEC D3_line
      4620       ECIS        1       no 35,00Cell Free + HCMEC D3_line
      4621       ECIS        1       no 35,00Cell Free + HCMEC D3_line
      4622       ECIS        1       no 35,00Cell Free + HCMEC D3_line
      4623       ECIS        1       no 35,00Cell Free + HCMEC D3_line
      4624       ECIS        1       no 35,00Cell Free + HCMEC D3_line
      4625       ECIS        1       no 35,00Cell Free + HCMEC D3_line
      4626       ECIS        1       no 35,00Cell Free + HCMEC D3_line
      4627       ECIS        1       no 35,00Cell Free + HCMEC D3_line
      4628       ECIS        1       no 35,00Cell Free + HCMEC D3_line
      4629       ECIS        1       no 35,00Cell Free + HCMEC D3_line
      4630       ECIS        1       no 35,00Cell Free + HCMEC D3_line
      4631       ECIS        1       no 35,00Cell Free + HCMEC D3_line
      4632       ECIS        1       no 35,00Cell Free + HCMEC D3_line
      4633       ECIS        1       no 35,00Cell Free + HCMEC D3_line
      4634       ECIS        1       no 35,00Cell Free + HCMEC D3_line
      4635       ECIS        1       no 35,00Cell Free + HCMEC D3_line
      4636       ECIS        1       no 35,00Cell Free + HCMEC D3_line
      4637       ECIS        1       no 35,00Cell Free + HCMEC D3_line
      4638       ECIS        1       no 35,00Cell Free + HCMEC D3_line
      4639       ECIS        1       no 35,00Cell Free + HCMEC D3_line
      4640       ECIS        1       no 35,00Cell Free + HCMEC D3_line
      4641       ECIS        1       no 35,00Cell Free + HCMEC D3_line
      4642       ECIS        1       no 35,00Cell Free + HCMEC D3_line
      4643       ECIS        1       no 35,00Cell Free + HCMEC D3_line
      4644       ECIS        1       no 35,00Cell Free + HCMEC D3_line
      4645       ECIS        1       no 35,00Cell Free + HCMEC D3_line
      4646       ECIS        1       no 35,00Cell Free + HCMEC D3_line
      4647       ECIS        1       no 35,00Cell Free + HCMEC D3_line
      4648       ECIS        1       no 35,00Cell Free + HCMEC D3_line
      4649       ECIS        1       no 35,00Cell Free + HCMEC D3_line
      4650       ECIS        1       no 35,00Cell Free + HCMEC D3_line
      4651       ECIS        1       no 35,00Cell Free + HCMEC D3_line
      4652       ECIS        1       no 35,00Cell Free + HCMEC D3_line
      4653       ECIS        1       no 35,00Cell Free + HCMEC D3_line
      4654       ECIS        1       no 35,00Cell Free + HCMEC D3_line
      4655       ECIS        1       no 35,00Cell Free + HCMEC D3_line
      4656       ECIS        1       no 35,00Cell Free + HCMEC D3_line
      4657       ECIS        1       no 35,00Cell Free + HCMEC D3_line
      4658       ECIS        1       no 35,00Cell Free + HCMEC D3_line
      4659       ECIS        1       no 35,00Cell Free + HCMEC D3_line
      4660       ECIS        1       no 35,00Cell Free + HCMEC D3_line
      4661       ECIS        1       no 35,00Cell Free + HCMEC D3_line
      4662       ECIS        1       no 35,00Cell Free + HCMEC D3_line
      4663       ECIS        1       no 35,00Cell Free + HCMEC D3_line
      4664       ECIS        1       no 35,00Cell Free + HCMEC D3_line
      4665       ECIS        1       no 35,00Cell Free + HCMEC D3_line
      4666       ECIS        1       no 35,00Cell Free + HCMEC D3_line
      4667       ECIS        1       no 35,00Cell Free + HCMEC D3_line
      4668       ECIS        1       no 35,00Cell Free + HCMEC D3_line
      4669       ECIS        1       no 35,00Cell Free + HCMEC D3_line
      4670       ECIS        1       no 35,00Cell Free + HCMEC D3_line
      4671       ECIS        1       no 35,00Cell Free + HCMEC D3_line
      4672       ECIS        1       no 35,00Cell Free + HCMEC D3_line
      4673       ECIS        1       no 35,00Cell Free + HCMEC D3_line
      4674       ECIS        1       no 35,00Cell Free + HCMEC D3_line
      4675       ECIS        1       no 35,00Cell Free + HCMEC D3_line
      4676       ECIS        1       no 35,00Cell Free + HCMEC D3_line
      4677       ECIS        1       no 35,00Cell Free + HCMEC D3_line
      4678       ECIS        1       no 35,00Cell Free + HCMEC D3_line
      4679       ECIS        1       no 35,00Cell Free + HCMEC D3_line
      4680       ECIS        1       no 35,00Cell Free + HCMEC D3_line
      4681       ECIS        1       no 35,00Cell Free + HCMEC D3_line
      4682       ECIS        1       no 35,00Cell Free + HCMEC D3_line
      4683       ECIS        1       no 35,00Cell Free + HCMEC D3_line
      4684       ECIS        1       no 35,00Cell Free + HCMEC D3_line
      4685       ECIS        1       no 35,00Cell Free + HCMEC D3_line
      4686       ECIS        1       no 35,00Cell Free + HCMEC D3_line
      4687       ECIS        1       no 35,00Cell Free + HCMEC D3_line
      4688       ECIS        1       no 35,00Cell Free + HCMEC D3_line
      4689       ECIS        1       no 35,00Cell Free + HCMEC D3_line
      4690       ECIS        1       no 35,00Cell Free + HCMEC D3_line
      4691       ECIS        1       no 35,00Cell Free + HCMEC D3_line
      4692       ECIS        1       no 35,00Cell Free + HCMEC D3_line
      4693       ECIS        1       no 35,00Cell Free + HCMEC D3_line
      4694       ECIS        1       no 35,00Cell Free + HCMEC D3_line
      4695       ECIS        1       no 35,00Cell Free + HCMEC D3_line
      4696       ECIS        1       no 35,00Cell Free + HCMEC D3_line
      4697       ECIS        1       no 35,00Cell Free + HCMEC D3_line
      4698       ECIS        1       no 35,00Cell Free + HCMEC D3_line
      4699       ECIS        1       no 35,00Cell Free + HCMEC D3_line
      4700       ECIS        1       no 35,00Cell Free + HCMEC D3_line
      4701       ECIS        1       no 35,00Cell Free + HCMEC D3_line
      4702       ECIS        1       no 35,00Cell Free + HCMEC D3_line
      4703       ECIS        1       no 35,00Cell Free + HCMEC D3_line
      4704       ECIS        1       no 35,00Cell Free + HCMEC D3_line
      4705       ECIS        1       no 35,00Cell Free + HCMEC D3_line
      4706       ECIS        1       no 35,00Cell Free + HCMEC D3_line
      4707       ECIS        1       no 35,00Cell Free + HCMEC D3_line
      4708       ECIS        1       no 35,00Cell Free + HCMEC D3_line
      4709       ECIS        1       no 35,00Cell Free + HCMEC D3_line
      4710       ECIS        1       no 35,00Cell Free + HCMEC D3_line
      4711       ECIS        1       no 35,00Cell Free + HCMEC D3_line
      4712       ECIS        1       no 35,00Cell Free + HCMEC D3_line
      4713       ECIS        1       no 35,00Cell Free + HCMEC D3_line
      4714       ECIS        1       no 35,00Cell Free + HCMEC D3_line
      4715       ECIS        1       no 35,00Cell Free + HCMEC D3_line
      4716       ECIS        1       no 35,00Cell Free + HCMEC D3_line
      4717       ECIS        1       no 35,00Cell Free + HCMEC D3_line
      4718       ECIS        1       no 35,00Cell Free + HCMEC D3_line
      4719       ECIS        1       no 35,00Cell Free + HCMEC D3_line
      4720       ECIS        1       no 35,00Cell Free + HCMEC D3_line
      4721       ECIS        1       no 35,00Cell Free + HCMEC D3_line
      4722       ECIS        1       no 35,00Cell Free + HCMEC D3_line
      4723       ECIS        1       no 35,00Cell Free + HCMEC D3_line
      4724       ECIS        1       no 35,00Cell Free + HCMEC D3_line
      4725       ECIS        1       no 35,00Cell Free + HCMEC D3_line
      4726       ECIS        1       no 35,00Cell Free + HCMEC D3_line
      4727       ECIS        1       no 35,00Cell Free + HCMEC D3_line
      4728       ECIS        1       no 35,00Cell Free + HCMEC D3_line
      4729       ECIS        1       no 35,00Cell Free + HCMEC D3_line
      4730       ECIS        1       no 35,00Cell Free + HCMEC D3_line
      4731       ECIS        1       no 35,00Cell Free + HCMEC D3_line
      4732       ECIS        1       no 35,00Cell Free + HCMEC D3_line
      4733       ECIS        1       no 35,00Cell Free + HCMEC D3_line
      4734       ECIS        1       no 35,00Cell Free + HCMEC D3_line
      4735       ECIS        1       no 35,00Cell Free + HCMEC D3_line
      4736       ECIS        1       no 35,00Cell Free + HCMEC D3_line
      4737       ECIS        1       no 35,00Cell Free + HCMEC D3_line
      4738       ECIS        1       no 35,00Cell Free + HCMEC D3_line
      4739       ECIS        1       no 35,00Cell Free + HCMEC D3_line
      4740       ECIS        1       no 35,00Cell Free + HCMEC D3_line
      4741       ECIS        1       no 35,00Cell Free + HCMEC D3_line
      4742       ECIS        1       no 35,00Cell Free + HCMEC D3_line
      4743       ECIS        1       no 35,00Cell Free + HCMEC D3_line
      4744       ECIS        1       no 35,00Cell Free + HCMEC D3_line
      4745       ECIS        1       no 35,00Cell Free + HCMEC D3_line
      4746       ECIS        1       no 35,00Cell Free + HCMEC D3_line
      4747       ECIS        1       no 35,00Cell Free + HCMEC D3_line
      4748       ECIS        1       no 35,00Cell Free + HCMEC D3_line
      4749       ECIS        1       no 35,00Cell Free + HCMEC D3_line
      4750       ECIS        1       no 35,00Cell Free + HCMEC D3_line
      4751       ECIS        1       no 35,00Cell Free + HCMEC D3_line
      4752       ECIS        1       no 35,00Cell Free + HCMEC D3_line
      4753       ECIS        1       no 35,00Cell Free + HCMEC D3_line
      4754       ECIS        1       no 35,00Cell Free + HCMEC D3_line
      4755       ECIS        1       no 35,00Cell Free + HCMEC D3_line
      4756       ECIS        1       no 35,00Cell Free + HCMEC D3_line
      4757       ECIS        1       no 35,00Cell Free + HCMEC D3_line
      4758       ECIS        1       no 35,00Cell Free + HCMEC D3_line
      4759       ECIS        1       no 35,00Cell Free + HCMEC D3_line
      4760       ECIS        1       no 35,00Cell Free + HCMEC D3_line
      4761       ECIS        1       no 35,00Cell Free + HCMEC D3_line
      4762       ECIS        1       no 35,00Cell Free + HCMEC D3_line
      4763       ECIS        1       no 35,00Cell Free + HCMEC D3_line
      4764       ECIS        1       no 35,00Cell Free + HCMEC D3_line
      4765       ECIS        1       no 35,00Cell Free + HCMEC D3_line
      4766       ECIS        1       no 35,00Cell Free + HCMEC D3_line
      4767       ECIS        1       no 35,00Cell Free + HCMEC D3_line
      4768       ECIS        1       no 35,00Cell Free + HCMEC D3_line
      4769       ECIS        1       no 35,00Cell Free + HCMEC D3_line
      4770       ECIS        1       no 35,00Cell Free + HCMEC D3_line
      4771       ECIS        1       no 35,00Cell Free + HCMEC D3_line
      4772       ECIS        1       no 35,00Cell Free + HCMEC D3_line
      4773       ECIS        1       no 35,00Cell Free + HCMEC D3_line
      4774       ECIS        1       no 35,00Cell Free + HCMEC D3_line
      4775       ECIS        1       no 35,00Cell Free + HCMEC D3_line
      4776       ECIS        1       no 35,00Cell Free + HCMEC D3_line
      4777       ECIS        1       no 35,00Cell Free + HCMEC D3_line
      4778       ECIS        1       no 35,00Cell Free + HCMEC D3_line
      4779       ECIS        1       no 35,00Cell Free + HCMEC D3_line
      4780       ECIS        1       no 35,00Cell Free + HCMEC D3_line
      4781       ECIS        1       no 35,00Cell Free + HCMEC D3_line
      4782       ECIS        1       no 35,00Cell Free + HCMEC D3_line
      4783       ECIS        1       no 35,00Cell Free + HCMEC D3_line
      4784       ECIS        1       no 35,00Cell Free + HCMEC D3_line
      4785       ECIS        1       no 35,00Cell Free + HCMEC D3_line
      4786       ECIS        1       no 35,00Cell Free + HCMEC D3_line
      4787       ECIS        1       no 35,00Cell Free + HCMEC D3_line
      4788       ECIS        1       no 35,00Cell Free + HCMEC D3_line
      4789       ECIS        1       no 35,00Cell Free + HCMEC D3_line
      4790       ECIS        1       no 35,00Cell Free + HCMEC D3_line
      4791       ECIS        1       no 35,00Cell Free + HCMEC D3_line
      4792       ECIS        1       no 35,00Cell Free + HCMEC D3_line
      4793       ECIS        1       no 35,00Cell Free + HCMEC D3_line
      4794       ECIS        1       no 35,00Cell Free + HCMEC D3_line
      4795       ECIS        1       no 35,00Cell Free + HCMEC D3_line
      4796       ECIS        1       no 35,00Cell Free + HCMEC D3_line
      4797       ECIS        1       no 35,00Cell Free + HCMEC D3_line
      4798       ECIS        1       no 35,00Cell Free + HCMEC D3_line
      4799       ECIS        1       no 35,00Cell Free + HCMEC D3_line
      4800       ECIS        1       no 35,00Cell Free + HCMEC D3_line
      4801       ECIS        1       no 35,00Cell Free + HCMEC D3_line
      4802       ECIS        1       no 35,00Cell Free + HCMEC D3_line
      4803       ECIS        1       no 35,00Cell Free + HCMEC D3_line
      4804       ECIS        1       no 35,00Cell Free + HCMEC D3_line
      4805       ECIS        1       no 35,00Cell Free + HCMEC D3_line
      4806       ECIS        1       no 35,00Cell Free + HCMEC D3_line
      4807       ECIS        1       no 35,00Cell Free + HCMEC D3_line
      4808       ECIS        1       no 35,00Cell Free + HCMEC D3_line
      4809       ECIS        1       no 35,00Cell Free + HCMEC D3_line
      4810       ECIS        1       no 35,00Cell Free + HCMEC D3_line
      4811       ECIS        1       no 35,00Cell Free + HCMEC D3_line
      4812       ECIS        1       no 35,00Cell Free + HCMEC D3_line
      4813       ECIS        1       no 35,00Cell Free + HCMEC D3_line
      4814       ECIS        1       no 35,00Cell Free + HCMEC D3_line
      4815       ECIS        1       no 35,00Cell Free + HCMEC D3_line
      4816       ECIS        1       no 35,00Cell Free + HCMEC D3_line
      4817       ECIS        1       no 35,00Cell Free + HCMEC D3_line
      4818       ECIS        1       no 35,00Cell Free + HCMEC D3_line
      4819       ECIS        1       no 35,00Cell Free + HCMEC D3_line
      4820       ECIS        1       no 35,00Cell Free + HCMEC D3_line
      4821       ECIS        1       no 35,00Cell Free + HCMEC D3_line
      4822       ECIS        1       no 35,00Cell Free + HCMEC D3_line
      4823       ECIS        1       no 35,00Cell Free + HCMEC D3_line
      4824       ECIS        1       no 35,00Cell Free + HCMEC D3_line
      4825       ECIS        1       no 35,00Cell Free + HCMEC D3_line
      4826       ECIS        1       no 35,00Cell Free + HCMEC D3_line
      4827       ECIS        1       no 35,00Cell Free + HCMEC D3_line
      4828       ECIS        1       no 35,00Cell Free + HCMEC D3_line
      4829       ECIS        1       no 35,00Cell Free + HCMEC D3_line
      4830       ECIS        1       no 35,00Cell Free + HCMEC D3_line
      4831       ECIS        1       no 35,00Cell Free + HCMEC D3_line
      4832       ECIS        1       no 35,00Cell Free + HCMEC D3_line
      4833       ECIS        1       no 35,00Cell Free + HCMEC D3_line
      4834       ECIS        1       no 35,00Cell Free + HCMEC D3_line
      4835       ECIS        1       no 35,00Cell Free + HCMEC D3_line
      4836       ECIS        1       no 35,00Cell Free + HCMEC D3_line
      4837       ECIS        1       no 35,00Cell Free + HCMEC D3_line
      4838       ECIS        1       no 35,00Cell Free + HCMEC D3_line
      4839       ECIS        1       no 35,00Cell Free + HCMEC D3_line
      4840       ECIS        1       no 35,00Cell Free + HCMEC D3_line
      4841       ECIS        1       no 35,00Cell Free + HCMEC D3_line
      4842       ECIS        1       no 35,00Cell Free + HCMEC D3_line
      4843       ECIS        1       no 35,00Cell Free + HCMEC D3_line
      4844       ECIS        1       no 35,00Cell Free + HCMEC D3_line
      4845       ECIS        1       no 35,00Cell Free + HCMEC D3_line
      4846       ECIS        1       no 35,00Cell Free + HCMEC D3_line
      4847       ECIS        1       no 35,00Cell Free + HCMEC D3_line
      4848       ECIS        1       no 35,00Cell Free + HCMEC D3_line
      4849       ECIS        1       no 35,00Cell Free + HCMEC D3_line
      4850       ECIS        1       no 35,00Cell Free + HCMEC D3_line
      4851       ECIS        1       no 35,00Cell Free + HCMEC D3_line
      4852       ECIS        1       no 35,00Cell Free + HCMEC D3_line
      4853       ECIS        1       no 35,00Cell Free + HCMEC D3_line
      4854       ECIS        1       no 35,00Cell Free + HCMEC D3_line
      4855       ECIS        1       no 35,00Cell Free + HCMEC D3_line
      4856       ECIS        1       no 35,00Cell Free + HCMEC D3_line
      4857       ECIS        1       no 35,00Cell Free + HCMEC D3_line
      4858       ECIS        1       no 35,00Cell Free + HCMEC D3_line
      4859       ECIS        1       no 35,00Cell Free + HCMEC D3_line
      4860       ECIS        1       no 35,00Cell Free + HCMEC D3_line
      4861       ECIS        1       no 35,00Cell Free + HCMEC D3_line
      4862       ECIS        1       no 35,00Cell Free + HCMEC D3_line
      4863       ECIS        1       no 35,00Cell Free + HCMEC D3_line
      4864       ECIS        1       no 35,00Cell Free + HCMEC D3_line
      4865       ECIS        1       no 35,00Cell Free + HCMEC D3_line
      4866       ECIS        1       no 35,00Cell Free + HCMEC D3_line
      4867       ECIS        1       no 35,00Cell Free + HCMEC D3_line
      4868       ECIS        1       no 35,00Cell Free + HCMEC D3_line
      4869       ECIS        1       no 35,00Cell Free + HCMEC D3_line
      4870       ECIS        1       no 35,00Cell Free + HCMEC D3_line
      4871       ECIS        1       no 35,00Cell Free + HCMEC D3_line
      4872       ECIS        1       no 35,00Cell Free + HCMEC D3_line
      4873       ECIS        1       no 35,00Cell Free + HCMEC D3_line
      4874       ECIS        1       no 35,00Cell Free + HCMEC D3_line
      4875       ECIS        1       no 35,00Cell Free + HCMEC D3_line
      4876       ECIS        1       no 35,00Cell Free + HCMEC D3_line
      4877       ECIS        1       no 35,00Cell Free + HCMEC D3_line
      4878       ECIS        1       no 35,00Cell Free + HCMEC D3_line
      4879       ECIS        1       no 35,00Cell Free + HCMEC D3_line
      4880       ECIS        1       no 35,00Cell Free + HCMEC D3_line
      4881       ECIS        1       no 35,00Cell Free + HCMEC D3_line
      4882       ECIS        1       no 35,00Cell Free + HCMEC D3_line
      4883       ECIS        1       no 35,00Cell Free + HCMEC D3_line
      4884       ECIS        1       no 35,00Cell Free + HCMEC D3_line
      4885       ECIS        1       no 35,00Cell Free + HCMEC D3_line
      4886       ECIS        1       no 35,00Cell Free + HCMEC D3_line
      4887       ECIS        1       no 35,00Cell Free + HCMEC D3_line
      4888       ECIS        1       no 35,00Cell Free + HCMEC D3_line
      4889       ECIS        1       no 35,00Cell Free + HCMEC D3_line
      4890       ECIS        1       no 35,00Cell Free + HCMEC D3_line
      4891       ECIS        1       no 35,00Cell Free + HCMEC D3_line
      4892       ECIS        1       no 35,00Cell Free + HCMEC D3_line
      4893       ECIS        1       no 35,00Cell Free + HCMEC D3_line
      4894       ECIS        1       no 35,00Cell Free + HCMEC D3_line
      4895       ECIS        1       no 35,00Cell Free + HCMEC D3_line
      4896       ECIS        1       no 35,00Cell Free + HCMEC D3_line
      4897       ECIS        1       no 35,00Cell Free + HCMEC D3_line
      4898       ECIS        1       no 35,00Cell Free + HCMEC D3_line
      4899       ECIS        1       no 35,00Cell Free + HCMEC D3_line
      4900       ECIS        1       no 35,00Cell Free + HCMEC D3_line
      4901       ECIS        1       no 35,00Cell Free + HCMEC D3_line
      4902       ECIS        1       no 35,00Cell Free + HCMEC D3_line
      4903       ECIS        1       no 35,00Cell Free + HCMEC D3_line
      4904       ECIS        1       no 35,00Cell Free + HCMEC D3_line
      4905       ECIS        1       no 35,00Cell Free + HCMEC D3_line
      4906       ECIS        1       no 35,00Cell Free + HCMEC D3_line
      4907       ECIS        1       no 35,00Cell Free + HCMEC D3_line
      4908       ECIS        1       no 35,00Cell Free + HCMEC D3_line
      4909       ECIS        1       no 35,00Cell Free + HCMEC D3_line
      4910       ECIS        1       no 35,00Cell Free + HCMEC D3_line
      4911       ECIS        1       no 35,00Cell Free + HCMEC D3_line
      4912       ECIS        1       no 35,00Cell Free + HCMEC D3_line
      4913       ECIS        1       no 35,00Cell Free + HCMEC D3_line
      4914       ECIS        1       no 35,00Cell Free + HCMEC D3_line
      4915       ECIS        1       no 35,00Cell Free + HCMEC D3_line
      4916       ECIS        1       no 35,00Cell Free + HCMEC D3_line
      4917       ECIS        1       no 35,00Cell Free + HCMEC D3_line
      4918       ECIS        1       no 35,00Cell Free + HCMEC D3_line
      4919       ECIS        1       no 35,00Cell Free + HCMEC D3_line
      4920       ECIS        1       no 35,00Cell Free + HCMEC D3_line
      4921       ECIS        1       no 35,00Cell Free + HCMEC D3_line
      4922       ECIS        1       no 35,00Cell Free + HCMEC D3_line
      4923       ECIS        1       no 35,00Cell Free + HCMEC D3_line
      4924       ECIS        1       no 35,00Cell Free + HCMEC D3_line
      4925       ECIS        1       no 35,00Cell Free + HCMEC D3_line
      4926       ECIS        1       no 35,00Cell Free + HCMEC D3_line
      4927       ECIS        1       no 35,00Cell Free + HCMEC D3_line
      4928       ECIS        1       no 35,00Cell Free + HCMEC D3_line
      4929       ECIS        1       no 35,00Cell Free + HCMEC D3_line
      4930       ECIS        1       no 35,00Cell Free + HCMEC D3_line
      4931       ECIS        1       no 35,00Cell Free + HCMEC D3_line
      4932       ECIS        1       no 35,00Cell Free + HCMEC D3_line
      4933       ECIS        1       no 35,00Cell Free + HCMEC D3_line
      4934       ECIS        1       no 35,00Cell Free + HCMEC D3_line
      4935       ECIS        1       no 35,00Cell Free + HCMEC D3_line
      4936       ECIS        1       no 35,00Cell Free + HCMEC D3_line
      4937       ECIS        1       no 35,00Cell Free + HCMEC D3_line
      4938       ECIS        1       no 35,00Cell Free + HCMEC D3_line
      4939       ECIS        1       no 35,00Cell Free + HCMEC D3_line
      4940       ECIS        1       no 35,00Cell Free + HCMEC D3_line
      4941       ECIS        1       no 35,00Cell Free + HCMEC D3_line
      4942       ECIS        1       no 35,00Cell Free + HCMEC D3_line
      4943       ECIS        1       no 35,00Cell Free + HCMEC D3_line
      4944       ECIS        1       no 35,00Cell Free + HCMEC D3_line
      4945       ECIS        1       no 35,00Cell Free + HCMEC D3_line
      4946       ECIS        1       no 35,00Cell Free + HCMEC D3_line
      4947       ECIS        1       no 35,00Cell Free + HCMEC D3_line
      4948       ECIS        1       no 35,00Cell Free + HCMEC D3_line
      4949       ECIS        1       no 35,00Cell Free + HCMEC D3_line
      4950       ECIS        1       no 35,00Cell Free + HCMEC D3_line
      4951       ECIS        1       no 35,00Cell Free + HCMEC D3_line
      4952       ECIS        1       no 35,00Cell Free + HCMEC D3_line
      4953       ECIS        1       no 35,00Cell Free + HCMEC D3_line
      4954       ECIS        1       no 35,00Cell Free + HCMEC D3_line
      4955       ECIS        1       no 35,00Cell Free + HCMEC D3_line
      4956       ECIS        1       no 35,00Cell Free + HCMEC D3_line
      4957       ECIS        1       no 35,00Cell Free + HCMEC D3_line
      4958       ECIS        1       no 35,00Cell Free + HCMEC D3_line
      4959       ECIS        1       no 35,00Cell Free + HCMEC D3_line
      4960       ECIS        1       no 35,00Cell Free + HCMEC D3_line
      4961       ECIS        1       no 35,00Cell Free + HCMEC D3_line
      4962       ECIS        1       no 35,00Cell Free + HCMEC D3_line
      4963       ECIS        1       no 35,00Cell Free + HCMEC D3_line
      4964       ECIS        1       no 35,00Cell Free + HCMEC D3_line
      4965       ECIS        1       no 35,00Cell Free + HCMEC D3_line
      4966       ECIS        1       no 35,00Cell Free + HCMEC D3_line
      4967       ECIS        1       no 35,00Cell Free + HCMEC D3_line
      4968       ECIS        1       no 35,00Cell Free + HCMEC D3_line
      4969       ECIS        1       no 35,00Cell Free + HCMEC D3_line
      4970       ECIS        1       no 35,00Cell Free + HCMEC D3_line
      4971       ECIS        1       no 35,00Cell Free + HCMEC D3_line
      4972       ECIS        1       no 35,00Cell Free + HCMEC D3_line
      4973       ECIS        1       no 35,00Cell Free + HCMEC D3_line
      4974       ECIS        1       no 35,00Cell Free + HCMEC D3_line
      4975       ECIS        1       no 35,00Cell Free + HCMEC D3_line
      4976       ECIS        1       no 35,00Cell Free + HCMEC D3_line
      4977       ECIS        1       no 35,00Cell Free + HCMEC D3_line
      4978       ECIS        1       no 35,00Cell Free + HCMEC D3_line
      4979       ECIS        1       no 35,00Cell Free + HCMEC D3_line
      4980       ECIS        1       no 35,00Cell Free + HCMEC D3_line
      4981       ECIS        1       no 35,00Cell Free + HCMEC D3_line
      4982       ECIS        1       no 35,00Cell Free + HCMEC D3_line
      4983       ECIS        1       no 35,00Cell Free + HCMEC D3_line
      4984       ECIS        1       no 35,00Cell Free + HCMEC D3_line
      4985       ECIS        1       no 35,00Cell Free + HCMEC D3_line
      4986       ECIS        1       no 35,00Cell Free + HCMEC D3_line
      4987       ECIS        1       no 35,00Cell Free + HCMEC D3_line
      4988       ECIS        1       no 35,00Cell Free + HCMEC D3_line
      4989       ECIS        1       no 35,00Cell Free + HCMEC D3_line
      4990       ECIS        1       no 35,00Cell Free + HCMEC D3_line
      4991       ECIS        1       no 35,00Cell Free + HCMEC D3_line
      4992       ECIS        1       no 35,00Cell Free + HCMEC D3_line
      4993       ECIS        1       no 35,00Cell Free + HCMEC D3_line
      4994       ECIS        1       no 35,00Cell Free + HCMEC D3_line
      4995       ECIS        1       no 35,00Cell Free + HCMEC D3_line
      4996       ECIS        1       no 35,00Cell Free + HCMEC D3_line
      4997       ECIS        1       no 35,00Cell Free + HCMEC D3_line
      4998       ECIS        1       no 35,00Cell Free + HCMEC D3_line
      4999       ECIS        1       no 35,00Cell Free + HCMEC D3_line
      5000       ECIS        1       no 35,00Cell Free + HCMEC D3_line
      5001       ECIS        1       no 35,00Cell Free + HCMEC D3_line
      5002       ECIS        1       no 35,00Cell Free + HCMEC D3_line
      5003       ECIS        1       no 35,00Cell Free + HCMEC D3_line
      5004       ECIS        1       no 35,00Cell Free + HCMEC D3_line
      5005       ECIS        1       no 35,00Cell Free + HCMEC D3_line
      5006       ECIS        1       no 35,00Cell Free + HCMEC D3_line
      5007       ECIS        1       no 35,00Cell Free + HCMEC D3_line
      5008       ECIS        1       no 35,00Cell Free + HCMEC D3_line
      5009       ECIS        1       no 35,00Cell Free + HCMEC D3_line
      5010       ECIS        1       no 35,00Cell Free + HCMEC D3_line
      5011       ECIS        1       no 35,00Cell Free + HCMEC D3_line
      5012       ECIS        1       no 35,00Cell Free + HCMEC D3_line
      5013       ECIS        1       no 35,00Cell Free + HCMEC D3_line
      5014       ECIS        1       no 35,00Cell Free + HCMEC D3_line
      5015       ECIS        1       no 35,00Cell Free + HCMEC D3_line
      5016       ECIS        1       no 35,00Cell Free + HCMEC D3_line
      5017       ECIS        1       no 35,00Cell Free + HCMEC D3_line
      5018       ECIS        1       no 35,00Cell Free + HCMEC D3_line
      5019       ECIS        1       no 35,00Cell Free + HCMEC D3_line
      5020       ECIS        1       no 35,00Cell Free + HCMEC D3_line
      5021       ECIS        1       no 35,00Cell Free + HCMEC D3_line
      5022       ECIS        1       no 35,00Cell Free + HCMEC D3_line
      5023       ECIS        1       no 35,00Cell Free + HCMEC D3_line
      5024       ECIS        1       no 35,00Cell Free + HCMEC D3_line
      5025       ECIS        1       no 35,00Cell Free + HCMEC D3_line
      5026       ECIS        1       no 35,00Cell Free + HCMEC D3_line
      5027       ECIS        1       no 35,00Cell Free + HCMEC D3_line
      5028       ECIS        1       no 35,00Cell Free + HCMEC D3_line
      5029       ECIS        1       no 35,00Cell Free + HCMEC D3_line
      5030       ECIS        1       no 35,00Cell Free + HCMEC D3_line
      5031       ECIS        1       no 35,00Cell Free + HCMEC D3_line
      5032       ECIS        1       no 35,00Cell Free + HCMEC D3_line
      5033       ECIS        1       no 35,00Cell Free + HCMEC D3_line
      5034       ECIS        1       no 35,00Cell Free + HCMEC D3_line
      5035       ECIS        1       no 35,00Cell Free + HCMEC D3_line
      5036       ECIS        1       no 35,00Cell Free + HCMEC D3_line
      5037       ECIS        1       no 35,00Cell Free + HCMEC D3_line
      5038       ECIS        1       no 35,00Cell Free + HCMEC D3_line
      5039       ECIS        1       no 35,00Cell Free + HCMEC D3_line
      5040       ECIS        1       no 35,00Cell Free + HCMEC D3_line
      5041       ECIS        1       no 35,00Cell Free + HCMEC D3_line
      5042       ECIS        1       no 35,00Cell Free + HCMEC D3_line
      5043       ECIS        1       no 35,00Cell Free + HCMEC D3_line
      5044       ECIS        1       no 35,00Cell Free + HCMEC D3_line
      5045       ECIS        1       no 35,00Cell Free + HCMEC D3_line
      5046       ECIS        1       no 35,00Cell Free + HCMEC D3_line
      5047       ECIS        1       no 35,00Cell Free + HCMEC D3_line
      5048       ECIS        1       no 35,00Cell Free + HCMEC D3_line
      5049       ECIS        1       no 35,00Cell Free + HCMEC D3_line
      5050       ECIS        1       no 35,00Cell Free + HCMEC D3_line
      5051       ECIS        1       no 35,00Cell Free + HCMEC D3_line
      5052       ECIS        1       no 35,00Cell Free + HCMEC D3_line
      5053       ECIS        1       no 35,00Cell Free + HCMEC D3_line
      5054       ECIS        1       no 35,00Cell Free + HCMEC D3_line
      5055       ECIS        1       no 35,00Cell Free + HCMEC D3_line
      5056       ECIS        1       no 35,00Cell Free + HCMEC D3_line
      5057       ECIS        1       no 35,00Cell Free + HCMEC D3_line
      5058       ECIS        1       no 35,00Cell Free + HCMEC D3_line
      5059       ECIS        1       no 35,00Cell Free + HCMEC D3_line
      5060       ECIS        1       no 35,00Cell Free + HCMEC D3_line
      5061       ECIS        1       no 35,00Cell Free + HCMEC D3_line
      5062       ECIS        1       no 35,00Cell Free + HCMEC D3_line
      5063       ECIS        1       no 35,00Cell Free + HCMEC D3_line
      5064       ECIS        1       no 35,00Cell Free + HCMEC D3_line
      5065       ECIS        1       no 35,00Cell Free + HCMEC D3_line
      5066       ECIS        1       no 35,00Cell Free + HCMEC D3_line
      5067       ECIS        1       no 35,00Cell Free + HCMEC D3_line
      5068       ECIS        1       no 35,00Cell Free + HCMEC D3_line
      5069       ECIS        1       no 35,00Cell Free + HCMEC D3_line
      5070       ECIS        1       no 35,00Cell Free + HCMEC D3_line
      5071       ECIS        1       no 35,00Cell Free + HCMEC D3_line
      5072       ECIS        1       no 35,00Cell Free + HCMEC D3_line
      5073       ECIS        1       no 35,00Cell Free + HCMEC D3_line
      5074       ECIS        1       no 35,00Cell Free + HCMEC D3_line
      5075       ECIS        1       no 35,00Cell Free + HCMEC D3_line
      5076       ECIS        1       no 35,00Cell Free + HCMEC D3_line
      5077       ECIS        1       no 35,00Cell Free + HCMEC D3_line
      5078       ECIS        1       no 35,00Cell Free + HCMEC D3_line
      5079       ECIS        1       no 35,00Cell Free + HCMEC D3_line
      5080       ECIS        1       no 35,00Cell Free + HCMEC D3_line
      5081       ECIS        1       no 35,00Cell Free + HCMEC D3_line
      5082       ECIS        1       no 35,00Cell Free + HCMEC D3_line
      5083       ECIS        1       no 35,00Cell Free + HCMEC D3_line
      5084       ECIS        1       no 35,00Cell Free + HCMEC D3_line
      5085       ECIS        1       no 35,00Cell Free + HCMEC D3_line
      5086       ECIS        1       no 35,00Cell Free + HCMEC D3_line
      5087       ECIS        1       no 35,00Cell Free + HCMEC D3_line
      5088       ECIS        1       no 35,00Cell Free + HCMEC D3_line
      5089       ECIS        1       no 35,00Cell Free + HCMEC D3_line
      5090       ECIS        1       no 35,00Cell Free + HCMEC D3_line
      5091       ECIS        1       no 35,00Cell Free + HCMEC D3_line
      5092       ECIS        1       no 35,00Cell Free + HCMEC D3_line
      5093       ECIS        1       no 35,00Cell Free + HCMEC D3_line
      5094       ECIS        1       no 35,00Cell Free + HCMEC D3_line
      5095       ECIS        1       no 35,00Cell Free + HCMEC D3_line
      5096       ECIS        1       no 35,00Cell Free + HCMEC D3_line
      5097       ECIS        1       no 35,00Cell Free + HCMEC D3_line
      5098       ECIS        1       no 35,00Cell Free + HCMEC D3_line
      5099       ECIS        1       no 35,00Cell Free + HCMEC D3_line
      5100       ECIS        1       no 35,00Cell Free + HCMEC D3_line
      5101       ECIS        1       no 35,00Cell Free + HCMEC D3_line
      5102       ECIS        1       no 35,00Cell Free + HCMEC D3_line
      5103       ECIS        1       no 35,00Cell Free + HCMEC D3_line
      5104       ECIS        1       no 35,00Cell Free + HCMEC D3_line
      5105       ECIS        1       no 35,00Cell Free + HCMEC D3_line
      5106       ECIS        1       no 35,00Cell Free + HCMEC D3_line
      5107       ECIS        1       no 35,00Cell Free + HCMEC D3_line
      5108       ECIS        1       no 35,00Cell Free + HCMEC D3_line
      5109       ECIS        1       no 35,00Cell Free + HCMEC D3_line
      5110       ECIS        1       no 35,00Cell Free + HCMEC D3_line
      5111       ECIS        1       no 35,00Cell Free + HCMEC D3_line
      5112       ECIS        1       no 35,00Cell Free + HCMEC D3_line
      5113       ECIS        1       no 35,00Cell Free + HCMEC D3_line
      5114       ECIS        1       no 35,00Cell Free + HCMEC D3_line
      5115       ECIS        1       no 35,00Cell Free + HCMEC D3_line
      5116       ECIS        1       no 35,00Cell Free + HCMEC D3_line
      5117       ECIS        1       no 35,00Cell Free + HCMEC D3_line
      5118       ECIS        1       no 35,00Cell Free + HCMEC D3_line
      5119       ECIS        1       no 35,00Cell Free + HCMEC D3_line
      5120       ECIS        1       no 35,00Cell Free + HCMEC D3_line
      5121       ECIS        1       no 35,00Cell Free + HCMEC D3_line
      5122       ECIS        1       no 35,00Cell Free + HCMEC D3_line
      5123       ECIS        1       no 35,00Cell Free + HCMEC D3_line
      5124       ECIS        1       no 35,00Cell Free + HCMEC D3_line
      5125       ECIS        1       no 35,00Cell Free + HCMEC D3_line
      5126       ECIS        1       no 35,00Cell Free + HCMEC D3_line
      5127       ECIS        1       no 35,00Cell Free + HCMEC D3_line
      5128       ECIS        1       no 35,00Cell Free + HCMEC D3_line
      5129       ECIS        1       no 35,00Cell Free + HCMEC D3_line
      5130       ECIS        1       no 35,00Cell Free + HCMEC D3_line
      5131       ECIS        1       no 35,00Cell Free + HCMEC D3_line
      5132       ECIS        1       no 35,00Cell Free + HCMEC D3_line
      5133       ECIS        1       no 35,00Cell Free + HCMEC D3_line
      5134       ECIS        1       no 35,00Cell Free + HCMEC D3_line
      5135       ECIS        1       no 35,00Cell Free + HCMEC D3_line
      5136       ECIS        1       no 35,00Cell Free + HCMEC D3_line
      5137       ECIS        1       no 35,00Cell Free + HCMEC D3_line
      5138       ECIS        1       no 35,00Cell Free + HCMEC D3_line
      5139       ECIS        1       no 35,00Cell Free + HCMEC D3_line
      5140       ECIS        1       no 35,00Cell Free + HCMEC D3_line
      5141       ECIS        1       no 35,00Cell Free + HCMEC D3_line
      5142       ECIS        1       no 35,00Cell Free + HCMEC D3_line
      5143       ECIS        1       no 35,00Cell Free + HCMEC D3_line
      5144       ECIS        1       no 35,00Cell Free + HCMEC D3_line
      5145       ECIS        1       no 35,00Cell Free + HCMEC D3_line
      5146       ECIS        1       no 35,00Cell Free + HCMEC D3_li