% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/type.R
\name{vec_ptype}
\alias{vec_ptype}
\alias{vec_ptype_common}
\alias{vec_ptype_show}
\title{Find the prototype of a set of vectors}
\usage{
vec_ptype(x, ..., x_arg = "", call = caller_env())

vec_ptype_common(
  ...,
  .ptype = NULL,
  .finalise = TRUE,
  .arg = "",
  .call = caller_env()
)

vec_ptype_show(...)
}
\arguments{
\item{x}{A vector}

\item{...}{For \code{vec_ptype()}, these dots are for future extensions and must
be empty.

For \code{vec_ptype_common()} and \code{vec_ptype_show()}, vector inputs.}

\item{x_arg}{Argument name for \code{x}. This is used in error messages to inform
the user about the locations of incompatible types.}

\item{call, .call}{The execution environment of a currently
running function, e.g. \code{caller_env()}. The function will be
mentioned in error messages as the source of the error. See the
\code{call} argument of \code{\link[rlang:abort]{abort()}} for more information.}

\item{.ptype}{If \code{NULL}, the default, the output type is determined by
computing the common type across all elements of \code{...}.

Alternatively, you can supply \code{.ptype} to give the output known type.
If \code{getOption("vctrs.no_guessing")} is \code{TRUE} you must supply this value:
this is a convenient way to make production code demand fixed types.}

\item{.finalise}{Should \code{vec_ptype_common()} \link[=vec_ptype_finalise]{finalise}
its output?
\itemize{
\item If \code{TRUE}, \code{\link[=vec_ptype_finalise]{vec_ptype_finalise()}} is called on the final \code{ptype} before
it is returned. Practically this has the effect of converting any
types from \link{unspecified} to logical.
\item If \code{FALSE}, \link{unspecified} types are left unfinalised, which can be useful
for advanced cases where you combine one common type result with another
type via \code{\link[=vec_ptype2]{vec_ptype2()}}. Note that you must manually call
\code{\link[=vec_ptype_finalise]{vec_ptype_finalise()}} on the final \code{ptype} before supplying it to any
other vctrs functions.
}}

\item{.arg}{An argument name as a string. This argument
will be mentioned in error messages as the input that is at the
origin of a problem.}
}
\value{
\code{vec_ptype()} and \code{vec_ptype_common()} return a prototype
(a size-0 vector).
}
\description{
\itemize{
\item \code{vec_ptype()} returns the \link[=vec_ptype_finalise]{unfinalised} prototype of a
single vector.
\item \code{vec_ptype_common()} returns the common type of multiple vectors. By
default, this is \link[=vec_ptype_finalise]{finalised} for immediate usage, but
can optionally be left unfinalised for advanced common type determination.
\item \code{vec_ptype_show()} nicely prints the common type of any number of inputs,
and is designed for interactive exploration.
}
}
\section{\code{vec_ptype()}}{


\code{vec_ptype()} returns \link[=vec_size]{size} 0 vectors potentially
containing attributes but no data. Generally, this is just
\code{vec_slice(x, 0L)}, but some inputs require special
handling.
\itemize{
\item While you can't slice \code{NULL}, the prototype of \code{NULL} is
itself. This is because we treat \code{NULL} as an identity value in
the \code{vec_ptype2()} monoid.
\item The prototype of logical vectors that only contain missing values
is the special \link{unspecified} type, which can be coerced to any
other 1d type. This allows bare \code{NA}s to represent missing values
for any 1d vector type. \link[=vec_ptype_finalise]{Finalising} this type
converts it from unspecified back to logical.
}

See \link{internal-faq-ptype2-identity} for more information about
identity values.

\code{vec_ptype()} is a \emph{performance} generic. It is not necessary to implement it
because the default method will work for any vctrs type. However the default
method builds around other vctrs primitives like \code{vec_slice()} which incurs
performance costs. If your class has a static prototype, you might consider
implementing a custom \code{vec_ptype()} method that returns a constant. This will
improve the performance of your class in many cases (\link[=vec_ptype2]{common type} imputation in particular).

Because it may contain unspecified vectors, the prototype returned by
\code{vec_ptype()} is said to be \strong{unfinalised}. Call \code{\link[=vec_ptype_finalise]{vec_ptype_finalise()}} to
finalise it.
}

\section{\code{vec_ptype_common()}}{


\code{vec_ptype_common()} first finds the prototype of each input, then
successively calls \code{\link[=vec_ptype2]{vec_ptype2()}} to find a common type. It returns a
\link[=vec_ptype_finalise]{finalised} prototype by default, but can optionally be
left unfinalised for advanced common type determination.
}

\section{Dependencies of \code{vec_ptype()}}{

\itemize{
\item \code{\link[=vec_slice]{vec_slice()}} for returning an empty slice
}
}

\section{Dependencies of \code{vec_ptype_common()}}{

\itemize{
\item \code{\link[=vec_ptype2]{vec_ptype2()}}
\item \code{\link[=vec_ptype_finalise]{vec_ptype_finalise()}}
}
}

\examples{
# Unknown types ------------------------------------------
vec_ptype_show()
vec_ptype_show(NULL)

# Vectors ------------------------------------------------
vec_ptype_show(1:10)
vec_ptype_show(letters)
vec_ptype_show(TRUE)

vec_ptype_show(Sys.Date())
vec_ptype_show(Sys.time())
vec_ptype_show(factor("a"))
vec_ptype_show(ordered("a"))

# Matrices -----------------------------------------------
# The prototype of a matrix includes the number of columns
vec_ptype_show(array(1, dim = c(1, 2)))
vec_ptype_show(array("x", dim = c(1, 2)))

# Data frames --------------------------------------------
# The prototype of a data frame includes the prototype of
# every column
vec_ptype_show(iris)

# The prototype of multiple data frames includes the prototype
# of every column that in any data frame
vec_ptype_show(
  data.frame(x = TRUE),
  data.frame(y = 2),
  data.frame(z = "a")
)

# Finalisation -------------------------------------------

# `vec_ptype()` and `vec_ptype2()` return unfinalised ptypes so that they
# can be coerced to any other type
vec_ptype(NA)
vec_ptype2(NA, NA)

# By default `vec_ptype_common()` finalises so that you can use its result
# directly in other vctrs functions
vec_ptype_common(NA, NA)

# You can opt out of finalisation to make it work like `vec_ptype()` and
# `vec_ptype2()` with `.finalise = FALSE`, but don't forget that you must
# call `vec_ptype_finalise()` manually if you do so!
vec_ptype_common(NA, NA, .finalise = FALSE)
vec_ptype_finalise(vec_ptype_common(NA, NA, .finalise = FALSE))

# This can be useful in rare scenarios, like including a separate `default`
# argument in the ptype computation
xs <- list(NA, NA)
default <- "a"
try(vec_ptype2(vec_ptype_common(!!!xs), default))
vec_ptype2(vec_ptype_common(!!!xs, .finalise = FALSE), default)
}
