% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_vpc.R
\name{plot_vpc_helper}
\alias{plot_vpc_helper}
\alias{plot_vpc_helper.default}
\alias{plot_vpc_helper.vpcdb_continuous}
\alias{plot_vpc_helper.vpcdb_categorical}
\alias{plot_vpc_helper.vpcdb_censored}
\alias{plot_vpc_helper.vpcdb_time_to_event}
\title{Helper function to simplify vpc plotting (not intended to be called directly)}
\usage{
plot_vpc_helper(
  db,
  show = NULL,
  vpc_theme = NULL,
  smooth = TRUE,
  log_x = FALSE,
  log_y = FALSE,
  xlab = NULL,
  ylab = NULL,
  title = NULL,
  verbose = FALSE
)

\method{plot_vpc_helper}{default}(db, ...)

\method{plot_vpc_helper}{vpcdb_continuous}(
  db,
  ...,
  show = NULL,
  vpc_theme = NULL,
  smooth = TRUE,
  log_x = FALSE,
  log_y = FALSE,
  xlab = NULL,
  ylab = NULL,
  title = NULL,
  verbose = FALSE
)

\method{plot_vpc_helper}{vpcdb_categorical}(db, ...)

\method{plot_vpc_helper}{vpcdb_censored}(db, ...)

\method{plot_vpc_helper}{vpcdb_time_to_event}(
  db,
  ...,
  show = NULL,
  vpc_theme = NULL,
  smooth = TRUE,
  log_x = FALSE,
  log_y = FALSE,
  xlab = NULL,
  ylab = NULL,
  title = NULL,
  verbose = FALSE
)
}
\arguments{
\item{db}{object created using the `vpc` function}

\item{show}{what to show in VPC (obs_dv, obs_ci, pi, pi_as_area, pi_ci, obs_median, sim_median, sim_median_ci)}

\item{vpc_theme}{theme to be used in VPC. Expects list of class vpc_theme created with function vpc_theme()}

\item{smooth}{"smooth" the VPC (connect bin midpoints) or show bins as rectangular boxes. Default is TRUE.}

\item{log_x}{Boolean indicting whether x-axis should be shown as logarithmic. Default is FALSE.}

\item{log_y}{Boolean indicting whether y-axis should be shown as logarithmic. Default is FALSE.}

\item{xlab}{label for x axis}

\item{ylab}{label for y axis}

\item{title}{title}

\item{verbose}{show debugging information (TRUE or FALSE)}
}
\description{
Helper function to simplify vpc plotting (not intended to be called directly)
}
\keyword{internal}
