% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/vpc_cens.R
\name{vpc_cens}
\alias{vpc_cens}
\title{VPC function for left- or right-censored data (e.g. BLOQ data)}
\usage{
vpc_cens(
  sim = NULL,
  obs = NULL,
  psn_folder = NULL,
  bins = "jenks",
  n_bins = 8,
  bin_mid = "mean",
  obs_cols = NULL,
  sim_cols = NULL,
  software = "auto",
  show = NULL,
  stratify = NULL,
  stratify_color = NULL,
  ci = c(0.05, 0.95),
  uloq = NULL,
  lloq = NULL,
  xlab = "Time",
  ylab = "Probability of <LOQ",
  title = NULL,
  smooth = TRUE,
  vpc_theme = NULL,
  facet = "wrap",
  labeller = NULL,
  vpcdb = FALSE,
  verbose = FALSE
)
}
\arguments{
\item{sim}{this is usually a data.frame with observed data, containing the independent and dependent variable, a column indicating the individual, and possibly covariates. E.g. load in from NONMEM using \link{read_table_nm}.  However it can also be an object like a nlmixr or xpose object}

\item{obs}{a data.frame with observed data, containing the independent and dependent variable, a column indicating the individual, and possibly covariates. E.g. load in from NONMEM using \link{read_table_nm}}

\item{psn_folder}{instead of specifying "sim" and "obs", specify a PsN-generated VPC-folder}

\item{bins}{either "density", "time", or "data", "none", or one of the
approaches available in classInterval() such as "jenks" (default) or
"pretty", or a numeric vector specifying the bin separators.}

\item{n_bins}{when using the "auto" binning method, what number of bins to
aim for}

\item{bin_mid}{either "mean" for the mean of all timepoints (default) or "middle" to use the average of the bin boundaries.}

\item{obs_cols}{list for mapping observation data columns, e.g. `list(dv = "DV", id = "ID", idv = "TIME", pred="PRED")`}

\item{sim_cols}{list for mapping simulation data columns, e.g. `list(dv = "DV", id = "ID", idv = "TIME", pred="PRED")`}

\item{software}{name of software platform using (e.g. nonmem, phoenix)}

\item{show}{what to show in VPC (obs_dv, obs_ci, pi, pi_as_area, pi_ci, obs_median, sim_median, sim_median_ci)}

\item{stratify}{character vector of stratification variables. Only 1 or 2 stratification variables can be supplied.}

\item{stratify_color}{variable to stratify and color lines for observed data. Only 1 stratification variables can be supplied.}

\item{ci}{confidence interval to plot. Default is (0.05, 0.95)}

\item{uloq}{Number or NULL indicating upper limit of quantification. Default is NULL.}

\item{lloq}{Number or NULL indicating lower limit of quantification. Default is NULL.}

\item{xlab}{label for x axis}

\item{ylab}{label for y axis}

\item{title}{title}

\item{smooth}{"smooth" the VPC (connect bin midpoints) or show bins as rectangular boxes. Default is TRUE.}

\item{vpc_theme}{theme to be used in VPC. Expects list of class vpc_theme created with function vpc_theme()}

\item{facet}{either "wrap", "columns", or "rows"}

\item{labeller}{ggplot2 labeller function to be passed to underlying ggplot object}

\item{vpcdb}{boolean whether to return the underlying vpcdb rather than the plot}

\item{verbose}{show debugging information (TRUE or FALSE)}
}
\value{
a list containing calculated VPC information (when vpcdb=TRUE), or a ggplot2 object (default)
}
\description{
Creates a VPC plot from observed and simulation data for censored data. Function can handle both left- (below lower limit of quantification) and right-censored (above upper limit of quantification) data.
}
\examples{

## See vpc.ronkeizer.com for more documentation and examples
library(vpc)

vpc_cens(sim = simple_data$sim, obs = simple_data$obs, lloq = 30)
vpc_cens(sim = simple_data$sim, obs = simple_data$obs, uloq = 120)

}
\seealso{
\link{vpc}, \link{vpc_tte}, \link{vpc_cat}
}
