% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_vpc.R
\name{vpc_ggplot}
\alias{vpc_ggplot}
\alias{geom_bin_sep}
\alias{geom_hline_loq}
\alias{geom_obs_cens_dat_tte}
\alias{geom_obs_ci_continuous}
\alias{geom_obs_ci_tte}
\alias{geom_obs_dv_continuous}
\alias{geom_obs_km}
\alias{geom_obs_median_continuous}
\alias{geom_sim_km}
\alias{geom_sim_median_continuous}
\alias{geom_sim_median_tte}
\alias{geom_sim_median_ci_continuous}
\alias{geom_sim_pi_as_area_continuous}
\alias{geom_sim_pi_as_area_tte}
\alias{geom_sim_pi_continuous}
\alias{geom_sim_pi_ci_continuous}
\alias{facet_continuous}
\alias{facet_tte}
\alias{guides_stratify_color}
\alias{scale_x_log10_vpc}
\alias{scale_y_log10_vpc}
\title{A collection of internal ggplot helpers for VPC plotting}
\usage{
geom_bin_sep(bins, show, vpc_theme)

geom_hline_loq(data, vpc_theme)

geom_obs_cens_dat_tte(data)

geom_obs_ci_continuous(data, show, vpc_theme)

geom_obs_ci_tte(data, show, vpc_theme)

geom_obs_dv_continuous(data, show, vpc_theme)

geom_obs_km(data)

geom_obs_median_continuous(data, show, vpc_theme)

geom_sim_km(data, show)

geom_sim_median_continuous(data, show, vpc_theme)

geom_sim_median_tte(data, show, smooth)

geom_sim_median_ci_continuous(data, show, smooth, vpc_theme)

geom_sim_pi_as_area_continuous(data, show, smooth, vpc_theme)

geom_sim_pi_as_area_tte(data, show, smooth, vpc_theme)

geom_sim_pi_continuous(data, show, vpc_theme)

geom_sim_pi_ci_continuous(data, show, smooth, vpc_theme, what = c("q5", "q95"))

facet_continuous(data)

facet_tte(data)

guides_stratify_color(data)

scale_x_log10_vpc(data, show)

scale_y_log10_vpc(show)
}
\arguments{
\item{bins}{Numeric vector of bin separators (if logical value, geom_blank is
returned)}

\item{show}{Should the geom be shown? (TRUE/FALSE)}

\item{vpc_theme}{The theme to use}

\item{data}{The vpcdb object}

\item{smooth}{"smooth" the VPC (connect bin midpoints) or show bins as rectangular boxes. Default is TRUE.}

\item{what}{Which interval should be shown (low = "q5" or high = "q95")}
}
\description{
A collection of internal ggplot helpers for VPC plotting
}
\section{Functions}{
\itemize{
\item \code{geom_bin_sep()}: Show rug plot of bin separators

\item \code{geom_hline_loq()}: Generate hlines for the lloq/uloq

\item \code{geom_obs_cens_dat_tte()}: Show the cens_dat for time-to-events

\item \code{geom_obs_ci_continuous()}: Show confidence interval for observed, continuous data

\item \code{geom_obs_ci_tte()}: Show confidence interval for observed, time-to-event
data

\item \code{geom_obs_dv_continuous()}: Show observed data points

\item \code{geom_obs_km()}: Show observed Kaplan-Meier line

\item \code{geom_obs_median_continuous()}: Show observed median line for continuous data

\item \code{geom_sim_km()}: Show simulated Kaplan-Meier curves for time-to-event
data

\item \code{geom_sim_median_continuous()}: Show simulated median line for continuous data

\item \code{geom_sim_median_tte()}: Show simulated median line (or steps) for
time-to-event data

\item \code{geom_sim_median_ci_continuous()}: Show simulated median confidence interval for
continuous data

\item \code{geom_sim_pi_as_area_continuous()}: Show simulated prediction interval area for continuous
data

\item \code{geom_sim_pi_as_area_tte()}: Show simulated prediction interval area for
time-to-event data

\item \code{geom_sim_pi_continuous()}: Show simulated prediction interval lines for
continuous data

\item \code{geom_sim_pi_ci_continuous()}: Show simulated prediction interval confidence interval
areas for continuous data

\item \code{facet_continuous()}: Facet continuous data by stratification factors

\item \code{facet_tte()}: Facet time-to-event data by stratification factors

\item \code{guides_stratify_color()}: Generate guides for stratification fill and colour

\item \code{scale_x_log10_vpc()}: Optionally show log-x scale

\item \code{scale_y_log10_vpc()}: Optionally show log-y scale

}}
