% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/datasets.R
\docType{data}
\name{cricket_batting}
\alias{cricket_batting}
\title{Cricket batting data for international test players}
\format{
A data frame with 3968 rows and 15 variables:
\describe{
\item{Player}{Player name in form of "initials surname"}
\item{Country}{Country played for}
\item{Start}{First year of test playing career}
\item{End}{Last year of test playing career}
\item{Matches}{Number of matches played}
\item{Innings}{Number of innings batted}
\item{NotOuts}{Number of times not out}
\item{Runs}{Total runs scored}
\item{HighScore}{Highest score in an innings}
\item{HighScoreNotOut}{Was highest score not out?}
\item{Average}{Batting average at end of career}
\item{Hundreds}{Total number of 100s scored}
\item{Fifties}{Total number of 50s scored}
\item{Ducks}{Total number of 0s scored}
\item{Gender}{"Men" or "Women"}
}
}
\source{
\url{https://www.espncricinfo.com/}
}
\usage{
cricket_batting
}
\value{
Data frame
}
\description{
A dataset containing career batting statistics for all international test
players (men and women) up to 6 October 2025.
}
\examples{
cricket_batting |>
  filter(Innings > 20) |>
  select(Player, Country, Matches, Runs, Average, Hundreds, Fifties, Ducks) |>
  arrange(desc(Average))
}
\references{
Rob J Hyndman (2026) "That's weird: Anomaly detection using R", Section 1.4,
\url{https://OTexts.com/weird/}.
}
\keyword{datasets}
