% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/hdr.R
\name{hdr_table}
\alias{hdr_table}
\title{Table of Highest Density Regions}
\usage{
hdr_table(object, prob)
}
\arguments{
\item{object}{Distributional object such as that returned by \code{dist_kde()}}

\item{prob}{Vector of probabilities giving the HDR coverage (between 0 and 1)}
}
\value{
A tibble
}
\description{
Compute a table of highest density regions (HDR) for a distributional object.
The HDRs are returned as a tibble with one row per interval and columns:
\code{prob} (giving the probability coverage),
\code{density} (the value of the density at the boundary of the HDR),
For one dimensional density functions, the tibble also has columns
\code{lower} (the lower ends of the intervals), and
\code{upper} (the upper ends of the intervals).
}
\examples{
# Univariate HDRs
c(dist_normal(), dist_kde(c(rnorm(100), rnorm(100, 3, 1)))) |>
  hdr_table(c(0.5, 0.95))
dist_kde(oldfaithful$duration) |> hdr_table(0.95)
# Bivariate HDRs
dist_kde(oldfaithful[, c("duration", "waiting")]) |> hdr_table(0.90)
}
\author{
Rob J Hyndman
}
