% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/selectGene.R
\name{SelectLRSelective}
\alias{SelectLRSelective}
\title{Linear rank selection with selective pressure.}
\usage{
SelectLRSelective(fit, lF, size = 1)
}
\arguments{
\item{fit}{Fitness vector.}

\item{lF}{Local configuration.}

\item{size}{Size of return vector (default: 1).}
}
\value{
The index vector of selected genes.
}
\description{
\code{SelectLRSelective()} implements selection
     by Whitley's linear rank selection with selective pressure 
     for the GENITOR algorithm. 
     See Whitley, Darrell (1989), p. 121.
}
\details{
The selection pressure is configured by the constant function 
         \code{lF$SelectionBias()}. Its values should be strictly larger 
         than 1 and preferably below 2. The default is set to 1.5.
         A value of 1.0 means uniform random selection.
}
\examples{
fit<-sample(10, 15, replace=TRUE)
SelectLRSelective(fit, NewlFselectGenes()) 
SelectLRSelective(fit, NewlFselectGenes(), length(fit)) 
}
\references{
Whitley, Darrell (1989):
The GENITOR Algorithm and Selection Pressure.
Why Rank-Based Allocation of Reproductive Trials is Best.
     In Schaffer, J. David (Ed.) 
     \emph{Proceedings of the Third International 
     Conference on Genetic Algorithms on Genetic Algorithms}, pp. 116-121.
     (ISBN:1-55860-066-3)
}
\seealso{
Other Selection Functions: 
\code{\link{SelectDuel}()},
\code{\link{SelectLinearRankTSR}()},
\code{\link{SelectPropFit}()},
\code{\link{SelectPropFitDiff}()},
\code{\link{SelectPropFitDiffM}()},
\code{\link{SelectPropFitDiffOnln}()},
\code{\link{SelectPropFitM}()},
\code{\link{SelectPropFitOnln}()},
\code{\link{SelectSTournament}()},
\code{\link{SelectSUS}()},
\code{\link{SelectTopK}()},
\code{\link{SelectTournament}()},
\code{\link{SelectUniform}()},
\code{\link{SelectUniformP}()}
}
\concept{Selection Functions}
