use cfg_if::cfg_if;
use std::time::Instant;









pub trait ThreadParkerT {
    type UnparkHandle: UnparkHandleT;

    const IS_CHEAP_TO_CONSTRUCT: bool;

    fn new() -> Self;

    
    unsafe fn prepare_park(&self);

    
    
    unsafe fn timed_out(&self) -> bool;

    
    
    unsafe fn park(&self);

    
    
    
    unsafe fn park_until(&self, timeout: Instant) -> bool;

    
    
    
    unsafe fn unpark_lock(&self) -> Self::UnparkHandle;
}




pub trait UnparkHandleT {
    
    
    
    
    
    unsafe fn unpark(self);
}

cfg_if! {
    if #[cfg(any(target_os = "linux", target_os = "android"))] {
        #[path = "linux.rs"]
        mod imp;
    } else if #[cfg(unix)] {
        #[path = "unix.rs"]
        mod imp;
    } else if #[cfg(windows)] {
        #[path = "windows/mod.rs"]
        mod imp;
    } else if #[cfg(target_os = "redox")] {
        #[path = "redox.rs"]
        mod imp;
    } else if #[cfg(all(target_env = "sgx", target_vendor = "fortanix"))] {
        #[path = "sgx.rs"]
        mod imp;
    } else if #[cfg(all(
        feature = "nightly",
        target_family = "wasm",
        target_feature = "atomics"
    ))] {
        #[path = "wasm_atomic.rs"]
        mod imp;
    } else if #[cfg(target_family = "wasm")] {
        #[path = "wasm.rs"]
        mod imp;
    } else {
        #[path = "generic.rs"]
        mod imp;
    }
}

pub use self::imp::{thread_yield, ThreadParker, UnparkHandle};
