% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/argos_files.R
\name{argos}
\alias{argos}
\title{Automatic Regression for Governing Equations (ARGOS)}
\usage{
argos(
  design_matrix,
  library_type = c("poly", "four", "poly_four"),
  state_var_deriv = 1,
  alpha_level = 0.05,
  num_samples = 2000,
  sr_method = c("lasso", "alasso"),
  weights_method = NULL,
  ols_ps = TRUE,
  parallel = c("no", "multicore", "snow"),
  ncpus = NULL
)
}
\arguments{
\item{design_matrix}{A list containing data frame, vector of predictor
variable orders for 'theta', and derivative matrix.}

\item{library_type}{A character vector (default: c("poly", "four",
"poly_four")) specifying the type of library being used.}

\item{state_var_deriv}{An integer. The index of the state variable for which
the derivative is calculated. Default is 1.}

\item{alpha_level}{A numeric scalar. The level of significance for
confidence intervals. Default is 0.05.}

\item{num_samples}{An integer. The number of bootstrap samples. Default is
2000.}

\item{sr_method}{A character string. The sparse regression method to be used,
either "lasso" or "alasso". Default is "lasso".}

\item{weights_method}{A string or NULL. The method for calculating weights in
the Adaptive Lasso. If NULL, ridge regression pilot
estimates are used. Default is NULL.}

\item{ols_ps}{A logical. If TRUE, post-selection OLS is performed after the
Lasso or Adaptive Lasso. Default is TRUE.}

\item{parallel}{A character string. The type of parallel computation to be
used, either "no", "multicore" or "snow". Default is "no".}

\item{ncpus}{An integer or NULL. The number of cores to be used in parallel
computation. If NULL, the function will try to detect the
number of cores. Default is NULL.}
}
\value{
A list with three elements:
  - point_estimates: a vector of point estimates for the coefficients.
  - ci: a matrix where each column represents the lower and upper bounds of
        the confidence interval for a coefficient.
  - identified_model: a matrix of coefficients of the identified model.
}
\description{
This function performs sparse regression on a data set to identify the
governing equations of the system. It takes a list of data from
`build_design_matrix` then applies the Lasso or Adaptive Lasso for variable
selection.
}
\examples{
# Identify the x1 equation of the Duffing Oscillator with ARGOS.
# Output provides point estimates, confidence intervals, and identified model.
x_t <- duffing_oscillator(n=1000, dt = 0.01,
                          init_conditions = c(1, 0),
                          gamma_value = 0.1, kappa_value = 1,
                          epsilon_value = 5, snr = 49)
duffing_design_matrix <-
       build_design_matrix(x_t, dt = 0.01, sg_poly_order = 4,
                           library_degree = 5, library_type = "poly")
design_matrix <- duffing_design_matrix
state_var_deriv = 1 # Denotes first equation/derivative to be identified
alpha_level = 0.05
num_samples = 10
sr_method = "lasso"
weights_method = NULL
ols_ps = TRUE
parallel = "no"
ncpus = NULL
library_type <- "poly"
perform_argos <- argos(design_matrix = design_matrix,
                       library_type = library_type,
                       state_var_deriv = state_var_deriv,
                       alpha_level = alpha_level,
                       num_samples = num_samples,
                       sr_method = "lasso",
                       weights_method = NULL,
                       ols_ps = TRUE,
                       parallel = "no",
                       ncpus = NULL)
perform_argos$point_estimates
perform_argos$ci
perform_argos$identified_model
}
