% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/observation_method_filters.R
\name{augmented_recording}
\alias{augmented_recording}
\title{Applies augmented interval recording to a behavior stream}
\usage{
augmented_recording(BS, interval_length, rest_length = 0)
}
\arguments{
\item{BS}{object of class behavior_stream}

\item{interval_length}{time length of each interval.}

\item{rest_length}{portion of each interval to exclude from observation. Default is zero. See details.}
}
\value{
A matrix with rows equal to the number of intervals per session and 
columns equal to the number of behavior streams in \code{BS}.
}
\description{
Divides the observation session into intervals. 
Each interval is scored using partial interval recording, whole interval recording, and  
momentary time sampling (at the beginning of the following interval).
}
\details{
Each behavior stream is divided into intervals of length \code{interval_length}. 
The last \code{rest_length} of each interval is excluded from observation. 
For example, for a stream length of 100, \code{interval_length = 20}, and 
\code{rest_length = 5}, the first interval runs from [0,15), the second interval runs from [20,35), etc.
}
\examples{
BS <- r_behavior_stream(n = 5, mu = 3, lambda = 10, 
                       F_event = F_exp(), F_interim = F_exp(), stream_length = 100)
augmented_recording(BS, interval_length = 20)
}
