% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/calculate_ps.R
\name{calculate_ps}
\alias{calculate_ps}
\title{Estimation of the Main Parameters of the Pollen Season}
\usage{
calculate_ps(data, method = "percentage", th.day = 100, perc = 95,
  def.season = "natural", reduction = FALSE, red.level = 0.9,
  derivative = 5, man = 11, th.ma = 5, n.clinical = 5,
  window.clinical = 7, window.grains = 5, th.pollen = 10,
  th.sum = 100, type = "none", interpolation = TRUE,
  int.method = "lineal", maxdays = 30, plot = FALSE,
  export.result = TRUE)
}
\arguments{
\item{data}{A \code{data.frame} object including the general database where calculation of the pollen season must be applied. This \code{data.frame} must include a first column in \code{Date} format and the rest of columns in \code{numeric} format belonging to each pollen type by column.}

\item{method}{A \code{character} string specifying the method applied to calculate the pollen season and the main parameters. The implemented methods that can be used are: \code{"percentage"}, \code{"logistic"}, \code{"moving"}, \code{"clinical"} or \code{"grains"}. A more detailed information about the different methods for defining the pollen season may be consulted in \strong{Details}.}

\item{th.day}{A \code{numeric} value. The number of days whose pollen concentration is bigger than this threshold is calculated for each year and pollen type. This value will be obtained in the results of the function. The \code{th.day} argument will be \code{100} by default.}

\item{perc}{A \code{numeric} value ranging \code{0_100}. This argument is valid only for \code{method = "percentage"}. This value represents the percentage of the total annual pollen included in the pollen season, removing \code{(100_perc)/2\%} of the total pollen before and after of the pollen season. The \code{perc} argument will be \code{95} by default.}

\item{def.season}{A \code{character} string specifying the method for selecting the best annual period to calculate the pollen season. The pollen seasons may occur within the natural year between two years. The implemented options that can be used are: \code{"natural"}, \code{"interannual"} or \code{"peak"}. The \code{def.season} argument will be \code{"natural"} by default. A more detailed information about the different methods for selecting the best annual period to calculate the pollen season may be consulted in \strong{Details}.}

\item{reduction}{A \code{logical} value. This argument is valid only for the \code{"logistic"} method. If \code{FALSE} the reduction of the pollen data is not applicable. If \code{TRUE} a reduction of the peaks above a certain level (\code{red.level} argument) will be carried out before the definition of the pollen season. The \code{reduction} argument will be \code{FALSE} by default. A more detailed information about the reduction process may be consulted in \strong{Details}.}

\item{red.level}{A \code{numeric} value ranging \code{0_1} specifying the percentile used as level to reduce the peaks of the pollen series before the definition of the pollen season. This argument is valid only for the \code{"logistic"} method. The \code{red.level} argument will be \code{0.90} by default, specifying the percentile 90.}

\item{derivative}{A \code{numeric} (\code{integer}) value belonging to options of \code{4}, \code{5} or \code{6} specifying the derivative that will be applied to calculate the asymptotes which determines the pollen season using the \code{"logistic"} method. This argument is valid only for the \code{"logistic"} method. The \code{derivative} argument will be \code{5} by default. More information may be consulted in \strong{Details}.}

\item{man}{A \code{numeric} (\code{integer}) value specifying the order of the moving average applied to calculate the pollen season using the \code{"moving"} method. This argument is valid only for the \code{"moving"} method. The \code{man} argument will be \code{11} by default.}

\item{th.ma}{A \code{numeric} value specifying the threshold used for the \code{"moving"} method for defining the beginning and the end of the pollen season. This argument is valid only for the \code{"moving"} method. The \code{th.ma} argument will be \code{5} by default.}

\item{n.clinical}{A \code{numeric} (\code{integer}) value specifying the number of days which must exceed a given threshold (\code{th.pollen} argument) for defining the beginning and the end of the pollen season. This argument is valid only for the \code{"clinical"} method. The \code{n.clinical} argument will be \code{5} by default.}

\item{window.clinical}{A \code{numeric} (\code{integer}) value specifying the time window during which the conditions must be evaluated for defining the beginning and the end of the pollen season using the \code{"clinical"} method. This argument is valid only for the \code{"clinical"} method. The \code{window.clinical} argument will be \code{7} by default.}

\item{window.grains}{A \code{numeric} (\code{integer}) value specifying the time window during which the conditions must be evaluated for defining the beginning and the end of the pollen season using the \code{"grains"} method. This argument is valid only for the \code{"grains"} method. The \code{window.grains} argument will be \code{5} by default.}

\item{th.pollen}{A \code{numeric} value specifying the threshold that must be exceeded during a given number of days (\code{n.clinical} or \code{window.grains} arguments) for defining the beginning and the end of the pollen season using the \code{"clinical"} or \code{"grains"} methods. This argument is valid only for the \code{"clinical"} or \code{"grains"} methods. The \code{th.pollen} argument will be \code{10} by default.}

\item{th.sum}{A \code{numeric} value specifying the pollen threshold that must be exceeded by the sum of daily pollen during a given number of days (\code{n.clinical} argument) exceeding a given daily threshold (\code{th.pollen} argument) for defining the beginning and the end of the pollen season using the \code{"clinical"} method. This argument is valid only for the \code{"clinical"} method. The \code{th.sum} argument will be \code{100} by default.}

\item{type}{A \code{character} string specifying the parameters considered according to a specific pollen type for calculating the pollen season using the \code{"clinical"} method. The implemented pollen types that may be used are: \code{"birch"}, \code{"grasses"}, \code{"cypress"}, \code{"olive"} or \code{"ragweed"}. As result for selecting any of these pollen types the parameters \code{n.clinical}, \code{window.clinical}, \code{th.pollen} and \code{th.sum} will be automatically adjusted for the \code{"clinical"} method. If no pollen types are specified (\code{type = "none"}), these parameters will be considered by the user. This argument is valid only for the \code{"clinical"} method. The \code{type} argument will be \code{"none"} by default.}

\item{interpolation}{A \code{logical} value. If \code{FALSE} the interpolation of the pollen data is not applicable. If \code{TRUE} an interpolation of the pollen series will be applied to complete the gaps with no data before the calculation of the pollen season. The \code{interpolation} argument will be \code{TRUE} by default. A more detailed information about the interpolation method may be consulted in \strong{Details}.}

\item{int.method}{A \code{character} string specifying the method selected to apply the interpolation method in order to complete the pollen series. The implemented methods that may be used are: \code{"lineal"}, \code{"movingmean"}, \code{"spline"} or \code{"tseries"}. The \code{int.method} argument will be \code{"lineal"} by default.}

\item{maxdays}{A \code{numeric} (\code{integer} value) specifying the maximum number of consecutive days with missing data that the algorithm is going to interpolate. If the gap is bigger than the argument value, the gap will not be interpolated. Not valid with \code{int.method = "tseries"}. The \code{maxdays} argument will be \code{30} by default.}

\item{plot}{A \code{logical} value specifying if a set of plots based on the definition of the pollen season and saved in the working directory will be required or not. If \code{FALSE} graphical results will not be saved. If \code{TRUE} a \emph{pdf} file for each pollen type showing graphically the definition of the pollen season for each studied year will be saved within the \emph{plot_AeRobiology} directory created in the working directory. The \code{plot} argument will be \code{FALSE} by default.}

\item{export.result}{A \code{logical} value specifying if a excel file including all parameters for the definition of the pollen season saved in the working directoty will be required or not. If \code{FALSE} the results will not exported. If \code{TRUE} the results will be exported as \emph{xlsx} file including all parameters calculated from the definition of the pollen season within the \emph{table_AeRobiology} directory created in the working directory. The \code{export.result} argument will be \code{TRUE} by default.}
}
\value{
This function returns different results:\cr
\code{data.frame} including the main parameters of the pollen season with regard to phenology and pollen intensity as:
\itemize{
   \item \strong{type}: pollen type
   \item \strong{seasons}: year of the beginning of the season
   \item \strong{st.dt}: start_date (date)
   \item \strong{st.jd}: start_date (day of the year)
   \item \strong{en.dt}: end_date (date)
   \item \strong{en.jd}: end_date (day of the year)
   \item \strong{ln.ps}: length of the season
   \item \strong{sm.tt}: total sum
   \item \strong{sm.ps}: pollen integral
   \item \strong{pk.val}: peak value
   \item \strong{pk.dt}: peak_date (date)
   \item \strong{pk.jd}: peak_date (day of year)
   \item \strong{ln.prpk}: length of the pre_peak period
   \item \strong{sm.prpk}: pollen integral of the pre_peak period
   \item \strong{ln.pspk}: length of the post_peak period
   \item \strong{sm.pspk}: pollen integral of the post_peak period
   \item \strong{daysth}: number of days with more than 100 pollen grains
   \item \strong{st.dt.hs}: start_date of the High pollen season (date, only for clinical method)
   \item \strong{st.jd.hs}: start_date of the High pollen season (day of the year, only for clinical method)
   \item \strong{en.dt.hs}: end_date of the High pollen season (date, only for clinical method)
   \item \strong{en.jd.hs}: end_date of the High pollen season (day of the year, only for clinical method)
}
If \code{export.result = TRUE} this \code{data.frame} will also be exported as \emph{xlsx} file within the \emph{table_AeRobiology} directory created in the working directory. If \code{export.result = FALSE} the results will also be showed as list object named \code{list.ps}. \cr
If \code{plot = TRUE} a \emph{pdf} file for each pollen type showing graphically the definition of the pollen season for each studied year will be saved within the \emph{plot_AeRobiology} directory created in the working directory.
}
\description{
Function to calculate the main parameters of the pollen season with regard to phenology and pollen intensity from a historical database of several pollen types. The function can use the most common methods in the definition of the pollen season.
}
\details{
This function allows to calculate the pollen season using five different methods which are described below. After calculating the start_date, end_date and peak_date for the pollen season all rest of parameters have been calculated as detailed in \strong{Value} section.
\itemize{
  \item \code{"percentage"} method. This is a commonly used method for defining the pollen season based on the elimination of a certain percentage in the beginning and the end of the pollen season \emph{(Nilsson and Persson, 1981; Andersen, 1991)}. For example if the pollen season is based on the 95\% of the total annual pollen (\code{"perc" = 95}), the start_date of the pollen season is marked as the day in which 2.5\% of the total pollen is registered and the end_date of the pollen season is marked as the day in which 97.5\% of the total pollen is registered.
  \item \code{"logistic"} method. This method was developed by \emph{Ribeiro et al. (2007)} and modified by \emph{Cunha et al. (2015)}. It is based on fitting annually a non_linear logistic regression model to the daily accumulated curve for each pollen type. This logistic function and the different derivatives were considered to calculate the start_date and end_date of the pollen season, based on the asymptotes when pollen amounts are stabilized on the beginning and the end of the accumulated curve. For more information about the method to see \emph{Ribeiro et al. (2007)} and \emph{Cunha et al. (2015)}. Three different derivatives may be used (\code{derivative} argument) \code{4}, \code{5} or \code{6} that represent from higher to lower restrictive criterion for defining the pollen season. This method may be complemented with an optional method for reduction the peaks values (\code{reduction = TRUE}), thus avoiding the effect of the great influence of extreme peaks. In this sense, peaks values will be cut below a certain level that the user may select based on a percentile analysis of peaks. For example, \code{red.level = 0.90} will cut all peaks above the percentile \code{90}.
  \item \code{"moving"} method. This method is proposed the first time by the authors of this package. The definition of the pollen season is based on the application of a moving average to the pollen series in order to obtain the general seasonality of the pollen curve avoiding the great variability of the daily fluctuations. Thus, the start_date and the end_date will be established when the curve of the moving average reaches a given pollen threshold (\code{th.ma} argument). Also the order of the moving average may be customized by the user (\code{man} argument).
  \item \code{"clinical"} method. This method was proposed by \emph{Pfaar et al. (2017)}. It is based on the expert consensus in relation to pollen exposure and the relationship with allergic symptoms derived of the literature. Different periods may be defined by this method: the pollen season, the high pollen season and the high pollen days. The start_date and end_date of the pollen season were defined as a certain number of days (\code{n.clinical} argument) within a time window period (\code{window.clinical} argument) exceeding a certain pollen threshold (\code{th.pollen} argument) which summation is above a certain pollen sum (\code{th.sum} argument). All these parameters are established for each pollen type according to \emph{Pfaar et al. (2017)} and using the \code{type} argument these parameters may be automatically adjusted for the specific pollen types (\code{"birch"}, \code{"grasses"}, \code{"cypress"}, \code{"olive"} or \code{"ragweed"}). Furthermore, the user may change all parameters to do a customized definition of the pollen season. The start_date and end_date of the high pollen season were defined as three consecutive days exceeding a certain pollen threshold (\code{th.day} argument). The number of high pollen days will also be calculated exceeding this pollen threshold (\code{th.day}). For more information about the method to see \emph{Pfaar et al. (2017)}.
\item \code{"grains"} method. This method was proposed by \emph{Galan et al. (2001)} originally in olive pollen but after also applied in other pollen types. The start_date and end_date of the pollen season were defined as a certain number of days (\code{window.grains} argument) exceeding a certain pollen threshold (\code{th.pollen} argument). For more information about the method to see \emph{Galan et al. (2001)}.
}
The pollen season of the species may occur during the natural year or the start_date and the end_date of the pollen season may happen in two different natural years. This consideration has been taken into account and in this package different method for defining the period for calculating the pollen season have been implemented. In this sense, the \code{def.season} argument has been incorporated in three options:
\itemize{
\item \code{"natural"}: considering the pollination year as natural year from 1st January to 31th December for defining the start_dates and end_dates of the pollen season for each pollen types.
\item \code{"interannual"}: considering the pollination year from 1st June to 31th May for defining the start_dates and end_dates of the pollen season for each pollen types.
\item \code{"peak"}: considering a customized pollination year for each pollen types calculated as 6 previous months and 6 later months from the average peak_date.
}
Pollen time series frequently have different gaps with no data and this fact could be a problem for the calculation of specific methods for defining the pollen season even providing incorrect results. In this sense by default a linear interpolation will be carried out to complete these gaps before to define the pollen season (\code{interpolation = TRUE}). Additionally, the users may select other interpolation methods using the \code{int.method} argument, as \code{"lineal"}, \code{"movingmean"}, \code{"spline"} or \code{"tseries"}. For more information to see the \code{\link{interpollen}} function.
}
\examples{
data("munich")
calculate_ps(munich, plot = FALSE, export.result = FALSE)
}
\references{
Andersen, T.B., 1991. A model to predict the beginning of the pollen season. \emph{Grana}, 30(1), pp.269_275.

Cunha, M., Ribeiro, H., Costa, P. and Abreu, I., 2015. A comparative study of vineyard phenology and pollen metrics extracted from airborne pollen time series. \emph{Aerobiologia}, 31(1), pp.45_56.

Galan, C., Garcia_Mozo, H., Carinanos, P., Alcazar, P. and Dominguez_Vilches, E., 2001. The role of temperature in the onset of the \emph{Olea europaea} L. pollen season in southwestern Spain. \emph{International Journal of Biometeorology}, 45(1), pp.8_12.

Nilsson, S. and Persson, S., 1981. Tree pollen spectra in the Stockholm region (Sweden), 1973_1980. \emph{Grana}, 20(3), pp.179_182.

Pfaar, O., Bastl, K., Berger, U., Buters, J., Calderon, M.A., Clot, B., Darsow, U., Demoly, P., Durham, S.R., Galan, C., Gehrig, R., Gerth van Wijk, R., Jacobsen, L., Klimek, L., Sofiev, M., Thibaudon, M. and Bergmann, K.C., 2017. Defining pollen exposure times for clinical trials of allergen immunotherapy for pollen_induced rhinoconjunctivitis_an EAACI position paper. \emph{Allergy}, 72(5), pp.713_722.

Ribeiro, H., Cunha, M. and Abreu, I., 2007. Definition of main pollen season using logistic model. \emph{Annals of Agricultural and Environmental Medicine}, 14(2), pp.259_264.
}
\seealso{
\code{\link{interpollen}}, \code{\link{ps_plot}}
}
